<?php
 /**
   * The template for Blog.
   * Template Name: Blog
   *
   * @package   fcast WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * fcast is distributed under the terms of the GNU GPL
*/
$sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}
$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}

if ((get_theme_mod('fcast_header_layout_other')) === 'header' ) :
    get_header();
elseif ((get_theme_mod('fcast_header_layout_other')) === 'header-main' ) :
    get_header('main');
else :
    get_header('main');
endif;
?>
<div id="main" class="site-main">
    <div id="blog-sidebar" class="site-content">

        <div class="row">

            <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                <?php  dynamic_sidebar('sidebar_left'); ?>
                </article>
            </div>
            <?php endif; ?>

            <?php if($sidebar_right && $sidebar_left) :
                echo ('<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">');
                echo ('<div class="blog">');
            elseif($sidebar_right || $sidebar_left) :
                echo ('<div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">');
                echo ('<div class="blog">');
            else :
                echo ('<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">');
                echo ('<div class="blog container">');
            endif; ?>
                    <?php the_title( '<h2 class="page-title">', '</h2>' ); ?>
                        <?php  $published_posts = wp_count_posts()->publish;
                            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                            query_posts( array(
                                'paged'=>$paged,
                                'posts_per_page'=>$posts_per_page
                            ) );
                            $position = 0;
                            if( have_posts() ){
                                while( have_posts() ){ the_post();
                                $position++ ?>
                                <div class="<?php if ($position != 0 && $position%2==0) echo 'right-post'; else echo 'left-post'; ?>">
                              <?php  get_template_part( 'content', $format = get_post_format() ); ?>
                              </div>
                            <?php } ?>
                            <?php  wp_reset_query();
                           } else {
                            get_template_part( 'content', 'none' );
                            } ?>
                    </div>
                </div>

            <?php if (is_active_sidebar( 'sidebar_right' ) ) : ?>
            <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                <article id="sidebar">
                <?php dynamic_sidebar('sidebar_right'); ?>
                </article>
            </div>
            <?php endif; ?>

        </div><!--row end-->
        <div class="pagination">
            <?php  fcast_pagenavi($published_posts,$posts_per_page); ?>
        </div>

    </div>
</div><!-- #main -->
<?php get_footer(); ?>