 <?php
/**
   * The template for Content Gallery.
   *
   *
   * @package   fcast WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * fcast is distributed under the terms of the GNU GPL
*/
?>
<?php if ( is_single() ) : ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php else : ?>
    <div id="post" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
<?php endif; ?>

    <article class="content-gallery">
        <header class="entry-header">
            <?php if ( is_single() ) : ?>
                <h1 class="entry-title"><?php the_title(); ?></h1>
            <?php else : ?>
                <a href="<?php the_permalink(); ?>" rel="bookmark">
                    <h2 class="entry-title">
                        <?php the_title(); ?>
                    </h2>
                </a>
            <?php endif; // is_single() ?>
        </header><!-- .entry-header -->

        <div class="entry-content">
            <?php if ( is_single() || ! get_post_gallery() ) : ?>
                <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'fcast' ) ); ?>
                <?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'fcast' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
            <?php else : ?>
                <?php echo get_post_gallery(); ?>
            <?php endif; // is_single() ?>
        </div><!-- .entry-content -->

        <footer class="entry-meta">
            <?php if ( is_single() ) :
                fcast_entry_meta(); ?>
               <?php fcast_entry_date(); ?>
                <?php edit_post_link( __( 'Edit', 'fcast' ), '<span class="edit-link"><i class="fa fa-edit"></i>', '</span>' );
            else : ?>

            <?php endif;

            if ( is_single() && comments_open() ) : ?>
                <span class="comments-link">
                <i class="fa fa-commenting-o"></i>
                    <?php comments_popup_link( '<span class="leave-reply">' . __( 'Leave a comment', 'fcast' ) . '</span>', __( 'One comment so far', 'fcast' ), __( 'View all % comments', 'fcast' ) ); ?>
                </span><!-- .comments-link -->
            <?php endif; // comments_open() ?>

            <?php if ( is_single() && get_the_author_meta( 'description' ) && is_multi_author() ) : ?>
                <?php get_template_part( 'author-bio' ); ?>
            <?php endif; ?>
        </footer><!-- .entry-meta -->
    </article><!-- #post -->
</div>