<?php
 /**
   * The Customize  Page.
   *
   *
   * @package   fcast WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license  www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author    AUTHOR <www.ordasoft.com>
   * fcast is distributed under the terms of the GNU GPL
   */



function fcast_customize_register( $wp_customize ) {

//*************************************Customize Control*********************************************************
        class WP_Slider_Customize_Control extends WP_Customize_Control {
        public $type = 'range';

          public function render_content() {
          ?>

        <label>
                    <?php if ( ! empty( $this->label ) ) : ?>
                        <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                    <?php endif;
                    if ( ! empty( $this->description ) ) : ?>
                        <span class="description customize-control-description"><?php echo $this->description; ?></span>
                    <?php endif; ?>
                    <form onsubmit="return false" oninput="level.value = flevel.valueAsNumber">
                      <input name="flevel" id="slider-range" type="range" min="0" max="100" step="1" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); checked( $this->value() ); ?> />
                      <output for="slider-range" name="level"><?php echo esc_attr( $this->value() ); ?></output>px
                    </form>
                </label>

          <?php
          }
    };

//************************************************Remove Standart Section****************************************

    $wp_customize->remove_section('colors');
    $wp_customize->remove_section('title_tagline');
    $wp_customize->remove_section('background_image');

//*************************************************General*******************************************************

    $wp_customize->add_section( 'fcast_general_settings' , array(
        'title'      => __( 'General Settings','fcast' ),
        'priority'   => 1,
        'capability'     => 'edit_theme_options',
        'description' => __('General settings for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
    ) );

//-----------------------------------Site Title------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'blogname',array(
                'label' => __('Yor site title','fcast'),
                'section'=> 'fcast_general_settings',
                'priority' => 1
                )
        ) );

//-----------------------------------Site Tagline------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize, 'blogdescription', array(
                'label' => __('Yor site tagline','fcast'),
                'section' => 'fcast_general_settings',
                'priority' => 2
                )
        ) );

//-----------------------------------Site icon------------------------------------------

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,'site_icon',array(
                'label' => __('Yor site icon','fcast'),
                'section' => 'fcast_general_settings',
                'priority'=>3
                )
        ) );

//-----------------------------------Background Colour------------------------------------------

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'background_color',array(
                'label' => __('Background Color','fcast'),
                'section' => 'fcast_general_settings',
                'priority'=>10
                )
        ) );

//-----------------------------------Background image------------------------------------------

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,'background_image',array(
                'label' => __('Background image','fcast'),
                'section' => 'fcast_general_settings',
                'priority'=>11
                )
        ) );

//-----------------------------------Background repeat------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_repeat',array(
                'label' => __('Background repeat','fcast'),
                'section' => 'fcast_general_settings',
                 'type' => 'radio',
                    'priority' => 12,
                    'choices' => array(
                        'no-repeat' => 'No Repeat',
                        'repeat' => 'Tile',
                        'repeat-x' => 'Tile Horizontally',
                        'repeat-y' => 'Tile Vertically',
                ))
        ) );

//-----------------------------------Background position------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_position_x',array(
                'label' => __('Background position','fcast'),
                'section' => 'fcast_general_settings',
                 'type' => 'radio',
                    'priority' => 13,
                    'choices' => array(
                        'left' => 'Left',
                        'center' => 'Center',
                        'right' => 'Right',
                ))
        ) );

//-----------------------------------Background attachment------------------------------------------

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'background_attachment',array(
                'label'=>__('Background attachment','fcast'),
                'section'=>'fcast_general_settings',
                 'type'=>'radio',
                    'priority'=>14,
                    'choices'=>array(
                        'scroll'=>'Scroll',
                        'fixed'=>'Fixed',
                ))
        ) );

//-----------------------------------Colour Theme------------------------------------------

        $wp_customize->add_setting( 'fcast_theme_color', array(
            'default'=>'#faa54b',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
               $wp_customize, 'theme_color',array(
                     'label' => __('Theme Color','fcast'),
                     'section' => 'fcast_general_settings',
                     'settings' => 'fcast_theme_color',
                     'priority'=>20
                     )
             ) );

//---------------------------------Body font-------------------------------------------------

        $wp_customize->add_setting( 'fcast_body_font' , array(
            'default' => 'Indie Flower',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize, 'body_font',array(
                    'label' => __( 'Body Font','fcast' ),
                    'settings' => 'fcast_body_font',
                    'priority' => 30,
                    'section' =>'fcast_general_settings',
                    'type'=>'select',
                    'choices'=>array(
                        "Abel,sans-serif"=>"Abel",
                        "Arial,sans-serif"=>"Arial",
                        "Cuprum"=>"Cuprum",
                        "Comfortaa"=>"Comfortaa",
                        "Dancing Script,cursive"=>"Dancing Script",
                        "Dosis,sans-serif"=>"Dosis",
                        "Droid Sans,sans-serif"=>"Droid Sans",
                        "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                        "Francois One,sans-serif"=>"Francois One",
                        "Georgia,serif"=>"Georgia",
                        "Helvetica,sans-serif"=>"Helvetica",
                        "Josefin Sans,sans-serif"=>"Josefin Sans",
                        "Lato,sans-serif"=>"Lato",
                        "Lobster,sans-serif"=>"Lobster",
                        "Lora,sans-serif"=>"Lora",
                        "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                        "Open Sans,sans-serif"=>"Open Sans",
                        "Oswald,sans-serif"=>"Oswald",
                        "Oxygen,sans-serif"=>"Oxygen",
                        "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                        "Philosopher"=>"Philosopher",
                        "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                        "PT Sans"=>"PT Sans",
                        "Prosto One,cursive"=>"Prosto One",
                        "Quicksand,sans-serif"=>"Quicksand",
                        "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                        "Roboto,sans-serif"=>"Roboto",
                        "Share,cursive"=>"Share",
                        "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                        "Merriweather,sans-serif"=>"Merriweather",
                        "Times New Roman,sans-serif"=>"Times New Roman",
                        "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                        "Ubuntu,sans-serif"=>"Ubuntu",
                        "Verdana,sans-serif"=>"Verdana"))
                )
            );

//---------------------------------------Body Font Size-----------------------------------------------

        $wp_customize->add_setting( 'fcast_font_size' , array(
            'default'     => '16',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize, 'font_size',array(
                 'label' => __('Body font size','fcast'),
                 'section' => 'fcast_general_settings',
                 'settings'=> 'fcast_font_size',
                 'priority'=>31
                 )
         ) );

//------------------------------------Body font color-------------------------------------------------

        $wp_customize->add_setting('fcast_font_color',array(
            'default'=>'#0a0a0a',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize, 'font_color',array(
                'label'=>__('Body font color','fcast'),
                'section'=>'fcast_general_settings',
                'settings'=>'fcast_font_color',
                'priority'=>32
             )
         ) );


//------------------------------------Read more button text-------------------------------------------------

        $wp_customize->add_setting('fcast_more_button',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'more_button',array(
                'label'=>__('Replace text in button "Read Now"','fcast'),
                'settings' => 'fcast_more_button',
                'section' => 'fcast_general_settings',
                'priority' => 41,
            )
        ) );
//--------------------------------------Favicon-------------------------------------------------------------

        $wp_customize->add_setting('fcast_favicon_img',array(
            'default'=>'',
            'sanitize_callback' => 'esc_url_raw',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize, 'favicon_img',array(
                    'label'=>__('A favicon is a 16x16 pixel icon that represents your site, to a .ico image that you want to use as the image','fcast'),
                    'settings'=> 'fcast_favicon_img',
                    'section'=> 'fcast_general_settings',
                    'priority'=>50
                )
          ) );

//------------------------------------------Custom CSS----------------------------------------------

        $wp_customize->add_setting('fcast_custom_css',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'custom_css',array(
                'label' => __('Want to add any custom CSS code? Put in here, and the rest is taken care of. This overrides any other stylesheets. eg: a.button{color:green}','fcast'),
                'settings' => 'fcast_custom_css',
                'section' => 'fcast_general_settings',
                'type' => 'textarea',
                'priority' => 60,
            )
        ) );

//------------------------------------Googleanalytics-------------------------------------------------

        $wp_customize->add_setting('fcast_add_googleanalytics',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'add_googleanalytics',array(
                'label'=>__('You can paste your Google Analytics or other tracking code in this box. This will be automatically added to the footer.','fcast'),
                'settings' => 'fcast_add_googleanalytics',
                'section' => 'fcast_general_settings',
                'type' => 'textarea',
                'priority' => 70,
            )
        ) );

//*************************************************Header*******************************************************

     $wp_customize->add_panel( 'fcast_header' , array(
        'title'      => __( 'Header','fcast' ),
        'priority'   => 20,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
         'description' => __('Header settings for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
    ) );

        $wp_customize->add_section( 'fcast_header_settings' , array(
            'title'      => __( 'Header Settings','fcast' ),
            'priority'   => 1,
            'panel' => 'fcast_header',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Header settings for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
        ) );

        $wp_customize->add_section( 'header_image' , array(
            'title'      => __( 'Header Image','fcast' ),
            'priority'   => 2,
            'panel' => 'fcast_header',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Header Image for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
        ) );

//------------------------------------------------Header Layout------------------------------------

        $wp_customize->add_setting( 'fcast_header_layout_home',array(
            'default'=>'header',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage', ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'header_layout_home',array(
                'label'=>__('Header layout for Home page','fcast'),
                'settings'=>'fcast_header_layout_home',
                'section'=>'fcast_header_settings',
                'type'=>'radio',
                'priority'=>10,
                'choices'=>array(
                    'header'=>'Full Header',
                    'header-main'=>'250px height Header',
                )
            )
        ) );

        $wp_customize->add_setting( 'fcast_header_layout_other',array(
            'default'=>'main',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'header_layout_other',array(
                'label'=>__('Header layout for Other page','fcast'),
                'settings'=>'fcast_header_layout_other',
                'section'=>'fcast_header_settings',
                'type'=>'radio',
                'priority'=>11,
                'choices'=>array(
                    'header'=>'Full Header',
                    'main'=>'250px height Header',
                )
            )
        ) );

//------------------------------------------------Logo------------------------------------

        $wp_customize->add_setting( 'fcast_logo_img',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Image_Control(
                $wp_customize,'logo_img',array(
                    'label'=>__('Upload logo for your site','fcast'),
                    'settings'=>'fcast_logo_img',
                    'section'=>'fcast_header_settings',
                    'priority'=>20 )
          ) );

//-----------------------------------------Logo Link-------------------------------------

        $wp_customize->add_setting( 'fcast_logo_link',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
                'transport'=>'postMessage',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'logo_link',array(
                'label'=>__('Insert your logo link','fcast'),
                'settings'=>'fcast_logo_link',
                'section'=>'fcast_header_settings',
                'priority'=>30 )
          ) );


//***********************************HOME PAGE SETTINGS**********************************************

    $wp_customize->add_section( 'fcast_home_settings',array(
        'title'=>__('Home page settings','fcast'),
        'priority'=>21,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'description' => __('Home page settings <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
      ) );

//----------------------------Home page width-------------------------

        $wp_customize->add_setting( 'fcast_home_width' , array(
            'default'     => 'full',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'home_width',array(
                'label'=>__('Home page width full or fixed (1170px)','fcast'),
                'settings'=> 'fcast_home_width',
                'section'=> 'fcast_home_settings',
                'type'=>'radio',
                'priority'=>1,
                'choices'=>array(
                    'full'=>'full',
                    'container'=>'fixed (1170px)'
                ))
        ) );

//----------------------------Home section blog-------------------------------------------------------------------------------

//----------------------------Home blog title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'fcast_home_blog_title' , array(
            'default'     => __('Your personal Blog', 'fcast'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'home_blog_title',array(
                'label'=>__('Home page blog title','fcast'),
                'settings'=> 'fcast_home_blog_title',
                'section'=> 'fcast_home_settings',
                'priority'=>20,
               )
        ) );

//----------------------------Home section shop-------------------------------------------------------------------------------
//----------------------------Home shop section show-------------------------

        $wp_customize->add_setting( 'fcast_shop_show' , array(
            'default'     => 'display:none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'shop_show',array(
                'label'=>__('Shop section on home page show or hide','fcast'),
                'settings'=> 'fcast_shop_show',
                'section'=> 'fcast_home_settings',
                'type'=>'radio',
                'priority'=>30,
                'choices'=>array(
                        'display:block'=>'show',
                        'display:none'=>'hide'))
        ) );

//----------------------------Home shop title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'fcast_home_shop_title' , array(
            'default'     => __('Last Products', 'fcast'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'home_shop_title',array(
                'label' => __('Home page shop section title','fcast'),
                'settings' => 'fcast_home_shop_title',
                'section' => 'fcast_home_settings',
                'priority' => 31,
               )
        ) );


//----------------------------Home shop section show products-------------------------

        $wp_customize->add_setting( 'fcast_products_show' , array(
            'default'     => '12',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'products_show',array(
                'label'=>__('Shop section show products','fcast'),
                'settings'=> 'fcast_products_show',
                'section'=> 'fcast_home_settings',
                'priority'=>33,
               )
        ) );

//----------------------------Home shop section products column-------------------------

        $wp_customize->add_setting( 'fcast_products_column' , array(
            'default'     => 'col-lg-6 col-md-4 col-sm-4',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'products_column',array(
                'label'=>__('Products column','fcast'),
                'settings'=> 'fcast_products_column',
                'section'=> 'fcast_home_settings',
                'type'=>'select',
                'priority'=>34,
                'choices'=>array(
                    'col-lg-6 col-md-4 col-sm-4'=>'2',
                    'col-lg-4 col-md-4 col-sm-4'=>'3',
                    'col-lg-3 col-md-3 col-sm-3'=>'4',
                    'col-lg-2 col-md-2 col-sm-4'=>'6',
                ))
        ) );
//----------------------------Home content section show-------------------------

        $wp_customize->add_setting( 'fcast_content_show' , array(
            'default'     => 'display:none',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'content_show',array(
                'label'=>__('Content section on home page show or hide','fcast'),
                'settings'=> 'fcast_content_show',
                'section'=> 'fcast_home_settings',
                'type'=>'radio',
                'priority'=>35,
                'choices'=>array(
                        'display:block'=>'show',
                        'display:none'=>'hide'))
        ) );
//----------------------------Home any section show-------------------------

        $wp_customize->add_setting( 'fcast_any_section_show' , array(
            'default'     => 'display:none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_section_show',array(
                'label'=>__('Any section on home page show or hide','fcast'),
                'settings'=> 'fcast_any_section_show',
                'section'=> 'fcast_home_settings',
                'type'=>'radio',
                'priority'=>40,
                'choices'=>array(
                        'display:block'=>'show',
                        'display:none'=>'hide'))
        ) );

//----------------------------Home any title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'fcast_any_section_title' , array(
            'default'     => __('Testimonial', 'fcast'),
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_section_title',array(
                'label'=>__('Home page any section title','fcast'),
                'settings'=> 'fcast_any_section_title',
                'section'=> 'fcast_home_settings',
                'priority'=>41,
               )
        ) );

//----------------------------Home any title-------------------------------------------------------------------------------

        $wp_customize->add_setting( 'fcast_any_shortcode' , array(
            'default'     => '[testimonial_sc  id="213" ]',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'any_shortcode',array(
                'label'=>__('Home page any section insert shortcode','fcast'),
                'settings'=> 'fcast_any_shortcode',
                'section'=> 'fcast_home_settings',
                'priority'=>43,
               )
        ) );

//***********************************Social icons**********************************************

    $wp_customize->add_section( 'fcast_social_settings',array(
        'title'=>__('Social Icons','fcast'),
        'priority'=>30,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
         'description' => __('Sociasl Icons for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
      ) );

//----------------------------Social Icons Font Size-------------------------

        $wp_customize->add_setting( 'fcast_soc_size' , array(
            'default'     => '20',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
             $wp_customize,'fcast_soc_size',array(
                   'label'=>__('Social icon size','fcast'),
                   'section'=> 'fcast_social_settings',
                   'settings'=> 'fcast_soc_size',
                   'priority'=>1
                   )
           ) );

//------------------------Socil Icons Color------------------------------------

        $wp_customize->add_setting( 'fcast_soc_color',array(
            'default'=>'#faa54b',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'soc_color',array(
                'label'=>__('Social Icons Color','fcast'),
                'settings'=> 'fcast_soc_color',
                'section'=> 'fcast_social_settings',
                'priority'=>2
            )
      ) );

//-----------------------Social Icons Color Hover------------------------------

        $wp_customize->add_setting( 'fcast_soc_color_hover',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'soc_color_hover',array(
                'label'=>__('Social Icons Color Hover','fcast'),
                'settings'=> 'fcast_soc_color_hover',
                'section'=> 'fcast_social_settings',
                'priority'=>3
            )
      ) );

//------------------Facebook-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_facebook',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_facebook',array(
                'label'=>__('Facebook','fcast'),
                'settings'=> 'fcast_soc_facebook',
                'section'=> 'fcast_social_settings',
                'priority'=>4
            )
      ) );

//------------------Twitter-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_twitter',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_twitter',array(
                'label'=>__('Twitter','fcast'),
                'settings'=> 'fcast_soc_twitter',
                'section'=> 'fcast_social_settings',
                'priority'=>5
            )
      ) );

//------------------Skype-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_skype',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_skype',array(
                'label'=>__('Skype','fcast'),
                'settings'=> 'fcast_soc_skype',
                'section'=> 'fcast_social_settings',
                'priority'=>6
            )
      ) );

//------------------Soundcloud-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_soundcloud',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_soundcloud',array(
                    'label'=>__('Soundcloud','fcast'),
                    'settings'=> 'fcast_soc_soundcloud',
                    'section'=> 'fcast_social_settings',
                    'priority'=>7
                )
          ) );

//------------------Dribbble-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_dribbble',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_dribbble',array(
                'label'=>__('Dribbble','fcast'),
                'settings'=> 'fcast_soc_dribbble',
                'section'=> 'fcast_social_settings',
                'priority'=>8
            )
      ) );

//-----------------Google-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_google',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_google',array(
                'label'=>__('Google','fcast'),
                'settings'=> 'fcast_soc_google',
                'section'=> 'fcast_social_settings',
                'priority'=>9
            )
      ) );

//-----------------Vimeo-----------------------------------------

        $wp_customize->add_setting('fcast_soc_vimeo',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_vimeo',array(
                    'label'=>__('Vimeo','fcast'),
                    'settings'=> 'fcast_soc_vimeo',
                    'section'=> 'fcast_social_settings',
                    'priority'=>10
                )
          ) );

//-----------------Flickr-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_flickr',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_flickr',array(
                'label'=>__('Flickr','fcast'),
                'settings'=> 'fcast_soc_flickr',
                'section'=> 'fcast_social_settings',
                'priority'=>11
            )
      ) );

//-----------------Youtube Play-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_youtube_play',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_youtube_play',array(
                    'label'=>__('Youtube','fcast'),
                    'settings'=> 'fcast_soc_youtube_play',
                    'section'=> 'fcast_social_settings',
                    'priority'=>12
                )
          ) );

//-----------------Instagram-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_instagram',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
               $wp_customize,'soc_instagram',array(
                    'label'=>__('Instagram','fcast'),
                    'settings'=> 'fcast_soc_instagram',
                    'section'=> 'fcast_social_settings',
                    'priority'=>13
                )
          ) );

//-----------------Linkedin-----------------------------------------

        $wp_customize->add_setting( 'fcast_soc_linkedin',array(
            'default'=>'',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
           $wp_customize,'soc_linkedin',array(
                'label'=>__('Linkedin','fcast'),
                'settings'=> 'fcast_soc_linkedin',
                'section'=> 'fcast_social_settings',
                'priority'=>14
            )
      ) );

//*********************************************Typography************************************************

    $wp_customize->add_section( 'fcast_typography',array(
        'title'=>__('Typography','fcast'),
        'priority'=>40,
        'type' => 'theme_mod',
        'capability'     => 'edit_theme_options',
        'description' => __('Typography settings for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
      ) );

//-------------------------------H1----------------------------------

        $wp_customize->add_setting( 'fcast_h1_font' , array(
            'default' => 'Shadows Into Light Two, cursive',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
              $wp_customize,'h1_font',array(
                'label'=>__( 'h1','fcast' ),
                'settings'=> 'fcast_h1_font',
                'priority'=>1,
                'section'=> 'fcast_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                    "Indie Flower, cursive"=>"Indie Flower",
                    "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                    "Rock Salt, cursive, cursive"=>"Rock Salt",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                    ))
            )
        );

        $wp_customize->add_setting('fcast_h1_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h1_color',array(
                 'label'=>__('h1 color','fcast'),
                 'section'=>'fcast_typography',
                 'settings'=>'fcast_h1_color',
                 'priority'=>2
                 )
         ) );

//-----------------------------H2----------------------------------------

        $wp_customize->add_setting( 'fcast_h2_font' , array(
            'default' => 'Shadows Into Light Two, cursive',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h2_font',array(
                'label'=>__( 'h2','fcast' ),
                'settings'=> 'fcast_h2_font',
                'priority'=>20,
                'section'=> 'fcast_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('fcast_h2_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h2_color',array(
                 'label'=>__('h2 color','fcast'),
                 'section'=>'fcast_typography',
                 'settings'=>'fcast_h2_color',
                 'priority'=>21
                 )
         ) );

//---------------------------H3----------------------------------------

        $wp_customize->add_setting( 'fcast_h3_font' , array(
            'default' => 'Shadows Into Light Two, cursive',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h3_font',array(
                'label'=>__( 'h3','fcast' ),
                'settings'=> 'fcast_h3_font',
                'priority'=>30,
                'section'=> 'fcast_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                    ))
            )
        );

        $wp_customize->add_setting('fcast_h3_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h3_color',array(
                 'label'=>__('h3 color','fcast'),
                 'section'=>'fcast_typography',
                 'settings'=>'fcast_h3_color',
                 'priority'=>31
                 )
         ) );

//-----------------------------------H4----------------------------------

        $wp_customize->add_setting( 'fcast_h4_font' , array(
            'default' => 'Indie Flower, cursive',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h4_font',array(
                'label'=>__( 'h4','fcast' ),
                'settings'=> 'fcast_h4_font',
                'priority'=>40,
                'section'=> 'fcast_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('fcast_h4_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h4_color',array(
                 'label'=>__('h4 color','fcast'),
                 'section'=>'fcast_typography',
                 'settings'=>'fcast_h4_color',
                 'priority'=>41
                 )
         ) );

//--------------------------------------H5------------------------------------------

        $wp_customize->add_setting( 'fcast_h5_font' , array(
            'default' => 'Indie Flower, cursive',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h5_font',array(
                'label'=>__( 'h5','fcast' ),
                'settings'=> 'fcast_h5_font',
                'priority'=>50,
                'section'=> 'fcast_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                    "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('fcast_h5_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h5_color',array(
                 'label'=>__('h5 color','fcast'),
                 'section'=>'fcast_typography',
                 'settings'=>'fcast_h5_color',
                 'priority'=>51
                 )
         ) );

//------------------------------H6---------------------------------------

        $wp_customize->add_setting( 'fcast_h6_font' , array(
            'default' => 'Indie Flower, cursive',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'h6_font',array(
                'label'=>__( 'h6','fcast' ),
                'settings'=> 'fcast_h6_font',
                'priority'=>60,
                'section'=> 'fcast_typography',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                    "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

        $wp_customize->add_setting('fcast_h6_color',array(
            'default'=>'#222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'h6_color',array(
                 'label'=>__('h6 color','fcast'),
                 'section'=>'fcast_typography',
                 'settings'=>'fcast_h6_color',
                 'priority'=>61
                 )
         ) );

//*******************************************Menu Settings*********************************************************

         $wp_customize->add_section( 'fcast_menu_settings' , array(
            'title'      => __( 'Menu Settings','fcast' ),
            'priority'   =>1,
            'panel' => 'nav_menus',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'description' => __('Menu settings for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
        ) );

//-----------------------------------Menu  Font------------------------------
        $wp_customize->add_setting( 'fcast_menu_font' , array(
            'default' => 'Exo,sans-serif',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
                $wp_customize,'menu_font',array(
                    'label'=>__( 'Menu Font','fcast' ),
                    'settings'=> 'fcast_menu_font',
                    'priority'=>1,
                    'section'=> 'fcast_menu_settings',
                    'type'=>'select','choices'=>array(
                        "Abel,sans-serif"=>"Abel",
                        "Arial,sans-serif"=>"Arial",
                        "Cuprum"=>"Cuprum",
                        "Comfortaa"=>"Comfortaa",
                        "Dancing Script,cursive"=>"Dancing Script",
                        "Dosis,sans-serif"=>"Dosis",
                        "Droid Sans,sans-serif"=>"Droid Sans",
                        "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                        "Francois One,sans-serif"=>"Francois One",
                        "Georgia,serif"=>"Georgia",
                        "Helvetica,sans-serif"=>"Helvetica",
                        "Josefin Sans,sans-serif"=>"Josefin Sans",
                        "Lato,sans-serif"=>"Lato",
                        "Lobster,sans-serif"=>"Lobster",
                        "Lora,sans-serif"=>"Lora",
                        "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                        "Open Sans,sans-serif"=>"Open Sans",
                        "Oswald,sans-serif"=>"Oswald",
                        "Oxygen,sans-serif"=>"Oxygen",
                        "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                        "Philosopher"=>"Philosopher",
                        "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                        "PT Sans"=>"PT Sans",
                        "Prosto One,cursive"=>"Prosto One",
                        "Quicksand,sans-serif"=>"Quicksand",
                        "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                        "Roboto,sans-serif"=>"Roboto",
                        "Share,cursive"=>"Share",
                        "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                      "Merriweather,sans-serif"=>"Merriweather",
                        "Times New Roman,sans-serif"=>"Times New Roman",
                        "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                        "Ubuntu,sans-serif"=>"Ubuntu",
                        "Verdana,sans-serif"=>"Verdana"
                    ))
                )
            );

//--------------------------------Menu Font Size------------------------------------

        $wp_customize->add_setting( 'fcast_menu_font_size' , array(
            'default'     => '14',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize,'menu_font_size',array(
                 'label'=>__('Font size','fcast'),
                 'section'=> 'fcast_menu_settings',
                 'settings'=> 'fcast_menu_font_size',
                 'priority'=>20
                 )
         ) );



   //--------------------------------Menu Item margin------------------------------------

        $wp_customize->add_setting( 'fcast_menu_margin' , array(
            'default'     => '5',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
           $wp_customize,'menu_margin',array(
                 'label'=>__('Margin menu item ','fcast'),
                 'section'=> 'fcast_menu_settings',
                 'settings'=> 'fcast_menu_margin',
                 'priority'=>21
                 )
         ) );

//----------------------------Menu Font Color-----------------------------------

        $wp_customize->add_setting( 'fcast_menu_color',array(
            'default'=>'#333333',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_color',array(
                 'label'=>__('Font Color','fcast'),
                 'section'=> 'fcast_menu_settings',
                 'settings'=> 'fcast_menu_color',
                 'priority'=>30
                 )
         ) );

//--------------------------Menu Font Color Hover-----------------------------

         $wp_customize->add_setting( 'fcast_menu_hover_color',array(
                'default'=>'#666',
                'sanitize_callback' => 'sanitize_hex_color',
                'type' => 'theme_mod',
                'capability'     => 'edit_theme_options',
                'transport' => 'postMessage',
            ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'menu_hover_color',array(
                 'label'=>__('Hover Color','fcast'),
                 'section'=> 'fcast_menu_settings',
                 'settings'=> 'fcast_menu_hover_color',
                 'priority'=>31
                 )
      ) );



//----------------------------SUB Menu Font Color-----------------------------------

        $wp_customize->add_setting( 'fcast_submenu_color',array(
            'default'=>'#444',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_color',array(
                 'label'=>__('Sub menu font Color','fcast'),
                 'section'=> 'fcast_menu_settings',
                 'settings'=> 'fcast_submenu_color',
                 'priority'=>32
                 )
         ) );

//--------------------------SUB Menu Font Color Hover-----------------------------

         $wp_customize->add_setting( 'fcast_submenu_hover_color',array(
            'default'=>'#0a0a0a',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
           $wp_customize,'submenu_hover_color',array(
                 'label'=>__('Sub menu hover color','fcast'),
                 'section'=> 'fcast_menu_settings',
                 'settings'=> 'fcast_submenu_hover_color',
                 'priority'=>33
                 )
      ) );
//----------------------Menu link underline-----------------------------------

        $wp_customize->add_setting( 'fcast_menu_underline',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline',array(
                'label'=>__('Menu link underline','fcast'),
                'settings'=> 'fcast_menu_underline',
                'section'=> 'fcast_menu_settings',
                'type'=>'radio',
                'priority'=>50,
                'choices'=>array(
                        'none'=>'no',
                        'underline'=>'yes'))
        ) );

//----------------------Menu Link underline hover-----------------------------

         $wp_customize->add_setting( 'fcast_menu_underline_hover',array(
            'default'=>'underline',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability'     => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'menu_underline_hover',array(
                'label'=>__('links underline hover','fcast'),
                'settings'=> 'fcast_menu_underline_hover',
                'section'=> 'fcast_menu_settings',
                'type'=>'radio',
                'priority'=>60,
                'choices'=>array(
                        'none'=>'no',
                        'underline'=>'yes'))
      ) );

//******************************************Footer Settings**********************************************

     $wp_customize->add_section( 'fcast_footer_settings' , array(
          'title'      => __( 'Footer Settings','fcast' ),
          'priority'   => 60,
          'type' => 'theme_mod',
          'capability' => 'edit_theme_options',
          'description' => __('Footer settings for <b style="color:#E9323B">"fcast"</b> Theme by <a target=_blank href="http://ordasoft.com/" style="color:#6BACF0">OrdaSoft</a>', 'fcast'),
    ) );

//-------------------------------------Footer Background color-----------------------------

        $wp_customize->add_setting( 'fcast_footer_background',array(
            'default'=>'#222222',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

      $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize, 'footer_background',array(
                'label'=>__('Footer background color','fcast'),
                'section'=> 'fcast_footer_settings',
                'settings'=> 'fcast_footer_background',
                'priority'=>1
            )
        ) );

//-------------------------------------Copyright text-----------------------------

        $wp_customize->add_setting( 'fcast_copyright_text' , array(
            'default'     => '',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
             $wp_customize,'copyright_text',array(
                   'label'=>__('Copyright text','fcast'),
                   'section'=>'fcast_footer_settings',
                   'settings'=>'fcast_copyright_text',
                   'priority'=>10
                   )
           ) );

//-------------------------------------Copyright link-----------------------------

        $wp_customize->add_setting( 'fcast_copyright_link' , array(
            'default'     => '',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
             $wp_customize,'copyright_link',array(
                   'label'=>__('Copyright link','fcast'),
                   'section'=> 'fcast_footer_settings',
                   'settings'=> 'fcast_copyright_link',
                   'priority'=>11
                   )
           ) );

//-------------------------------------Copyright font-----------------------------

        $wp_customize->add_setting( 'fcast_copyright_font' , array(
            'default' => 'Indie Flower, cursive',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_font',array(
                'label'=>__( 'Copyright font','fcast' ),
                'settings'=> 'fcast_copyright_font',
                'priority'=>12,
                'section'=> 'fcast_footer_settings',
                'type'=>'select','choices'=>array(
                    "Abel,sans-serif"=>"Abel",
                    "Arial,sans-serif"=>"Arial",
                    "Cuprum"=>"Cuprum",
                    "Comfortaa"=>"Comfortaa",
                    "Dancing Script,cursive"=>"Dancing Script",
                    "Dosis,sans-serif"=>"Dosis",
                    "Droid Sans,sans-serif"=>"Droid Sans",
                    "Droid Serif,sans-serif"=>"Droid Serif",
                        "Exo,sans-serif"=>"Exo Serif",
                        "Indie Flower, cursive"=>"Indie Flower",
                        "Shadows Into Light Two, cursive"=>"Shadows Into Light Two",
                        "Rock Salt, cursive, cursive"=>"Rock Salt",
                    "Francois One,sans-serif"=>"Francois One",
                    "Georgia,serif"=>"Georgia",
                    "Helvetica,sans-serif"=>"Helvetica",
                    "Josefin Sans,sans-serif"=>"Josefin Sans",
                    "Lato,sans-serif"=>"Lato",
                    "Lobster,sans-serif"=>"Lobster",
                    "Lora,sans-serif"=>"Lora",
                    "Open Sans Condensed,sans-serif"=>"Open Sans Condensed",
                    "Open Sans,sans-serif"=>"Open Sans",
                    "Oswald,sans-serif"=>"Oswald",
                    "Oxygen,sans-serif"=>"Oxygen",
                    "Playfair Display SC,sans-serif"=>"Playfair Display SC",
                    "Philosopher"=>"Philosopher",
                    "PT Sans Narrow,sans-serif"=>"PT Sans Narrow",
                    "PT Sans"=>"PT Sans",
                    "Prosto One,cursive"=>"Prosto One",
                    "Quicksand,sans-serif"=>"Quicksand",
                    "Roboto Condensed, sans-serif"=>"Roboto Condensed",
                    "Roboto,sans-serif"=>"Roboto",
                    "Share,cursive"=>"Share",
                    "Source Sans Pro,sans-serif"=>"Source Sans Pro",
                        "Montserrat,sans-serif"=>"Montserrat",
                    "Merriweather,sans-serif"=>"Merriweather",
                    "Times New Roman,sans-serif"=>"Times New Roman",
                    "Ubuntu Condensed,sans-serif"=>"Ubuntu Condensed",
                    "Ubuntu,sans-serif"=>"Ubuntu",
                    "Verdana,sans-serif"=>"Verdana"
                ))
            )
        );

//-------------------------------------Copyright font size-----------------------------

        $wp_customize->add_setting( 'fcast_copyright_font_size' , array(
            'default'     => '16',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Slider_Customize_Control(
             $wp_customize,'copyright_font_size',array(
                'label'=>__('Copyright font size','fcast'),
                'section'=> 'fcast_footer_settings',
                'settings'=> 'fcast_copyright_font_size',
                'priority'=>13
                )
        ) );

//-------------------------------------Copyright font color-----------------------------

        $wp_customize->add_setting( 'fcast_copyright_color',array(
            'default'=>'#5a2b59',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

      $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'copyright_color',array(
                'label'=>__('Copyright font color','fcast'),
                'section'=> 'fcast_footer_settings',
                'settings'=> 'fcast_copyright_color',
                'priority'=>14
            )
        ) );

//-------------------------------------Copyright font color hover-----------------------------

       $wp_customize->add_setting( 'fcast_copyright_hover_color',array(
            'default'=>'#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Color_Control(
            $wp_customize,'copyright_hover_color',array(
                'label'=>__('Copyright font color hover','fcast'),
                'section'=> 'fcast_footer_settings',
                'settings'=> 'fcast_copyright_hover_color',
                'priority'=>15
            )
        ) );

//-------------------------------------Copyright link Underline-----------------------------

        $wp_customize->add_setting( 'fcast_copyright_underline',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_underline',array(
                'label'=>__('Copyright link underline','fcast'),
                'settings'=> 'fcast_copyright_underline',
                'section'=> 'fcast_footer_settings',
                'type'=>'radio',
                'priority'=>16,
                'choices'=>array(
                    'none'=>'no',
                    'underline'=>'yes'
                ))
        ) );

//-------------------------------------Copyright link Underline hover-----------------------------

        $wp_customize->add_setting( 'fcast_copyright_underline_hover',array(
            'default'=>'none',
            'sanitize_callback' => 'sanitize_text_field',
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'transport' => 'postMessage',
        ) );

        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,'copyright_underline_hover',array(
                'label'=>__('Copyright link underline hover','fcast'),
                'settings'=> 'fcast_copyright_underline_hover',
                'section'=> 'fcast_footer_settings',
                'type'=>'radio',
                'priority'=>17,
                'choices'=>array(
                    'none'=>'no',
                    'underline'=>'yes'
                ))
        ) );


}
add_action( 'customize_register', 'fcast_customize_register' );