<?php
 /**
   * The template for Content Status.
   *
   *
   * @package   fcast WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * fcast is distributed under the terms of the GNU GPL
   */
?>
<?php if ( is_single() ) : ?>
<div  <?php post_class(); ?> id="post-<?php the_ID(); ?>">
<?php else : ?>
<div id="post" class="<?php echo esc_attr(get_theme_mod("fcast_columns_posts"));?>">
<?php endif; ?>
<article class="content">
    <div class="entry-content">
        <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'fcast' ) ); ?>
        <?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'fcast' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
    </div><!-- .entry-content -->
    <footer class="entry-meta">
        <?php if ( is_single() ) :
        fcast_entry_meta();
          else :
          fcast_entry_date();
          endif;
         edit_post_link( __( 'Edit', 'fcast' ), '<span class="edit-link">', '</span>' ); ?>

        <?php if ( is_single() && get_the_author_meta( 'description' ) && is_multi_author() ) : ?>
            <?php get_template_part( 'author-bio' ); ?>
        <?php endif; ?>
    </footer><!-- .entry-meta -->
</article><!-- #post -->
</div>