<?php
 /**
   * The template for Home page.
   * Template Name: Home two
   *
   * @package   fcast WordPress Theme
   * @copyright Copyright (C) 2015, OrdaSoft
   * @license    http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License v2 or later
   * @author      AUTHOR <www.ordasoft.com>
   * fcast is distributed under the terms of the GNU GPL
   */
  $sidebar_left = false;
if (is_active_sidebar( 'sidebar_left' ) ) {
    $sidebar_left = true;
}

$sidebar_right = false;
if (is_active_sidebar( 'sidebar_right' ) ) {
    $sidebar_right = true;
}

$content_top = false;
if (is_active_sidebar( 'content_top' ) ) {
    $content_top = true;
}

$content_bottom = false;
if (is_active_sidebar( 'content_bottom' ) ) {
    $content_bottom = true;
}


if ((get_theme_mod('fcast_header_layout_home')) === 'header' ) :
    get_header();
elseif ((get_theme_mod('fcast_header_layout_home')) === 'header-main' ) :
    get_header('main');
else :
    get_header();
endif;
?>
<div id="main" class="site-main">

    <?php //Full or 1170px width
        if ((get_theme_mod('fcast_home_width')) === 'container' ) :
        echo '<div id="content" class="site-content container">';
        else :
        echo '<div id="content" class="site-content">';
        endif; ?>

        <div class="row">
            <?php if (is_active_sidebar( 'content_top' ) ) : ?>
            <div class="col-lg-12">
                <article id="content-top">
                    <?php  dynamic_sidebar('content_top'); ?>
                </article>
            </div>
            <?php endif; ?>
        </div>

        <div class="page-content" style="<?php echo esc_attr(get_theme_mod( 'fcast_content_show', 'display:none' )); ?>;">
            <?php the_title( '<h1 class="title-home-page">', '</h1>' ); ?>

                <?php while ( have_posts() ) : the_post(); ?>
                    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <?php if (has_post_thumbnail( $post->ID ) ): ?>
                        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
                        <div id="bg-content" style="background-image: url('<?php echo $image[0]; ?>')">
                            <div class="content-overlay"></div>
                            <div class="content-box">
                            <?php endif; ?>
                                <div class="entry-content">
                                    <?php the_content(); ?>
                                </div><!-- .entry-content -->
                            </div>
                        </div><!-- end #category-name -->
                <?php endwhile; ?>
            </div>
        </div>

            <div id="shop-section" style="<?php echo esc_attr(get_theme_mod( 'fcast_shop_show', 'display:none' )); ?>;">
                <div class="title-block row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <h1 class="title"><?php echo esc_attr(get_theme_mod( 'fcast_home_shop_title', '' )); ?></h1>
                    </div>
                </div>
                <div class="row">
                    <div class="store">
                    <?php $posts_per_page = get_theme_mod( 'fcast_products_show', '8' );
                        $args=array(
                            'post_type' => 'product',
                            'post_status' => 'publish',
                            'posts_per_page' => $posts_per_page,
                        );
                    $my_products = null;
                    $my_products = new WP_Query($args);
                        if( $my_products->have_posts() ) {
                        while( $my_products->have_posts() ){ $my_products->the_post();
                            get_template_part( 'products' );
                        }
                        wp_reset_query();
                        } else {
                            get_template_part( 'content', 'none' );
                    } ?>
                </div>
            </div>
        </div>

        <div id="any-section" style="<?php echo esc_attr(get_theme_mod( 'fcast_any_section_show', 'display:none' )); ?>;">
            <div class="title-block row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <h1 class="title"><?php echo esc_attr(get_theme_mod( 'fcast_any_section_title', '' )); ?></h1>
                </div>
            </div>
        <?php echo do_shortcode(get_theme_mod( 'fcast_any_shortcode', '' )); ?>
        </div>

        <div class="title-block row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <h1 class="title"><?php echo esc_attr(get_theme_mod( 'fcast_home_blog_title', '' )); ?></h1>
            </div>
        </div>

           <div class="row">
                <?php if (is_active_sidebar( 'sidebar_left' ) ) : ?>
                <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                    <article id="sidebar">
                        <?php  dynamic_sidebar('sidebar_left'); ?>
                    </article>
                </div>
                <?php endif; ?>

                <div class="<?php if($sidebar_right && $sidebar_left) :
                        echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12');
                        elseif($sidebar_right || $sidebar_left) :
                        echo ('col-lg-9 col-md-9 col-sm-9 col-xs-12');
                        else :
                        echo('col-lg-12 col-md-12 col-sm-12 col-xs-12');
                        endif; ?>">
                         <div class="row">
                            <?php get_template_part( 'loop' ); ?>
                        </div>
                </div>
                <?php if (is_active_sidebar( 'sidebar_right' ) ) : ?>
                    <div class="widgets col-lg-3 col-md-3 col-sm-3 col-xs-12">
                    <article id="sidebar">
                        <?php dynamic_sidebar('sidebar_right'); ?>
                    </article>
                    </div>
                <?php endif; ?>
            </div>

        <div class="row">
            <?php if (is_active_sidebar( 'content_bottom' ) ) : ?>
            <div class="col-lg-12">
                <article id="content-bottom">
                    <?php  dynamic_sidebar('content_bottom'); ?>
                </article>
            </div>
            <?php endif; ?>
        </div>

    </div>
</div>
<?php get_footer(); ?>