<?php
/**
* @author Andrey Kvasnevskiy, http://ordasoft.com
* @email akbet@ordasoft.com
* @version $Id: com_medialibrary.php 2009
* @package Xmap
* @license GNU/GPL
* @description MediaLibrary plugin for MediaLibrary Component
*/

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
require_once (JPATH_BASE ."/components/com_medialibrary/functions.php");
require_once ( JPATH_ROOT .DS.'components'.DS.'com_medialibrary'.DS.'functions.php' );
jimport('joomla.plugin.plugin');
//$tmp = new XmapBookLibrary;
//XmapPlugins::addPlugin( $tmp );

class xmap_com_medialibrary {

  // Set to 0 if you dont want the books and other media in your sitemap
//    var $show_book = 1;
//    var $show_game = 1;
//    var $show_music = 1;
//    var $show_video = 1;

    // Set the order to display media(title,hits,price,vote)
    var $orderby = 'title';

    function isOfType( &$xmap, &$parent ) {
        if( strpos($parent->link, 'option=com_medialibrary') ) {
            $parent->name="MediaLibrary";
            $parent->option="com_medialibrary"; 
            return true;
        }
        return false;
    }



    static function &getTree( &$xmap, &$parent, &$params ) {

        global $mosConfig_absolute_path;

        $list = array();
        $parent->name="Medialibrary";
        $parent->option="com_medialibrary";
        $parent->uid="com_medialibrary";

        if ( strpos($parent->link, 'task=view') )
        {
        return $list;
        }

        $link_query = parse_url( $parent->link );
        parse_str( html_entity_decode($link_query['query']), $link_vars );
        $view = JArrayHelper::getValue($link_vars,'view','categories');

        switch ( $view ) {

            case 'categories':
        
              $link_query = parse_url( $parent->link );
              parse_str( html_entity_decode($link_query['query']), $link_vars );
              $catid = JArrayHelper::getValue($link_vars,'catid',0);
              $list = xmap_com_medialibrary::getCategorieTree ( $xmap, $parent, $catid, $params);
              break;

             
            case 'category':
              xmap_com_medialibrary::singleCategoryHandler ( $xmap, $parent );
              break;

            case 'allcategories':
              $link_query = parse_url( $parent->link );
              parse_str( html_entity_decode($link_query['query']), $link_vars );
              $catid = JArrayHelper::getValue($link_vars,'catid',0);
                
              xmap_com_medialibrary::getCategorieTree ( $xmap, $parent, $catid, $params); 
              break;

            case 'ownerslist':
              xmap_com_medialibrary::ownersListHandler ( $xmap, $parent, $params );
              break;

            case 'allpeople':
              xmap_com_medialibrary::PeopleHandler ( $xmap, $parent );
              break;
            case 'allbook':
              if($params['show_book'] == 'Yes')
              xmap_com_medialibrary::BookCategoryHandler ( $xmap, $parent, $params );
              break;

            case 'allgame':
              if($params['show_game'] == 'Yes')
              xmap_com_medialibrary::GameCategoryHandler ( $xmap, $parent, $params );
              break;


            case 'allvideo':
              if($params['show_video'] == 'Yes')
              xmap_com_medialibrary::VideoCategoryHandler ( $xmap, $parent, $params );
              break;

            case 'allmusic':
              if($params['show_music'] == 'Yes')
              xmap_com_medialibrary::MusicCategoryHandler ( $xmap, $parent, $params );
              break;

            case 'mymedias':
              xmap_com_medialibrary::myMediasHandler ( $xmap, $parent, $params );
              break;

            case 'ownermedias':
              xmap_com_medialibrary::singleUserMediasHandler ( $xmap, $parent, $params );
              break;  

            case 'alonecategory':
              xmap_com_medialibrary::singleCategoryHandler ( $xmap, $parent, $params );
              break;
         
            case 'allmedia':
              xmap_com_medialibrary::getAllMedia ($xmap, $parent, $params);
              break;

            default:

            break;
        }

        return $list;
    }

    static function getAllMedia($xmap, $parent, $params){ 
        $GLOBALS['Itemid'] = $Itemid = intval(mosGetParam( $_REQUEST, 'Itemid', 0 ) ); // for 1.6
        //var_dump($params);
        //$orderby = $params['orderby'];
        //var_dump($orderby);
        
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'm.' . $params['orderby'];}
        
        $xmap->changeLevel(1);
        if ($params['show_book'] == 'No') {
            $notbook = "AND m.media_type <> 'book'";
        }
        else {$notbook = '';}
        if ($params['show_game'] == 'No') {
            $notgame = "AND m.media_type <> 'game'";
        }
        else {$notgame = '';}
        if ($params['show_music'] == 'No') {
            $notmusic = "AND m.media_type <> 'music'";
        }
        else {$notmusic = '';}
        if ($params['show_video'] == 'No') {
            $notvideo = "AND m.media_type <> 'video'";
        }
        else {$notvideo = '';}
          
        $usergroups = getWhereUsergroupsString("cc");

        $database = JFactory::getDBO();
        $my=JFactory::getUser();
        $acl = JFactory::getACL();
    
        $sql = "SELECT m.media_type, m.id,  mc.catid AS catid , other_table.title as title  " .
              " FROM #__medialibrary AS m" .
              " LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid = m.id "  .
              " LEFT JOIN #__medialibrary_main_categories AS cc ON cc.id = mc.catid ".
              " LEFT JOIN (SELECT id,title,rating,URL,imageURL,'game' as type, price,priceunit FROM #__medialibrary_game ".
              " UNION all SELECT id,title,rating,URL,imageURL,'music' as type, price,priceunit  FROM #__medialibrary_music " .
              " UNION all SELECT id,title,rating,URL,imageURL,'book'  as type, price,priceunit  FROM #__medialibrary_book " .
              " UNION all SELECT id,title,rating,URL,imageURL,'video' as type, price,priceunit  FROM #__medialibrary_video ) " .
              " AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type" .
              " WHERE  m.published='1' AND m.approved='1' " .
              "    AND cc.published='1' AND ({$usergroups})" . $notbook . $notgame . $notmusic .$notvideo .
              " GROUP BY m.id ORDER BY " . $orderby . ""  ;
        $database->setQuery ($sql);

        $medias = $database->loadObjectList();
        foreach($medias as $media){
        
            $node = new stdclass;
            $node->id   = $media->id;
            $node->uid=$media->id;
            $node->name = $media->title;
            $node->parent=1;
            $node->browsNav=1;//open new window
            $node->ordering=2;
            $node->priority=$parent->priority;
            $node->chansefreq=$parent->changefreq;
            $node->changefreq=$parent->changefreq;
            $node->modified= date("Y-m-d h:i:s");
            $node->type='component';
            $node->menutype='mainmenu';
            $node->link ='index.php?option=com_medialibrary&amp;task=view&amp;'
                    . 'catid=' .$media->catid.'&amp;id='.$media->id.'&amp;Itemid='.$Itemid;      
                                      
            $xmap->printNode($node);

        }
        $xmap->changeLevel(-1);
    }    


    static function getMedia(&$xmap, &$parent, &$catid ,&$params,$catid, $parentid){ 
        $GLOBALS['Itemid'] = $Itemid = intval(mosGetParam( $_REQUEST, 'Itemid', 0 ) ); // for 1.6

        $parentid = (int)$parentid;
        
        $xmap->changeLevel(1);
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'm.' . $params['orderby'];}
               
        
          
        $usergroups = getWhereUsergroupsString("cc");

        $database = JFactory::getDBO();
        $my=JFactory::getUser();
        $acl = JFactory::getACL();
    
        $sql = "SELECT m.media_type, m.id,  mc.catid AS catid , other_table.title as title  " .
              " FROM #__medialibrary AS m" .
              " LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid = m.id "  .
              " LEFT JOIN #__medialibrary_main_categories AS cc ON cc.id = mc.catid ".
              " LEFT JOIN (SELECT id,title,rating,URL,imageURL,'game' as type, price,priceunit FROM #__medialibrary_game ".
              " UNION all SELECT id,title,rating,URL,imageURL,'music' as type, price,priceunit  FROM #__medialibrary_music " .
              " UNION all SELECT id,title,rating,URL,imageURL,'book'  as type, price,priceunit  FROM #__medialibrary_book " .
              " UNION all SELECT id,title,rating,URL,imageURL,'video' as type, price,priceunit  FROM #__medialibrary_video ) " .
              " AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type" .
              " WHERE  m.published='1' AND m.approved='1' " .
              "    AND cc.published='1' AND mc.catid = '$catid' AND ({$usergroups})" .
              " GROUP BY m.id ORDER BY " . $orderby . ""  ;
        $database->setQuery ($sql);

        $medias = $database->loadObjectList();
        foreach($medias as $media){
        
            $node = new stdclass;
            $node->id   = $media->id;
            $node->uid=$media->id;
            $node->name = $media->title;
            $node->parent=1;
            $node->browsNav=1;//open new window
            $node->ordering=2;
            $node->priority=$parent->priority;
            $node->chansefreq=$parent->changefreq;
            $node->changefreq=$parent->changefreq;
            $node->modified= date("Y-m-d h:i:s");
            $node->type='component';
            $node->menutype='mainmenu';
            $node->link ='index.php?option=com_medialibrary&amp;task=view&amp;catid=' .$media->catid.'&amp;id='.$media->id.'&amp;Itemid='.$Itemid;      
                                      
            $xmap->printNode($node);

        }
        $xmap->changeLevel(-1);
    }
  

 
    static function getSubCategory(&$xmap, &$parent, &$catid ,&$params,$parentid = 0,$cats){
        $link_query = parse_url( $parent->link );
        parse_str( html_entity_decode($link_query['query']), $link_vars );
        $Itemid = $parent->id; //JArrayHelper::getValue($link_vars,'Itemid',0);

        $xmap->changeLevel(1);
        foreach($cats as $subcat) {

            if($subcat->parent_id==$parentid){
        
                $node = new stdclass;
                $node->id = $parent->id;
                $node->uid=$parent->uid.'a'.$subcat->catid;
                $node->name = $subcat->category;
                $node->parent=1;
                $node->browsNav=1;
                $node->ordering=2;
                $node->priority=$parent->priority;
                $node->chansefreq=$parent->changefreq;
                $node->changefreq=$parent->changefreq;
                $node->modified= date("Y-m-d h:i:s");
                $node->type='component';

                $node->link = 'index.php?option=com_medialibrary&amp;task=alonecategory&amp;'
                        . 'catid='.$subcat->catid.'&amp;Itemid='.$Itemid;

                $xmap->printNode($node);
        
                xmap_com_medialibrary::getSubCategory($xmap, $parent, $catid ,
                        $params,$subcat->catid,$cats);
 
                xmap_com_medialibrary::getMedia ($xmap, $parent, $catid ,
                        $params,$subcat->catid, $parentid);

            }
        }
        $xmap->changeLevel(-1);
    }
  


    static function getCategorieTree ( &$xmap, &$parent, &$catid ,&$params) {
        //  xmap_com_medialibrary::header ();

        global $my,$mosConfig_absolute_path;
        if ($params['show_book'] == 'No') {
            $notbook = "AND m.media_type <> 'book'";
        }
        else {$notbook = '';}
        if ($params['show_game'] == 'No') {
            $notgame = "AND m.media_type <> 'game'";
        }
        else {$notgame = '';}
        if ($params['show_music'] == 'No') {
            $notmusic = "AND m.media_type <> 'music'";
        }
        else {$notmusic = '';}
        if ($params['show_video'] == 'No') {
            $notvideo = "AND m.media_type <> 'video'";
        }
        else {$notvideo = '';}

        $database = JFactory::getDBO();
        // $list = array();

        $q = " SELECT m.id AS id, other_table.title AS title, c.name AS category, c.parent_id, c.id AS catid 
                          FROM #__medialibrary AS m  
                          LEFT JOIN #__medialibrary_categories AS mc ON m.id=mc.mediaid AND m.published=1 AND m.approved=1
                          LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid
                          LEFT JOIN (SELECT id,title,rating,URL,imageURL,'game' as type, price,priceunit FROM #__medialibrary_game 
                            UNION all SELECT id,title,rating,URL,imageURL,'music' as type, price,priceunit  FROM #__medialibrary_music 
                            UNION all SELECT id,title,rating,URL,imageURL,'book'  as type, price,priceunit  FROM #__medialibrary_book 
                            UNION all SELECT id,title,rating,URL,imageURL,'video' as type, price,priceunit  FROM #__medialibrary_video ) 
                          AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type
                          WHERE
                          c.published = '1'" . $notbook . $notgame . $notmusic .$notvideo ." 
                         GROUP BY c.id
                          ORDER BY c.parent_id, c.ordering
                          ";
        $database->setQuery ($q);

        $cats = $database->loadObjectList();
        
    
        xmap_com_medialibrary::getSubCategory($xmap, $parent, $catid ,$params,$catid,$cats);

    
    }
  



    static function singleCategoryHandler (&$xmap, &$parent, $params) {
        $database = JFactory::getDBO();
        $query = "SELECT name from #__medialibrary_main_categories "
                . "WHERE id = '".$parent->params->get('category_id')."'";

        $database->setQuery( $query );
        $category = $database->loadResult();


        switch($category){

            case 'video':
                if($params['show_video'] == 'Yes')
                xmap_com_medialibrary::VideoCategoryHandler ( $xmap, $parent, $params );
                break;

            case 'game':
                if($params['show_game'] == 'Yes')
                xmap_com_medialibrary::GameCategoryHandler ( $xmap, $parent, $params );
                break;

            case 'book':
                if($params['show_book'] == 'Yes')
                xmap_com_medialibrary::BookCategoryHandler ( $xmap, $parent, $params );
                break;

            case 'music':
                if($params['show_music'] == 'Yes')
                xmap_com_medialibrary::MusicCategoryHandler ( $xmap, $parent, $params );
                break;

        default:

        break;

        }

    }


    static function BookCategoryHandler (&$xmap, &$parent, $params) {

        // The [Single Category] menu type handler
        // xmap_com_medialibrary::header ();        
        $Itemid = $parent->id;
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'library.' . $params['orderby'];}
        $database = JFactory::getDBO();
    
        $query = "SELECT library.id, library.media_type, library.media_id," .
        " library.hits, library.checked_out, GROUP_CONCAT(c.title SEPARATOR ', ') AS category, ".
        " library.fk_lendid,library.date," .
        " other_table.id as media_type_id, other_table.title as title, other_table.rating as rating, " .
        " other_table.URL as URL, other_table.imageURL as imageURL, price,priceunit " .
        " FROM #__medialibrary AS library " .
        " LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid = library.id "  .
        " LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid " .
        " LEFT JOIN (SELECT id,title,rating,URL,imageURL,price,priceunit,'book' as type FROM #__medialibrary_book) " .
        " AS other_table ON other_table.id = library.media_id and other_table.type = library.media_type" .
        " WHERE  type = 'book' AND library.published='1' AND library.approved='1' " .
        "    AND c.published='1'  " .
        " GROUP BY library.id ORDER BY " . $orderby . ""  ;

        $database->setQuery( $query );
        $items = $database->loadObjectList(); 
         
        $xmap->changeLevel(1);
        
        foreach ( $items as $media ) 
              xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, 
                      $media->title, $media->id, true );
        
        $q = "SELECT m.id AS id, other_table.title as title, c.name AS category, c.parent_id, c.id AS catid 
              FROM #__medialibrary AS m  
              LEFT JOIN #__medialibrary_categories AS mc ON m.id=mc.mediaid AND m.published=1 AND m.approved=1
              LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid
              LEFT JOIN (SELECT id,title,rating,URL,imageURL,'game' as type, price,priceunit FROM #__medialibrary_game 
              UNION all SELECT id,title,rating,URL,imageURL,'music' as type, price,priceunit  FROM #__medialibrary_music 
              UNION all SELECT id,title,rating,URL,imageURL,'book'  as type, price,priceunit  FROM #__medialibrary_book  
              UNION all SELECT id,title,rating,URL,imageURL,'video' as type, price,priceunit  FROM #__medialibrary_video ) AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type 
              WHERE  c.published = '1' 
              GROUP BY c.id
              ORDER BY c.parent_id, c.ordering
                              ";
        $database->setQuery ($q);
        $cats = $database->loadObjectList();

        xmap_com_medialibrary::getSubCategory($xmap, $parent, $catid ,$params,$catid,$cats);  
        
        $xmap->changeLevel(-1);         
    }

    static function PeopleHandler (&$xmap, &$parent ) {
       
        $Itemid = $parent->id;
        $database = JFactory::getDBO();
    
        $query = "SELECT library.id, library.media_type, library.media_id," .
                " library.hits, library.checked_out, GROUP_CONCAT(c.title SEPARATOR ', ') AS category, ".
                " library.fk_lendid,library.date," .
                " other_table.id as media_type_id, other_table.title as title, other_table.rating as rating, " .
                " other_table.URL as URL, other_table.imageURL as imageURL, price,priceunit " .
                " FROM #__medialibrary AS library " .
                " LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid = library.id "  .
                " LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid " .
                " LEFT JOIN (SELECT id,title,rating,URL,imageURL,price,priceunit,'book' as type FROM #__medialibrary_book) " .
                " AS other_table ON other_table.id = library.media_id and other_table.type = library.media_type" .
                " WHERE  type = 'book' AND library.published='1' AND library.approved='1' " .
                "    AND c.published='1'  " .
                " GROUP BY library.id ";
        $query = 'SELECT p.*
                FROM #__medialibrary_people as p
                WHERE  p.published=\'1\' AND p.approved=\'1\' ';
        $database->setQuery( $query );
        $items = $database->loadObjectList(); 
         
        $xmap->changeLevel(1);
        
        foreach ( $items as $media ) {
            //xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, $media->people_name, $media->id, true );
            $catid = 0;
            $mediaid = 0;
            $is_media = false; 
            $name = false;
            $node = new stdclass;
            $node->id   = $Itemid; 
            $node->uid = $media->id; 
            $node->name = $media->people_name ;
            $node->parent = 1; 
            $node->browsNav = 1; 
            $node->ordering = 2; 
            $node->priority=$parent->priority;
            $node->chansefreq=$parent->changefreq;
            $node->changefreq=$parent->changefreq;
            $node->modified= date("Y-m-d h:i:s");
            $node->type = 'component'; 
            $node->menutype = 'mainmenu'; 
             
            $node->link = 'index.php?option=com_medialibrary&task=view_people&pid='.$media->id
                  .'&Itemid='.$Itemid;
                   
            $xmap->printNode($node);    
              
              
        }


        $xmap->changeLevel(-1);         
    }

    static function GameCategoryHandler (&$xmap, &$parent, $params) {

        //xmap_com_medialibrary::header ();        
        $Itemid = $parent->id;
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'library.' . $params['orderby'];}
        $database = JFactory::getDBO();
    
        $query = "SELECT library.id, library.media_type, library.media_id," .
                " library.hits, library.checked_out, GROUP_CONCAT(c.title SEPARATOR ', ') AS category, ".
                " library.fk_lendid,library.date," .
                " other_table.id as media_type_id, other_table.title as title, other_table.rating as rating, " .
                " other_table.URL as URL, other_table.imageURL as imageURL, price,priceunit " .
                " FROM #__medialibrary AS library " .
                " LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid = library.id "  .
                " LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid " .
                " LEFT JOIN (SELECT id,title,rating,URL,imageURL,price,priceunit,'game' as type FROM #__medialibrary_game) " .
                " AS other_table ON other_table.id = library.media_id and other_table.type = library.media_type" .
                " WHERE  type = 'game' AND library.published='1' AND library.approved='1' " .
                "    AND c.published='1' " .
                " GROUP BY library.id ORDER BY " . $orderby . ""  ;

        $database->setQuery( $query );
        $items = $database->loadObjectList(); 
         
        $xmap->changeLevel(1);
        
        foreach ( $items as $media ) 
            xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, $media->title, $media->id, true );
        
        $q = "SELECT m.id AS id, other_table.title as title, c.name AS category, c.parent_id, c.id AS catid 
             FROM #__medialibrary AS m  
             LEFT JOIN #__medialibrary_categories AS mc ON m.id=mc.mediaid AND m.published=1 AND m.approved=1
             LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid
             LEFT JOIN (SELECT id,title,rating,URL,imageURL,'game' as type, price,priceunit FROM #__medialibrary_game 
             UNION all SELECT id,title,rating,URL,imageURL,'music' as type, price,priceunit  FROM #__medialibrary_music 
             UNION all SELECT id,title,rating,URL,imageURL,'book'  as type, price,priceunit  FROM #__medialibrary_book  
             UNION all SELECT id,title,rating,URL,imageURL,'video' as type, price,priceunit  FROM #__medialibrary_video ) AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type 
             WHERE  c.published = '1' 
             GROUP BY c.id
             ORDER BY c.parent_id, c.ordering";
        $database->setQuery ($q);
        $cats = $database->loadObjectList();

        xmap_com_medialibrary::getSubCategory($xmap, $parent, $catid ,$params,$catid,$cats);  
        
        $xmap->changeLevel(-1);         
    }

    static function VideoCategoryHandler (&$xmap, &$parent, $params) {

        //xmap_com_medialibrary::header ();        
        $Itemid = $parent->id;
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'library.' . $params['orderby'];}
        $database = JFactory::getDBO();
    
        $query = "SELECT library.id, library.media_type, library.media_id," .
                " library.hits, library.checked_out, GROUP_CONCAT(c.title SEPARATOR ', ') AS category, ".
                " library.fk_lendid,library.date," .
                " other_table.id as media_type_id, other_table.title as title, other_table.rating as rating, " .
                " other_table.URL as URL, other_table.imageURL as imageURL, price,priceunit " .
                " FROM #__medialibrary AS library " .
                " LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid = library.id "  .
                " LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid " .
                " LEFT JOIN (SELECT id,title,rating,URL,imageURL,price,priceunit,'video' as type FROM #__medialibrary_video) " .
                " AS other_table ON other_table.id = library.media_id and other_table.type = library.media_type" .
                " WHERE  type = 'video' AND library.published='1' AND library.approved='1' " .
                "    AND c.published='1' " .
                " GROUP BY library.id ORDER BY " . $orderby . ""  ;

        $database->setQuery( $query );
        $items = $database->loadObjectList(); 
         
        $xmap->changeLevel(1);
        
        foreach ( $items as $media ) 
            xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, $media->title, $media->id, true );
        
        $q = "SELECT m.id AS id, other_table.title as title, c.name AS category, c.parent_id, c.id AS catid 
             FROM #__medialibrary AS m  
             LEFT JOIN #__medialibrary_categories AS mc ON m.id=mc.mediaid AND m.published=1 AND m.approved=1
             LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid
             LEFT JOIN (SELECT id,title,rating,URL,imageURL,'game' as type, price,priceunit FROM #__medialibrary_game 
             UNION all SELECT id,title,rating,URL,imageURL,'music' as type, price,priceunit  FROM #__medialibrary_music 
             UNION all SELECT id,title,rating,URL,imageURL,'book'  as type, price,priceunit  FROM #__medialibrary_book  
             UNION all SELECT id,title,rating,URL,imageURL,'video' as type, price,priceunit  FROM #__medialibrary_video ) AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type 
             WHERE  c.published = '1' 
             GROUP BY c.id
             ORDER BY c.parent_id, c.ordering
                              ";
        $database->setQuery ($q);
        $cats = $database->loadObjectList();

        xmap_com_medialibrary::getSubCategory($xmap, $parent, $catid ,$params,$catid,$cats);  
        
        $xmap->changeLevel(-1);         
    }

    static function MusicCategoryHandler (&$xmap, &$parent, $params) {

       // xmap_com_medialibrary::header ();        
        $Itemid = $parent->id;
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'library.' . $params['orderby'];}
        $database = JFactory::getDBO();
    
        $query = "SELECT library.id, library.media_type, library.media_id," .
                " library.hits, library.checked_out, GROUP_CONCAT(c.title SEPARATOR ', ') AS category, ".
                " library.fk_lendid,library.date," .
                " other_table.id as media_type_id, other_table.title as title, other_table.rating as rating, " .
                " other_table.URL as URL, other_table.imageURL as imageURL, price,priceunit " .
                " FROM #__medialibrary AS library " .
                " LEFT JOIN #__medialibrary_categories AS mc   ON mc.mediaid = library.id "  .
                " LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid " .
                " LEFT JOIN (SELECT id,title,rating,URL,imageURL,price,priceunit,'music' as type FROM #__medialibrary_music ) " .
                " AS other_table ON other_table.id = library.media_id and other_table.type = library.media_type" .
                " WHERE  type = 'music' AND library.published='1' AND library.approved='1' " .
                "    AND c.published='1' " .
                " GROUP BY library.id ORDER BY " . $orderby . ""  ;

        $database->setQuery( $query );
        $items = $database->loadObjectList(); 
         
        $xmap->changeLevel(1);
        
        foreach ( $items as $media ) 
            xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, $media->title, $media->id, true );
        
        $q = "SELECT m.id AS id, other_table.title as title, c.name AS category, c.parent_id, c.id AS catid 
             FROM #__medialibrary AS m  
             LEFT JOIN #__medialibrary_categories AS mc ON m.id=mc.mediaid AND m.published=1 AND m.approved=1
             LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid
             LEFT JOIN (SELECT id,title,rating,URL,imageURL,'game' as type, price,priceunit FROM #__medialibrary_game 
             UNION all SELECT id,title,rating,URL,imageURL,'music' as type, price,priceunit  FROM #__medialibrary_music 
             UNION all SELECT id,title,rating,URL,imageURL,'book'  as type, price,priceunit  FROM #__medialibrary_book  
             UNION all SELECT id,title,rating,URL,imageURL,'video' as type, price,priceunit  FROM #__medialibrary_video ) AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type 
             WHERE  c.published = '1' 
             GROUP BY c.id
             ORDER BY c.parent_id, c.ordering";
        $database->setQuery ($q);
        $cats = $database->loadObjectList();

        xmap_com_medialibrary::getSubCategory($xmap, $parent, $catid ,$params,$catid,$cats);  
        
        $xmap->changeLevel(-1);         
    }

    static function myMediasHandler (&$xmap, &$parent, $params) {

        //xmap_com_medialibrary::header ();
        $Itemid = $parent->id;
        
        $items = array();
        if ($params['show_book'] == 'No') {
            $notbook = "AND m.media_type <> 'book'";
        }
        else {$notbook = '';}
        if ($params['show_game'] == 'No') {
            $notgame = "AND m.media_type <> 'game'";
        }
        else {$notgame = '';}
        if ($params['show_music'] == 'No') {
            $notmusic = "AND m.media_type <> 'music'";
        }
        else {$notmusic = '';}
        if ($params['show_video'] == 'No') {
            $notvideo = "AND m.media_type <> 'video'";
        }
        else {$notvideo = '';}
        
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'm.' . $params['orderby'];}
        
        $database = JFActory::getDBO ();
        $my = JFActory::getUser ();        
       
        if( !isset($my->name) ) return ;
        
        $q = "  SELECT other_table.title as title, m.id as id, c.id AS catid 
                FROM `#__medialibrary` AS m
                LEFT JOIN `#__users` AS u ON u.email=m.owner_ID
                LEFT JOIN `#__medialibrary_categories` AS mc ON mc.mediaid=m.id
                LEFT JOIN `#__medialibrary_main_categories` AS c ON mc.catid=c.id
                LEFT JOIN (SELECT id,title,'game' as type, price,priceunit FROM #__medialibrary_game 
                                   UNION all SELECT id,title,'music' as type, price,priceunit  FROM #__medialibrary_music 
                                   UNION all SELECT id,title,'book'  as type, price,priceunit  FROM #__medialibrary_book  
                                   UNION all SELECT id,title,'video' as type, price,priceunit  FROM #__medialibrary_video ) AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type 
                WHERE m.owner_ID = '$my->id'" . $notbook . $notgame . $notmusic .$notvideo . "
                GROUP BY id ORDER BY " . $orderby . ""  ;
              
        $database->setQuery( $q ); 
        $items = $database->loadObjectList(); 
        $xmap->changeLevel(1);
        if ( isset($items[0]) )
            foreach ( $items as $media )         
                xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, $media->title, $media->catid, $media->id, true );
        $xmap->changeLevel(-1);        
    }
    
    static function singleUserMediasHandler (&$xmap, &$parent, $params) {
        // The [Single User media] menu type handler
        $database = JFactory::getDBO ();
        
        // xmap_com_medialibrary::header ();
        $Itemid = $parent->id;
        
        $username = ($parent->params->get ('id'));
        
        if ($params['show_book'] == 'No') {
            $notbook = "AND m.media_type <> 'book'";
        }
        else {$notbook = '';}
        if ($params['show_game'] == 'No') {
            $notgame = "AND m.media_type <> 'game'";
        }
        else {$notgame = '';}
        if ($params['show_music'] == 'No') {
            $notmusic = "AND m.media_type <> 'music'";
        }
        else {$notmusic = '';}
        if ($params['show_video'] == 'No') {
            $notvideo = "AND m.media_type <> 'video'";
        }
        else {$notvideo = '';}
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'm.' . $params['orderby'];}
        
        $q = " SELECT distinct m.*,other_table.title as title, c.id AS catid 
                  FROM `#__medialibrary` AS m
                  LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid=m.id 
                  LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid 
                  LEFT JOIN `#__users` AS u ON u.email=m.owneremail
                  LEFT JOIN (SELECT id,title,'game' as type, price,priceunit FROM #__medialibrary_game 
                               UNION all SELECT id,title,'music' as type, price,priceunit  FROM #__medialibrary_music 
                               UNION all SELECT id,title,'book'  as type, price,priceunit  FROM #__medialibrary_book  
                               UNION all SELECT id,title,'video' as type, price,priceunit  FROM #__medialibrary_video ) AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type 
                  WHERE m.approved = 1 AND c.published = 1 AND m.published = 1 AND
                  u.id='$username' " . $notbook . $notgame . $notmusic .$notvideo . "
                  GROUP BY title ORDER BY " . $orderby . ""  ;
        $database->setQuery( $q ); 
        $items = $database->loadObjectList();
      
        
        $xmap->changeLevel(1);
            foreach ( $items as $media )            
                xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, $media->title, $media->catid, $media->id, true );
        $xmap->changeLevel(-1);
    }




    static function ownersListHandler (&$xmap, &$parent, $params) { 
        // The [owners list] menu type handler
        $database = JFactory::getDBO ();
        // xmap_com_medialibrary::header ();
        $Itemid = $parent->id;

     

        $q1 = "SELECT u.name, u.email, u.id, COUNT(m.owneremail) AS medias
                      \nFROM #__medialibrary AS m
                      \nLEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid=m.id
                      \nLEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid
                      \nLEFT JOIN #__users AS u ON m.owneremail=u.email
                      \nWHERE m.published=1 AND m.approved=1 AND c.published=1 AND m.owneremail!=''
                      \nGROUP BY u.name
                      \nORDER BY u.name ";
                          
        $database->setQuery ($q1);
        $items = $database->loadObjectList(); 
                
        $xmap->changeLevel(1);
        if ($params['show_book'] == 'No') {
            $notbook = "AND m.media_type <> 'book'";
        }
        else {$notbook = '';}
        if ($params['show_game'] == 'No') {
            $notgame = "AND m.media_type <> 'game'";
        }
        else {$notgame = '';}
        if ($params['show_music'] == 'No') {
            $notmusic = "AND m.media_type <> 'music'";
        }
        else {$notmusic = '';}
        if ($params['show_video'] == 'No') {
            $notvideo = "AND m.media_type <> 'video'";
        }
        else {$notvideo = '';}
        
        if ($params['orderby'] == 'price' || $params['orderby'] == 'title'){
            $orderby = 'other_table.' . $params['orderby'];
        }
        else {$orderby = 'm.' . $params['orderby'];}
            
        foreach ( $items as $owner ) { 
          
            xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $owner->id, $owner->name, 0, 0, false, $owner->name );
              
         
        $q = "SELECT m.*,other_table.title as title, c.id AS catid FROM `#__medialibrary` AS m
             LEFT JOIN #__medialibrary_categories AS mc ON mc.mediaid=m.id
             LEFT JOIN #__medialibrary_main_categories AS c ON c.id=mc.catid
             LEFT JOIN (SELECT id,title,'game' as type, price,priceunit FROM #__medialibrary_game 
             UNION all SELECT id,title,'music' as type, price,priceunit  FROM #__medialibrary_music 
             UNION all SELECT id,title,'book'  as type, price,priceunit  FROM #__medialibrary_book  
             UNION all SELECT id,title,'video' as type, price,priceunit  FROM #__medialibrary_video ) AS other_table ON other_table.id = m.media_id and other_table.type = m.media_type 
             WHERE 
             m.approved = 1 AND c.published = 1 AND m.published = 1 " . $notbook . $notgame . $notmusic .$notvideo . " AND                  
             m.owner_ID='$owner->id'
             GROUP BY m.id ORDER BY " . $orderby . ""  ;  
        $database->setQuery($q);
        $medias = $database->loadObjectList();   
        $xmap->changeLevel(1);        
        foreach ( $medias as $media )               
            xmap_com_medialibrary::printNode ( $xmap, $parent, $Itemid, $media->id, $media->title, $media->catid, $media->id, true );                        
        $xmap->changeLevel(-1);
        }
        
        $xmap->changeLevel(-1);
    } 
  


    static function printNode ( &$xmap, &$parent, $Itemid, $node_uid, $node_name, $catid = 0, $mediaid = 0, $is_media = false, $name = false ) {
        // [params for media]: $xmap obj, the `parent` Obj, Itemid, mediaid, media->title, catid, mediaID, media/category flag = 'true', user=false
        // [params for Category]: $xmap, $parent, Itemid, catid, category title, catid, 0, false, user=false
        // [params for User]: $xmap, $parent, Itemid, userid, username, 0, 0, false, username
        $node = new stdclass;
        $node->id   = $Itemid; 
        $node->uid = $node_uid; 
        $node->name = $node_name ;
        $node->parent = 1; 
        $node->browsNav = 1; 
        $node->ordering = 2; 
        $node->priority=$parent->priority;
        $node->chansefreq=$parent->changefreq;
        $node->changefreq=$parent->changefreq;
        $node->modified= date("Y-m-d h:i:s");
        $node->type = 'component'; 
        $node->menutype = 'mainmenu'; 
        if ( $is_media ) 
    
              $node->link = 'index.php?option=com_medialibrary&amp;task=view&amp;catid='.$catid.'&amp;Itemid='.$Itemid.'&amp;id='.$mediaid;
        elseif ( $catid > 0 ) // Its a category link
              // echo 'catid';
              $node->link = 'index.php?option=com_medialibrary&amp;task=view&amp;id='.$node_uid.'&amp;Itemid='.$Itemid;
        elseif ( isset($name) AND $name != '' ) // Its a user link
          //echo 'name';
          $node->link = 'index.php?option=com_medialibrary&amp;task=ownermedias&amp;Itemid='.$Itemid.'&amp;id='.$node_uid;
      $xmap->printNode($node);    
      
  } 


}



