<?php
/*
 * @package OS_Touch_Slider_Pro
 * @subpackage  mod_medialibrary_OS_TouchSlider_Free
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru);
 * @Homepage: http://www.ordasoft.com
 * @version: 3.5 Free
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

if(!class_exists('modSlideShowHelperMedia')) {
  class modSlideShowHelperMedia {
  static $mediaArray = array();
    static function getWhereUsergroupsString( $table_alias ) {
        global $my;

        if ( isset($my->id) AND $my->id != 0 ) {
          $usergroups_sh = modSlideShowHelperMedia::getGroupsByUser ($my->id,'');
          //$usergroups_sh = '-2'.$usergroups_sh;
        } else {
           $usergroups_sh = array ();
        }
        $usergroups_sh[] = -2;
        $s = '';
        for ($i=0; $i<count($usergroups_sh); $i++) {
          $g = $usergroups_sh[$i];
          $s .= " $table_alias.params LIKE '%,{$g}' or $table_alias.params = '{$g}' " .
           " or $table_alias.params LIKE '{$g},%' or $table_alias.params LIKE '%,{$g},%' ";
          if ( ($i+1)<count($usergroups_sh) )
            $s .= ' or ';
        }
        return $s;
    }

    static function getGroupsByUser ( $uid, $recurse ) {
           $database = JFactory::getDBO() ;
          $usergroups = array ();

          if ( $recurse == 'RECURSE' ) {
          // [1]: Recurse getting the usergroups
            $id_group = array ();
            $q1 = "SELECT group_id FROM `#__user_usergroup_map` WHERE user_id={$uid}";
            $database->setQuery($q1);
            $rows1 = $database->loadObjectList();
            foreach ($rows1 as $v) {
              $id_group[] = $v->group_id;
              }
            for ($k=0; $k<count($id_group); $k++) {
              $q = "SELECT g2.id FROM `#__usergroups` g1 " .
               " LEFT JOIN `#__usergroups` g2 ON g1.lft > g2.lft AND g1.lft < g2.rgt " .
                " WHERE g1.id={$id_group[$k]} ORDER BY g2.lft";
              $database->setQuery($q);
              $rows = $database->loadObjectList();
              foreach ($rows as $r) {
                $usergroups[] = $r->id;
                }
              }
            $usergroups = array_unique($usergroups);
            }
          return $usergroups;
      }

      static function sefRelToAbs( $value ) {
        //Need check!!!
        // Replace all &amp; with & as the router doesn't understand &amp;
        $url = str_replace('&amp;', '&', $value);
        if(substr(strtolower($url),0,9) != "index.php") return $url;
        $uri    = JURI::getInstance();
        $prefix = $uri->toString(array('scheme', 'host', 'port'));
        return $prefix.JRoute::_($url);
      }

      static function getImagesFromSlideShow($params,$langContent) {

        if(!is_numeric($max = $params->get('count_book'))) $max = 20;
        if(!is_numeric($limit_title = $params->get('limit_title'))) $limit_title = 15;

        $catid = trim($params->get('catid') );
        if($catid != "" ) $catid = " and c.id in ( ". $catid ." ) " ;

        $mediaid = trim($params->get('mediaid') );
        // выборка из mediaid
        if($mediaid != "" ) $mediaid = " and h.id in ( ". $mediaid ." ) " ;
        if($mediaid != "" && $catid != ""){
           echo ('<font color="#CC0000">You input IDs of categories and media together! Correct this mistake.</font>');
        } 
        // build query to get slides
        $db = JFactory::getDBO();

        $s=modSlideShowHelperMedia::GetWhereUserGroupsString("c");
        $temp_sort=$params->get('sort_by');

         if (isset($langContent)) {

            $lang = $langContent;
            $query = "SELECT lang_code FROM #__languages WHERE sef = '$lang'";
            $db->setQuery($query);
            $lang = $db->loadResult();
            $lang = " and ( h.language = '$lang' or h.language like 'all' or " .
             " h.language like '' or h.language like '*' or h.language is null) " .
             " AND ( c.language = '$lang' or c.language like 'all' or " .
              " c.language like '' or c.language like '*' or c.language is null) ";
        } else {
            $lang = "";
        }

       switch($temp_sort) {
        case 4 : $sql_sort_top = ' CAST( h.hits AS SIGNED) ASC ' ; break;
        case 3 : $sql_sort_top = ' h.htitle ASC ' ; break;
        case 2 : $sql_sort_top = ' CAST( h.price AS SIGNED) ASC '; break;
        case 1 : $sql_sort_top = ' h.date DESC '; break;
        case 0 : $sql_sort_top = ' RAND() '; break;
       }

        $select_types_of_medias = array();

        if($params->get('book') > 0){
          $select_types_of_medias['book'] = $params->get('book');
        }
        if($params->get('music') > 0){
          $select_types_of_medias['music'] = $params->get('music');
        }
        if($params->get('video') > 0){
          $select_types_of_medias['video'] = $params->get('video');
        }
        if($params->get('game') > 0){
          $select_types_of_medias['game'] = $params->get('game');
        }
      self::$mediaArray = array();
         $arm = self::$mediaArray;

        if (empty($select_types_of_medias)) {
            
               
                $arm = modSlideShowHelperMedia::getMedias($arm, "book", $catid, $mediaid, $sql_sort_top, $max);
            
        } else {
             foreach ($select_types_of_medias as $key => $value) {
               
                $arm = modSlideShowHelperMedia::getMedias($arm, $key, $catid, $mediaid, $sql_sort_top, $value);
            }
        }
        $slides = self::$mediaArray;
        foreach($slides as $slide){
            $slide->price = $slide->price;
            $slide->priceunit = $slide->priceunit;

            $slide->image = $slide->imageURL;
            if($slide->imageURL != "" )  $slide->image = $slide->imageURL;//modSlideShowHelperMedia::getSlideImage($slide,$params);
            else  $slide->image = "./components/com_medialibrary/images/no-img_eng.gif";
            $slide->link = modSlideShowHelperMedia::getSlideLink($slide,$params);
            $slide->description = modSlideShowHelperMedia::getSlideDescription($slide, $params->get('comment'));
            if(strlen($slide->title)>$limit_title)
                $slide->title = substr($slide->title, 0, $limit_title)."..";
        }
        return $slides;
      }
    
      static function getMedias($mediaArray, $mediaType, $catid, $mediaid, $sql_sort_top, $max) {
  

        
        $db = JFactory::getDBO();
        $database = JFactory::getDBO();
        //----------------------------------------------------
        // подключим файл  с нашими функциями
        require_once ( JPATH_SITE . "/components/com_medialibrary/functions.php" );

        $langContent=defination_Lang_media();
        // // добавили возможность фильрования языка
        if (isset($langContent)){

          $lang = $langContent;
          $query = "SELECT lang_code FROM #__languages WHERE sef = '$lang'";
          $database->setQuery($query);

          $lang = $database->loadResult();
          $langSelect = "( h.langDescription like 'all'
            or h.langDescription like ''
            or h.langDescription like '*'
            or h.langDescription is null
            or h.langDescription like '$lang'
            )  AND
            (c.langDescription like 'all'
            or c.langDescription like ''
            or c.langDescription like '*'
            or c.langDescription is null
            or c.langDescription like '$lang'
            )";
        }
          
          
          
//----------------------------------------------------           
        //  тут стоит добавить языковой фильтр
        $selectstring = "SELECT DISTINCT mv.*,hc.catid,h.id as id FROM `#__medialibrary_$mediaType` AS mv
                        LEFT JOIN `#__medialibrary` AS h ON h.media_id = mv.id
                        LEFT JOIN `#__medialibrary_categories` AS hc ON hc.mediaid=h.id
                        LEFT JOIN `#__medialibrary_main_categories` AS c ON c.id=hc.catid
                        WHERE ({$langSelect}) and   h.media_type = '".$mediaType.
                        "' and h.published=1 and h.approved=1 and c.published = 1 ".
                        $catid . $mediaid . " ORDER BY ".$sql_sort_top." LIMIT 0, $max;";
        $db->setQuery($selectstring);
        $mediaTypeArray = $db->loadObjectList();

        self::$mediaArray = array_merge($mediaArray, $mediaTypeArray);
        return self::$mediaArray;
      }

      static function getSlideImage($slide,$params) {



        $image_source_type = $params->get('image_source_type');
        $mosConfig_absolute_path=JPATH_BASE;
        $mosConfig_live_site=JURI::base(true);

        $imageURL = $slide->src;
        if($imageURL!=''){
            $file_pth= pathinfo($imageURL);
            $file_type=".".$file_pth['extension'];
            if(array_key_exists  ( 'filename' , $file_pth  ) ) $file_name=$file_pth['filename'];
            else $file_name = substr($imageURL, 0,strlen($imageURL)-strlen($file_pth['extension'] ) -1 );

            $file1=$mosConfig_absolute_path . '/components/com_medialibrary/covers/'. $file_name . $file_type;
            $img1= $mosConfig_absolute_path.'/components/com_medialibrary/covers/'. $file_name . $file_type;
            if($image_source_type == 0 ) {
              if( file_exists($file1) ) return $img1;
            }

            $file2=$mosConfig_absolute_path . '/components/com_medialibrary/covers/'. $file_name ."_gallery". $file_type;
            $img2= $mosConfig_absolute_path.'/components/com_medialibrary/covers/'. $file_name ."_gallery". $file_type;
            if($image_source_type == 1 ) {
              if( file_exists($file2) ) return $img2;
              else return $img1;
            }

            if($image_source_type == 2 ) {
              $file3=$mosConfig_absolute_path . '/components/com_medialibrary/covers/'. $file_name ."_mini". $file_type;
              $img3= $mosConfig_absolute_path.'/components/com_medialibrary/covers/'. $file_name ."_mini". $file_type;
              if( file_exists($file3) ) return $img3;
              else if( file_exists($file2) ) return $img2;
              else return $img1;
            }
        }
        else $imageURL = "./components/com_medialibrary/images/no-img_eng.gif";

        return $imageURL ;
      }
      static function isHttpUrl($url) 
      {
          $findme   = 'http';
          $pos = strpos($url, $findme);
          if($pos === false) $url = JURI::base().$url;
          return $url;
      }

      static function getSlideLink($slide,$params) {



        $link = '';
        $db = JFactory::getDBO();

        if( $params->get('ItemId', '') != "" ) {
          $ItemId_tmp=$params->get('ItemId', '');
        } else {
          $selectstring = "SELECT id  FROM #__menu WHERE menutype like '%menu%' AND " .
           " link LIKE '%option=com_medialibrary%' AND params LIKE '%back_button%' ";
          $db->setQuery($selectstring);
          $ItemId_tmp_from_db = $db->loadResult();
          $ItemId_tmp=$ItemId_tmp_from_db;
        }

        $link = 'index.php?option=com_medialibrary&amp;task=view&amp;id='.
          $slide->id.'&amp;catid='.$slide->catid.'&amp;Itemid='.$ItemId_tmp;
        return modSlideShowHelperMedia::sefRelToAbs($link);
      }

      static function getSlideDescription($slide, $limit) {
        $desc = strip_tags($slide->comment);
        if($limit && $limit < strlen($desc)) {
          $limit = strpos($desc, ' ', $limit);
          $desc = substr($desc, 0, $limit);
          if(preg_match('/[A-Za-z0-9]$/', $desc)) $desc.=' ...';
          $desc = nl2br($desc);
        } else { // no limit or limit greater than description
          $desc = $slide->comment;
        }
        return $desc;
      }

  }
}