// Copyright (C) 2012 Brett Dixon

// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 
// "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject 
// to the following conditions:

// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT 
// SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN 
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE 
// USE OR OTHER DEALINGS IN THE SOFTWARE.

/*
---
description: Graphing/chart tool for MooTools

license: MIT License

authors:
- Brett Dixon

requires: 
- core/1.3.1: *
- more/1.3.2: Color

provides: [MilkChart.Column, MilkChart.Bar, MilkChart.Line, MilkChart.Scatter, MilkChart.Pie, MilkChart.Doughnut]


...
*/
(function(b){var c=b.MilkChart={};c.Colors=["#4f81bd","#c0504d","#9bbb59","#8064a2","#4198af","#db843d"];var a=new Class({initialize:function(d,e){this.x=d||0;this.y=e||0}});c.Base=new Class({Implements:[Options,Events],options:{width:480,height:290,colors:c.Colors,padding:12,font:"Verdana",fontColor:"#000000",fontSize:10,background:"#FFFFFF",chartLineColor:"#878787",chartLineWeight:1,border:true,borderWeight:1,borderColor:"#878787",titleSize:18,titleFont:"Verdana",titleColor:"#000000",showRowNames:true,showValues:true,showKey:true,useZero:true,copy:false,rowPrefix:"",ignoreFirstColumn:false,clean:false},state:{skipLabel:0},initialize:function(f,e){this.setOptions(e);this.element=document.id(f);this.width=this.options.width;this.height=this.options.height;this.options.padding+=0.5;if(this.options.clean||!this.isClean()){this.element=this.getCleanedTable()}if(this.element.get("tag")==="table"){this.container=new Element("div").inject(this.element.getParent())}else{this.container=this.element}this.container.setStyles({width:this.width,height:this.height,display:"inline-block"});this._canvas=new Element("canvas",{width:this.options.width,height:this.options.height}).inject(this.container);this.ctx=this._canvas.getContext("2d");this.data={title:this.element.title,colNames:[],rowNames:[],rows:[]};this.minY=(this.options.useZero)?0:10000000000;this.maxY=0;this.bounds=[new a(),new a(this.width,this.height)];this.chartWidth=0;this.chartHeight=0;var g=0.2;var d=0.1;this.keyPadding=this.width*g;this.rowPadding=this.height*d;this.rowPaddingDimension="width";this.shapes=[];Object.each(c.Shapes,function(h){this.shapes.push(h)},this)},isClean:function(){var d=true;if(this.element.get("tag")==="table"){if(this.element.tHead){d=this.element.tHead.getChildren().length===1}}return d},getCleanedTable:function(){var e=new Element("table");var f=new Element("thead").inject(e);var g=new Element("tr").inject(f);var d=new Element("tbody").inject(e);this.element.getChildren()[0].getLast().getChildren().each(function(h){g.adopt(new Element("td",{text:h.get("text")}))});this.element.getChildren()[1].getChildren().each(function(h){var h=new Element("tr").inject(d);h.getChildren().each(function(i){var k=new Element("td",{text:i.get("text")});h.adopt(k)})});e.setStyle("display","none");e.inject(this.element.getParent());return e},prepareCanvas:function(){if(!this.options.copy&&this.element.get("tag")=="table"){this.element.setStyle("display","none")}this.ctx.fillStyle=this.options.background;this.ctx.fillRect(0,0,this.width,this.height);this.ctx.font=this.options.fontSize+"px "+this.options.font;if(this.options.border){var g=0.5;this.ctx.lineWeight=this.options.borderWeight;this.ctx.strokeRect(g,g,this.width-1,this.height-1)}if(this.options.showValues){this.bounds[0].x+=this.getValueColumnWidth()}this.bounds[0].x+=this.options.padding;this.bounds[0].y+=this.options.padding;this.bounds[1].x-=this.options.padding*2;this.bounds[1].y-=this.options.padding*2;if(this.options.showKey){var e="";this.data.colNames.each(function(i){if(i.length>e.length){e=String(i)}});var f=14;this.keyPadding=this.ctx.measureText(e).width+f;this.bounds[1].x-=this.keyPadding;var d=1.02;this.keyBounds=[new a(this.bounds[1].x*d,this.bounds[0].y),new a(this.keyPadding,this.bounds[1].y)]}this.chartWidth=this.bounds[1].x-this.bounds[0].x;if(this.data.title){var h=this.bounds[0].y+this.height*0.1;this.bounds[0].y=h;this.titleBounds=[new a(this.bounds[0].x,0),new a(this.bounds[1].x,h)];this.drawTitle()}if(this.options.showRowNames){this.ctx.font=this.options.fontSize+"px "+this.options.font;this.getRowPadding();this.bounds[1].y-=this.rowPadding}else{this.rowPadding=0}this.chartHeight=this.bounds[1].y-this.bounds[0].y;this.colors=this.__getColors(this.options.colors)},getValueColumnWidth:function(){return this.ctx.measureText(String(this.maxY+0.01)).width},getRowPadding:function(){var e=0;this.data.rowNames.each(function(f){e+=this.ctx.measureText(f).width},this);var d=(e>this.chartWidth);if(d){this.rowPadding=this.ctx.measureText(this.longestRowName).width}else{this.rowPadding=(this.ctx.measureText(this.longestRowName).width>((this.bounds[1].x-this.bounds[0].x)/this.data.rows.length))?this.ctx.measureText(this.longestRowName).width:this.height*0.1}},drawTitle:function(){var d=1.25;var e=this.options.titleSize*d;this.ctx.textAlign="center";this.ctx.font=this.options.titleSize+"px "+this.options.titleFont;this.ctx.fillStyle=this.options.titleColor;this.ctx.fillText(this.data.title,this.bounds[0].x+(this.bounds[1].x-this.bounds[0].x)/2,e,this.chartWidth)},drawAxes:function(){this.ctx.beginPath();this.ctx.strokeStyle=this.options.chartLineColor;this.ctx.moveTo(this.bounds[0].x+0.5,this.bounds[0].y+0.5);this.ctx.lineTo(this.bounds[0].x+0.5,this.bounds[1].y+0.5);this.ctx.moveTo(this.bounds[0].x+0.5,this.bounds[1].y+0.5);this.ctx.lineTo(this.bounds[1].x+0.5,this.bounds[1].y+0.5);this.ctx.stroke()},__xAxisLabels:function(m,h,l){var k=c.escape(this.data.rowNames[m]);var i=true;var e=4;var d=Math.floor((this.data.rowNames.length*this.options.fontSize)/(this.chartWidth/2));this.ctx.fillStyle=this.options.fontColor;this.ctx.lineWidth=1;this.ctx.textAlign="center";if(this.options.skipLabel){if(this.state.skipLabel!==0){i=false}++this.state.skipLabel;if(this.state.skipLabel===this.options.skipLabel){this.state.skipLabel=0}}if(this.options&&this.options.labelTicks){this.ctx.save();this.ctx.translate(parseInt(l.x+this.rowWidth/2)+0.5,this.bounds[1].y+0.5);this.ctx.moveTo(0,0);this.ctx.lineTo(0,4);this.ctx.stroke();this.ctx.restore();e=8}if(i===true){if(h!==0){this.ctx.save();this.ctx.textAlign="right";var g=l.x+this.rowWidth/2+this.options.fontSize/2;var f=this.bounds[1].y+e;this.ctx.translate(g,f);this.ctx.rotate(h);if(this.data.rowNames.length*this.options.fontSize>this.chartWidth){if(this.options.skipLabel||m%d==1){if(this.options.type==="column"){this.ctx.fillText(k,-(this.rowWidth),0)}else{this.ctx.fillText(k,0,0)}}}else{this.ctx.fillText(k,0,0)}this.ctx.restore()}else{this.ctx.fillText(k,l.x+(this.rowWidth/2),this.bounds[1].y+(this.rowPadding/2))}}},drawValueLines:function(){var o=[0.1,0.2,0.25,0.5,1,2,5,10,20,50,100,150,500,1000,1500,2000,2500,5000,10000];var n=o[o.length-1];while(this.maxY>n){n+=10000;o.push(n)}var p=9;var g=0;this.chartLines=1;if(this.maxY==this.minY){this.maxY=1}var r=this.maxY-this.minY;var l=false;var m=0;o.each(function(i){if(l){return}for(j=p;j>4;j--){if(l){return}if(j*i>=r){l=i}}});this.minY=Math.floor(this.minY/l)*l;this.maxY=Math.ceil(this.maxY/l)*l;for(j=this.minY;j<=this.maxY;j=j+l){++m}var s=this.bounds[1].y-this.bounds[0].y;var e=this.bounds[1].x-this.bounds[0].x;var q=Math.floor(s/(m-1));this.ratio=q/l;this.ctx.fillStyle=this.options.fontColor;var h=this.options.rowTicks?4:0;var f=0;for(j=this.minY;j<=this.maxY;j=j+l){j=parseInt(j*100)/100;var d=this.bounds[1].y+0.5-f*q;if(this.options.showValues){this.ctx.textAlign="right";this.ctx.fillText(String(j),this.bounds[0].x-2-h,(d+3))}this.ctx.beginPath();this.ctx.moveTo(this.bounds[0].x-h,d);this.ctx.lineTo(this.bounds[1].x,d);this.ctx.stroke();this.ctx.moveTo(this.bounds[0].x,this.bounds[1].y+0.5+j*q);++f}},swapAxes:function(){var f=this.data.rowNames.slice(0);var d=this.data.colNames.slice(0);this.data.rowNames=d;this.data.colNames=f;var e=[];this.data.rows.each(function(h,g){h.each(function(i,k){if(!e[k]){e[k]=[]}e[k][g]=i})});this.data.rows=e;this.setData(this.data);this.render()},setData:function(e){this.bounds=[new a(),new a(this.width,this.height)];this.colors=this.__getColors(this.options.colors);this.minY=(this.options.useZero)?0:10000000000;this.maxY=0;e.rows.each(function(g){var f=Math.max.apply(Math,g);var h=Math.min.apply(Math,g);this.maxY=(f>this.maxY)?f:this.maxY;this.minY=(h<this.minY)?h:this.minY},this);var d="";e.rowNames.each(function(f){if(this.ctx.measureText(f).width>this.ctx.measureText(d).width){d=String(f)}},this);this.longestRowName=d;this.data=e},load:function(f){var e=this;var i={onLoad:function(k){return k},};f=Object.merge(i,f||{});var g={onSuccess:function(k){var l=f.onLoad(k);e.setData(l);e.render()}};var d=Object.merge(f,g);var h=new Request.JSON(d);h.GET();return h},getData:function(){return null},draw:function(){return null},drawKey:function(){return null},__getColors:function(p){var d=[];if(p.length==1||p.length==2){var e=new Color(p[0]);var l=(p.length==2)?new Color(p[1]):new Color("#ffffff").mix(p[0],20);var n=[(l[0]-e[0])/this.data.colNames.length,(l[1]-e[1])/this.data.colNames.length,(l[2]-e[2])/this.data.colNames.length];var k=e;for(var g=0;g<this.data.colNames.length;g++){d.push(k.rgbToHex());for(var f=0;f<n.length;f++){k[f]+=parseInt(n[f])}}}else{var o=0;var m=p.slice(0);while(d.length!=this.data.colNames.length){if(m.length===0){m=p.slice(0);o+=20}var h=new Color(m.shift()).mix("#ffffff",o);d.push(h.rgbToHex())}}return d}});c.Column=new Class({Extends:c.Base,options:{columnBorder:false,columnBorderWeight:2,columnBorderColor:"#ffffff",skipLabel:0,labelTicks:false,rowTicks:true,rotateLabels:0,type:"column"},initialize:function(e,d){this.parent(e,d);if(this.element.get("tag")=="table"){this.getData();this.render()}},render:function(){this.ctx.save();this.prepareCanvas();this.rowWidth=this.chartWidth/this.data.rows.length;this.drawAxes();this.drawValueLines();this.draw();if(this.options.showKey){this.drawKey()}this.ctx.restore()},getData:function(){this.element.getElement("thead").getChildren()[0].getChildren().each(function(g){this.data.colNames.push(g.get("html"))}.bind(this));var d="";if(this.element.getElement("tfoot")){this.element.getElement("tfoot").getChildren()[0].getChildren().each(function(h){var g=h.get("html");this.data.rowNames.push(g);if(this.ctx.measureText(g).width>this.ctx.measureText(d).width){d=String(g)}}.bind(this))}this.element.getElement("tbody").getChildren().each(function(h){var g=[];h.getChildren().each(function(i){var k=Number(i.get("html"));if(!typeOf(k)){k=i.get("html").toFloat()}g.push(k);if(k>this.maxY){this.maxY=k}if(k<this.minY){this.minY=k}}.bind(this));this.data.rows.push(g)}.bind(this));if(!this.element.getElement("tfoot")){for(var f=1;f<=this.data.rows.length;f++){var e=this.options.rowPrefix+f;this.data.rowNames.push(e);if(this.ctx.measureText(e).width>d.length){d=String(e)}}}this.longestRowName=d},draw:function(){var i=(this.minY>=0)?this.bounds[1].y:this.bounds[1].y-Math.floor((this.chartHeight/(this.chartLines-1)));var e=new a(this.bounds[0].x,i);var d=Math.floor(this.rowWidth*0.16);var f=Math.ceil((this.rowWidth-(d*2))/this.data.rows[0].length);var g=(this.ctx.measureText(this.longestRowName).width>this.rowWidth)?-1.57079633:0;var h=Math.floor((this.data.rowNames.length*this.options.fontSize)/(this.chartWidth/2));if(this.options.rotateLabels){g=this.options.rotateLabels*Math.PI*-1/180}this.data.rows.each(function(n,k){this.__xAxisLabels(k,g,e);var l=this.bounds[1].y-this.minY*this.ratio;if(this.minY<0){l=this.bounds[1].y+this.minY*this.ratio}if(this.minY>0){l=this.bounds[1].y+this.minY*this.ratio}if(this.minY>0){l=this.bounds[1].y}var m=new a(e.x,l);n.each(function(p,r){this.ctx.beginPath();this.ctx.fillStyle=this.colors[r%this.colors.length];var q=p-this.minY;var o=Math.ceil(q*this.ratio+this.minY*this.ratio)-1;if(this.minY>0){o=Math.ceil(q*this.ratio)-1}this.ctx.fillStyle=this.colors[r];this.ctx.fillRect(m.x+d,m.y-o,f,o);if(this.options.columnBorder){this.ctx.strokeStyle=this.options.columnBorderColor;this.ctx.lineWidth=this.options.columnBorderWeight;this.ctx.strokeRect(e.x+d,m.y-o,f,o)}m.x+=f}.bind(this));e.x+=this.rowWidth}.bind(this))},drawKey:function(){var e=14;var i=0.06;var f=Math.ceil(this.height*i);var h=this.data.colNames.length*f;var d=(this.height-h)/2;var g=10;this.data.colNames.each(function(l,k){this.ctx.fillStyle=this.options.fontColor;this.ctx.textAlign="left";l=c.escape(l);this.ctx.fillText(l,this.keyBounds[0].x+e,d+8);this.ctx.fillStyle=this.colors[k%this.colors.length];this.ctx.fillRect(Math.ceil(this.keyBounds[0].x),Math.ceil(d),g,g);d+=f},this)}});c.Bar=new Class({Extends:c.Column,options:{},initialize:function(e,d){this.parent(e,d)},getValueColumnWidth:function(){var d=14;return this.ctx.measureText(this.longestRowName).width+d},getRowPadding:function(){this.rowPadding=this.height*0.1},drawValueLines:function(){var k=[1,2,5,10,20,50,100,150,500,1000,1500,2000,2500,5000,10000];var d=k[k.length-1];while(this.maxY>d){d+=10000;k.push(d)}var l=9;var h=0;this.chartLines=1;var n=Math.floor((this.maxY-this.minY));while(Math.floor((n/k[h]))>l){h++}this.chartLines=Math.floor((n/k[h]))+2;var g=k[h];this.ratio=(this.chartWidth)/((this.chartLines-1)*g);this.ctx.font=this.options.fontSize+"px "+this.options.font;this.ctx.textAlign="center";this.ctx.fillStyle=this.options.fontColor;var m=Math.ceil(this.chartWidth/(this.chartLines-1));for(h=0;h<this.chartLines;h++){this.ctx.fillStyle=this.options.fontColor;var e=this.bounds[0].x+(h*m);var f=(this.chartLines*g)-((this.chartLines-h)*g)+this.minY;this.ctx.beginPath();e=Math.round(e)+0.5;this.ctx.moveTo(e,this.bounds[0].y);this.ctx.fillText(c.escape(f),e,this.bounds[1].y+14);this.ctx.lineTo(e,this.bounds[1].y+4);this.ctx.stroke()}},draw:function(){var f=new a(this.bounds[0].x,this.bounds[1].y);this.colHeight=Math.round(this.chartHeight/this.data.rows.length);var h=0.16;var d=Math.ceil(this.colHeight*h);var g=Math.ceil((this.colHeight-(d*2))/this.data.rows[0].length);var e=0;this.data.rows.each(function(o,i){var l=new a(f.x,f.y);var k=0;this.ctx.fillStyle=this.options.fontColor;this.ctx.textAlign="center";var n=Math.ceil(this.ctx.measureText(this.data.rowNames[e]).width);if(this.options.showRowNames){var m=c.escape(this.data.rowNames[e]);if(this.data.rows.length*this.options.fontSize>this.chartWidth){if(i%8==1){this.ctx.fillText(m,l.x-((g+n)/2),l.y-(this.rowPadding/2))}}else{this.ctx.fillText(m,l.x-((g+n)/2),l.y-(this.rowPadding/2))}}o.each(function(q){this.ctx.beginPath();this.ctx.fillStyle=this.colors[k];var p=Math.ceil(q*this.ratio);this.ctx.fillRect(l.x,l.y-this.rowPadding,p,g);l.y-=g;k++}.bind(this));f.y-=this.colHeight;e++}.bind(this))}});c.Line=new Class({Extends:c.Column,options:{showTicks:false,showLines:true,tickSize:10,lineWeight:3,skipLabel:0,labelTicks:false,rowTicks:true,rotateLabels:0,},load:function(f){var e=this;var i={onLoad:function(k){return k},};f=Object.merge(i,f||{});var g={noCache:true,onSuccess:function(k){var m=f.onLoad(k);var l=[];m.rows.each(function(o,n){o.each(function(p,q){if(!l[q]){l[q]=[]}l[q][n]=p})});m.rows=l;e.setData(m);e.render()}};var d=Object.merge(f,g);var h=new Request.JSON(d);h.GET();return h},render:function(){this.ctx.save();this.prepareCanvas();this.rowWidth=this.chartWidth/this.data.rows[0].length;this.drawAxes();this.drawValueLines();this.draw();if(this.options.showKey){this.drawKey()}this.ctx.restore()},getData:function(){this.data.rows=[];this.element.getElement("thead").getChildren()[0].getChildren().each(function(g){this.data.colNames.push(g.get("html"));this.data.rows.push([])}.bind(this));var d="";if(this.element.getElement("tfoot")){this.element.getElement("tfoot").getChildren()[0].getChildren().each(function(h){var g=h.get("html");this.data.rowNames.push(g);if(this.ctx.measureText(g).width>d.length){d=String(g)}}.bind(this))}this.element.getElement("tbody").getChildren().each(function(g){g.getChildren().each(function(i,h){var k=Number(i.get("html"));if(!typeOf(k)){k=i.get("html").toFloat()}this.data.rows[h].push(k);if(k>this.maxY){this.maxY=k}if(k<this.minY){this.minY=k}}.bind(this));this.maxY=Math.ceil(this.maxY);this.minY=Math.floor(this.minY)}.bind(this));if(!this.element.getElement("tfoot")){for(var f=1;f<=this.element.getElement("tbody").getChildren().length;f++){var e=this.options.rowPrefix+f;this.data.rowNames.push(e);if(this.ctx.measureText(e).width>d.length){d=String(e)}}}this.longestRowName=d},draw:function(){this.__drawRowLabels();var f=this.bounds[1].y-this.minY*this.ratio;if(this.minY<0){f=this.bounds[1].y+this.minY*this.ratio}if(this.minY>0){f=this.bounds[1].y+this.minY*this.ratio}var e=new a(this.bounds[0].x,f);var h=this.rowWidth/2;var d=0;var i=0;var k=(this.minY>=0)?this.bounds[1].y+(this.minY*this.ratio):this.bounds[1].y-Math.floor((this.chartHeight/(this.chartLines-1)));var g=0;this.data.rows.each(function(o,m){var n;if(this.options.showLines){n=new a(e.x,e.y);this.ctx.lineWidth=this.options.lineWeight;this.ctx.beginPath();this.ctx.strokeStyle=this.colors[m];this.ctx.moveTo(n.x+h,k-(o[0]*this.ratio));o.each(function(r){var q=n.x+h;var p=new a(q,e.y-(r*this.ratio)+0.5);this.ctx.lineTo(p.x,p.y);n.x+=this.rowWidth}.bind(this));this.ctx.stroke()}if(this.options.showTicks){n=new a(e.x,e.y);g=(g>Object.getLength(c.Shapes)-1)?0:g;var l=this.shapes[g];o.each(function(r){var q=n.x+h;var p=new a(q,k-(r*this.ratio));l(this.ctx,p.x,p.y,this.options.tickSize,this.colors[m]);n.x+=this.rowWidth}.bind(this));g++}i++;d++}.bind(this))},drawKey:function(){var f=Math.ceil(this.height*0.05);var h=this.data.colNames.length*f;var d=(this.height-h)/2;var e=0;var g=25;this.data.colNames.each(function(l,k){this.ctx.fillStyle=this.options.fontColor;this.ctx.textAlign="left";this.ctx.fillText(c.escape(l),this.keyBounds[0].x+g,d+5);this.ctx.fillStyle=this.colors[k%this.colors.length];this.ctx.strokeStyle=this.colors[k%this.colors.length];this.ctx.lineWidth=3;if(this.options.showLines){this.ctx.beginPath();this.ctx.moveTo(this.keyBounds[0].x,d+0.5);this.ctx.lineTo(this.keyBounds[0].x+20,d+0.5);this.ctx.closePath();this.ctx.stroke()}if(this.options.showTicks){e=(e>Object.getLength(c.Shapes)-1)?0:e;var i=this.shapes[e];i(this.ctx,this.keyBounds[0].x+10,d,10,this.colors[k%this.colors.length]);e++}d+=f}.bind(this))},__drawRowLabels:function(){var d=new a(this.bounds[0].x,this.bounds[1].y);var e=(this.ctx.measureText(this.longestRowName).width>this.rowWidth)?-1.57079633:0;var f=Math.floor((this.data.rowNames.length*this.options.fontSize)/(this.chartWidth/2));if(this.options.rotateLabels){e=this.options.rotateLabels*Math.PI*-1/180}this.data.rowNames.each(function(h,g){this.__xAxisLabels(g,e,d);d.x+=this.rowWidth}.bind(this))}});c.Scatter=new Class({Extends:c.Line,options:{showTicks:true,showLines:false},initialize:function(e,d){this.parent(e,d)}});c.Pie=new Class({Extends:c.Base,options:{stroke:true,strokeWeight:3,strokeColor:"#ffffff",chartTextColor:"#000000",shadow:false,chartLineWeight:2,pieBorder:false},initialize:function(e,d){this.parent(e,d);if(this.element.get("tag")=="table"){this.rowCount=this.element.getElement("thead").getChildren()[0].getChildren().length;this.colors=this.__getColors(this.options.colors);this.options.showRowNames=false;this.getData();this.render()}},swapAxes:function(){return true},render:function(){this.ctx.save();this.prepareCanvas();this.radius=(this.chartHeight/2);if(this.options.showKey){this.drawKey()}this.draw();this.ctx.restore()},setData:function(g){this.bounds=[new a(),new a(this.width,this.height)];this.colors=this.__getColors(this.options.colors);g.rowNames=g.colNames;var d="";g.rowNames.each(function(h){if(this.ctx.measureText(h).width>this.ctx.measureText(d).width){d=String(h)}},this);this.longestRowName=d;var f=[];var e=0;g.rows.each(function(h){e+=h[0]});g.rows.each(function(k,h){var i=[k[0],(k[0]/e)*360];f.push(i)},this);this.pieTotal=e;g.rows=f;this.data=g},getData:function(){this.element.getElement("thead").getChildren()[0].getChildren().each(function(e){this.data.rowNames.push(e.get("html"));this.data.colNames.push(e.get("html"))}.bind(this));var d=0;this.element.getElement("tbody").getChildren()[0].getChildren().each(function(f){var e=[];var g=f.get("html").toInt();e.push(g);d+=g;this.data.rows.push(e)}.bind(this));this.data.rows.each(function(e){e.push((e[0]/d)*360)});this.pieTotal=d},draw:function(){var f=0;var d=new a((this.bounds[1].x/2)+this.options.padding,(this.bounds[1].y/2)+this.options.padding);if(this.options.shadow){var e=this.ctx.createRadialGradient(d.x,d.y,this.radius,d.x*1.03,d.y*1.03,this.radius*1.05);e.addColorStop(0.5,"#000000");e.addColorStop(0.75,"#000000");e.addColorStop(1,"rgba(0,0,0,0)");this.ctx.fillStyle=e;this.ctx.fillRect(this.bounds[0].x,this.bounds[0].y,this.width,this.height)}this.data.rows.each(function(p,k){this.ctx.fillStyle=this.colors[k%this.colors.length];this.ctx.beginPath();this.ctx.arc(d.x,d.y,this.radius,(Math.PI/180)*f,(Math.PI/180)*(p[1]+f),false);this.ctx.lineTo(d.x,d.y);this.ctx.closePath();this.ctx.fill();if(this.options.stroke){this.ctx.strokeStyle=this.options.strokeColor;this.ctx.lineWidth=this.options.strokeWeight;this.ctx.lineJoin="round";this.ctx.beginPath();this.ctx.arc(d.x,d.y,this.radius,(Math.PI/180)*f,(Math.PI/180)*(p[1]+f),false);this.ctx.lineTo(d.x,d.y);this.ctx.closePath();this.ctx.stroke()}if(this.options.showValues){this.ctx.font=this.options.fontSize+"px "+this.options.font;this.ctx.fillStyle=this.options.chartTextColor;this.ctx.textAlign="center";var g=(Math.PI/180)*(f);var i=(Math.PI/180)*(p[1]+f);var h=g+((i-g)/2);var l=Math.round((p[0]/this.pieTotal)*100);var m=(l<5)?0.9:1.75;var o=this.radius*Math.cos(h)/m;var n=this.radius*Math.sin(h)/m;this.ctx.fillText(l+"%",d.x+o,d.y+n)}f+=p[1]}.bind(this));if(this.options.pieBorder){this.ctx.lineWidth=this.options.chartLineWeight;this.ctx.strokeStyle=this.options.chartLineColor;this.ctx.beginPath();this.ctx.arc(d.x,d.y,this.radius-1,0,Math.PI*2);this.ctx.stroke()}},drawKey:function(){var e=Math.ceil(this.height*0.06);var f=this.data.rowNames.length*e;f=(f>this.height)?this.height*0.9:f;var d=(this.height-f)/2;this.ctx.font=this.options.fontSize+"px "+this.options.font;this.data.rowNames.each(function(h,g){this.ctx.fillStyle=this.options.fontColor;this.ctx.textAlign="left";this.ctx.fillText(c.escape(h),this.keyBounds[0].x+14,d+8);this.ctx.fillStyle=this.colors[g%this.colors.length];this.ctx.fillRect(Math.ceil(this.keyBounds[0].x),Math.ceil(d),10,10);d+=e}.bind(this))}});c.Doughnut=new Class({Extends:c.Base,options:{stroke:true,strokeWeight:1,strokeColor:"#ffffff",chartTextColor:"#000000",shadow:false,chartLineWeight:2,pieBorder:false},initialize:function(e,d){this.parent(e,d);if(this.element.get("tag")=="table"){this.getData();this.rowCount=this.element.getElements("th").length;this.colors=this.__getColors(this.options.colors);this.options.showRowNames=false;this.render()}},swapAxes1:function(){return true},render:function(){this.ctx.save();this.prepareCanvas();this.radius=(this.chartHeight/2);if(this.options.showKey){this.drawKey()}this.draw();this.ctx.restore()},setData:function(f){this.bounds=[new a(),new a(this.width,this.height)];this.colors=this.__getColors(this.options.colors);var d="";f.colNames.each(function(g){if(this.ctx.measureText(g).width>this.ctx.measureText(d).width){d=String(g)}},this);this.longestRowName=d;var e=[];f.totals=[];f.rows.each(function(k,g){var h=0;k.each(function(l){h+=(typeof(l)=="number")?l:l[0]});var i=[];k.each(function(l){var m=(typeof(l)=="number")?l:l[0];i.push([m,(m/h)*360])});e.push(i);f.totals.push(h)});f.rows=e;this.data=f},getData:function(){this.element.getElements("th").each(function(e){this.data.colNames.push(e.get("html"))}.bind(this));var d=this.element.getElements("tbody tr");if(this.element.tfoot){this.element.getElement("tfoot").getChildren().getChildren().each(function(e){this.data.rowNames.push(e.get("html"))}.bind(this))}else{d.each(function(f,e){this.data.rowNames.push(this.options.rowPrefix+e)},this)}this.data.totals=[];d.each(function(h,e){var f=0;h.getElements("td").each(function(i){f+=i.get("html").toInt()});var g=[];h.getElements("td").each(function(i){g.push([i.get("html").toInt(),(i.get("html").toInt()/f)*360])});this.data.rows.push(g);this.data.totals.push(f)},this)},draw:function(){var g=0;var e=new a((this.bounds[1].x/2)+this.options.padding,(this.bounds[1].y/2)+this.options.padding);var f=(this.radius/2)/this.data.rows.length;var d=Number(this.radius);this.data.rows.each(function(i,h){i.each(function(k,l){this.ctx.fillStyle=this.colors[l%this.colors.length];this.ctx.beginPath();this.ctx.arc(e.x,e.y,d,(Math.PI/180)*g,(Math.PI/180)*(k[1]+g),false);this.ctx.lineTo(e.x,e.y);this.ctx.closePath();this.ctx.fill();if(this.options.stroke){this.ctx.strokeStyle=this.options.strokeColor;this.ctx.lineWidth=this.options.strokeWeight;this.ctx.beginPath();this.ctx.arc(e.x,e.y,d,(Math.PI/180)*g,(Math.PI/180)*(k[1]+g),false);this.ctx.lineTo(e.x,e.y);this.ctx.closePath();this.ctx.stroke()}g+=k[1]},this);d-=f;g=0},this);this.ctx.beginPath();this.ctx.fillStyle="#ffffff";this.ctx.arc(e.x,e.y,this.radius/2,0,Math.PI*2);this.ctx.fill()},drawKey:function(){var e=Math.ceil(this.height*0.06);var f=this.data.rowNames.length*e;f=(f>this.height)?this.height*0.9:f;var d=(this.height-f)/2;this.ctx.font=this.options.fontSize+"px "+this.options.font;this.data.colNames.each(function(h,g){this.ctx.fillStyle=this.options.fontColor;this.ctx.textAlign="left";this.ctx.fillText(c.escape(h),this.keyBounds[0].x+14,d+8);this.ctx.fillStyle=this.colors[g%this.colors.length];this.ctx.fillRect(Math.ceil(this.keyBounds[0].x),Math.ceil(d),10,10);d+=e}.bind(this))}});c.Shapes={square:function(e,d,h,g,f){e.fillStyle=f;e.fillRect(d-(g/2),h-(g/2),g,g)},circle:function(e,d,h,g,f){e.fillStyle=f;e.beginPath();e.arc(d,h,g/2,0,(Math.PI/180)*360,true);e.closePath();e.fill()},triangle:function(e,d,i,h,g){e.fillStyle=g;e.beginPath();d-=h/2;i-=h/2;var f=new a(d+h,i+h);e.moveTo(d,f.y);e.lineTo(d+(h/2),i);e.lineTo(f.x,f.y);e.closePath();e.fill()},cross:function(e,d,h,g,f){d-=g/2;h-=g/2;e.strokeStyle=f;e.lineWidth=g/2;e.beginPath();e.moveTo(d,h);e.lineTo(d+g,h+g);e.moveTo(d,h+g);e.lineTo(d+g,h);e.closePath();e.stroke()},diamond:function(e,d,h,g,f){d-=g/2;h-=g/2;e.fillStyle=f;e.beginPath();e.moveTo(d+(g/2),h);e.lineTo(d+g,h+(g/2));e.lineTo(d+(g/2),h+g);e.lineTo(d,h+(g/2));e.closePath();e.fill()},pipe:function(e,d,h,g,f){h-=g/2;e.strokeStyle=f;e.lineWidth=g/2;e.beginPath();e.moveTo(d,h);e.lineTo(d,h+g);e.stroke()}};c.escape=function(e){e=String(e);var d=[[/\&amp;/g,"&"],[/\&lt;/g,"<"],[/\&gt;/g,">"]];d.each(function(f){e=e.replace(f[0],f[1])});return e}})(window);