<?php
if (!defined('_VALID_MOS') && !defined('_JEXEC')) { die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');
}

/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;

require_once($mosConfig_absolute_path . "/components/com_realestatemanager/compat.joomla1.5.php");
require_once ($mosConfig_absolute_path . "/components/com_realestatemanager/realestatemanager.class.php");
require_once ($mosConfig_absolute_path . "/components/com_realestatemanager/functions.php");
require_once ($mosConfig_absolute_path . "/administrator/components/com_realestatemanager/realestatemanager.class.conf.php");
//require_once ($mosConfig_absolute_path . "/administrator/components/com_realestatemanager/realestatemanager.class.others.php");

$GLOBALS['realestatemanager_configuration'] = $realestatemanager_configuration;



if (!defined('_JLEGACY')) {
    $GLOBALS['path'] = $mosConfig_live_site . "/components/com_realestatemanager/images/";
} else {
    $GLOBALS['path'] = $mosConfig_live_site . "/administrator/components/com_realestatemanager/images/";
}
$path = $GLOBALS['path'];


if (version_compare(JVERSION, "1.6.0", "lt")) {
    function com_install() {
        return com_install2();
    }
}

function updateRemConfigurationVersion() {
    global $realestatemanager_configuration, $mosConfig_absolute_path;
    $xml = simplexml_load_file($mosConfig_absolute_path . "/administrator/components/com_realestatemanager/realestatemanager.xml");
    $realestatemanager_configuration['release']['version'] = (string)$xml->version;
    $realestatemanager_configuration['release']['date'] = (string)$xml->creationDate;
    mosRealEstateManagerOthers::setParams();
    unset($xml);
}

function update_to_version_3_6(){
    global $database,$currentVersion,$currentnumber;

    try {

        $database->setQuery("SELECT * FROM #__rem_version");
        $version = $database->loadAssoc();


        if($version['version'] == '3.5' && $version['number'] == 'Free'){
            $query = "ALTER TABLE #__rem_orders
                        ADD COLUMN `fk_houses_htitle` VARCHAR( 255 ) NOT NULL";
            $database->setQuery($query);
            $database->execute();
            $query = "ALTER TABLE #__rem_orders_details
                        ADD COLUMN `fk_houses_htitle` VARCHAR( 255 ) NOT NULL";
            $database->setQuery($query);
            $database->execute();
        }
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{

        echo "Creating table for video source... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_video_source (
        `id` int(11) unsigned NOT NULL auto_increment,
        `fk_house_id`int(11) DEFAULT NULL,
        `sequence_number` int(11) DEFAULT NULL,
        `src` varchar(255) DEFAULT NULL,
        `type` varchar(255) DEFAULT NULL,
        `media`varchar(255) DEFAULT NULL,
        `youtube`varchar(255) DEFAULT NULL,
         FOREIGN KEY (`fk_house_id`) REFERENCES #__rem_houses(`id`),
         PRIMARY KEY (`id`)
        ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        $database->setQuery($query);
        $database->execute();

        if (array_search($database->getPrefix() . "rem_video_source", $database->getTableList(), true))
            echo "[Ok]<br />";
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        echo "Creating table for track source... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_track_source (
            `id` int(11) unsigned NOT NULL auto_increment,
            `fk_house_id`int(11) DEFAULT NULL,
            `sequence_number` int(11) DEFAULT NULL,
            `src` varchar(255) DEFAULT NULL,
            `kind` varchar(255) DEFAULT NULL,
            `scrlang` varchar(255) DEFAULT NULL,
            `label` varchar(255) DEFAULT NULL,
             FOREIGN KEY (`fk_house_id`) REFERENCES #__rem_houses(`id`),
             PRIMARY KEY (`id`)
        ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
        $database->setQuery($query);
        $database->execute();
        if (array_search($database->getPrefix() . "rem_track_source", $database->getTableList(), true))
            echo "[Ok]<br />";
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        //IGNORE deleted dublicate entry
        $query = "ALTER  TABLE #__rem_const
          ADD UNIQUE  const(`const`)";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER  TABLE #__rem_languages
          ADD UNIQUE  lang_code(`lang_code`)";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    return;
}

function update_to_version_3_7(){
    global $database,$currentVersion,$currentnumber;

    try{

        $query = "ALTER  TABLE #__rem_orders_details
          ADD COLUMN `paypal_paykay` VARCHAR( 255 ) NOT NULL  DEFAULT '' ";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER  TABLE #__rem_photos
          ADD COLUMN `img_ordering` int(11) NULL";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query =  "ALTER  TABLE #__rem_houses ADD COLUMN pixUpdtedDt varchar(100) default ''";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }
    
    return;
}

function update_to_version_3_9 () {
    global $database;

    try {

        $query = "CREATE TABLE IF NOT EXISTS `#__rem_users_wishlist` (
                 `id` int(11) NOT NULL auto_increment,
                 `fk_houseid` int(11) DEFAULT NULL,
                 `fk_userid` int(11) DEFAULT NULL,
                  FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`),
                  FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
                  PRIMARY KEY (`id`)
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci";
        $database->setQuery($query);
        $database->execute();

        if (array_search($database->getPrefix() . "rem_users_wishlist", $database->getTableList(), true))
            echo "[Ok]<br />";
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    return;
}

function update_to_version_4_0 () {
    global $database;

    try {
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_mls_for_delete` (
                `id` int(15) NOT NULL AUTO_INCREMENT,
                `mls` varchar(255) DEFAULT NULL,
                PRIMARY KEY (`id`), INDEX (`mls`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

        $database->setQuery($query);
        $database->execute();

        if (array_search($database->getPrefix() . "rem_mls_for_delete", $database->getTableList(), true))
            echo "[Ok]<br />";

    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    return;
}

function update_to_version_4_1 () {

}

function update_to_version_4_2 () {
    global $database;

    try {

        $query = "ALTER TABLE `#__rem_houses` ADD COLUMN `energy_value` FLOAT(3) ";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER TABLE `#__rem_houses` ADD COLUMN `climate_value` FLOAT(3) ";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER TABLE `#__rem_houses` CHANGE `price` `price` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ''";

        $database->setQuery($query);
        $database->execute();

        echo "[Ok]<br />";
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    return;
}

function update_to_version_5_0() {
    global $database;

    try {

        $query = "ALTER TABLE `#__rem_rent_request` ADD `user_phone` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' AFTER `user_email`";
        $database->setQuery($query);
        $database->execute() ;
        echo "Add user_phone to rem_rent_request - [Ok]<br />";
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER TABLE `#__rem_rent` ADD `user_phone` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' AFTER `user_email`";
        $database->setQuery($query);
        $database->execute();
        echo "Add column user_phone to the table rem_rent - [Ok]<br />";
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    return;
}

function update_to_version_5_1() {
    global $database;

    try {

        $query = "ALTER TABLE `#__rem_orders_details` ADD `fk_request_id` int(11) DEFAULT NULL AFTER `paypal_paykay`";
        $database->setQuery($query);
        $database->execute() ;
        echo "Add column fk_request_id to the table rem_orders_details - [Ok]<br />";
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
                
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_mls_for_delete` (
                `id` int(15) NOT NULL AUTO_INCREMENT,
                `mls` varchar(255) DEFAULT NULL,
                PRIMARY KEY (`id`), INDEX (`mls`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        $database->setQuery($query);
        $database->execute() ;
        echo "Add table rem_mls_for_delete to the database - [Ok]<br />";
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }
    
    return;
}

function update_to_version_5_5() {
    global $database;

    try {
        $query = "CREATE TABLE IF NOT EXISTS  `#__rem_api` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `service` varchar(255) NOT NULL,
                `key` text ,
                PRIMARY KEY  (`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2  CHARSET=utf8;";
        $database->setQuery($query);
        $database->execute();   
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    return;
}

function update_to_version_5_6() {
    global $database;

    try {
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_property_request` (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_houseid` int(11) NOT NULL default 0,
                `fk_userid` int(11),
                `property_request` datetime NOT NULL default '0000-00-00 00:00:00',
                `checked_out` int(11) NOT NULL default 0,
                `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
                `customer_name` varchar(250) default '',
                `customer_email` varchar(250) default '',
                `customer_phone` TEXT ,
                `customer_comment` TEXT ,
                `status` int(1) default 0,
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
                FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARSET=utf8;";
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }    

    return;
}

function update_to_version_6_2() {
    global $database;

    try {

        $query = "ALTER TABLE #__rem_rent_request
                        ADD COLUMN how_many_weeks int(5)  default 0,
                        ADD COLUMN how_many_monthes int(5) default 0;";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER TABLE #__rem_rent
                        ADD COLUMN how_many_weeks int(5)  default 0,
                        ADD COLUMN how_many_monthes int(5) default 0;";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = " ALTER TABLE `#__rem_houses` 
                        ADD `rent_by` VARCHAR(10) NOT NULL default '' AFTER `listing_type`";
        $database->setQuery($query);
        $database->execute();    
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    return;
}

function update_to_version_6_3() {
    global $database;

    try {
        //specify the number of rooms for properties, e.g. 2.5, 3.5, 4.5, 5.5 rooms. 
        $query = "ALTER TABLE `#__rem_houses` CHANGE `rooms` `rooms` VARCHAR(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ''";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER TABLE #__rem_houses  
                ADD COLUMN `metadata` TEXT ,  
                ADD COLUMN `publish_up` datetime, 
                ADD COLUMN `publish_down` datetime ";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER TABLE #__rem_main_categories  
                ADD COLUMN `metadata` TEXT ,  
                ADD COLUMN `publish_up` datetime, 
                ADD COLUMN `publish_down` datetime ";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
            //echo "Creating table for sef urls... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_sef_urls` (
            `id` int(11) unsigned NOT NULL auto_increment,
            `ser_url_segments` blob,
            `hash_url_segments` varchar(35) NOT NULL default ''
            `url_last_segment`  varchar(255) NOT NULL default '',
            `hash_last_segment` varchar(35) NOT NULL default '',
            `ser_vars` blob ,
            `hash_vars` varchar(35) NOT NULL default '',
            `lang` varchar(55) NOT NULL default '',
            `date` datetime ,
            `hits` int(11) NOT NULL default '0',
            `published` tinyint(1) NOT NULL default '1',
            PRIMARY KEY  (`id`),
            INDEX (`hash_url_segments`),
            INDEX (`hash_vars`),
            INDEX (`date`),
            INDEX (`date`,`hits`),
            INDEX (`lang`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2  CHARACTER SET utf8 ";
        $database->setQuery($query);
        $database->execute();
    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    return;
}


function update_to_version_6_5() {
    global $database;

    try {
        //specify the number of rooms and bathrooms for properties, e.g. 2.5, 3.5, 4.5, 5.5 rooms. 
        $query = "ALTER TABLE `#__rem_houses` 
            CHANGE `rooms` `rooms` VARCHAR(10) NOT NULL DEFAULT '',
            CHANGE `bathrooms` `bathrooms` VARCHAR(10) NOT NULL DEFAULT ''";
        $database->setQuery($query);
        $database->execute();

    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    return;
}

function update_to_version_6_6() {
    global $database;

    try {

        $query = "ALTER TABLE #__rem_houses  
                ADD COLUMN `extra11` TEXT ,  
                ADD COLUMN `extra12` TEXT ,  
                ADD COLUMN `extra13` TEXT  ";
        $database->setQuery($query);
        $database->execute();
    }
    catch (Exception $e)
    {
        echo $e->getMessage();
    }

    try{
        
        $query = "ALTER TABLE `#__rem_sef_urls` 
                ADD COLUMN `url_last_segment` varchar(255) NOT NULL default '',
                ADD COLUMN `hash_last_segment` varchar(35) NOT NULL default '' ";
        $database->setQuery($query);
        $database->execute();

    } catch (RuntimeException $e) {
        echo $e->getMessage();
    }

    return;
}


function com_install2() {
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $realestatemanager_configuration;
    echo "<br>Checking the PHP version...";

    //**********************   begin check version PHP   ***********************
    $is_warning = false;

    if ((phpversion()) < 5) {
        ?>
        <center>
            <table width="100%" border="0">
                <tr>
                    <td>
                        <code>Installation status: <font color="red">fault</font></code>
                    </td>
                </tr>
                <tr>
                    <td>
                        <code><font color="red">This component works correctly under PHP version 5.0 and higher.</font></code>
                    </td>
                </tr>
            </table>
        </center>

        <?php
        return '<h2><font color="red">Component installation fault</font></h2>';
    }

    //******************   end check version PHP   ******************************

    //******************   begin check xsl extension   *****************
    if (!(class_exists('XsltProcessor'))) {
        $is_warning = true;
        ?>
        <center>
            <table width="100%" border="0">
                <tr>
                    <td>
                        <code><font color="red">XSL extension not found! In order for csv export to work, you need to compile PHP with support for the XSL extension!</font></code>
                    </td>
                </tr>
            </table>
        </center>
        <?php
    }
    echo "Ok<br>Checking XSL extension...";
    //*******************   end check xsl extension   **********************
    
    //******************   begin check php-xml extension   *****************
    if (!(class_exists('domDocument'))) {
        $is_warning = true;
        ?>
        <center>
            <table width="100%" border="0">
                <tr>
                    <td>
                        <code><font color="red">PHP-Xml extension not found! In order for xml export to work, you need to compile PHP with support for the PHP-Xml extension!</font></code>
                    </td>
                </tr>
            </table>
        </center>
        <?php
    }
    echo "Ok<br>Checking PHP-Xml extension...";
    //*******************   end check php-xml extension   **********************

    //********************   begin check CURL extension   ******************
    if (!(function_exists('curl_init'))) {
        $is_warning = true;
        ?>
        <center>
            <table width="100%" border="0">
                <tr>
                    <td>
                        <code><font color="red">CURL extension not found! In order for Photo download to work, you need to compile PHP with support for the CURL extension!</font></code>
                    </td>
                </tr>
            </table>
        </center>
        <?php
    }
    echo "Ok<br>Checking CURL PHP extension...";
    //****************   end check CURL extension   ***********************

    //*************   begin check GD extension   *************************
    if (!(function_exists('imagefontwidth'))) {
        $is_warning = true;
        ?>
        <center>
            <table width="100%" border="0">
                <tr>
                    <td>
                        <code><font color="red">GD extension not found! In order for CAPTCHA picture works correctly, you need to compile PHP with support for the GD extension!</font></code>
                    </td>
                </tr>
            </table>
        </center>
        <?php
    }
    echo "Ok<br>Checking GD PHP extension...";
    //************************   end check GD extension   ******************

    //*************   begin check EXIF PHP extensions   *************************
    if (!(function_exists('exif_read_data'))) {
        $is_warning = true;
        ?>
        <center>
            <table width="100%" border="0">
                <tr>
                    <td>
                        <code><font color="red">EXIF PHP extensions not found! In order for rotate JPG picture works correctly, you need to compile PHP with support for the EXIF extension!</font></code>
                    </td>
                </tr>
            </table>
        </center>
        <?php
    }
    echo "Ok<br>Checking EXIF PHP extension...";
    //************************   end check EXIF PHP extensions   ******************

    //*************   begin check FileInfo extension   *************************
    if (!(function_exists('mime_content_type'))) {
        $is_warning = true;
        ?>
        <center>
            <table width="100%" border="0">
                <tr>
                    <td>
                        <code><font color="red">FileInfo PHP extension not found! In order for Files mime check works correctly, you need to compile PHP with support for the FileInfo extension!</font></code>
                    </td>
                </tr>
            </table>
        </center>
        <?php
    }
    echo "Ok<br>Checking FileInfo PHP extension...";
    //************************   end check FileInfo extension   ******************  

    echo "Ok<br>Installing database...";

    //******************   database ******************

    $tableList = $database->getTableList();
    echo 'cheking database<br/>';

    $table_prefix = $database->getPrefix(); 

    echo 'cheking database<br/>';
    if (array_search($table_prefix . 'rem_version', $tableList)) {
        $database->setQuery("SELECT * FROM #__rem_version");
        $version = $database->loadAssoc();
    }

    if (array_search($table_prefix . 'rem_houses', $tableList)) {
        $database->setQuery("SELECT * FROM #__rem_houses");
        $reallibr = $database->loadResult();
    }
    else
        $reallibr = '';
    
    if ($reallibr) {
        echo 'database already exist<br/>';

        $tmp_ver = explode('.',$version['version'] );
        if(count($tmp_ver) > 1 )   $tmp_ver2 = $tmp_ver[0] . '.' .  $tmp_ver[1] ;
        else $tmp_ver2 = $tmp_ver[0] ;

        switch ($tmp_ver2) {        
            case 2.1:
                $query = "ALTER TABLE #__rem_houses
                    ADD COLUMN hzipcode varchar(50) NOT NULL default '',
                    ADD COLUMN area_unit varchar(45) default '',
                    ADD COLUMN land_area varchar(45) default '',
                    ADD COLUMN land_area_unit varchar(45) default '',
                    ADD COLUMN featured_shows varchar(100) default '',
                    ADD COLUMN featured_clicks varchar(100) default ''";


                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_main_categories
                    ADD COLUMN `language` varchar(250) default '*'";
                $database->setQuery($query);
                $database->execute();


                $query = "CREATE TABLE IF NOT EXISTS `#__rem_rent_sal` (
        		`id` int(11) unsigned NOT NULL auto_increment,
        		`fk_houseid` int(11),
        		`monthW` int(4) NOT NULL default 0,
        		`yearW` int(4) NOT NULL default 0,
        		`week` varchar(1250) default '',
        		`weekend` varchar(1250) default '',
        		`midweek` varchar(1250) default '',
                `price_from` DATE NOT NULL ,
                `price_to` DATE NOT NULL ,
                `special_price` FLOAT NOT NULL ,
                `comment_price` VARCHAR( 1000 ) NOT NULL ,
                `priceunit` VARCHAR( 255 ) NOT NULL,
		 PRIMARY KEY  (`id`)
		) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
                $database->setQuery($query);
                $database->execute();


                $query = "ALTER TABLE #__rem_houses
                    ADD COLUMN `extra1` varchar(250) default '',
                    ADD COLUMN `extra2` varchar(250) default '',
                    ADD COLUMN `extra3` varchar(250) default '',
                    ADD COLUMN `extra4` varchar(250) default '',
                    ADD COLUMN `extra5` varchar(250) default '',
                    ADD COLUMN `extra6` varchar(250) default '',
                    ADD COLUMN `extra7` varchar(250) default '',
                    ADD COLUMN `extra8` varchar(250) default '',
                    ADD COLUMN `extra9` varchar(250) default '',
                    ADD COLUMN `extra10` varchar(250) default '',
                    ADD COLUMN `language` varchar(250) default '',
                    ADD COLUMN `owner_id` int(9) default 0,
                    ADD COLUMN `rooms` int(11) default null,
                    ADD COLUMN `house_size` varchar(50) default '',
                    ADD COLUMN `garages` varchar(50) default ''";

                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_feature_houses (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_houseid` int(11) NOT NULL default 0,
                `fk_featureid` int(11) NOT NULL default 0,
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`),
                FOREIGN KEY (`fk_featureid`) REFERENCES #__rem_feature(`id`),
                INDEX (`fk_houseid`,`fk_featureid`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_const (
                `id` int(11) unsigned NOT NULL auto_increment,
                `const` varchar(250) default '',
                `sys_type` varchar(250) default '',
                PRIMARY KEY  (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_languages (
                `id` int(11) unsigned NOT NULL auto_increment,
                `lang_code` char(7),
                `title` varchar(250) default '',
                `sef` char(7),
                PRIMARY KEY  (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_const_languages (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_constid` int(11) NOT NULL default 0,
                `fk_languagesid` int(11) NOT NULL default 0,
                `value_const` varchar(2000) default '',
                PRIMARY KEY  (`id`),
                UNIQUE (`fk_constid`,`fk_languagesid`),
                FOREIGN KEY (`fk_constid`) REFERENCES #__rem_const(`id`),
                FOREIGN KEY (`fk_languagesid`) REFERENCES #__rem_languages(`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();


                  $query = " CREATE TABLE IF NOT EXISTS `#__rem_mime_types` (
                    `mime_ext` text,
                    `mime_type` text
                  ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `fk_user_id` int(11) DEFAULT NULL,
              `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
              `email` varchar(255) NOT NULL DEFAULT '',
              `name` varchar(255) NOT NULL DEFAULT '',
              `status` varchar(255) NOT NULL DEFAULT '',
              `order_date` DATETIME,
              `fk_house_id` int(11) DEFAULT NULL,
              `txn_type` varchar(255) NOT NULL DEFAULT '',
              `txn_id` varchar(255) NOT NULL DEFAULT '',
              `payer_id` varchar(255) NOT NULL DEFAULT '',
              `payer_status` varchar(255) NOT NULL DEFAULT '',
              `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
              `order_price` int(11) DEFAULT NULL,
              `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8; ";
                $database->setQuery($query);
                $database->execute();

            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders_details` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `fk_order_id` int(11) DEFAULT NULL,
                `fk_user_id` int(11) DEFAULT NULL,
                `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
                `email` varchar(255) NOT NULL DEFAULT '',
                `name` varchar(255) NOT NULL DEFAULT '',
                `status` varchar(255) NOT NULL DEFAULT '',
                `order_date` DATETIME,
                `fk_house_id` int(11) DEFAULT NULL,
                `txn_type` varchar(255) NOT NULL DEFAULT '',
                `txn_id` varchar(255) NOT NULL DEFAULT '',
                `payer_id` varchar(255) NOT NULL DEFAULT '',
                `payer_status` varchar(255) NOT NULL DEFAULT '',
                `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
                `order_price` int(11) DEFAULT NULL,
                `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                `payment_details` text ,
                PRIMARY KEY (`id`)
             ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $database->setQuery($query);
                $database->execute();


                $query = "ALTER TABLE #__rem_houses ADD COLUMN `associate_house` varchar(255) default null";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_main_categories ADD COLUMN `associate_category` varchar(255) default null";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_rent_sal
                          ADD COLUMN `price_from` DATE NOT NULL,
                          ADD COLUMN `price_to` DATE NOT NULL ,
                          ADD COLUMN `special_price` FLOAT NOT NULL ,
                          ADD COLUMN `comment_price` VARCHAR( 1000 ) NOT NULL ,
                          ADD COLUMN `priceunit` VARCHAR( 255 ) NOT NULL";
                $database->setQuery($query);
                $database->execute();

                update_to_version_3_6();
                update_to_version_3_7();
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

                break;
            case 2.2:

                $query = "CREATE TABLE IF NOT EXISTS `#__rem_rent_sal` (
        		`id` int(11) unsigned NOT NULL auto_increment,
        		`fk_houseid` int(11),
        		`monthW` int(4) NOT NULL default 0,
        		`yearW` int(4) NOT NULL default 0,
        		`week` varchar(1250) default '',
        		`weekend` varchar(1250) default '',
        		`midweek` varchar(1250) default '',
        		`price_from` DATE NOT NULL ,
                `price_to` DATE NOT NULL ,
                `special_price` FLOAT NOT NULL ,
                `comment_price` VARCHAR( 1000 ) NOT NULL ,
                `priceunit` VARCHAR( 255 ) NOT NULL,
		 PRIMARY KEY  (`id`)
		) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_houses
                    ADD COLUMN `extra1` varchar(250) default '',
                    ADD COLUMN `extra2` varchar(250) default '',
                    ADD COLUMN `extra3` varchar(250) default '',
                    ADD COLUMN `extra4` varchar(250) default '',
                    ADD COLUMN `extra5` varchar(250) default '',
                    ADD COLUMN `extra6` varchar(250) default '',
                    ADD COLUMN `extra7` varchar(250) default '',
                    ADD COLUMN `extra8` varchar(250) default '',
                    ADD COLUMN `extra9` varchar(250) default '',
                    ADD COLUMN `extra10` varchar(250) default '',
                    ADD COLUMN `language` varchar(250) default '*',
                    ADD COLUMN `owner_id` int(9) default 0,
                    ADD COLUMN `rooms` int(11) default null,
                    ADD COLUMN `house_size` varchar(50) default '',
                    ADD COLUMN `garages` varchar(50) default ''";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_main_categories
                    ADD COLUMN `language` varchar(250) default '*'";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_feature_houses (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_houseid` int(11) NOT NULL default 0,
                `fk_featureid` int(11) NOT NULL default 0,
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`),
                FOREIGN KEY (`fk_featureid`) REFERENCES #__rem_feature(`id`),
                INDEX (`fk_houseid`,`fk_featureid`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_const (
                `id` int(11) unsigned NOT NULL auto_increment,
                `const` varchar(250) default '',
                `sys_type` varchar(250) default '',
                PRIMARY KEY  (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = " CREATE TABLE IF NOT EXISTS `#__rem_mime_types` (
            `mime_ext` text,
            `mime_type` text
          ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_languages (
                `id` int(11) unsigned NOT NULL auto_increment,
                `lang_code` char(7),
                `title` varchar(250) default '',
                `sef` char(7),
                PRIMARY KEY  (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_const_languages (
                        `id` int(11) unsigned NOT NULL auto_increment,
                        `fk_constid` int(11) NOT NULL default 0,
                        `fk_languagesid` int(11) NOT NULL default 0,
                        `value_const` varchar(2000) default '',
                        PRIMARY KEY  (`id`),
                        UNIQUE (`fk_constid`,`fk_languagesid`),
                        FOREIGN KEY (`fk_constid`) REFERENCES #__rem_const(`id`),
                        FOREIGN KEY (`fk_languagesid`) REFERENCES #__rem_languages(`id`)
                        ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `fk_user_id` int(11) DEFAULT NULL,
              `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
              `email` varchar(255) NOT NULL DEFAULT '',
              `name` varchar(255) NOT NULL DEFAULT '',
              `status` varchar(255) NOT NULL DEFAULT '',
              `order_date` DATETIME,
              `fk_house_id` int(11) DEFAULT NULL,
              `txn_type` varchar(255) NOT NULL DEFAULT '',
              `txn_id` varchar(255) NOT NULL DEFAULT '',
              `payer_id` varchar(255) NOT NULL DEFAULT '',
              `payer_status` varchar(255) NOT NULL DEFAULT '',
              `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
              `order_price` int(11) DEFAULT NULL,
              `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8; ";
                $database->setQuery($query);
                $database->execute();

            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders_details` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `fk_order_id` int(11) DEFAULT NULL,
                `fk_user_id` int(11) DEFAULT NULL,
                `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
                `email` varchar(255) NOT NULL DEFAULT '',
                `name` varchar(255) NOT NULL DEFAULT '',
                `status` varchar(255) NOT NULL DEFAULT '',
                `order_date` DATETIME,
                `fk_house_id` int(11) DEFAULT NULL,
                `txn_type` varchar(255) NOT NULL DEFAULT '',
                `txn_id` varchar(255) NOT NULL DEFAULT '',
                `payer_id` varchar(255) NOT NULL DEFAULT '',
                `payer_status` varchar(255) NOT NULL DEFAULT '',
                `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
                `order_price` int(11) DEFAULT NULL,
                `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                `payment_details` text ,
                PRIMARY KEY (`id`)
             ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_houses ADD COLUMN `associate_house` varchar(255) default null";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_main_categories ADD COLUMN `associate_category` varchar(255) default null";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_rent_sal
                          ADD COLUMN `price_from` DATE NOT NULL,
                          ADD COLUMN `price_to` DATE NOT NULL ,
                          ADD COLUMN `special_price` FLOAT NOT NULL ,
                          ADD COLUMN `comment_price` VARCHAR( 1000 ) NOT NULL ,
                          ADD COLUMN `priceunit` VARCHAR( 255 ) NOT NULL";
                $database->setQuery($query);
                $database->execute();

                update_to_version_3_6();
                update_to_version_3_7();
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();


                break;
            case 2.3:

                $query = "ALTER TABLE #__rem_houses
                    ADD COLUMN `extra1` varchar(250) default '',
                    ADD COLUMN `extra2` varchar(250) default '',
                    ADD COLUMN `extra3` varchar(250) default '',
                    ADD COLUMN `extra4` varchar(250) default '',
                    ADD COLUMN `extra5` varchar(250) default '',
                    ADD COLUMN `extra6` varchar(250) default '',
                    ADD COLUMN `extra7` varchar(250) default '',
                    ADD COLUMN `extra8` varchar(250) default '',
                    ADD COLUMN `extra9` varchar(250) default '',
                    ADD COLUMN `extra10` varchar(250) default '',
                    ADD COLUMN `language` varchar(250) default '*',
                    ADD COLUMN `owner_id` int(9) default 0";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_main_categories
                    ADD COLUMN `language` varchar(250) default '*'";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_feature_houses (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_houseid` int(11) NOT NULL default 0,
                `fk_featureid` int(11) NOT NULL default 0,
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`),
                FOREIGN KEY (`fk_featureid`) REFERENCES #__rem_feature(`id`),
                INDEX (`fk_houseid`,`fk_featureid`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_const (
                `id` int(11) unsigned NOT NULL auto_increment,
                `const` varchar(250) default '',
                `sys_type` varchar(250) default '',
                PRIMARY KEY  (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_languages (
                `id` int(11) unsigned NOT NULL auto_increment,
                `lang_code` char(7),
                `title` varchar(250) default '',
                `sef` char(7),
                PRIMARY KEY  (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS #__rem_const_languages (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_constid` int(11) NOT NULL default 0,
                `fk_languagesid` int(11) NOT NULL default 0,
                `value_const` varchar(2000) default '',
                PRIMARY KEY  (`id`),
                UNIQUE (`fk_constid`,`fk_languagesid`),
                FOREIGN KEY (`fk_constid`) REFERENCES #__rem_const(`id`),
                FOREIGN KEY (`fk_languagesid`) REFERENCES #__rem_languages(`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
                $database->setQuery($query);
                $database->execute();

            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `fk_user_id` int(11) DEFAULT NULL,
              `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
              `email` varchar(255) NOT NULL DEFAULT '',
              `name` varchar(255) NOT NULL DEFAULT '',
              `status` varchar(255) NOT NULL DEFAULT '',
              `order_date` DATETIME,
              `fk_house_id` int(11) DEFAULT NULL,
              `txn_type` varchar(255) NOT NULL DEFAULT '',
              `txn_id` varchar(255) NOT NULL DEFAULT '',
              `payer_id` varchar(255) NOT NULL DEFAULT '',
              `payer_status` varchar(255) NOT NULL DEFAULT '',
              `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
              `order_price` int(11) DEFAULT NULL,
              `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8; ";
                $database->setQuery($query);
                $database->execute();

            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders_details` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `fk_order_id` int(11) DEFAULT NULL,
                `fk_user_id` int(11) DEFAULT NULL,
                `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
                `email` varchar(255) NOT NULL DEFAULT '',
                `name` varchar(255) NOT NULL DEFAULT '',
                `status` varchar(255) NOT NULL DEFAULT '',
                `order_date` DATETIME,
                `fk_house_id` int(11) DEFAULT NULL,
                `txn_type` varchar(255) NOT NULL DEFAULT '',
                `txn_id` varchar(255) NOT NULL DEFAULT '',
                `payer_id` varchar(255) NOT NULL DEFAULT '',
                `payer_status` varchar(255) NOT NULL DEFAULT '',
                `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
                `order_price` int(11) DEFAULT NULL,
                `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                `payment_details` text ,
                PRIMARY KEY (`id`)
             ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_houses ADD COLUMN `associate_house` varchar(255) default null,
                          ADD COLUMN `rooms` int(11) default null,
                          ADD COLUMN `house_size` varchar(50) default '',
                          ADD COLUMN `garages` varchar(50) default ''";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_main_categories ADD COLUMN `associate_category` varchar(255) default null";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_rent_sal
                          ADD COLUMN `price_from` DATE NOT NULL,
                          ADD COLUMN `price_to` DATE NOT NULL ,
                          ADD COLUMN `special_price` FLOAT NOT NULL ,
                          ADD COLUMN `comment_price` VARCHAR( 1000 ) NOT NULL ,
                          ADD COLUMN `priceunit` VARCHAR( 255 ) NOT NULL";
                $database->setQuery($query);
                $database->execute();

                update_to_version_3_6();
                update_to_version_3_7();
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

                break;
            case 3.0:
//added in 3.3
            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `fk_user_id` int(11) DEFAULT NULL,
              `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
              `email` varchar(255) NOT NULL DEFAULT '',
              `name` varchar(255) NOT NULL DEFAULT '',
              `status` varchar(255) NOT NULL DEFAULT '',
              `order_date` DATETIME,
              `fk_house_id` int(11) DEFAULT NULL,
              `txn_type` varchar(255) NOT NULL DEFAULT '',
              `txn_id` varchar(255) NOT NULL DEFAULT '',
              `payer_id` varchar(255) NOT NULL DEFAULT '',
              `payer_status` varchar(255) NOT NULL DEFAULT '',
              `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
              `order_price` int(11) DEFAULT NULL,
              `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=utf8; ";
                $database->setQuery($query);
                $database->execute();

            $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders_details` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `fk_order_id` int(11) DEFAULT NULL,
                `fk_user_id` int(11) DEFAULT NULL,
                `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
                `email` varchar(255) NOT NULL DEFAULT '',
                `name` varchar(255) NOT NULL DEFAULT '',
                `status` varchar(255) NOT NULL DEFAULT '',
                `order_date` DATETIME,
                `fk_house_id` int(11) DEFAULT NULL,
                `txn_type` varchar(255) NOT NULL DEFAULT '',
                `txn_id` varchar(255) NOT NULL DEFAULT '',
                `payer_id` varchar(255) NOT NULL DEFAULT '',
                `payer_status` varchar(255) NOT NULL DEFAULT '',
                `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
                `order_price` int(11) DEFAULT NULL,
                `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                `payment_details` text ,
                PRIMARY KEY (`id`)
             ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_houses
                ADD COLUMN `associate_house` varchar(255) default null,
                ADD COLUMN `rooms` int(11) default null,
                ADD COLUMN `house_size` varchar(50) default '',
                ADD COLUMN `garages` varchar(50) default ''";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_main_categories ADD COLUMN `associate_category` varchar(255) default null";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_rent_sal
                          ADD COLUMN `price_from` DATE NOT NULL,
                          ADD COLUMN `price_to` DATE NOT NULL ,
                          ADD COLUMN `special_price` FLOAT NOT NULL ,
                          ADD COLUMN `comment_price` VARCHAR( 1000 ) NOT NULL ,
                          ADD COLUMN `priceunit` VARCHAR( 255 ) NOT NULL";
                $database->setQuery($query);
                $database->execute();

                update_to_version_3_6();
                update_to_version_3_7();
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

                break;
            case 3.3:
                //added in 3.5

                $query = "ALTER TABLE #__rem_houses
                    ADD COLUMN `rooms` int(11) default null,
                    ADD COLUMN `house_size` varchar(50) default '',
                    ADD COLUMN `garages` varchar(50) default ''";
                $database->setQuery($query);
                $database->execute();

                $query = "ALTER TABLE #__rem_orders
                    CHANGE `data` `order_date` DATETIME ,
                    CHANGE `fk_vehicle_id` `fk_house_id` INT( 11 ) NULL DEFAULT NULL ,
                    ADD COLUMN `order_currency_code` VARCHAR( 255 ) NOT NULL ,
                    ADD COLUMN `order_price` INT( 11 ) DEFAULT NULL AFTER `payer_status`,
                    ADD COLUMN `fk_houses_htitle` VARCHAR( 255 ) NOT NULL ,
                    ADD COLUMN `order_calculated_price` VARCHAR( 255 ) DEFAULT NULL ";
                $database->setQuery($query);
                $database->execute();

                $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders_details` (
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `fk_order_id` int(11) DEFAULT NULL,
                    `fk_user_id` int(11) DEFAULT NULL,
                    `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
                    `email` varchar(255) NOT NULL DEFAULT '',
                    `name` varchar(255) NOT NULL DEFAULT '',
                    `status` varchar(255) NOT NULL DEFAULT '',
                    `order_date` DATETIME,
                    `fk_house_id` int(11) DEFAULT NULL,
                    `txn_type` varchar(255) NOT NULL DEFAULT '',
                    `txn_id` varchar(255) NOT NULL DEFAULT '',
                    `payer_id` varchar(255) NOT NULL DEFAULT '',
                    `payer_status` varchar(255) NOT NULL DEFAULT '',
                    `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
                    `order_price` int(11) DEFAULT NULL,
                    `order_currency_code` varchar(255) NOT NULL DEFAULT '',
                    `payment_details` text ,
                    PRIMARY KEY (`id`)
                 ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
                $database->setQuery($query);
                $database->execute();

                update_to_version_3_6();
                update_to_version_3_7();
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();
                
            break;

            case 3.5:
                update_to_version_3_6();
                update_to_version_3_7();
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

              break;

            case 3.6:
                update_to_version_3_7();
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

                break;

            case 3.7:
            case 3.8:
                update_to_version_3_9();
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

                break;

            case 3.9:
                update_to_version_4_0();
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

                break;

            case 4.0:
                update_to_version_4_1();
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();
            break;

            case 4.1:
                update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

            break;

            case 4.2:
                // update_to_version_4_2();
                update_to_version_5_0();
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();
                
            break;

            case 5.0:
                update_to_version_5_1();
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

            break;

            case 5.1:
                update_to_version_5_5();
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();
                
            break;

            case 5.5:
                update_to_version_5_6();
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();

            break;
            case 5.6:
            case 6.0:
            case 6.1:
                update_to_version_6_2();
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();
            break;
            case 6.2:
                update_to_version_6_3();
                update_to_version_6_5();
                update_to_version_6_6();
            break;            
            case 6.3:
            case 6.4:
                update_to_version_6_5();
                update_to_version_6_6();

            break;
            case 6.5:
                update_to_version_6_6();

            break;
            default:
                echo "Updated";
                break;
                echo 'end upgrading database';
        }

        updateRemConfigurationVersion();
        $vers = explode(' ', $realestatemanager_configuration['release']['version']);
        $versi = substr($vers[0],0,3);

        $query = "UPDATE #__rem_version
                  SET version = '" . $versi . "', number = '" . $vers[1] . "'
                  WHERE id = 2";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }

    } else {
    // If database doesnt exists, create it
        echo '<br/>install database <br/>';
        $query = "DROP TABLE IF EXISTS `#__rem_const`, `#__rem_languages`, 
            `#__rem_const_languages`, `#__rem_feature`, `#__rem_feature_houses`,
            `#__rem_rent_sal`, `#__rem_rent`, `#__rem_rent_request`, 
            `#__rem_buying_request`,`#__rem_review`, `#__rem_suggestion`,
            `#__rem_categories`, `#__rem_photos`, `#__rem_version`, `#__rem_houses`,
            `#__rem_main_categories`,`#__rem_mime_types`, `#__rem_orders`, `#__rem_orders_details`,  
            `#__rem_users_wishlist`, `#__rem_mls_for_delete`, `#__rem_api`, 
            `#__rem_property_request`, #__rem_sef_urls" ;
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
            

        // 
        echo "Creating table for main_categories... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_main_categories` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `parent_id` int(11) NOT NULL DEFAULT '0',
            `associate_category` varchar(255) default null,
            `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
            `title` varchar(255) NOT NULL DEFAULT '',
            `name` varchar(255) NOT NULL DEFAULT '',
            `alias` varchar(255) NOT NULL DEFAULT '',
            `image` varchar(255) NOT NULL DEFAULT '',
            `section` varchar(50) NOT NULL DEFAULT '',
            `image_position` varchar(30) NOT NULL DEFAULT '',
            `description` text ,
            `published` tinyint(1) NOT NULL DEFAULT '0',
            `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
            `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
            `editor` varchar(50) DEFAULT NULL,
            `ordering` int(11) NOT NULL DEFAULT '0',
            `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
            `count` int(11) NOT NULL DEFAULT '0',
            `params` text ,
            `params2` text ,
            `language` varchar(50) DEFAULT '*',
            metadata TEXT,  
            publish_up datetime,
            publish_down datetime,            
            PRIMARY KEY (`id`),
            KEY `cat_idx` (`section`,`published`,`access`),
            KEY `idx_access` (`access`),
            KEY `idx_checkout` (`checked_out`)
          ) ENGINE=MyISAM  DEFAULT  COLLATE utf8_general_ci AUTO_INCREMENT=46 ; ";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_main_categories", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for houses... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_houses (
              id int(11) unsigned NOT NULL auto_increment,
              asset_id int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
              houseid varchar(20) NOT NULL default '0',
              catid int(11) NOT NULL default '0',
              sid int(11) NOT NULL default '0',
              fk_rentid int(11) default '0',
              associate_house varchar(255) default null,

              description text ,
              link varchar(250) NOT NULL default '',
              listing_type varchar(45) NOT NULL default '',
              rent_by varchar(10) NOT NULL default '',
              price varchar(255) NOT NULL default '',
              priceunit varchar(14) NOT NULL default '',
              htitle varchar(200) NOT NULL default '',

              hcountry varchar(50) NOT NULL default '',
              hregion varchar(50) NOT NULL default '',
              hcity varchar(50) NOT NULL default '',
              hzipcode varchar(50) NOT NULL default '',
              hlocation varchar(100) NOT NULL default '',
              hlatitude varchar(20) NOT NULL default '',
              hlongitude varchar(20) NOT NULL default '',
              map_zoom varchar(5) NOT NULL default '',

              rooms  VARCHAR(10) NOT NULL DEFAULT '',
              bathrooms  VARCHAR(10) NOT NULL DEFAULT '',
              bedrooms int(11) default '0',
              contacts varchar(250) default '',
              image_link varchar(200) default '',
              listing_status varchar(45) default '',
              property_type varchar(45) default '',
              year varchar(4) default '',

              agent varchar(45) default '',
              area_unit varchar(45) default '',
              land_area varchar(45) default '',
              land_area_unit varchar(45) default '',
              expiration_date date ,
              lot_size varchar(45) default '',
              house_size varchar(45) default '',
              garages varchar(50) default '',

              `checked_out` int(11) NOT NULL default '0',
              `checked_out_time` datetime ,
              `ordering` int(11) NOT NULL default '0',
              `date` datetime ,
              `hits` int(11) NOT NULL default '0',
              `edok_link` varchar(200) default '',
              `published` tinyint(1) NOT NULL default '0',
              `approved` tinyint(1) NOT NULL default '1',
              `owneremail` VARCHAR(50) default '',
              `featured_clicks` varchar(100) default '',
              `featured_shows` varchar(100) default '',
              `pixUpdtedDt` varchar(100) default '',

              `extra1` varchar(250) default '',
              `extra2` varchar(250) default '',
              `extra3` varchar(250) default '',
              `extra4` varchar(250) default '',
              `extra5` varchar(250) default '',
              `extra6` varchar(250) default '',
              `extra7` varchar(250) default '',
              `extra8` varchar(250) default '',
              `extra9` varchar(250) default '',
              `extra10` varchar(250) default '',
              `extra11` TEXT ,  
              `extra12` TEXT ,  
              `extra13` TEXT  ,
              `language` varchar(250) default '*',
              `owner_id` int(9) default 0,
              `energy_value` FLOAT ,
              `climate_value` FLOAT ,
                metadata TEXT,  
                publish_up datetime,
                publish_down datetime,      

              PRIMARY KEY  (`id`),
              INDEX (`catid`, `houseid`)

              ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_houses", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for photos... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_photos` (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_houseid` int(11),
              `thumbnail_img` varchar(250) default '',
              `main_img` varchar(250) default '',
              `img_ordering` int(11) NULL,
              PRIMARY KEY  (`id`),
              FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`)
              ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_photos", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;


        echo "Creating table for rent... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_rent` (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_houseid` int(11) NOT NULL default 0,
              `fk_userid` int(11),
              `rent_from` datetime NOT NULL default '0000-00-00 00:00:00',
              `rent_until` datetime,
              `rent_return` datetime,
              `checked_out` int(11) NOT NULL default 0,
              `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
              `user_name` VARCHAR(150),
              `user_email` VARCHAR(100),
              `user_phone` VARCHAR(250) DEFAULT '',
              `user_mailing` TEXT ,
              `how_many_weeks` int(5)  default 0,
              `how_many_monthes` int(5) default 0,
              PRIMARY KEY  (`id`),
              FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
              FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`)
              ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_rent", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for rent_request... ";  // --
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_rent_request` (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_houseid` int(11) NOT NULL default 0,
              `fk_userid` int(11),
              `rent_from` date NOT NULL default '0000-00-00',
              `rent_until` date,
              `rent_request` datetime NOT NULL default '0000-00-00 00:00:00',
              `checked_out` int(11) NOT NULL default 0,
              `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
              `user_name` VARCHAR(150),
              `user_email` VARCHAR(100),
              `user_phone` VARCHAR(250) DEFAULT '',
              `user_mailing` TEXT ,
              `status` int(1) default 0,
              `how_many_weeks` int(5)  default 0,
              `how_many_monthes` int(5) default 0,
              PRIMARY KEY  (`id`),
              FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
              FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`)
              ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_rent_request", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for buying_request... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_buying_request` (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_houseid` int(11) NOT NULL default 0,
                `fk_userid` int(11),
                `buying_request` datetime NOT NULL default '0000-00-00 00:00:00',
                `checked_out` int(11) NOT NULL default 0,
                `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
                `customer_name` varchar(250) default '',
                `customer_email` varchar(250) default '',
                `customer_phone` TEXT ,
                `customer_comment` TEXT ,
                `status` int(1) default 0,
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
                FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_buying_request", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;


        echo "Creating table for orders... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `fk_user_id` int(11) DEFAULT NULL,
          `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
          `email` varchar(255) NOT NULL DEFAULT '',
          `name` varchar(255) NOT NULL DEFAULT '',
          `status` varchar(255) NOT NULL DEFAULT '',
          `order_date` DATETIME,
          `fk_house_id` int(11) DEFAULT NULL,
          `txn_type` varchar(255) NOT NULL DEFAULT '',
          `txn_id` varchar(255) NOT NULL DEFAULT '',
          `payer_id` varchar(255) NOT NULL DEFAULT '',
          `payer_status` varchar(255) NOT NULL DEFAULT '',
          `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
          `order_price` int(11) DEFAULT NULL,
          `order_currency_code` varchar(255) NOT NULL DEFAULT '',
          `paypal_paykay` varchar(255) NOT NULL DEFAULT '',
            PRIMARY KEY (`id`)
        ) ENGINE=MyISAM  DEFAULT CHARSET=utf8; ";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
            catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_orders", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else  exit;

        echo "Creating table for orders details... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_orders_details` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `fk_order_id` int(11) DEFAULT NULL,
            `fk_user_id` int(11) DEFAULT NULL,
            `fk_houses_htitle` varchar(255) NOT NULL DEFAULT '',
            `email` varchar(255) NOT NULL DEFAULT '',
            `name` varchar(255) NOT NULL DEFAULT '',
            `status` varchar(255) NOT NULL DEFAULT '',
            `order_date` DATETIME,
            `fk_house_id` int(11) DEFAULT NULL,
            `txn_type` varchar(255) NOT NULL DEFAULT '',
            `txn_id` varchar(255) NOT NULL DEFAULT '',
            `payer_id` varchar(255) NOT NULL DEFAULT '',
            `payer_status` varchar(255) NOT NULL DEFAULT '',
            `order_calculated_price` varchar(255) NOT NULL DEFAULT '',
            `order_price` int(11) DEFAULT NULL,
            `order_currency_code` varchar(255) NOT NULL DEFAULT '',
            `payment_details` text ,
            `paypal_paykay` varchar(255) NOT NULL DEFAULT '',
            `fk_request_id` int(11) DEFAULT NULL,
            PRIMARY KEY (`id`)
         ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_orders", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else  exit;

        echo "Creating table for video source... ";
          $query = "CREATE TABLE IF NOT EXISTS #__rem_video_source (
            `id` int(11) unsigned NOT NULL auto_increment,
            `fk_house_id`int(11) DEFAULT NULL,
            `sequence_number` int(11) DEFAULT NULL,
            `src` varchar(255) DEFAULT NULL,
            `type` varchar(255) DEFAULT NULL,
            `media`varchar(255) DEFAULT NULL,
            `youtube`varchar(255) DEFAULT NULL,
             FOREIGN KEY (`fk_house_id`) REFERENCES #__rem_houses(`id`),
             PRIMARY KEY (`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
          $database->setQuery($query);
          try
            {
                $database->execute();
            }
            catch (Exception $e)
            {
                echo $e->getMessage();
            }
          if (array_search($database->getPrefix() . "rem_video_source", $database->getTableList(), true))
            echo "[Ok]<br />";
          else
            exit;

          echo "Creating table for track source... ";
          $query = "CREATE TABLE IF NOT EXISTS #__rem_track_source (
            `id` int(11) unsigned NOT NULL auto_increment,
            `fk_house_id`int(11) DEFAULT NULL,
            `sequence_number` int(11) DEFAULT NULL,
            `src` varchar(255) DEFAULT NULL,
            `kind` varchar(255) DEFAULT NULL,
            `scrlang` varchar(255) DEFAULT NULL,
            `label` varchar(255) DEFAULT NULL,
             FOREIGN KEY (`fk_house_id`) REFERENCES #__rem_houses(`id`),
             PRIMARY KEY (`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci ";
          $database->setQuery($query);
          try
            {
                $database->execute();
            }
            catch (Exception $e)
            {
                echo $e->getMessage();
            }
          if (array_search($database->getPrefix() . "rem_track_source", $database->getTableList(), true))
            echo "[Ok]<br />";
          else
            exit;

        echo "Creating table for review... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_review` (
              `id` int(11) unsigned NOT NULL auto_increment,
              `fk_houseid` int(11) NOT NULL default 0,
              `fk_userid` int(11),
              `user_name` VARCHAR(150),
              `user_email` VARCHAR(100),
              `date` datetime NOT NULL default '0000-00-00 00:00:00',
              `rating` int(2) default 0,
              `title` varchar(250) default '',
              `comment` TEXT,
              `published` tinyint(1) NOT NULL default '0',
              PRIMARY KEY  (`id`),
              FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
              FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`)
              ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_review", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;


        echo "Creating table for rent sale... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_rent_sal` (
		`id` int(11) unsigned NOT NULL auto_increment,
		`fk_houseid` int(11),
		`monthW` int(4) NOT NULL default 0,
		`yearW` int(4) NOT NULL default 0,
		`week` varchar(1250) default '',
		`weekend` varchar(1250) default '',
		`midweek` varchar(1250) default '',
		`price_from` DATE NOT NULL ,
                `price_to` DATE NOT NULL ,
                `special_price` FLOAT NOT NULL ,
                `comment_price` VARCHAR( 1000 ) NOT NULL ,
                `priceunit` VARCHAR( 255 ) NOT NULL,
		 PRIMARY KEY  (`id`)
		) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_rent_sal", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for feature... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_feature` (
		`id` int(11) unsigned NOT NULL auto_increment,
		`name` varchar(250) default '',
		`categories` varchar(250) default '',
		`published` tinyint(1) NOT NULL DEFAULT '0',
		`image_link` varchar(250) default '',
		PRIMARY KEY  (`id`)
		) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_feature", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for feature_rem_houses... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_feature_houses (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_houseid` int(11) NOT NULL default 0,
                `fk_featureid` int(11) NOT NULL default 0,
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`),
                FOREIGN KEY (`fk_featureid`) REFERENCES #__rem_feature(`id`),
                INDEX (`fk_houseid`,`fk_featureid`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_feature_houses", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for const ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_const (
                `id` int(11) unsigned NOT NULL auto_increment,
                `const` varchar(250) default '',
                `sys_type` varchar(250) default '',
                PRIMARY KEY  (`id`),
                UNIQUE (`const`),
                INDEX (`const`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_const", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for languages ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_languages (
                `id` int(11) unsigned NOT NULL auto_increment,
                `lang_code` char(7),
                `title` varchar(250) default '',
                `sef` char(7),
                PRIMARY KEY  (`id`),
                UNIQUE (`lang_code`),
                INDEX (`lang_code`),
                INDEX (`lang_code`,`title`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_languages", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for const ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_const_languages (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_constid` int(11) NOT NULL default 0,
                `fk_languagesid` int(11) NOT NULL default 0,
                `value_const` varchar(2000) default '',
                PRIMARY KEY  (`id`),
                UNIQUE (`fk_constid`,`fk_languagesid`),
                FOREIGN KEY (`fk_constid`) REFERENCES #__rem_const(`id`),
                FOREIGN KEY (`fk_languagesid`) REFERENCES #__rem_languages(`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_const_languages", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for mime_types ... ";
        $query = " CREATE TABLE IF NOT EXISTS `#__rem_mime_types` (
            `mime_ext` text,
            `mime_type` text
          ) ENGINE=MyISAM AUTO_INCREMENT=2 COLLATE utf8_general_ci";
        $database->setQuery($query);
        $database->execute();
        if (array_search($database->getPrefix() . "rem_mime_types", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for version ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_version (
                `id` int(11) unsigned NOT NULL auto_increment,
                `version` varchar(11) NOT NULL default 0,
                `number` varchar(11),
                PRIMARY KEY  (`id`),
                INDEX (`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_version", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        updateRemConfigurationVersion();
        $vers = explode(' ', $realestatemanager_configuration['release']['version']);
        $versi = substr($vers[0],0,3);
        $query = "INSERT INTO #__rem_version (`version`,`number`) VALUES ('$versi','$vers[1]')";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }

        echo "Creating table for categories ... ";
        $query = "CREATE TABLE IF NOT EXISTS #__rem_categories (
                `id` int(11) unsigned NOT NULL auto_increment,
                `iditem` int(11) NOT NULL default 0,
                `idcat` int(11),
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`iditem`) REFERENCES #__rem_houses(`id`),
                FOREIGN KEY (`idcat`) REFERENCES #__rem_main_categories(`id`)
                ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARACTER SET `utf8`";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_categories", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit;

        echo "Creating table for wishlist ... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_users_wishlist` (
                 `id` int(11) NOT NULL auto_increment,
                 `fk_houseid` int(11) DEFAULT NULL,
                 `fk_userid` int(11) DEFAULT NULL,
                  FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`),
                  FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
                  PRIMARY KEY (`id`)
                 ) ENGINE=MyISAM AUTO_INCREMENT=2  COLLATE utf8_general_ci";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_users_wishlist", $database->getTableList(), true))
            echo "[Ok]<br />";
        else
            exit;

        echo "Creating table for MLS ... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_mls_for_delete` (
            `id` int(15) NOT NULL AUTO_INCREMENT,
            `mls` varchar(255) DEFAULT NULL,
            PRIMARY KEY (`id`)
            ) ENGINE=MyISAM CHARSET=utf8;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_mls_for_delete", $database->getTableList(), true))
            echo "[Ok]<br />";
        else
            exit;


        echo "Creating table for rem_api ... ";
        $query = "CREATE TABLE IF NOT EXISTS  `#__rem_api` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `service` varchar(255) NOT NULL,
                `key` text ,
                PRIMARY KEY  (`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2  CHARSET=utf8;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_api", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else  exit;      

        echo "Creating table for property_request... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_property_request` (
                `id` int(11) unsigned NOT NULL auto_increment,
                `fk_houseid` int(11) NOT NULL default 0,
                `fk_userid` int(11),
                `property_request` datetime NOT NULL default '0000-00-00 00:00:00',
                `checked_out` int(11) NOT NULL default 0,
                `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
                `customer_name` varchar(250) default '',
                `customer_email` varchar(250) default '',
                `customer_phone` TEXT ,
                `customer_comment` TEXT ,
                `status` int(1) default 0,
                PRIMARY KEY  (`id`),
                FOREIGN KEY (`fk_userid`) REFERENCES #__users(`id`),
                FOREIGN KEY (`fk_houseid`) REFERENCES #__rem_houses(`id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2 CHARSET=utf8;";
        $database->setQuery($query);
        try
        {
            $database->execute();
        }
        catch (Exception $e)
        {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_property_request", $database->getTableList(), true))
            echo "[Ok]<br />"; else
            exit;        

        //echo "Creating table for sef urls... ";
        $query = "CREATE TABLE IF NOT EXISTS `#__rem_sef_urls` (
            `id` int(11) unsigned NOT NULL auto_increment,
            `ser_url_segments` blob,
            `hash_url_segments` varchar(35) NOT NULL default '',
            `url_last_segment`  varchar(255) NOT NULL default '',
            `hash_last_segment` varchar(35) NOT NULL default '',
            `ser_vars` blob ,
            `hash_vars` varchar(35) NOT NULL default '',
            `lang` varchar(55) NOT NULL default '',
            `date` datetime ,
            `hits` int(11) NOT NULL default '0',
            `published` tinyint(1) NOT NULL default '1',
            PRIMARY KEY  (`id`),
            INDEX (`hash_url_segments`),
            INDEX (`hash_vars`),
            INDEX (`date`),
            INDEX (`date`,`hits`),
            INDEX (`lang`)
            ) ENGINE=MyISAM AUTO_INCREMENT=2  CHARACTER SET utf8 ";
        try {
            $database->setQuery($query);
            $database->execute();
        } catch (RuntimeException $e) {
            echo $e->getMessage();
        }
        if (array_search($database->getPrefix() . "rem_sef_urls", $database->getTableList(), true))
            echo "[Ok]<br />"; 
        else
            exit; 

        echo "end install database<br/>";
    } // End of creation new database

       
    //load language and constant
    loadConstRem();

    //if update free version need do features constand add for new languages
    rem_add_new_features_constant() ;
    rem_add_new_features_category_constant();
            

    //load MimeType
    loadDataMime();

    //add sample data
    $database->setQuery("SELECT * FROM #__rem_houses");
    $realestatemanager = $database->loadResult();
    require_once ($mosConfig_absolute_path . "/administrator/components/com_realestatemanager/realestatemanager.class.impexp.php");
    if (!isset($realestatemanager)) {
        mosRealEstateManagerImportExport::importHousesXML($mosConfig_absolute_path . "/administrator/components/com_realestatemanager/exports/sample_data.xml", null,true);
        echo "Sample data loaded<br/>";
    }


    //******************   end database ******************

    if (!$is_warning)
        echo "<h2 style='color:#0f0;'>Import sample data - OK</h2>";

    # Show installation result to user
    ?>
    <center>
        <table width="100%" border="0">
            <tr>
                <td>
                    <strong>Joomla Real Estate</strong><br/>
                    <br/>
                    This component is published under the <a href="<?php echo $mosConfig_live_site . "/components/com_realestatemanager/doc/LICENSE.txt"; ?>"
                                                             target="new">License</a>.
                </td>
            </tr>
            <tr>
                <td>
                    <code>Installation: <font color="green">successfull</font></code>
                </td>
            </tr>
        </table>
    </center>

    <?php
    if ($is_warning)
        return '<h2><font color="red">The Joomla Real Estate Component installed with a warning about a missing PHP extension! Please read carefully and uninstall Joomla Real Estate. Next fix your PHP installation and then install Joomla Real Estate again.</font></h2>';
}

function loadDataMime() {
    global $database;

    $query = "TRUNCATE TABLE  `#__rem_mime_types`";
    $database->setQuery($query);
    $database->execute();

    $query = "INSERT INTO `#__rem_mime_types` VALUES
        ('atom', 'application/atom+xml'),
        ('atomcat', 'application/atomcat+xml'),
        ('atomsvc', 'application/atomsvc+xml'),
        ('ccxml', 'application/ccxml+xml'),
        ('epub', 'application/epub+zip'),
        ('jar', 'application/java-archive'),
        ('js', 'application/javascript'),
        ('json', 'application/json'),
        ('jsonml', 'application/jsonml+json'),
        ('mads', 'application/mads+xml'),
        ('mathml', 'application/mathml+xml'),
        ('mbox', 'application/mbox'),
        ('mscml', 'application/mediaservercontrol+xml'),
        ('metalink', 'application/metalink+xml'),
        ('meta4', 'application/metalink4+xml'),
        ('mods', 'application/mods+xml'),
        ('doc', 'application/msword'),
        ('dot', 'application/msword'),
        ('bin', 'application/octet-stream'),
        ('so', 'application/octet-stream'),
        ('pkg', 'application/octet-stream'),
        ('dump', 'application/octet-stream'),
        ('elc', 'application/octet-stream'),
        ('deploy', 'application/octet-stream'),
        ('oxps', 'application/oxps'),
        ('pdf', 'application/pdf'),
        ('asc', 'application/pgp-signature'),
        ('sig', 'application/pgp-signature'),
        ('prf', 'application/pics-rules'),
        ('cer', 'application/pkix-cert'),
        ('crl', 'application/pkix-crl'),
        ('ai', 'application/postscript'),
        ('eps', 'application/postscript'),
        ('ps', 'application/postscript'),
        ('rdf', 'application/rdf+xml'),
        ('rs', 'application/rls-services+xml'),
        ('rsd', 'application/rsd+xml'),
        ('rss', 'application/rss+xml'),
        ('rtf', 'application/rtf'),
        ('fxp', 'application/vnd.adobe.fxp'),
        ('fxpl', 'application/vnd.adobe.fxp'),
        ('xdp', 'application/vnd.adobe.xdp+xml'),
        ('xfdf', 'application/vnd.adobe.xfdf'),
        ('ahead', 'application/vnd.ahead.space'),
        ('azf', 'application/vnd.airzip.filesecure.azf'),
        ('azs', 'application/vnd.airzip.filesecure.azs'),
        ('azw', 'application/vnd.amazon.ebook'),
        ('mpkg', 'application/vnd.apple.installer+xml'),
        ('m3u8', 'application/vnd.apple.mpegurl'),
        ('sc', 'application/vnd.ibm.secure-container'),
        ('org', 'application/vnd.lotus-organizer'),
        ('scm', 'application/vnd.lotus-screencam'),
        ('flo', 'application/vnd.micrografx.flo'),
        ('igx', 'application/vnd.micrografx.igx'),
        ('xul', 'application/vnd.mozilla.xul+xml'),
        ('cab', 'application/vnd.ms-cab-compressed'),
        ('xls', 'application/vnd.ms-excel'),
        ('xlm', 'application/vnd.ms-excel'),
        ('xla', 'application/vnd.ms-excel'),
        ('xlc', 'application/vnd.ms-excel'),
        ('xlt', 'application/vnd.ms-excel'),
        ('xlw', 'application/vnd.ms-excel'),
        ('chm', 'application/vnd.ms-htmlhelp'),
        ('thmx', 'application/vnd.ms-officetheme'),
        ('cat', 'application/vnd.ms-pki.seccat'),
        ('ppt', 'application/vnd.ms-powerpoint'),
        ('pps', 'application/vnd.ms-powerpoint'),
        ('pot', 'application/vnd.ms-powerpoint'),
        ('mpp', 'application/vnd.ms-project'),
        ('mpt', 'application/vnd.ms-project'),
        ('docm', 'application/vnd.ms-word.document.macroenabled.12'),
        ('dotm', 'application/vnd.ms-word.template.macroenabled.12'),
        ('wps', 'application/vnd.ms-works'),
        ('wks', 'application/vnd.ms-works'),
        ('wcm', 'application/vnd.ms-works'),
        ('wdb', 'application/vnd.ms-works'),
        ('wpl', 'application/vnd.ms-wpl'),
        ('xps', 'application/vnd.ms-xpsdocument'),
        ('edm', 'application/vnd.novadigm.edm'),
        ('edx', 'application/vnd.novadigm.edx'),
        ('ext', 'application/vnd.novadigm.ext'),
        ('odc', 'application/vnd.oasis.opendocument.chart'),
        ('otc', 'application/vnd.oasis.opendocument.chart-template'),
        ('odb', 'application/vnd.oasis.opendocument.database'),
        ('odf', 'application/vnd.oasis.opendocument.formula'),
        ('odft', 'application/vnd.oasis.opendocument.formula-template'),
        ('odg', 'application/vnd.oasis.opendocument.graphics'),
        ('otg', 'application/vnd.oasis.opendocument.graphics-template'),
        ('odi', 'application/vnd.oasis.opendocument.image'),
        ('oti', 'application/vnd.oasis.opendocument.image-template'),
        ('odp', 'application/vnd.oasis.opendocument.presentation'),
        ('otp', 'application/vnd.oasis.opendocument.presentation-template'),
        ('ods', 'application/vnd.oasis.opendocument.spreadsheet'),
        ('ots', 'application/vnd.oasis.opendocument.spreadsheet-template'),
        ('odt', 'application/vnd.oasis.opendocument.text'),
        ('odm', 'application/vnd.oasis.opendocument.text-master'),
        ('ott', 'application/vnd.oasis.opendocument.text-template'),
        ('oth', 'application/vnd.oasis.opendocument.text-web'),
        ('oxt', 'application/vnd.openofficeorg.extension'),
        ('pptx', 'application/vnd.openxmlformats-officedocument.presentationml.presentation'),
        ('sldx', 'application/vnd.openxmlformats-officedocument.presentationml.slide'),
        ('ppsx', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow'),
        ('potx', 'application/vnd.openxmlformats-officedocument.presentationml.template'),
        ('xlsx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'),
        ('xltx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template'),
        ('docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'),
        ('dotx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'),
        ('mgp', 'application/vnd.osgeo.mapguide.package'),
        ('vcx', 'application/vnd.vcx'),
        ('vsd', 'application/vnd.visio'),
        ('vst', 'application/vnd.visio'),
        ('vss', 'application/vnd.visio'),
        ('vsw', 'application/vnd.visio'),
        ('vsf', 'application/vnd.vsf'),
        ('wbxml', 'application/vnd.wap.wbxml'),
        ('xar', 'application/vnd.xara'),
        ('vxml', 'application/voicexml+xml'),
        ('wgt', 'application/widget'),
        ('hlp', 'application/winhlp'),
        ('wsdl', 'application/wsdl+xml'),
        ('7z', 'application/x-7z-compressed'),
        ('abw', 'application/x-abiword'),
        ('ace', 'application/x-ace-compressed'),
        ('bz', 'application/x-bzip'),
        ('bz2', 'application/x-bzip2'),
        ('boz', 'application/x-bzip2'),
        ('vcd', 'application/x-cdlink'),
        ('cfs', 'application/x-cfs-compressed'),
        ('chat', 'application/x-chat'),
        ('pgn', 'application/x-chess-pgn'),
        ('nsc', 'application/x-conference'),
        ('cpio', 'application/x-cpio'),
        ('csh', 'application/x-csh'),
        ('deb', 'application/x-debian-package'),
        ('udeb', 'application/x-debian-package'),
        ('dgc', 'application/x-dgc-compressed'),
        ('ncx', 'application/x-dtbncx+xml'),
        ('dtb', 'application/x-dtbook+xml'),
        ('res', 'application/x-dtbresource+xml'),
        ('dvi', 'application/x-dvi'),
        ('gsf', 'application/x-font-ghostscript'),
        ('psf', 'application/x-font-linux-psf'),
        ('otf', 'application/x-font-otf'),
        ('pcf', 'application/x-font-pcf'),
        ('snf', 'application/x-font-snf'),
        ('ttf', 'application/x-font-ttf'),
        ('ttc', 'application/x-font-ttf'),
        ('woff', 'application/x-font-woff'),
        ('arc', 'application/x-freearc'),
        ('gca', 'application/x-gca-compressed'),
        ('ulx', 'application/x-glulx'),
        ('gnumeric', 'application/x-gnumeric'),
        ('gramps', 'application/x-gramps-xml'),
        ('gtar', 'application/x-gtar'),
        ('hdf', 'application/x-hdf'),
        ('install', 'application/x-install-instructions'),
        ('iso', 'application/x-iso9660-image'),
        ('jnlp', 'application/x-java-jnlp-file'),
        ('latex', 'application/x-latex'),
        ('lzh', 'application/x-lzh-compressed'),
        ('lha', 'application/x-lzh-compressed'),
        ('prc', 'application/x-mobipocket-ebook'),
        ('mobi', 'application/x-mobipocket-ebook'),
        ('application', 'application/x-ms-application'),
        ('crd', 'application/x-mscardfile'),
        ('clp', 'application/x-msclip'),
        ('exe', 'application/x-msdownload'),
        ('dll', 'application/x-msdownload'),
        ('com', 'application/x-msdownload'),
        ('bat', 'application/x-msdownload'),
        ('msi', 'application/x-msdownload'),
        ('pub', 'application/x-mspublisher'),
        ('rar', 'application/x-rar-compressed'),
        ('sh', 'application/x-sh'),
        ('shar', 'application/x-shar'),
        ('swf', 'application/x-shockwave-flash'),
        ('sql', 'application/x-sql'),
        ('srt', 'application/x-subrip'),
        ('t3', 'application/x-t3vm-image'),
        ('tar', 'application/x-tar'),
        ('tcl', 'application/x-tcl'),
        ('tex', 'application/x-tex'),
        ('texinfo', 'application/x-texinfo'),
        ('texi', 'application/x-texinfo'),
        ('obj', 'application/x-tgif'),
        ('src', 'application/x-wais-source'),
        ('der', 'application/x-x509-ca-cert'),
        ('crt', 'application/x-x509-ca-cert'),
        ('xpi', 'application/x-xpinstall'),
        ('xz', 'application/x-xz'),
        ('xaml', 'application/xaml+xml'),
        ('xdf', 'application/xcap-diff+xml'),
        ('xht', 'application/xhtml+xml'),
        ('xml', 'application/xml'),
        ('xsl', 'application/xml'),
        ('dtd', 'application/xml-dtd'),
        ('xop', 'application/xop+xml'),
        ('xpl', 'application/xproc+xml'),
        ('xslt', 'application/xslt+xml'),
        ('xspf', 'application/xspf+xml'),
        ('zip', 'application/zip'),
        ('zip', 'application/x-zip'),
        ('zip', 'application/x-zip-compressed'),
        ('adp', 'audio/adpcm'),
        ('au', 'audio/basic'),
        ('snd', 'audio/basic'),
        ('mid', 'audio/midi'),
        ('midi', 'audio/midi'),
        ('kar', 'audio/midi'),
        ('rmi', 'audio/midi'),
        ('mp4a', 'audio/mp4'),
        ('mpga', 'audio/mpeg'),
        ('mp2', 'audio/mpeg'),
        ('mp2a', 'audio/mpeg'),
        ('mp3', 'audio/mpeg'),
        ('m2a', 'audio/mpeg'),
        ('m3a', 'audio/mpeg'),
        ('oga', 'audio/ogg'),
        ('ogg', 'audio/ogg'),
        ('spx', 'audio/ogg'),
        ('s3m', 'audio/s3m'),
        ('sil', 'audio/silk'),
        ('uva', 'audio/vnd.dece.audio'),
        ('uvva', 'audio/vnd.dece.audio'),
        ('eol', 'audio/vnd.digital-winds'),
        ('dra', 'audio/vnd.dra'),
        ('dts', 'audio/vnd.dts'),
        ('dtshd', 'audio/vnd.dts.hd'),
        ('lvp', 'audio/vnd.lucent.voice'),
        ('pya', 'audio/vnd.ms-playready.media.pya'),
        ('rip', 'audio/vnd.rip'),
        ('weba', 'audio/webm'),
        ('aac', 'audio/x-aac'),
        ('aif', 'audio/x-aiff'),
        ('aiff', 'audio/x-aiff'),
        ('aifc', 'audio/x-aiff'),
        ('caf', 'audio/x-caf'),
        ('flac', 'audio/x-flac'),
        ('mka', 'audio/x-matroska'),
        ('m3u', 'audio/x-mpegurl'),
        ('wax', 'audio/x-ms-wax'),
        ('wma', 'audio/x-ms-wma'),
        ('ram', 'audio/x-pn-realaudio'),
        ('ra', 'audio/x-pn-realaudio'),
        ('rmp', 'audio/x-pn-realaudio-plugin'),
        ('wav', 'audio/x-wav'),
        ('xm', 'audio/xm'),
        ('cdx', 'chemical/x-cdx'),
        ('cif', 'chemical/x-cif'),
        ('cmdf', 'chemical/x-cmdf'),
        ('cml', 'chemical/x-cml'),
        ('csml', 'chemical/x-csml'),
        ('xyz', 'chemical/x-xyz'),
        ('bmp', 'image/bmp'),
        ('cgm', 'image/cgm'),
        ('g3', 'image/g3fax'),
        ('gif', 'image/gif'),
        ('ief', 'image/ief'),
        ('jpeg', 'image/jpeg'),
        ('jpg', 'image/jpeg'),
        ('jpe', 'image/jpeg'),
        ('ktx', 'image/ktx'),
        ('png', 'image/png'),
        ('btif', 'image/prs.btif'),
        ('sgi', 'image/sgi'),
        ('svg', 'image/svg+xml'),
        ('svgz', 'image/svg+xml'),
        ('tiff', 'image/tiff'),
        ('tif', 'image/tiff'),
        ('psd', 'image/vnd.adobe.photoshop'),
        ('uvi', 'image/vnd.dece.graphic'),
        ('uvvi', 'image/vnd.dece.graphic'),
        ('uvg', 'image/vnd.dece.graphic'),
        ('uvvg', 'image/vnd.dece.graphic'),
        ('sub', 'text/vnd.dvb.subtitle'),
        ('djvu', 'image/vnd.djvu'),
        ('djv', 'image/vnd.djvu'),
        ('dwg', 'image/vnd.dwg'),
        ('dxf', 'image/vnd.dxf'),
        ('fbs', 'image/vnd.fastbidsheet'),
        ('fpx', 'image/vnd.fpx'),
        ('fst', 'image/vnd.fst'),
        ('mmr', 'image/vnd.fujixerox.edmics-mmr'),
        ('rlc', 'image/vnd.fujixerox.edmics-rlc'),
        ('mdi', 'image/vnd.ms-modi'),
        ('wdp', 'image/vnd.ms-photo'),
        ('npx', 'image/vnd.net-fpx'),
        ('wbmp', 'image/vnd.wap.wbmp'),
        ('xif', 'image/vnd.xiff'),
        ('webp', 'image/webp'),
        ('3ds', 'image/x-3ds'),
        ('ras', 'image/x-cmu-raster'),
        ('cmx', 'image/x-cmx'),
        ('fh', 'image/x-freehand'),
        ('fhc', 'image/x-freehand'),
        ('fh4', 'image/x-freehand'),
        ('fh5', 'image/x-freehand'),
        ('fh7', 'image/x-freehand'),
        ('ico', 'image/x-icon'),
        ('sid', 'image/x-mrsid-image'),
        ('pcx', 'image/x-pcx'),
        ('pic', 'image/x-pict'),
        ('pct', 'image/x-pict'),
        ('pnm', 'image/x-portable-anymap'),
        ('pbm', 'image/x-portable-bitmap'),
        ('pgm', 'image/x-portable-graymap'),
        ('ppm', 'image/x-portable-pixmap'),
        ('rgb', 'image/x-rgb'),
        ('tga', 'image/x-tga'),
        ('xbm', 'image/x-xbitmap'),
        ('xpm', 'image/x-xpixmap'),
        ('xwd', 'image/x-xwindowdump'),
        ('eml', 'message/rfc822'),
        ('mime', 'message/rfc822'),
        ('igs', 'model/iges'),
        ('iges', 'model/iges'),
        ('msh', 'model/mesh'),
        ('mesh', 'model/mesh'),
        ('ics', 'text/calendar'),
        ('ifb', 'text/calendar'),
        ('css', 'text/css'),
        ('csv', 'text/csv'),
        ('html', 'text/html'),
        ('htm', 'text/html'),
        ('txt', 'text/plain'),
        ('text', 'text/plain'),
        ('conf', 'text/plain'),
        ('def', 'text/plain'),
        ('list', 'text/plain'),
        ('log', 'text/plain'),
        ('sgml', 'text/sgml'),
        ('sgm', 'text/sgml'),
        ('man', 'text/troff'),
        ('ttl', 'text/turtle'),
        ('uri', 'text/uri-list'),
        ('uris', 'text/uri-list'),
        ('urls', 'text/uri-list'),
        ('vcard', 'text/vcard'),
        ('curl', 'text/vnd.curl'),
        ('dcurl', 'text/vnd.curl.dcurl'),
        ('scurl', 'text/vnd.curl.scurl'),
        ('mcurl', 'text/vnd.curl.mcurl'),
        ('fly', 'text/vnd.fly'),
        ('flx', 'text/vnd.fmi.flexstor'),
        ('gv', 'text/vnd.graphviz'),
        ('3dml', 'text/vnd.in3d.3dml'),
        ('spot', 'text/vnd.in3d.spot'),
        ('jad', 'text/vnd.sun.j2me.app-descriptor'),
        ('wml', 'text/vnd.wap.wml'),
        ('wmls', 'text/vnd.wap.wmlscript'),
        ('s', 'text/x-asm'),
        ('asm', 'text/x-asm'),
        ('c', 'text/x-c'),
        ('cc', 'text/x-c'),
        ('cxx', 'text/x-c'),
        ('cpp', 'text/x-c'),
        ('h', 'text/x-c'),
        ('hh', 'text/x-c'),
        ('dic', 'text/x-c'),
        ('f', 'text/x-fortran'),
        ('for', 'text/x-fortran'),
        ('f77', 'text/x-fortran'),
        ('f90', 'text/x-fortran'),
        ('java', 'text/x-java-source'),
        ('opml', 'text/x-opml'),
        ('p', 'text/x-pascal'),
        ('pas', 'text/x-pascal'),
        ('nfo', 'text/x-nfo'),
        ('etx', 'text/x-setext'),
        ('sfv', 'text/x-sfv'),
        ('uu', 'text/x-uuencode'),
        ('vcs', 'text/x-vcalendar'),
        ('vcf', 'text/x-vcard'),
        ('3gp', 'video/3gpp'),
        ('3g2', 'video/3gpp2'),
        ('h261', 'video/h261'),
        ('h263', 'video/h263'),
        ('h264', 'video/h264'),
        ('jpgv', 'video/jpeg'),
        ('jpm', 'video/jpm'),
        ('jpgm', 'video/jpm'),
        ('mj2', 'video/mj2'),
        ('mjp2', 'video/mj2'),
        ('mp4', 'video/mp4'),
        ('mp4v', 'video/mp4'),
        ('mpg4', 'video/mp4'),
        ('mpeg', 'video/mpeg'),
        ('mpg', 'video/mpeg'),
        ('mpe', 'video/mpeg'),
        ('m1v', 'video/mpeg'),
        ('m2v', 'video/mpeg'),
        ('ogv', 'video/ogg'),
        ('qt', 'video/quicktime'),
        ('mov', 'video/quicktime'),
        ('uvh', 'video/vnd.dece.hd'),
        ('uvvh', 'video/vnd.dece.hd'),
        ('uvm', 'video/vnd.dece.mobile'),
        ('uvvm', 'video/vnd.dece.mobile'),
        ('uvp', 'video/vnd.dece.pd'),
        ('uvvp', 'video/vnd.dece.pd'),
        ('uvs', 'video/vnd.dece.sd'),
        ('uvvs', 'video/vnd.dece.sd'),
        ('uvv', 'video/vnd.dece.video'),
        ('uvvv', 'video/vnd.dece.video'),
        ('dvb', 'video/vnd.dvb.file'),
        ('fvt', 'video/vnd.fvt'),
        ('mxu', 'video/vnd.mpegurl'),
        ('m4u', 'video/vnd.mpegurl'),
        ('pyv', 'video/vnd.ms-playready.media.pyv'),
        ('uvu', 'video/vnd.uvvu.mp4'),
        ('uvvu', 'video/vnd.uvvu.mp4'),
        ('viv', 'video/vnd.vivo'),
        ('webm', 'video/webm'),
        ('f4v', 'video/x-f4v'),
        ('fli', 'video/x-fli'),
        ('flv', 'video/x-flv'),
        ('m4v', 'video/x-m4v'),
        ('mkv', 'video/x-matroska'),
        ('mk3d', 'video/x-matroska'),
        ('mks', 'video/x-matroska'),
        ('mng', 'video/x-mng'),
        ('asf', 'video/x-ms-asf'),
        ('asx', 'video/x-ms-asf'),
        ('vob', 'video/x-ms-vob'),
        ('wm', 'video/x-ms-wm'),
        ('wmv', 'video/x-ms-wmv'),
        ('wmx', 'video/x-ms-wmx'),
        ('wvx', 'video/x-ms-wvx'),
        ('avi', 'video/x-msvideo'),
        ('movie', 'video/x-sgi-movie'),
        ('smv', 'video/x-smv'),
        ('ice', 'x-conference/x-cooltalk');";
    $database->setQuery($query);
    $database->execute();
}
