<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
// if(is_file(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.others.php') ) {
//     require_once ($mosConfig_absolute_path .
//     "/administrator/components/com_realestatemanager/realestatemanager.class.others.php");
// }

//we can't include compat.joomla1.5.php - while - it included from old version - which installed early
//need for Joomla 5-6
use Joomla\CMS\Factory;
if (version_compare(JVERSION, "5.0.0", "ge")) {
    if (!class_exists('JFactory')) class_alias('Joomla\CMS\Factory', 'JFactory');
} 

class com_RealEstateManagerInstallerScript {

    /**
     * method to run before an install/update/uninstall method
     *
     * @return void
     */
    function preflight($type, $parent) {
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        // Save admin settings before updete
        if ( $type == 'update' ) {
            // $realestatemanager_configuration:
            if(is_file(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf.php') ) {
                require(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf.php');
                if(isset($realestatemanager_configuration) )
                    $GLOBALS['realestatemanager_configuration_old'] = $realestatemanager_configuration;
            };
            if(is_file(JPATH_ROOT . '/components/com_realestatemanager/regions_and_citys.txt') ) {
                copy(JPATH_ROOT . '/components/com_realestatemanager/regions_and_citys.txt', JPATH_ROOT . '/components/com_realestatemanager/regions_and_citys.txt_bak');
            }
            if(is_file(JPATH_ROOT . '/components/com_realestatemanager/countrys_and_regions.txt') ) {
                copy(JPATH_ROOT . '/components/com_realestatemanager/countrys_and_regions.txt', JPATH_ROOT . '/components/com_realestatemanager/countrys_and_regions.txt_bak');
            }            
        }

        $db = JFactory::getDBO();
        $db->setQuery("DELETE FROM #__update_sites WHERE name = 'Realestatemanager`s Update'");
        $db->execute();

    }

    /**
     * method to install the component
     *
     * @return void
     */
    function install($parent) {
        
        // $parent is the class calling this method
    }

    /**
     * method to update the component
     *
     * @return void
     */
    function update($parent) {
        
        // $parent is the class calling this method

    }

    /**
     * method to uninstall the component
     *
     * @return void
     */
    function uninstall($parent) {
        
        // $parent is the class calling this method
        require_once(JPATH_SITE . "/administrator/components/com_realestatemanager/uninstall.realestatemanager.php");
    }

    /**
     * method to run after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent) {
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        // Marge old admin settings and new configuration after update
        global $realestatemanager_configuration_old, $realestatemanager_configuration;

        if ( $type == 'update' ) {
            // $realestatemanager_configuration new from update files
            if(is_file(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf_new.php') ) {
                require(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf_new.php');
                if(isset($realestatemanager_configuration) && isset($realestatemanager_configuration_old)  ){

                    $ordasoftNewReleaseVersion = $realestatemanager_configuration['release']['version'];
                    $ordasoftNewReleaseDate = $realestatemanager_configuration['release']['date'];

                    $realestatemanager_configuration = array_replace_recursive($realestatemanager_configuration, $realestatemanager_configuration_old);
                    $realestatemanager_configuration['release']['version'] = $ordasoftNewReleaseVersion;
                    $realestatemanager_configuration['release']['date'] = $ordasoftNewReleaseDate;

                    //need ONLY NOW include  mosRealestateManagerOthers - with new  setParams function - other run old function        
                    if(!class_exists('mosRealestateManagerOthers') ) 
                        require_once(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.others.php');
                    mosRealestateManagerOthers::setParams();
                }
            }
            if(is_file(JPATH_ROOT . '/components/com_realestatemanager/regions_and_citys.txt_bak') ) {
                copy(JPATH_ROOT . '/components/com_realestatemanager/regions_and_citys.txt_bak', JPATH_ROOT . '/components/com_realestatemanager/regions_and_citys.txt');
            }
            if(is_file(JPATH_ROOT . '/components/com_realestatemanager/countrys_and_regions.txt_bak') ) {
                copy(JPATH_ROOT . '/components/com_realestatemanager/countrys_and_regions.txt_bak', JPATH_ROOT . '/components/com_realestatemanager/countrys_and_regions.txt');
            }            
        }
        // In J4 method postflight calling on uninstall too.
        // https://docs.joomla.org/Potential_backward_compatibility_issues_in_Joomla_4
        if ( $type == 'install' || $type == 'update' ) {
            require_once(JPATH_SITE . "/administrator/components/com_realestatemanager/install.realestatemanager.php");
            require_once(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.others.php');
            
            com_install2();
        }
    }

}
