<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 * */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'];
//$database = JFactory::getDBO();
// load language
require_once ($mosConfig_absolute_path . "/components/com_realestatemanager/realestatemanager.class.feature.php");
require_once ($mosConfig_absolute_path . "/components/com_realestatemanager/realestatemanager.main.categories.class.php");
require_once $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/language.php";

function myRemErrorHandler($errno, $errstr, $errfile, $errline)
    {

        global $mosConfig_absolute_path;
        $errorPath = $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/my_error_2.log";
        if (!(error_reporting() & $errno)) {
            // Этот код ошибки не включен в error_reporting,
            // так что пусть обрабатываются стандартным обработчиком ошибок PHP
            return false;
        }

        switch ($errno) {
        case E_USER_ERROR:
            $error =  "<b>My ERROR</b> [$errno] $errstr <br />\n";
            $error .= "  Фатальная ошибка в строке $errline файла $errfile";
            $error .= ", PHP " . PHP_VERSION . " (" . PHP_OS . ")<br />\n";
            $error .= "Завершение работы...<br />\n";

            break;

        case E_USER_WARNING:
            $error = "<b>My WARNING</b> [$errno] $errstr Строка:$errline файла $errfile<br />\n";

            break;

        case E_USER_NOTICE:
            $error = "<b>My NOTICE</b> [$errno] $errstr Строка:$errline файла $errfile<br />\n";

            break;

        default:
            $error = "Неизвестная ошибка: [$errno] $errstr Строка:$errline файла $errfile<br />\n";

            break;
        }

        file_put_contents($errorPath, $error." ".time()." \n",  FILE_APPEND );
        /* Не запускаем внутренний обработчик ошибок PHP */
        return true;
    }

// set_error_handler("myRemErrorHandler");

if (PHP_VERSION >= 5) {

    // Emulate the old xslt library functions
    function xslt_create() {
        return new XsltProcessor();
    }

    function xslt_process($xsltproc, $xml_arg, $xsl_arg, $xslcontainer = null, $args = null, $params = null) {
        // Create instances of the DomDocument class
        $xml = new DomDocument;
        $xsl = new DomDocument;

        // Load the xml document and the xsl template
        $xml->load($xml_arg);
        $xsl->load($xsl_arg);

        // Load the xsl template
        $xsltproc->importStyleSheet($xsl);

        // Set parameters when defined
        if ($params)
            foreach ($params as $param => $value)
                $xsltproc->setParameter("", $param, $value);
        // Start the transformation
        $processed = $xsltproc->transformToXML($xml);
        // Put the result in a file when specified
        if ($xslcontainer)
            return @file_put_contents($xslcontainer, $processed); else
            return $processed;
    }

    function xslt_free($xsltproc) {
        unset($xsltproc);
    }

}

class mosRealEstateManagerImportExport {

    /**
     * Imports the lines given to this method into the database and writes a
     * table containing the information of the imported houses.
     * The imported houses will be set to [not published]
     * Format: #;id;isbn;title;author;language
     * @param array lines - an array of lines read from the file
     * @param int catid - the id of the category the houses should be added to
     */
    static function importHousesCSV($lines, $catid) {
        global $database;
        $retVal = array();
        $i = 0;
        foreach ($lines as $k => $line) {
            $tmp = array();
            if (trim($line) == "")
                continue;
            $line = explode('|', $line);
            array_push($line, "", "");
            $house = new mosRealEstateManager($database);

            $house->houseid = trim($line[0]);
            $house->description = $line[1];
            $house->link = $line[2];
            $house->listing_type = $line[3];
            if (($house->listing_type) != '') {
                $listing_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                $listing_type[_REALESTATE_MANAGER_OPTION_FOR_RENT] = 1;
                $listing_type[_REALESTATE_MANAGER_OPTION_FOR_SALE] = 2;
                $listing_type[_REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST] = 3;
                if(isset($listing_type[$house->listing_type] ) )
                    $house->listing_type = $listing_type[$house->listing_type];
                else $house->listing_type = intval($house->listing_type);

            } else  $house->listing_type = 0;

            $house->price = $line[4];
            $house->priceunit = $line[5];
            $house->htitle = $line[6];
            $house->hcountry = $line[7];
            $house->hregion = $line[8];
            $house->hcity = $line[9];
            $house->hzipcode = $line[11];
            $house->hlocation = $line[12];
            $house->hlatitude = $line[13];
            $house->hlongitude = $line[14];
            $house->map_zoom = $line[15];
            $house->bathrooms = $line[16];
            $house->bedrooms = $line[17];
            $house->contacts = $line[19];
            $house->image_link = $line[20];
            $house->listing_status = $line[21];
            if (($house->listing_status) != '') {
                $listing_status[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
                $k = 1;
                foreach ($listing_status1 as $listing_status2) {
                    $listing_status[$listing_status2] = $k;
                    $k++;
                }
                $house->listing_status = $listing_status[$house->listing_status];
            } else
                $house->listing_status = 0;
            $house->property_type = $line[23];
            if (($house->property_type) != '') {
                $property_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
                $k = 1;
                foreach ($property_type1 as $property_type2) {
                    $property_type[$property_type2] = $k;
                    $k++;
                }
                $house->property_type = $property_type[$house->property_type];
            } else
                $house->property_type = 0;

                $house->year = $line[25];
                $house->agent = $line[26];
                $house->house_size = $line[29];
                $house->lot_size = $line[31];
                $house->garages = $line[32];
                $house->date = $line[38];
                $house->hits = $line[39];
                $house->published = $line[40];
                $house->owneremail = trim($line[41]);
                $house->featured_clicks = $line[42];
                $house->featured_shows = $line[43];
                $house->extra1 = $line[44];
                $house->extra2 = $line[45];
                $house->extra3 = $line[46];
                $house->extra4 = $line[47];
                $house->extra5 = $line[48];
                $house->extra6 = $line[49];
                $house->extra7 = $line[50];
                $house->extra8 = $line[51];
                $house->extra9 = $line[52];
                $house->extra10 = $line[53];
                $house->language = $line[54];
                $house->owner_id = $line[55];
                $house->energy_value = $line[56];
                $house->climate_value = $line[57];
                $house->rooms = $line[58];
                $house->rent_by = $line[59];
                $house->extra11 = $line[60];
                $house->extra12 = $line[61];
                $house->extra13 = $line[62];

                $house->catid = $catid;
                $tmp[0] = $i;
                $tmp[1] = $house->houseid;
                $tmp[2] = $house->hlocation;
                $tmp[3] = $house->htitle;
            if (!$house->check() || !$house->store()) {
                $tmp[5] = $house->getError();
            } else {
                $tmp[5] = "OK";
                $house->saveCatIds($house->catid);
            }
            if (version_compare(JVERSION, "3.0.0", "lt")) {
                $house->checkin();
            }
            $retVal[$i] = $tmp;
            $i++;
        }

        return $retVal;
    }

    static function getXMLItemValue($item, $item_name,$default="") {
        $house_items = $item->getElementsByTagname($item_name);

        $house_item = $house_items->item(0);

        // if($item_name == "status"){
        //     echo ":1111111111111111112:";
        //     print_r($house_item);
        //     echo ":1111111111111111113:";
        //     print_r($default);
        //     echo ":1111111111111111114:";
        //     print_r($house_item->nodeValue);
        //     if( "0" === $house_item->nodeValue ) echo ":44444444444444:";

        // }

        if (NULL != $house_item && isset($house_item->nodeValue) 
            && ( ( "0" === $house_item->nodeValue ) || !empty($house_item->nodeValue) ) ) {
            return $house_item->nodeValue;
        }
        else if ("" != $default)
            return $default;
        else 
            return "";
    }

    static function findCategory(&$categories, $new_category) {
        global $database;
        // print_r($new_category) ;
        foreach ($categories as $category)
            if ($category->old_id == $new_category->old_id)
                return $category;

        $new_parent_id = -1;
        if ($new_category->old_parent_id != 0) {
            foreach ($categories as $category) {
                if ($category->old_id == $new_category->old_parent_id) {
                    $new_parent_id = $category->id;
                    break;
                }
            }
        } else
            $new_parent_id = 0;

        //sanity test
        if ($new_parent_id === -1) {
            echo "error in import !";
            exit;
        }
        $row = new mainRealEstateCategories($database);
        //$row->id = null;
        $row->section = 'com_realestatemanager';
        $row->parent_id = $new_parent_id;
        $row->name = $new_category->name;
        $row->title = $new_category->title;
        $row->published = $new_category->published;
        $row->params = $new_category->params;
        $row->params2 = $new_category->params2;
        $row->language = $new_category->language;
        $row->associate_category = $new_category->associate_category;
        $row->description = '';
        $row->metadata = $new_category->metadata;
        $row->publish_up = $new_category->publish_up;
        $row->publish_down = $new_category->publish_down;        


        if (!$row->check()) {
            echo "error in import2 !";
            exit;
            exit();
        }
        if (!$row->store()) {
            echo $row->getError() . '<br>';
            echo "error in import3 !";
            exit;
            exit();
        }

        $row->updateOrder("section='com_realestatemanager' AND parent_id='$row->parent_id'");
        $new_category->id = $row->id;
        $categories[] = $new_category;
        return $new_category;
    }

    static function updateAssociateCategories($infoArr){

        $dataToUpdate = array();
        global $database;
        if( !isset($infoArr) ) return ;
        for($i = 0; $i < count($infoArr); $i++){
            if(isset($infoArr[$i]['associate']) && $infoArr[$i]['associate']){
                $currentAssocId = array();
                $newObjAssociate = unserialize($infoArr[$i]['associate']);

                foreach ($newObjAssociate as $key=>$value){

                    if($value && $value != 0){
                        for($j = 0; $j < count($infoArr); $j++){
                            if(isset($infoArr[$j]['oldId']) && $infoArr[$j]['oldId'] == $value){
                                $newObjAssociate[$key] = $infoArr[$j]['newId'];
                                $currentAssocId[] = $infoArr[$j]['newId'];
                                break;
                            }
                        }
                    }
                }
                $newSerializAssoc = serialize($newObjAssociate);
                $currentAssocIdToString = implode(',', $currentAssocId);
                if(!isset($dataToUpdate[$newSerializAssoc])){
                    $dataToUpdate[$newSerializAssoc] = $currentAssocIdToString;
                }
            }
        }
        if(!empty($dataToUpdate)){
            foreach ($dataToUpdate as $key=>$value){
                if(isset($key) && $key !="" && isset($value) && $value !="" ){
                    $query = "UPDATE #__rem_main_categories
                              SET associate_category = '$key'
                              WHERE id in ($value) ";
                    $database->setQuery($query);
                    $database->execute();
                }
            }
        }
    }

    static function updateAssociateHouses($infoArr){


        $dataToUpdate = array();
        global $database;
        if( !isset($infoArr) ) return ;
        for($i = 0; $i < count($infoArr); $i++){
            if(isset($infoArr[$i]['associate']) && $infoArr[$i]['associate']){
                $currentAssocId = array();
                $newObjAssociate = unserialize($infoArr[$i]['associate']);

                foreach ($newObjAssociate as $key=>$value){

                    if($value && $value != 0){
                        for($j = 0; $j < count($infoArr); $j++){
                            if(isset($infoArr[$j]['oldId']) && $infoArr[$j]['oldId'] == $value){
                                $newObjAssociate[$key] = $infoArr[$j]['newId'];
                                $currentAssocId[] = $infoArr[$j]['newId'];
                                break;
                            }
                        }
                    }
                }
                $newSerializAssoc = serialize($newObjAssociate);
                $currentAssocIdToString = implode(',', $currentAssocId);
                if(!isset($dataToUpdate[$newSerializAssoc])){
                    $dataToUpdate[$newSerializAssoc] = $currentAssocIdToString;
                }
            }
        }
        if(!empty($dataToUpdate)){
            foreach ($dataToUpdate as $key=>$value){
                $query = "UPDATE #__rem_houses
                          SET associate_house = '$key'
                          WHERE id in ($value) ";
                $database->setQuery($query);
                $database->execute();
            }
        }
    }


    static function LoginTorontomlsServer($un,$pw) {

        $url = 'https://rets.torontomls.net:6103/rets-treb3pv/server/login';
        $curl_post_data = array(
          "Username" => $un,
          "Password" => $pw,
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "RETS-Version: RETS/1.7"));
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_USERPWD, $un . ":" . $pw);
        curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($ch);
        curl_close($ch);
   }


   static function curl_to_host($url,$curl_get_data, $headers, &$resp_headers,$un,$pw){

      $ch=curl_init($url.'?' . http_build_query($curl_get_data['query']));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
      curl_setopt($ch, CURLOPT_HTTPGET, 1);
      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST);
      curl_setopt($ch, CURLOPT_USERPWD, $un . ":" . $pw);
      curl_setopt($ch, CURLOPT_TIMEOUT, 30);
      curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
      curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      curl_setopt($ch, CURLOPT_HEADER, 1);
      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      $rtn=curl_exec($ch);
      curl_close($ch);
      $rtn=explode("\r\n\r\nHTTP/", $rtn, 2);    //to deal with "HTTP/1.1 100 Continue\r\n\r\nHTTP/1.1 200 OK...\r\n\r\n..." header
      $rtn=(count($rtn)>1 ? 'HTTP/' : '').array_pop($rtn);
      list($str_resp_headers, $rtn)=explode("\r\n\r\n", $rtn, 2);
      $str_resp_headers=explode("\r\n", $str_resp_headers);
      array_shift($str_resp_headers);    //get rid of "HTTP/1.1 200 OK"
      $resp_headers=array();
      foreach ($str_resp_headers as $k=>$v) {
              $v=explode(': ', $v, 2);
              $resp_headers[$v[0]]=$v[1];
        }

        return $rtn;
    }

    static function parse( $response, $Content_Type){

        $collection = array();
        // help bad responses be more multipart compliant
        $body = "\r\n" . $response . "\r\n";
        // multipart


        preg_match('/boundary\=\"(.*?)\"/', $Content_Type, $matches);

        if (isset($matches[1])) {
            $boundary = $matches[1];
        } else {
            preg_match('/boundary\=(.*?)(\s|$|\;)/', $Content_Type, $matches);
            if(!isset($matches[1])){
              $boundary = '';
            }else{
              $boundary = $matches[1];
            }
        }
        // strip quotes off of the boundary
        $boundary = preg_replace('/^\"(.*?)\"$/', '\1', $boundary);
        // clean up the body to remove a reamble and epilogue
        $body = preg_replace('/^(.*?)\r\n--' . $boundary . '\r\n/', "\r\n--{$boundary}\r\n", $body);
        // make the last one look like the rest for easier parsing
        $body = preg_replace('/\r\n--' . $boundary . '--/', "\r\n--{$boundary}\r\n", $body);
        // cut up the message
        $multi_parts = explode("\r\n--{$boundary}\r\n", $body);
        // take off anything that happens before the first boundary (the preamble)
        array_shift($multi_parts);
        // take off anything after the last boundary (the epilogue)
        array_pop($multi_parts);
        // go through each part of the multipart message
        foreach ($multi_parts as $part) {
            // get Guzzle to parse this multipart section as if it's a whole HTTP message
            $parts = mosRealEstateManagerImportExport::parseResponse("HTTP/1.1 200 OK\r\n" . $part);
            $collection[] = $parts;
        }
        return $collection;
    }

    static function parseResponse($message){
        if (!($parts = mosRealEstateManagerImportExport::parseMessage($message))) {
            return false;
        }
        list($protocol, $version) = explode('/', trim($parts['start_line'][0]));
        $arr = array(
                  'protocol'         => $protocol,
                  'protocol_version' => $version,
                  'code'             => $parts['start_line'][1],
                  'reason_phrase'    => isset($parts['start_line'][2]) ? $parts['start_line'][2] : '',
                  'headers'          => $parts['headers'],
                  'body'             => $parts['body']
              );
        return $arr;
    }

     static function parseMessage($message){
        if (!$message) {
            return false;
        }
        $startLine = null;
        $headers = array();
        $body = '';

        // Iterate over each line in the message, accounting for line endings
        $lines = preg_split('/(\\r?\\n)/', $message, -1, PREG_SPLIT_DELIM_CAPTURE);
        for ($i = 0, $totalLines = count($lines); $i < $totalLines; $i += 2) {

           $line = $lines[$i];

          // If two line breaks were encountered, then this is the end of body
          if (empty($line)) {
              if ($i < $totalLines - 1) {
                  $body = implode('', array_slice($lines, $i + 2));
              }
              break;
          }
            // Parse message headers
            if (!$startLine) {
                $startLine = explode(' ', $line, 3);
            } elseif (strpos($line, ':')) {
                $parts = explode(':', $line, 2);
                $key = trim($parts[0]);
                $value = isset($parts[1]) ? trim($parts[1]) : '';
                if (!isset($headers[$key])) {
                    $headers[$key] = $value;
                } elseif (!is_array($headers[$key])) {
                    $headers[$key] = array($headers[$key], $value);
                } else {
                    $headers[$key][] = $value;
                }
            }
        }
        $arr = array(
                'start_line' => $startLine,
                'headers'    => $headers,
                'body'       => $body
              );
        return $arr;
    }

   //if house not imported before - return: true  
   //if house imported before and new house fresh - return: old update date  
   //if no need update, return : false  
   static function CheckDate($mls,$pixUpdtedDt) {
      global $database;
      $selectstring = "SELECT id,pixUpdtedDt,houseid,hlocation,htitle FROM #__rem_houses WHERE houseid = '$mls'";
      $database->setQuery($selectstring);
      $houseData = $database->LoadRow();

      if( !isset($houseData) || count($houseData) <= 0 ) return true;
      if($houseData[1] == '0000-00-00 00:00:00') {
         return $houseData[0];
      }

      $pixUpdtedDt = new DateTime($pixUpdtedDt);
      $pixUpdtedDt = $pixUpdtedDt->format("Y-m-d H:i:s");

      if ($pixUpdtedDt > $houseData[1]){
          return $houseData[0];
      }else{
          return false;
      }

  }

  static function guid() {
      mt_srand((double)microtime() * 10000); //optional for php 4.2.0 and up.
      $charid = strtoupper(md5(uniqid(rand(), true)));
      $hyphen = chr(45);
      $uuid = substr($charid, 0, 8) . $hyphen . substr($charid, 8, 4) . $hyphen . substr($charid, 12, 4) . $hyphen . substr($charid, 16, 4) .
             $hyphen . substr($charid, 20, 12);
      return $uuid;
  }

  static function downloadPhoto($url){
      global $mosConfig_absolute_path;
//      echo "downloadPhoto url:".$url.":";
      $photo_name = "";
      $dir = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
      $code = mosRealEstateManagerImportExport::guid();
      file_put_contents($dir.$code.'.jpg',file_get_contents($url) );
      $photo_name  = $code.'.jpg';
      return $photo_name;
  }
  static function firstPhoto($response){
      global $mosConfig_absolute_path;
      $firstPhoto = "";
      if(!empty($response)) {
          $dir = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
          $code = mosRealEstateManagerImportExport::guid();
          file_put_contents($dir.$code.'.jpg',$response[0]["body"]);
          $firstPhoto  = $code.'.jpg';
      }
         return $firstPhoto;
  }

  static function photos($response){
     global $mosConfig_absolute_path;
     $photosArray = array();
     if(!empty($response)) {
        foreach($response as $key => $value) {
          $dir = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
          $code = mosRealEstateManagerImportExport::guid();
          file_put_contents($dir.$code.'.jpg',$value['body']);
          $photosArray[] = $code.'.jpg';
        }
    }
         return $photosArray;
  }
  static function LoginToMRESDMSServer($un,$pw) {
        $url = 'https://rets.mresdms.com:8080/rets2/rets/login';
        $curl_post_data = array(
          "Username" => $un,
          "Password" => $pw,
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "RETS-Version: RETS/1.7"));
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST);
        curl_setopt($ch, CURLOPT_USERPWD, $un . ":" . $pw);
        curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($ch);
        curl_close($ch);


   }



    static function importHousesXMLFromMRESDMS($catid){

      global $database,$mosConfig_absolute_path,$mosConfig_live_site,$realestatemanager_configuration;


        $logPath  = $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/my_log.log";

        if (file_exists($logPath)) {
          clearstatcache();
          $ret = time() - filemtime($logPath) ;
          if($ret < 600){
             echo "importHousesXMLFromMRESDMS exit, file accessed : " . $ret ."seconds ago <br />";
            file_put_contents($logPath, "importHousesXMLFromMRESDMS exit, file accessed : " . $ret ."seconds ago  \n\n",  FILE_APPEND );
            exit ;

          }
        }

        if ( file_exists($logPath) ) unlink($logPath);
        file_put_contents($logPath, "   import start ".time()." \n",  FILE_APPEND );

        {
            $query = "SELECT rh.id FROM #__rem_houses as rh LEFT JOIN #__rem_mls_for_delete".
             " AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid";
            $database->setQuery($query);
            $bid = $database->loadColumn();

            $query = "SELECT * FROM #__rem_mls_for_delete ";
            $database->setQuery($query);
            $mls = $database->loadColumn();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start1 " . count($mls) ."::". count($bid)."::" .time()." \n\n",  FILE_APPEND );


            if(count($mls) > 0 && count($bid)>0)
            {


                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start2 ".time()." \n\n",  FILE_APPEND );

                self::removeHouses($bid);

                //not active houses removed, clear array with active
                $query = "DELETE FROM #__rem_mls_for_delete";
                $database->setQuery($query);
                $database->execute();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," after remove 11 ".time()." \n\n",  FILE_APPEND );


            } else {

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start3 ".time()." \n\n",  FILE_APPEND );

                //not active houses removed, clear array with active
                $query = "DELETE FROM #__rem_mls_for_delete";
                $database->setQuery($query);
                $database->execute();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," after remove 12  ".time()." \n\n",  FILE_APPEND );

            }
            unset($bid);
            unset($mls);


        }

      if(!empty($realestatemanager_configuration['mresdms_login']) && !empty($realestatemanager_configuration['mresdms_password'])) {
         $un = $realestatemanager_configuration['mresdms_login'];
         $pw = $realestatemanager_configuration['mresdms_password'];
         mosRealEstateManagerImportExport::LoginToMRESDMSServer($un,$pw);
      } else {
        echo "<script> alert(\"" . _REALESTATE_MANAGER_ADMIN_CONFIG_TREB_IMPORT_REQUIRED_FIELD . "\"); window.history.go(-1); </script>\n";
        exit();
      }


      $retVal = array();
      $properties = 0;

      $classes = array(
         1 => 'RES',
          2 => 'COM',
           3 => 'MUL',
            4 => 'FRM'
      );

      ini_set('max_execution_time', 0);
      $count_record_arr = array();
      $count_added_arr = array();
      $mls = array();

      foreach($classes as $val) {

        if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," import start22 ".time()." \n\n",  FILE_APPEND );

      $url = 'https://rets.mresdms.com:8080/rets2/rets/search';
      $curl_post_data = array(
        "query" => array(
          'SearchType'=>'Property',
          'Class' => $val,
          'QueryType' => "DMQL2",
          'Format' => "STANDARD-XML",
          'StandardNames' => "0",
          'Query' => "(STATUS=STACT)",
          'Count' => "1",
          'Limit' => "3",

        )
      );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.'?' . http_build_query($curl_post_data['query']));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "RETS-Version: RETS/1.7"));
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPGET, 1);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST);
        curl_setopt($ch, CURLOPT_TIMEOUT, 140);
        curl_setopt($ch,CURLOPT_USERPWD, $un . ":" . $pw);
        curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($ch);


        if($errno = curl_errno($ch)) {
                $error_message = curl_strerror($errno);
                echo "cURL error ({$errno}):\n {$error_message}";

                    if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," import start222 "."cURL error ({$errno}):\n {$error_message}"."  ".time()." \n\n",  FILE_APPEND );
            }

        curl_close($ch);
        $ret = simplexml_load_string($response);
        unset($response);



        if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," import start3   ".time()." \n\n",  FILE_APPEND );

        $count = 0;

        if(!empty($ret)) {

           if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," import start4  ". $ret->COUNT->attributes()->Records->__toString()." ".time()." \n\n",  FILE_APPEND );


        foreach($ret->REData->REProperties->Listing as $key => $value) {

            // print_r((string)$value->ListingID);
            // exit;

            // echo "import: $count \n"; flush();   if( ob_get_level() > 0 ) ob_flush(); //fix error: Maximum execution time
            if (!file_exists($logPath)) exit; //remove file and break import
            file_put_contents($logPath, $count."   ". memory_get_usage() ." ".time()." \n",  FILE_APPEND );


            //add acctive houses, for find not active
            $mls[]= (string)$value->ListingID;

            $id_house = mosRealEstateManagerImportExport::CheckDate((string)$value->ListingID, (string)$value->ListingData->ListDate);

            if($id_house !== false) {

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath,"YES3 --> ".$id_house."::".(string)$value->ListingID." ".time()." \n\n",  FILE_APPEND );

                 $house_class = new mosRealEstateManager($database);


                 if($id_house !== true ) {
                     $house_class->load($id_house);
                     //delete old house for update
                     $arr_for_update = array();
                     $arr_for_update[] = $id_house ;
                     //remove images
                     self::updateHouses( $arr_for_update );
                 }




                 $url = 'https://rets.mresdms.com:8080/rets2/rets/getObject';
                  $curl_post_data = array(
                  "query" => array(
                  'Resource'=> 'Property',
                  'ID' => (string)$value->ListingID.':'.'*',
                  'Type' => 'Photo',
                  ),
                );



                $headers = array("Content-Type: application/json", "RETS-Version: RETS/1.7");
                $responseFromCurl = mosRealEstateManagerImportExport::curl_to_host($url,$curl_post_data,$headers,$resp_headers,$un,$pw);

                $response = mosRealEstateManagerImportExport::parse($responseFromCurl, $resp_headers['Content-Type']);


                $houseid = $house_class->houseid = (string)$value->ListingID;
                //get description
                 $house_description = $house_class->description = htmlspecialchars((string)$value->ListingData->PublicRemarks);
                 //get listing_type

                 // $SaleLease = isset($value->Listing->SaleLease) && (string)$value->Listing->SaleLease!='null'?(string)$value->Listing->SaleLease:''; //type sale/rent

                 // if(trim($SaleLease) == 'Lease'){
                 //    $house_class->listing_type = 1;
                 // }else if(trim($SaleLease) == 'Sale'){
                 //    $house_class->listing_type = 2;
                 // }else{
                 //    $house_class->listing_type = 0;
                 // }
                 $house_class->listing_type = 2;

                 //get rent_by
	            if($house_class->listing_type == 1 ) $house_class->rent_by = 'by_night'; 

                 //get price
                 // $house_class->property_type = (string)$value->Listing->TypeOwn1Out;

                //  if (($house_class->property_type) != '') {
                //     $property_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                //     $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
                //     $k = 1;
                //     foreach ($property_type1 as $property_type2) {
                //         $property_type[$property_type2] = $k;
                //         $k++;
                //     }
                //     $house_class->property_type = $property_type[$house_class->property_type];
                // } else

                $house_class->property_type = 0;

                 $house_class->price = (int)$value->ListingData->ListPrice;
                 //get priceunit
                 $house_priceunit = $house_class->priceunit = "USD";
                 //get Title(house)
                 $house_htitle = $house_class->htitle = (string)$value->StreetAddress->StreetNumber.', '.(string)$value->StreetAddress->StreetName.', '.(string)$value->StreetAddress->StreetSuffix.', '.(string)$value->StreetAddress->City;
                 //get country
                 $house_class->hcountry = (string)$value->StreetAddress->Country;
                 //get region
                 $house_class->hregion = (string)$value->StreetAddress->StateOrProvince;
                 //get city
                 $house_class->hcity = (string)$value->StreetAddress->City;
                 //get zipcode
                 $house_class->hzipcode = (string)$value->StreetAddress->PostalCode;
                 //get location
                 $house_hlocation = $house_class->hlocation = $house_htitle;
                //get bathrooms
                 // $house_class->bathrooms =(int)$value->Listing->Washrooms;
                 //get bedrooms
                 // $house_class->bedrooms = (int)$value->Listing->Bedrooms;
                 //get rooms
                 // $house_class->rooms = (int)$value->Listing->Rooms;
                 //get mainImage


                 $house_class->image_link = mosRealEstateManagerImportExport::firstPhoto($response);


                 //get lot_size
                 // $LotFront = isset($value->Listing->LotFront) && (int)$value->Listing->LotFront?$value->Listing->LotFront:0; //LotFront
                 // $house_class->lot_size = (int)$value->Listing->LotDepth + $LotFront;
                 //get house_size
                 // $house_class->house_size = (int)$value->Listing->ApproxSquareFootage;
                 //get garages
                 // $house_class->garages = (int)$value->Listing->GarageSpaces;
                 //get date
                 $house_class->date = date("Y-m-d");
                 //get last update
                 $house_class->pixUpdtedDt = (string)$value->ListingData->ListDate;
                 //get published
                 $house_class->published = 1;


                 $house_class->agent = (string)$value->ListingData->REAgent->FirstName." ".(string)$value->ListingData->REAgent->LastName;

                 $house_class->owneremail = (string)$value->ListingData->REAgent->ContactInformation->Email;
                 $house_class->contacts = (string)$value->ListingData->REAgent->ContactInformation->OfficePhone;
                 $house_class->listing_status = 1;//if status Active
                 $house_class->hlatitude = (string)$value->GeographicData->Latitude;
                 $house_class->hlongitude = (string)$value->GeographicData->Longitude;
                 $house_class->map_zoom = 14;




                $tempcat = array();


                // if(isset($_GET['task']) && $_GET['task'] == 'link_import'){
                //     // $catid = array();
                //      if(trim($SaleLease) == 'Lease'){
                //         $catid = '55';
                //      }else if(trim($SaleLease) == 'Sale'){
                //         $catid = '54';
                //      }
                // }

                $tempcat = $catid;



                //for output rezult in table
                // $tmp[0] = $properties;
                // $tmp[1] = $houseid;
                // $tmp[2] = $house_hlocation;
                // $tmp[3] = $house_htitle;

                //check houseid for existing
                if (!$house_class->check() || !$house_class->store()) {
                    // $tmp[5] = $house_class->getError();
                } else {
                    $house_class->saveCatIds($tempcat);
                    // $tmp[5] = "<font color='green'>OK</font>";
                }
                // $retVal[$properties] = $tmp;

              $AllPhotosOneHouse = mosRealEstateManagerImportExport::photos($response);



                if ($AllPhotosOneHouse) {
                    for ($j = 0; $j< count($AllPhotosOneHouse); $j++) {
                        $database->setQuery("INSERT INTO #__rem_photos " .
                                "\n (fk_houseid,main_img)" .
                                "\n VALUES " .
                                "\n (" . $house_class->id .",
                                    '" . $AllPhotosOneHouse[$j] . "');");
                        $database->execute();
                    } //end for(...) - images
                } //end if(...) - images
                $properties++;

                unset($house_class);
            } else {

                if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath,"NO --> ".(string)$value->ListingID." ".time()." \n\n",  FILE_APPEND );
                    // $tmp[0] = $properties;
                    // $tmp[1] = $IsCheckDate[2];
                    // $tmp[2] = $IsCheckDate[3];
                    // $tmp[3] = $IsCheckDate[4];
                    // $tmp[5] = "<font color='red'>NOT UPDATE</font>";
                    // $retVal[$properties] = $tmp;
                    // $properties++;
                }

               $count++;   //for delete function

            } //end foreach
          } // end $ret

          $count_added_arr[] = $count;
          $count_record_arr[] = ($ret->COUNT)?$ret->COUNT->attributes()->Records->__toString():0;

        }   // end foreach classes

        //Uncomment if you want switch on delete function
          $count_added = array_sum($count_added_arr);
            $count_record = array_sum($count_record_arr);

            // $count_record = 15;

                    if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," afret import ".count($count_added_arr)."::".$count_added . "::" . $count_record
                        ."::" . $count_added_arr[0]."::" . $count_added_arr[1]."::" . $count_added_arr[2]." ".time()." \n\n",  FILE_APPEND );


            //check was errors  at import time, if errors exist - not run housee delete
            if(count($count_added_arr) == 3 && $count_added_arr[0] > 0 && $count_added_arr[1] > 0 && $count_added_arr[2] > 0
            && $count_added == $count_record && $count_added != 0 )
            {

                    if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," remove start0 ".time()." \n\n",  FILE_APPEND );


                //insert mls fetched houses for nex delete not active
                foreach ($mls as $value) {
                    $query = "INSERT INTO #__rem_mls_for_delete VALUES(null,'".$value."')";
                    $database->setQuery($query);
                    $database->execute();
                }
                $mls_count = count($mls);
                unset($mls);

                $query = "SELECT rh.id FROM #__rem_houses as rh LEFT JOIN #__rem_mls_for_delete".
                 " AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid";
                $database->setQuery($query);
                $bid = $database->loadColumn();


                // SELECT rh.id FROM zm8wo_rem_houses as rh LEFT JOIN zm8wo_rem_mls_for_delete
                //  AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid

                // SELECT rh.id FROM zm8wo_rem_houses as rh
                // where not exists ( select * from zm8wo_rem_mls_for_delete
                //  AS mls where rh.houseid = mls.mls)


                // SELECT rh.* FROM zm8wo_rem_houses as rh
                // where not exists ( select * from zm8wo_rem_categories
                //  AS rc where rh.id = rc.iditem)


                // SELECT rp.id FROM zm8wo_rem_photos as rp
                // where not exists ( select * from zm8wo_rem_houses
                //  AS rh where rh.id = rp.fk_houseid)


                if($mls_count > 0 && count($bid)>0)
                {
                    if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," remove start ".time()." \n\n",  FILE_APPEND );

                    self::removeHouses($bid);

                    //not active houses removed, clear array with active
                    $query = "DELETE FROM #__rem_mls_for_delete";
                    $database->setQuery($query);
                    $database->execute();

                    if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," after remove 22 ".time()." \n\n",  FILE_APPEND );


                } else {
                    if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," remove start 1232 ".time()." \n\n",  FILE_APPEND );

                    //not active houses removed, clear array with active
                    $query = "DELETE FROM #__rem_mls_for_delete";
                    $database->setQuery($query);
                    $database->execute();

                    if (!file_exists($logPath)) exit; //remove file and break import
                    file_put_contents($logPath," after remove 23 ".time()." \n\n",  FILE_APPEND );
                }


            }

            return;
    }

//******************   begin add for import XML format from TREB ****************************
    static function importHousesXMLFromToronto($catid){
      global $database,$mosConfig_absolute_path,$mosConfig_live_site,$realestatemanager_configuration;

      //ini_set('display_errors', '1');

      // wget -q -O - "http://theredbrick.ca/index.php?option=com_realestatemanager&task=link_import" >/dev/null 2>&1
        // CURL

        $logPath  = $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/my_log.log";

        //exit if now import or map update is going
        if (file_exists($logPath)) {
          clearstatcache();
          $ret = time() - filemtime($logPath) ;
          if($ret < 600){
             echo "importHousesXMLFromToronto exit, file accessed : " . $ret ."seconds ago <br />";
            file_put_contents($logPath, "importHousesXMLFromToronto exit, file accessed : " . $ret ."seconds ago  \n\n",  FILE_APPEND );
            exit ;

          }
        }

        //clear old log and start import
        if ( file_exists($logPath) ) unlink($logPath);
        file_put_contents($logPath, "   import start ".time()." \n",  FILE_APPEND );


        //first remove all not active houses
        {
            $query = "SELECT rh.id FROM #__rem_houses as rh LEFT JOIN #__rem_mls_for_delete".
             " AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid";
            $database->setQuery($query);
            $bid = $database->loadColumn();

            $query = "SELECT * FROM #__rem_mls_for_delete ";
            $database->setQuery($query);
            $mls = $database->loadColumn();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start1 " . count($mls) ."::". count($bid)."::" .time()." \n\n",  FILE_APPEND );


            if(count($mls) > 0 && count($bid)>0)
            {


                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start2 ".time()." \n\n",  FILE_APPEND );

                self::removeHouses($bid);

                //not active houses removed, clear array with active
                $query = "DELETE FROM #__rem_mls_for_delete";
                $database->setQuery($query);
                $database->execute();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," after remove 11 ".time()." \n\n",  FILE_APPEND );


            } else {

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start3 ".time()." \n\n",  FILE_APPEND );

                //not active houses removed, clear array with active
                $query = "DELETE FROM #__rem_mls_for_delete";
                $database->setQuery($query);
                $database->execute();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," after remove 12  ".time()." \n\n",  FILE_APPEND );

            }
            unset($bid);
            unset($mls);


        }

      if(!empty($realestatemanager_configuration['toronto_login']) && !empty($realestatemanager_configuration['toronto_password'])) {
         $un = $realestatemanager_configuration['toronto_login'];
         $pw = $realestatemanager_configuration['toronto_password'];
         mosRealEstateManagerImportExport::LoginTorontomlsServer($un,$pw);
      } else {
        if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," import start2  ".time()." \n\n",  FILE_APPEND );

        echo "<script> alert(\"" . _REALESTATE_MANAGER_ADMIN_CONFIG_TREB_IMPORT_REQUIRED_FIELD . "\"); window.history.go(-1); </script>\n";
        exit();
      }


      $retVal = array();
      $properties = 0;

      $classes = array(
        1 => 'ResidentialProperty',
        2 => 'CommercialProperty',
        3 => 'CondoProperty',
      );

      ini_set('max_execution_time', 0);
      $count_record_arr = array();
      $count_added_arr = array();
      $mls = array();

      foreach($classes as $val) {

        if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," import start22 ".time()." \n\n",  FILE_APPEND );

      $url = 'https://rets.torontomls.net:6103/rets-treb3pv/server/search';
      $curl_post_data = array(
        "query" => array(
          'SearchType'=>'Property',
          'Class' => $val,
          'Query' => "((status=A))",
          'QueryType' => "DMQL2",
          'Count' => "1",
          'Format' => "STANDARD-XML",
          'Limit' => "5",
          'StandardNames' => "0",
        ),
      );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url.'?' . http_build_query($curl_post_data['query']));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "RETS-Version: RETS/1.7"));
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_HTTPGET, 1);
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($ch, CURLOPT_TIMEOUT, 140);
    curl_setopt($ch,CURLOPT_USERPWD, $un . ":" . $pw);
    curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
    curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    $response = curl_exec($ch);


    if($errno = curl_errno($ch)) {
            $error_message = curl_strerror($errno);
            echo "cURL error ({$errno}):\n {$error_message}";

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," import start222 "."cURL error ({$errno}):\n {$error_message}"."  ".time()." \n\n",  FILE_APPEND );
        }

    curl_close($ch);
    $ret = simplexml_load_string($response);
    unset($response);

    if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," import start3   ".time()." \n\n",  FILE_APPEND );

    $count = 0;

    if(!empty($ret)) {

       if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," import start4  ". $ret->COUNT->attributes()->Records->__toString()." ".time()." \n\n",  FILE_APPEND );


    foreach($ret->REData->REProperties->$val as $key => $value) {

        // echo "import: $count \n"; flush();   if( ob_get_level() > 0 ) ob_flush(); //fix error: Maximum execution time
        if (!file_exists($logPath)) exit; //remove file and break import
        file_put_contents($logPath, $count."   ". memory_get_usage() ." ".time()." \n",  FILE_APPEND );


        //add acctive houses, for find not active
        $mls[]= $value->Listing->MLS ;

        $id_house = mosRealEstateManagerImportExport::CheckDate($value->Listing->MLS, $value->Listing->TimestampSql);

        if($id_house !== false) {

            if (!file_exists($logPath)) exit; //remove file and break import
            file_put_contents($logPath,"YES3 --> ".$id_house."::".$value->Listing->MLS." ".time()." \n\n",  FILE_APPEND );

             $house_class = new mosRealEstateManager($database);


             if($id_house !== true ) {
                 $house_class->load($id_house);
                 //delete old house for update
                 $arr_for_update = array();
                 $arr_for_update[] = $id_house ;
                 //remove images
                 self::updateHouses( $arr_for_update );
             }

             $url = 'https://rets.torontomls.net:6103/rets-treb3pv/server/getobject';
              $curl_post_data = array(
              "query" => array(
              'Resource'=> 'Property',
              'ID' => $value->Listing->MLS.':'.'*',
              'Type' => 'Photo',
              ),
            );
            $headers = array("Content-Type: application/json", "RETS-Version: RETS/1.7");
            $responseFromCurl = mosRealEstateManagerImportExport::curl_to_host($url,$curl_post_data,$headers,$resp_headers,$un,$pw);
            $response = mosRealEstateManagerImportExport::parse($responseFromCurl,$resp_headers['Content-Type']);




             $SaleLease = isset($value->Listing->SaleLease) && (string)$value->Listing->SaleLease!='null'?(string)$value->Listing->SaleLease:''; //type sale/rent

             if(trim($SaleLease) == 'Lease'){
                $house_class->listing_type = 1;
                $house_class->rent_by = 'by_night';
             }else if(trim($SaleLease) == 'Sale'){
                $house_class->listing_type = 2;
             }else{
                $house_class->listing_type = 0;
             }

            //get HouseID
             $houseid = $house_class->houseid = (string)$value->Listing->MLS;
            //get description
             $house_description = $house_class->description = htmlspecialchars((string)$value->Listing->RemarksForClients)."<br/>".htmlspecialchars((string)$value->Listing->Extras);
             //get listing_type


             //get price
             $house_class->property_type = (string)$value->Listing->TypeOwn1Out;

             if (($house_class->property_type) != '') {
                $property_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
                $k = 1;
                foreach ($property_type1 as $property_type2) {
                    $property_type[$property_type2] = $k;
                    $k++;
                }
                if(isset($property_type[$house_class->property_type]))
                {
                    $house_class->property_type = $property_type[$house_class->property_type];
                }else{
                    $house_class->property_type = 0;
                }

            } else
                $house_class->property_type = 0;

             $house_class->price = $value->Listing->ListPrice;
             //get priceunit
             $house_priceunit = $house_class->priceunit = "USD";
             //get Title(house)
             $house_htitle = $house_class->htitle = (string)$value->Listing->Address;
             //get country
             $house_class->hcountry = "Canada";
             if($house_class->hregion != (string)$value->Listing->Province
                || $house_class->hcity != (string)$value->Listing->Municipality
                || $house_class->hzipcode != (string)$value->Listing->PostalCode
                || $house_class->hlocation != (string)$value->Listing->Address )
             {
                 //get region
                 $house_class->hregion = (string)$value->Listing->Province;
                 //get city
                 $house_class->hcity = (string)$value->Listing->Municipality;
                 //get zipcode
                 $house_class->hzipcode = (string)$value->Listing->PostalCode;
                 //get location
                 $house_hlocation = $house_class->hlocation = (string)$value->Listing->Address;
                 //if update - reset longitude and latitude, clear ZERO_RESULTS from google updateMap
                 $house_class->hlatitude = "";
                 $house_class->hlongitude = "";
             }
            //get bathrooms
             $house_class->bathrooms =(int)$value->Listing->Washrooms;
             //get bedrooms
             $house_class->bedrooms = (int)$value->Listing->Bedrooms;
             //get rooms
             $house_class->rooms = (int)$value->Listing->Rooms;
             //get mainImage
             $house_class->image_link = mosRealEstateManagerImportExport::firstPhoto($response);
             //get lot_size
             $LotFront = isset($value->Listing->LotFront) && (int)$value->Listing->LotFront?$value->Listing->LotFront:0; //LotFront
             $house_class->lot_size = (int)$value->Listing->LotDepth + $LotFront;
             //get house_size
             $house_class->house_size = (int)$value->Listing->ApproxSquareFootage;
             //get garages
             $house_class->garages = (int)$value->Listing->GarageSpaces;
             //get date
             $house_class->date = date("Y-m-d H:i:s");
             //get last update
             $house_class->pixUpdtedDt = substr($value->Listing->TimestampSql, 0, strlen($value->Listing->TimestampSql) - 2);
             //get published
             $house_class->published = 1;
              //get category

            $tempcat = array();


            // if(isset($_GET['task']) && $_GET['task'] == 'link_import'){
            //     // $catid = array();
            //      if(trim($SaleLease) == 'Lease'){
            //         $catid = '55';
            //      }else if(trim($SaleLease) == 'Sale'){
            //         $catid = '54';
            //      }
            // }

            $tempcat = $catid;



            //for output rezult in table
            // $tmp[0] = $properties;
            // $tmp[1] = $houseid;
            // $tmp[2] = $house_hlocation;
            // $tmp[3] = $house_htitle;

            //check houseid for existing
            if (!$house_class->check() || !$house_class->store()) {
                // $tmp[5] = $house_class->getError();
            } else {
                $house_class->saveCatIds($tempcat);
                // $tmp[5] = "<font color='green'>OK</font>";
            }
            // $retVal[$properties] = $tmp;

          $AllPhotosOneHouse = mosRealEstateManagerImportExport::photos($response);
            if ($AllPhotosOneHouse) {
                for ($j = 0; $j< count($AllPhotosOneHouse); $j++) {
                    $database->setQuery("INSERT INTO #__rem_photos " .
                            "\n (fk_houseid,main_img)" .
                            "\n VALUES " .
                            "\n (" . $house_class->id .",
                                '" . $AllPhotosOneHouse[$j] . "');");
                    $database->execute();
                } //end for(...) - images
            } //end if(...) - images
            $properties++;

            unset($house_class);
        } else {

            if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath,"NO --> ".$value->Listing->MLS." ".time()." \n\n",  FILE_APPEND );
                // $tmp[0] = $properties;
                // $tmp[1] = $IsCheckDate[2];
                // $tmp[2] = $IsCheckDate[3];
                // $tmp[3] = $IsCheckDate[4];
                // $tmp[5] = "<font color='red'>NOT UPDATE</font>";
                // $retVal[$properties] = $tmp;
                // $properties++;
            }

           $count++;   //for delete function

        } //end foreach
      } // end $ret

      $count_added_arr[] = $count;
      $count_record_arr[] = ($ret->COUNT)?$ret->COUNT->attributes()->Records->__toString():0;

    }   // end foreach classes

    //Uncomment if you want switch on delete function
      $count_added = array_sum($count_added_arr);
        $count_record = array_sum($count_record_arr);

        // $count_record = 15;

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," afret import ".count($count_added_arr)."::".$count_added . "::" . $count_record
                    ."::" . $count_added_arr[0]."::" . $count_added_arr[1]."::" . $count_added_arr[2]." ".time()." \n\n",  FILE_APPEND );


        //check was errors  at import time, if errors exist - not run housee delete
        if(count($count_added_arr) == 3 && $count_added_arr[0] > 0 && $count_added_arr[1] > 0 && $count_added_arr[2] > 0
        && $count_added == $count_record && $count_added != 0 )
        {

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start0 ".time()." \n\n",  FILE_APPEND );


            //insert mls fetched houses for nex delete not active
            foreach ($mls as $value) {
                $query = "INSERT INTO #__rem_mls_for_delete VALUES(null,'".$value."')";
                $database->setQuery($query);
                $database->execute();
            }
            $mls_count = count($mls);
            unset($mls);

            $query = "SELECT rh.id FROM #__rem_houses as rh LEFT JOIN #__rem_mls_for_delete".
             " AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid";
            $database->setQuery($query);
            $bid = $database->loadColumn();


// SELECT rh.id FROM zm8wo_rem_houses as rh LEFT JOIN zm8wo_rem_mls_for_delete
//  AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid

// SELECT rh.id FROM zm8wo_rem_houses as rh
// where not exists ( select * from zm8wo_rem_mls_for_delete
//  AS mls where rh.houseid = mls.mls)


// SELECT rh.* FROM zm8wo_rem_houses as rh
// where not exists ( select * from zm8wo_rem_categories
//  AS rc where rh.id = rc.iditem)


// SELECT rp.id FROM zm8wo_rem_photos as rp
// where not exists ( select * from zm8wo_rem_houses
//  AS rh where rh.id = rp.fk_houseid)


            if($mls_count > 0 && count($bid)>0)
            {
                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start ".time()." \n\n",  FILE_APPEND );

                self::removeHouses($bid);

                //not active houses removed, clear array with active
                $query = "DELETE FROM #__rem_mls_for_delete";
                $database->setQuery($query);
                $database->execute();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," after remove 22 ".time()." \n\n",  FILE_APPEND );


            } else {
                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," remove start 1232 ".time()." \n\n",  FILE_APPEND );

                //not active houses removed, clear array with active
                $query = "DELETE FROM #__rem_mls_for_delete";
                $database->setQuery($query);
                $database->execute();

                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath," after remove 23 ".time()." \n\n",  FILE_APPEND );
            }


        }

        return;
  }




static function removeHouses($bid,$if_clon=NULL) {

        global $database, $mosConfig_absolute_path;
        if (!is_array($bid) || count($bid) < 1) {
            echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM .
              "'); window.history.go(-1);</script>\n";
            exit;
        }


        $bids = implode(',', $bid);
        $logPath  = $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/my_log.log";
        if (!file_exists($logPath)) exit; //remove file and break import
        file_put_contents($logPath," remove start 1111 ".time()." \n\n",  FILE_APPEND );


        $database->setQuery("DELETE FROM #__rem_rent WHERE fk_houseid IN ($bids) ");
        $database->execute() ;

        $database->setQuery("DELETE FROM #__rem_review WHERE fk_houseid IN ($bids)");
        $database->execute();

        $database->setQuery("DELETE FROM #__rem_categories WHERE iditem IN ($bids)");
        $database->execute() ;

        $database->setQuery("DELETE FROM #__rem_feature_houses WHERE fk_houseid IN ($bids)");
        $database->execute() ;


        for($i = 0; $i < count($bid); $i++){

            $query = "select associate_house from #__rem_houses where id =".$bid[$i];
            $database->setQuery($query);
            $houseAssociateHouse = $database->loadResult();

            $assocHouseObj = unserialize($houseAssociateHouse);
            $idWhereChange = array();
            if(!empty($assocHouseObj)){
                foreach ($assocHouseObj as $key => $value) {
                    if($value == $bid[$i]){
                        $assocHouseObj[$key] = null;
                    }else if($value){
                        $idWhereChange[] = $value;
                    }
                }

                $stringIdWhereChange = implode(',', $idWhereChange);
                $newAssocSerialize = serialize($assocHouseObj);
                if(!empty($stringIdWhereChange)){
                    $query =
                      "update #__rem_houses set associate_house ='$newAssocSerialize' " .
                       " where id in($stringIdWhereChange)";
                    $database->setQuery($query);
                    $database->execute();
                }
            }
        }

        if (count($bid)) {

            foreach ($bid as $h_id) {

                  $sql = "SELECT src FROM #__rem_video_source WHERE fk_house_id =". $h_id;
                  $database->setQuery($sql);
                  $videos = $database->loadColumn();
                  if ($videos) {
                    foreach($videos as $name) {
                      if (substr($name, 0, 4) != "http" && file_exists($mosConfig_absolute_path . $name))
                        unlink($mosConfig_absolute_path . $name);
                    }
                  }
                  $sql = "DELETE FROM #__rem_video_source
                          WHERE (fk_house_id = $h_id)";
                  $database->setQuery($sql);
                  $database->execute();

                  $sql = "SELECT src FROM #__rem_track_source WHERE fk_house_id =". $h_id;
                  $database->setQuery($sql);
                  $track = $database->loadColumn();
                  if ($track) {
                    foreach($track as $name) {
                      if (substr($name, 0, 4) != "http" && file_exists($mosConfig_absolute_path . $name))
                        unlink($mosConfig_absolute_path . $name);
                    }
                  }
                  $sql = "DELETE FROM #__rem_track_source
                          WHERE (fk_house_id = $h_id)";
                  $database->setQuery($sql);
                  $database->execute();
            }



            $database->setQuery("SELECT * FROM  #__rem_houses WHERE id IN (" . $bids . ")");
            $del_rem = $database->loadObjectList();

            for ($i = 0; $i < count($del_rem); $i++) {

//echo "remove1: ".$i." \n"; flush();   if( ob_get_level() > 0 ) ob_flush(); //fix error: Maximum execution time
if (!file_exists($logPath)) exit; //remove file and break import
file_put_contents($logPath," remove 1 ".$i." ".time()." \n\n",  FILE_APPEND );

                  if ($del_rem[$i]->image_link != '' )
                  {
                       $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos';
                       $del_photo_mask_inf = pathinfo($del_rem[$i]->image_link);
                       $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
                       $del_photo_mask = basename($del_rem[$i]->image_link, $del_photo_mask_type);

                       if(strlen($del_photo_mask) < 20 ) continue ;

                        @set_time_limit(ini_get('max_execution_time'));
                        array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );
                  }
            }


            $database->setQuery("SELECT fk_houseid,thumbnail_img, main_img FROM #__rem_photos WHERE fk_houseid IN ($bids)");
            $del_photos = $database->loadObjectList();
            for ($i = 0; $i < count($del_photos); $i++) {

//echo "remove2: ".$i." \n"; flush();   if( ob_get_level() > 0 ) ob_flush(); //fix error: Maximum execution time
if (!file_exists($logPath)) exit; //remove file and break import
file_put_contents($logPath," remove 2 ".$i." ".time()." \n\n",  FILE_APPEND );

                  if ($del_photos[$i]->main_img != '')
                  {

                       $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos';
                       $del_photo_mask_inf = pathinfo($del_photos[$i]->main_img);
                       $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
                       $del_photo_mask = basename($del_photos[$i]->main_img, $del_photo_mask_type);

                       if(strlen($del_photo_mask) < 20 ) continue ;

                        @set_time_limit(ini_get('max_execution_time'));
                        array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );

                   }
                    $database->setQuery("DELETE FROM #__rem_photos WHERE fk_houseid = " . $del_photos[$i]->fk_houseid );
                    $database->execute() ;


                    $database->setQuery("DELETE FROM #__rem_houses WHERE id =" . $del_photos[$i]->fk_houseid );
                    $database->execute();
            }



            $database->setQuery("DELETE FROM #__rem_photos WHERE fk_houseid IN ($bids)");
            $database->execute() ;



            $database->setQuery("DELETE FROM #__rem_houses WHERE id IN ($bids)");
            $database->execute() ;
        }

//    if(removeHouse){
//        for($j = 0; $j < count($houseAssociateHouse); $j++){
//            removeHouses($houseAssociateHouse, $option, $if_clon);
//        }
//    }

    // mosRedirect("index.php?option=$option");
}

static function removeAllHouses($is_sample_data) {
    global $database, $mosConfig_absolute_path;

    mosRealEstateManagerImportExport::clearDatabase();
    if($is_sample_data) return; //images in photos - no need remove

    $file_indexhtml = $mosConfig_absolute_path . '/components/com_realestatemanager/index.html';

    $path_files_edocs = $mosConfig_absolute_path . '/components/com_realestatemanager/edocs';
    @set_time_limit(ini_get('max_execution_time'));
    array_map( "unlink", glob( $path_files_edocs . '/' . '*.*' ) );
    copy($file_indexhtml, $path_files_edocs . '/index.html');

    $path_files_tracks = $mosConfig_absolute_path . '/components/com_realestatemanager/media/track';
    @set_time_limit(ini_get('max_execution_time'));
    array_map( "unlink", glob( $path_files_tracks . '/' . '*.*' ) );
    copy($file_indexhtml, $path_files_tracks . '/index.html');

    $path_files_videos = $mosConfig_absolute_path . '/components/com_realestatemanager/media/video';
    @set_time_limit(ini_get('max_execution_time'));
    array_map( "unlink", glob( $path_files_videos . '/' . '*.*' ) );
    copy($file_indexhtml, $path_files_videos . '/index.html');

    $path_files_photos = $mosConfig_absolute_path . '/components/com_realestatemanager/photos';
    @set_time_limit(ini_get('max_execution_time'));
    array_map( "unlink", glob( $path_files_photos . '/' . '*.*' ) );
    copy($file_indexhtml, $path_files_photos . '/index.html');

}

static function updateHouses($bid) {

        global $database, $mosConfig_absolute_path;
        if (!is_array($bid) || count($bid) < 1) {
            echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM .
              "'); window.history.go(-1);</script>\n";
            exit;
        }

        $logPath  = $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/my_log.log";
        if (!file_exists($logPath)) exit; //remove file and break import
        file_put_contents($logPath," updateHouses start 1111 ::".time()." \n\n",  FILE_APPEND );


        if (count($bid)) {

            $bids = implode(',', $bid);

            $database->setQuery("SELECT * FROM  #__rem_houses WHERE id IN (" . $bids . ")");
            $del_rem = $database->loadObjectList();

            for ($i = 0; $i < count($del_rem); $i++) {
                  if ($del_rem[$i]->image_link != '' )
                  {
                       $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos';
                       $del_photo_mask_inf = pathinfo($del_rem[$i]->image_link);
                       $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
                       $del_photo_mask = basename($del_rem[$i]->image_link, $del_photo_mask_type);

                       if(strlen($del_photo_mask) < 20 ) continue ;

                        @set_time_limit(ini_get('max_execution_time'));
                        array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );
                  }
            }


            $database->setQuery("SELECT thumbnail_img, main_img FROM #__rem_photos WHERE fk_houseid IN ($bids)");
            $del_photos = $database->loadObjectList();
            for ($i = 0; $i < count($del_photos); $i++) {
                  if ($del_photos[$i]->main_img != '')
                  {
                       $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos';
                       $del_photo_mask_inf = pathinfo($del_photos[$i]->main_img);
                       $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
                       $del_photo_mask = basename($del_photos[$i]->main_img, $del_photo_mask_type);

                       if(strlen($del_photo_mask) < 20 ) continue ;

                        @set_time_limit(ini_get('max_execution_time'));
                        array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );

                   }
            }

            $database->setQuery("DELETE FROM #__rem_photos WHERE fk_houseid IN ($bids)");
            $database->execute() ;

            $database->setQuery("DELETE FROM #__rem_feature_houses WHERE fk_houseid IN ($bids)");
            $database->execute() ;

        }

}

//******************  get HouseId ****************************//
    static function getHouseId($mls){
        global $database;

        $query = "SELECT id FROM #__rem_houses WHERE houseid = '$mls'";
        $database->setQuery($query);
        $idHouse = $database->loadResult();

         if($idHouse) return $idHouse;
         else false;
    }

//******************   begin add for import XML format   ****************************
    static function importHousesXML($files_name_pars, $catid=null,$is_sample_data=false) {
        global $database,$realestatemanager_configuration;
        $retVal = array();
        $k = 0;
        $new_categories = array();
        $new_relate_ids = array();

        $dom = new domDocument('1.0', 'utf-8');
        $dom->load($files_name_pars);

        if ($catid === null) {

            // mosRealEstateManagerImportExport::clearDatabase();
            mosRealEstateManagerImportExport::removeAllHouses($is_sample_data);

            $cat_list = $dom->getElementsByTagname('category');
            $associateSaveArr = array();
            for ($i = 0; $i < $cat_list->length; $i++) {
                $category = $cat_list->item($i);
                $new_category = new stdClass();
                if (mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_section') == 'com_realestatemanager') {
                    $new_category->old_id = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_id');
                    $new_category->old_parent_id = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_parent_id');
                    $new_category->old_asset_id = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_asset_id');
                    $new_category->name = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_name');
                    $new_category->title = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_title');
                    $new_category->alias = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_alias');
                    $new_category->image = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_image');
                    $new_category->section = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_section');
                    $new_category->image_position = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_image_position');
                    $new_category->description = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_description');
                    $new_category->published = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_published');
                    $new_category->checked_out = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_checked_out');
                    $new_category->checked_out_time = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_checked_out_time');
                    $new_category->editor = mosRealEstateManagerImportExport::getXMLItemValue($category, 'editor');
                    $new_category->ordering = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_ordering');
                    $new_category->access = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_access');
                    $new_category->count = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_count');
                    $new_category->params = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_params');
                    if ($new_category->params == '') $new_category->params = '-2';
                    $new_category->params2 = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_params2');
                    $new_category->language = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_language');
                    $new_category->associate_category = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_associate_category');
                    $new_category->metadata = mosRealEstateManagerImportExport::getXMLItemValue($category, 'metadata');
                    $new_category->publish_up = mosRealEstateManagerImportExport::getXMLItemValue($category, 'publish_up');
                    $new_category->publish_down = mosRealEstateManagerImportExport::getXMLItemValue($category, 'publish_down');                    

                    $new_category = mosRealEstateManagerImportExport::findCategory($new_categories, $new_category);

                    $ussuesArray = array();
                    $ussuesArray["associate"] = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_associate_category');
                    $ussuesArray["oldId"] = mosRealEstateManagerImportExport::getXMLItemValue($category, 'category_id');
                    $ussuesArray["newId"] = $new_category->id;

                    $associateSaveArr[] = $ussuesArray;
                }
            }
            //update accosiate for categoris
            mosRealEstateManagerImportExport::updateAssociateCategories($associateSaveArr);

        }


        $feature_categories = array() ;
        $feature_list = $dom->getElementsByTagname('feature');
        for ($i = 0; $i < $feature_list->length; $i++) {
            $feature = $feature_list->item($i);
            $new_feature = new mosRealEstateManager_feature($database);
            $old_id = mosRealEstateManagerImportExport::getXMLItemValue($feature, 'feature_id');
            $new_feature->name = trim( mosRealEstateManagerImportExport::getXMLItemValue($feature, 'feature_name') );
            $feature_categories[] = $new_feature->categories = trim( mosRealEstateManagerImportExport::getXMLItemValue($feature, 'feature_categories'));
            $new_feature->published = mosRealEstateManagerImportExport::getXMLItemValue($feature, 'feature_published');
            $new_feature->image_link = mosRealEstateManagerImportExport::getXMLItemValue($feature, 'feature_image_link');
            if (!$new_feature->check() || !$new_feature->store()) {
                $tmp[5] = $new_feature->getError();
            } else {
                $database->setQuery("UPDATE #__rem_feature SET id =" . $old_id . " WHERE id = " . $new_feature->id . "");
                $database->execute();
                $tmp[5] = "OK";
            }
        }
        $feature_categories = array_unique( $feature_categories); 
        $feature_categories_old = explode(',', $realestatemanager_configuration['featuredmanager']['placeholder']);
        $feature_categories_result = array_merge($feature_categories,$feature_categories_old);
        $feature_categories_result = array_unique( $feature_categories_result); 
        $realestatemanager_configuration['featuredmanager']['placeholder'] = implode(",", $feature_categories_result ) ;
        mosRealestateManagerOthers::setParams();
        rem_add_new_features_constant() ;
        rem_add_new_features_category_constant();


        $house_list = $dom->getElementsByTagname('house');


        $associateSaveArr = array();
        for ($i = 0; $i < $house_list->length; $i++) {

            $house_class = new mosRealEstateManager($database);
            $house = $house_list->item($i);

            //get HouseID
            $houseid = $house_class->houseid = mosRealEstateManagerImportExport::getXMLItemValue($house, 'houseid');
            $old_house_id = mosRealEstateManagerImportExport::getXMLItemValue($house, 'id');

            //get rent ID
            $house_class->fk_rentid = mosRealEstateManagerImportExport::getXMLItemValue($house, 'fk_rentid');
            //get description
            $house_description = $house_class->description = mosRealEstateManagerImportExport::getXMLItemValue($house, 'description');
            //get link
            $house_class->link = mosRealEstateManagerImportExport::getXMLItemValue($house, 'link');
            //get listing_type
            $house_class->listing_type = mosRealEstateManagerImportExport::getXMLItemValue($house, 'listing_type');
            if (($house_class->listing_type) != '') {
                $listing_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                $listing_type[_REALESTATE_MANAGER_OPTION_FOR_RENT] = 1;
                $listing_type[_REALESTATE_MANAGER_OPTION_FOR_SALE] = 2;
                $listing_type[_REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST] = 3;

                if(isset($listing_type[$house_class->listing_type] ) )
                    $house_class->listing_type = $listing_type[$house_class->listing_type];
                else $house_class->listing_type = intval($house_class->listing_type);


            } else
                $house_class->listing_type = 0;

               
            //get rent_by
            $house_class->rent_by = mosRealEstateManagerImportExport::getXMLItemValue($house, 'rent_by');
            if($house_class->listing_type == 1 && $house_class->rent_by == ""  ) $house_class->rent_by = 'by_night'; 


            //get listing status
            $house_class->listing_status = mosRealEstateManagerImportExport::getXMLItemValue($house, 'listing_status');
            if (($house_class->listing_status) != '') {
                $listing_status[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
                $k = 1;
                foreach ($listing_status1 as $listing_status2) {
                    $listing_status[$listing_status2] = $k;
                    $k++;
                }
                $house_class->listing_status = $listing_status[$house_class->listing_status];
            } else
                $house_class->listing_status = 0;
            //get property type
            $house_class->property_type = mosRealEstateManagerImportExport::getXMLItemValue($house, 'property_type');
            if (($house_class->property_type) != '') {
                $property_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
                $k = 1;
                foreach ($property_type1 as $property_type2) {
                    $property_type[$property_type2] = $k;
                    $k++;
                }
                $house_class->property_type = $property_type[$house_class->property_type];
            } else
                $house_class->property_type = 0;

             //get price
            $house_class->price = mosRealEstateManagerImportExport::getXMLItemValue($house, 'price');
            $house_priceunit = $house_class->priceunit = mosRealEstateManagerImportExport::getXMLItemValue($house, 'priceunit');
            //get Title(house)

            $house_htitle = $house_class->htitle = mosRealEstateManagerImportExport::getXMLItemValue($house, 'htitle');
            //get country
            $house_class->hcountry = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hcountry');
            //get region
            $house_class->hregion = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hregion');
            //get city
            $house_class->hcity = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hcity');
            //get zipcode
            $house_class->hzipcode = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hzipcode');
            //get location
            $house_hlocation = $house_class->hlocation = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hlocation');
            //get latitude
            $house_hlatitude = $house_class->hlatitude = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hlatitude');
            //get longitude
            $house_hlongitude = $house_class->hlongitude = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hlongitude');
            //get map_zoom
            $house_map_zoom = $house_class->map_zoom = mosRealEstateManagerImportExport::getXMLItemValue($house, 'map_zoom');
            //get bathrooms
            $house_class->bathrooms = mosRealEstateManagerImportExport::getXMLItemValue($house, 'bathrooms');
            //get bedrooms
            $house_class->bedrooms = mosRealEstateManagerImportExport::getXMLItemValue($house, 'bedrooms');
            //get rooms
            $house_class->rooms = mosRealEstateManagerImportExport::getXMLItemValue($house, 'rooms');
            //get contacts

            $house_class->contacts = mosRealEstateManagerImportExport::getXMLItemValue($house, 'contacts');
             //get contacts
            $house_class->image_link = mosRealEstateManagerImportExport::getXMLItemValue($house, 'image_link');
            //get year
            $house_class->year = mosRealEstateManagerImportExport::getXMLItemValue($house, 'year');
            //get agent
            $house_class->agent = mosRealEstateManagerImportExport::getXMLItemValue($house, 'agent');
            //get lot_size
            $house_class->lot_size = mosRealEstateManagerImportExport::getXMLItemValue($house, 'lot_size');
            //get house_size
            $house_class->house_size = mosRealEstateManagerImportExport::getXMLItemValue($house, 'house_size');
            //get garages
            $house_class->garages = mosRealEstateManagerImportExport::getXMLItemValue($house, 'garages');
            //get date
            $house_class->date = mosRealEstateManagerImportExport::getXMLItemValue($house, 'date');
            //get hits
            $house_class->hits = mosRealEstateManagerImportExport::getXMLItemValue($house, 'hits');
            //get published
            $house_class->published = mosRealEstateManagerImportExport::getXMLItemValue($house, 'published');
            //get owneremail

            $house_class->owneremail = mosRealEstateManagerImportExport::getXMLItemValue($house, 'owneremail');
            //get featured_clicks
            $house_class->featured_clicks = mosRealEstateManagerImportExport::getXMLItemValue($house, 'featured_clicks');
            //get featured_shows
            $house_class->featured_shows = mosRealEstateManagerImportExport::getXMLItemValue($house, 'featured_shows');
            //get pixUpdtedDt treb
            $house_class->pixUpdtedDt = mosRealEstateManagerImportExport::getXMLItemValue($house, 'pixUpdtedDt');
            $house_class->climate_value = mosRealEstateManagerImportExport::getXMLItemValue($house, 'climate_value');
            if($house_class->climate_value === ''){
                $house_class->climate_value = 0;
            }
            $house_class->energy_value = mosRealEstateManagerImportExport::getXMLItemValue($house, 'energy_value');
            if($house_class->energy_value === ''){
                $house_class->energy_value = 0;
            }

            $house_class->extra1 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra1');
            $house_class->extra2 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra2');
            $house_class->extra3 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra3');
            $house_class->extra4 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra4');
            $house_class->extra5 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra5');
            $house_class->extra6 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra6');
            $house_class->extra7 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra7');
            $house_class->extra8 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra8');
            $house_class->extra9 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra9');
            $house_class->extra10 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra10');
            $house_class->extra11 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra11');
            $house_class->extra12 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra12');
            $house_class->extra13 = mosRealEstateManagerImportExport::getXMLItemValue($house, 'extra13');
            //get language
            $house_class->language = mosRealEstateManagerImportExport::getXMLItemValue($house, 'language');
            $house_class->metadata = mosRealEstateManagerImportExport::getXMLItemValue($house, 'metadata');
            $house_class->publish_up = mosRealEstateManagerImportExport::getXMLItemValue($house, 'publish_up');
            $house_class->publish_down = mosRealEstateManagerImportExport::getXMLItemValue($house, 'publish_down');
            
            if ($catid === null) {
              //get associate_house - only if full import
              $house_class->associate_house = mosRealEstateManagerImportExport::getXMLItemValue($house, 'associate_house');
            }

            //get category
            if ($catid === null) {
                $new_category = new stdClass();
                $catidsxml = $house->getElementsByTagname('catid');
                $tempcat = array();
                for ($t = 0; $t < $catidsxml->length; $t++) {
                    $tempxml[$t] = $catidsxml->item($t);
                    $new_category = new stdClass();
                    $new_category->old_id = $tempxml[$t]->nodeValue;

                    $new_category = mosRealEstateManagerImportExport::findCategory($new_categories, $new_category);
                    $tempcat[] = $new_category->id;
                }
            } else {
                $tempcat = array();
                $tempcat = $catid;
            }

            //for output rezult in table
            $tmp[0] = $i;
            $tmp[1] = $houseid;
            $tmp[2] = $house_hlocation;
            $tmp[3] = $house_htitle;

            //check houseid for existing
            try
            {
                $house_class->check();
                
            }
            catch (Exception $e)
            {
                var_dump($database);
                echo $e->getMessage();
                exit;
            }
            if (!$house_class->check() || !$house_class->store()) {
                $tmp[5] = $house_class->getError();
            } else {
                $house_class->saveCatIds($tempcat);
                $tmp[5] = "OK";
            }

            if ($catid === null){
                if(!$house_class->checkin()){
                    echo $house_class->getError();
                    exit;
                }
            }

            $retVal[$i] = $tmp;

            $ussuesArray = array();
            $ussuesArray["associate"] = mosRealEstateManagerImportExport::getXMLItemValue($house, 'associate_house');
            $ussuesArray["oldId"] = mosRealEstateManagerImportExport::getXMLItemValue($house, 'id');
            $ussuesArray["newId"] = $house_class->id;

            $associateSaveArr[] = $ussuesArray;

            //get Reviews
            if ($tmp[5] == "OK" && mosRealEstateManagerImportExport::getXMLItemValue($house, 'reviews') != "") {
                $review_list = $house->getElementsByTagname('review');
                for ($j = 0; $j < $review_list->length; $j++) {
                    $review = $review_list->item($j);
                    $review_user_name = mosRealEstateManagerImportExport::getXMLItemValue($review, 'user_name');
                    $review_user_email = mosRealEstateManagerImportExport::getXMLItemValue($review, 'user_email');
                    $review_date = mosRealEstateManagerImportExport::getXMLItemValue($review, 'date');
                    $review_rating = mosRealEstateManagerImportExport::getXMLItemValue($review, 'rating');
                    $review_title = mosRealEstateManagerImportExport::getXMLItemValue($review, 'title');
                    $review_comment = mosRealEstateManagerImportExport::getXMLItemValue($review, 'comment');
                    $review_published = mosRealEstateManagerImportExport::getXMLItemValue($review, 'published');

                    //insert data in table #__rem_review
                    $database->setQuery("INSERT INTO #__rem_review" .
                            "\n (fk_houseid, user_name,user_email, date, rating, title, comment, published)" .
                            "\n VALUES " .
                            "\n (" . $house_class->id . ", '" . $review_user_name . "','" . $review_user_email .
                            "', '" . $review_date . "'," . $review_rating . ",'" . $review_title . "', '" . addslashes($review_comment) . "', '" . $review_published . "');");
                    $database->execute();
                } //end for(...) - REVIEW
            } //end if(...) - REVIEW
            //get rents
            if ($tmp[5] == "OK" && mosRealEstateManagerImportExport::getXMLItemValue($house, 'rents') != "") {
                $rent_list = $house->getElementsByTagname('rent');
                for ($j = 0; $j < $rent_list->length; $j++) {
                    $rent = $rent_list->item($j);
                    $help = new mosRealEstateManager_rent($database);
                    $help->fk_houseid = $house_class->id;
                    $help->rent_from = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'rent_from');
                    $help->rent_until = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'rent_until');
                    $rent_return = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'rent_return');
                    $help->user_name = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'user_name');
                    $help->user_email = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'user_email');
                    $help->user_mailing = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'user_mailing');
                    $help->how_many_weeks = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'how_many_weeks');
                    $help->how_many_monthes = mosRealEstateManagerImportExport::getXMLItemValue($rent, 'how_many_monthes');

                    //insert data in table #__rem_rent
                    if (empty($rent_return))
                        $help->rent_return = new stdClass(); else
                        $help->rent_return = $rent_return;

                    if (!$help->check() || !$help->store()) {
                        $tmp[5] = $help->getError();
                    } else {
                        $house_class->fk_rentid = $help->id;
                        if (!$house_class->check() || !$house_class->store()) {
                            $tmp[5] = $house_class->getError();
                        } else
                            $tmp[5] = "OK";
                    }
                } //end for(...) - rent
            } //end if(...) - rent
            //print_r($house_class->id);
            if ($tmp[5] == "OK" && mosRealEstateManagerImportExport::getXMLItemValue($house, 'features_houses') != "") {
                 $feature_house_list = $house->getElementsByTagname('features_house');

                 for ($j = 0; $j < $feature_house_list->length; $j++) {
                 $feature_house = $feature_house_list->item($j);
                 $house_feature_id = mosRealEstateManagerImportExport::getXMLItemValue($feature_house, 'fk_featureid');

                 $database->setQuery("INSERT INTO #__rem_feature_houses" .
                                 "\n (fk_houseid, fk_featureid)" .
                                 "\n VALUES " .
                                 "\n (" . $house_class->id . ", " . $house_feature_id . ");");

                         $database->execute();
                 }
            }

            if ($tmp[5] == "OK" && mosRealEstateManagerImportExport::getXMLItemValue($house, 'rent_sals') != "") {
                $rent_sal_list = $house->getElementsByTagname('rent_sal');

                for ($j = 0; $j < $rent_sal_list->length; $j++) {

                    $rent_sal = $rent_sal_list->item($j);
                    $sp_from = mosRealEstateManagerImportExport::getXMLItemValue($rent_sal, 'price_from');
                    $sp_to= mosRealEstateManagerImportExport::getXMLItemValue($rent_sal, 'price_to');
                    $special_price = mosRealEstateManagerImportExport::getXMLItemValue($rent_sal, 'special_price');
                    $priceunit = mosRealEstateManagerImportExport::getXMLItemValue($rent_sal, 'priceunit');

                    //insert data in table #__rem_rent_sal
                    $database->setQuery("INSERT INTO #__rem_rent_sal" .
                            "\n (fk_houseid, price_from, price_to, special_price, priceunit)" .
                            "\n VALUES " . " (" . $house_class->id .
                            ", '" . $sp_from . "','" . $sp_to .
                            "', " . $special_price . ",'" . $priceunit . "');");
                    $database->execute();
                }
            }

            //get rentrequests
            if ($tmp[5] == "OK" && mosRealEstateManagerImportExport::getXMLItemValue($house, 'rentrequests') != "") {
                 $rentrequests_list = $house->getElementsByTagname('rentrequest');
                 for ($j = 0; $j < $rentrequests_list->length; $j++) {
                     $rentrequest = $rentrequests_list->item($j);
                     $rr_rent_from = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'rent_from');
                     $rr_rent_until = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'rent_until');
                     $rr_rent_request = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'rent_request');
                     $rr_user_name = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'user_name');
                     $rr_user_email = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'user_email');
                     $rr_user_mailing = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'user_mailing');
                     $rr_status = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'status');
                     $rr_how_many_weeks = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'how_many_weeks');
                     $rr_how_many_monthes = mosRealEstateManagerImportExport::getXMLItemValue($rentrequest, 'how_many_monthes');
                     //insert data in table #__rem_rent_request
                     $database->setQuery("INSERT INTO #__rem_rent_request " .
                             "\n (fk_houseid, rent_from,rent_until, rent_request, user_name, user_email, user_mailing,status,how_many_weeks,how_many_monthes)" .
                             "\n VALUES " .
                             "\n (" . $house_class->id . ", '" . $rr_rent_from . "', '" . $rr_rent_until .
                             "', '" . $rr_rent_request . "', '" . $rr_user_name . "','" . $rr_user_email . "', '" . addslashes($rr_user_mailing) .
                             "', " . $rr_status . ",'".$rr_how_many_weeks."','".$rr_how_many_monthes."');");
                     $database->execute();
                 } //end for(...) - rentrequest
             } //end if(...) - rentrequest

            //get buyingrequests
             if ($tmp[5] == "OK" && mosRealEstateManagerImportExport::getXMLItemValue($house, 'buyingrequests') != "") {
                 $buyingrequests_list = $house->getElementsByTagname('buyingrequest');

                for ($j = 0; $j < $buyingrequests_list->length; $j++) {
                     $buyingrequest = $buyingrequests_list->item($j);

                     $br_buying_request = mosRealEstateManagerImportExport::getXMLItemValue($buyingrequest, 'buying_request');
                     $br_customer_name = mosRealEstateManagerImportExport::getXMLItemValue($buyingrequest, 'customer_name');
                     $br_customer_email = mosRealEstateManagerImportExport::getXMLItemValue($buyingrequest, 'customer_email');
                     $br_customer_phone = mosRealEstateManagerImportExport::getXMLItemValue($buyingrequest, 'customer_phone');
                     $br_customer_com = mosRealEstateManagerImportExport::getXMLItemValue($buyingrequest, 'customer_comment');
                     $br_status = mosRealEstateManagerImportExport::getXMLItemValue($buyingrequest, 'status');

                     //insert data in table #__rem_buying_request
                     $database->setQuery("INSERT INTO #__rem_buying_request " .
                             "\n (fk_houseid, buying_request, customer_name, customer_email, customer_phone, customer_comment, status)" .
                             "\n VALUES " . " (" . $house_class->id .
                             ", '" . $br_buying_request .
                             "', '" . $br_customer_name .
                             "','" . $br_customer_email.
                             "','" . $br_customer_phone .
                             "' , '" . addslashes($br_customer_com) .
                             "' , " . $br_status . ");");
                     $database->execute();

                 } //end for(...) - $buyingrequest
             } //end if(...) - $buyingrequest



            //get images
            if ($tmp[5] == "OK" && mosRealEstateManagerImportExport::getXMLItemValue($house, 'images') != "") {
                $images_list = $house->getElementsByTagname('image');
                for ($j = 0; $j < $images_list->length; $j++) {
                    $image = $images_list->item($j);
                    $image_thumbnail_img = mosRealEstateManagerImportExport::getXMLItemValue($image, 'thumbnail_img');
                    $image_main_img = mosRealEstateManagerImportExport::getXMLItemValue($image, 'main_img');
                    $database->setQuery("INSERT INTO #__rem_photos " .
                            "\n (fk_houseid, thumbnail_img, main_img)" .
                            "\n VALUES " .
                            "\n (" . $house_class->id .
                            ", '" . $image_thumbnail_img . "','" . $image_main_img . "');");
                    $database->execute();
                } //end for(...) - images
            } //end if(...) - images
        }//end for(...) - house
          //get videos

        // print_r(11111111111111);
        // exit;

          if ($tmp[5] == "OK" && $house_list->length != 0 && mosRealEstateManagerImportExport::getXMLItemValue($house, 'videos') != ""){
            $videos_list = $house->getElementsByTagname('video');
            for ($j = 0; $j < $videos_list->length; $j++) {
              $video = $videos_list->item($j);
              $sequence_number = mosRealEstateManagerImportExport::getXMLItemValue($video, 'sequence_number','1');

              $src = mosRealEstateManagerImportExport::getXMLItemValue($video, 'src');
              $type = mosRealEstateManagerImportExport::getXMLItemValue($video, 'type');
              $media = mosRealEstateManagerImportExport::getXMLItemValue($video, 'media');
              $youtube = mosRealEstateManagerImportExport::getXMLItemValue($video, 'youtube');
              //insert data in table __rem_video_source
              $database->setQuery("INSERT INTO #__rem_video_source" .
                      "\n (fk_house_id, sequence_number, src, type, media, youtube)" .
                      "\n VALUES " .
                      "\n (" . $house_class->id .",
                      '" . $sequence_number . "',
                      '" . $src . "',
                      '" . $type . "',
                      '" . $media . "',
                      '" . $youtube . "');");
              $database->execute();
            } //end for(...) - videos
          } //end if(...) - videos

          //get tracks
        if ($tmp[5] == "OK" && $house_list->length != 0 && mosRealEstateManagerImportExport::getXMLItemValue($house, 'tracks') != ""){
            $tracks_list = $house->getElementsByTagname('track');
            for ($j = 0; $j < $tracks_list->length; $j++) {
              $track = $tracks_list->item($j);
              $sequence_number = mosRealEstateManagerImportExport::getXMLItemValue($track, 'sequence_number',"1");
              $src = mosRealEstateManagerImportExport::getXMLItemValue($track, 'src');
              $kind = mosRealEstateManagerImportExport::getXMLItemValue($track, 'kind');
              $scrlang = mosRealEstateManagerImportExport::getXMLItemValue($track, 'scrlang');
              $label = mosRealEstateManagerImportExport::getXMLItemValue($track, 'label');
              //insert data in table __rem_track_source
              $database->setQuery("INSERT INTO #__rem_track_source" .
                      "\n (fk_house_id, sequence_number, src, kind, scrlang, label)" .
                      "\n VALUES " .
                      "\n (" . $house_class->id .",
                      '" . $sequence_number . "',
                      '" . $src . "',
                      '" . $kind . "',
                      '" . $scrlang . "',
                      '" . $label . "');");
              $database->execute();
            } //end for(...) - tracks
        } //end if(...) - tracks

               //get orders
                  $orders_list = $dom->getElementsByTagname('order');
                  $odrers_ids = array();
                  for ($j = 0; $j < $orders_list->length; $j++) {
                      $orders = $orders_list->item($j);
                      $order_id = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'id');
                      $order_userid = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'fk_user_id');
                      $htitle = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'fk_houses_htitle');
                      $order_email = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'email');
                      $order_name = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'name');
                      $order_status = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'status');
                      $order_data = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'order_date');
                      $order_payer = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'payer_id');
                      $order_payer_status = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'payer_status');
                      $order_calculated_price = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'order_calculated_price');
                      $order_price = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'order_price');
                      $order_currency_code = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'order_currency_code');

                      //insert data in table #__rem_orders
                      $database->setQuery("INSERT INTO #__rem_orders " .
                              "\n (fk_user_id,fk_houses_htitle, email, name, status, order_date, fk_house_id,
                               payer_id, payer_status, order_calculated_price, order_price, order_currency_code)" .
                              "\n VALUES " . " ('" . $order_userid .
                              "', '" . $htitle .
                              "', '" . $order_email .
                              "', '" . $order_name .
                              "', '" . $order_status .
                              "', '" . $order_data .
                              "', '" . $old_house_id .
                              "', '" . $order_payer .
                              "', '" . $order_payer_status .
                              "', '" . $order_calculated_price .
                              "', '" . $order_price .
                              "', '" . $order_currency_code . "');");
                      $database->execute();
                      $odrers_ids[$order_id]=$database->insertid();
                      $database->setQuery("UPDATE #__rem_orders SET fk_house_id =" . $house_class->id . " WHERE fk_house_id = " . $old_house_id . "");
                      $database->execute();

                  }
                   //get orders details
                  $details_list = $dom->getElementsByTagname('orders_detail');
                  for ($j = 0; $j < $details_list->length; $j++) {
                      $detail= $details_list->item($j);
                      $order_id = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'fk_order_id');
                      $order_userid = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'fk_user_id');
                      $htitle = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'fk_houses_htitle');
                      $order_email = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'email');
                      $order_name = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'name');
                      $order_status = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'status');
                      $order_data = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'order_date');
                      $order_payer = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'payer_id');
                      $order_payer_status = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'payer_status');
                      $payment_details = mosRealEstateManagerImportExport::getXMLItemValue($detail, 'payment_details');
                      $order_calculated_price = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'order_calculated_price');
                      $order_price = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'order_price');
                      $order_currency_code = mosRealEstateManagerImportExport::getXMLItemValue($orders, 'order_currency_code');
                      $order_id = $odrers_ids[$order_id];

                      //insert data in table #__rem_orders
                      $database->setQuery("INSERT INTO #__rem_orders_details " .
                              "\n (fk_order_id,fk_user_id,fk_houses_htitle, email, name, status, order_date,
                               fk_house_id, payer_id, payer_status, order_calculated_price, order_price,
                                order_currency_code,payment_details)" .
                              "\n VALUES " . " (
                              '" . $order_id .
                              "', '" . $order_userid .
                              "', '" . $htitle .
                              "', '" . $order_email .
                              "', '" . $order_name .
                              "', '" . $order_status .
                              "', '" . $order_data .
                              "', '" . $old_house_id .
                              "', '" . $order_payer .
                              "', '" . $order_payer_status .
                              "',  '" . $order_calculated_price .
                              "',  '" . $order_price .
                              "', '" . $order_currency_code .
                              "', " . $database->Quote($payment_details) . ");");
                      $database->execute();
                      $database->setQuery("UPDATE #__rem_orders_details SET fk_house_id =" . $house_class->id . " WHERE fk_house_id = " . $old_house_id . "");
                      $database->execute();

                  }

        if ($catid === null) {
          //update accosiate for houses
          mosRealEstateManagerImportExport::updateAssociateHouses($associateSaveArr);
        }
        return $retVal;
    }

//***************************************************************************************************
//***********************   end add for import XML format   *****************************************
//***************************************************************************************************



static function exportHouses($option) {

    global $database, $realestatemanager_configuration;

    $catid = mosGetParam($_POST, 'export_catid', 0);
    $type = mosGetParam($_POST, 'export_type', 0);
    $where = array();

    if ( isset($catid) && $catid > 0 ) {
        if (count($catid) > 0 && $type != 4){
                foreach ($catid as $id){
                    array_push($where, "hc.idcat='$id'");
                }
        }
    }

    $selectstring = "SELECT distinct a.id FROM #__rem_houses AS a
            \nLEFT JOIN #__rem_categories AS hc ON hc.iditem=a.id" .
            "\nLEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat" .
            (count($where) ? " WHERE " . implode(' or ', $where) : "") .
            "\n GROUP BY a.id
             \n ORDER BY c.parent_id, a.ordering";
    $database->setQuery($selectstring);
    $bids = $database->loadObjectList();


    if (version_compare(JVERSION, '3.0', 'lt')) {
        $bids = $database->loadResultArray();
    } else {
        $bids = $database->loadColumn();
    }


    $listing_status[0] = '';
    $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
    $k = 1;
    foreach ($listing_status1 as $listing_status2) {
        $listing_status[$k] = $listing_status2;
        $k++;
    }
    $property_type[0] = '';
    $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
    $k = 1;
    foreach ($property_type1 as $property_type2) {
        $property_type[$k] = $property_type2;
        $k++;
    }

    $categories = '';

    if ($type == '4') {
        $database->setQuery("SELECT *  FROM #__rem_main_categories " .
            "WHERE section='com_realestatemanager' order by parent_id ; ");
        $categories = $database->loadObjectList();

        $database->setQuery("SELECT * FROM #__rem_feature ");
        $features = $database->loadObjectList();

        $database->setQuery("SELECT * FROM #__rem_feature_houses ");
        $features_houses = $database->loadObjectList();

        $database->setQuery("SELECT * FROM #__rem_orders ");
        $orders = $database->loadObjectList();

        $database->setQuery("SELECT * FROM #__rem_orders_details ");
        $orders_details = $database->loadObjectList();

    }

    switch ($type) {
        case '0':break;
        case '1':
            $type2 = 'csv';
            //move to xml - all data
            $createFeatured = true;
            $all = false;
            break;
        case '2':
            $type2 = 'xml';
            //move to xml - some category
            $createFeatured = false;
            $all = false;
            break;
        default :
            $type2 = 'xml';
            //move to xml - all category
            $createFeatured = true;
            $all = true;
            break;

    }


    $order = array("\r\n", "\n", "\r");
    $strXmlDoc = "";
    $strXmlDoc.= "<?xml version='1.0' encoding='utf-8' ?>\n";
    $strXmlDoc.= "<houses_data>\n";
    $strXmlDoc.= "<version>" . $realestatemanager_configuration['release']['version'] . "</version>\n";


    $strXmlDocCategory = "";
    $strXmlDocCategory.= "<categories>\n";
    if(!empty($categories)){
        foreach($categories as $cat){
            $strXmlDocCategory.= "<category>\n";
            foreach($cat as $field => $value) {

                $strXmlDocCategory.= '<category_' . $field . '><![CDATA[' . $value . ']]></category_' . $field . ">\n";
            }
            $strXmlDocCategory.= "</category>\n";
        }
    }
    $strXmlDocCategory.= "</categories>\n";


    $strXmlDocFeatures = "";
    $strXmlDocFeatures.= "<features>\n";
    if(!empty($features)){
        foreach($features as $feature1){
            $strXmlDocFeatures .= "<feature>\n";
            foreach ($feature1 as $field => $value) {
                $strXmlDocFeatures.= '<feature_' . $field . '><![CDATA[' . $value . ']]></feature_' . $field . ">\n";
            }
            $strXmlDocFeatures .= "</feature>\n";
        }
    }
    $strXmlDocFeatures.= "</features>\n";

    $strXmlDocOrders = "";
    $strXmlDocOrders.= "<orders>\n";;
    if(!empty($orders)){
        foreach($orders as $order1){
            $strXmlDocOrders .= "<order>\n";
            foreach ($order1 as $field => $value) {
                $strXmlDocOrders.= '<' . $field . '><![CDATA[' . $value . ']]></' . $field . ">\n";
            }
            $strXmlDocOrders .= "</order>\n";
        }
    }
    $strXmlDocOrders.= "</orders>\n";

    $strXmlDocOrdersDet = "";
    $strXmlDocOrdersDet.= "<orders_details>\n";;
    if(!empty($orders_details)){
        foreach($orders_details as $order1){
            $strXmlDocOrdersDet .= "<orders_detail>\n";
            foreach ($order1 as $field => $value) {
                $strXmlDocOrdersDet.= '<' . $field . '><![CDATA[' . $value . ']]></' . $field . ">\n";
            }
            $strXmlDocOrdersDet .= "</orders_detail>\n";
        }
    }
    $strXmlDocOrdersDet.= "</orders_details>\n";

    // $listing_type = [0] = '';
    // $listing_type = [1] = _REALESTATE_MANAGER_OPTION_FOR_RENT;
    // $listing_type = [2] = _REALESTATE_MANAGER_OPTION_FOR_SALE;
    // $listing_type = [3] = _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST;
    //$tmp->listing_type = $tmp->listing_type ;

    $strXmlDocHousesList = "";
    $strXmlDocHousesList.= "<houses_list>\n";
    $tmp = new mosRealEstateManager($database);
    foreach($bids as $bid){

        if($tmp->load(intval($bid))){

//            $tmp->listing_type = str_replace('|', '-', $listing_type[$tmp->listing_type]);
//            $tmp->listing_type = str_replace($order, ' ', $tmp->listing_type);
            $tmp->listing_status = str_replace('|', '-', $listing_status[$tmp->listing_status]);
            $tmp->listing_status = str_replace($order, ' ', $tmp->listing_status);
            $tmp->property_type = str_replace('|', '-', $property_type[$tmp->property_type]);
            $tmp->property_type = str_replace($order, ' ', $tmp->property_type);
            $tmp->contacts = str_replace('|', '-', $tmp->contacts);
            $tmp->contacts = str_replace($order, ' ', $tmp->contacts);
            $tmp->htitle = str_replace('|', '-', $tmp->htitle);
            $tmp->htitle = str_replace($order, ' ', $tmp->htitle);
            $tmp->description = str_replace('|', '-', $tmp->description);
            $tmp->description = str_replace($order, ' ', $tmp->description);
            $tmp->hcountry = str_replace('|', '-', $tmp->hcountry);
            $tmp->hcountry = str_replace($order, ' ', $tmp->hcountry);
            $tmp->hregion = str_replace('|', '-', $tmp->hregion);
            $tmp->hregion = str_replace($order, ' ', $tmp->hregion);
            $tmp->hcity = str_replace('|', '-', $tmp->hcity);
            $tmp->hcity = str_replace($order, ' ', $tmp->hcity);
            $tmp->hlocation = str_replace('|', '-', $tmp->hlocation);
            $tmp->hlocation = str_replace($order, ' ', $tmp->hlocation);
            $tmp->agent = str_replace('|', '-', $tmp->agent);
            $tmp->agent = str_replace($order, ' ', $tmp->agent);
            $tmp->garages = str_replace('|', '-', $tmp->garages);
            $tmp->garages = str_replace($order, ' ', $tmp->garages);
            $tmp->owneremail = str_replace('|', '-', $tmp->owneremail);
            $tmp->owneremail = str_replace($order, ' ', $tmp->owneremail);
            $tmp->priceunit = str_replace('|', '-', $tmp->priceunit);
            $tmp->priceunit = str_replace($order, ' ', $tmp->priceunit);
            $tmp->featured_clicks = str_replace('|', '-', $tmp->featured_clicks);
            $tmp->featured_clicks = str_replace($order, ' ', $tmp->featured_clicks);
            $tmp->featured_shows = str_replace('|', '-', $tmp->featured_shows);
            $tmp->featured_shows = str_replace($order, ' ', $tmp->featured_shows);
            $tmp->extra1 = str_replace('|', '-', $tmp->extra1);
            $tmp->extra1 = str_replace($order, ' ', $tmp->extra1);
            $tmp->extra2 = str_replace('|', '-', $tmp->extra2);
            $tmp->extra2 = str_replace($order, ' ', $tmp->extra2);
            $tmp->extra3 = str_replace('|', '-', $tmp->extra3);
            $tmp->extra3 = str_replace($order, ' ', $tmp->extra3);
            $tmp->extra4 = str_replace('|', '-', $tmp->extra4);
            $tmp->extra4 = str_replace($order, ' ', $tmp->extra4);
            $tmp->extra5 = str_replace('|', '-', $tmp->extra5);
            $tmp->extra5 = str_replace($order, ' ', $tmp->extra5);
            $tmp->extra6 = str_replace('|', '-', $tmp->extra6);
            $tmp->extra6 = str_replace($order, ' ', $tmp->extra6);
            $tmp->extra7 = str_replace('|', '-', $tmp->extra7);
            $tmp->extra7 = str_replace($order, ' ', $tmp->extra7);
            $tmp->extra8 = str_replace('|', '-', $tmp->extra8);
            $tmp->extra8 = str_replace($order, ' ', $tmp->extra8);
            $tmp->extra9 = str_replace('|', '-', $tmp->extra9);
            $tmp->extra9 = str_replace($order, ' ', $tmp->extra9);
            $tmp->extra10 = str_replace('|', '-', $tmp->extra10);
            $tmp->extra10 = str_replace($order, ' ', $tmp->extra10);
            $tmp->extra11 = str_replace('|', '-', $tmp->extra11);
            $tmp->extra11 = str_replace($order, ' ', $tmp->extra11);
            $tmp->extra12 = str_replace('|', '-', $tmp->extra12);
            $tmp->extra12 = str_replace($order, ' ', $tmp->extra12);
            $tmp->extra13 = str_replace('|', '-', $tmp->extra13);
            $tmp->extra13 = str_replace($order, ' ', $tmp->extra13);
            $tmp->language = str_replace('|', '-', $tmp->language);
            $tmp->language = str_replace($order, ' ', $tmp->language);
            $tmp->owner_id = str_replace('|', '-', $tmp->owner_id);
            $tmp->owner_id = str_replace($order, ' ', $tmp->owner_id);
            $tmp->associate_house = str_replace('|', '-', $tmp->associate_house);
            $tmp->associate_house = str_replace($order, ' ', $tmp->associate_house);
            $tmp->lot_size = str_replace('|', '-', $tmp->lot_size);
            $tmp->lot_size = str_replace($order, ' ', $tmp->lot_size);
            $tmp->bathrooms = str_replace('|', '-', $tmp->bathrooms);
            $tmp->bathrooms = str_replace($order, ' ', $tmp->bathrooms);
            $tmp->bedrooms = str_replace('|', '-', $tmp->bedrooms);
            $tmp->bedrooms = str_replace($order, ' ', $tmp->bedrooms);
            $tmp->year = str_replace('|', '-', $tmp->year);
            $tmp->year = str_replace($order, ' ', $tmp->year);
            $tmp->house_size = str_replace('|', '-', $tmp->house_size);
            $tmp->house_size = str_replace($order, ' ', $tmp->house_size);
            $tmp->rooms = str_replace('|', '-', $tmp->rooms);
            $tmp->rooms = str_replace($order, ' ', $tmp->rooms);

            $strXmlDocHousesList.= $tmp->toXML2($all);
        }
    }

    $strXmlDocHousesList.= "</houses_list>\n";


    if($createFeatured){
        $strXmlDoc.= $strXmlDocCategory;
        $strXmlDoc.= $strXmlDocFeatures;
        $strXmlDoc.= $strXmlDocOrders;
        $strXmlDoc.= $strXmlDocOrdersDet;
    }
    $strXmlDoc.= $strXmlDocHousesList;
    $strXmlDoc.= "</houses_data>\n";

    $retVal = $strXmlDoc;

    $InformationArray = mosRealEstateManagerImportExport :: storeExportFile($retVal, $type2);
    HTML_realestatemanager :: showExportResult($InformationArray, $option);
}


    static function storeExportFile($data, $type) {

        global $mosConfig_live_site, $mosConfig_absolute_path, $realestatemanager_configuration;
        $fileName = "realestatemanager_" . date("Ymd_His");
        $fileBase = "/administrator/components/com_realestatemanager/exports/";

        //write the xml file
        $fp = fopen($mosConfig_absolute_path . $fileBase . $fileName . ".xml", "w", 0); #open for writing

        fwrite($fp, $data); #write all of $data to our opened file
        fclose($fp); #close the file
        $InformationArray = array();
        $InformationArray['xml_file'] = $fileName . '.xml';
        $InformationArray['log_file'] = $fileName . '.log';
        $InformationArray['fileBase'] = "file://" . getcwd() . "/components/com_realestatemanager/exports/";
        $InformationArray['urlBase'] = $mosConfig_live_site . $fileBase;
        $InformationArray['out_file'] = $InformationArray['xml_file'];
        $InformationArray['error'] = new stdClass();

        switch ($type) {
            case 'csv':
                $InformationArray['xslt_file'] = 'csv.xsl';
                $InformationArray['out_file'] = $fileName . '.csv';
                mosRealEstateManagerImportExport :: transformPHP4($InformationArray);
                break;
            default:
                break;
        }
        return $InformationArray;
    }

    static function transformPHP4(&$InformationArray) {

        // create the XSLT processor^M
        $xh = xslt_create() or die("Could not create XSLT processor");

        // Process the document
        $result = xslt_process($xh, $InformationArray['fileBase'] .
           $InformationArray['xml_file'], $InformationArray['fileBase'] .
           $InformationArray['xslt_file'], $InformationArray['fileBase'] . $InformationArray['out_file']);

        if (!$result) {
            // Something croaked. Show the error
            $InformationArray['error'] = "Cannot process XSLT document: ";
        }
        // Destroy the XSLT processor
        xslt_free($xh);
    }

    static function clearDatabase() {
        global $database;
        $database->setQuery("DELETE FROM #__rem_main_categories "); // for 1.6
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_feature_houses");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_feature");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_categories");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_houses");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_photos");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_rent");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_rent_request");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_review");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_buying_request");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_orders");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_orders_details");
        $database->execute();
        $database->setQuery("DELETE FROM #__rem_rent_sal");
        $database->execute();
    }



 // --------------------------------MatrixRets--------------------------//

  static function LoginToMatrixRetsServer($un,$pw) {
      $url = 'http://matrixrets.miborblc.com/rets/login.ashx';
      $url = 'http://matrixrets.skmls.ca/rets/login.ashx';
      // $url = 'http://matrixrets.skmls.ca/rets/GetMetadata.ashx?Type=METADATA-TABLE&Format=STANDARD-XML&ID=0';
      // $url = 'http://matrixrets.skmls.ca/rets/GetMetadata.ashx?Type=METADATA-CLASS&Format=STANDARD-XML&ID=0';
      // $url = 'http://matrixrets.skmls.ca/rets/GetMetadata.ashx?Type=METADATA-CLASS&Format=COMPACT&ID=Property';
      // $url = 'http://matrixrets.skmls.ca/rets/GetMetadata.ashx?Type=METADATA-CLASS&Format=STANDARD-XML&ID=Property';
      // $url = 'http://matrixrets.skmls.ca/rets/GetMetadata.ashx?Type=METADATA-TABLE&ID=Property&Format=STANDARD-XML';




      $curl_post_data = array(
        "Username" => $un,
        "Password" => $pw,
      );

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "RETS-Version: RETS/1.7"));
      curl_setopt($ch, CURLOPT_HEADER, 1);
      curl_setopt($ch, CURLOPT_HTTPGET, 1);
      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST);
      curl_setopt($ch, CURLOPT_USERPWD, $un . ":" . $pw);
      curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
      curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');
      //curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      $response = curl_exec($ch);

      //print_r($response); exit ;
      curl_close($ch);
  }



  static function importHousesFromMatrixRets($catid){

    global $database,$mosConfig_absolute_path,$mosConfig_live_site,$realestatemanager_configuration;

    ini_set("memory_limit", '-1');
    ini_set('max_execution_time', 0);

      //error handler
      $logPath  = $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/my_log.log";
      if (file_exists($logPath)) {
        clearstatcache();
        $ret = time() - filemtime($logPath) ;
        if($ret < 600){
           echo "importHousesFromMatrixRets exit, file accessed : " . $ret ."seconds ago <br />";
          file_put_contents($logPath, "importHousesFromMatrixRets exit, file accessed : " . $ret ."seconds ago  \n\n",  FILE_APPEND );
          exit ;
        }
      }
      //error handler
      if ( file_exists($logPath) ) unlink($logPath);
      file_put_contents($logPath, "   import start ".time()." \n",  FILE_APPEND );

      ///first remove all not active houses
      {
          $query = "SELECT rh.id FROM #__rem_houses as rh LEFT JOIN #__rem_mls_for_delete".
           " AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid";
          $database->setQuery($query);
          $bid = $database->loadColumn();

          $query = "SELECT * FROM #__rem_mls_for_delete ";
          $database->setQuery($query);
          $mls = $database->loadColumn();

              if (!file_exists($logPath)) exit; //remove file and break import
              file_put_contents($logPath," remove start1 " . count($mls) ."::". count($bid)."::" .time()." \n\n",  FILE_APPEND );


          if(count($mls) > 0 && count($bid)>0)
          {
              if (!file_exists($logPath)) exit; //remove file and break import
              file_put_contents($logPath," remove start2 ".time()." \n\n",  FILE_APPEND );

                  // if (!file_exists($logPath)) exit; //remove file and break import
                  // file_put_contents($logPath," after remove count:". count($bid) ."  ".time()." \n\n",  FILE_APPEND );
                  // exit ;

              //self::removeHouses($bid);
              foreach ($bid as $value) {

                $house = new mosRealEstateManager($database);
                $house->load($value);
                $house->deleteHouse();
                $house = null ;

                  if (!file_exists($logPath)) exit; //remove file and break import
                  file_put_contents($logPath," after remove id:". $value ."  ".time()." \n\n",  FILE_APPEND );

              }


              //not active houses removed, clear array with active
              $query = "DELETE FROM #__rem_mls_for_delete";
              $database->setQuery($query);
              $database->execute();

              if (!file_exists($logPath)) exit; //remove file and break import
              file_put_contents($logPath," after remove 11 ".time()." \n\n",  FILE_APPEND );

          } else {

              if (!file_exists($logPath)) exit; //remove file and break import
              file_put_contents($logPath," remove start3 ".time()." \n\n",  FILE_APPEND );

              //not active houses removed, clear array with active
              $query = "DELETE FROM #__rem_mls_for_delete";
              $database->setQuery($query);
              $database->execute();

              if (!file_exists($logPath)) exit; //remove file and break import
              file_put_contents($logPath," after remove 12  ".time()." \n\n",  FILE_APPEND );

          }
          unset($bid);
          unset($mls);
      }

      //login
      if(!empty($realestatemanager_configuration['matrix_login'])
        && !empty($realestatemanager_configuration['matrix_password'])) {
         $un = $realestatemanager_configuration['matrix_login'];
         $pw = $realestatemanager_configuration['matrix_password'];
         mosRealEstateManagerImportExport::LoginToMatrixRetsServer($un,$pw);
      } else {
        echo "<script> alert(\"" . _REALESTATE_MANAGER_ADMIN_CONFIG_TREB_IMPORT_REQUIRED_FIELD . "\"); window.history.go(-1); </script>\n";
        exit();
      }
      //login



      $retVal = array();
      $properties = 0;

   /*   $classes = array(
        1 => 'Listing',
      );*/

      ini_set('max_execution_time', 0);
      $count_record_arr = array();
      $count_added_arr = array();
      $mls = array();
      $MATRIX_UNIQUE_ID = 0;

      while($MATRIX_UNIQUE_ID !== false) {

        set_time_limit(120);

      //error handler
      if (!file_exists($logPath)) exit; //remove file and break import
      file_put_contents($logPath," import start22 ".time()." \n\n",  FILE_APPEND );

//      $url = 'http://matrixrets.miborblc.com/rets/Search.ashx';
      $url = 'http://matrixrets.skmls.ca/rets/Search.ashx';
      $curl_post_data = array(
        "query" => array(
          'SearchType'=>'Property',
          'Class' => "Listing",
          'QueryType' => "DMQL2",
          'Format' => "COMPACT-DECODED",
          'StandardNames' => "0",
          'Query' => "(MATRIX_UNIQUE_ID=" . $MATRIX_UNIQUE_ID . "+) AND ( (STATUS=A) ) ",
          'Count' => "1",
          'Limit' => "2000",

        )
      );

          //'Query' => "(((ListingType=EXCRE) OR (ListingType=EXLAG) OR (ListingType=EXLRT) OR (ListingType=NEWCONST) OR (ListingType=OPRTY))) AND (PropertyType=RES) AND (MATRIX_UNIQUE_ID=" . $MATRIX_UNIQUE_ID . "+) AND ( (STATUS=A) OR (STATUS=P) ) AND ( (PublicInternet=1) AND (AddressonPublicInternet=1) AND (PropertyDesconInternet=1) )",

//for Except rent
//          'Query' => "(((ListingType=EXCRE) OR (ListingType=EXLAG) OR (ListingType=EXLRT) OR (ListingType=NEWCONST) OR (ListingType=OPRTY)) AND ((PropertyType=FRM) OR (PropertyType=MUL) OR (PropertyType=RES) OR (PropertyType=VAC))) AND (MATRIX_UNIQUE_ID=" . $MATRIX_UNIQUE_ID . "+) AND (STATUS=A)",

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url.'?' . http_build_query($curl_post_data['query']));
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "RETS-Version: RETS/1.8"));
      curl_setopt($ch, CURLOPT_HEADER, 0);
      curl_setopt($ch, CURLOPT_HTTPGET, 1);
      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST);
      // curl_setopt($ch, CURLOPT_TIMEOUT, 140);
      curl_setopt($ch, CURLOPT_TIMEOUT, 140);

      curl_setopt($ch,CURLOPT_USERPWD, $un . ":" . $pw);
      curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
      curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
      $response = curl_exec($ch);



      //error handler
      if($errno = curl_errno($ch)) {
          $error_message = curl_strerror($errno);
          echo "cURL error ({$errno}):\n {$error_message}";
          if (!file_exists($logPath)) exit; //remove file and break import
          file_put_contents($logPath," import start222 "."cURL error ({$errno}):\n {$error_message}"."  ".time()." \n\n",  FILE_APPEND );
      }

      curl_close($ch);
      $ret = simplexml_load_string($response);
      unset($response);

      $data = [];
      $delimiter = "\t";
      //get columns array
      $columns = array_flip(explode($delimiter, $ret->COLUMNS));



      // $columns_tmp = explode($delimiter, $ret->COLUMNS);

      // echo "<pre>";
      // print_r($columns_tmp);
      // echo "</pre>";

      // foreach($data as $key => $value) {
      //     foreach($value as $key2 => $value2) {
      //       $data1[$columns_tmp[$key2] ] = $value2 ;
      //     }
      //     $data2[] = $data1;
      // }
      // echo "<pre>";
      // print_r($data2);
      // echo "</pre>";
      // exit;


      //get data array
      foreach($ret->DATA as $key => $value) {
        $data[] = explode($delimiter, $value);
      }

      $lastIdInArray = end($data)[ $columns['Matrix_Unique_ID'] ];


      // loop management
      if($lastIdInArray > $MATRIX_UNIQUE_ID){
        $MATRIX_UNIQUE_ID = ($lastIdInArray + 1);
      }else{
        $MATRIX_UNIQUE_ID = false;
        break;
      }

      //error handler
      if (!file_exists($logPath)) exit; //remove file and break import
      file_put_contents($logPath," import start3   ".time()." \n\n",  FILE_APPEND );


      $count = 0;

      if(!empty($ret)){

        //error handler
        if (!file_exists($logPath)) exit; //remove file and break import
        file_put_contents($logPath," import start4  ". $ret->COUNT->attributes()->Records->__toString()." ".time()." \n\n",  FILE_APPEND );

      
        //start house loop
        foreach($data as $key => $value) {


// print_r(":1111111111111111111111111:"); 
// print_r($value); exit ;
            echo $count." - "; flush();  if( ob_get_level() > 0 ) ob_flush(); //fix error Gatway timeout

            //error handler
            if (!file_exists($logPath)) exit; //remove file and break import
            file_put_contents($logPath, $count."   ". memory_get_usage() ." ".time()." \n",  FILE_APPEND );

            //add acctive houses, for find not active

            $mls[] = $value[$columns['Matrix_Unique_ID']];
            // MatrixModifiedDT

            $id_house = mosRealEstateManagerImportExport::CheckDate($value[$columns['Matrix_Unique_ID']], $value[$columns['MatrixModifiedDT']]);


            if($id_house !== false) {

                //error handler
                if (!file_exists($logPath)) exit; //remove file and break import
                file_put_contents($logPath,"YES3 --> ".$id_house."::".$value[$columns['Matrix_Unique_ID']]." ".time()." \n\n", FILE_APPEND );

                $house_class = new mosRealEstateManager($database);


                if($id_house !== true ) {
                    $house_class->load($id_house);
                    //delete old house for update
                    $arr_for_update = array();
                    $arr_for_update[] = $id_house ;
                    //remove images
                    self::updateHouses($arr_for_update);
                }

                $url = 'http://matrixrets.miborblc.com/rets/GetObject.ashx';
                $url = 'http://matrixrets.skmls.ca/rets/GetObject.ashx';

                $curl_post_data = array(
                  "query" => array(
                    'Resource'=> 'Property',
                    'ID' => $value[$columns['Matrix_Unique_ID']].':'.'*',
                    'Type' => 'LargePhoto',
//                  'Type' => 'Photo',
                  ),
                );

                $headers = array("Content-Type: application/json", "RETS-Version: RETS/1.7");
                $responseFromCurl = mosRealEstateManagerImportExport::curl_to_host($url, $curl_post_data, $headers, $resp_headers, $un, $pw);

                $response = mosRealEstateManagerImportExport::parse($responseFromCurl, $resp_headers['Content-Type']);

                $houseid = $house_class->houseid = $value[$columns['Matrix_Unique_ID']];
                //get description
                $house_description = $house_class->description = $value[$columns['PropertyDescription']];

                //get listing_type
                $sale_lease = strtolower($value[$columns['ListingType']]); //type sale/rent

                if(trim($sale_lease) == strtolower("Exclusive Right to Lease")){
                   $house_class->listing_type = 1;
                }else if((trim($sale_lease) == strtolower("Exclusive Right to Sell"))
                          || (trim($sale_lease) == strtolower("Exclusive Agency"))){
                   $house_class->listing_type = 2;
                }else{
                   $house_class->listing_type = 0;
                }
	
	            //get rent_by
                $house_class->rent_by = "";
	            if($house_class->listing_type == 1 ) $house_class->rent_by = 'by_night'; 


                // get property_type
                $house_class->property_type = $value[$columns['PropertyType']];

                if (trim($house_class->property_type) != '' && trim($house_class->property_type) != 'not exists') {
                    $property_type[_REALESTATE_MANAGER_OPTION_SELECT] = 0;
                    $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
                    $k = 1;
                    foreach ($property_type1 as $property_type2) {
                        $property_type[$property_type2] = $k;
                        $k++;
                    }
                    $house_class->property_type = $property_type[$house_class->property_type];
                } else {
                  $house_class->property_type = 0;
                }



                //get price
                $house_class->price = $value[$columns['CurrentPrice']];
                //get priceunit
                $house_priceunit = $house_class->priceunit = "USD";
                //get Title(house)


                $house_htitle = $house_class->htitle = (string)$value[$columns['StreetNumber']].' '.(string)$value[$columns['StreetName']].' '.(string)$value[$columns['StreetSuffix']].', '.(string)$value[$columns['City']];
                 //get country
                $house_class->hcountry = "USA";
                 //get region
                $house_class->hregion = (string) $value[$columns['StateOrProvince']];
                 //get city
                $house_class->hcity = (string) $value[$columns['City']];
                 //get zipcode
                $house_class->hzipcode = (string) $value[$columns['PostalCode']];
                 //get location
                $house_hlocation = $house_class->hlocation = $value[$columns['Area']];
                //get bathrooms
                $house_class->bathrooms = $value[$columns['BathsTotal']];
                //get bedrooms
                $house_class->bedrooms = (int)$value[$columns['BedsTotal']];
                // get rooms
                $house_class->rooms = (int)$value[$columns['RoomCount']];
                // get year
                $house_class->year = (int)$value[$columns['YearBuilt']];

                //get mainImage
                $house_class->image_link = mosRealEstateManagerImportExport::firstPhoto($response);


                //get lot_size
                // $LotFront = isset($value->Listing->LotFront) && (int)$value->Listing->LotFront?$value->Listing->LotFront:0; //LotFront
                $house_class->lot_size = $value[$columns['LotSize']];
                // get house_size
                $house_class->house_size = (int) $value[$columns['TotalSqFt']];
                // get garages
                $house_class->garages = $value[$columns['NumberofGarages']];

                //get date
                $house_date = new DateTime($value[$columns['ListingContractDate']]);
                $house_class->date = $house_date->format("Y-m-d H:i:s");

                //get last update
                $pixUpdtedDt = new DateTime($value[$columns['MatrixModifiedDT']]);
                $house_class->pixUpdtedDt = $pixUpdtedDt->format("Y-m-d H:i:s");

                //get published
                $house_class->published = 1;

                //get agent
                $house_class->agent = $value[$columns['ListAgentFullName']];


                $house_class->owneremail = $value[$columns['ListAgentEmail']];
                $house_class->contacts = $value[$columns['ListAgentPreferredPhone']];
                $house_class->listing_status = 1;//if status Active
                // $house_class->hlatitude = (string)$value->GeographicData->Latitude;
                // $house_class->hlongitude = (string)$value->GeographicData->Longitude;
                $house_class->map_zoom = 14;



                $tempcat = array();

                if(isset($_GET['task']) && $_GET['task'] == 'matrix_link_import'){
                    // $catid = array();
                     if(trim($sale_lease) == strtolower("Exclusive Right to Lease")){
                        $catid = '52';
                     }else{
                        $catid = '51';
                     }
                }

                $tempcat = $catid;



                //for output rezult in table
                // $tmp[0] = $properties;
                // $tmp[1] = $houseid;
                // $tmp[2] = $house_hlocation;
                // $tmp[3] = $house_htitle;

              $AllPhotosOneHouse = mosRealEstateManagerImportExport::photos($response);

              //check houseid for existing
              if (!$house_class->check() || !$house_class->store()) {
                  // $tmp[5] = $house_class->getError();
              } else {
                  $house_class->saveCatIds($tempcat);
                  // $tmp[5] = "<font color='green'>OK</font>";
              }
              // $retVal[$properties] = $tmp;



              if ($AllPhotosOneHouse) {
                  for ($j = 0; $j< count($AllPhotosOneHouse); $j++) {
                      $database->setQuery("INSERT INTO #__rem_photos " .
                              "\n (fk_houseid,main_img)" .
                              "\n VALUES " .
                              "\n (" . $house_class->id .",
                                  '" . $AllPhotosOneHouse[$j] . "');");
                      $database->execute();
                  } //end for(...) - images
              } //end if(...) - images
              $properties++;

              unset($house_class);
            } else {

              //debug string
              if (!file_exists($logPath)) exit; //remove file and break import
              file_put_contents($logPath,"NO --> ".$value[$columns['Matrix_Unique_ID']]." ".time()." \n\n",  FILE_APPEND );
                  // $tmp[0] = $properties;
                  // $tmp[1] = $IsCheckDate[2];
                  // $tmp[2] = $IsCheckDate[3];
                  // $tmp[3] = $IsCheckDate[4];
                  // $tmp[5] = "<font color='red'>NOT UPDATE</font>";
                  // $retVal[$properties] = $tmp;
                  // $properties++;
              }

             $count++;   //for delete function
        } //end foreach


      } // end $ret

      $count_added_arr[] = $count;
      $count_record_arr[] = (isset($ret->COUNT)) ? $ret->COUNT->attributes()->Records->__toString() : 0;


    } // end while with MATRIX_UNIQUE_ID

      //Uncomment if you want switch on delete function
      $count_added = array_sum($count_added_arr);
      $count_record = max($count_record_arr);

          //test string (cooment in prodiction)
          // $count_record = 1;

          //debug string
          if (!file_exists($logPath)) exit; //remove file and break import
          file_put_contents($logPath," afret import ".count($count_added_arr)."::".$count_added . "::" . $count_record
          ."::" . $count_added_arr[0].
          // "::" . $count_added_arr[1]."::" . $count_added_arr[2].
          " ".time()." \n\n",  FILE_APPEND );


          //check was errors  at import time, if errors exist - not run housee delete
          // if(count($count_added_arr) == 3
          //   && $count_added_arr[0] > 0
          //   && $count_added_arr[1] > 0
          //   && $count_added_arr[2] > 0
          //   && $count_added == $count_record
          //   && $count_added != 0 )



          if($count_added > 0 && $count_added == $count_record )
          {
            echo "Delete - "; flush();  if( ob_get_level() > 0 ) ob_flush(); //fix error Gatway timeout
              //debug string
              if (!file_exists($logPath)) exit; //remove file and break import
              file_put_contents($logPath," remove start0 ".time()." \n\n",  FILE_APPEND );

              //insert mls fetched houses for nex delete not active
              foreach ($mls as $value) {
                  $query = "INSERT INTO #__rem_mls_for_delete VALUES(null,'".$value."')";
                  $database->setQuery($query);
                  $database->execute();
              }
              $mls_count = count($mls);
              unset($mls);

              $query = "SELECT rh.id FROM #__rem_houses as rh LEFT JOIN #__rem_mls_for_delete".
               " AS mls ON rh.houseid = mls.mls WHERE mls.mls is null GROUP BY rh.houseid";
              $database->setQuery($query);
              $bid = $database->loadColumn();

              if($mls_count > 0 && count($bid)>0){
                  //debug string
                  if (!file_exists($logPath)) exit; //remove file and break import
                  file_put_contents($logPath," remove start ".time()." \n\n",  FILE_APPEND );

                  //self::removeHouses($bid);
                  foreach ($bid as $value) {

                    $house = new mosRealEstateManager($database);
                    $house->load($value);
                    $house->deleteHouse();
                    $house = null ;

                      if (!file_exists($logPath)) exit; //remove file and break import
                      file_put_contents($logPath," after remove id:". $value ."  ".time()." \n\n",  FILE_APPEND );

                  }

                  //not active houses removed, clear array with active
                  $query = "DELETE FROM #__rem_mls_for_delete";
                  $database->setQuery($query);
                  $database->execute();

                  if (!file_exists($logPath)) exit; //remove file and break import
                  file_put_contents($logPath," after remove 22 ".time()." \n\n",  FILE_APPEND );


              } else {
                  //debug string
                  if (!file_exists($logPath)) exit; //remove file and break import
                  file_put_contents($logPath," remove start 1232 ".time()." \n\n",  FILE_APPEND );

                  //not active houses removed, clear array with active
                  $query = "DELETE FROM #__rem_mls_for_delete";
                  $database->setQuery($query);
                  $database->execute();

                  if (!file_exists($logPath)) exit; //remove file and break import
                  file_put_contents($logPath," after remove 23 ".time()." \n\n",  FILE_APPEND );
              }

          }

        return;
    }

    // --------------------------------MatrixRets--------------------------//


}
