<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');


//for Joomla 5-6
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Access\Access;
use Joomla\CMS\Version;
use Joomla\Registry\Registry;
use Joomla\CMS\Table\Table;
use Joomla\Filesystem\Path;
use Joomla\Filesystem\Folder;
use Joomla\Filesystem\File;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Helper\UserGroupsHelper;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Component\Router\RouterView;
use Joomla\CMS\Table\Menu;
use Joomla\CMS\Plugin\PluginHelper ;
use Joomla\CMS\User\User ;
use Joomla\CMS\Response\JsonResponse ;
use Joomla\Archive\Archive;
use Joomla\CMS\Installer\Installer;


if (version_compare(JVERSION, "5.0.0", "ge")) {

    if (!class_exists('JFactory')) class_alias('Joomla\CMS\Factory', 'JFactory');
    if (!class_exists('JURI')) class_alias('Joomla\CMS\Uri\Uri', 'JURI');
    if (!class_exists('JAccess')) class_alias('Joomla\CMS\Access\Access', 'JAccess');
    if (!class_exists('JVersion')) class_alias('Joomla\CMS\Version', 'JVersion');
    if (!class_exists('JRegistry')) class_alias('Joomla\Registry\Registry', 'JRegistry');
    if (!class_exists('JTable')) class_alias('Joomla\CMS\Table\Table', 'JTable');
    if (!class_exists('JPath')) class_alias('Joomla\Filesystem\Path', 'JPath');
    if (!class_exists('JFolder')) class_alias('Joomla\Filesystem\Folder', 'JFolder');
    if (!class_exists('JFile')) class_alias('Joomla\Filesystem\File', 'JFile');
    if (!class_exists('JToolbarHelper')) class_alias('Joomla\CMS\Toolbar\ToolbarHelper', 'JToolbarHelper');
    if (!class_exists('JHtml')) class_alias('Joomla\CMS\HTML\HTMLHelper', 'JHtml');
    if (!class_exists('JText')) class_alias('Joomla\CMS\Language\Text', 'JText');
    if (!class_exists('JEditor')) class_alias('Joomla\CMS\Editor\Editor', 'JEditor');
    if (!class_exists('JHelperUsergroups')) class_alias('Joomla\CMS\Helper\UserGroupsHelper', 'JHelperUsergroups');
    if (!class_exists('JFilterOutput')) class_alias('Joomla\CMS\Filter\OutputFilter', 'JFilterOutput');
    if (!class_exists('JRoute')) class_alias('Joomla\CMS\Router\Route', 'JRoute');
    if (!class_exists('JFormField')) class_alias('Joomla\CMS\Form\FormField', 'JFormField');
    if (!class_exists('JComponentRouterView')) class_alias('Joomla\CMS\Component\Router\RouterView', 'JComponentRouterView');
    if (!class_exists('JTableMenu')) class_alias('Joomla\CMS\Table\Menu', 'JTableMenu');
    if (!class_exists('JPluginHelper')) class_alias('Joomla\CMS\Plugin\PluginHelper', 'JPluginHelper');
    if (!class_exists('JUser')) class_alias('Joomla\CMS\User\User', 'JUser');
    if (!class_exists('JResponseJson')) class_alias('Joomla\CMS\Response\JsonResponse', 'JResponseJson');
    if (!class_exists('JArchive')) class_alias('Joomla\Archive\Archive', 'JArchive');
    if (!class_exists('JInstaller')) class_alias('Joomla\CMS\Installer\Installer', 'JInstaller');
} 

if(!function_exists('protectInjection')){
    function protectInjection($element, $def = '', $filter = "STRING",$bypass_get=false){
        
        $database = JFactory::getDBO();
        
        if(!$bypass_get){
          $value = JFactory::getApplication()->input->get($element, $def, $filter);
        // $value = $element;
        }else{
          $value = $element;
        }

        if(!isset($value) ) return $def;


        if(is_array($value)){
            foreach($value as $key=>$item_value){
                $value[$key] = $database->quote($item_value);
            }
            return $value ;

        }

        return $database->quote($value);
    }

}

if(!function_exists('protectInjectionWithoutQuote')){
    function protectInjectionWithoutQuote($element, $def = '', $filter = "STRING", $bypass_get=false){
        
        $database = JFactory::getDBO();
        
        if(!$bypass_get){
                $value = JFactory::getApplication()->input->get($element, $def, $filter);
                // $value = $element;
             }else{
                $value = $element;
             }

        if(!isset($value) ) return $def;
        $special_symb = array("/*","*/","select", "insert", "update", "drop", "delete", "alter");

        if(is_array($value)){
            foreach($value as $key => $val){
                if(!is_array($val)){
                    $isset_spec_symb = false;
                    foreach($special_symb as $symb){
                        $indx = stripos($val, $symb);
                        if($indx  !== false){
                            if($indx == 0 && preg_match('#'.$symb.'[0-9a-zA-Z@]+#i', $val)==0 ){
                                $isset_spec_symb = true;
                                continue;
                            } else if($indx > 0 && preg_match('#[0-9a-zA-Z@]+'.$symb.'#i', $val)==0 ){
                                $isset_spec_symb = true;
                                continue;
                            }
                        }
                    }
                    if($isset_spec_symb){
                        $val = protectInjection($val, $def , $filter ,true);
                    }else{
                        $val = protectInjectionWithoutQuote($val, $def , $filter ,true);
                    }
                }else{
                    $val = protectInjectionWithoutQuote($val, $def , $filter ,true);
                }
                $value[$key] = $val;
            }
        }else {
            $isset_spec_symb = false;
            foreach($special_symb as $symb){
                $indx = stripos($value, $symb);
                if($indx !== false){
                    if($indx == 0 && preg_match('#'.$symb.'[0-9a-zA-Z@]+#i', $value)==0 ){
                        $isset_spec_symb = true;
                        continue;
                    } else if($indx > 0 && preg_match('#[0-9a-zA-Z@]+'.$symb.'#i', $value)==0 ){
                        $isset_spec_symb = true;
                        continue;
                    }
                }
            }
            if($isset_spec_symb){
                $value = protectInjection($value, $def , $filter ,true);
            }else{
                $value = $database->escape($value);
            }
        }

        return $value;
    }
}


$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
// $mosConfig_live_site = $GLOBALS['mosConfig_live_site'] = JURI::base(); //return website Base path in admin  + administrator
$mosConfig_live_site = $GLOBALS['mosConfig_live_site'] = JURI::root(); //always return website Base path
$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
$mosConfig_cachepath = $GLOBALS['mosConfig_cachepath'] = JPATH_BASE . '/' . 'cache';
$database = $GLOBALS['database'] = JFactory::getDBO();
if (!isset($option))
    $option = $GLOBALS['option'] = strtolower(protectInjectionWithoutQuote('option', 'com_realestatemanager'));
// The selected language
$lang = JFactory::getLanguage();
// The $my (user) object
$GLOBALS['my'] = JFactory::getUser();
// The permissions object
$acl = new JAccess;
$GLOBALS['acl'] = $acl;
// Version information
$_VERSION = $GLOBALS['_VERSION'] = new JVersion();
$GLOBALS['mainframe'] = $mainframe = $GLOBALS['app'] = $app = JFactory::getApplication();
$GLOBALS['templateDir'] = $templateDir = 'templates/' . $mainframe->getTemplate();;
$GLOBALS['doc'] = $doc = JFactory::getDocument();


if (!function_exists('set_menu_metatags_rem')) {
    function set_menu_metatags_rem($Itemid) {
        global $database,$task,$doc  ;

        $app = JFactory::getApplication();
        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $conf = $app->getConfig();
        } else {
            $conf = JFactory::getConfig(); 
        }    

        $menu = new JTableMenu($database);
        if($Itemid == 0 ) $Itemid = $app->getMenu()->getActive()->id ;
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

        //check:
        //- this some menu item 
        // - not some child task for that menu item 
        if ( is_menu_item_rem($Itemid) )  {

            $page_title = '';
            if(  $params->get('page_title') !== null &&  trim($params->get('page_title')) != "" ){
              $doc->setTitle( trim($params->get('page_title')) );
              $page_title = trim($params->get('page_title') ) ;
            } else{
              if ($app->getParams()->get('page_title') !='') $page_title = $app->getParams()->get('page_title');
              else $page_title = $app->getMenu()->getActive()->title;
            }  
            $doc->setTitle( $page_title );

            if( $params->get('menu-meta_keywords') !== null && trim($params->get('menu-meta_keywords')) != "" ){
              $doc->setMetaData('keywords', trim($params->get('menu-meta_keywords')) );           
            }   

            if( $params->get('menu-meta_description') !== null && trim($params->get('menu-meta_description')) != "" ){
              $doc->setMetaData('description', trim($params->get('menu-meta_description')) );
            } 

            if( $params->get('robots') !== null && trim($params->get('robots')) != "" ){
                $doc->setMetaData('robots', trim($params->get('robots')) ) ;
            } else if( $conf->get('robots') !== null && trim($conf->get('robots')) != "" ){
                $doc->setMetaData('robots', trim($conf->get('robots')) ) ;
            } else {
                $doc->setMetaData('robots', 'index, follow' ) ;
            }

            //we set all OK
            return true;
        }

        //we set nothing
        return false;
          
    }

}

//if this not menu, as example we show house for menu all-house, return false
//if menu: all-house, and show all-houses - return true 
// $from_view - we may set Vew name from which we call this function
//so if $from_view == $task - this view main - not child
if (!function_exists('is_menu_item_rem')) {
    function is_menu_item_rem($Itemid ) {
        global $database,$task  ;

        $app = JFactory::getApplication();

        $menu = new JTableMenu($database);
        $menu->load($Itemid);
        $params = new JRegistry;
        $params->loadString($menu->params);

        $menu_item = $app->getMenu()->getItem($Itemid);
        $query_view = "";
        if( isset($menu_item->query['view']) ) $query_view = $menu_item->query['view'];
        else if( isset($menu_item->query['task']) ) $query_view = $menu_item->query['task']; 

           // echo ":111111111111101:";
           // var_dump($query_view); 
           // echo ":111111111111102:";
           // var_dump($Itemid); 

        $single_category = $params->get('single_category') ;
        $catid = $app->input->getInt('catid', null);
        $house_id = $params->get('house');
        $id = $app->input->getInt('id', null);
 //echo ":11111111111111111:".$query_view.":111111111111:".$task;
// echo ":11111111111111111:".$single_category.":111111111111:".$catid;
        //check:
        //- this some menu item 
        // - not some child task for that menu item 
        if (isset( $query_view ) && ( 
            ( $query_view == 'all_categories' && $task == "all_categories" ) 
            || ($query_view == 'wishlist' && $task == $query_view )  
            || ($query_view == 'add_house' && $task == $query_view )  
            || ($query_view == 'all_houses' && $task == $query_view ) 
            || ($query_view == 'owners_list' && ($task == "owners_list" || $task == "ownerslist" ) ) 
            || ($query_view == 'show_search_house' && $task == "show_search_house"  )
            || ($query_view == 'owner_houses' && 
                ( $task == "owner_houses" || $task == "view_user_houses" || 
                    $task == "showownerhouses" || $task == "show_my_houses" 
                    || $task == "showmyhouses" ) 
                && $params->get('username') !== null ) 
            || ($query_view == 'my_houses' && 
                ( $task == "my_houses" || $task == "edit_my_houses" ) ) 
            || ($query_view == 'alone_category' && ($task == "showCategory" || $task == "alone_category" )  && $single_category !== null && $catid == null ) 
            || ($query_view == 'view_house' && ($task == "view_house" || $task == "view" ) && $house_id !== null && ($id == null || $house_id == $id )  ) 
            ) )  {

 //echo ":111111111111103:";
                          return true ;
        }

        return false ;
    }

}
if (!function_exists('get_menu_url_alias_rem')) {

    function get_menu_url_alias_rem($Itemid,$view,$task_param) {
        global $database,$task  ;

        $app = JFactory::getApplication();
        $menu_item = $app->getMenu()->getItem($Itemid);
        $menu = new JTableMenu($database);
        $menu->load($Itemid);

        $url_alias = "" ;

        $task = $task_param ;
    
        $query_view = "";
        if( isset($menu_item->query['view']) ) $query_view = $menu_item->query['view'];
        else if( isset($menu_item->query['task']) ) $query_view = $menu_item->query['task']; 

     // echo ":444444444444444444444:".$Itemid; 
     // print_r( $menu_item ); 
      // echo ":1111111111111111111112222222:".$view."::".$task."::".$view."::".$query_view."::".$catid."::";
       //print_r( $menu_item->alias ); 

     //echo ":1111111111111111111112222222:".is_menu_item_rem($Itemid);

        //if in some menu item but not in child
        if (isset( $view ) && $view == $query_view  
            &&  is_menu_item_rem($Itemid) )  
        {
            $url_alias = trim( $menu->alias ) ;
        }

        return $url_alias ;
    }

}

if (!function_exists('userGID_REM')) {

    function userGID_REM($oID) {
        global $database, $ueConfig;
        if (version_compare(JVERSION, '1.6.0', 'lt')) {
            if ($oID > 0) {
                $query = "SELECT gid FROM #__users WHERE id = '" . $oID . "'";
                $database->setQuery($query);
                $gid = $database->loadResult();
                return $gid;
            } else
                return 0;
        } else if (version_compare(JVERSION, '1.6.0', 'ge')) {
            if ($oID > 0) {
                $query = "SELECT group_id FROM #__user_usergroup_map WHERE user_id  = '" . $oID . "'";
                $database->setQuery($query);
                $gids = $database->loadAssocList();
                if (count($gids) > 0) {
                    $ret = '';
                    foreach ($gids as $gid) {
                        if ($ret != "")
                            $ret.= ',';
                        $ret.= $gid['group_id'];
                    }
                    return $ret;
                } else
                    return -2;
            } else
                return -2;
        } else {
            echo "Sanity test. Error version check!";
            exit;
        }
    }

}
if (!function_exists('positions_rem')) {

    function positions_rem($position, $params = array()) {

            $err_state = ini_get('display_errors');
            ini_set('display_errors', 'Off');
            $plug_row = new stdClass();
            $plug_row->text = $position; // load the var into plugin_row object
            $plug_row->params = $params;
            JPluginHelper::importPlugin('content');
            $offset = 0;
            $plug_params = 1;


             //run mambot onPrepareContent on plug_row object
            // Trigger the onContentPrepare event.
            if ( version_compare(JVERSION, "4.0.0-alpha10", "ge") ) { 
                JFactory::getApplication()->triggerEvent('onContentPrepare', array("com_realestatemanager", $plug_row, $plug_params,$offset));
            } else {

            // Class 'JDispatcher' not found: JDispatcher deprecated J >= 4.0. Use JFactory::getApplication()->triggerEvent(...) instead
             $dispatcher = JDispatcher::getInstance();
             $results = $dispatcher->trigger('onContentPrepare', array('com_realestatemanager', &$plug_row, &$plug_params, $offset)); //run mambot nPrepareContent on plug_row object
            }


            echo $plug_row->text; //echo new content out
            ini_set('display_errors', $err_state);

    }

}
if (!function_exists('get_group_children_rem')) {

    function get_group_children_rem() {
        global $acl, $database;
        $groups['-2'] = ('Everyone');
        if (version_compare(JVERSION, '1.6.0', 'lt')) {
            $ids_groups = $acl->get_group_children($acl->get_group_id('USERS'), '', 'RECURSE');
            foreach ($ids_groups as $id_group) {
                $groups[$id_group] = $acl->get_group_name($id_group);
            }
            return $groups;
        } else if (version_compare(JVERSION, '1.6.0', 'ge')) {
            $query = 'SELECT `id`,`title` FROM #__usergroups';
            $database->setQuery($query);
            $rows = $database->loadObjectList();
            foreach ($rows as $k => $v) {
                $id_group = $rows[$k]->id;
                $group_name = $rows[$k]->title;
                $groups[$id_group] = $group_name;
            }
            return $groups;
        } else {
            echo "Sanity test. Error version check!";
            exit;
        }
    }

}
if (!function_exists('get_group_children_tree_rem')) {

    function get_group_children_tree_rem() {
        global $acl, $mosConfig_absolute_path;
        $gtree[] = mosHTML :: makeOption('-2', 'Everyone');
     
            $group_children_tree = array();
            // The code below needs for works users groups in admin settings in J4.
            if (version_compare(JVERSION, "6.0.0", "ge")) {
                //jimport('joomla.cms.helper.usergroupshelper');
                $options = JHelperUserGroups::getInstance()->getAll();
            } else if (version_compare(JVERSION, "4.0.0-alpha12", "ge")) {
                jimport('joomla.cms.helper.usergroupshelper');
                $options = JHelperUserGroups::getInstance()->getAll();
            } else {
                include_once($mosConfig_absolute_path . '/administrator/components/com_users/models/groups.php');
                if (version_compare(JVERSION, "3.0.0", "ge")) {
                    $model = JModelLegacy::getInstance('Groups', 'UsersModel', 
                        array('ignore_request' => true));
                    $options = $model->getItems();
                } else {
                    $model = JModel::getInstance('Groups', 'UsersModel', array('ignore_request' => true));
                    $options = $model->getItems();
                }
            }
            foreach ($g = $options as $k => $v) { // $g contains basic usergroup items info
                $group_title = '.';
                for ($i = 1; $i <= $g[$k]->level; $i++)
                    $group_title .= '-';
                $group_title .= '-' . $g[$k]->title;
                $group_children_tree[] = mosHTML :: makeOption($g[$k]->id, $group_title);
            }
            $gtree = array_merge($gtree, $group_children_tree);
            return $gtree;
    }

}
if (!function_exists('catOrderDownIcon')) {

    function catOrderDownIcon($i, $n, $index, $task = 'orderdown', $alt = 'Move Down') {
        global $templateDir, $mosConfig_live_site;
        if ($i < $n - 1) {
            if (version_compare(JVERSION, '1.6.0', 'lt')) {
                return '<a href="#reorder" onclick="return listItemTask(\'cb' . $index . '\',\'' . $task . '\')" title="' . $alt . '">
                <img src="' . $mosConfig_live_site . '/administrator/images/downarrow-1.png" width="12" height="12" border="0" alt="' . $alt . '" />
                </a>';
            } else {
                return '<a href="#reorder" onclick="return listItemTask(\'cb' . $index . '\',\'' . $task . '\')" title="' . $alt . '">
                <img src="' . $templateDir . '/images/admin/downarrow-1.png" width="12" height="12" border="0" alt="' . $alt . '" />
                </a>';
            }
        } else
            return '&nbsp;';
    }

}
if (!function_exists('catOrderUpIcon')) {

    function catOrderUpIcon($i, $index, $task = 'orderup', $alt = 'Move Up') {
        global $templateDir, $mosConfig_live_site;
        if ($i > 0) {
            if (version_compare(JVERSION, '1.6.0', 'lt')) {
                return '<a href="#reorder" onclick="return listItemTask(\'cb' . $index . '\',\'' . $task . '\')" title="' . $alt . '">
                <img src="' . $mosConfig_live_site . '/administrator/images/uparrow-1.png" width="12" height="12" border="0" alt="' . $alt . '" />
                </a>';
            } else {
                return '<a href="#reorder" onclick="return listItemTask(\'cb' . $index . '\',\'' . $task . '\')" title="' . $alt . '">
                <img src="' . $templateDir . '/images/admin/uparrow-1.png" width="12" height="12" border="0" alt="' . $alt . '" />
                </a>';
            }
        } else
            return '&nbsp;';
    }

}



if (!defined('_REALESTATE_MANAGER_COMPAT_FILE_LOADED')) {
    define('_REALESTATE_MANAGER_COMPAT_FILE_LOADED', 1);
    if (class_exists('JConfig')) {
        // These are needed when the Joomla! 1.5 legacy plugin is not enabled
        if (!defined('_JLEGACY')) {
            // TODO: determine what else is needed to work without the legacy plugin

            include_once ($mosConfig_absolute_path . '/components/com_realestatemanager/functions.php');
            if (!class_exists('mosHTML')) {
                include_once ($mosConfig_absolute_path . '/components/com_realestatemanager/includes/html.php');
            }
            if (!class_exists('mosAdminMenus')) {
                include_once ($mosConfig_absolute_path . '/components/com_realestatemanager/includes/adminmenus.php');
            }

            if (!class_exists('JComponentHelper') && !isset($mainframe)) {
                include_once (JPATH_BASE . '/' . 'includes' . '/' . 'defines.php');
                include_once (JPATH_BASE . '/' . 'includes' . '/' . 'framework.php');
                $mainframe = JFactory::getApplication(defined('_VM_IS_BACKEND') ? 'administrator' : 'site');
            }
            jimport('joomla.application.component.helper');
            if (class_exists('JComponentHelper')) {
                $usersConfig = JComponentHelper::getParams('com_users');
                $contentConfig = JComponentHelper::getParams('com_content');
                // User registration settings
                $mosConfig_allowUserRegistration = $GLOBALS['mosConfig_allowUserRegistration'] = $usersConfig->get('allowUserRegistration');
                $mosConfig_useractivation = $GLOBALS['mosConfig_useractivation'] = $usersConfig->get('useractivation');
                // TODO: Do we need these? They are set in the template.
                // Icon display settings
                // (hide pdf, etc has been changed to *show* pdf, etc in J! 1.5)
                $mosConfig_icons = $contentConfig->get('show_icons');
                $mosConfig_hidePdf = 1 - intval($contentConfig->get('show_pdf_icon'));
                $mosConfig_hidePrint = 1 - intval($contentConfig->get('show_print_icon'));
                $mosConfig_hideEmail = 1 - intval($contentConfig->get('show_email_icon'));
            }
            $jconfig = new JConfig();
            // Settings from the Joomla! configuration file
            foreach (get_object_vars($jconfig) as $k => $v) {
                $name = 'mosConfig_' . $k;
                if( isset($v) && $name !== "mosConfig_live_site" ) $$name = $GLOBALS[$name] = $v;
            }

            if (!function_exists('sefreltoabs')) {

                function sefRelToAbs($value) {
                    $url = str_replace('&amp;', '&', $value);
                    if (substr(strtolower($url), 0, 9) != "index.php")
                        return $url;
                    $uri = JURI::getInstance();
                    $prefix = $uri->toString(array('scheme', 'host', 'port'));
                    return $prefix . JRoute::_($url);
                    return $url;
                }

            }

            // Load the menu bar class
            JLoader::register('mosMenuBar_ext', $mosConfig_absolute_path . '/' . 'administrator' . '/' . 'components' . '/' . 'com_realestatemanager' . '/' . 'menubar_ext.php');
            // Load the user class
            JLoader::register('mosUser', $mosConfig_absolute_path . '/' . 'plugins' . '/' . 'system' . '/' . 'legacy' . '/' . 'user.php');
        } else {
            // We need these even when the Joomla! 1.5 legacy plugin is enabled
            // We need to set these when we don't enter as a component or module (like in notify.php)
            if (!isset($usersConfig))
                $usersConfig = JComponentHelper::getParams('com_users');
            if (!isset($contentConfig))
                $contentConfig = JComponentHelper::getParams('com_content');
            // Paths
            // These are in the legacy plugin as globals, but we need them locally too
            // $mosConfig_live_site = $GLOBALS['mosConfig_live_site'];
            $mosConfig_cachepath = $GLOBALS['mosConfig_cachepath'];
            // User registration settings
            $mosConfig_allowUserRegistration = $GLOBALS['mosConfig_allowUserRegistration'] = $usersConfig->get('allowUserRegistration');
            $mosConfig_useractivation = $GLOBALS['mosConfig_useractivation'] = $usersConfig->get('useractivation');
            // TODO: Do we need these? They are set in the template.
            // Icon display settings
            // hide pdf, etc has been changed to show pdf, etc in J! 1.5
            $mosConfig_icons = $contentConfig->get('show_icons');
            $mosConfig_hidePdf = 1 - intval($contentConfig->get('show_pdf_icon'));
            $mosConfig_hidePrint = 1 - intval($contentConfig->get('show_print_icon'));
            $mosConfig_hideEmail = 1 - intval($contentConfig->get('show_email_icon'));
            // TODO: Do we still need this in the latest J! 1.5 SVN?
            // Adjust the time offset
            // Version information
            $_VERSION = $GLOBALS['_VERSION'];
        }
    }
}
