<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

jimport( 'joomla.plugin.helper' );
if (version_compare(JVERSION, "3.0.0", "lt"))
    jimport('joomla.html.toolbar');

require_once($mosConfig_absolute_path . "/components/com_realestatemanager/functions.php");
require_once($mosConfig_absolute_path . "/components/com_realestatemanager/realestatemanager.php");

$GLOBALS['mosConfig_live_site'] = $mosConfig_live_site = JURI::root();
$GLOBALS['mosConfig_absolute_path'] = $mosConfig_absolute_path; 
$GLOBALS['mainframe'] = $mainframe = JFactory::getApplication();

$templateDir = JPATH_THEMES . '/' . JFactory::getApplication()->getTemplate() . '/';
$GLOBALS['templateDir'] = $templateDir;
$GLOBALS['doc'] = $doc = JFactory::getDocument();
$g_item_count = 0;

// add stylesheet
if(checkStylesIncludedRE("/realestatemanager.css") === false ) {
    $doc->addStyleSheet($mosConfig_live_site . 'components/com_realestatemanager/includes/realestatemanager.css');
}
if(checkStylesIncludedRE("/font-awesome/6.7.2/css/all.min.css") === false ) {
    $doc->addStyleSheet("https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css");
}

//$doc->addStyleSheet('//maxcdn.bootstrapcdn.com/bootstrap/2.3.2/css/bootstrap.min.css');
if(checkStylesIncludedRE('/animate.css') === false){
    $doc->addStyleSheet("https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.0/animate.css");
}
//$doc->addScript('//maxcdn.bootstrapcdn.com/bootstrap/3.3.2/js/bootstrap.min.js');
if(checkStylesIncludedRE("/jquerOs-ui.min.css") === false ) {
    $doc->addStyleSheet(JURI::root() . "components/com_realestatemanager/includes/jquerOs-ui.min.css");
}
if(checkStylesIncludedRE("/bootstrapREL.css") === false ) {
    $doc->addStyleSheet($mosConfig_live_site . 'components/com_realestatemanager/includes/bootstrapREL.css');
}

if(checkStylesIncludedRE("/tabcontent.css") === false ) {
    $doc->addStyleSheet($mosConfig_live_site . 'components/com_realestatemanager/TABS/tabcontent.css');
}
// add js

if(checkJavaScriptIncludedRE("/functions.js") === false ) {
  $doc->addScript($mosConfig_live_site . 'components/com_realestatemanager/includes/functions.js');
}
if(checkJavaScriptIncludedRE("/jQuerOs-2.2.4.min.js") === false ) {
  $doc->addScript($mosConfig_live_site . 'components/com_realestatemanager/includes/jQuerOs-2.2.4.min.js');
}
$doc->addScriptDeclaration("jQuerOs=jQuerOs.noConflict();");

if(checkJavaScriptIncludedRE("/jquerOs-ui.min.js") === false ) {
  $doc->addScript($mosConfig_live_site . 'components/com_realestatemanager/includes/jquerOs-ui.min.js');
}
if(checkJavaScriptIncludedRE("/jQuer.raty.js") === false ) {
    $doc->addScript($mosConfig_live_site . 'components/com_realestatemanager/includes/jQuer.raty.js');
}
if(checkJavaScriptIncludedRE("/tabcontent.js") === false ) {
    $doc->addScript($mosConfig_live_site . 'components/com_realestatemanager/TABS/tabcontent.js');
}

//add fancybox & swiper slider
if(checkJavaScriptIncludedRE("/swiper-os.js") === false ) {
    $doc->addScript($mosConfig_live_site . 'components/com_realestatemanager/includes/swiper-os.js');
}
if(checkStylesIncludedRE("/swiper.css") === false ) {
    $doc->addStyleSheet($mosConfig_live_site . 'components/com_realestatemanager/includes/swiper.css');
}

if(checkStylesIncludedRE("/jquer.os_fancyboxGall.css") === false ) {
    $doc->addStyleSheet($mosConfig_live_site . 'components/com_realestatemanager/includes/jquer.os_fancybox.css');
}
if(checkStylesIncludedRE("/styleFuncyboxThumbs.css") === false ) {
    $doc->addStyleSheet($mosConfig_live_site . 'components/com_realestatemanager/includes/styleFuncyboxThumbs.css');
}
if(checkJavaScriptIncludedRE("/jquer.os_fancyboxGall.js") === false ) {
    $doc->addScript($mosConfig_live_site . 'components/com_realestatemanager/includes/jquer.os_fancybox.js');
}
//add fancybox & swiper slider


class HTML_realestatemanager {

    static function showCaptchaRealestate($key="" ){

      global $my, $Itemid, $realestatemanager_configuration, $mosConfig_live_site;

       $googleRecaptchaEnabled = rem_check_enabled_google_captcha_recaptcha();

      if($googleRecaptchaEnabled){
        $captcha = JCaptcha::getInstance('recaptcha', array('namespace' => 'captcha_keystring_'.$key ));
        echo $captcha->display('recaptcha', 'recaptcha', 'required');
      } else {
        //<!--*************************   begin insetr image   **********************-->
        // begin create kod
        $st = "      ";
        $algoritm = mt_rand(1, 2);
        switch ($algoritm) {
          case 1:
            for ($j = 0; $j < 6; $j+= 2) {
                $st = substr_replace($st, chr(mt_rand(97, 122)), $j, 1); //abc
                $st = substr_replace($st, chr(mt_rand(50, 57)), $j + 1, 1); //23456789
            }
            break;
        case 2:
          for ($j = 0; $j < 6; $j+= 2) {
            $st = substr_replace($st, chr(mt_rand(50, 57)), $j, 1); //23456789
            $st = substr_replace($st, chr(mt_rand(97, 122)), $j + 1, 1); //abc
          }
            break;
        }
        //**************   begin search in $st simbol 'o, l, i, j, t, f'   ***************************
        $st_validator = "olijtf";
        for ($j = 0; $j < 6; $j++) {
          for ($i = 0; $i < strlen($st_validator); $i++) {
            if ($st[$j] == $st_validator[$i]) {
                    $st[$j] = chr(mt_rand(117, 122)); //uvwxyz
            }
          }
        }
        //**************   end search in $st simbol 'o, l, i, j, t, f'   *****************************
        $session = JFactory::getSession();

        $uniqid = urlencode(uniqid(microtime(), true ) ) ;
        $uniqid = str_replace(array("","+","&"), "", $uniqid);
        $session->set('captcha_keystring_'.$uniqid , $st);

        if (isset($_REQUEST['error']) && $_REQUEST['error'] != "")
            echo "<font style='color:red'>" . $_REQUEST['error'] . "</font><br />";
        $name_user = "";
        if (isset($_REQUEST['name_user'])){
          $name_user = $_REQUEST['name_user'];
        }
        if (isset($_REQUEST["err_msg"])){
          echo "<script> alert('Error: " . $_REQUEST["err_msg"] . "'); </script>\n";
        }

        echo "<br /><img src='" . JRoute::_( $mosConfig_live_site . "index.php?option=com_realestatemanager&amp;task=secret_image_". $key . "&amp;Itemid=" . $Itemid .'&amp;uniqid='. $uniqid ) ."' alt='CAPTCHA_picture'/><br/>";
        //echo "<br /><img src='" . $mosConfig_live_site . "index.php?option=com_realestatemanager&task=secret_image_".$key."&Itemid=" . $Itemid .'&uniqid='. $uniqid . "' alt='CAPTCHA_picture'/><br/>";

            //<!--**********************   end insert image   *******************************-->
         ?>
            <div class="row_05"><?php echo _REALESTATE_MANAGER_LABEL_REVIEW_KEYGUEST; ?></div>
            <div class="row_06">
            <input type="hidden" name="uniqid" value="<?php echo $uniqid; ?>" />
            <input class="inputbox" type="text" name="keyguest" size="6" maxlength="6" autocomplete="off" />
            </div>
            <?php

      }
    }
    

    static function showRentRequest(& $houses, & $currentcat, & $params, & $tabclass,
     & $catid, & $sub_categories, $option) {
        $pageNav = new os_libPagination(0, 0, 0);

        HTML_realestatemanager::displayHouses($houses, $currentcat, $params, $tabclass,
         $catid, $sub_categories, $pageNav, $option);
        // add the formular for send to :-)
    }

    static function displayHouses_empty($rows, $currentcat, &$params, $tabclass, $catid,
           $categories, &$pageNav = null,$is_exist_sub_categories=false, $option='com_realestatemanager') {
        positions_rem($params->get('allcategories01'));
        ?>
        <div class="rem">
        <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
             <?php echo $currentcat->header; ?>
        </div>
        <?php positions_rem($params->get('allcategories02')); ?>
        <table class="basictable table_48" border="0" cellpadding="4" cellspacing="0" width="100%">
            <tr>
                <td>
                    <?php echo $currentcat->descrip; ?>
                </td>
                <td width="120" align="center">
                    <img src="<?php echo JURI::root(); ?>components/com_realestatemanager/images/rem_logo.png"
                     align="right" alt="Real Estate Manager logo"/>
                </td>
            </tr>
        </table>
        <?php
        if ($is_exist_sub_categories) {
            ?>
            <?php positions_rem($params->get('singlecategory07')); ?>
            <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
            <?php echo _REALESTATE_MANAGER_LABEL_FETCHED_SUBCATEGORIES . " : " .
             $params->get('category_name'); ?>
            </div>
            <?php positions_rem($params->get('singlecategory08')); ?>
            <?php
            HTML_realestatemanager::listCategories($params, $categories, $catid, $tabclass, $currentcat);
        } ?>
        </div> <!-- class="rem" -->
        <?php
    }

    static function displayHouses(&$rows, $currentcat, &$params, $tabclass, $catid, $categories, &$pageNav = null, $is_exist_sub_categories=false, $option='com_realestatemanager', $layout = "default", $type = "alone_category") {
        global $mosConfig_absolute_path, $Itemid;
        //$type = 'alone_category';

        require getLayoutPath::getLayoutPathCom('com_realestatemanager', $type, $layout);
    }

    static function displaySearchHouses(&$rows, $currentcat, &$params, $tabclass, $catid, $categories, &$pageNav = null, $is_exist_sub_categories=false, $option='com_realestatemanager', $layout = "default", $layoutsearch = "default") {
        global $mosConfig_absolute_path, $Itemid;
        $type = 'search_result';

        if($params->get('search_form_on_result_search_page_show')){
          PHP_realestatemanager::showSearchHouses($option, $catid, $params, $layoutsearch);
        }
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', $type, $layout);
    }




    static function displayAllHouses(&$rows, &$params, $tabclass, &$pageNav, $layout = "default") {
        global $mosConfig_absolute_path,$Itemid;
        $type = 'all_houses';
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', $type, $layout);
    }


    /**
     * Displays the house
     */
    static function displayHouse(& $house, & $tabclass, & $params, & $currentcat, & $rating,
     & $house_photos,$videos,$tracks, $id, $catid, $option, & $house_feature, & $currencys_price, $layout = "default") {
        global $mosConfig_absolute_path;

        // This is mistake in php 5.6:
        // if(empty(trim($layout))) $layout = 'default';
        // Code below meet in component much times:
        if(empty($layout))
            $layout = 'default';

        $type = 'view_house';
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', $type, $layout);
    }

 
    /**
     * Display links to categories
     */
    static function showCategories(&$params, &$categories, &$catid, &$tabclass, &$currentcat, $layout) {
        global $mosConfig_absolute_path;
        $type = 'all_categories';
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', $type, $layout);
    }
    static function showSearchButton($Itemid) {
        global $mosConfig_live_site;
        ?>
        <form action="<?php
         echo sefRelToAbs("index.php?option=com_realestatemanager&task=show_search_house&amp;Itemid="
          . $Itemid); ?>" method="post" name="search_button" enctype="multipart/form-data">
            <input  type="submit" name="submit" value="<?php
             echo _REALESTATE_MANAGER_LABEL_SEARCH; ?>" class="button"/>
        </form>
        <?php
    }

    static function showAddButton($Itemid) {
        global $mosConfig_live_site;
        ?>
        <form action="<?php
         echo sefRelToAbs("index.php?option=com_realestatemanager&amp;task=show_add&amp;Itemid="
          . $Itemid); ?>" method="post" name="show_add" enctype="multipart/form-data">
            <input  type="submit" name="submit" value="<?php
             echo _REALESTATE_MANAGER_LABEL_BUTTON_ADD_HOUSE; ?>" class="button"/>
        </form>
        <?php
    }
  

    static function showSearchHouses($params, $currentcat, $clist, $option, &$temp1, &$temp2, $layout = "default") {
        global $mosConfig_absolute_path, $task;
        //$type = $task == "search" ? "show_search_result" : "show_search_house";
        if($params->get('showsearchhouselayout')){
          $layout = $params->get('showsearchhouselayout');
        }
        $type = "show_search_house";
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', $type, $layout);
    }

/////////////////////////////////////


        static function showRentRequestThanks($params, $backlink, $currentcat, $houseid=NULL, $time_difference=NULL) {
            global $Itemid, $doc, $mosConfig_live_site, $hide_js, $catid,
             $option, $realestatemanager_configuration, $database;

            ?>
    <div class="rem">

        <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
        </div>
        <?php

        if($houseid ){
          $house_class = new mosRealEstateManager($database);
          $house_class->load($houseid);

           $item_name = $house_class->htitle;             //'Donate to website.com';

            if($time_difference){
                $amount = $time_difference[0]; // price
                $currency_code = $time_difference[1] ; // priceunit
            }
            else{
                $amount= $house_class->price;
                $currency_code = $house_class->priceunit;
            }

        }

        ?>

        <div class="save_add_table">
            <div class="descrip"><?php echo $currentcat->descrip; ?></div>
        </div>

        <div class="basictable_15 basictable">
             <span>

        <?php
        if (isset($amount) && isset($currency_code)
            && !incorrect_price($house_class->price) && $house_class->price > 0 ) {

                      $amountcut = sprintf ('%.2f', $amount);
                      $house_class->price=$amountcut;
                      echo '<br/> '._REALESTATE_MANAGER_TOTAL_PRICE .$amountcut.' '.$currency_code;
        }
        ?>
                <input  type="submit" ONCLICK="window.location.href='<?php
                    echo $backlink;
                    ?>'" value="OK">

            </span>
        </div>
    </div> <!--class="rem" -->
        <?php
    }
//********************************************************************************************************




 static function listCategories(&$params, $cat_all, $catid, $tabclass, $currentcat) {
      global $Itemid, $mosConfig_live_site, $doc;
   ?>
        <?php positions_rem($params->get('allcategories04')); ?>
        <div class="basictable table_58">
            <div class="row_01">
                <span class="col_01 sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>">
            <?php echo _REALESTATE_MANAGER_LABEL_CATEGORY; ?>
                </span>
                <span class="col_02 sectiontableheader<?php echo $params->get('pageclass_sfx'); ?>">
        <?php echo _REALESTATE_MANAGER_LABEL_HOUSES; ?>
                </span>
            </div>
            <br/>
            <div class="row_02">
        <?php positions_rem($params->get('allcategories05')); ?>
        <?php HTML_realestatemanager::showInsertSubCategory($catid, $cat_all, $params, $tabclass, $Itemid, 0); ?>
            </div>
        </div>

        <?php positions_rem($params->get('allcategories06')); ?>
    <?php
    }

    /* function for show subcategory */

    static function showInsertSubCategory($id, $cat_all, $params, $tabclass, $Itemid, $deep) {
        global $g_item_count, $realestatemanager_configuration, $mosConfig_live_site;
        global $doc;


        $deep++;
        for ($i = 0; $i < count($cat_all); $i++) {
            if (($id == $cat_all[$i]->parent_id) && ($cat_all[$i]->display == 1)) {
                $g_item_count++;

                $link = 'index.php?option=com_realestatemanager&amp;task=showCategory&amp;catid='
                   . $cat_all[$i]->id . '&amp;Itemid=' . $Itemid;
                ?>
                <div class="table_59 <?php echo $tabclass[($g_item_count % 2)]; ?>">
                    <span class="col_01">
                <?php
                if ($deep != 1) {
                    $jj = $deep;
                    while ($jj--) {
                        echo "&nbsp;&nbsp;&nbsp;&nbsp;";
                    }
                    echo "&nbsp;|_";
                }
                ?>
                    </span>
                    <span class="col_01">
                <?php if (($params->get('show_cat_pic')) && ($cat_all[$i]->image != "")) { ?>
                            <img src="<?php echo JURI::root(); ?>images/stories/<?php echo $cat_all[$i]->image; ?>"
                               alt="picture for subcategory" height="48" width="48" />&nbsp;
                    <?php } else {
                    ?>
                            <a <?php echo "href='" . sefRelToAbs($link) . "'"; ?> class="category<?php
                             echo $params->get('pageclass_sfx'); ?>" style="text-decoration: none"><img
                              src="<?php echo JURI::root(); ?>components/com_realestatemanager/images/folder.png"
                               alt="picture for subcategory" height="48" width="48" /></a>&nbsp;
                <?php } ?>
                    </span>
                    <span class="col_02">
                        <a href="<?php echo sefRelToAbs($link); ?>"
                         class="category<?php echo $params->get('pageclass_sfx'); ?>">
                <?php echo $cat_all[$i]->title; ?>
                        </a>
                    </span>
                    <span class="col_03">
                <?php if ($cat_all[$i]->houses == '') echo "0";else echo $cat_all[$i]->houses; ?>
                    </span>

                </div>
                <?php
              if ($realestatemanager_configuration['subcategory']['show'])
                    HTML_realestatemanager::showInsertSubCategory($cat_all[$i]->id,
                     $cat_all, $params, $tabclass, $Itemid, $deep);
            }//end if ($id == $cat_all[$i]->parent_id)
        }//end for(...)
     }


}

//class html
