<?php
/**
 *
 * @package  Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
require_once($mosConfig_absolute_path . "/components/com_realestatemanager/compat.joomla1.5.php");
require_once($mosConfig_absolute_path . "/components/com_realestatemanager/realestatemanager.class.sefurl.php");

$GLOBALS['pu_debug'] = false;
function pu_log_rem( $msg="", $request=false,$prefix="" ) {

    global $pu_debug;

    if($pu_debug){

      $prefix = $prefix . "  ";
      
        // Write out new initialization file
        $logFilePath =  "./log_debug.log" ;
        $fd = fopen($logFilePath, "a+")
                or die("Cannot create log_debug.log file.");
        if(!empty($msg) ){
          fwrite($fd, "---------------".date( "d M Y G:i:s" ) ."\n");
          fwrite($fd, $msg ."\n" );
        } 
        if($request){
          if(is_string( $request ) || is_int( $request ) )  fwrite($fd,  $request ."\n" );
          else if(is_array( $request ) || is_object( $request ) ) 
            foreach($request as $key=>$value){
                if(is_string( $value ) || is_int( $value ) ) 
                    fwrite($fd,  $prefix. "[".$key."] = ".$value ."\n" );
                else if(is_array( $value ) || is_object( $value ) ) {
                    fwrite($fd,  $prefix. "[".$key."] = ".pu_log_rem("",$value,$prefix) ."\n" );
                }
            }
        }
        fclose($fd);    
      }
}

class RealEstateManagerRouter extends JComponentRouterView
{
    public function build(&$query)
    {

        pu_log_rem("RealEstateManagerRouter:build start:",$query);
// echo ":111111111111112:";
// print_r($url_alias);
// exit;  


        $segments = array();
        $segments_with_id = array(); //need if same $segments exist for other URL(same house name.. )
        if (isset($query['view']))   $view =$query['view'] ;
        if (isset($query['task']))   $task =$query['task'] ;
        else if(isset($query['view']))  $task =$query['view'] ;


        if (isset($query['Itemid']) ) { 
            //for menu items - not use router

            if(!isset($task)) return $segments;

            if (isset($query['view']) ) { 

                $url_alias = get_menu_url_alias_rem($query['Itemid'],$query['view'],$task) ;
            pu_log_rem("RealEstateManagerRouter:build 0010:",$url_alias);        
                if(!empty($url_alias) ) {
                    //we in some exectly menu(not in submenu)
            pu_log_rem("RealEstateManagerRouter:build 001:",$query);        
                    if ( !isset($query['letindex']) 
                        && !isset($query['limitstart'])
                        && !isset($query['limit'])
                        )  {
                        // foreach ($query as $key => $value) {
                        //     if( $key == 'option' ) continue ;
                        //     if( $key == 'Itemid' ) continue ;
                        //     unset($query[$key]);
                        // }
                        unset($query['view']);
                        unset($query['layout']);
             pu_log_rem("RealEstateManagerRouter:build 002:",$query);        
                        return $segments;
                    }

                }
            }
        }

        $db = JFactory::getDBO();

        // remove 'Itemid' from "vars query" for DB, because start menu items may be many
        $query_tmp = array();
        foreach ($query as $key => $value) {
            if( $key == 'Itemid' ) continue ;
            $query_tmp[$key] = $query[$key];
        }
        $sefurl = new mosRemSefurl($db);

        $ser_vars = serialize($query_tmp) ;
    pu_log_rem("RealEstateManagerRouter:build 01:",$query);        
        $hash_vars = md5( $ser_vars );
        $sefurl = $sefurl->loadByHashVars($hash_vars);
       
        if($sefurl != null ) {
          
            //if this url aready created
            if($task != "search" && $task != "search_houses" )
                foreach ($query as $key => $value) {
                    if( $key == 'option' ) continue ;
                    if( $key == 'Itemid' ) continue ;
                    if( $key == 'task' || $key == 'view' || $key == 'id' || 
                        $key == 'letindex' || $key == 'limitstart' || 
                        $key == 'limit' || $key == 'printItem' || 
                        ( $key == 'catid' && ($task != "search"  && $task != "search_houses") ) || 
                        ( $key == 'name' && 
                            ( $task == 'owner_houses' || $task == 'view_user_houses' || 
                              $task == 'showownerhouses' || $task == 'show_my_houses' || 
                              $task == 'showmyhouses' ) 
                        ) || 
                        ( $key == 'id' && $task == 'mdownload') 
                    ) unset($query[$key] );
                 }
            $segments = unserialize( $sefurl->ser_url_segments ) ;
    pu_log_rem("RealEstateManagerRouter:build 1:",$segments);
        //exit;

            return $segments;
        } else{
   
            //if this url not exist
        pu_log_rem("RealEstateManagerRouter:build 2:");
            $sefurl = new mosRemSefurl($db);
            $sefurl->ser_vars = $ser_vars;
            $sefurl->hash_vars = $hash_vars ;

          
            if(isset($task)) {
                switch($task) {
                    case 'show_search_house':
                        $segments[] = 'show-search';
                    break;
                    case 'search':
                    case 'search_houses':
                        $segments[] = 'search';
                    break;
                    case 'view':
                    case 'view_house':
                        //$segments[] = 'view'; //comment because we no need "this task name" URL part
                    break;
                    case 'alone_category':
                    case 'showCategory':
                    // $segments[] = "showCategory"; //comment because we no need "this task name" URL part
                    break;
                    case 'review':
                        $segments[] = 'review';
                    break;
                    case 'owners_list':
                    case 'ownerslist':
                        $segments[] = 'owners-list';
                    break;    
                    case 'secret_image':
                     //   $segments[] = 'secret_image'; //comment because we no need "this task name" URL part
                    break;    

                    default:
                        $segments[] = JFilterOutput::stringURLUnicodeSLug($task);
                    break;
                }
            } 

            if (isset($query['catid']) && ($task != "search"  && $task != "search_houses")  ) {
                if( $query['catid'] > 0) {
                    $sql_query = "SELECT c.id, c.name, c.parent_id FROM #__rem_main_categories AS c
                             \nWHERE c.id = ".intval($query['catid']);
                    $db->setQuery($sql_query);
                    $row = null;
                    $row = $db->loadObject();
                    
                    if(isset($row)) {
                      $cattitle = array();
                      $cattitle_with_id = array();
                      $cattitle[] = JFilterOutput::stringURLUnicodeSLug($row->name);
                      $cattitle_with_id[] = JFilterOutput::stringURLUnicodeSLug($row->id. '_' .$row->name);
                   
                      while(isset($row) && $row->parent_id>0) {
                        $sql_query = "SELECT name, c.id , parent_id 
                                  FROM #__rem_main_categories AS c
                                  WHERE c.id = ".intval($row->parent_id);
                        $db->setQuery($sql_query);
                        $row = $db->loadObject();
                        if(isset($row) && $row->name!=''){
                          $cattitle[] = JFilterOutput::stringURLUnicodeSLug($row->name);
                          $cattitle_with_id[] = JFilterOutput::stringURLUnicodeSLug($row->name);
                        }
                      }
                      $segments_with_id = array_merge($segments,array_reverse($cattitle_with_id));
                      $segments = array_merge($segments,array_reverse($cattitle));
                    }
                }
                unset($query['catid']);
            }

            if(isset($query['id']) && ( $task == 'view' || $task == 'view_house' ) ) {
                //if exist house, - this not end segment, so clean segments_with_id
                $segments_with_id = $segments;
            }


pu_log_rem("RealEstateManagerRouter:build 22:".$task."::",$query);             
            if(isset($query['id']) && ( $task == 'view' || $task == 'view_house') ) {
                $sql_query = "SELECT h.htitle, h.id 
                        FROM #__rem_houses AS h
                        LEFT JOIN #__rem_categories AS hc ON h.id=hc.iditem
                        LEFT JOIN #__rem_main_categories AS c ON c.id=hc.idcat
                        WHERE h.id=" . intval($query['id']) ;

                 $db->setQuery($sql_query);
                 $row = null;
                 $row = $db->loadObject();
                 if(isset($row)) {
                   $segments[] = JFilterOutput::stringURLUnicodeSLug($row->htitle);
                   $segments_with_id[] = JFilterOutput::stringURLUnicodeSLug($row->id. '_' .$row->htitle);
                 }
            } 

            if(isset($query['id']) && $task == 'edit_house') {
                $segments[] = JFilterOutput::stringURLUnicodeSLug($query['id']);
                $segments_with_id[] = JFilterOutput::stringURLUnicodeSLug($query['id']);
            }

            if(isset($query['id']) && $task == 'mdownload') {
                $segments[] = JFilterOutput::stringURLUnicodeSLug($query['id']);
                $segments_with_id[] = JFilterOutput::stringURLUnicodeSLug($query['id']);
            }      

            if(isset($query['name']) && 
                ( $task == 'owner_houses' || $task == 'view_user_houses' || 
                  $task == 'showownerhouses' || $task == 'show_my_houses' || 
                  $task == 'showmyhouses' ) ) {
                $segments[] = JFilterOutput::stringURLUnicodeSLug($query['name'] );
                $segments_with_id[] = JFilterOutput::stringURLUnicodeSLug($query['name']);
                unset($query['name']);
            }

            if(isset($query['printItem']) ) {
                $segments[] = JFilterOutput::stringURLUnicodeSLug($query['printItem'] );
                $segments_with_id[] = JFilterOutput::stringURLUnicodeSLug($query['printItem']);
                unset($query['printItem']);
            }


            if ( isset($query['letindex']) ) {
                //if(count($segments) == 0 ) $segments[] = $task;
                $segments[] = JFilterOutput::stringURLUnicodeSLug('letindex_'.$query['letindex']);
                unset($query['letindex']);
            }            
            if (isset($query['limitstart'])) {
                //if(count($segments) == 0 ) $segments[] = $task;
                $segments[] = JFilterOutput::stringURLUnicodeSLug("ls_".$query['limitstart']);
                unset($query['limitstart']);
            }

            if (isset($query['limit'])) {
                //if(count($segments) == 0 ) $segments[] = $task;
                $segments[] = JFilterOutput::stringURLUnicodeSLug("l_".$query['limit']);
                unset($query['limit']);
            }

            unset($query['id']);
            unset($query['task']);
            unset($query['view']);
            unset($query['layout']);
            unset($query['is_show_data']);
            unset($query['tab']);


            $sefurl->ser_url_segments = serialize($segments);
            $sefurl->url_last_segment = end($segments);

pu_log_rem("RealEstateManagerRouter:build 23:".$task."::",$segments);             

            $sefurl->hash_url_segments = md5( $sefurl->ser_url_segments ) ;
            $sefurl->hash_last_segment = md5( $sefurl->url_last_segment ) ;

            $sefurl_new = new mosRemSefurl($db);
            $sefurl_new = $sefurl_new->loadByHashUrlSegments($sefurl->hash_url_segments);

            if($sefurl_new != null 
                && count($segments_with_id) > 0 
                && $sefurl->hash_vars == $sefurl_new->hash_vars ) {
                //$sefurl_new != null - this mean exist some duplecate with same url, 
                //$sefurl->hash_vars == $sefurl_new->hash_vars - mean all vars 
                // in url same(not only in segment)
                //so add to URL the ID
pu_log_rem("RealEstateManagerRouter:build 232:");             
                $sefurl->ser_url_segments = serialize($segments_with_id);
                $sefurl->hash_url_segments = md5( $sefurl->ser_url_segments ) ;

                $sefurl->url_last_segment = end($segments_with_id);
                $sefurl->hash_last_segment = md5( $sefurl->url_last_segment ) ;

                $segments = $segments_with_id;
            }else if($sefurl_new != null 
                && count($segments_with_id) == 0 
                && $sefurl->hash_vars == $sefurl_new->hash_vars ) {
                //this mean exist some duplecate with same url, 
                //$sefurl->hash_vars == $sefurl_new->hash_vars - mean all vars 
                // in url same(not only in segment)
                //so add to URL the some hash code
                //need additional check for SEaRCH tasks, 
                //so task may check with date and hint, and remove all old 1 month
                //this condition must not happened, other some error  !!!!
pu_log_rem("RealEstateManagerRouter:build 233:");             
                $hash = md5( serialize($query) ) ;
                $segments[] = $hash;
                $sefurl->ser_url_segments = serialize($segments);
                $sefurl->hash_url_segments = md5( $sefurl->ser_url_segments ) ;

                $sefurl->url_last_segment = end($segments_with_id);
                $sefurl->hash_last_segment = md5( $sefurl->url_last_segment ) ;

                $segments = $segments_with_id;
            }else if($sefurl_new != null 
                && count($segments_with_id) > 0 
                && $sefurl->hash_vars != $sefurl_new->hash_vars ) {
                //$sefurl_new != null - this mean exist some duplecate with same url, 
                //$sefurl->hash_vars != $sefurl_new->hash_vars - mean NOT all vars 
                // in url same(not only in segment) (may be exist some duplicate name)
                //so add to URL the ID
pu_log_rem("RealEstateManagerRouter:build 234:");             
                $sefurl->ser_url_segments = serialize($segments_with_id);
                $sefurl->hash_url_segments = md5( $sefurl->ser_url_segments ) ;

                $sefurl->url_last_segment = end($segments_with_id);
                $sefurl->hash_last_segment = md5( $sefurl->url_last_segment ) ;

                $segments = $segments_with_id;
            }

            $sefurl->store();
pu_log_rem("RealEstateManagerRouter:build 3:",$segments);
            return $segments;

        }
pu_log_rem("RealEstateManagerRouter:build 4:");



//old code - if some error :
        //     // print_r ("!!!!!!!!start RealEstateManagerBuildRoute     ---- ");
        //     // print_r($query);


        // $segments = array();
        // $db = JFactory::getDBO();
        // if (isset($query['Itemid']) && $query['Itemid'] !== 0) {
        //     $app = JFactory::getApplication();
        //     $menu = $app->getMenu();
        //     if (!isset($query['view']) && !isset($query['task'])) {
        //         if (version_compare(JVERSION, "1.6.0", "lt")) {
        //             @$query['view'] = $menu->getItem($query['Itemid'])->query['task'];
        //         } else if (version_compare(JVERSION, "1.6.0", "ge")) {
        //             @$query['view'] = $menu->getItem($query['Itemid'])->query['view'];
        //         }
        //     }
        //     if (isset($query['view']) && $query['view'] == "alone_category") {
        //         if (version_compare(JVERSION, '3.0', 'ge')) {
        //             $menu = new JTableMenu($db);
        //             $menu->load($query['Itemid']);
        //             $params = new JRegistry;
        //             $params->loadString($menu->params);
        //         } else {
        //             $menu = new JTableMenu($database);
        //             $menu->load($Itemid);
        //             $params = new JRegistry;
        //             $params->loadString($menu->params);
        //         }
        //         $single_category = $params->get('single_category', '');
        //         if ($single_category != "")
        //              $query['catid'] = $single_category;
        //     }
        // }

        // if (isset($query['option']) && $query['option'] == 'com_realestatemanager') { //check component

        //     // echo "--=>"; print_r($query); echo "<=--";
        //    if (isset($query['view']) && ($query['view']== 'all_houses'
        //     || $query['view'] == 'all_categories'
        //     || $query['view'] == 'alone_category'
        //     || $query['view'] == 'view_house'
        //     || $query['view'] == 'my_houses' 
        //     || $query['view'] == 'edit_my_houses' 
        //     || $query['view'] == 'view_user_houses')) {
        //         $segments[0] = (isset($query['Itemid'])) && ($query['Itemid'] != 0) ? $query['Itemid'] : '0';
        //     }else{

        //     $segments[0] = (isset($query['Itemid'])) && ($query['Itemid'] != 0) ? $query['Itemid'] : '0';
        //     }
        //     if ((isset($query['view'])) && (!isset($query['task']))) {
        //         $query['task'] = $query['view'];
        //     }
        //    //print_r($query['task']);exit;
        //     if (isset($query['task'])) {
        //         switch ($query['task']) {
        //             case 'all_houses':
        //                 $segments[1] = 'all_houses';
        //                 break;
        //             case 'my_houses':
        //             case 'edit_my_houses':
        //                 $segments[1] = 'my_houses';
        //                 break;
        //             case 'new_url':
        //                 $segments[1] = 'buy_now';
        //                 break;
        //             case 'new_url_for_vm':
        //                 $segments[1] = 'buy_now_for_rem';
        //                 break;

        //              case 'search':
        //              case 'search_houses':
        //                   $segments[1] = 'search';
        //                  break;

        //              case 'show_search_house':
        //                   $segments[1] = 'show_search_house';
        //                  break;

        //             case 'view_user_houses':
        //             case 'owner_houses':
        //                 $segments[1] = $query['task'];
        //                 if (isset($query['name'])) {
        //                     //$segments[] = JFilterOutput::stringURLUnicodeSLug($query['name']);
        //                     $segments[] = $query['name'];
        //                     unset($query['name']);
        //                 }
        //                 break;
        //             case 'rent_requests':
        //                 $segments[1] = $query['task'];
        //                 break;
        //             case 'buying_requests':
        //                 $segments[1] = $query['task'];
        //                 break;
        //             case 'buying_request':
        //                 $segments[1] = $query['task'];
        //                 break;
        //             case 'save_rent_request':
        //                 $segments[1] = $query['task'];
        //                 break;
        //             case 'rent_history':
        //                 $segments[1] = $query['task'];
        //                 break;
        //             default:
        //                 $segments[1] = $query['task'];
        //                 break;
        //         }
        //     }
        //     unset($query['task']);
        //     unset($query['view']);

        //     if (isset($query['catid']) && (isset($segments[1]) && $segments[1] != "search")) {

        //         if ($query['catid'] > 0) {
        //             $sql_query = "SELECT rmc.id, rmc.name,rmc.title, rc.idcat, rmc.parent_id " .
        //              " FROM #__rem_main_categories AS rmc" .
        //              " LEFT JOIN #__rem_categories AS rc ON rc.idcat=rmc.id " .
        //              " LEFT JOIN #__rem_houses AS r ON rc.iditem = r.id " .
        //              " WHERE rmc.section = 'com_realestatemanager' AND rmc.id = " . intval($query['catid']);
        //             $db->setQuery($sql_query);
        //             $row = null;
        //             $row = $db->loadObject();
        //             if (isset($row)) {
        //                 $cattitle = array();
        //                 $segments[] = $query['catid']."-".JFilterOutput::stringURLUnicodeSLug($row->title);
        //                 //$segments[] = $row->name;
        //                 unset($query['catid']);
        //             }
        //         } else {
        //             $temp = $query['catid']; //is catid set??
        //             unset($query['catid']);
        //         }
        //     }

        //     if (!empty($query['lang'])) {
        //         unset($query['lang']);
        //     }
        //     if (isset($query['name'])) {
        //         $segments[] = JFilterOutput::stringURLUnicodeSLug($query['name']);
        //         unset($query['name']);
        //     }
        //     if (isset($query['user'])) {
        //         $segments[] = $query['user'];
        //         unset($query['user']);
        //     }
        //     if (isset($query['id'])) {
        //         $sql_query = "SELECT rc.idcat AS catid, r.htitle" .
        //          "\n FROM #__rem_houses AS r" .
        //          "\n LEFT JOIN #__rem_categories AS rc ON rc.iditem=r.id" .
        //          "\n LEFT JOIN #__rem_main_categories AS rmc ON rmc.id=rc.idcat" .
        //          "\n WHERE r.id = " . intval($query['id']);
        //         $db->setQuery($sql_query);
        //         $row = null;
        //         $row = $db->loadObject();
        //         if (isset($row)) {
        //             $temp_title = JFilterOutput::stringURLUnicodeSLug($row->htitle);
        //             if (isset($temp)) {
        //                 $sql_query = "SELECT name, alias FROM #__rem_main_categories WHERE id = " . $row->catid;
        //                 $db->setQuery($sql_query);
        //                 $row = $db->loadObject();
        //                 if (isset($row)) {
        //                     $segments[] = $row->alias;
        //                 }
        //             }
        //             $segments[] = $query['id']; //for back up in parseroute
        //             $segments[] = $temp_title;
        //             unset($query['id']);
        //         }
        //     }


        //     if (isset($query['start'])) {
        //         if( count($segments) == 0 ){
        //             $segments[0] = (isset($query['Itemid'])) && ($query['Itemid'] != 0) ? $query['Itemid'] : '0';
        //         }
        //         $segments[] = $query['start'];
        //         if (isset($query['limitstart'])) {
        //             $segments[] = $query['limitstart'];
        //             unset($query['limitstart']);
        //         } else {
        //             $segments[] = $query['start'];
        //         }
        //         unset($query['start']);
        //     } else if (isset($query['limitstart'])) {
        //         $segments[] = $query['limitstart'];
        //         unset($query['limitstart']);
        //     }
        //     if (isset($query['searchtext'])) {
        //         $segments[] = $query['searchtext'];
        //         unset($query['searchtext']);
        //     }
        //     if (isset($query['searchtype'])) {
        //         $segments[] = $query['searchtype'];
        //         unset($query['searchtype']);
        //     }
        // }
        // //unset($query);
        // if (count($segments) == 1) {
        //     $segments[] = 'all_categories';
        // }

        // $total = count($segments);

        // for ($i = 0; $i < $total; $i++){
        //     if(isset($segments[$i])){
        //         $segments[$i] = str_replace(':', '-', $segments[$i]);
        //     }
        // }

        //     // print_r ("end RealEstateManagerBuildRoute     ---- ");
        //     // print_r($segments);
        //     //exit;
        // return $segments;
    }


    /**
     * Parse the segments of a URL.
     *
     */
    public function parse(&$segments)
    {
    
         pu_log_rem("RealEstateManagerRouter:parse 1:",$segments);
        // exit;

        //$input = JFactory::getApplication()->getInput();
        $input_var = JFactory::getApplication()->input->getArray();
        pu_log_rem("RealEstateManagerRouter:parse 11:",$input_var);            


        $vars = array();
        $db = JFactory::getDBO();

        $sefurl = new mosRemSefurl($db);
        $ser_segments = serialize($segments) ;
        $hash_segments = md5( $ser_segments );
        $sefurl_new = $sefurl->loadByHashUrlSegments($hash_segments);
        if($sefurl_new != null ) {
            foreach ($segments as $key => $value) {
                unset($segments[$key]);
            }

            $vars = unserialize( $sefurl_new->ser_vars ) ;
pu_log_rem("RealEstateManagerRouter:parse 2:",$vars);      
            foreach ($vars as $key => $value) {
                if( !isset($input_var[$key]) ) $input_var[$key] = $value ; 
            }      
            return $input_var;
        } else {
            //if url not found by every element - search url by last element of URL
            //some time Joomla not give all segments - so we will try find so url by last segment element
            $last_segment = end($segments) ;
            $hash_last_segment = md5( $last_segment );
            $sefurl_new = $sefurl->loadByHashLastSegment($hash_last_segment);
            if($sefurl_new != null ) {
                foreach ($segments as $key => $value) {
                    unset($segments[$key]);
                }

                $vars = unserialize( $sefurl->ser_vars ) ;
                pu_log_rem("RealEstateManagerRouter:parse 3:",$vars);            
                foreach ($vars as $key => $value) {
                    if( !isset($input_var[$key]) ) $input_var[$key] = $value ; 
                }      
                return $input_var;

            }
        }



//old code - if some error :
        // //print_r($segments);exit;
        //    //  print_r ("start RealEstateManagerParseRoute     ---- ");
        //    //  print_r($segments);
        //    // exit;
        // $vars = array();


        // $total = count($segments);
        // $vars['option'] = 'com_realestatemanager';

        // $menu = JFactory::getApplication()->getMenu();
        // if( !is_numeric($segments[0])){ //&& $segments[0] != 'view'
        //     $vars['Itemid'] = $menu->getDefault()->id;
        // } else {
        //     $menu->setActive($segments[0]);
        //     $vars['Itemid'] = $segments[0];
        // }

        // if ((@$segments[1] == "alone_category" || @$segments[1] == "showCategory") && isset($segments[2]) ) {
        //     if (@$vars['task'] == "alone_category") {
        //         $vars['task'] = "alone_category";
        //     } else {
        //         $vars['task'] = "showCategory";
        //     }

        //     $query_part = explode(':', $segments[2]);
        //     $vars['catid'] = (int) $query_part[0];

        //     if (isset($segments[3])) {
        //         $vars['start'] = $segments[3];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[4]) ) {
        //         $vars['limitstart'] = $segments[4];
        //     } else {
        //         unset($vars['limistart']);
        //     }

        // } elseif ( (@$segments[1] == "view" || @$segments[1] == "view_house"
        //       || @$segments[1] == "showCategory") && isset($segments[4])) {
        //     if (@$segments[1] == "view" || @$segments[1] == "view_house" ) {
        //         $vars['task'] = $segments[1];
        //         $query_part = explode(':', $segments[2]);
        //         $vars['catid'] = (int) $query_part[0];
        //         $vars['id'] = $segments[3];
        //     } else
        //         $vars['task'] = "showCategory";

        //     if (isset($segments[3]) ) {
        //         $vars['start'] = $segments[3];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[5]) ) {
        //         $vars['limitstart'] = $segments[5];
        //     } else {
        //         unset($vars['limitstart']);
        //     }
        // } elseif (@$segments[1] == "view_house") {
        //     $vars['task'] = "view_house";
        // } elseif (@$segments[1] == "secret_image") {
        //     $vars['task'] = "secret_image";
        // } elseif (@$segments[1] == "show_add") {
        //     $vars['task'] = "show_add";
        // } elseif (@$segments[1] == "edit_house") {

        //     $vars['task'] = "edit_house";
        //     if (isset($segments[2]))
        //         $vars['id'] = $segments[2];
        //     $vars['Itemid'] = $segments[0];
        // } elseif (@$segments[1] == "owner_houses") {
        //     $vars['task'] = "owner_houses";
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // } elseif (@$segments[1] == "owners_list") {
        //     $vars['task'] = "owners_list";
        // }elseif(@$segments[1] == "rent_requests"){
        //     $vars['task'] = "rent_requests";
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // }elseif(@$segments[1] == "buying_requests"){
        //     $vars['task'] = "buying_requests";
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // }elseif(@$segments[1] == "buying_request"){
        //     $vars['task'] = "buying_request";
        // }elseif(@$segments[1] == "property_requests"){
        //     $vars['task'] = "property_requests";
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // }elseif(@$segments[1] == "property_request"){
        //     $vars['task'] = "property_request";
        // }elseif(@$segments[1] == "save_rent_request"){
        //     $vars['task'] = "save_rent_request";
        // }elseif(@$segments[1] == "rent_history"){
        //     $vars['task'] = "rent_history";
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // } elseif (@$segments[1] == "my_houses" || @$segments[1] == "edit_my_houses") {
        //     $vars['task'] = "my_houses";
        //     if (isset($segments[2]))
        //         $vars['limitstart'] = $segments[2];
        // } elseif (@$segments[1] == "review_house") {
        //     $vars['task'] = "review_house";
        //     if (isset($segments[2]))
        //         $vars['limitstart'] = $segments[2];
        // } elseif (@$segments[1] == "all_houses") {
        //     $vars['task'] = @$segments[1];
        //     if (isset($segments[2]))
        //         $vars['limitstart'] = $segments[2];
        // } elseif (@$segments[1] == "Search") {
        //     $vars['task'] = "search";
        //     if (isset($segments[4])) {
        //         $vars['searchtext'] = $segments[4];
        //     }
        //     if (isset($segments[5])) {
        //         $vars['searchtype'] = $segments[5];
        //     }
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // } elseif (@$segments[1] == "show_search") { //_realestate
        //     $vars['task'] = "show_search";
        //     if (isset($segments[4])) {
        //         $vars['searchtext'] = $segments[4];
        //     }
        //     if (isset($segments[5])) {
        //         $vars['searchtype'] = $segments[5];
        //     }
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }

        // } elseif (@$segments[1] == "search" || @$segments[1] == "search_houses" || @$segments[1] == "show_search_house" ) {
        //     $vars['task'] = "search";

        //     if( @$segments[1] == "show_search_house" ) $vars['task'] = "show_search_house";

        //     if (isset($segments[2])) {
        //          $vars['start'] = $segments[2];
        //      }
        //      else {
        //          unset($vars['start']);
        //      }
        //      if (isset($segments[3])) {
        //          $vars['limitstart'] = $segments[3];
        //      }
        //      else {
        //          unset($vars['limistart']);
        //      }

        //      if (isset($segments[4])) {
        //          $vars['searchtext'] = $segments[4];
        //      }
        //      if (isset($segments[5])) {
        //          $vars['searchtype'] = $segments[5];
        //      }



        // } elseif (@$segments[1] == "show_rss_categories") {
        //     $vars['task'] = "show_rss_categories";
        // } elseif (@$segments[1] == "buy_now") {
        //     $vars['task'] = "new_url";
        //     if (isset($segments[2])) {
        //         $vars['id'] = $segments[2];
        //     }
        // } elseif (@$segments[1] == "buy_now_for_vm") {
        //     $vars['task'] = "new_url_for_vm";
        //     if (isset($segments[2])) {
        //         $vars['id'] = $segments[2];
        //     }
        // } elseif (@$segments[1] == "view_user_houses") {
        //     $vars['task'] = "view_user_houses";
        //     if (isset($segments[2])) {
        //         $vars['name'] = $segments[2];
        //     }
        //     if (isset($segments[3])) {
        //         $vars['start'] = $segments[3];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[4])) {
        //         $vars['limitstart'] = $segments[4];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // } elseif (@$segments[1] == "lend_history") {
        //     $vars['task'] = "lend_history";
        //     $vars['name'] = $segments[2];
        //     $vars['user'] = $segments[3];
        // } elseif (@$segments[1] == "lend_requests") {
        //     $vars['task'] = "lend_requests";
        //     if (isset($segments[2])) {
        //         $vars['start'] = $segments[2];
        //     } else {
        //         unset($vars['start']);
        //     }
        //     if (isset($segments[3])) {
        //         $vars['limitstart'] = $segments[3];
        //     } else {
        //         unset($vars['limistart']);
        //     }
        // } elseif (@$segments[1] == "mdownload") {
        //     $vars['task'] = "mdownload";
        //     if (isset($segments[2])) {
        //         $vars['id'] = $segments[2];
        //     }
        // } elseif (@$segments[1] == "save_add") {
        //     $vars['task'] = "save_add";

        // } elseif (isset($segments[0]) && isset($segments[1]) ) {

        //   $vars['start'] = $segments[1];
        //   if (isset($segments[2]))   $vars['limitstart'] = $segments[2];;
        // } else {
        //     $vars['task'] = @$segments[1];
        // }

        // foreach ($segments as $key => $value) {
        //     unset($segments[$key]);
        // }

        //        // ECHO "   ++++end RealEstateManagerParseRoute    ----  ";
        //        // print_r($vars);
        //      //exit;
        // return $vars;
    }
}




function RealEstateManagerBuildRoute(&$query)
{
    $app = JFactory::getApplication();
    $router = new RealEstateManagerRouter($app, $app->getMenu('site'));

    return $router->build($query);
}

function RealEstateManagerParseRoute($segments)
{
    $app = JFactory::getApplication();
    $router = new RealEstateManagerRouter($app, $app->getMenu('site'));

    return $router->parse($segments);
}
