<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

$session = JFactory::getSession();
$arr = $session->get("array", "default");
global $hide_js, $Itemid, $mosConfig_live_site, $mosConfig_absolute_path, $database, $my, $catid, $acl;
global $limit, $total, $limitstart, $task, $paginations, $mainframe, $realestatemanager_configuration, $option;

$watermark = false;

if (count($rows) > 0) {

    ?>

    <?php
    // Check that Google Mao API Key exist, if not - show message on the page.
    // Add script to Google Map works.
    // rem_GoogleMap_KeyCheck_AddScript();
    ?>


<noscript>Javascript is required to use <a href="https://ordasoft.com/joomla-real-estate" title="Joomla Real Estate">Joomla Real Estate</a>, <a href="https://ordasoft.com/how-to-create-real-estate-website" title="How to create real estate website" >How to create real estate website</a></noscript>

    <script>

jQuerOs(document).ready(function () {
    function maxMargin(item){
        var A = item, max = 0, elem;
        A.each(function () {

        var margin = parseInt( jQuerOs(this).css('margin-left'), 10) ;

        if ( margin > max)
        max = margin, elem = this;

            if (max > 0) {
                // statement
                jQuerOs('.okno_R').css('margin-bottom', max);
            } else {
                jQuerOs('.okno_R').css('margin-bottom', '10px');
            }

        });
    };


        maxMargin(jQuerOs('.okno_R'));




    });

</script>

<div class="rem">
    <?php positions_rem($params->get('singlecategory01')); ?>

  <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
    <?php 
    if ($params->get('show_page_heading') 
        && $params->get('page_heading') 
        && trim($params->get('page_heading')) != "" ) {  ?>
              <h1><?php echo $params->get('page_heading'); ?></h1>
    <?php } else {  ?>
                <h1><?php echo _HEADER_NUMBER;  ?></h1>                
    <?php } ?>
  </div>

  <div class="componentbody<?php echo $params->get('pageclass_sfx'); ?>">

    <?php positions_rem($params->get('singleuser02')); ?>
    <?php positions_rem($params->get('singlecategory02')); ?>

    <!-- Connect Google or Open map START-->
    <?php
    $map_uniq_id = "12345";
    if (($task != 'rent_request') && ($realestatemanager_configuration['location_map'] == 1)) { ?>
    <div id="map_canvas<?php echo $map_uniq_id; ?>" class="re_map_canvas re_map_canvas_07"></div>

<?php
    if ( $realestatemanager_configuration['google_openmap']['show'] == 0 ){
    //for open map add div for Popup
?>

    <div id="os_ol_popup<?php echo $map_uniq_id; ?>" class="os_ol_popup">
      <a href="#" id="os_ol_popup-closer<?php echo $map_uniq_id; ?>" class="os_ol_popup-closer"></a>
      <div id="os_ol_popup-content<?php echo $map_uniq_id; ?>"></div>
    </div>

<?php
        // HTML_realestatemanager::add_open_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', 'map', 'open_map');

    } else {
        // HTML_realestatemanager::add_google_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', 'map', 'google_map');
    }
?>
<!-- Connect Google or Open map END-->

    <?php } ?>
<?php
$sort_arr['order_field'] = $params->get('sort_arr_order_field');
$sort_arr['order_direction'] = $params->get('sort_arr_order_direction');
?>

<div id="ShowOrderBy" class="table_31 REL-row">
<?php
if($realestatemanager_configuration['searchlayout_orderby']['show']): ?>

<?php  if(checkAccess_REM($realestatemanager_configuration['searchlayout_orderby']['registrationlevel'],
              'NORECURSE', userGID_REM($my->id), $acl)): ?>
    <form method="POST" action="<?php echo sefRelToAbs($_SERVER["REQUEST_URI"]); ?>" name="orderForm" class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-5 REL-collumn-lg-5">
        <input type="hidden" id="order_direction" name="order_direction" value="<?php echo $sort_arr['order_direction']; ?>" >
        <a title="Click to sort by this column." onclick="javascript:allreordering();return false;" href="#">
<?php
    if ($sort_arr['order_direction'] == 'asc') {
        echo '<i class="fa fa-sort-alpha-asc"></i>';
    } else {
        echo '<i class="fa fa-sort-alpha-desc"></i>';
    }
?>
        </a>
<?php echo _REALESTATE_MANAGER_LABEL_ORDER_BY; ?>
        <select size="1" class="inputbox" onchange="javascript:document.orderForm.order_direction.value='asc';  document.orderForm.submit();" id="order_field" name="order_field">
            <option  value="ordering" <?php if ($sort_arr['order_field'] == "ordering")
                echo 'selected="selected"'; ?> >  <?php echo _REALESTATE_MANAGER_LABEL_ORDERING; ?> </option>
            <option  value="date" <?php if ($sort_arr['order_field'] == "date")
                 echo 'selected="selected"'; ?> >  <?php echo _REALESTATE_MANAGER_LABEL_DATE; ?>
            </option>
            <option value="price" <?php if ($sort_arr['order_field'] == "price")
                 echo 'selected="selected"'; ?> > <?php echo _REALESTATE_MANAGER_LABEL_PRICE; ?>
            </option>
            <option value="htitle" <?php if ($sort_arr['order_field'] == "htitle")
                 echo 'selected="selected"'; ?> > <?php echo _REALESTATE_MANAGER_LABEL_TITLE; ?>
            </option>
        </select>
    </form>
    <?php endif ?>
<?php endif ?>

    <div class="button_ppe table_29 REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-7 REL-collumn-lg-7">
<?php
if (!$params->get('wrongitemid')) {
    if ($realestatemanager_configuration['search_button']['show']) {
        if (checkAccess_REM($realestatemanager_configuration['search_button']['registrationlevel'],
         'NORECURSE', userGID_REM($my->id), $acl)) {
            HTML_realestatemanager::showSearchButton($Itemid);
        }
    }
}
?>

<span class="rem_house_files">
</span>
</div>

    <div style="clear: both;"></div>
</div>

<?php positions_rem($params->get('singlecategory03')); ?>
<?php positions_rem($params->get('singleuser03')); ?>
<?php positions_rem($params->get('singlecategory04')); ?>
<?php positions_rem($params->get('singleuser04')); ?>
<?php positions_rem($params->get('singlecategory05')); ?>
<div class="REL-row">

<!--style for show or hide search block-->
<?php if ($params->get('search_all_houses_registrationlevel') && $params->get('search_all_houses')): ?>
<div class="REL-collumn-xs-12 REL-collumn-sm-8 REL-collumn-md-9 REL-collumn-lg-9">
<?php else: ?>
<div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-12 REL-collumn-lg-12">
<?php endif; ?>

        <div    id="gallery_rem"
                data-collumn-lg="<?php echo $realestatemanager_configuration['rel_data_columns_adv_lg']; ?>"
                data-collumn-md="<?php echo $realestatemanager_configuration['rel_data_columns_adv_md']; ?>"
                data-collumn-sm="<?php echo $realestatemanager_configuration['rel_data_columns_adv_sm']; ?>"
                data-collumn-xs="<?php echo $realestatemanager_configuration['rel_data_columns_adv_xs']; ?>">
            <?php
            $total = count($rows);

            foreach($rows as $row): ?>

            <?php

                $tmphouse = new mosRealEstateManager($database);
                $tmphouse->load($row->id);
                $tmphouse->setCatIds();
                $link = 'index.php?option=' . $option . '&amp;task=view&amp;id=' .
                $row->id . '&amp;catid=' . $tmphouse->catid[0] . '&amp;Itemid=' . $Itemid;
                $imageURL = $row->image_link;
                ?>

                <div class="okno_R imageBlock">
                    <div class="divamage" style = "position: relative; text-align:center;">
                    <a href="<?php echo sefRelToAbs($link); ?>" style="text-decoration: none">
                        <?php
                        if ($imageURL == '') $imageURL = _REALESTATE_MANAGER_NO_PICTURE_BIG;
                        $file_name =rem_picture_thumbnail($imageURL,
                           $realestatemanager_configuration['fotocategory']['width'],
                           $realestatemanager_configuration['fotocategory']['high'], $watermark);
                        $file = JURI::root() . 'components/com_realestatemanager/photos/' . $file_name;
                        echo '<img alt="' . $row->htitle . '" title="' . $row->htitle . '" src="' .
                        $file . '" border="0" class="little">';
                        ?>
                    </a>

                    <?php
                        if ($row->listing_status){
                          if ($row->listing_status != 0){
                            $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
                            $ls = 1;
                            foreach ($listing_status1 as $listing_status2) {
                                $listing_status[$ls] = $listing_status2;
                                $ls++;
                            }
                            echo '<div class="rem_listing_status">'.$listing_status[$row->listing_status].'</div>';
                          }
                        }
                    ?>

                    <div class="col_rent">
                        <?php

                        if ($params->get('show_housestatus')) {
                            if ($params->get('show_houserequest')) {

                                $data1 = JFactory::getDBO();
                                $query = "SELECT  b.rent_from , b.rent_until  FROM #__rem_rent AS b " .
                                " LEFT JOIN #__rem_houses AS c ON b.fk_houseid = c.id " . " WHERE c.id=" .
                                $row->id . " AND c.published='1' AND c.approved='1' AND b.rent_return IS NULL";
                                $data1->setQuery($query);
                                $rents1 = $data1->loadObjectList();
                                ?>
                                <?php
                                if ($row->listing_type == 1) {
                                    echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_RENT;
                                } else if($row->listing_type == 2){
                                    echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_SALE;
                                } else if($row->listing_type == 3){
                                    echo _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST;
                                }
                            }
                        }
                        ?>
                    </div><!-- col_rent -->

                </div>
                <div class="texthouse">
                    <div class="titlehouse">
                        <a href="<?php echo sefRelToAbs($link); ?>" >
                            <?php
                            if (strlen($row->htitle) > 45) echo mb_substr($row->htitle, 0, 25), '...';
                            else {
                                echo $row->htitle;
                            }
                            ?>
                        </a>
                    </div>
                    <div style="clear: both;"></div>

                    <div class="rem_type_Allhouses">
                     <?php if (trim($row->house_size)):?>
                        <div class="row_text">
                            <i class="fa fa-expand"></i>
                            <span class="col_text_2">
                                <?php echo $row->house_size; ?>
                                <?php echo _REALESTATE_MANAGER_LABEL_SIZE_SUFFIX; ?>
                            </span>
                        </div>
                    <?php endif ?>

                    <?php if (trim($row->rooms)):?>
                    <div class="row_text">
                        <i class="fa fa-building"></i>
                        <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_ROOMS; ?>:</span>
                        <span class="col_text_2"><?php echo $row->rooms; ?></span>
                    </div>
                    <?php endif ?>
                    <?php if (trim($row->year)): ?>
                <div class="row_text">
                    <i class="fa fa-calendar"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?>:</span>
                    <span class="col_text_2"><?php echo $row->year; ?></span>
                </div>
                <?php endif ?>

                <?php if (trim($row->bedrooms)):?>
            <div class="row_text">
                <i class="fa fa-inbox"></i>
                <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BEDROOMS; ?>:</span>
                <span class="col_text_2"><?php echo $row->bedrooms; ?></span>
            </div>
            <?php endif ?>

    </div>
</div>
<div class="rem_house_viewlist">
    <a href="<?php echo sefRelToAbs($link); ?>" style="display: block">
    <?php


        if ($params->get('show_pricerequest') && $row->price !== '' && $row->priceunit !== '') {

            if(!incorrect_price($row->price)){
            ?>
            <div class="price"><?php
                if ($realestatemanager_configuration['price_unit_show'] == '1') {
                    if ($realestatemanager_configuration['sale_separator'])
                       echo formatMoney($row->price, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']), ' ',
                   $row->priceunit;
                   else echo $row->price, ' ', $row->priceunit;
               } else {
                if ($realestatemanager_configuration['sale_separator'])
                   echo $row->priceunit, ' ', formatMoney($row->price, $realestatemanager_configuration['sale_fraction'],
                      $realestatemanager_configuration['price_format']);
               else echo $row->priceunit, ' ', $row->price;
           }
               ?>
               </div>
            <?php
            }else{
                echo '<div class="price">'.trim($row->price).'</div>';
            }
        }
    ?>
   <span><?php echo _REALESTATE_MANAGER_LABEL_VIEW_LISTING; ?></span></a>
   <div style="clear: both;"></div>

</div>
</div>


<?php endforeach; ?>

</div>

<?php
$paginations = $arr;
if ($paginations && ($pageNav->total > $pageNav->limit)): ?>

   <div id="pagenavig">
    <?php
    echo $pageNav->getPagesLinks();
    ?>
</div>
<?php endif ?>

</div> <!-- end span9  -->

<?php
if($params->get('search_all_houses') && $params->get('search_all_houses_registrationlevel')): ?>
    <div class="REL-collumn-xs-12 REL-collumn-sm-4 REL-collumn-md-3 REL-collumn-lg-3">
        <?php positions_rem($params->get('singleuser01')); ?>
        <div class="rem_house_contacts">
            <div id="rem_house_titlebox">
                <?php echo _REALESTATE_MANAGER_SHOW_SEARCH; ?>
            </div>
            <?php
            PHP_realestatemanager::showSearchHouses($option, $catid, $option, $layout);
            ?>
        </div>
    </div>
<?php endif ?>

</div><!-- end row-fluid  -->
<?php positions_rem($params->get('singlecategory09')); ?>
<?php positions_rem($params->get('singlecategory11')); ?>


<div class="basictable table_35">
    <?php mosHTML::BackButton($params, $hide_js); ?>
</div>
<?php 
} //if (count($rows) > 0) 
?>

</div> <!--class="componentbody -->
<p style="text-align: center; font-size: 12px;"><a title="Joomla Real Estate" href="https://ordasoft.com/joomla-real-estate" target="_blank">Joomla Real Estate</a>, by OrdaSoft.</p>
</div> <!--class="rem -->
