<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

$session = JFactory::getSession();
$arr = $session->get("array", "default");
global $hide_js, $Itemid, $mosConfig_live_site, $mosConfig_absolute_path, $database, $doc, $my;
global $limit, $total, $limitstart, $task, $paginations, $mainframe, $realestatemanager_configuration;

$watermark = false;

function words_limit($input_text, $limit = 50, $end_str = '') {
    $input_text = strip_tags($input_text);
    $words = explode(' ', $input_text);
    if ($limit < 1 || sizeof($words) <= $limit) {
     return $input_text;
    }
    $words = array_slice($words, 0, $limit);
     $out = implode(' ', $words);
    return $out . $end_str;
}
// $user = Jfactory::getUser(); we call this from search result for my_houses 2020_11_10
// if (isset($_REQUEST['userId'])) {
//     if ($option != 'com_realestatemanager' and $_REQUEST['userId'] == $user->id) PHP_realestatemanager::showTabs();
// } else {
//     if ($option != 'com_realestatemanager') PHP_realestatemanager::showTabs();
// }
?>

<?php
// Check that Google Mao API Key exist, if not - show message on the page.
// Add script to Google Map works.
// rem_GoogleMap_KeyCheck_AddScript();
?>
<noscript>Javascript is required to use <a href="https://ordasoft.com/joomla-real-estate" title="Joomla Real Estate">Joomla Real Estate</a>, <a href="https://ordasoft.com/how-to-create-real-estate-website" title="How to create real estate website" >How to create real estate website</a></noscript>

<div class="rem">

<?php positions_rem($params->get('singlecategory01')); ?>

  <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
    <?php 
    if ( is_menu_item_rem($Itemid)
        && $params->get('show_page_heading') 
        && $params->get('page_heading') 
        && trim($params->get('page_heading')) != "" ) {  ?>
              <h1><?php echo $params->get('page_heading'); ?></h1>
    <?php } else if($params->get('header')) {  ?>
              <h1><?php echo $params->get('header') ; ?></h1>                
    <?php } else {  ?>
              <h1><?php echo $currentcat->header ; ?></h1>                
    <?php } ?>
  </div>

  <div class="componentbody<?php echo $params->get('pageclass_sfx'); ?>">

<?php positions_rem($params->get('singleuser02')); ?>
<?php positions_rem($params->get('singlecategory02')); ?>

<?php
$GLOBALS['map_uniq_id'] = $map_uniq_id = "67890";
if (($task != 'rent_request') && ($realestatemanager_configuration['location_map'] == 1)) { ?>

    <div id="map_canvas<?php echo $map_uniq_id; ?>" class="re_map_canvas re_map_canvas_02"></div>

<?php
    if ( $realestatemanager_configuration['google_openmap']['show'] == 0 ){
    //for open map add div for Popup
?>
    <div id="os_ol_popup<?php echo $map_uniq_id; ?>" class="os_ol_popup">
      <a href="#" id="os_ol_popup-closer<?php echo $map_uniq_id; ?>" class="os_ol_popup-closer"></a>
      <div id="os_ol_popup-content<?php echo $map_uniq_id; ?>"></div>
    </div>

<?php
        // HTML_realestatemanager::add_open_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', 'map', 'open_map');

    } else {
        // HTML_realestatemanager::add_google_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', 'map', 'google_map');
    }
?>
<?php } ?>

<?php
if (count($rows) > 0) {
    $sort_arr['order_field'] = $params->get('sort_arr_order_field');
    $sort_arr['order_direction'] = $params->get('sort_arr_order_direction');
?>
    <?php positions_rem($params->get('singleuser03')); ?>
    <?php positions_rem($params->get('singlecategory03')); ?>
    <?php positions_rem($params->get('singlecategory04')); ?>
    <?php $option_type = Joomla\Utilities\ArrayHelper::getValue($_REQUEST, 'option');

    if ($option_type != 'com_simplemembership'): ?>

    <div id="ShowOrderBy" class="table_38 REL-row">


<?php if($realestatemanager_configuration['searchlayout_orderby']['show']): ?>

        <form method="POST"
            action="<?php echo sefRelToAbs($_SERVER["REQUEST_URI"]); ?>" name="orderForm" class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-5 REL-collumn-lg-5">
            <input type="hidden" id="order_direction" name="order_direction"
             value="<?php echo $sort_arr['order_direction']; ?>" >
            <a title="Click to sort by this column."
             onclick="javascript:allreordering();return false;" href="#">
                               <?php
        if ($sort_arr['order_direction'] == 'asc') {
            echo '<i class="fa fa-sort-alpha-asc"></i>';
        } else {
            echo '<i class="fa fa-sort-alpha-desc"></i>';
        }
?>
           </a>
    <?php echo _REALESTATE_MANAGER_LABEL_ORDER_BY; ?>
             <select size="1" class="inputbox"
              onchange="javascript:document.orderForm.order_direction.value='asc'; document.orderForm.submit();"
               id="order_field" name="order_field">
                    <option  value="ordering" <?php if ($sort_arr['order_field'] == "ordering")
                    echo 'selected="selected"'; ?> >  <?php echo _REALESTATE_MANAGER_LABEL_ORDERING; ?> </option>
                    <option value="date" <?php if ($sort_arr['order_field'] == "date")
                     echo 'selected="selected"'; ?> > <?php echo _REALESTATE_MANAGER_LABEL_DATE; ?> </option>
                    <option value="price" <?php if ($sort_arr['order_field'] == "price")
                     echo 'selected="selected"'; ?> > <?php echo _REALESTATE_MANAGER_LABEL_PRICE; ?></option>
                    <option value="htitle" <?php if ($sort_arr['order_field'] == "htitle")
                     echo 'selected="selected"'; ?> > <?php echo _REALESTATE_MANAGER_LABEL_TITLE; ?></option>
            </select>
        </form>
<?php endif ?>


        <div class="button_ppe table_29 REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-7 REL-collumn-lg-7">

<?php
      if ($realestatemanager_configuration['search_button']['show']) {
        HTML_realestatemanager::showSearchButton($Itemid);
    }
?>

<span class="rem_house_files">
</span>

    </div>

<div style="clear: both;"></div>
<?php endif ?>

    </div>

            <?php positions_rem($params->get('singleuser04')); ?>
            <?php positions_rem($params->get('singlecategory05')); ?>
<div class="REL-row">
<!--style for show or hide search block-->
<?php if ($params->get('search_alone_category') && $params->get('search_alone_category_registrationlevel')): ?>
<div class="REL-collumn-xs-12 REL-collumn-sm-8 REL-collumn-md-9 REL-collumn-lg-9">
<?php else: ?>
<div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-12 REL-collumn-lg-12">
<?php endif; ?>

    <div id="list">
    <?php
    $available = false;
    $k = 0;
    $total = count($rows);
    $g_item_count = 0;
    foreach($rows as $row) {
        $tmphouse = new mosRealEstateManager($database);
        $tmphouse->load($row->id);
        $tmphouse->setCatIds();
        $link = 'index.php?option=com_realestatemanager&task=view&id=' .
         $row->id . '&catid=' . $tmphouse->catid[0] . '&Itemid=' .
          $Itemid ;
        $g_item_count++;
?>

            <div class="list_house <?php echo $tabclass[($g_item_count % 2) ]; ?> REL-row"  >

             <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 rem_list_image_container">


                <span class="col_img" style="position: relative;">
                    <a href="<?php echo sefRelToAbs($link); ?>">
            <?php
        $house = $row;
        $imageURL = $house->image_link;
        if ($imageURL == '') $imageURL = _REALESTATE_MANAGER_NO_PICTURE_BIG;
            $file_name = rem_picture_thumbnail($imageURL,
                         $realestatemanager_configuration['foto']['width'],
                          $realestatemanager_configuration['foto']['high'], $watermark);
            $file = JURI::root() . 'components/com_realestatemanager/photos/' . $file_name;
            echo '<img alt="' . $house->htitle . '" title="' . $house->htitle . '" src="' .
                                $file . '" border="0" class="little">';
?>
                    </a>
                    <?php
                        if ($house->listing_status){
                          if ($house->listing_status != 0){
                            $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
                            $ls = 1;
                            foreach ($listing_status1 as $listing_status2) {
                                $listing_status[$ls] = $listing_status2;
                                $ls++;
                            }
                            echo '<div class="rem_listing_status">'.$listing_status[$house->listing_status].'</div>';
                          }
                        }
                    ?>
                     <div class="col_rent">
<?php
        if ($params->get('show_housestatus')) {
            if ($params->get('show_houserequest')) {
                
                if ($row->listing_type == 1) {
                    echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_RENT;
                }else if($row->listing_type == 2){
                    echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_SALE;
                }else if($row->listing_type == 3){
                    echo _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST;
                } 
            }
        }
?>
                </div><!-- col_rent -->
            </span>

            </div>

             <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8 rem_list_container">

<div id="rem_house_catlist">
    <div class="col_htitle">
        <a href="<?php echo sefRelToAbs($link); ?>" class="category<?php echo $params->get('pageclass_sfx'); ?>">
    <?php positions_rem(words_limit($row->htitle, 5, '...')); ?></a>
    </div>
    <div class="price_hits">
<?php if ($params->get('show_pricerequest') && $row->price !== '' && $row->priceunit !== ''):?>

    <?php if (!incorrect_price($row->price)):?>

    <?php if ($row->price != '' || $row->priceunit != ''): ?>

        <?php if ($realestatemanager_configuration['price_unit_show'] == '1') :?>

            <?php if ($realestatemanager_configuration['sale_separator']):?>

                    <div class="price_priceunit">
                        <span class="col_price">
                    <?php echo formatMoney($row->price, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']); ?>
                        </span>
                        <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                    </div>
                  <?php else: ?>
                    <div class="price_priceunit">
                        <span class="col_price"><?php echo $row->price; ?></span>
                        <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                    </div>

                <?php endif ?>

            <?php else: ?>

            <?php if ($realestatemanager_configuration['sale_separator']): ?>

                    <div class="price_priceunit">
                        <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                        <span class="col_price">
        <?php echo formatMoney($row->price, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']); ?>
                        </span>
                    </div>
                            <?php else: ?>

                    <div class="price_priceunit">
                        <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                        <span class="col_price"><?php echo $row->price; ?></span>
                    </div>
            <?php endif ?>

        <?php endif ?>

    <?php endif ?>

    <?php else: ?>
        <span class="col_price"><?php echo $row->price; ?></span>
    <?php endif; ?>

<?php endif ?>
    </div> <!-- price_hits -->
   <div class="col_hlocation">
    <?php if ( trim($row->hcountry) !== '' || trim($row->hregion) !== '' || trim($row->hcity) !== '' || trim($row->hzipcode) !== '' || trim($row->hlocation) !== '' ) { ?>
                    <i class="fa fa-map-marker"></i>

        <?php if (trim($row->hcountry)):?>
                        <span class="col_text_2"><?php echo trim($row->hcountry); ?></span>,

        <?php endif ?>

        <?php if (trim($row->hregion)):?>
                        <span class="col_text_2"><?php echo trim($row->hregion); ?></span>,
        <?php endif ?>

        <?php if (trim($row->hcity)): ?>
                        <span class="col_text_2"><?php echo trim($row->hcity); ?></span>,
        <?php endif ?>

        <?php if (trim($row->hzipcode)): ?>

                <span class="col_text_2"><?php echo trim($row->hzipcode); ?></span>,

        <?php endif ?>

        <?php if (trim($row->hlocation)): ?>

            <span class="col_02"><?php echo trim($row->hlocation); ?></span>.

        <?php endif ?>
        <?php } ?>

    </div>

    <?php if (trim($row->description)): ?>
        <div class="rem_house_description">
            <?php positions_rem(words_limit($row->description, 20, '...')); ?>
        </div>
    <?php endif ?>

                            </div>





                            </div>

                            <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-12 REL-collumn-lg-12">
                                <div class="rem_type_catlist">

                                    <?php if ($params->get('show_category')) : ?>

                                            <?php           $link1 = 'index.php?option=com_realestatemanager&amp;task=showCategory&amp;catid=' .
                                                 $catid . '&amp;Itemid=' . $Itemid;
                                    ?>

                                        <div class="col_category_title row_text">
                                            <i class='fa fa-tag'></i>
                                            <a href="<?php echo sefRelToAbs($link1); ?>"
                                             class="category<?php echo $params->get('pageclass_sfx'); ?>">
                                                <?php echo $params->get('category_name'); ?>
                                            </a>
                                        </div>

                                    <?php endif ?>

                                                <div class="col_hits row_text">

                                        <?php if ($params->get('hits')):?>

                                                        <div class="col_hits">
                                <span class="col_10">
                                                        <?php echo "<i class='fa fa-eye'></i>" . "&nbsp;" . _REALESTATE_MANAGER_LABEL_HITS; ?>:
                                </span>
                                <span class="col_11">
                                                        <?php echo $row->hits; ?>
                                </span>
                                                        </div>

                                         <?php endif ?>

                                                </div> <!-- price_hits -->

                                                       <?php if (trim($row->house_size)):?>
                                                <div class="row_text">
                                                    <i class="fa fa-expand"></i>
                                                    <span class="col_text_2">
                                                        <?php echo $row->house_size; ?>
                                                        <?php echo _REALESTATE_MANAGER_LABEL_SIZE_SUFFIX; ?>
                                                    </span>
                                                </div>
                                            <?php endif ?>


                                            <?php if (trim($row->year)): ?>
                                                <div class="row_text">
                                                    <i class="fa fa-calendar"></i>
                                                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?>:</span>
                                                    <span class="col_text_2"><?php echo $row->year; ?></span>
                                                </div>

                                            <?php endif ?>

                                            <?php if (trim($row->rooms)):?>

                                                <div class="row_text">
                                                    <i class="fa fa-building"></i>
                                                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_ROOMS; ?>:</span>
                                                    <span class="col_text_2"><?php echo $row->rooms; ?></span>
                                                </div>
                                            <?php endif ?>

                                            <?php if (trim($row->bedrooms)): ?>
                                                <div class="row_text">
                                                    <i class="fa fa-inbox"></i>
                                                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BEDROOMS; ?>:</span>
                                                    <span class="col_text_2"><?php echo $row->bedrooms; ?></span>
                                                </div>
                                            <?php endif ?>

                                            <div style="clear: both;"></div>
                                                        </div>
                            </div>


                            </div>
                     <?php
    }
?>
    </div> <!-- list -->

                <?php positions_rem($params->get('singleuser05')); ?>
                <?php positions_rem($params->get('singlecategory06')); ?>
                <?php
}
?>

    <br/>
    <div class="basictable table_27">


<?php
    $paginations = $arr;
    if ($paginations && ($pageNav->total > $pageNav->limit)): ?>

       <div id="pagenavig">
            <?php
            echo $pageNav->getPagesLinks();
            ?>
        </div>
<?php endif ?>


        <div class="col_02">
<?php
if ($params->get('show_rentstatus') && $params->get('show_rentrequest')
 && !$params->get('rent_save') && !$params->get('search_request')):
?>

        <?php elseif ($params->get('show_rentstatus') && $params->get('show_rentrequest')
 && $params->get('rent_save') && !$params->get('search_request')) : ?>

                <input type="button" class="button"
                 value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_RENT_REQU_SAVE; ?>"
                  onclick="rem_rent_request_submitbutton()" />

            <?php else: ?>
                &nbsp;
<?php endif ?>
        </div>

    </div>
</div> <!-- end span9  -->
<?php
if($params->get('search_alone_category') && $params->get('search_alone_category_registrationlevel')):?>

<div class="REL-collumn-xs-12 REL-collumn-sm-4 REL-collumn-md-3 REL-collumn-lg-3">
<?php positions_rem($params->get('singleuser01')); ?>
<?php positions_rem($params->get('view05')); ?>
    <div class="rem_house_contacts">
        <div id="rem_house_titlebox">
            <?php echo _REALESTATE_MANAGER_SHOW_SEARCH; ?>
        </div>
            <?php
            PHP_realestatemanager::showSearchHouses($option, $catid, $option, $layout);
            ?>
    </div>
</div>
<?php endif ?>
</div><!-- end row-fluid  -->
<?php positions_rem($params->get('singlecategory09')); ?>
  <?php positions_rem($params->get('singlecategory11')); ?>


<?php if ($is_exist_sub_categories):?>
        <?php positions_rem($params->get('singlecategory07')); ?>
    <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">

    <?php echo _REALESTATE_MANAGER_LABEL_FETCHED_SUBCATEGORIES . " : " . $params->get('category_name'); ?>
    </div>

    <?php positions_rem($params->get('singlecategory08')); ?>

    <?php
    HTML_realestatemanager::listCategories($params, $categories, $catid, $tabclass, $currentcat);

    ?>

<?php endif ?>


<div class="basictable table_28">
    <?php
mosHTML::BackButton($params, $hide_js);
?>
</div>
</div> <!--class="componentbody -->
<p style="text-align: center; font-size: 12px;"><a title="Joomla Real Estate" href="https://ordasoft.com/joomla-real-estate" target="_blank">Joomla Real Estate</a> by OrdaSoft.</p>
</div> <!--class="rem -->
