<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');


global $hide_js, $database, $mainframe, $Itemid, $realestatemanager_configuration,
  $mosConfig_live_site, $mosConfig_absolute_path, $my, $doc, $arr, $acl,$langContent;


$watermark = false;

////////////Adding google map
$realestatemanager_configuration = $GLOBALS['realestatemanager_configuration'];
if ($realestatemanager_configuration['location_tab']['show']
    || $realestatemanager_configuration['street_view']['show']) {


  if ( $realestatemanager_configuration['google_openmap']['show'] == 1 ) {
    //show Google map

    // $api_key = "key=" . $realestatemanager_configuration['api_key'] ;
    // $doc->addScript("//maps.googleapis.com/maps/api/js?$api_key");
    if ( isset($realestatemanager_configuration['api_key']) && $realestatemanager_configuration['api_key'] ) {
        $api_key = "key=" . $realestatemanager_configuration['api_key'];
    } else {
      $api_key = JFactory::getApplication()->enqueueMessage("<a target='_blank' href='//developers.google.com/maps/documentation/geocoding/get-api-key'>" . _REALESTATE_MANAGER_GOOGLEMAP_API_KEY_LINK_MESSAGE . "</a>", _REALESTATE_MANAGER_GOOGLEMAP_API_KEY_ERROR);
    }
    //if ( checkJavaScriptIncludedRE("maps.googleapis.com") === false ) {
    if ( checkJavaScriptIncludedRE("apis.com/maps/api/js") === false ) {
        // $doc->addScript("//maps.googleapis.com/maps/api/js?$api_key&libraries=places");
        // $doc = JFactory::getDocument();
        // $doc->addScript("//maps.googleapis.com/maps/api/js?$api_key");

?>
                <!-- prettier-ignore -->
    <script>(g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})
        ({key: "<?php echo $realestatemanager_configuration['api_key']; ?>", v: "weekly" });</script>
 <?php

    }
    if($realestatemanager_configuration['street_view']['show']){
      ?>
      <script type="text/javascript">
        // Turn off Mootools because it crushed StreetView GoogleMap and gange on jQuer
        // window.addEvent('domready', function() {
        jQuerOs(document).ready(function() {
          initialize();
        });
        var map;
        var myLat = <?php
          if ($house->hlatitude && $house->hlatitude != '')
            echo $house->hlatitude;
          else
            echo 0;
          ?>;
        var myLng = <?php
          if ($house->hlongitude && $house->hlongitude != '')
            echo $house->hlongitude;
          else
            echo 0;
          ?>;
          var myLatLng = {lat: myLat, lng: myLng};

//        var sv = new google.maps.StreetViewService();

        var panorama;
        async function initialize(){

          const { Map, InfoWindow } = await google.maps.importLibrary("maps");
          const { AdvancedMarkerElement, PinElement } = await google.maps.importLibrary(
              "marker",
          );

          var myOptions = {
              mapId: "One-House-map",
              zoom: <?php if ($house->map_zoom)
                              echo $house->map_zoom;
                          else
                              echo 1;
                          ?>,
              center: myLatLng,
              zoomControl: true,
              scrollwheel: false,
              mapTypeId: 'roadmap'
          };
          if(document.getElementById("map_canvas") != undefined){
            map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
          }
          var imgCatalogPath = "<?php echo JURI::root(); ?>components/com_realestatemanager/";
    <?php
          $newArr = explode(",", _REALESTATE_MANAGER_HOUSE_MARKER);
          $numPick = '';
          if (isset($newArr[$house->property_type])) {
              $numPick = $newArr[$house->property_type];
          } else $numPick = $newArr[1] ;
    ?>
          var srcForPic = imgCatalogPath + "<?php echo $numPick; ?>";

          var MarkerImg = document.createElement('img');
          MarkerImg.src = srcForPic;
          MarkerImg.height = 32 ;
          MarkerImg.width = 32 ;

          var marker = new google.maps.marker.AdvancedMarkerElement({
              content: MarkerImg,
              position: myLatLng
          });

          marker.setMap(map);

          var streetViewService = new google.maps.StreetViewService();
          var STREETVIEW_MAX_DISTANCE = 1050;
          streetViewService.getPanoramaByLocation(myLatLng, STREETVIEW_MAX_DISTANCE, function (streetViewPanoramaData, status) {
            if (status === google.maps.StreetViewStatus.OK) {
              // ok
		  var panoramaOptions = {
		    position: streetViewPanoramaData.location.latLng,
		    pov: {
		      heading: 34,
		      pitch: 10
		    }
		  };

              var panorama = new google.maps.StreetViewPanorama(document.getElementById('map_pano'), panoramaOptions);
              map.setStreetView(panorama);
            } else {
            if( document.getElementById('map_pano') != null )
               document.getElementById('map_pano').style.display = "none";
              // no street view available in this range, or some error occurred
            }
          });

        }
      </script>
      <?php

    } else {

      ?>
      <script type="text/javascript">
        /*window.addEvent('domready', function() {
          initialize();
        });*/
        var map;
        var myLat = <?php
          if ($house->hlatitude && $house->hlatitude != '')
            echo $house->hlatitude;
          else
            echo 0;
          ?>;
        var myLng =  <?php
          if ($house->hlongitude && $house->hlongitude != '')
            echo $house->hlongitude;
          else
            echo 0;
          ?>;
          var myLatLng = {lat: myLat, lng: myLng};

        async function initialize(){

          const { Map, InfoWindow } = await google.maps.importLibrary("maps");
          const { AdvancedMarkerElement, PinElement } = await google.maps.importLibrary(
              "marker",
          );

          var myOptions = {
              mapId: "One-House-map",
              zoom: <?php if ($house->map_zoom)
                              echo $house->map_zoom;
                          else
                              echo 1;
                          ?>,
              center: myLatLng,
              scrollwheel: false,
              zoomControl: true,
              mapTypeId: 'roadmap'
          };
          map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
          var imgCatalogPath = "<?php echo JURI::root(); ?>components/com_realestatemanager/";
    <?php
          $newArr = explode(",", _REALESTATE_MANAGER_HOUSE_MARKER);
          $numPick = '';
          if (isset($newArr[$house->property_type])) {
              $numPick = $newArr[$house->property_type];
          } else $numPick = $newArr[1] ;
    ?>
          var srcForPic = imgCatalogPath + "<?php echo $numPick; ?>";

          var MarkerImg = document.createElement('img');
          MarkerImg.src = srcForPic;
          MarkerImg.height = 32 ;
          MarkerImg.width = 32 ;

          var marker = new google.maps.marker.AdvancedMarkerElement({
              content: MarkerImg,
              position: myLatLng
          });

          marker.setMap(map);
        }

            function mod_loc_map_addLoadEvent(func) {
             var oldonload = window.onload;
             if (typeof window.onload != 'function') {
                window.onload = func;
              } else {
                window.onload = function() {
                  if (oldonload) {
                    oldonload();
                  }
                  func();
                }
              }
            }
          mod_loc_map_addLoadEvent(initialize);

      </script>
      <?php }

    }else {


      //show OpenMap
      // $doc->addScript("//openlayers.org/en/v4.6.5/build/ol.js");
      // $doc->addStyleSheet("//openlayers.org/en/v4.6.5/css/ol.css");
      $doc->addScript("//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.js");
      $doc->addStyleSheet("//cdnjs.cloudflare.com/ajax/libs/ol3/4.6.5/ol.css");

      ?>

      <script type="text/javascript">
        // Turn off Mootools because it crushed StreetView GoogleMap and gange on jQuer
        // window.addEvent('domready', function() {
        jQuerOs(document).ready(function() {
          initialize();
          if( document.getElementById('map_pano') != null )
                  document.getElementById('map_pano').style.display = "none";
        });

        var ol_point;
        var map_view;
        var map ;
        var pointFeature;
        var map_layer;

        function initialize(){

            //if map already created: refresh
                if (map instanceof ol.Map) {
                    map.updateSize();
                    return ;
                };

            ol_point = ol.proj.fromLonLat([<?php
                if ($house->hlongitude && $house->hlongitude != '')
                  echo $house->hlongitude;
                else
                  echo 0;
                ?>,<?php
                if ($house->hlatitude && $house->hlatitude != '')
                  echo $house->hlatitude;
                else
                  echo 0;
                ?>]);

            map_view = new ol.View({
              center: ol_point,
              zoom: <?php if ($house->map_zoom)
                              echo $house->map_zoom;
                          else
                              echo 8;
                          ?>
            });

            map = new ol.Map({
              //kill zoom by mouse scroll in OpenMap
              interactions: ol.interaction.defaults({mouseWheelZoom:false}),

              layers: [
                new ol.layer.Tile({
                  source: new ol.source.OSM()
                })
              ],
              target: 'map_canvas',
              controls: ol.control.defaults({
                attributionOptions: {
                  collapsible: false
                }
              }),
              view: map_view
            });


            var imgCatalogPath = "<?php echo JURI::root(); ?>components/com_realestatemanager/";
            var image_point_src = imgCatalogPath + "images/marker-2.png";


            pointFeature = new ol.Feature(new ol.geom.Point(ol_point)) ;

            map_layer = new ol.layer.Vector({
                  source: new ol.source.Vector({
                    features: [pointFeature]
                  }),
                  style: new ol.style.Style({
                    image: new ol.style.Icon(/** @type {olx.style.IconOptions} */ ({
                      anchor: [0.52, 31],
                      anchorXUnits: 'fraction',
                      anchorYUnits: 'pixels',
                      opacity: 0.95,
                      src: image_point_src
                    }))
                  })
                });

             map.addLayer(map_layer);

        }
        setTimeout('initialize()',1500);
      </script>

<?php
    }

  }

?>
<div class="rem">

<div id="overDiv" ></div>

<script language="javascript" type="text/javascript">

function review_submitbutton() {
    var form = document.review_house;
    // do field validation
    var rating_checked = false;
    for (c = 0;  c < form.rating.length; c++){
        if (form.rating[c].checked){
            rating_checked = true;
            form.rating.value = c ;
        }
    }
    if (form.title.value == "") {
        alert( "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_REVIEW_TITLE; ?>" );
    } else if (form.comment == "") {
        alert( "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_REVIEW_COMMENT; ?>" );
    } else if (! form.rating.value) {
        alert( "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_REVIEW_RATING; ?>" );
    } else {
        form.submit();
    }
}
//*****************   begin add for show/hiden button "Add review" ********************
function button_hidden( is_hide ) {
    var el = document.getElementById('button_hidden_review');
    var el2 = document.getElementById('hidden_review');
    if(is_hide){
        el.style.display = 'none';
        el2.style.display = 'block';
    } else {
        el.style.display = 'block';
        el2.style.display = 'none';
    }
}

function buying_request_submitbutton() {
    var form = document.buying_request;
    if (form.customer_name.value == "") {
        document.getElementById('customer_name_warning').innerHTML =
         "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_NAME; ?>";
        document.getElementById('customer_name_warning').style.color = "red";
        document.getElementById('alert_name_buy').style.borderColor = "red";
        document.getElementById('alert_name_buy').style.color = "red";
    } else if (form.customer_email.value == ""|| !isValidEmail(form.customer_email.value)) {
        document.getElementById('customer_email_warning').innerHTML =
         "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_EMAIL; ?>";
        document.getElementById('customer_email_warning').style.color = "red";
        document.getElementById('alert_mail_buy').style.borderColor = "red";
        document.getElementById('alert_mail_buy').style.color = "red";
    } else if (!isValidPhoneNumber(form.customer_phone.value)){
        document.getElementById('customer_phone_warning').innerHTML =
         "<?php echo _REALESTATE_MANAGER_REQUEST_PHONE; ?>";
        document.getElementById('customer_phone_warning').style.color = "red";
        document.getElementById('customer_phone').style.borderColor = "red";
        document.getElementById('customer_phone').style.color = "red";
    } else {
        form.submit();
    }
}
function property_request_submitbutton() {
    var form = document.property_request;
    if (form.customer_name.value == "") {
        document.getElementById('customer_name_warning2').innerHTML =
         "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_NAME; ?>";
        document.getElementById('customer_name_warning2').style.color = "red";
        document.getElementById('alert_name2').style.borderColor = "red";
        document.getElementById('alert_name2').style.color = "red";
    } else if (form.customer_email.value == ""|| !isValidEmail(form.customer_email.value)) {
        document.getElementById('customer_email_warning2').innerHTML =
         "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_EMAIL; ?>";
        document.getElementById('customer_email_warning2').style.color = "red";
        document.getElementById('alert_mail2').style.borderColor = "red";
        document.getElementById('alert_mail2').style.color = "red";
    } else if (!isValidPhoneNumber(form.customer_phone.value)){
        document.getElementById('customer_phone_warning2').innerHTML =
         "<?php echo _REALESTATE_MANAGER_REQUEST_PHONE; ?>";
        document.getElementById('customer_phone_warning2').style.color = "red";
        document.getElementById('customer_phone2').style.borderColor = "red";
        document.getElementById('customer_phone2').style.color = "red";
    } else {
        form.submit();
    }
}
function isValidPhoneNumber(str){
    myregexp = new RegExp("^([_0-9() -;,]*)$");
    mymatch = myregexp.exec(str);
    if(str == "")
        return true;
    if(mymatch != null)
        return true;
    return false;
}
function isValidEmail(str){
    myregexp = new RegExp("^([a-zA-Z0-9_-]+\.)*[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)*\.[a-zA-Z]{2,6}$");
    mymatch = myregexp.exec(str);
    if(str == "")
        return false;
    if(mymatch != null)
        return true;
    return false;
}
</script>

<?php

    if ($params->get('show_rentstatus') && $params->get('show_rentrequest')
          && !$params->get('rent_save') && !$params->get('search_request')) {
?>

<!--///////////////////////////////calendar///////////////////////////////////////-->
<script language="javascript" type="text/javascript">

<?php
    $house_id_fordate =  $house->id;
    $date_NA = available_dates($house_id_fordate);
?>

    var by_week = false ;
    <?php if( $house->rent_by == "by_week" ) echo "by_week = true;" ;?> 
    var by_month = false ;
    <?php if( $house->rent_by == "by_month" ) echo "by_month = true;" ;?> 
    var date_from = 0 ;
 
    var unavailableDates = Array();

    jQuerOs(document).ready(function() {
        var k=0;
        <?php if(!empty($date_NA)){?>
            <?php foreach ($date_NA as $N_A){ ?>
                 unavailableDates[k]= '<?php echo $N_A; ?>';
                k++;
            <?php } ?>
        <?php } ?>

        function ajax_rent_calcualete() {
              jQuerOs("#alert_date").html("");

              var rent_from = jQuerOs(" #rent_from ").val();
              var how_many_monthes = 0;
              var how_many_weeks = 0;
              var rent_until = 0;
              if(jQuerOs("#how_many_monthes") && jQuerOs("#how_many_monthes").val() != undefined  ){
                how_many_monthes = jQuerOs(" #how_many_monthes ").val();
              }
              
              if(jQuerOs("#how_many_weeks") && jQuerOs("#how_many_weeks").val() != undefined ){
                how_many_weeks = jQuerOs(" #how_many_weeks ").val();
              }              
              if(jQuerOs("#rent_until") && jQuerOs("#rent_until").val() != undefined ){
                rent_until = jQuerOs(" #rent_until ").val();
              }
              if(how_many_monthes == 0 && how_many_weeks == 0 && rent_until == 0) return;

              jQuerOs.ajax({
                  type: "POST",
                  url: "<?php echo JURI::root();?>index.php?option=com_realestatemanager&task=ajax_rent_calcualete"
                    +"&bid=<?php echo $house->id; ?>&rent_from="+
                    rent_from+"&rent_until="+rent_until+"&how_many_weeks="+how_many_weeks+"&how_many_monthes="+how_many_monthes,
                  data: { " #do " : " #1 " },
                  update: jQuerOs(" #message-here "),
                  success: function( data ) {
                      jQuerOs("#message-here").html(data);
                      jQuerOs("#calculated_price").val(data);
                  }
              });          

        }

        function unavailableFromDay(date) {
          // console.log(":11111111111111:",Object.getOwnPropertyNames(date) );

          //(0+13).slice(-2) => 13; (0+04).slice(-2) => 04  //return two last sings
            dmy = date.getFullYear() + "-" + ('0'+(date.getMonth() + 1)).slice(-2) +
              "-" + ('0'+date.getDate()).slice(-2);
            if (jQuerOs.inArray(dmy, unavailableDates) == -1) {
                return [true, ""];
            } else {
                return [false, "", "Unavailable"];
            }
        }



        jQuerOs( "#rent_from" ).datepicker(
        {
          minDate: "+0",
          firstDay: 1,//fist day by Monday
          dateFormat: "<?php echo transforDateFromPhpToJquery_rm();?>",
          beforeShowDay: unavailableFromDay,
          onClose: function (selectedDate,inst) {
            
            if(selectedDate != "" ) date_from  =  new Date(inst.currentYear, inst.currentMonth, inst.currentDay );

            ajax_rent_calcualete();

          }
        });

    <?php if( $house->rent_by != "by_week" && $house->rent_by != "by_month" ) {  ?> 

        var date_from = 0 ;
        function unavailableUntil(input, inst) {

          if(date_from == 0 ) {
            alert("Please select -rent from- first");
            jQuerOs('#rent_until').datepicker('disable');
            jQuerOs('#rent_until').datepicker('enable');

            return false ;

          }


          var dayornight = "<?php echo $house->rent_by ?>";
          if( dayornight == "by_night" ){
            //rent by night
            //set start date from rent_until not less rent_from +1
            date_from_tmp = new Date(date_from.getFullYear(), date_from.getMonth(), date_from.getDate()+1 );
            jQuerOs('#rent_until').datepicker( "option", "minDate", date_from_tmp ) ;
          }else if( dayornight == "by_day" ){
            //set start date from rent_until not less rent_from 
            date_from_tmp = new Date(date_from.getFullYear(), date_from.getMonth(), date_from.getDate() );
            jQuerOs('#rent_until').datepicker( "option", "minDate", date_from_tmp ) ;

          }          

        }

        function unavailableUntilDay(date) {

          var rent_from = jQuerOs(" #rent_from ").val();

          //(0+13).slice(-2) => 13; (0+04).slice(-2) => 04  //return two last sings
            dmy = date.getFullYear() + "-" + ('0'+(date.getMonth() + 1)).slice(-2) +
              "-" + ('0'+(date.getDate()-("<?php  if( $house->rent_by == "by_night" ) echo '1';?>"))).slice(-2);
            if (jQuerOs.inArray(dmy, unavailableDates) == -1) {
                return [true, ""];
            } else {
                return [false, "", "Unavailable"];
            }
        }

        jQuerOs( "#rent_until" ).datepicker(
        {

          minDate: "+0",
          firstDay: 1,//fist day by Monday
          dateFormat: "<?php echo transforDateFromPhpToJquery_rm();?>",
          beforeShowDay: unavailableUntilDay,
          beforeShow: unavailableUntil,
          onClose: function (selectedDate) {
            ajax_rent_calcualete();
          }
        });


    <?php } else if( $house->rent_by == "by_week" ) {  ?> 
        jQuerOs( "#how_many_weeks" ).change(function(){
          val = parseInt(jQuerOs('#how_many_weeks').val() );
          if(val <= 0 || val > 52  ) val = 1 ;  
          jQuerOs('#how_many_weeks').val( val ); 
          ajax_rent_calcualete();

        });
    <?php } else if( $house->rent_by == "by_month" ) {  ?> 
        jQuerOs( "#how_many_monthes" ).change(function(){
          val = parseInt(jQuerOs('#how_many_monthes').val() );
          if(val <= 0  ||  val > 12 ) val = 1 ;  
          jQuerOs('#how_many_monthes').val( val ) ; 

          ajax_rent_calcualete();
          
        });
    <?php } // ('rent_by month')   ?> 


        jQuerOs('.ui-datepicker').addClass('notranslate'); //fix error with Google ajax(instance) translate

    });

    <!--///////////////////////////////////////////////////////////////////////////-->

    function rem_rent_request_submitbutton() {
        var form = document.rent_request_form;

        if (form.user_name.value == "") {
            document.getElementById('user_name_warning').innerHTML =
             "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_NAME; ?>";
            document.getElementById('user_name_warning').style.color = "red";
            document.getElementById('alert_name').style.borderColor = "red";
            document.getElementById('alert_name').style.color = "red";
        } else if (form.user_email.value == "" || !isValidEmail(form.user_email.value)) {
            document.getElementById('user_email_warning').innerHTML =
             "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_EMAIL; ?>";
            document.getElementById('user_email_warning').style.color = "red";
            document.getElementById('alert_mail').style.borderColor = "red";
            document.getElementById('alert_mail').style.color = "red";
        }

        else if (form.user_phone.value == "" || !isValidPhoneNumber(form.user_phone.value)) {
            document.getElementById('user_phone_warning').innerHTML =
             "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_PHONE; ?>";
            document.getElementById('user_phone_warning').style.color = "red";
            document.getElementById('alert_phone').style.borderColor = "red";
            document.getElementById('alert_phone').style.color = "red";
        } else if (!by_week && !by_month && unavailableDates.indexOf(form.rent_until.value) >= 0
         || unavailableDates.indexOf(form.rent_from.value) >= 0) {


            var datef = form.rent_from.value;
            var dateu = form.rent_until.value;


              // var rent_from = jQuerOs(" #rent_from ").val();
              // var how_many_monthes = 0;
              // var how_many_weeks = 0;
              // var rent_until = 0;
              // if(jQuerOs("#how_many_monthes") && jQuerOs("#how_many_monthes").val() != undefined  ){
              //   how_many_monthes = jQuerOs(" #how_many_monthes ").val();
              // }
              
              // if(jQuerOs("#how_many_weeks") && jQuerOs("#how_many_weeks").val() != undefined ){
              //   how_many_weeks = jQuerOs(" #how_many_weeks ").val();
              // }              
              // if(jQuerOs("#rent_until") && jQuerOs("#rent_until").val() != undefined ){
              //   rent_until = jQuerOs(" #rent_until ").val();
              // }

            var dayornight = "<?php echo $house->rent_by ?>";
            var frep = datef.replace(/\//gi,"-").replace(/\s/gi,"-").replace(/\*/gi,"-");
            var urep = dateu.replace(/\//gi,"-").replace(/\s/gi,"-").replace(/\*/gi,"-");
            var re = /\n*\-\d\d\d\d/;
            var found = urep.match(re);
            if(found){
                var dfrom = (frep.split ('-').reverse ());
                var duntil = (urep.split ('-').reverse ());
            } else {
                var dfrom = (frep.split ('-'));
                var duntil = (urep.split ('-'));
            }

            var dmin=dfrom[0]*10000+dfrom[1]*100+dfrom[2]*1;
            var dmax=duntil[0]*10000+duntil[1]*100+duntil[2]*1;

            document.getElementById('alert_date').innerHTML =
             "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_DATE; ?>";
            document.getElementById('alert_date').style.borderColor = "red";
            document.getElementById('alert_date').style.color = "red";
        } else if(!by_month && !by_month && dmax==dmin && dayornight == "by_night" ) {
             document.getElementById('alert_date').innerHTML =
              "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_ALERT; ?>";
             document.getElementById('alert_date').style.borderColor = "red";
             document.getElementById('alert_date').style.color = "red";
        } else if( form.rent_from.value == "" ) {
             document.getElementById('alert_date').innerHTML =
              "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_DATE; ?>";
             document.getElementById('alert_date').style.borderColor = "red";
             document.getElementById('alert_date').style.color = "red";
        }else {
            form.submit();
        }
    }

</script>

<?php
    }
?>
<script  type="text/javascript" charset="utf-8" async defer>
    jQuerOs(document).ready(function () {
      jQuerOs('input,textarea').focus(function(){
        jQuerOs(this).data('placeholder',jQuerOs(this).attr('placeholder'))
        jQuerOs(this).attr('placeholder','')
        jQuerOs(this).css('color','#a3a3a3');
        jQuerOs(this).css('border-color','#ddd');
      });
      jQuerOs('input,textarea').blur(function(){
        jQuerOs(this).attr('placeholder',jQuerOs(this).data('placeholder'));
      });
    });



    function allreordering(){
        if(document.orderForm.order_direction.value=='asc')
            document.orderForm.order_direction.value='desc';
        else document.orderForm.order_direction.value='asc';

        document.orderForm.submit();
    }

</script>


<?php
     positions_rem($params->get('view01'));
?>
  <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
    <?php
    $is_menu_head_show =  is_menu_item_rem($Itemid)
        && $params->get('show_page_heading') 
        && $params->get('page_heading') 
        && trim($params->get('page_heading')) != "" ;
    if ( $is_menu_head_show ) {  ?>
              <h1><?php echo $params->get('page_heading'); ?></h1>
    <?php } else if (trim($house->htitle)){  ?>
              <h1><?php echo $house->htitle;  ?></h1>                
    <?php } ?>
  </div>

<div class="componentbody<?php echo $params->get('pageclass_sfx'); ?>">

<div class="REL-row">

<?php    
//check exist right part(with contact info) or not
if ($params->get('show_contacts_registrationlevel') ==1 || $params->get('show_owner_registrationlevel') ==1
  || $house->listing_type == 1 && ($params->get('show_rentrequest') && $params->get('show_rentstatus') )
  || $house->listing_type == 2 && ($params->get('show_buystatus') && $params->get('show_buyrequest') )
  || $house->listing_type == 3 && ($params->get('show_property_request_status') && $params->get('show_property_request') )    ) {
?>
  <div class="REL-collumn-xs-12 REL-collumn-sm-8 REL-collumn-md-9 REL-collumn-lg-9">
<?php    
} else {
?>
  <div class="REL-collumn-xs-12">
<?php    

}
?>

<!-- begin gallery -->
<div id="rem_house_galery">

<div class="componentheading<?php echo $params->get('pageclass_sfx'); ?> ">

<?php if (trim($house->htitle) && $is_menu_head_show ) { ?>
                <span class="col_text_2"><h2><?php echo $house->htitle; ?></h2></span>
<?php } ?>
<?php if($params->get('show_pricerequest') && $house->price !== '' && $house->priceunit !== ''){ ?>
    <div class="rem_house_price">
<?php


if(!incorrect_price($house->price)){

    // if ($realestatemanager_configuration['price_unit_show'] == '1') {
    //     if ($params->get('show_sale_separator')) {
    //         echo "<div class=\"pricemoney\">
    //                 <span class=\"money\">"
    //                 . formatMoney($house->price, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']) .
    //                 "</span>";
    //         echo "<span class=\"price\">&nbsp;" . $house->priceunit . "</span></div>";
    //     } else {
    //         echo "<div class=\"pricemoney\"><span class=\"money\">" . $house->price . "</span>";
    //         echo "<span class=\"price\">&nbsp;" . $house->priceunit . "</span></div>";
    //     }
    // } else {
    //     if ($params->get('show_sale_separator')) {
    //         echo "<div class=\"pricemoney\"><span class=\"price\">" . $house->priceunit . "</span>";
    //         echo "&nbsp;<span class=\"money\">"
    //              . formatMoney($house->price, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format'])
    //              . "</span></div>";
    //     } else {
    //         echo "<div class=\"pricemoney\"><span class=\"price\">" . $house->priceunit . "</span>";
    //         echo "&nbsp;<span class=\"money\">" . $house->price . "</span></div>";
    //     }
    // }
    if($currencys_price){
      foreach ($currencys_price as $key => $row) {
        if ($realestatemanager_configuration['price_unit_show'] == '1') {
          if ($params->get('show_sale_separator')) {
            echo "<div class=\"pricemoney\"><span class=\"money\">"
                . formatMoney($row, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']) . "</span>";
            echo "<span class=\"price\">&nbsp;" . $key . "</span></div>";
          } else {
            echo "<div class=\"pricemoney\"><span class=\"money\">" . $row . "</span>";
            echo "<span class=\"price\">&nbsp;" . $key . "</span></div>";
          }
        } else {
          if ($params->get('show_sale_separator')) {
            echo "<div class=\"pricemoney\"><span class=\"price\">" . $key . "</span>";
            echo "&nbsp;<span class=\"money\">"
                . formatMoney($row, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']) .
                "</span></div>";
          } else {
            echo "<div class=\"pricemoney\"><span class=\"price\">" . $key . "</span>";
            echo "&nbsp;<span class=\"money\">" . $row . "</span></div>";
          }
        }
      }
    }

}else{
   echo "<div class=\"pricemoney\"><span class=\"money\">" . $house->price . "</span>";
   echo "&nbsp;<span class=\"money\"></span></div>";
}
    ?>

    </div>
<?php
      } ?>
</div>
<div style="clear:both"></div>
    <div class="button_ppe">

        <span>
      </span>
    </div>

    <div class="rem_house_location">
      <?php if ( trim($house->hcountry) !== '' || trim($house->hregion) !== '' || trim($house->hcity) !== '' || trim($house->hzipcode) !== '' || trim($house->hlocation) !== '' ) { ?>
                <i class="fa fa-map-marker"></i>
    <?php if (isset($house->hcountry) && trim($house->hcountry)) { ?>
                <span class="col_text_2"><?php echo trim($house->hcountry); ?></span>,

<?php     } if (isset($house->hregion) && trim($house->hregion)) { ?>
                <span class="col_text_2"><?php echo trim($house->hregion); ?></span>,

<?php     } if (isset($house->hcity) && trim($house->hcity)) { ?>
                <span class="col_text_2"><?php echo trim($house->hcity); ?></span>,

    <?php } if (isset($house->hzipcode) && trim($house->hzipcode)) { ?>
                <span class="col_text_2"><?php echo trim($house->hzipcode); ?></span>,

    <?php }  if (isset($house->hlocation) && trim($house->hlocation)) { ?>
                <span class="col_02"><?php echo trim($house->hlocation); ?></span>.
    <?php }
      } ?>

    </div>
    <div style="clear:both"></div>

    <span class="col_img">

    <?php
    //for local images
$imageURL = ($house->image_link);
if ($imageURL == '') $imageURL = _REALESTATE_MANAGER_NO_PICTURE_BIG;

     $file_name = rem_picture_thumbnail($imageURL,
        $realestatemanager_configuration['fotomain']['width'],
        $realestatemanager_configuration['fotomain']['high'], $watermark);

     //$file_name = $imageURL;
    $file = JURI::root() . 'components/com_realestatemanager/photos/' . $file_name;
echo '<div style="position:relative">';
if($realestatemanager_configuration['show_house_slider']=='1') {
  $stdClassImage = new stdClass();
  $stdClassImage->main_img = $imageURL;
  // $house_photos[] = $stdClassImage;

  array_unshift($house_photos, $stdClassImage);

  if(count($house_photos) > 0) { ?>
      <div class="swiper-container">
        <div class="swiper-wrapper">
    <?php for ($i = 0; $i < count($house_photos); $i++) { ?>
          <div class="swiper-slide">

          <?php
          if ($house->listing_type){
            if ($house->listing_type == 2){
              echo '<div class="rem_col_sale view_veh" >'._REALESTATE_MANAGER_OPTION_FOR_SALE.'</div>';
            } else if ($house->listing_type == 3){
              echo '<div class="rem_col_sale view_veh" >'._REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST.'</div>';
            } else if ($house->listing_type == 1){
              echo '<div class="rem_col_rent view_veh">'._REALESTATE_MANAGER_OPTION_FOR_RENT.'</div>';
            }
          }

          if ($house->listing_status){
            if ($house->listing_status != 0){
              $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);

              $ls = 1;
              foreach ($listing_status1 as $listing_status2) {
                  $listing_status[$ls] = $listing_status2;
                  $ls++;
              }

              echo '<div class="rem_listing_status view_veh">'.$listing_status[$house->listing_status].'</div>';
            }
          }

        ?>

        <?php
        $house_photos[$i]->main_img = str_ireplace('watermark/', '', $house_photos[$i]->main_img);

          $file_name = rem_picture_thumbnail( $house_photos[$i]->main_img, $realestatemanager_configuration['fotomain']['width'], $realestatemanager_configuration['fotomain']['high'], $watermark );
            $img_path = JURI::root() . 'components/com_realestatemanager/photos/';
            $href = JURI::root() . 'components/com_realestatemanager/photos/' . $house_photos[$i]->main_img;

         ?>

            <a href="<?php echo $href; ?>" data-os_fancybox="slider" class="rem_fancybox" title="photo">
            <img alt="<?php echo $house->htitle; ?>" title="<?php echo $house->htitle; ?>" src="<?php echo $img_path; ?><?php echo $file_name; ?>" />
          </a>
          </div><!--end div class="swiper-slide"-->
<?php } ?>
      </div><!--end div class="swiper-wrapper"-->
      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
    </div><!--end div class="swiper-container"-->
<?php
  }
}
else {
            echo '<div class="swiper-slide">';
          if ($house->listing_type){
            if ($house->listing_type == 2){
              echo '<div class="rem_col_sale view_veh" >'._REALESTATE_MANAGER_OPTION_FOR_SALE.'</div>';
            } else if ($house->listing_type == 3){
              echo '<div class="rem_col_sale view_veh" >'._REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST.'</div>';
            } else if ($house->listing_type == 1){
              echo '<div class="rem_col_rent view_veh">'._REALESTATE_MANAGER_OPTION_FOR_RENT.'</div>';
            }
          }

          if ($house->listing_status){
            if ($house->listing_status != 0){
              $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);

              $ls = 1;
              foreach ($listing_status1 as $listing_status2) {
                  $listing_status[$ls] = $listing_status2;
                  $ls++;
              }

              echo '<div class="rem_listing_status view_veh">'.$listing_status[$house->listing_status].'</div>';
            }
          }
          $href = JURI::root() . 'components/com_realestatemanager/photos/' . $imageURL;

          echo '<a  href="'.$href.'" data-os_fancybox="gallery"><img alt="' . $house->htitle . '" title="' . $house->htitle . '" src="' . $file . '"  ></a>';

          echo '</div>';
}
?>

    </div>
    </span>

    <div class="table_gallery table_07">
<?php if (count($house_photos) > 0) { ?>
    <div class="gallery_img">
    <?php for ($i = 0;$i < count($house_photos);$i++) { ?>
        <div class="thumbnail viewHouses"
              style="width: <?php echo $realestatemanager_configuration['fotogal']['width'];?>px; height: <?php
              echo $realestatemanager_configuration['fotogal']['high'];?>px;" >

         <?php $house_photos[$i]->main_img = str_ireplace('watermark/', '', $house_photos[$i]->main_img) ;

            $img_path = JURI::root() . 'components/com_realestatemanager/photos/';
            $watermark_img_file_path = JPATH_SITE . '/components/com_realestatemanager/photos/watermark/watermark_img.png';
            $watermark_text_file_path = JPATH_SITE . '/components/com_realestatemanager/photos/watermark/watermark.png';
            if( $watermark && ( (file_exists($watermark_img_file_path)) || (file_exists($watermark_text_file_path)) ) ) {
                  $href = JURI::root() . 'components/com_realestatemanager/photos/watermark/' . $house_photos[$i]->main_img;
              } else {
                  $href = JURI::root() . 'components/com_realestatemanager/photos/' . $house_photos[$i]->main_img;
              }

         ?>

              <a href="<?php echo $href; ?>" data-os_fancybox="gallery" title="photo" >
               <img alt="<?php echo $house->htitle; ?>" title="<?php echo $house->htitle; ?>"
               src="<?php echo JURI::root(); ?>components/com_realestatemanager/photos/<?php
               echo rem_picture_thumbnail($house_photos[$i]->main_img,
               $realestatemanager_configuration['fotogal']['width'],
               $realestatemanager_configuration['fotogal']['high'], $watermark); ?>" style = "vertical-align:middle;" />
              </a>
          </div>
           <?php
    }
    ?>
            </div>
    <?php }
?>
    </div>
</div>
<!--<form action="<?php //echo sefRelToAbs($form_action);
?>" method="post" name="house">-->
        <?php positions_rem($params->get('view02')); ?>

        <div id="rem_house_property">
                 <?php
            $listing_status[0] = _REALESTATE_MANAGER_OPTION_SELECT;
            $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
            $i = 1;
            foreach ($listing_status1 as $listing_status2) {
                $listing_status[$i] = $listing_status2;
                $i++;
            }
            if ($house->listing_status != 0) {
                ?>
                <div class="row_text">
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_LISTING_STATUS; ?>:</span>
                    <span class="col_text_2"><?php echo $listing_status[$house->listing_status]; ?></span>
                </div>
                        <?php
                    }
            ?>

            <?php
            $property_type[0] = _REALESTATE_MANAGER_OPTION_SELECT;
            $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
            $i = 1;
            foreach ($property_type1 as $property_type2) {
                $property_type[$i] = $property_type2;
                $i++;
            }
            if ($house->property_type != 0) {
                ?>
                <div class="row_text">
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_PROPERTY_TYPE; ?>:</span>
                    <span class="col_text_2"><?php echo $property_type[$house->property_type]; ?></span>
                </div>
                <?php
            }
                ?>

                <?php if (trim($house->houseid)) { ?>
                <div class="row_text">
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_PROPERTYID; ?>:</span>
                    <span class="col_text_2"><?php echo $house->houseid; ?></span>
                </div>
                <?php
                }
                ?>
                <?php
                $listing_type[0] = _REALESTATE_MANAGER_OPTION_SELECT;
                $listing_type[1] = _REALESTATE_MANAGER_OPTION_FOR_RENT;
                $listing_type[2] = _REALESTATE_MANAGER_OPTION_FOR_SALE;
                $listing_type[3] = _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST;
                if ($house->listing_type != 0) {
                    ?>
                <div class="row_text">
                <span class="col_text_icon"></span>
                <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_LISTING_TYPE; ?>:</span>
                <span class="col_02"><?php echo $listing_type[$house->listing_type]; ?></span>
                </div>
                <?php
            }
            ?>
            <?php if ($realestatemanager_configuration['extra1'] == 1 && $house->extra1 != "") {
            ?>
            <div class="row_text">
                <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA1_SHOW; ?>:</span>
                <span class="col_text_2"><?php echo $house->extra1; ?></span>
            </div>
                <?php
            }
            if ($realestatemanager_configuration['extra2'] == 1 && $house->extra2 != "") {
                ?>
            <div class="row_text">
                <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA2_SHOW; ?>:</span>
                <span class="col_text_2"><?php echo $house->extra2; ?></span>
            </div>
                <?php
            }
            if ($realestatemanager_configuration['extra3'] == 1 && $house->extra3 != "") {
                ?>
            <div class="row_text">
                <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA3_SHOW; ?>:</span>
                <span class="col_text_2"><?php echo $house->extra3; ?></span>
            </div>
            <?php
            }
            if ($realestatemanager_configuration['extra4'] == 1 && $house->extra4 != "") {
                ?>
                        <div class="row_text">
                            <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA4_SHOW; ?>:</span>
                            <span class="col_text_2"><?php echo $house->extra4; ?></span>
                        </div>
                            <?php
                        }
                        if ($realestatemanager_configuration['extra5'] == 1 && $house->extra5 != "") {
                            ?>
                        <div class="row_text">
                            <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA5_SHOW; ?>:</span>
                            <span class="col_text_2"><?php echo $house->extra5; ?></span>
                        </div>
            <?php
            }
            if ($realestatemanager_configuration['extra6'] == 1 && $house->extra6 > 0) {
                $extra1 = explode(',', _REALESTATE_MANAGER_EXTRA6_SELECTLIST);
                $i = 1;
                foreach ($extra1 as $extra2) {
                    $extra[$i] = $extra2;
                    $i++;
                }
                ?>
                        <div class="row_text">
                            <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA6_SHOW; ?>:</span>
                            <span class="col_text_2"><?php echo $extra[$house->extra6]; ?></span>
                        </div>
            <?php
            }
            if ($realestatemanager_configuration['extra7'] == 1 && $house->extra7 > 0) {
                $extra1 = explode(',', _REALESTATE_MANAGER_EXTRA7_SELECTLIST);
                $i = 1;
                foreach ($extra1 as $extra2) {
                    $extra[$i] = $extra2;
                    $i++;
                }
                ?>
                        <div class="row_text">
                            <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA7_SHOW; ?>:</span>
                            <span class="col_text_2"><?php echo $extra[$house->extra7]; ?></span>
                        </div>
            <?php
            }
            if ($realestatemanager_configuration['extra8'] == 1 && $house->extra8 > 0) {
                $extra1 = explode(',', _REALESTATE_MANAGER_EXTRA8_SELECTLIST);
                $i = 1;
                foreach ($extra1 as $extra2) {
                    $extra[$i] = $extra2;
                    $i++;
                }
                ?>
                        <div class="row_text">
                            <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA8_SHOW; ?>:</span>
                            <span class="col_text_2"><?php echo $extra[$house->extra8]; ?></span>
                        </div>
            <?php
            }
            if ($realestatemanager_configuration['extra9'] == 1 && $house->extra9 > 0) {
                $extra1 = explode(',', _REALESTATE_MANAGER_EXTRA9_SELECTLIST);
                $i = 1;
                foreach ($extra1 as $extra2) {
                    $extra[$i] = $extra2;
                    $i++;
                }
                ?>
                <div class="row_text">
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA9_SHOW; ?>:</span>
                    <span class="col_text_2"><?php echo $extra[$house->extra9]; ?></span>
                </div>
                <?php
            }
            if ($realestatemanager_configuration['extra10'] == 1 && $house->extra10 > 0) {
                $extra1 = explode(',', _REALESTATE_MANAGER_EXTRA10_SELECTLIST);
                $i = 1;
                foreach ($extra1 as $extra2) {
                    $extra[$i] = $extra2;
                    $i++;
                }
                ?>
                <div class="row_text">
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA10_SHOW; ?>:</span>
                    <span class="col_text_2"><?php echo $extra[$house->extra10]; ?></span>
                </div>
                <?php }
            ?>
        <!--add edocument -->
        <?php
        if ($params->get('show_edocsrequest') && $house->edok_link != null) {
            $session = JFactory::getSession();
            $sid = $session->getId();
            $session->set("ssmid", $sid);
            setcookie('ssd', $sid, time() + 60 * 60 * 24, "/");
            ?>
            <div class="row_text">
                <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_EDOCUMENT; ?>:</span>
                <span class="col_text_2">
                    <a href="<?php
                    echo sefRelToAbs('index.php?option=com_realestatemanager&amp;task=mdownload&amp;id='
                       . $house->id . '&amp;Itemid=' . $Itemid); ?>" target="blank">
            <?php echo _REALESTATE_MANAGER_LABEL_EDOCUMENT_DOWNLOAD; ?>
                    </a>
                </span>
            </div>
    <?php
} //end if
?>
        </div>
        <?php
        if($realestatemanager_configuration['energy_field_show']) {
          $result = $params->get('diagramma');
          if($result){ ?>
        <!-- <div class="diagramm"> -->
        <div class="diagramm">
          <?php echo $params->get('diagramma'); ?>
        </div>
      <?php
        }
      }
      ?>
<div class="tabs_buttons">
    <!--list of the tabs-->
    <ul id="countrytabs" class="shadetabs">
        <li>
            <a href="#" rel="country1" class="selected"><?php echo _REALESTATE_MANAGER_TAB_DESCRIPTION; ?>
            </a>
        </li>
        <?php
        if (($params->get('show_location') && $params->get('show_locationtab_registrationlevel'))
            || ($params->get('street_view') && $params->get('street_view_registrationlevel'))) {
            ?>
            <li>
              <a href="#" rel="country2" onmouseup="setTimeout('initialize()',10)">
                  <?php echo _REALESTATE_MANAGER_TAB_LOCATION; ?>
              </a>
            </li>
            <?php
        }
        ?>
        <?php
        if ($params->get('show_reviews_tab')) {
          if ($params->get('show_reviewstab_registrationlevel')) {
            ?>
            <li>
              <a href="#" rel="country4"><?php echo _REALESTATE_MANAGER_TAB_REVIEWS; ?></a>
            </li>
            <?php
          }
        }
        ?>
        <?php

//https://www.greatschools.org/widget/map?searchQuery=&amp;textColor=000000&amp;borderColor=FFFFFFF&amp;lat=37.8424&amp;lon=-122.273625&amp;cityName=OAKLAND&amp;state=CA&amp;normalizedAddress=894+Arlington+Ave%2C+OAKLAND%2C+CA+94608&amp;zoom=14&amp;width=838&amp;height=600
        $normalized_address = "";
        if (isset($house->hlocation) && trim($house->hlocation))
          $normalized_address = $house->hlocation;

        if (isset($house->hcity) && trim($house->hcity) && $normalized_address != ''){
           $normalized_address .= " ". $house->hcity;
        } else if (isset($house->hcity) && trim($house->hcity)){
           $normalized_address .= $house->hcity;
        }  

        if (isset($house->hregion) && trim($house->hregion) && $normalized_address != ''){
           $normalized_address .= " ". $house->hregion;
        } else if (isset($house->hregion) && trim($house->hregion) ){
           $normalized_address .=  $house->hregion;
        }  

        if (isset($house->hcountry) && trim($house->hcountry) && $normalized_address != ''){
           $normalized_address .= " ". $house->hcountry;
        } else if (isset($house->hcountry) && trim($house->hcountry) ){
           $normalized_address .=  $house->hcountry;
        }  

        if (isset($house->hzipcode) && trim($house->hzipcode) && $normalized_address != ''){
           $normalized_address .= " ". $house->hzipcode;
        } else if (isset($house->hzipcode) && trim($house->hzipcode) ){
           $normalized_address .=  $house->hzipcode;
        }  


        $request_address = "";
        if ($house->hlatitude && $house->hlatitude != '')
          $request_address = "lat=". $house->hlatitude;

        if ($house->hlongitude && $house->hlongitude != '' && $house->hlatitude != '')
          $request_address .= "&lon=". $house->hlongitude;

        if (isset($house->hcity) && trim($house->hcity) && $request_address != ''){
           $request_address .= "&cityName=". $house->hcity;
        } else if (isset($house->hcity) && trim($house->hcity) && $request_address == ''){
           $request_address .= "cityName=". $house->hcity;
        }  

        if (isset($house->hcountry) && trim($house->hcountry) && $request_address != ''){
           $request_address .= "&state=". $house->hregion;
        } else if (isset($house->hcountry) && trim($house->hcountry) && $request_address == ''){
           $request_address .= "state=". $house->hcountry;
        }  

        if( $normalized_address != "" && $request_address != ''){
           $request_address .= "&normalizedAddress=". urlencode($normalized_address);
           //$normalized_address = urlencode($normalized_address);
        } else if ( $normalized_address != "" && $request_address == ''){
           $request_address .= "normalizedAddress=". urlencode($normalized_address);
           //$normalized_address = urlencode($normalized_address);
        }  



        if ($params->get('greatschools_registrationlevel','') && $request_address != "" ) {
            ?>
            <li>
                <a href="#" rel="country5"><?php echo _REALESTATE_MANAGER_LABEL_GREATSCHOOLS; ?></a>
            </li>
            <?php
        }
        ?>
        <?php
        if ($params->get('walkscore_registrationlevel','') && $normalized_address != "" ) {
            ?>
            <li>
                <a href="#" rel="country6"><?php echo _REALESTATE_MANAGER_LABEL_WALKSCORE; ?></a>
            </li>
            <?php
        }
        ?>        
        <?php
        if ($params->get('calendarlist_show') && $house->listing_type == 1) {
            if ($params->get('calendarlist_registrationlevel','')) {
                ?>
                <li>
                    <a href="#" rel="country7"><?php echo _REALESTATE_MANAGER_LABEL_CALENDAR_CALENDAR; ?></a>
                </li>
                <?php
            }
        }
        ?>        
        <?php
        if ($params->get('additional_tab_show') ) {
            if ($params->get('additional_tab_registrationlevel','')) {
                ?>
                <li>
                    <a href="#" rel="country8"><?php echo _REALESTATE_MANAGER_LABEL_ADDITIONAL_TAB; ?></a>
                </li>
                <?php
            }
        }
        ?>        
    </ul>
</div>
                <?php positions_rem($params->get('view03')); ?>

<!--begin tabs-->
<div id="tabs">
    <div id="country1" class="tabcontent">
        <div class="rem_type_house">
            <?php if (isset($house->rooms) && trim($house->rooms)) { ?>
                <div class="row_text">
                    <i class="fa fa-building"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_ROOMS; ?>:</span>
                    <span class="col_text_2"><?php echo $house->rooms; ?></span>
                </div>
            <?php } if (isset($house->bathrooms) && trim($house->bathrooms)) { ?>
                <div class="row_text">
                    <i class="fa fa-tint"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BATHROOMS; ?>:</span>
                    <span class="col_text_2"><?php echo $house->bathrooms; ?></span>
                </div>
            <?php } if (isset($house->bedrooms) && trim($house->bedrooms)) { ?>
                <div class="row_text">
                    <i class="fa fa-inbox"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BEDROOMS; ?>:</span>
                    <span class="col_text_2"><?php echo $house->bedrooms; ?></span>
                </div>
                        <?php
                    }
            ?>
            <?php if (isset($house->year) && trim($house->year)) { ?>
                <div class="row_text">
                    <i class="fa fa-calendar"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?>:</span>
                    <span class="col_text_2"><?php echo $house->year; ?></span>
                </div>
                <?php }   ?>
            <?php if (isset($house->garages) && trim($house->garages)) { ?>
                <div class="row_text">
                    <i class="fa fa-truck"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_GARAGES; ?>:</span>
                    <span class="col_text_2"><?php echo $house->garages; ?></span>
                </div>
                        <?php }
            if (isset($house->lot_size) && trim($house->lot_size)) {
                ?>
                <div class="row_text">
                    <i class="fa fa-arrows-alt"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_LOT_SIZE; ?>:</span>
                    <span class="col_text_2">
                        <?php echo $house->lot_size; ?> <?php echo _REALESTATE_MANAGER_LABEL_SIZE_SUFFIX_AR; ?>
                    </span>
                </div>
                <?php }
            if (isset($house->house_size) && trim($house->house_size)) {
                ?>
                <div class="row_text">
                    <i class="fa fa-expand"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_HOUSE_SIZE; ?>:</span>
                    <span class="col_text_2">
                        <?php echo $house->house_size; ?> <?php echo _REALESTATE_MANAGER_LABEL_SIZE_SUFFIX; ?>
                    </span>
                </div>
                <?php }
////////////////////////////////////START show video\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
                      if (!empty($videos)) {
                        $youtubeCode = "";
                        $videoSrc = array();
                        $videoSrcHttp = "";
                        $videoType = array();
                        foreach($videos as $video) {
                            if ($video->youtube) {
                              $youtubeCode = $video->youtube;
                            } else if ($video->src) {
                              $videoSrc[] = $video->src;
                              if($video->type)
                                $videoType[] = $video->type;
                            }
                        }?>
                        <div class="row_06">
                          <span class="realestate_video">
                            <strong class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_VIDEO; ?>:</strong>
                        <?php
                        if (!empty($youtubeCode)) { ?>
                          <iframe width="420" height="315" frameborder="0"
                            src="//www.youtube.com/embed/<?php echo $youtubeCode ?>"></iframe>
                          <?php
                        } else if (!empty($videoSrc) && empty($youtubeCode)) { ?>
                          <video width="320" height="240" controls>
                            <?php
                            for ($i = 0;$i < count($videoSrc);$i++) {
                              if(!strstr($videoSrc[$i], "http") && $videoType) {
                              echo '<source src="' . JURI::root() . $videoSrc[$i] .'"'.
                                    ' type="' . $videoType[$i] .'">';
                              }else{
                               echo '<source src="' . $videoSrc[$i] .'"'.
                                    ' type="' . $videoType[$i] .'">';
                             }
                            }
                            if (!empty($tracks)) {
                              for ($i = 0;$i < count($tracks);$i++) {
                                ($i==0)?$default='default="default"':$default='';
                                if (!strstr($tracks[$i]->src, "http")) {
                                  echo '<track src="' . JURI::root() .$tracks[$i]->src . '"'.
                                      ' kind="' . $tracks[$i]->kind .'"'.
                                      ' srclang="' . $tracks[$i]->scrlang .'"'.
                                      ' label="' . $tracks[$i]->label . '" '.$default.'>';
                                }else{
                                  echo '<track src="' .$src . '"'.
                                      ' kind="' . $tracks[$i]->kind .'"'.
                                      ' srclang="' . $tracks[$i]->scrlang .'"'.
                                      ' label="'.$tracks[$i]->label.'" '.$default.'>';
                                }
                              }
                            } ?>
                          </video>
                            </span>

                        <?php
                      } ?>
                      </div>
                      <?php
                    }
////////////////////////////////////END show video\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
            
            if (isset($house->description) && trim($house->description)) {
            ?>
                    <div class="rem_house_desciption"><?php positions_rem($house->description); ?></div>
            <?php
            }
            ?>

            <?php
            if ($realestatemanager_configuration['extra11'] == 1 && isset($house->extra11) && trim($house->extra11)) {
            ?>
                  <div class="rem_house_desciption">
                    <span><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA11_SHOW; ?></span>
                    <?php print_r($house->extra11); ?>
                  </div>
                <?php
            }
            ?>
            <?php
            if ($realestatemanager_configuration['extra12'] == 1 && isset($house->extra12) && trim($house->extra12)) {
            ?>
                  <div class="rem_house_desciption">
                    <span><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA12_SHOW; ?></span>
                    <?php print_r($house->extra12); ?>
                  </div>
                <?php
            }
            ?>
            <?php
            if ($realestatemanager_configuration['extra13'] == 1 && isset($house->extra13) && trim($house->extra13)) {
            ?>
                  <div class="rem_house_desciption">
                    <span><?php echo _REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA13_SHOW; ?></span>
                    <?php print_r($house->extra13); ?>
                  </div>
                <?php
            }
            ?>            
        </div>



<div class="table_tab_01 table_03">

    <!--       *******************************************************************         -->
    <?php

if($realestatemanager_configuration['special_price']['show']){
   
    global $database, $realestatemanager_configuration;
    if($house->rent_by == "by_day" ){
        $switchTranslateDayNight = _REALESTATE_MANAGER_RENT_SPECIAL_PRICE_PER_DAY;
    }else{
        $switchTranslateDayNight = _REALESTATE_MANAGER_RENT_SPECIAL_PRICE_PER_NIGHT;
    }
    if( $house->listing_type != 1 )  $switchTranslateDayNight = _REALESTATE_MANAGER_LABEL_PRICE;
    $query = "select * from #__rem_rent_sal WHERE fk_houseid='$house->id'";
    $database->setQuery($query);
    $rentTerm = $database->loadObjectList();
        if(isset($rentTerm[0]->special_price)) { ?>
            <div class = "row_17">
            <span class="col_01"><?php echo _REALESTATE_MANAGER_RENT_SPECIAL_PRICE; ?>:</span> <br />

                <table class="adminlist adminlist_04">
                    <tr>
                        <th class="title" width = "15%" align ='center' ><?php
                          echo _REALESTATE_MANAGER_FROM; ?></th>
                        <th class="title" width = "15%" align ='center' ><?php
                          echo _REALESTATE_MANAGER_TO; ?></th>
                        <th class="title" width = "15%" align ='center'><?php
                          echo $switchTranslateDayNight; ?></th>
                        <th class="title" width = "20%" align ='center' ><?php
                          echo _REALESTATE_MANAGER_LABEL_REVIEW_COMMENT; ?></th>
                    </tr>
                    <?php
                        $DateToFormat = str_replace("D",'d',
                          (str_replace("M",'m',(str_replace('%','',
                          $realestatemanager_configuration['date_format'])))));
                        for ($i = 0; $i < count($rentTerm); $i++) {
                        $date_from = new DateTime($rentTerm[$i]->price_from);
                        $date_to = new DateTime($rentTerm[$i]->price_to);
                    ?>
                    <tr>
                        <td align ='center'><?php echo date_format($date_from, "$DateToFormat"); ?></td>
                        <td align ='center'><?php echo date_format($date_to, "$DateToFormat"); ?></td>
                        <?php
                                if ($realestatemanager_configuration['sale_separator'] == '1') { ?>
                                    <td align ='center'><?php
                                      echo formatMoney($rentTerm[$i]->special_price, $realestatemanager_configuration['sale_fraction'],
                                         $realestatemanager_configuration['price_format']); ?></td>
                        <?php   } else { ?>
                                    <td align ='center'><?php echo $rentTerm[$i]->special_price; ?></td>
                        <?php   }
                            ?>

                        <td align ='center'><?php echo $rentTerm[$i]->comment_price; ?></td>
                    </tr>
                    <?php } ?>
                </table>
            </div>
<?php   } 
}//if($realestatemanager_configuration['special_price']['show']){

?>
<!--       *******************************************************************         -->
  <?php if (count($house_feature)) { ?>
    <div class="table_country3 ">
      <h4>
        <div class="rem_features_title">
          <?php echo _REALESTATE_MANAGER_LABEL_FEATURED_MANAGER_FEATURE; ?>
        </div>
      </h4>
      <div class="row_text">
        <span class="col_text_2">
          <?php
          for ($i = 0; $i < count($house_feature); $i++) {
            if($realestatemanager_configuration['manager_feature_category'] == 1) {
              if ($i != 0) {
                if ($house_feature[$i]->categories !== $house_feature[$i - 1]->categories)
                  echo "<div class='rem_features_category'>" .
                  constant('_REALESTATE_MANAGER_FEATURE_CATEGORY_'.trim($house_feature[$i]->categories) ) . ": </div>";
                }
                else {
                  echo "<div class='rem_features_category'>" .
                  constant('_REALESTATE_MANAGER_FEATURE_CATEGORY_'. trim($house_feature[$i]->categories) ) . ": </div>";
              }
            }
              echo "<span class='rem_features_name'><i class='fa fa-check rem_fa'></i>";
              echo constant('_REALESTATE_MANAGER_FEATURE'.$house_feature[$i]->id) . "</span>";
            } ?>
        </span>
      </div>
    </div>
  <?php
  } ?>

     </div>
    </div><!--end of tab-->


<div id="country2" class="tabcontent">
        <!--if we are given the coordinates, then display latitude, longitude and a map with a marker -->
<?php if ($house->hlatitude && $house->hlongitude) {?>
          <div class="table_latitude table_04">
            <?php
            if(($params->get('show_location') && $params->get('show_locationtab_registrationlevel'))){ ?>
              <div id="map_canvas" class="re_map_canvas re_map_canvas_02"></div>
            <?php
            }
            if($params->get('street_view') && $params->get('street_view_registrationlevel')){ ?>
              <div id="map_pano" class="re_map_canvas re_map_canvas_02"></div>
              <?php
            } ?>
          </div>
          <?php
      } else
        echo _REALESTATE_MANAGER_LABEL_NO_LOCATION_AVAILIBLE;
        ?>
    </div>
   <!--tab for reviews-->
    <div id="country4" class="tabcontent">
<?php
//show the reviews
    if ($reviews = $house->getReviews()) {
        ?>
        <br />
        <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
            <?php echo _REALESTATE_MANAGER_LABEL_REVIEWS; ?>
        </div>

        <div class="reviews_table table_06">
            <?php
            if ($reviews != null && count($reviews) > 0) {
                for ($m = 0, $n = count($reviews); $m < $n; $m++) {
                    $review = $reviews[$m];
                    if ($review->published != 0) {
                        ?>
                        <div class="box_comment">
                            <div class="user_name"><?php echo $review->user_name; ?></div>
                            <span class="arrow_up_comment"></span>
                            <div class="head_comment">
                                <div class="title_rating">
                                    <h4 class="col_title_rev"><?php echo $review->title; ?></h4>
                                    <span class="col_rating_rev">
                                        <img src="<?php echo JURI::root(); ?>components/com_realestatemanager/images/rating-<?php
                                             echo $review->rating; ?>.png"
                                             alt="<?php echo ($review->rating) / 2; ?>" border="0" align="right"/>
                                    </span>
                                </div>
                                <div class="row_comment">
                                    <?php echo $review->comment; ?>
                                </div>
                                <div class="date">
                                    <span class="date_format">
                                        <?php echo date_transform_rem($review->date); ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
            }
            ?>
        </div>

        <?php
    } else{
      echo "<p>"._REALESTATE_MANAGER_NO_REVIEWS_FOR_HOUSE."</p>";
    }

if ($params->get('show_reviews')) {
    $reviews = $house->getReviews();
    ?><?php
    if ($params->get('show_inputreviews')) {
        ?><?php positions_rem($params->get('view07')); ?><div id="hidden_review">
            <form action="<?php echo sefRelToAbs("index.php?option="
                 . $option . "&amp;task=review_house&amp;Itemid=" .
                   $Itemid); ?>" method="post" name="review_house">
                <input type="hidden" name="user_name" value="<?php echo $my->username ?>">
                <input type="hidden" name="fk_userid" value="<?php echo $my->id ?>">
                <input type="hidden" name="user_email" value="<?php echo $my->email ?>">
                <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
                    <hr />
                    <?php echo _REALESTATE_MANAGER_LABEL_ADDREVIEW; ?>
                </div>

                <div class="add_table_review table_09">
                    <div class="row_01"><?php echo _REALESTATE_MANAGER_LABEL_REVIEW_TITLE; ?></div>
                    <div class="row_02">
                        <input class="inputbox" type="text" name="title" size="80"
                        value="<?php if (isset($_REQUEST["title"])) {
                        echo $_REQUEST["title"]; } ?>" />
                    </div>
                    <div class="row_03"><?php echo _REALESTATE_MANAGER_LABEL_REVIEW_COMMENT; ?></div>
                    <div class="row_04">
                            <?php
                            $comm_val = "";
                            if (isset($_REQUEST["comment"])) {
                                $comm_val = protectInjectionWithoutQuote("comment",'','STRING');
                            }
                            //editorArea( 'editor1',  $comm_val, 'comment', '410', '200', '60', '10' );
                            ?>
                        <textarea name="comment" cols="50" rows="8" ><?php echo $comm_val; ?></textarea>
                    </div>

                    <!-- #### RATING #### -->
                    <?php if (version_compare(JVERSION, "3.0", "ge")): ?>
                    <script type="text/javascript">
                        os_img_path = '<?php echo JURI::root() . 'components/com_realestatemanager/images/'; ?>' ;
                        jQuerOs(document).ready(function(){
                            jQuerOs('#star').raty({
                                starHalf: os_img_path+'star-half.png',
                                starOff: os_img_path+'star-off.png',
                                starOn: os_img_path+'star-on.png'
                            });
                        });
                    </script>

                        <div class="row_rating_j3">
                            <span class="lable_rating"><?php echo _REALESTATE_MANAGER_LABEL_REVIEW_RATING; ?></span>
                            <span id="star"></span>
                        </div>

                            <?php else:
                            ?>
                        <div class="row_rating_j2">
                            <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_REVIEW_RATING; ?></span>
                            <br />
                            <span>
                            <?php
                            $k = 0;
                            while ($k < 11) {
                                ?>
                            <input type="radio" name="rating" value="<?php echo $k; ?>" <?php
                            if (isset($_REQUEST["rating"]) && $_REQUEST["rating"] == $k) {
                                echo "CHECKED";
                            }
                            ?> alt="Rating" />
                            <img src="<?php echo JURI::root(); ?>components/com_realestatemanager/images/rating-<?php echo $k; ?>.png"
                              alt="<?php echo ($k) / 2; ?>" border="0" /><br />
                                <?php
                                $k++;
                            }
                            ?>
                            </span>
                        </div>

                        <?php endif; ?>

<!--*************************   begin add antispam guest   ********************-->
<?php
if ($params->get('captcha_option')) {
  if ($params->get('captcha_option_registrationlevel')) {
?>
<?php
?>
            <div  class="row_capcha">
<!--*************************   begin insetr image   **********************-->
<?php HTML_realestatemanager::showCaptchaRealestate("review"); ?>
<!--******************** end insert image *******************************-->
            </div><!--end div class="row_capcha"-->
  <?php
  }
}
?>
            <!--****************************   end add antispam guest   ******************************-->
            <div  class="row_button_review">
                <span class="button_save">
                    <!-- save review button-->
                    <input class="button" type="button" value="<?php
                      echo _REALESTATE_MANAGER_LABEL_BUTTON_SAVE; ?>" onclick="review_submitbutton()"/>
                </span>
            </div>

        </div>

        <input type="hidden" name="fk_houseid" value="<?php echo $house->id; ?>" />
        <input type="hidden" name="catid" value="<?php $temp = $house->catid;
        echo $temp[0]; ?>" />
            </form>
        </div>
        <!-- end <div id="hidden_review"> -->
        <?php
    } //end if($params->get('show_inputreviews'))
} // end if( $params->get('show_reviews'))
?>
    </div>
<?php
/////////////////////////////////////////////START greatschools\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
  if ( $params->get('greatschools_registrationlevel') && $request_address != "" ) {
    //https://www.greatschools.org/widget/map?searchQuery=&amp;textColor=000000&amp;borderColor=FFFFFFF&amp;lat=37.8424&amp;lon=-122.273625&amp;cityName=OAKLAND&amp;state=CA&amp;normalizedAddress=894+Arlington+Ave%2C+OAKLAND%2C+CA+94608&amp;zoom=14&amp;width=838&amp;height=600
    
//$request_address = "lat=37.8424&amp;lon=-122.273625&amp;cityName=OAKLAND&amp;state=CA&amp;normalizedAddress=894+Arlington+Ave%2C+OAKLAND%2C+CA+94608"
?>
<style>
iframe {
  height: 500px;
  width: 100%;
  resize: both;
  overflow: auto;
}  
</style>
    <div id="country5" class="tabcontent">
      <div style="text-align: center;" >
        <h4><?php echo _REALESTATE_MANAGER_LABEL_GREATSCHOOLS_TITLE; ?></h4>
        <div class="rem_tableC basictable">
          <iframe src="https://www.greatschools.org/widget/map?searchQuery=&amp;textColor=000000&amp;borderColor=FFFFFFF&amp;zoom=13&amp;width=538&amp;height=500&amp;<?php echo $request_address; ?>  " width="100%" height="500" frameborder="0" scrolling="no" class="greatschools"></iframe>        
        </div>
      </div>
    </div>
    <?php
  }
/////////////////////////////////////////////END greatschools\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

/////////////////////////////////////////////START walkscore\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  if ($params->get('walkscore_registrationlevel') && $normalized_address != "" ) {
    //https://www.greatschools.org/widget/map?searchQuery=&amp;textColor=000000&amp;borderColor=FFFFFFF&amp;lat=37.8424&amp;lon=-122.273625&amp;cityName=OAKLAND&amp;state=CA&amp;normalizedAddress=894+Arlington+Ave%2C+OAKLAND%2C+CA+94608&amp;zoom=14&amp;width=838&amp;height=600
    
//$request_address = "lat=37.8424&amp;lon=-122.273625&amp;cityName=OAKLAND&amp;state=CA&amp;normalizedAddress=894+Arlington+Ave%2C+OAKLAND%2C+CA+94608"
?>
    <div id="country6" class="tabcontent">
      <div style="text-align: center;" >
        <h4><?php echo _REALESTATE_MANAGER_LABEL_WALKSCORE_TITLE; ?></h4>
        <div class="rem_tableC basictable">
          <!--iframe marginheight="0" marginwidth="0" height="426px" frameborder="0" scrolling="no" width="100%" style="margin: 0px; outline: none; text-align: left; text-decoration: none; padding: 0px; font-stretch: normal; font-style: normal; font-variant: normal; letter-spacing: normal; word-spacing: normal; text-transform: none; vertical-align: baseline; text-indent: 0px; text-shadow: none; white-space: normal; background-image: none; background-color: transparent; border: 0px;" src="//www.walkscore.com/serve-walkscore-tile.php?wsid=b03a22a4f3674046b9a7648e0512f932&amp;s=894-Arlington-Ave-OAKLAND-CA-94608&amp;o=v&amp;ts=t&amp;c=t&amp;mm=all&amp;e=2&amp;h=426&amp;fh=18&amp;w=868"></iframe-->    
<script type='text/javascript'>
//var ws_wsid = 'f7a1064f10c246413dcb9da93ada60bb';
var ws_wsid = '<?php echo $realestatemanager_configuration['walkscore']['key'];  ?>';
//var ws_address = '1060 Lombard Street, San Francisco, CA';
var ws_address = '<?php echo $normalized_address; ?>';

var ws_format = 'tall';
var ws_width = '400';
var ws_height = '500';
</script><style type='text/css'>#ws-walkscore-tile{position:relative;text-align:left}#ws-walkscore-tile *{float:none;}</style><div id='ws-walkscore-tile'></div><script type='text/javascript' src='//www.walkscore.com/tile/show-walkscore-tile.php'></script>


        </div>
      </div>
    </div>
    <?php
  }
/////////////////////////////////////////////END walkscore\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\


/////////////////////////////////////////////START CALENDAR\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
if ($house->listing_type == 1) {
  if ($params->get('calendarlist_show') && $params->get('calendarlist_registrationlevel') ) {
?>
    <div id="country7" class="tabcontent">
      <div style="text-align: center;" >
        <h4><?php echo _REALESTATE_MANAGER_LABEL_CALENDAR_TITLE; ?></h4>
        <form action="" method="post" id="calendar" name="calendar" >
        <!-- year select list on display -->
        <?php
        echo $params->get('months_list');
        echo $params->get('years_list');
        $calendar = $params->get('calendar');
        ?>
        <!-- year select list on display -->
        </form>
        <div class="rem_tableC basictable">
          <div class="row_01">
              <span class="col_01"><?php if( isset($calendar->tab1) ) echo $calendar->tab1; ?></span>
              <span class="col_02"><?php if( isset($calendar->tab2) ) echo $calendar->tab2; ?></span>
              <span class="col_03"><?php if( isset($calendar->tab3) ) echo $calendar->tab3; ?></span>
              <span class="col_03"><?php if( isset($calendar->tab4) ) echo $calendar->tab4; ?></span>
          </div>
          <div class="row_02">
              <span class="col_01"><?php if( isset($calendar->tab21) ) echo $calendar->tab21; ?></span>
              <span class="col_02"><?php if( isset($calendar->tab22) ) echo $calendar->tab22; ?></span>
              <span class="col_02"><?php if( isset($calendar->tab23) ) echo $calendar->tab23; ?></span>
              <span class="col_03"><?php if( isset($calendar->tab24) ) echo $calendar->tab24; ?></span>
          </div>
          <div class="calendar_notation row_03">
            <div class="row_calendar">
              <span class="label_calendar_available">
              <?php echo _REALESTATE_MANAGER_LABEL_CALENDAR_AVAILABLE; ?></span>
              <div class="calendar_available_notation"></div>
            </div>
            <div class="row_calendar">
              <span class="label_calendar_available">
                <?php echo _REALESTATE_MANAGER_LABEL_CALENDAR_NOT_AVAILABLE; ?></span>
              <div class="calendar_not_available_notation"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php
  }
}
/////////////////////////////////////////////END CALENDAR\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
/////////////////////////////////////////////START additional_tab\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
  if ($params->get('additional_tab_show') && $params->get('additional_tab_registrationlevel') ) {
?>
    <div id="country8" class="tabcontent">
      <div style="text-align: center;" >
        <h4><?php echo _REALESTATE_MANAGER_LABEL_ADDITIONAL_TAB_TITLE; ?></h4>
        <div class="rem_table basictable">
          <?php positions_rem($params->get('view08')); ?>
        
        </div>
        <div class="rem_tableC basictable">
          <?php positions_rem($params->get('view09')); ?>
        
        </div>
      </div>
    </div>
    <?php
  }
/////////////////////////////////////////////END additional_tab\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\


?>
</div> <!--end all tabs -->

<script type="text/javascript">
    var countries=new ddtabcontent("countrytabs")
    countries.setpersist(true)
    countries.setselectedClassTarget("link") //"link" or "linkparent"
    countries.init()
</script>

</div>

<div class="REL-collumn-xs-12 REL-collumn-sm-4 REL-collumn-md-3 REL-collumn-lg-3">
<?php  positions_rem($params->get('view05')); ?>
<?php   if ($params->get('show_owner_registrationlevel') ==1 || $params->get('show_contacts_registrationlevel') ==1) {
?>
          <div class="rem_house_contacts">
            <div id="rem_house_titlebox">
                <?php echo _REALESTATE_MANAGER_LABEL_CONTACT_AGENT ; ?>
            </div>
            <?php 
            if (isset($house->agent) && trim($house->agent)) { ?>
                    <span class="col_02"><?php echo $house->agent; ?></span>
            <?php
            }
            ?>

            <?php
            if ($params->get('show_owner_registrationlevel')) {
            ?>
                    <span class="col_02"><?php echo $house->ownername; ?></span>
                    <span class="col_02"><?php echo $house->owneremail; ?></span>
            <?php
            }
            ?>

            <?php
            if ($params->get('show_contacts_registrationlevel')) {
            ?>
                    <span class="col_02"><?php echo $house->contacts; ?></span>
            <?php
            }
            ?>
          </div>
        <?php
        }
        ?>

    <?php
    if(($house->listing_type == 1 && $params->get('show_rentrequest') && $params->get('show_rentstatus'))
       ||
       ($house->listing_type == 2 && $params->get('show_buystatus') && $params->get('show_buyrequest'))
       ||
       ($house->listing_type == 3 && $params->get('show_property_request_status') && $params->get('show_property_request'))
       ) {
    ?>

    <div class="rem_buying_house">
    <?php
     if ($house->listing_type == 1) {
      if ($params->get('show_rentrequest') && $params->get('show_rentstatus')) {
        if ($option != 'com_realestatemanager') {
          $form_action = "index.php?option=" . $option . "&task=save_rent_request&Itemid=" . $Itemid ;
        }
        else {
          $form_action = "index.php?option=com_realestatemanager&amp;task=save_rent_request&amp;Itemid=" . $Itemid;
        }
    ?>
      <div id="rem_house_titlebox">
    <?php echo _REALESTATE_MANAGER_LABEL_BOOK_NOW ; ?>
      </div>

      <form action="<?php echo sefRelToAbs($form_action); ?>" method="post" name="rent_request_form">
        <div id="show_buying">
          <input type="hidden" name="bid[]" value="<?php echo $house->id; ?>" />
          <input type="hidden" name="houseid" id="houseid" value="<?php echo $house->id ?>" maxlength="80" />
          <input type="hidden" name="calculated_price" id="calculated_price" value="" maxlength="80" />
          <input type="hidden" name="price_unit" value="<?php echo $house->priceunit;?>" maxlength="80" />
    <?php
        global $my;

        if($my->guest) {
    ?>
          <div class="row_01">
            <div id="user_name_warning"></div>
            <p>
              <input class="inputbox" id="alert_name" type="text" name="user_name" size="38"
                        maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_NAME ; ?>*" />
            </p>
          </div>

          <div class="row_02">
            <div id="user_email_warning"></div>
            <p>
              <input class="inputbox" id="alert_mail" type="text" name="user_email" size="30"
                       maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_EMAIL; ?>*" />
            </p>
          </div>

          <div class="row_03">
            <div id="user_phone_warning"></div>
            <p>
              <input class="inputbox" id="alert_phone" type="text" name="user_phone" size="30"
                       maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_PHONE; ?>*" />
            </p>
          </div>

    <?php
        }
        else {
    ?>
          <div class="row_04">
            <div id="user_name_warning"></div>
              <p>
                <input class="inputbox" id="alert_name"  type="text" name="user_name" size="38"
                  maxlength="80" value="<?php echo $my->name; ?>"
                  placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_NAME; ?>*" />
              </p>
          </div>
          <div class="row_05">
            <div id="user_email_warning"></div>
              <p>
                <input id="alert_mail" class="inputbox" type="text" name="user_email" size="30"
                  maxlength="80" value="<?php echo $my->email; ?>"
                  placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_EMAIL; ?>*" />
              </p>
          </div>

          <div class="row_06">
            <div id="user_phone_warning"></div>
              <p>
                <input id="alert_phone" class="inputbox" type="text" name="user_phone" size="30"
                  maxlength="80" value="<?php // echo $my->phone; ?>"
                  placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_PHONE; ?>*" />
              </p>
          </div>

    <?php
        }
    ?>

    <!-- 2019_06_06  script type="text/javascript">
        Date.prototype.toLocaleFormat = function(format) {
            var f = {Y : this.getYear() + 1900,m : this.getMonth() + 1,d : this.getDate(),
              H : this.getHours(),M : this.getMinutes(),S : this.getSeconds()}
            for(k in f)
                format = format.replace('%' + k, f[k] < 10 ? "0" + f[k] : f[k]);
            return format;
        };
        window.onload = function ()
        {
            var today = new Date();
            var date = today.toLocaleFormat("<?php echo $realestatemanager_configuration['date_format'] ?>");
           //fix later //first load date dug.
           // document.getElementById('rent_from').value = date;
           // document.getElementById('rent_until').value = date;
        };
    </script-->

          <div class="row_05">
            <p>
              <textarea name="user_mailing" cols="50" rows="8" placeholder="<?php
                echo _REALESTATE_MANAGER_TAB_DESCRIPTION; ?>" ></textarea>
            </p>
          </div>

          <div class="row_06">
            <p><?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_FROM; ?>:</p>
            <p><input type="text" id="rent_from" name="rent_from" autocomplete="off"></p>
          </div>


    <?php if( $house->rent_by != "by_month" && $house->rent_by != "by_week" ) {  ?>
          <div class="row_07">
            <p><?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_UNTIL; ?>:</p>
            <p><input type="text" id="rent_until" name="rent_until" autocomplete="off"></p>
          </div>
    <?php } else if( $house->rent_by == "by_month" ) {  ?>
          <div class="row_07">
            <p><?php echo _REALESTATE_MANAGER_HOW_MANY_MONTHES; ?>:</p>
            <p>
              <input max='12' min='1' name='how_many_monthes' id='how_many_monthes' type="number" value="1"  step="1" pattern="\d+">
          </div>
    <?php } else if($house->rent_by == "by_week" ) {  ?>
          <div class="row_07">
            <p><?php echo _REALESTATE_MANAGER_HOW_MANY_WEEKS; ?>:</p>
            <p>
              <input max='52' min='1' name='how_many_weeks' id='how_many_weeks' type="number" value="1"  step="1" pattern="\d+" >
          </div>
    <?php } //if( ('rent_by_month') )   ?>      
        </div>
        <div id="alert_date" name = "alert_date"> <span id="alert_date"> </span>  </div>

      <?php if ($params->get('show_pricerequest')): ?>

        <div id="price_1">
            <span><?php echo    _REALESTATE_MANAGER_LABEL_PRICE. ': '; ?></span>
            <span id="message-here"> </span>
            <span><?php //echo $house->priceunit; ?></span>
        </div>

      <?php endif; ?>

        <div id="message-here"> </div>

    <div id="captcha-block">
<!--*************************   begin add antispam guest   ********************-->
<?php
if ($params->get('captcha_option_booking')) {
  if ($params->get('captcha_option_booking_registrationlevel')) { ?>
            <?php
?>
    <div class="row_capcha">
<!--*************************   begin insetr image   **********************-->
<?php HTML_realestatemanager::showCaptchaRealestate("rent_request"); ?>
<!--**********************   end insert image   *******************************-->
             </div><!--end div class="row_capcha"-->

<?php
  }

}
?>
<!--*********************** end add antispam guest   *************************-->
        <?php
        if ($params->get('show_rentstatus') && $params->get('show_rentrequest')
              && !$params->get('rent_save') && !$params->get('search_request')) {
            ?>
            <br />
            <input type="button" value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_RENT_REQU ; ?>"
              class="button" onclick="rem_rent_request_submitbutton()" />
            <br />
    <?php
} else if ($params->get('show_rentstatus') && $params->get('show_rentrequest') && $params->get('rent_save')
          && !$params->get('search_request')) {
    ?>
            <input type="button" class="button" value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_RENT_REQU_SAVE; ?>"
              onclick="rem_rent_request_submitbutton()" />
    <?php
    }
    else {
     ?>
            &nbsp;
     <?php
    }
    ?>
    </div>
        </form>
     <?php
                }
            }
            else if ($house->listing_type == 2) {

    if ($params->get('show_buyrequest') && $params->get('show_buystatus')) {
        global $option;
        if ($option != 'com_realestatemanager') {
            $form_action = "index.php?option=" . $option
            . "&task=buying_request&Itemid="
              . $Itemid ;
        } else
            $form_action = "index.php?option=com_realestatemanager&amp;task=buying_request&amp;Itemid=" . $Itemid;
        ?>
    <div id="rem_house_titlebox">
        <?php echo _REALESTATE_MANAGER_LABEL_BUTTON_SEND_MESSAGE; ?>
    </div>
    <div id="show_buying">
        <form action="<?php echo sefRelToAbs($form_action); ?>" method="post" name="buying_request">
            <div class="table_08">
    <?php
    global $my;
    if ($my->guest) {
        ?>
            <div class="row_01">
              <div id="customer_name_warning"></div>
                <span class="col_02"><input id="alert_name_buy" class="inputbox" type="text"
                  name="customer_name" size="38" maxlength="80" placeholder="<?php
                  echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_NAME ; ?>*"/></span>
            </div>
            <div class="row_02">
              <div id="customer_email_warning"></div>
                <span class="col_02"><input id="alert_mail_buy" class="inputbox" type="text"
                  name="customer_email" size="38" maxlength="80" placeholder="<?php
                  echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_EMAIL; ?>*"/></span>
            </div>

        <?php
    } else {
        ?>
            <div class="row_03">
              <div id="customer_name_warning"></div>
                <span class="col_02">
                    <input id="alert_name_buy"  class="inputbox" type="text" name="customer_name" size="38"
                  maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_NAME; ?>"
                  value="<?php echo $my->name; ?> " /></span>
            </div>
            <div class="row_04">
              <div id="customer_email_warning"></div>
                <span class="col_02">
                    <input id="alert_mail_buy"  class="inputbox" type="text" name="customer_email" size="38"
                  maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_EMAIL; ?>"
                  value="<?php echo $my->email; ?>"/></span>
            </div>
            <?php
        }
        ?>
            <div class="row_05">
              <div id="customer_phone_warning"></div>
                <span class="col_02">
                    <input class="inputbox" type="text" id="customer_phone" name="customer_phone"
                      size="38" maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_REQUEST_PHONE; ?>" />
                </span>
            </div>
            <div class="row_06">
                <textarea name="customer_comment" cols="50" rows="8" placeholder="<?php
                  echo _REALESTATE_MANAGER_TAB_DESCRIPTION; ?>" ></textarea>
                <input type="hidden" name="bid[]" value="<?php echo $house->id; ?>" />
            </div>

            <!--*************************   begin add antispam guest   ********************-->
            <?php
            if ($params->get('captcha_option_sendmessage')) {
              if ($params->get('captcha_option_sendmessage_registrationlevel')) { ?>
                        <?php
            ?>
                <div class="row_capcha">
            <!--*************************   begin insetr image   **********************-->
            <?php HTML_realestatemanager::showCaptchaRealestate("buy_request"); ?>
            <!--**********************   end insert image   *******************************-->
                         </div><!--end div class="row_capcha"-->

            <?php
              }
            }
            ?>
            <div class="row_07">
              <span class="col_01">
                <input type="button" value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_SEND_MESSAGE; ?>"
                      class="button" onclick="buying_request_submitbutton()"/>
              </span>
            </div>
          </div>
        </form>
      </div>
        <?php
    }
}
else if ($house->listing_type == 3) {

    if ($params->get('show_property_request') && $params->get('show_property_request_status')) {
        global $option;
        if ($option != 'com_realestatemanager') {
            $form_action = "index.php?option=" . $option
            . "&task=property_request&Itemid="
              . $Itemid ;
        } else
            $form_action = "index.php?option=com_realestatemanager&amp;task=property_request&amp;Itemid=" . $Itemid;
        ?>
    <div id="rem_house_titlebox">
        <?php echo _REALESTATE_MANAGER_LABEL_BUTTON_PROPERTY_REQUEST; ?>
    </div>
    <div id="show_buying">
        <form action="<?php echo sefRelToAbs($form_action); ?>" method="post" name="property_request">
            <div class="table_08">
    <?php
    global $my;
    if ($my->guest) {
        ?>
            <div class="row_01">
              <div id="customer_name_warning2"></div>
                <span class="col_02"><input id="alert_name2" class="inputbox" type="text"
                  name="customer_name" size="38" maxlength="80" placeholder="<?php
                  echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_NAME ; ?>*"/></span>
            </div>
            <div class="row_02">
              <div id="customer_email_warning2"></div>
                <span class="col_02"><input id="alert_mail2" class="inputbox" type="text"
                  name="customer_email" size="38" maxlength="80" placeholder="<?php
                  echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_EMAIL; ?>*"/></span>
            </div>

        <?php
    } else {
        ?>
            <div class="row_03">
              <div id="customer_name_warning2"></div>
                <span class="col_02">
                    <input id="alert_name2"  class="inputbox" type="text" name="customer_name" size="38"
                  maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_NAME; ?>"
                  value="<?php echo $my->name; ?> " /></span>
            </div>
            <div class="row_04">
              <div id="customer_email_warning2"></div>
                <span class="col_02">
                    <input id="alert_mail2"  class="inputbox" type="text" name="customer_email" size="38"
                  maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_EMAIL; ?>"
                  value="<?php echo $my->email; ?>"/></span>
            </div>
            <?php
        }
        ?>
            <div class="row_05">
              <div id="customer_phone_warning2"></div>
                <span class="col_02">
                    <input class="inputbox" type="text" id="customer_phone2" name="customer_phone"
                      size="38" maxlength="80" placeholder="<?php echo _REALESTATE_MANAGER_REQUEST_PHONE; ?>" />
                </span>
            </div>
            <div class="row_06">
                <textarea name="customer_comment" cols="50" rows="8" placeholder="<?php
                  echo _REALESTATE_MANAGER_TAB_DESCRIPTION; ?>" ></textarea>
                <input type="hidden" name="bid[]" value="<?php echo $house->id; ?>" />
            </div>

            <!--*************************   begin add antispam guest   ********************-->
            <?php
            if ($params->get('captcha_option_property_request')) {
              if ($params->get('captcha_option_property_request_registrationlevel')) { ?>
                        <?php
            ?>
                <div class="row_capcha">
            <!--*************************   begin insetr image   **********************-->
            <?php HTML_realestatemanager::showCaptchaRealestate("property_request"); ?>
            <!--**********************   end insert image   *******************************-->
                         </div><!--end div class="row_capcha"-->

            <?php
              }
            }
            ?>
            <div class="row_07">
              <span class="col_01">
                <input type="button" value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_PROPERTY_REQUEST; ?>"
                      class="button" onclick="property_request_submitbutton()"/>
              </span>
            </div>
          </div>
        </form>
      </div>
        <?php
    }
}
?>

</div><!-- end div class='rem_buying_house' -->
<?php
}
?>
</div> <!-- end span3-->

</div>

 <?php positions_rem($params->get('similaires')); ?>

<div>
    <?php
    mosHTML::BackButton($params, $hide_js);
    ?>
</div>
<!-- Modal -->
<a href="#aboutus" class="rem-button-about"></a>

<a href="#rem-modal-css" class="rem-overlay" id="rem-aboutus" style="display: none;"></a>
<div class="rem-popup">
    <div class="rem-modal-text">
        Please past text to modal
    </div>

    <a class="rem-close" title="Close" href="#rem-close"></a>
</div>

<?php
  $slider_object_fit = $realestatemanager_configuration['slider']['object_fit'];
  $slider_height = $realestatemanager_configuration['slider']['height']/100;
?>
<noscript>Javascript is required to use <a href="https://ordasoft.com/joomla-real-estate" title="Joomla Real Estate">Joomla Real Estate</a>, <a href="https://ordasoft.com/how-to-create-real-estate-website" title="How to create real estate website" >How to create real estate website</a></noscript>

<script type="text/javascript">
  var mySwiper = new SwipeOs ('#rem_house_galery .swiper-container', {
    navigation: {
        nextEl: '#rem_house_galery .swiper-button-next',
        prevEl: '#rem_house_galery .swiper-button-prev',
    },
    allowTouchMove: true
  })
  
// fancybox

 jQuerOs('[data-os_fancybox]').os_fancybox({
 // jQuerOs('[data-os_fancybox]').fancybox({
  thumbs : {
    autoStart : true
  },
  buttons : ['slideShow','fullScreen','thumbs','close']
})


var width = jQuerOs('#rem_house_galery .swiper-container').width();
jQuerOs('#rem_house_galery .swiper-container .swiper-slide img').height(width*<?php echo $slider_height; ?>);
jQuerOs('#rem_house_galery .swiper-container .swiper-slide img').css('object-fit','<?php echo $slider_object_fit; ?>');

jQuerOs(window).resize(function(){
  var width = jQuerOs('#rem_house_galery .swiper-container').width();
  jQuerOs('#rem_house_galery .swiper-container .swiper-slide img').height(width*<?php echo $slider_height; ?>);
})


</script>

</div> <!-- class="componentbody -->
<p style="text-align: center; font-size: 12px;"><a title="Joomla Real Estate" href="https://ordasoft.com/joomla-real-estate" target="_blank">Joomla Real Estate</a>, by OrdaSoft.</p>
</div> <!-- class="rem -->
