<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter\Abstracts;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Enum\FilterEnum;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

defined('_JEXEC') or die;

abstract class ItemFilter extends AbstractFilter implements FilterInterface
{
    protected array $rules = [
        'id' => FilterEnum::Integer,
        'form_id' => FilterEnum::Integer,
        'key' => FilterEnum::String,
        'type' => FilterEnum::String,
        'parent' => FilterEnum::String,
        'column_id' => FilterEnum::Integer
    ];

    protected array $optionsRules = [];

    public function clean(object &$data): void
    {
        $this->cleanData($this->rules, $data);
        $this->cleanData($this->optionsRules, $data->options);
    }

    protected function cleanOptionProperty(object &$data, string $key, array $rules): void
    {
        if (!isset($data->options->$key)) {
            return;
        }

        $this->cleanData($rules, $data->options->$key);
    }
}