<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter\Filters;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Abstracts\ItemFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Enum\FilterEnum;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

class CheckboxFilter extends ItemFilter implements FilterInterface
{
    protected array $optionsRules = [
        'title' => FilterEnum::String,
        'description' => FilterEnum::String,
        'required' => FilterEnum::Boolean,
        'suffix' => FilterEnum::String,
        "count" => FilterEnum::Integer,
    ];

    protected array $itemRules = [
        'title' => FilterEnum::String,
        'price' => FilterEnum::String,
        'key' => FilterEnum::Integer,
        'default' => FilterEnum::Boolean
    ];

    protected function cleanOptionsItems(object &$data): void
    {
        if (!isset($data->options->items)) {
            return;
        }

        foreach ($data->options->items as &$item) {
            if (!$item) {
                dd($this->itemRules, $item);
            }
            $this->cleanData($this->itemRules, $item);
        }
    }

    public function clean(object &$data): void
    {
        parent::clean($data);

        $this->cleanOptionsItems($data);
    }
}