<?php
/**
 *
 * @package  VehicleManager
 * @copyright by Ordasoft
 * @author Andrey Kvasnevskiy - OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Homepage: https://ordasoft.com/
 *
 */

if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );
if(!defined('DS'))  define('DS', DIRECTORY_SEPARATOR);

/**
* mosSefurl database table class
*/
jimport( 'joomla.database.table');
class mosVmSefurl extends JTable {


//keys
  /** @var int Primary key */
  var $id=null;
  /** @var BLOB */
  var $ser_url_segments=null;
  /** @var varchar(35) */
  var $hash_url_segments=null;
  /** @var BLOB */
  var $ser_vars=null;
  /** @var varchar(35) */
  var $hash_vars=null;
  /** @var varchar(55) */
  var $lang=null;
  /** @var datetime */
  var $date=null;
  /** @var int */
  var $hits=null;
  /** @var boolean */
  var $published=null;


  /**
  * @param database - A database connector object
  */
  function __construct( &$db ) {
    parent::__construct( '#__vehiclemanager_sef_urls', 'id', $db );
  }

  function loadByHashUrlSegments($hash){

    $this->_db->setQuery("SELECT id FROM #__vehiclemanager_sef_urls WHERE hash_url_segments = '$hash' ");
    $id = intval( $this->_db->loadResult() );
    if ($id) {
      $this->load($id );

      //if url not exist, remove it
      if( !$this->check_url_exist() ){
        return null;
      }

      //if url exist, update it date
      $this->date = date("Y-m-d H:i:s") ;
      $this->store();
      return $this;
    }
    else return null;
  }

  function loadByHashVars($hash){

    $this->_db->setQuery("SELECT id FROM #__vehiclemanager_sef_urls WHERE hash_vars = '$hash' ");
    $id = intval( $this->_db->loadResult() );
    if ($id) {
      $this->load($id );

      //if url not exist, remove it
      if( !$this->check_url_exist() ){
        return null;
      }

      //if url exist, update it date
      $this->date = date("Y-m-d H:i:s") ;
      $this->store();
      return $this;
    }
    else return null;
  }

  function check_url_exist(){

    $var_array = unserialize($this->ser_vars)  ;

    if( isset( $var_array['id'] ) 
        && ( $var_array['task'] == 'view' || $var_array['task'] == 'view_vehicle' ) ){
      //if link to vehicle = check so vehicle exist ?
      $selectstring = "SELECT id FROM #__vehiclemanager_vehicles WHERE id = ". $var_array['id'];
      $this->_db->setQuery($selectstring);
      $itemData = $this->_db->LoadRow();

      if( isset($itemData) && count($itemData) > 0 ) return $this;

      //if vehicle not exist - remove this url
      $this->delete();
      return false;

    }else if( isset($query['catid']) && ( $var_array['task'] != "search_vehicle" ||  $var_array['task'] != "search" )  ){
      //if link to CATEGORY = check so CATEGORY exist ?
      $selectstring = "SELECT  c.id FROM #__vehiclemanager_main_categories AS c "
                      . " WHERE c.id = " . intval($var_array['catid']);
      $this->_db->setQuery($selectstring);
      $catData = $this->_db->LoadRow();

      if( isset($catData) && count($catData) > 0 ) return $this;

      //if category not exist - remove this url
      $this->delete();
      return false;
    }

    return true;
  }
}
