<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\AcceptanceFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\AddressFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\CalculationFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\CalendarFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\CheckboxFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\ColumnFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\HeadlineFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\HtmlFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\ImageFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\InputFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\MapFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\PageFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\PhoneFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\PollFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\RadioFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\RatingFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\SelectFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\SelectMultipleFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\SignatureFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\SliderFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\SubmitFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\TextFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\TotalFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Filters\UploadFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

class FilterFactory
{
    protected static array $filters = [
        'page' => PageFilter::class,
        'column' => ColumnFilter::class,
        'address' => AddressFilter::class,
        'acceptance' => AcceptanceFilter::class,
        'calculation' => CalculationFilter::class,
        'calendar' => CalendarFilter::class,
        'checkbox' => CheckboxFilter::class,
        'headline' => HeadlineFilter::class,
        'html' => HtmlFilter::class,
        'input' => InputFilter::class,
        'image' => ImageFilter::class,
        'map' => MapFilter::class,
        'phone' => PhoneFilter::class,
        'poll' => PollFilter::class,
        'radio' => RadioFilter::class,
        'rating' => RatingFilter::class,
        'select' => SelectFilter::class,
        'selectMultiple' => SelectMultipleFilter::class,
        'signature' => SignatureFilter::class,
        'slider' => SliderFilter::class,
        'text' => TextFilter::class,
        'total' => TotalFilter::class,
        'upload' => UploadFilter::class,
        'submit' => SubmitFilter::class,
    ];

    public static function make(string $key): FilterInterface|null
    {
        if (!isset(self::$filters[$key])) {
            return null;
        }

        return self::$filters[$key]::getInstance();
    }
}