<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter\Filters;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Enum\FilterEnum;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

class PollFilter extends CheckboxFilter implements FilterInterface
{
    protected array $optionsRules = [
        "title" => FilterEnum::String,
        "description" => FilterEnum::String,
        "required" => FilterEnum::Boolean,
        "count" => FilterEnum::Integer,
        "multiple" => FilterEnum::Boolean,
        "vote-count" => FilterEnum::Boolean,
        "close" => FilterEnum::Boolean,
        "again" => FilterEnum::Boolean,
        "end" => FilterEnum::String,
        "suffix" => FilterEnum::String,
    ];

    protected array $itemRules = [
        "title" => FilterEnum::String,
        "key" => FilterEnum::Integer,
        "default" => FilterEnum::Boolean
    ];
}