<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Site\Helper;

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

class DesignHelper
{
    protected bool $isSite;
    protected static DesignHelper $instance;
    protected bool $accessibility = false;

    protected function __construct()
    {
        $this->isSite = Factory::getApplication()->isClient('site');
    }

    public static function getInstance(): static
    {
        if (!isset(self::$instance)) {
            self::$instance = new static();
        }

        return self::$instance;
    }

    public function setAccessibility(bool $accessibility): void
    {
        $this->accessibility = $accessibility;
    }

    protected function getUnitsValue(string|int $value, string $units): string
    {
        if ($this->isSite && $this->accessibility && $units == 'px') {
            $value = floatval($value) / 16;
            $units = 'rem';
        }

        return $value . $units;
    }

    protected function getUnits(string $group, string $subgroup, string $option, object $design): ?string
    {
        if (!empty($group) && isset($design->{$group}->units->{"$subgroup-$option"})) {
            return $design->{$group}->units->{"$subgroup-$option"};
        } else if (!empty($group) && isset($design->{$group}->units->{$option})) {
            return $design->{$group}->units->{$option};
        } else if (isset($design->units->{$option})) {
            return $design->units->{$option};
        } else if (!empty($group) && isset($design->units->{$group})) {
            return $design->units->{$group};
        } else if (!empty($group) && isset($design->units->{"$group-$option"})) {
            return $design->units->{"$group-$option"};
        } else if ($subgroup == 'padding' || $subgroup == 'margin') {
            return $design->{$group}->units->{$subgroup};
        }

        return null;
    }

    public function getVariable(
        string $group,
        string $subgroup,
        string $option,
        object $design,
        string $subname = ''
    ): string
    {
        $units = $this->getUnits($group, $subgroup, $option, $design);
        if (!empty($subgroup)) {
            $value = $design->{$group}->{$subgroup}->{$option};
            $property = "--$group-$subgroup-$option";
        } else if (!empty($group)) {
            $value = $design->{$group}->{$option};
            $property = '--'.($subname ? $subname . '-' : '').$group.'-'.$option;
        } else {
            $value = $design->{$option};
            $property = '--'.($subname ? $subname . '-' : '').$option;
        }
        if ($units) {
            $value = $this->getUnitsValue($value, $units);
        }
        if ($option == 'fullwidth') {
            $value = $value ? '100%' : 'auto';
        } else if (is_bool($value)) {
            $value = (int) $value;
        } else if ($option == 'font-family') {
            $value = str_replace('+', ' ', $value);
        }

        return "$property: $value";
    }

    public function getVariables(object $design): string
    {
        $variables = "";
        $skipProperties = [
            'css', 'js', 'theme', 'lightbox'
        ];
        $this->setAccessibility($design->theme->accessibility ?? false);
        foreach ($design as $group => $groupValue) {
            if ($group == 'theme') {
                $variables .= $this->getVariable('theme', '', 'color', $design).";\n\t";
            } else if ($group == 'lightbox') {
                $variables .= $this->getVariable('lightbox', '', 'color', $design).";\n\t";
            }
            if (in_array($group, $skipProperties)) {
                continue;
            }
            foreach ($groupValue as $subgroup => $subgroupValue) {
                if ($subgroup == 'units') {
                    continue;
                }
                foreach ($subgroupValue as $option => $optionValue) {
                    if ($option == 'link') {
                        continue;
                    }
                    $variables .= $this->getVariable($group, $subgroup, $option, $design).";\n\t";
                }
            }
        }

        return $variables;
    }
}