<?php
/**
* @package   BaForms
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Plugin\System\Forms\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Balbooa\Component\Forms\Site\Helper\BaformsHelper;
use Joomla\CMS\Http\HttpFactory;
 
class Baforms extends CMSPlugin
{
    public function __construct($subject, $config)
    {
        parent::__construct($subject, $config);
    }

    public function onInstallerBeforePackageDownload(&$url, &$headers)
    {
        if (!str_contains($url, 'com_licenseactivations&task=baforms.update')) {
            return;
        }
        $about = BaformsHelper::aboutUs();
        $url .= '&amp;tag=' . $about->tag;
        if ($about->tag == 'free') {
            return;
        }
        $state = BaformsHelper::checkFormsActivation('balbooa');
        $url .= '&amp;data=' . ($state->data ?? '');
        $language = Factory::getApplication()->getLanguage();
        $language->load('com_baforms', JPATH_ADMINISTRATOR);
        if (isset($state->data)) {
            $this->checkUpdateLicense($state);

            return;
        }
        $this->setUpdateError(Text::_('ACTIVATE_LICENSE_BEFORE_UPDATE'));
    }

    private function setUpdateError($message)
    {
        $app = Factory::getApplication();
        $app->enqueueMessage($message, 'error');
        $app->redirect('index.php?option=com_installer&view=update');
    }

    private function checkUpdateLicense($state)
    {
        $uri = 'https://www.balbooa.com/index.php?option=com_licenseactivations'
            . '&amp;task=baforms.checkUpdateLicense&amp;data=' . $state->data;
        $response = HttpFactory::getHttp()->get($uri);
        $object = json_decode($response->body);
        if (!$object->flag) {
            $this->setUpdateError(Text::_('RENEW_LICENSE_BEFORE_UPDATE'));
        }
    }
    
    public function onAfterRender(): void
    {
        $app = Factory::getApplication();
        $doc = Factory::getDocument();
        if ($app->isClient('site') && $doc->getType() == 'html') {
            $this->setForms();
        }
    }

    public function onBeforeRenderGridbox():void
    {
        $this->setForms();
    }

    public function setForms():void
    {
        /** @var SiteApplication $app */
        $app = Factory::getApplication();
        $a_id = $app->input->get('a_id');
        $option = $app->input->get('option', '', 'string');
        if (empty($a_id) && $option != 'com_config') {
            BaformsHelper::prepareHelper();
            $html = $app->getBody();
            $pos = strpos($html, '</head>');
            $head = substr($html, 0, $pos);
            $body = substr($html, $pos);
            include JPATH_ROOT . '/components/com_baforms/tmpl/form/click-trigger.min.php';
            /** @var string $out */
            $body = str_replace('</body>', $out . '</body>', $body);
            $content = $this->getContent($body);
            $html = $head.$content;
            $app->setBody($html);
        }
    }
    
    public function getContent($body): string
    {
        return BaformsHelper::renderFormHTML($body);
    }
}