<?php
/**
 * 
 * @package simpleMembership
 * @copyright Andrey Kvasnevskiy-OrdaSoft(akbet@mail.ru);
 * Homepage: http://www.ordasoft.com
 * @version: 1.0 PRO
 *
 *
 */
defined( '_JEXEC' ) or die( ';)' );
jimport('joomla.html.html');
jimport( 'joomla.plugin.helper' );

class plgPaymentPaypalHelper
{
	public static $ipn_data = array();
	public static $last_error = null;
	public static $ipn_response = null;
	public static $ipn_log = null;
	public static $ipn_log_file = null;
	
	//gets the paypal URL
	public static function buildPaypalUrl($secure_post = true, $sandbox = false )
	{	
		$url = $sandbox? 'www.sandbox.paypal.com' : 'www.paypal.com';
		if ( $secure_post )
			$url = 'https://' . $url . '/cgi-bin/webscr';
		else
			$url = 'http://' . $url . '/cgi-bin/webscr';
		return $url;
	}

	public static function getPayKey($vars){	
		$url = $vars['paypal_real_or_test']? 'svcs.paypal.com' : 'svcs.sandbox.paypal.com';
		$url = 'https://' . $url . '/AdaptivePayments/Pay';
		$headers=array(
			"X-PAYPAL-SECURITY-USERID:".$vars['paypal_api_user'],
			"X-PAYPAL-SECURITY-PASSWORD:".$vars['paypal_api_pass'],
			"X-PAYPAL-SECURITY-SIGNATURE:".$vars['paypal_api_sign'],
			"X-PAYPAL-REQUEST-DATA-FORMAT:JSON",
			"X-PAYPAL-RESPONSE-DATA-FORMAT:JSON",
			"X-PAYPAL-APPLICATION-ID:".$vars['paypal_api_id']
		);
		$data=array(
			"actionType"=>"PAY",
			"currencyCode"=>$vars['currency_code'],
			"receiverList"=>array(
				"receiver"=>array(array("amount"=>$vars['price'],"email"=>$vars['main_receiver']),
					array("amount"=>$vars['comission'],"email"=>$vars['comission_receiver']))//need array variable such as (array)$reciver
			),
			"returnUrl"=>$vars['return_url'],
			"cancelUrl"=>$vars['cancel_url'],
			"ipnNotificationUrl"=>$vars['notify_url'],//ipnNotificationUrl notifyUrl
			//"trackingId"=>"",//maybe need for traking order id///if we want to change plagin behavior
			"requestEnvelope"=>array("errorLanguage"=>"en_US","detailLevel"=>"ReturnAll")
			//"feesPayer"=>"PRIMARYRECEIVER"//we sat primary resiver in resiver list///don't know why...
		);

		//create transaction
		$ch=curl_init();
		curl_setopt($ch,CURLOPT_URL,$url);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE);
		curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,FALSE);
		curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,FALSE);
		curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($data));
		curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
		$pay_data = json_decode(curl_exec($ch),TRUE);
		curl_close($ch);
		if(!isset($pay_data['payKey']) || empty($pay_data['payKey'])){
			JError::raiseWarning( 100, 'Error with getting paypal PayKey. Please contact admin!<br>'
																	.$pay_data['error']['0']['message'] );
			return;
		}
		return $pay_data['payKey'];
	}

	public static function Storelog($name,$logdata){
		jimport('joomla.error.log');
		$options = array('format' => "{DATE}\t{TIME}\t{USER}\t{DESC}");
		if(JVERSION >='1.6.0')
			$path=JPATH_SITE.'/plugins/payment/'.$name.'/'.$name.'/';
		else
			$path=JPATH_SITE.'/plugins/payment/'.$name.'/';	  
		$my 	= JFactory::getUser();  
		JLog::addLogger(array(
													'user' => $my->name.'('.$my->id.')', 
													'desc' => json_encode($logdata['raw_data'])
													)
		);
	}

  public static function validateIPN($paypal_real_or_test,$receiver_email,$currency_code,$params){		
  	$database = JFactory::getDbo();
		define("DEBUG", 0);
		define("LOG_FILE", "./ipn.log");
                
		if($params->get('paypal_payment_type') == 1){//paralel payment
			$url = $params->get('paypal_real_or_test')? 'svcs.paypal.com' : 'svcs.sandbox.paypal.com';
			$url = 'https://' . $url . '/AdaptivePayments/PaymentDetails';
			$headers=array(
				"X-PAYPAL-SECURITY-USERID:".$params->get('paypal_api_user'),
				"X-PAYPAL-SECURITY-PASSWORD:".$params->get('paypal_api_pass'),
				"X-PAYPAL-SECURITY-SIGNATURE:".$params->get('paypal_api_sign'),
				"X-PAYPAL-REQUEST-DATA-FORMAT:JSON",
				"X-PAYPAL-RESPONSE-DATA-FORMAT:JSON",
				"X-PAYPAL-APPLICATION-ID:".$params->get('paypal_api_id')
			);
			$component = '';
			$orderId = JRequest::getVar('orderId');
			if(JRequest::getVar('option') == 'com_realestatemanager'){
				$component = '#__rem_orders';
			}
			if(JRequest::getVar('option') == 'com_vehiclemanager'){
				$component = '#__vehiclemanager_orders';
			}
			$query = "SELECT paypal_paykay FROM $component WHERE id = $orderId";
			$database->setQuery($query);
			$payKay = $database->loadResult();
			$data=array(
				"actionType"=>"PaymentDetails",
				"payKey"=>"$payKay",
				"requestEnvelope"=>array("errorLanguage"=>"en_US","detailLevel"=>"ReturnAll")
			);
			//create transaction
			$ch=curl_init();
			curl_setopt($ch,CURLOPT_URL,$url);
			curl_setopt($ch,CURLOPT_RETURNTRANSFER,TRUE);
			curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,FALSE);
			curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,FALSE);
			curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode($data));
			curl_setopt($ch,CURLOPT_HTTPHEADER,$headers);
			$pay_data = json_decode(curl_exec($ch),TRUE);
			curl_close($ch);
			if(isset($pay_data['error'])){
				echo "Transaction id error!";
				return false;
			}
			if($pay_data['responseEnvelope']['ack'] == 'Failure' || $pay_data['responseEnvelope']['ack'] == 'FailureWithWarning'){
				echo "Invalid IPN Paypal test<br>";
				return false;
			}
			return $pay_data;
		}else{
			//define("USE_SANDBOX", 1);
			$raw_post_data = file_get_contents('php://input');
			$raw_post_array = explode('&', $raw_post_data);
                        //$raw_post_array = $_REQUEST;
			$myPost = array();
			$req = "";
                        
			foreach ($raw_post_array as $keyval) {
                            $keyval = explode ('=', $keyval);
			    if (count($keyval) == 2)
			    $myPost[$keyval[0]] = urldecode($keyval[1]);
			}
                        
//                        foreach ($raw_post_array as $key => $val) {
//                            //$keyval = explode ('=', $keyval);
//			    //if (count($keyval) == 2)
//			    $myPost[$key] = urldecode($val);
//			}
			$req = 'cmd=_notify-validate';
			if(function_exists('get_magic_quotes_gpc')) {
			    $get_magic_quotes_exists = true;
			}
                        //var_dump($raw_post_array);
			foreach ($myPost as $key => $value) {
                          if($key == "receiver_email"  && $value != $receiver_email){
                            if(DEBUG == true) {
                                error_log(date('[Y-m-d H:i e] '). "Paypal receiver_email not valid: " .
                                $receiver_email ." != ". $value . PHP_EOL, 3, LOG_FILE);
                              }
                              return FALSE;
                            }
                          if($key == "mc_currency"  && !in_array($value,$currency_code)) {
                            if(DEBUG == true) {
                                error_log(date('[Y-m-d H:i e] '). " order check error, currency fault ". $currency_code ." != ".$value. PHP_EOL, 3, LOG_FILE);
                              }
                            return FALSE;
                          }      
                          if($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
                            $value = urlencode(stripslashes($value));
                          } else {
                            $value = urlencode($value);
                          }
                                $req .= "&$key=$value";
			}

			//USE_SANDBOx or not
			if($paypal_real_or_test == false) {
			    //$paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
                            $paypal_url = 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr';
			} else {
			    //$paypal_url = "https://www.paypal.com/cgi-bin/webscr";
                            $paypal_url = 'https://ipnpb.paypal.com/cgi-bin/webscr';
			}
                        
			$ch = curl_init($paypal_url);
			if ($ch == FALSE) {
                            if(DEBUG == true) {
                              error_log(date('[Y-m-d H:i e] '). "curl_init error: " . $paypal_url." request data:". $req . PHP_EOL, 3, LOG_FILE);
                            }
                            return FALSE;
			}
                        
			if(DEBUG == true) {
				error_log(date('[Y-m-d H:i e] '). "PayPal url: " . $paypal_url." request data:". $req . PHP_EOL, 3, LOG_FILE);
			}

			curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
			curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);

			if(DEBUG == true) {
			    curl_setopt($ch, CURLOPT_HEADER, 1);
			    curl_setopt($ch, CURLINFO_HEADER_OUT, 1);
			}
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));
			//проверка на валидность ipn
			$res = curl_exec($ch);
                        
                        
                        //var_dump($res);
			if (curl_errno($ch) != 0) {// cURL error
			    if(DEBUG == true) {
			        //echo "FALSE11111";
			        error_log(date('[Y-m-d H:i e] '). "Can't connect to PayPal to validate IPN message: " . curl_error($ch) . PHP_EOL, 3, LOG_FILE);
			    }
			    curl_close($ch);
			    echo "Can't connect to PayPal to validate IPN message: " . curl_error($ch);
			    if($_POST['test_ipn']) { echo "<br>You used test sandbox-paypal!!<br>";}
			    else {exit; }//в тесте пока закоментить
			} else {
			    // Log the entire HTTP response if debug is switched on.
			    if(DEBUG == true) {
			        error_log(date('[Y-m-d H:i e] '). "HTTP request of validation request:". curl_getinfo($ch, CURLINFO_HEADER_OUT) ." for IPN payload: $req" . PHP_EOL, 3, LOG_FILE);
			        error_log(date('[Y-m-d H:i e] '). "HTTP response of validation request: $res" . PHP_EOL, 3, LOG_FILE);
			        // Split response headers and payload
			        list($headers, $res) = explode("\r\n\r\n", $res, 2);
			    }
			    curl_close($ch);
			    //echo "HTTP request of validation request";

			}
                        
			// Inspect IPN validation result and act accordingly
			if (strcmp ($res, "VERIFIED") == 0) {

			    if(DEBUG == true) {
			        error_log(date('[Y-m-d H:i e] '). "Verified IPN: $req ". PHP_EOL, 3, LOG_FILE);
			        //echo "HTTP request of validation request";
			    }
				return TRUE;
			} else if (strcmp ($res, "INVALID") == 0) {
			    // log for manual investigation
			    // Add business logic here which deals with invalid IPN messages
			    if(DEBUG == true) {
			        error_log(date('[Y-m-d H:i e] '). "Invalid IPN: $req" . PHP_EOL, 3, LOG_FILE);
			    }
			    echo "Invalid IPN Paypal test<br>";
	            
                            if($paypal_real_or_test == false) {
                              echo "<br>You used test sandbox-paypal!!<br>";
                            } else {
                              echo "<br>You used test live paypal!!<br>";
                            }
			    return FALSE;
			}
                        
			if(DEBUG == true) {
				error_log(date('[Y-m-d H:i e] '). "Some errors:  $req" . PHP_EOL, 3, LOG_FILE);
			}
			return FALSE;
			/*
			echo 'GOOD PAYPAL!!!';return true;
			// parse the paypal URL
			if(!$paypal_url){
				$paypal_url	=plgPaymentPaypalHelper::buildPaypalUrl();
			}
			$url_parsed=parse_url($paypal_url);

			// generate the post string from the _POST vars aswell as load the
			// _POST vars into an arry so we can play with them from the calling
			// script.
			// append ipn command
			// open the connection to paypal
			$fp = fsockopen($url_parsed["host"],"80",$err_num,$err_str,30);
			// $fp = fsockopen ($this->paypal_url, 80, $errno, $errstr, 30);

			if(!$fp) {
				// could not open the connection.  If loggin is on, the error message
				// will be in the log.
				self::$last_error = 'fsockopen error no. '.$err_num.': '.$err_str;
				plgPaymentPaypalHelper::log_ipn_results(false);	   
				return false;
			} else { 

				$post_string = '';	
				foreach ($data as $field=>$value) { 
					self::$ipn_data["$field"] = $value;
					$post_string .= $field.'='.urlencode(stripslashes($value)).'&'; 
				}
				$post_string.="cmd=_notify-validate";

				// Post the data back to paypal
				fputs($fp, "POST $url_parsed[path] HTTP/1.1\r\n"); 
				fputs($fp, "Host: $url_parsed[host]\r\n"); 
				fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n"); 
				fputs($fp, "Content-length: ".strlen($post_string)."\r\n"); 
				fputs($fp, "Connection: close\r\n\r\n"); 
				fputs($fp, $post_string . "\r\n\r\n"); 

				// loop through the response from the server and append to variable
				while(!feof($fp)) { 
					self::$ipn_response .= fgets($fp, 1024); 
				}
				fclose($fp); // close connection
			}
			if (preg_match("/verified/",$post_string)) {
				// Valid IPN transaction.
				plgPaymentPaypalHelper::log_ipn_results(true);
				return true;
			} else {
				// Invalid IPN transaction.  Check the log for details.
				self::$last_error = 'IPN Validation Failed.';
				plgPaymentPaypalHelper::log_ipn_results(false);   
				return false;
			}

			}
			
			public static function log_ipn_results($success) {
				if (!self::$ipn_log) return; 
				// Timestamp
				$text = '['.date('m/d/Y g:i A').'] - '; 
				// Success or failure being logged?
				if ($success)
					$text .= "SUCCESS!\n";
				else
					$text .= 'FAIL: '.self::$last_error."\n";

				// Log the POST variables
				$text .= "IPN POST Vars from Paypal:\n";
				foreach (self::$ipn_data as $key=>$value) {
					$text .= "$key=$value, ";
				}

				// Log the response from the paypal server
				$text .= "\nIPN Response from Paypal Server:\n ".self::$ipn_response;
				// Write to log
				$fp=fopen(self::$ipn_log_file,'a');
				fwrite($fp, $text . "\n\n");
				fclose($fp);  // close file
			}
			*/
		}
	}//end else of paralel payment
}
