<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko (vlados.vp1@gmail.com)
* @license GNU General Public License version 2 or later;
* @description Ordasoft Image Gallery
*/


// No direct access to this file
defined('_JEXEC') or die('Restricted access');
global $os_gallery_configuration;
// Set some global property
$document = JFactory::getDocument();

//include needed style
$document->addStyleSheet(JURI::base() . "components/com_osgallery/assets/css/admin.css");
//include icons
$document->addStyleSheet("//fonts.googleapis.com/icon?family=Material+Icons");

// Access check: is this user allowed to access the backend of this component?
if (!JFactory::getUser()->authorise('core.manage', 'com_osgallery'))
{
    return JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'warning');
    
}

// require helper file
require_once(JPATH_COMPONENT . '/helpers/GifFrameExtractor.php');
require_once(JPATH_COMPONENT . '/helpers/GifCreator.php');
require_once(JPATH_COMPONENT . '/helpers/ImageWorkshop.php');
JLoader::register('osGalleryHelperAdmin', JPATH_COMPONENT . '/helpers/osGalleryHelperAdmin.php');

$GLOBALS['gl_state'] = $gl_state = osGalleryHelperAdmin::checkActivation() ;
$os_gallery_configuration = JComponentHelper::getParams('com_osgallery');

// Perform the Request task
$input = JFactory::getApplication()->input;
$task = $input->getCmd('task', '');
$galId = $input->getCmd('galId', '');
// print_r($task);exit;
switch ($task) {
    case "upload_images":
        osGalleryHelperAdmin::uploadImages();
        break;

    case "upload_folder":
        osGalleryHelperAdmin::getImageFromFolder();
        break;   

    case "upload_zip":
        osGalleryHelperAdmin::getImageFromZip();
        break;   

    case "new_gallery":
        osGalleryHelperAdmin::displayGallery(0);
        break;

    case "clone_gallery":
        osGalleryHelperAdmin::cloneGallery($galId, $input->getCmd('with_image', 0));
        break;

    case "unpublish":
        osGalleryHelperAdmin::published($galId, 0);
        break;

    case "publish":
        osGalleryHelperAdmin::published($galId, 1);
        break;

    case "delete_gallery":
        osGalleryHelperAdmin::deleteGallery($galId);
        break;

    case "edit_gallery":
        osGalleryHelperAdmin::displayGallery($galId);
        break;

    case "save_gallery":
        osGalleryHelperAdmin::saveGallery(false);
        break;

    case "save_close_galery":
        osGalleryHelperAdmin::saveGallery(true);
        break;
    case "save_watermark":
        osGalleryHelperAdmin::saveWatermark($galId);
        break;

    case "set_app_license":
        $data = $input->get('data', '', 'string');
        osGalleryHelperAdmin::setAppLicense($data);
        break ;

    case "check_gallery_state":
        $state = osGalleryHelperAdmin::checkGalleryState();
        print_r($state);exit();
        break ;

    case "update_osgallery":
        osGalleryHelperAdmin::updateOSGallery();
        break ;

    case "close_gallery":
    default:
        osGalleryHelperAdmin::displayDefault();
        break;
}


