<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko (vlados.vp1@gmail.com)
* @license GNU General Public License version 2 or later;
* @description Ordasoft Image Gallery
*/

// No direct access to this file
defined('_JEXEC') or die('Restricted Access');
?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
    <div id="galleries-block">
        <div class="galleries-header">
            <span class="span1 col-1">
                <input type="checkbox" name="checkall-toggle" value=""
                       title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
            </span>
            <span class="span1 col-2"><?php echo JText::_("COM_OSGALLERY_LIST_HEADER_ID"); ?></span>
            <span class="span4 col-3"><?php echo JText::_("COM_OSGALLERY_LIST_HEADER_TILE"); ?></span>
            <span class="span3 col-4"><?php echo JText::_("COM_OSGALLERY_LIST_HEADER_PUBLISHED"); ?></span>
            <span class="span3 col-5 short-code"><?php echo JText::_("COM_OSGALLERY_LIST_HEADER_SHORT_CODE");  ?>
                <span class="short-code-tooltip">
                <?php echo JText::_("COM_OSGALLERY_YOU_CAN_COPY_THIS_SHORTCODE"); ?>
                </span>
                <i class="material-icons">help_outline</i>
            </span>
        </div>
        <?php
        if($galleries){
            foreach ($galleries as $i => $gallery) {
                $canChange  = $user->authorise('core.edit.state', 'com_osgallery');
                ?>
                <div class="gallery-block">
                    <span class="span1 col-1">
                        <?php echo JHtml::_('grid.id', $i, $gallery->id, false, 'galId'); ?>
                    </span>
                    <span class="span1 col-2">
                        <?php
                        if (JFactory::getUser()->authorise('core.edit', 'com_bagallery')) {
                        ?>
                        <a href="index.php?option=com_osgallery&task=edit_gallery&galId=<?php echo $gallery->id?>" class="editable-title">
                            <?php echo $gallery->id; ?>
                        </a>
                        <?php
                        }else{
                            echo $gallery->id;
                        }?>
                    </span>
                    <span class="span4 col-3">
                        <?php
                        if (JFactory::getUser()->authorise('core.edit', 'com_bagallery')) {
                        ?>
                        <a href="index.php?option=com_osgallery&task=edit_gallery&galId=<?php echo $gallery->id?>" class="editable-title">
                            <?php echo $gallery->title; ?>
                        </a>
                        <?php
                        }else{
                            echo $gallery->title;
                        }?>
                    </span>
                    <span class="span3 col-4">
                        <?php echo JHtml::_('jgrid.published', $gallery->published, $i, '', $canChange); ?>
                    </span>
                    <span class="span3 col-2">{os-gal-<?php echo $gallery->id?>}</span>
                </div>
            <?php
            }
        }?>
    </div>
    <input type="hidden" name="option" value="com_osgallery"/>
    <input type="hidden" name="boxchecked" value="0" />
    <input type="hidden" name="task" value="new_gallery"/>
    <input type="hidden" name="with_image" value="0"/>
</form>

<div id="confirm-modal" class="modal hide fade">
  <div class="modal-body">
    <p><?php echo JText::_("COM_OSGALLERY_YOU_WANT_CLONE_GALLERY"); ?></p>
  </div>
  <div class="modal-footer">
    <a id="with-image" href="#" class="btn"><?php echo JText::_("COM_OSGALLERY_WITH_IMAGE"); ?></a>
    <a id="no-image" href="#" class="btn btn-primary"><?php echo JText::_("COM_OSGALLERY_EMPTY_GALLERY"); ?></a>
  </div>
</div>

<div id="confirm-delete-modal" class="modal hide fade">
  <div class="modal-body">
    <p><?php echo JText::_("COM_OSGALLERY_DO_YOU_REALLY_WANT_TO_DELETE_GALLERY"); ?></p>
  </div>
  <div class="modal-footer">
    <a id="yes-delete" href="#" class="btn"><?php echo JText::_("COM_OSGALLERY_YES"); ?></a>
    <a id="no-delete" href="#" class="btn btn-primary"><?php echo JText::_("COM_OSGALLERY_NO"); ?></a>
  </div>
</div>

<!-- about form  start-->
<div id="ordasoft-notification">
    <p></p>
</div>
<div id="about-modal" class="ordasoft-dashboard-apps-dialog  ordasoft-dashboard-about modal hide fade">
  <div class="modal-body">
    <div class="about-image">
        <img src="<?php echo JURI::base().'components/com_osgallery/assets/images/os-image-gallery.png'?>" alt="OS Gallery">
    </div>
  </div>
  <div class="modal-footer">
        <span class="span3">
            <div class="about-col-1"><?php echo JText::_("COM_OSGALLERY_VERSION")?></div><span id="gallery-version" class="about-col-2"><?php echo $galV.' Pro'?></span>
        </span>
        <span class="span3">
            <div class="about-col-1"><?php echo JText::_("COM_OSGALLERY_CREATION_DATE")?></div><span id="gallery-version" class="about-col-2"><?php echo $creationDate?></span>
        </span>
    <?php if(!osGalleryHelperAdmin::checkActivationNeed() &&  $avaibleUpdate ){?>
        <span class="span3">
                <div class="about-col-1 new-version"><?php echo JText::_("COM_OSGALLERY_NEW_VERSION_OF_GALLERY_AVAIBLE")?> <span class="version-osgallery"><?php echo $ordasoftGalV; ?></span></div><a class="update-link dashboard-link-action" href="#" ><?php 
                echo JText::_('COM_OSGALLERY_UPDATE'); ?></a>
        </span>
    <?php }else if( osGalleryHelperAdmin::$tag == "free" &&  $avaibleUpdate  ) {?>
        <span class="span3">
                <div class="about-col-1 new-version"><?php echo JText::_("COM_OSGALLERY_NEW_VERSION_OF_GALLERY_AVAIBLE")?> <span class="version-osgallery"><?php echo $ordasoftGalV; ?></span></div>
        </span>
    <?php }?>
        <span class="span3">

<?php
    if ( osGalleryHelperAdmin::checkVersionProFree() == 'pro') {
        $need_activation = osGalleryHelperAdmin::checkActivationNeed();

?>
<link rel="stylesheet" type="text/css" href="<?php echo JUri::root(); ?>administrator/components/com_osgallery/assets/css/os-about.css">

<script type="text/javascript">
var JUri = '<?php echo JUri::root(); ?>';
</script>
<script src="<?php echo JUri::root(); ?>administrator/components/com_osgallery/assets/js/os-about.js"></script>

        <div class="forms-deactivate-license"
            <?php echo !($need_activation) ? '' : 'style="display:none;"'; ?>>
            <i class="zmdi zmdi-shield-check"></i>
            <span><?php echo JText::_('COM_OSGALLERY_SUCCESSFULY_ACTIVATED'); ?></span><br />
            <a class="deactivate-link dashboard-link-action" href="#"><?php echo JText::_('COM_OSGALLERY_DEACTIVATE'); ?></a>
        </div>
        <div class="forms-activate-license"
            <?php echo ($need_activation) ? '' : 'style="display:none;"'; ?>>
            <i class="zmdi zmdi-shield-check"></i>
            <span><?php echo JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE'); ?></span><br />
            <a class="activate-link dashboard-link-action" href="#"><?php echo JText::_('COM_OSGALLERY_ACTIVATE'); ?></a>
        </div>
<?php
    }
?>

        </span>

        <span class="span12 submit-close">
            <button class="btn" data-dismiss="modal" aria-hidden="true"><?php echo JText::_('COM_OSGALLERY_CLOSE') ?></button>
        </span>
     
  </div>
</div>
<div id="deactivate-dialog" class="ordasoft-modal-sm modal hide" style="display:none">
    <div class="modal-body">
        <h3><?php echo JText::_('COM_OSGALLERY_LICENSE_DEACTIVATION'); ?></h3>
        <p class="modal-text can-delete"><?php echo JText::_('COM_OSGALLERY_ARE_YOU_SURE_DEACTIVATE') ?></p>
    </div>
    <div class="modal-footer">
        <a href="#" class="ordasoft-btn" data-dismiss="modal">
            <?php echo JText::_('COM_OSGALLERY_CANCEL') ?>
        </a>
        <a href="#" class="ordasoft-btn-primary red-btn" id="apply-deactivate">
            <?php echo JText::_('COM_OSGALLERY_APPLY') ?>
        </a>
    </div>
</div>
<div id="login-modal" class="ordasoft-modal-sm modal hide" aria-hidden="true" style="display: none;">
    <div class="modal-body">
        
    </div>
</div>

<script>
    window.addEventListener('load', function() {
        Joomla.submitbutton = function(pressbutton) {
            document.adminForm.task.value = pressbutton;
            if(pressbutton == 'clone_gallery'){
                jQuery("#confirm-modal").modal('show');
                jQuery("#with-image").click(function(event) {
                    document.adminForm.with_image.value = 1;
                    jQuery("#confirm-modal").modal('hide');
                    document.adminForm.submit();
                });

                jQuery("#no-image").click(function(event) {
                    document.adminForm.with_image.value = 0;
                    jQuery("#confirm-modal").modal('hide');
                    document.adminForm.submit();
                });
                return;
            }if(pressbutton == 'delete_gallery'){
                jQuery("#confirm-delete-modal").modal('show');
                jQuery("#yes-delete").click(function(event) {
                    jQuery("#confirm-delete-modal").modal('hide');
                    document.adminForm.submit();
                });

                jQuery("#no-delete").click(function(event) {
                    jQuery("#confirm-delete-modal").modal('hide');
                    return;
                });
                return;
            }else if(pressbutton == "about_gallery"){
                jQuery("#about-modal").modal('show');
                return;
            }else{
                document.adminForm.submit();
            }
        }
    })
    function listItemTask(id, task, frmName){
        var form = document.adminForm;
        cb = eval( id );
        if (cb) {
            cb.checked = true;
            form.task.value = task;
            form.submit();
        }
        return false;
    }

    window.addEventListener('load', function() {
        setTimeout(function(){
            jQuery("#system-message-container").empty();
        }, 3000);
    });
</script>