<?php

defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class os_cckDb
{

  public $_db = false;
  
  function __construct()
  {
    if(defined('_JEXEC')){
      $this->_db = JFactory::getDBO();
    }

  }

  public function setQuery($query){
    if(defined('_JEXEC')){
      $return = $this->_db->setQuery($query);
      return $return;
    }
  }

  public function execute(){
    if(defined('_JEXEC')){
      $return = $this->_db->execute();
      return $return;
    }
  }

  public function getPrefix(){
    if(defined('_JEXEC')){
      $return = $this->_db->getPrefix();
      return $return;
    }
  }

  public function getQuery(){
    if(defined('_JEXEC')){
      $return = $this->_db->getQuery();
      return $return;
    }
  }

  
  public function insertObject($table, $object, $key = null){
    if(defined('_JEXEC')){
      $return = $this->_db->insertObject($table, $object, $key);
      return $return;
    }
  }
  
  public function loadAssoc(){
    if(defined('_JEXEC')){
      $return = $this->_db->loadAssoc();
      return $return;
    }
  }

  public function loadAssocList($key = null, $column = null){
    if(defined('_JEXEC')){
      $return = $this->_db->loadAssocList($key, $column);
      return $return;
    }
  }

  public function loadColumn(){
    if(defined('_JEXEC')){
      $return = $this->_db->loadColumn();
      return $return;
    }
  }

  public function loadObject($class = false){
    if(defined('_JEXEC')){
      if($class){
          $return = $this->_db->loadObject($class);
      }else{
          $return = $this->_db->loadObject();
      }
      return $return;
    }
  }

  public function loadObjectList($key = '', $class = false){
    if(defined('_JEXEC')){
      // try{
        if($class){
          $return = $this->_db->loadObjectList($key, $class);
        }else{
          $return = $this->_db->loadObjectList($key);
        }
      // }catch(Exception $ex){
      //   var_dump($key);
      //   exit;
      // }
      return $return;
    }
  }
  
  public function loadResult(){
    if(defined('_JEXEC')){
      $return = $this->_db->loadResult();
      return $return;
    }
  }

  public function loadRow(){
    if(defined('_JEXEC')){
      $return = $this->_db->loadRow();
      return $return;
    }
  }

  public function loadRowList($key = false){
    if(defined('_JEXEC')){
      if($key !== false){  
          $return = $this->_db->loadRowList($key);
      }else{
          $return = $this->_db->loadRowList();
      }
      return $return;
    }
  }

  public function q($text, $escape = true){
    if(defined('_JEXEC')){
      $return = $this->_db->quote($text, $escape);
      return $return;
    }
  }

  public function quote($text, $escape = true){
    if(defined('_JEXEC')){
      $return = $this->_db->quote($text, $escape);
      return $return;
    }
  }

  public function quoteName($name, $as = null){
    if(defined('_JEXEC')){
      $return = $this->_db->quoteName($name, $as);
      return $return;
    }
  }

  public function qn($name, $as = null){
    if(defined('_JEXEC')){
      $return = $this->_db->quoteName($name, $as);
      return $return;
    }
  }

  public function splitSql($sql){
    if(defined('_JEXEC')){
      $return = $this->_db->splitSql($sql);
      return $return;
    }
  }

  public function updateObject($table, $object, $key, $nulls = false){
    if(defined('_JEXEC')){
      $return = $this->_db->updateObject($table, $object, $key, $nulls);
      return $return;
    }
  }

  public function escape($text, $extra=false){
    if(defined('_JEXEC')){
      $return = $this->_db->escape($text, $extra);
      return $return;
    }
  }

  public function insertid(){
    if(defined('_JEXEC')){
      $return = $this->_db->insertid();
      return $return;
    }
  }

}


