
/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 3.2.2
  * @author Adam Chaboryk
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2024 Toronto Metropolitan University.
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
/*! WARNING: This is a machine-generated translation and may contain errors or inaccuracies. */
var nl = {
  // Dutch
  strings: {
    LANG_CODE: 'nl',
    MAIN_TOGGLE_LABEL: 'Toegankelijkheid controleren',
    CONTAINER_LABEL: 'Toegankelijkheidscontrole',
    ERROR: 'Fout',
    ERRORS: 'Fouten',
    WARNING: 'Waarschuwing',
    WARNINGS: 'Waarschuwingen',
    GOOD: 'Goed',
    ON: 'Op',
    OFF: 'Uit',
    ALERT_TEXT: 'Waarschuwing',
    ALERT_CLOSE: 'Sluit',
    OUTLINE: 'Overzicht',
    TITLE: 'Titel',
    ALT: 'ALT',
    IMAGES: 'Afbeeldingen',
    EDIT: 'Bewerken',
    IMAGES_NOT_FOUND: 'Geen afbeeldingen gevonden.',
    DECORATIVE: 'Decoratief',
    MISSING: 'Ontbrekend',
    PAGE_ISSUES: 'Pagina problemen',
    SETTINGS: 'Instellingen',
    CONTRAST: 'Contrast',
    FORM_LABELS: 'Formulier labels',
    LINKS_ADVANCED: 'Koppelingen (geavanceerd)',
    DARK_MODE: 'Donkere modus',
    SHORTCUT_SCREEN_READER: 'Naar uitgave gaan. Sneltoets: Alt S',
    SHORTCUT_TOOLTIP: 'Doorgaan naar uitgave',
    NEW_TAB: 'Opent nieuw tabblad',
    LINKED: 'Gekoppeld',
    PANEL_HEADING: 'Toegankelijkheid controleren',
    PANEL_STATUS_NONE: 'Geen fouten gevonden.',
    PANEL_ICON_WARNINGS: 'waarschuwingen gevonden.',
    PANEL_ICON_TOTAL: 'totaal aantal gevonden problemen.',
    NOT_VISIBLE_ALERT: 'Het item dat je probeert te bekijken is niet zichtbaar; het kan verborgen zijn of in een accordeon of tabbladcomponent zitten. Hier is een voorbeeld:',
    ERROR_MISSING_ROOT_TARGET: 'De volledige pagina is gecontroleerd op toegankelijkheid omdat het doelgebied <code>%(root)</code> niet bestaat.',
    HEADING_NOT_VISIBLE_ALERT: 'De kop is niet zichtbaar; hij kan verborgen zijn of in een accordeon- of tabbladcomponent staan.',
    SKIP_TO_PAGE_ISSUES: 'Doorgaan naar paginanummers',
    CONSOLE_ERROR_MESSAGE: 'Sorry, maar er is een probleem met de toegankelijkheidscontrole op deze pagina. Kunt u dit alstublieft <a href="%(link)">melden via dit formulier</a> of op <a href="%(link)">GitHub</a>?',

    // Dismiss
    PANEL_DISMISS_BUTTON: 'Toon %(dismissCount) afgewezen waarschuwingen',
    DISMISS: 'Ontsla',
    DISMISSED: 'Afgewezen waarschuwingen',
    DISMISS_REMINDER: "Let op: waarschuwingen worden alleen <strong>tijdelijk</strong> genegeerd. Als u uw browsergeschiedenis en cookies wist, worden alle eerder afgewezen waarschuwingen op alle pagina's hersteld.",

    // Export
    DATE: 'Datum',
    PAGE_TITLE: 'Paginatitel',
    RESULTS: 'Resultaten',
    EXPORT_RESULTS: 'Resultaten exporteren',
    GENERATED: 'Resultaten gegenereerd met %(tool).',
    PREVIEW: 'Voorbeeld',
    ELEMENT: 'Element',
    PATH: 'Pad',

    // Colour filters
    COLOUR_FILTER: 'Kleurenfilter',
    PROTANOPIA: 'Protanopia',
    DEUTERANOPIA: 'Deuteranopia',
    TRITANOPIA: 'Tritanopia',
    MONOCHROMACY: 'Monochromie',
    COLOUR_FILTER_MESSAGE: 'Controleer op elementen die moeilijk zijn waar te nemen of te onderscheiden van andere kleuren.',
    RED_EYE: 'Blind rood.',
    GREEN_EYE: 'Green blind.',
    BLUE_EYE: 'Blauwe jaloezie.',
    MONO_EYE: 'Blind rood, blauw en groen.',
    COLOUR_FILTER_HIGH_CONTRAST_MESSAGE: 'Kleurenfilters werken niet in de modus Hoog contrast.',

    // Alternative text stop words
    SUSPICIOUS_ALT_STOPWORDS: [
      'afbeelding',
      'grafisch',
      'foto',
      'photo',
      'image',
      'graphic',
    ],
    PLACEHOLDER_ALT_STOPWORDS: [
      'alt',
      'afbeelding',
      'foto',
      'decoratief',
      'photo',
      'image',
      'graphic',
      'placeholder',
      'plaatshouderafbeelding',
      'afstandhouder',
    ],
    PARTIAL_ALT_STOPWORDS: [
      'klik op',
      'klik hier',
      'klik hier voor meer',
      'klik hier voor meer informatie',
      'hier klikken',
      'door hier te klikken',
      'uitchecken',
      'hier gedetailleerd',
      'downloaden',
      'hier downloaden',
      'te weten komen',
      'meer informatie',
      'kom meer te weten',
      'meer weten',
      'formulier',
      'hier',
      'info',
      'informatie',
      'link',
      'leren',
      'meer leren',
      'meer informatie',
      'meer weten',
      'leren',
      'meer',
      'pagina',
      'papier',
      'meer lezen',
      'lees meer',
      'lees',
      'lees dit',
      'deze',
      'deze pagina',
      'deze website',
      'bekijk',
      'bekijk onze',
      'website',
    ],
    WARNING_ALT_STOPWORDS: [
      'klik hier',
    ],
    NEW_WINDOW_PHRASES: [
      'extern',
      'nieuw tabblad',
      'nieuw venster',
      'pop-up',
      'verschijnen',
    ],
    FILE_TYPE_PHRASES: ['document', 'rekenblad', 'rekenblad', 'gecomprimeerd bestand', 'gearchiveerd bestand', 'werkblad', 'powerpoint', 'presentatie', 'installeren', 'video', 'audio', 'pdf'],
    LANG_READABILITY: 'Leesbaarheid',
    LANG_AVG_SENTENCE: 'Gemiddeld aantal woorden per zin:',
    LANG_COMPLEX_WORDS: 'Complexe woorden:',
    LANG_TOTAL_WORDS: 'Woorden:',
    LANG_VERY_DIFFICULT: 'Zeer moeilijk',
    LANG_DIFFICULT: 'Moeilijk',
    LANG_FAIRLY_DIFFICULT: 'Redelijk moeilijk',
    LANG_GOOD: 'Goed',
    READABILITY_NO_P_OR_LI_MESSAGE: 'Kan de leesbaarheidsscore niet berekenen. Geen paragraaf <code>&lt;p&gt;</code> of lijstinhoud <code>&lt;li&gt;</code> gevonden.',
    READABILITY_NOT_ENOUGH_CONTENT_MESSAGE: 'Niet genoeg inhoud om een leesbaarheidsscore te berekenen.',
    HEADING_NON_CONSECUTIVE_LEVEL: 'Niet-opeenvolgend rubriekniveau gebruikt. Koppen mogen nooit niveaus overslaan of van <strong>Kop %(prevLevel)</strong> naar <strong {r}>Kop %(level)</strong> gaan.',
    HEADING_EMPTY: 'Lege koptekst gevonden! Om dit op te lossen, verwijdert u deze regel of wijzigt u de opmaak van <strong {r}>Heading %(level)</strong> in <strong>Normal</strong> of <strong>Paragraph</strong>.',
    HEADING_LONG: 'Koppen zijn lang! Koppen moeten worden gebruikt om inhoud te organiseren en structuur over te brengen. Ze moeten kort, informatief en uniek zijn. Houd koppen onder de 160 tekens (niet meer dan een zin). <hr> <strong {B}>%(HEADING_LENGTH) Tekens</strong>',
    HEADING_FIRST: 'De eerste kop op een pagina moet meestal een Kop 1 of Kop 2 zijn. Kop 1 moet het begin zijn van het hoofdgedeelte van de inhoud en is de belangrijkste kop die het algemene doel van de pagina beschrijft. Meer informatie over <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Kopjesstructuur.</a>',
    HEADING_MISSING_ONE: 'Ontbrekende kop 1. Kop 1 moet het begin zijn van het hoofdgedeelte van de inhoud en is de belangrijkste kop die het algemene doel van de pagina beschrijft. Meer informatie over <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/">Kopjesstructuur.</a>',
    HEADING_EMPTY_WITH_IMAGE: 'Een kop heeft geen tekst, maar bevat een afbeelding. Als dit geen koptekst is, verander de opmaak dan van <strong {r}>Koptekst %(level)</strong> in <strong>Normaal</strong> of <strong>Paragraaf</strong>. Voeg anders alt-tekst toe aan de afbeelding als deze niet decoratief is.',
    PANEL_HEADING_MISSING_ONE: 'Rubriek 1 ontbreekt!',
    PANEL_NO_HEADINGS: 'Geen koppen gevonden.',
    LINK_EMPTY: 'Verwijder lege links zonder tekst.',
    LINK_EMPTY_LABELLEDBY: 'De link heeft een waarde voor <code>aria-labelledby</code> die leeg is of niet overeenkomt met de waarde van het attribuut <code>id</code> van een ander element op de pagina.',
    LINK_EMPTY_LINK_NO_LABEL: 'Link heeft geen leesbare tekst die zichtbaar is voor schermlezers en andere ondersteunende technologie. Op te lossen: <ul><li>Voeg beknopte tekst toe die beschrijft waar de koppeling naartoe leidt.</li><li>Als het een <a href="https://a11y-101.com/development/icons-and-links">icon link of SVG,</a> is, ontbreekt waarschijnlijk een beschrijvend label.</li><li>Als u denkt dat deze koppeling een fout is als gevolg van een copy/paste-bug, kunt u overwegen deze te verwijderen.</li></ul>',
    LINK_LABEL: '<strong {B}>Linklabel</strong> %(TEXT)',
    LINK_STOPWORD: 'Linktekst is mogelijk niet beschrijvend genoeg buiten de context: <strong {r}>%(ERROR)</strong> <hr> <strong>Tip!</strong> Linktekst moet altijd duidelijk, uniek en betekenisvol zijn. Vermijd veelgebruikte woorden zoals &quot;klik hier&quot; of &quot;leer meer&quot;',
    LINK_BEST_PRACTICES: 'Overweeg om de tekst van de koppeling te vervangen: <strong {W}>%(ERROR)</strong> <hr> <ul><li>&quot;Klik hier&quot; legt de nadruk op muismechanica, terwijl veel mensen geen muis gebruiken of deze website mogelijk bekijken op een mobiel apparaat. Overweeg het gebruik van een ander werkwoord dat betrekking heeft op de taak.</li><li>Vermijd het gebruik van HTML-symbolen als oproep tot actie, tenzij deze verborgen zijn voor ondersteunende technologieën.</li></ul>',
    LINK_URL: "Langere, minder begrijpelijke URL's die gebruikt worden als linktekst kunnen moeilijk te begrijpen zijn met hulptechnologie. In de meeste gevallen is het beter om menselijk leesbare tekst te gebruiken in plaats van de URL. Korte URL's (zoals de startpagina van een site) zijn prima. <hr> <strong>Tip!</strong> Linktekst moet altijd duidelijk, uniek en betekenisvol zijn, zodat deze ook buiten de context kan worden begrepen.",
    LINK_DOI: 'Voor webpagina\'s of online bronnen raadt de <a href="https://apastyle.apa.org/style-grammar-guidelines/paper-format/accessibility/urls#:~:text=descriptive%20links">APA stijlgids</a> aan om beschrijvende links te gebruiken door de URL of DOI van het werk rond de titel te plaatsen. Langere, minder begrijpelijke URL\'s die gebruikt worden als linktekst kunnen moeilijk te begrijpen zijn met hulptechnologie.',
    NEW_TAB_WARNING: 'Link opent in een nieuw tabblad of venster zonder waarschuwing. Dit kan desoriënterend zijn, vooral voor mensen die moeite hebben met het waarnemen van visuele inhoud. Ten tweede is het niet altijd een goede gewoonte om iemands ervaring te controleren of beslissingen voor hem te nemen. Geef in de tekst van de koppeling aan dat deze in een nieuw venster wordt geopend. <hr> <strong>Tip!</strong> Leer de beste werkwijzen: <a href="https://www.nngroup.com/articles/new-browser-windows-and-tabs/">links openen in nieuwe browservensters en tabbladen.</a>',
    FILE_TYPE_WARNING: 'Link verwijst naar een PDF of downloadbaar bestand (bijv. MP3, Zip, Word Doc) zonder waarschuwing. Vermeld het bestandstype in de linktekst. Als het een groot bestand is, kun je overwegen de bestandsgrootte te vermelden. <hr> <strong>Voorbeeld:</strong> Uitvoerend rapport (PDF, 3 MB)',
    LINK_IDENTICAL_NAME: 'Link heeft dezelfde tekst als een andere link, maar verwijst naar een andere pagina. Meerdere links met dezelfde tekst kunnen verwarring veroorzaken voor mensen die schermlezers gebruiken. <hr> Overweeg om de volgende link beschrijvender te maken om hem te helpen onderscheiden van andere links: <strong {W}>%(TEXT)</strong>',
    MISSING_ALT_LINK_BUT_HAS_TEXT_MESSAGE: 'Afbeelding wordt gebruikt als een link met omringende tekst, hoewel het alt-attribuut als decoratief of null moet worden gemarkeerd.',
    MISSING_ALT_LINK_MESSAGE: 'Afbeelding wordt gebruikt als link maar alt-tekst ontbreekt! Zorg ervoor dat de alt-tekst beschrijft waar de link naartoe leidt.',
    MISSING_ALT_MESSAGE: 'Ontbrekende alt-tekst! Als de afbeelding een verhaal, sfeer of belangrijke informatie overbrengt, zorg er dan voor dat je de afbeelding beschrijft.',
    LINK_ALT_HAS_FILE_EXTENSION: 'Bestandsextensie in de alt-tekst gevonden. Zorg ervoor dat de alt-tekst de bestemming van de link beschrijft en niet een letterlijke beschrijving van de afbeelding. Verwijderen: <strong {r}>%(ERROR)</strong>. <hr> {ALT} {L} <strong {r}>%(ALT_TEXT)</strong>',
    LINK_IMAGE_PLACEHOLDER_ALT_MESSAGE: 'Niet-beschrijvende of plaatsvervangende alt-tekst binnen een gekoppelde afbeelding gevonden. Zorg ervoor dat de alt-tekst de bestemming van de link beschrijft en niet een letterlijke beschrijving van de afbeelding. Vervang de volgende alt-tekst. <hr> {ALT} {L} <strong {r}>%(ALT_TEXT)</strong>',
    LINK_IMAGE_SUS_ALT_MESSAGE: 'Hulptechnologieën geven al aan dat het om een afbeelding gaat, dus &quot;<strong {W}>%(ERROR)</strong>&quot; kan overbodig zijn. Zorg ervoor dat de alt-tekst de bestemming van de link beschrijft en niet een letterlijke beschrijving van de afbeelding. <hr> {ALT} {L} <strong {W}>%(ALT_TEXT)</strong>',
    ALT_HAS_FILE_EXTENSION: 'Bestandsextensie in de gevonden alt-tekst. Als de afbeelding een verhaal, stemming of belangrijke informatie overbrengt, zorg er dan voor dat je de afbeelding beschrijft. Verwijderen: <strong {r}>%(ERROR)</strong> <hr> {ALT} <strong {r}>%(ALT_TEXT)</strong>',
    ALT_PLACEHOLDER_MESSAGE: 'Niet-beschrijvende of plaatshouder alt-tekst gevonden. Vervang de volgende alt-tekst door iets dat meer betekenis heeft. <hr> {ALT} <strong {r}>%(ALT_TEXT)</strong>',
    ALT_HAS_SUS_WORD: 'Hulptechnologieën geven al aan dat dit een afbeelding is, dus &quot;<strong {W}>%(ERROR)</strong>&quot; kan overbodig zijn. <hr> {ALT} <strong {W}>%(ALT_TEXT)</strong>',
    LINK_HIDDEN_FOCUSABLE: 'De link heeft <code>aria-hidden=&quot;true&quot;</code>, maar is nog steeds toegankelijk met het toetsenbord. Als je van plan bent om een overbodige of dubbele link te verbergen, voeg dan ook <code>tabindex=&quot;-1&quot;</code> toe.',
    LINK_IMAGE_NO_ALT_TEXT: 'De afbeelding in de link is gemarkeerd als decoratief en er is geen linktekst. Voeg alt-tekst toe aan de afbeelding die de bestemming van de link beschrijft.',
    LINK_IMAGE_HAS_TEXT: 'Afbeelding is gemarkeerd als decoratief, hoewel de link de omringende tekst gebruikt als beschrijvend label.',
    LINK_IMAGE_LONG_ALT: 'Alt-tekstbeschrijving op een gekoppelde afbeelding is <strong>te lang</strong>. De alt-tekst op gelinkte afbeeldingen moet beschrijven waar de link je naartoe brengt, niet een letterlijke beschrijving van de afbeelding. <strong>Overweeg om de titel van de pagina waarnaar wordt gelinkt als alt-tekst te gebruiken.</strong> <hr> {ALT} {L} <strong {B}>%(altLength) Tekens</strong> <strong {W}>%(ALT_TEXT)</strong>',
    LINK_IMAGE_ALT_WARNING: 'De link naar de afbeelding bevat alt-tekst. <strong>Beschrijft de alt-tekst waar de link je naartoe brengt?</strong> Overweeg om de titel van de pagina waarnaar wordt gelinkt als alt-tekst te gebruiken. <hr> {ALT} {L} <strong {W}>%(ALT_TEXT)</strong>',
    LINK_IMAGE_ALT_AND_TEXT_WARNING: 'Als deze afbeelding decoratief is en wordt gebruikt als een functionele link naar een andere pagina, overweeg dan om de afbeelding als decoratief of null te markeren - de omringende linktekst zou moeten volstaan. <hr> {ALT} <strong {W}>%(ALT_TEXT)</strong> <hr> <strong {B}>Linklabel</strong> {L} <strong {W}>%(TEXT)</strong>',
    IMAGE_FIGURE_DECORATIVE: 'Afbeelding is gemarkeerd als <strong>decoratief</strong> en wordt genegeerd door ondersteunende technologie. <hr> Hoewel er een <strong>bijschrift</strong> is opgegeven, moet de afbeelding in de meeste gevallen ook een alt-tekst hebben. <ul><li>De alt-tekst moet een beknopte beschrijving geven van wat er in de afbeelding staat.</li><li>Het bijschrift moet meestal context bieden om de afbeelding te relateren aan de omringende inhoud, of de aandacht vestigen op een bepaald stukje informatie.</li></ul> Lees meer: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a>',
    IMAGE_FIGURE_DUPLICATE_ALT: 'Gebruik niet exact dezelfde woorden voor zowel de alt- als bijschrifttekst. Schermlezers zullen de informatie twee keer aankondigen. <ul><li>De alt-tekst moet een beknopte beschrijving geven van wat er in de afbeelding staat.</li><li>Het bijschrift moet meestal context bieden om de afbeelding te relateren aan de omringende inhoud, of de aandacht vestigen op een bepaald stukje informatie.</li></ul> Meer informatie: <a href="https://thoughtbot.com/blog/alt-vs-figcaption#the-figcaption-element">alt versus figcaption.</a> <hr> {ALT} <strong {W}>%(ALT_TEXT)</strong>',
    IMAGE_DECORATIVE: 'De afbeelding is gemarkeerd als <strong>decoratief</strong> en wordt genegeerd door ondersteunende technologie. Als de afbeelding een verhaal, stemming of belangrijke informatie overbrengt, voeg dan alt-tekst toe.',
    IMAGE_ALT_TOO_LONG: 'Alt-tekstbeschrijving is <strong>te lang</strong>. Alt-tekst moet beknopt zijn, maar toch betekenisvol, zoals een <em>tweet</em> (ongeveer 100 tekens). Als dit een complexe afbeelding of een grafiek is, overweeg dan om de lange beschrijving van de afbeelding in de tekst eronder te zetten of in een accordeoncomponent. <hr> {ALT} <strong {B}>%(altLength) Tekens</strong> <strong {W}>%(ALT_TEXT)</strong>',
    IMAGE_PASS: '{ALT} %(ALT_TEXT)',
    LABELS_MISSING_IMAGE_INPUT_MESSAGE: 'Bij de afbeeldingsknop ontbreekt alt-tekst. Voeg alt-tekst toe om een toegankelijke naam te geven. Bijvoorbeeld: <em>Zoeken</em> of <em>Inzenden</em>.',
    LABELS_INPUT_RESET_MESSAGE: 'Resetknoppen moeten <strong>niet</strong> worden gebruikt tenzij ze specifiek nodig zijn, omdat ze gemakkelijk per ongeluk kunnen worden geactiveerd. <hr> <strong>Tip!</strong>Lees waarom <a href="https://www.nngroup.com/articles/reset-and-cancel-buttons/">Reset- en annuleerknoppen bruikbaarheidsproblemen opleveren.</a>',
    LABELS_ARIA_LABEL_INPUT_MESSAGE: 'De invoer heeft een toegankelijke naam, maar zorg ervoor dat er ook een zichtbaar label is. <hr> <strong {B}>Invoerlabel</strong> <strong {W}>%(TEXT)</strong>',
    LABELS_NO_FOR_ATTRIBUTE_MESSAGE: 'Er is geen label gekoppeld aan deze ingang. Voeg een <code>for</code>-attribuut toe aan het label dat overeenkomt met de <code>id</code> van deze ingang. <hr> De ID voor deze ingang is: <strong>id=&#34;%(id)&#34;</strong>',
    LABELS_MISSING_LABEL_MESSAGE: 'Er is geen label gekoppeld aan deze ingang. Voeg een <code>id</code> toe aan deze ingang en voeg een overeenkomend <code>for</code> attribuut toe aan het label.',
    EMBED_VIDEO: "Zorg ervoor dat <strong>alle video's zijn voorzien van ondertiteling.</strong> Het leveren van ondertiteling voor alle audio- en video-inhoud is een verplichte Level A-vereiste. Ondertiteling ondersteunt mensen die doof of slechthorend zijn.",
    EMBED_AUDIO: 'Zorg voor een <strong>transcript voor alle podcasts.</strong> Het leveren van transcripts voor audio-inhoud is een verplichte Level A-vereiste. Transcripties ondersteunen mensen die doof of slechthorend zijn, maar iedereen kan er baat bij hebben. Overweeg om het transcript onder of in een accordeonpaneel te plaatsen.',
    EMBED_DATA_VIZ: 'Widgets voor gegevensvisualisatie zoals deze zijn vaak problematisch voor mensen die een toetsenbord of schermlezer gebruiken om te navigeren, en kunnen aanzienlijke problemen opleveren voor mensen met slechtziendheid of kleurenblindheid. Het is aan te raden om dezelfde informatie in een alternatieve (tekst of tabel) indeling onder de widget aan te bieden. <hr> Meer informatie over <a href="https://www.w3.org/WAI/tutorials/images/complex">complexe afbeeldingen.</a>',
    EMBED_MISSING_TITLE: 'Voor ingesloten inhoud is een toegankelijke naam nodig die de inhoud beschrijft. Geef een uniek <code>title</code> of <code>aria-label</code> attribuut op het <code>iframe</code> element. Meer informatie over <a href="https://web.dev/learn/accessibility/more-html#iframes">iFrames.</a>',
    EMBED_GENERAL_WARNING: 'Kan ingesloten inhoud niet controleren. Controleer of afbeeldingen alt-tekst hebben, video\'s bijschriften, tekst voldoende contrast en interactieve onderdelen <a href="https://webaim.org/techniques/keyboard/">toetsenbordtoegankelijk zijn.</a>',
    EMBED_UNFOCUSABLE: '<code>&lt;iframe&gt;</code> met niet-focusbare elementen mag geen <code>tabindex="-1"</code> hebben. De ingesloten inhoud zal niet toegankelijk zijn met het toetsenbord.',
    QA_BAD_LINK: 'Slechte link gevonden. Link lijkt te verwijzen naar een ontwikkelomgeving. <hr> Deze link verwijst naar: <br> <strong {r}>%(LINK)</strong>',
    QA_IN_PAGE_LINK: 'Gebroken koppeling naar dezelfde pagina. Het koppelingsdoel komt niet overeen met enig element op deze pagina.',
    QA_BAD_ITALICS: "Vetgedrukte en cursieve tags hebben een semantische betekenis en moeten <strong>niet</strong> worden gebruikt om hele alinea's te benadrukken. Vetgedrukte tekst moet worden gebruikt om een woord of zin sterk te <strong>accentueren</strong>. Cursief moet worden gebruikt om eigennamen (bijv. titels van boeken en artikelen), vreemde woorden en aanhalingstekens te benadrukken. Lange citaten moeten worden opgemaakt als een blokcitaat.",
    QA_PDF: 'Kan PDF\'s niet controleren op toegankelijkheid. PDF\'s worden beschouwd als webinhoud en moeten ook toegankelijk worden gemaakt. PDF\'s bevatten vaak problemen voor mensen die screenreaders gebruiken (ontbrekende structurele tags of ontbrekende labels voor formuliervelden) en mensen die slecht zien (tekst wordt niet weergegeven als deze wordt vergroot). <ul><li>Als dit een formulier is, kunt u overwegen een toegankelijk HTML-formulier te gebruiken als alternatief.</li><li>Als dit een document is, kunt u overwegen het te converteren naar een webpagina.</li></ul> Ofwel controleer <a href="https://helpx.adobe.com/acrobat/using/create-verify-pdf-accessibility.html">PDF op toegankelijkheid in Acrobat DC.</a>',
    QA_DOCUMENT: 'Kan document niet controleren op toegankelijkheid. Gekoppelde documenten worden beschouwd als webinhoud en moeten ook toegankelijk worden gemaakt. Controleer dit document handmatig. <ul><li>Maak uw <a href="https://support.google.com/docs/answer/6199477?hl=nl">Google Workspace-document of presentatie toegankelijker.</a></li><li>Maak uw <a href="https://support.microsoft.com/nl/office/create-accessible-office-documents-868ecfcd-4f00-4224-b881-a65537a7c155">Office-documenten toegankelijker.</a></li></ul>',
    QA_PAGE_LANGUAGE: 'Pagina taal niet aangegeven! Gelieve <a href="https://www.w3.org/International/questions/qa-html-language-declarations">declareer taal in HTML-tag.</a>',
    QA_PAGE_TITLE: 'Er ontbreekt een paginatitel! Geef een <a href="https://developer.mozilla.org/nl/docs/Web/HTML/Element/title">paginatitel.</a>',
    QA_BLOCKQUOTE_MESSAGE: 'Is dit een koptekst? <strong {W}>%(TEXT)</strong> <hr> Blokcitaten moeten alleen worden gebruikt voor citaten. Als dit bedoeld is als een koptekst, verander deze blokcitaat dan in een semantische koptekst (bijvoorbeeld koptekst 2 of koptekst 3).',
    QA_FAKE_HEADING: 'Is dit een koptekst? <strong {W}>%(TEXT)</strong> <hr> Een regel vette of grote tekst ziet er misschien uit als een kop, maar iemand die een schermlezer gebruikt, kan niet zien dat het belangrijk is of naar de inhoud springen. Vette of grote tekst mag nooit semantische koppen vervangen (Kop 2 tot en met Kop 6).',
    QA_SHOULD_BE_LIST: 'Probeer je een lijst te maken? Mogelijk lijstitem gevonden: <strong {W}>%(firstPrefix)</strong> <hr> Zorg ervoor dat je semantische lijsten gebruikt door in plaats daarvan de opsommingsteken- of nummeropmaakknoppen te gebruiken. Als je een semantische lijst gebruikt, kunnen hulptechnologieën informatie overbrengen zoals het totale aantal items en de relatieve positie van elk item in de lijst. Meer informatie over <a href="https://www.w3.org/WAI/tutorials/page-structure/content/#lists">semantische lijsten.</a>',
    QA_UPPERCASE_WARNING: 'Hoofdletters gevonden. Sommige schermlezers interpreteren tekst met allemaal hoofdletters als een acroniem en lezen elke letter apart. Bovendien vinden sommige mensen hoofdletters moeilijker te lezen en kan het lijken alsof ze schreeuwen.',
    QA_DUPLICATE_ID: '<strong>Duplicate ID</strong> gevonden. Het is bekend dat dubbele ID-fouten problemen veroorzaken voor hulptechnologieën wanneer deze proberen te communiceren met inhoud. <hr> Verwijder of wijzig de volgende ID: <strong {r}>%(id)</strong>',
    QA_TEXT_UNDERLINE_WARNING: 'Onderstreepte tekst kan worden verward met links. Overweeg een andere stijl te gebruiken, zoals <code>&lt;strong&gt;</code><strong>strong importance</strong><code>&lt;/strong&gt;</code> of <code>&lt;em&gt;</code><em>emphasis</em><code>&lt;/em&gt;</code>.',
    QA_SUBSCRIPT_WARNING: 'De opmaakopties subscript en superscript mogen alleen worden gebruikt om de positie van tekst te wijzigen voor typografische conventies of standaarden. Het moet <strong>niet</strong> alleen worden gebruikt voor presentatie of uiterlijk. Het formatteren van hele zinnen geeft problemen met de leesbaarheid. Voorbeelden van geschikte toepassingen zijn het weergeven van exponenten, rangtelwoorden zoals 4<sup>th</sup> in plaats van fourth, en chemische formules (bijv. H<sub>2</sub>O).',
    TABLES_MISSING_HEADINGS: 'Tabelkoppen ontbreken! Voor toegankelijke tabellen is HTML-markup nodig die kopcellen en gegevenscellen aangeeft en hun relatie definieert. Deze informatie geeft context aan mensen die ondersteunende technologie gebruiken. Tabellen moeten alleen worden gebruikt voor gegevens in tabelvorm. <hr> Lees meer over <a href="https://www.w3.org/WAI/tutorials/tables/">toegankelijke tabellen.</a>',
    TABLES_SEMANTIC_HEADING: 'Semantische koppen zoals Kop 2 of Kop 3 mogen alleen worden gebruikt voor gedeelten van de inhoud; <strong>niet</strong> in HTML-tabellen. Geef tabelkoppen aan met het <code>&lt;th&gt;</code>-element. <hr> Meer informatie over <a href="https://www.w3.org/WAI/tutorials/tables/">toegankelijke tabellen.</a>',
    TABLES_EMPTY_HEADING: 'Lege tabelheader gevonden! Tabelkoppen moeten <strong>nooit</strong> leeg zijn. Het is belangrijk om rij- en/of kolomkoppen aan te geven om hun relatie duidelijk te maken. Deze informatie geeft context aan mensen die ondersteunende technologie gebruiken. Houd in gedachten dat tabellen alleen mogen worden gebruikt voor gegevens in tabelvorm. <hr> Meer informatie over <a href="https://www.w3.org/WAI/tutorials/tables/">toegankelijke tabellen.</a>',
    CONTRAST_ERROR: 'Deze tekst heeft niet genoeg contrast met de achtergrond. De contrastverhouding moet ten minste 4,5:1 zijn voor normale tekst en 3:1 voor grote tekst. <hr> <strong {B}>Contrastverhouding</strong> <strong {B}>%(RATIO)</strong> <strong {r}>%(TEXT)</strong>',
    CONTRAST_WARNING: 'Het contrast van deze tekst is onbekend en moet handmatig worden gecontroleerd. Zorg ervoor dat de tekst en de achtergrond sterk contrasterende kleuren hebben. De contrastverhouding moet minstens 4,5:1 zijn voor normale tekst en 3:1 voor grote tekst. <hr> Bekijk: <strong {W}>%(TEXT)</strong>',
    CONTRAST_INPUT_ERROR: 'Tekst binnen deze invoer heeft niet genoeg contrast met de achtergrond. De contrastverhouding moet ten minste 4,5:1 zijn voor normale tekst en 3:1 voor grote tekst. <hr> <strong {B}>Contrastverhouding</strong> <strong {B}>%(RATIO)</strong>',
  },
};

export { nl as default };
