<?php
/**
* @package OS Gallery
* @copyright 2020 OrdaSoft
* @author 2020 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @license This component is released under License from included LICENSE.txt file
* @description Ordasoft Image Gallery
*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
global $gl_state;

if(count($images)){
$galId_random = $galId."_". rand(); 
self::addMetaTags();
$img_count_cat_js = isset($img_count_cat) ? json_encode($img_count_cat) : '';
$fitrow_more_hidden = ($albumSublayout == 'fit_rows') ? fitrow-more-hidden : '';


?>
    <div class="os-gallery-album-tabs-main-<?php echo $galId_random; ?>">

        <div id="os_progres_img-<?php echo $galId_random; ?>" class="img-block1"></div> 

        <span class="back-to-albums" id="back-<?php echo $galId_random; ?>"style="display:none;"><?php echo $backText?></span>
        <div class="os-cat-tab-images" id="tabimg-<?php echo $galId_random; ?>" style="display:none">
            <?php
            foreach($images as $catId => $catImages){
                $currentCatParams = new JRegistry;
                $currentCatParams = $currentCatParams->loadString(rawurldecode($catParamsArray[$catId]->params));
                if($galleryLayout != 'albumMode')continue;
                if($currentCatParams->get("categoryUnpublish",false))continue;
                if($currentCatParams->get("categoryAlias",'')){
                    $catName = $currentCatParams->get("categoryAlias",'');
                }else if(isset($catImages[0])){
                    $catName = $catImages[0]->cat_name;
                }else{
                    $catName = 'no name';
                }


                // if(!isset($gl_state->data) ){
                //     echo '<script>alert("'.JText::_('COM_OSGALLERY_YOU_NEED_ACTIVATE_LICENSE') .'"); history.back(); </script>';
                //     return ;
                // }

                $catTitlePosition = $currentCatParams->get("catTitlePosition",'onImage');
                $catDescription = $currentCatParams->get("categoryDescription",'');
                $catTitleHeight = $currentCatParams->get("catTitleHeight",'');
                
                
                $catTextStile = "style='min-height:".$catTitleHeight."px; max-height:".$catTitleHeight."px; height:".$catTitleHeight."px; overflow: hidden;'";
                //var_dump($catName);
                ?>
                <!-- Simple category mode-->
                <div id="cat-<?php echo $catId?>-<?php echo $galId_random?>" class="album-block" data-cat-id="<?php echo $catId?>" data-end="<?php echo $numberImages?>" >
                   
                    <?php
                    if($catImages){
                        if(isset($catImages[0])){
                                $styleImg = 'style="margin:'.$imageMargin.'px;"';
                                $currentImgParams = new JRegistry;
                                $currentImgParams = $currentImgParams->loadString(rawurldecode($imgParamsArray[$catImages[0]->id]->params));
                                $imgAlt = ($currentImgParams->get("imgAlt",''))? $currentImgParams->get("imgAlt",'') : $catImages[0]->file_name;
                            ?>

                            <div class="img-block text-<?php echo $imgTextPosition; ?> <?php echo $imageHover ?>-effect <?php echo $numberImagesEffect; ?> animated" <?php echo $styleImg?>>
                                <span class="album-main-image" data-cat-id="<?php echo $catId?>">
                                    <?php if($catTitlePosition != 'bottom'){ ?>
                                        <div class="os-gallery-caption<?php echo ($catTitlePosition == 'onImage')?' ':'-';?><?php echo $catTitlePosition; ?>"
                                             <?php echo ($catTitlePosition == 'onImage')?'':$catTextStile;?>>
                                            <?php
                                                if($catName) {
                                                    echo "<h3 class='os-gallery-img-title'>".strip_tags($catName)."</h3>";
                                                }
                                                if($catDescription) {
                                                    echo "<p class='os-gallery-img-desc'>".strip_tags($catDescription)."</p>";
                                                }
                                            ?>
                                        </div>
                                    <?php } 
                                    
                                    if($imgMask != 'none'){ ?>
                            
                                        <div class="bg" style="<?php echo $background_color; ?>; position: absolute; width: 100%; height: 100%;"></div>
                                        <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $catImages[0]->galId?>/thumbnail/<?php echo $catImages[0]->file_name?>" alt="<?php echo $imgAlt?>" style="opacity: <?php echo $background_opacity; ?>; position: absolute;">
                                    <?php } ?>
                                    <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $catImages[0]->galId?>/thumbnail/<?php echo $catImages[0]->file_name?>" alt="<?php echo $imgAlt?>" class="<?php echo $imgMaskClass; ?>">
                                    <?php if($catTitlePosition == 'bottom'){ ?>
                                        <div class="os-gallery-caption-<?php echo $catTitlePosition; ?>"
                                             <?php echo ($catTitlePosition == 'onImage')?'':$catTextStile;?>>
                                            <?php
                                                if($catName) {
                                                    echo "<h3 class='os-gallery-img-title'>".strip_tags($catName)."</h3>";
                                                }
                                                if($catDescription) {
                                                    echo "<p class='os-gallery-img-desc'>".strip_tags($catDescription)."</p>";
                                                }
                                            ?>
                                        </div>
                                    <?php } ?>
                                </span>
                            </div>
                            <?php 
                            }
                        ?>
                    <div class="grid" style="display: none;">
                            <?php if($albumSublayout == 'masonry'){ ?>
                                <div class="grid-sizer grid-sizer-<?php echo $galId_random?>" id = "grid-sizer-<?php echo $galId_random?>" style="width: 33.333%;" ></div>
                           <?php }elseif($albumSublayout == 'fit_rows'){ ?>
                                <div class="gutter-sizer" id="gutter-sizer-<?php echo $galId_random?>"></div>
                           <?php } ?>
                        <?php    
                        foreach($catImages as $i => $image){
                            $currentImgParams = new JRegistry;
                            $currentImgParams = $currentImgParams->loadString(rawurldecode($imgParamsArray[$image->id]->params));
                            $imgAlt = ($currentImgParams->get("imgAlt",''))? $currentImgParams->get("imgAlt",'') : $image->file_name;
                            if($currentImgParams->get("imgTitle",'')){
                            $imgTitle = $currentImgParams->get("imgTitle",'') . '</br>';}
                            else {$imgTitle = $currentImgParams->get("imgTitle",'');}
                            if ($currentImgParams->get("imgShortDescription",'')){
                            $imgShortDesc = $currentImgParams->get("imgShortDescription",'') . '</br>';}
                            else {$imgShortDesc = $currentImgParams->get("imgShortDescription",'');}
                            if ($imgVideoLink = $currentImgParams->get("videoLink", '')){
                                $imgVideoLink = $currentImgParams->get("videoLink", '');
                            } else {
                                $imgHtml = $currentImgParams->get("imgHtml", '');
                                $imgHtmlShow = $currentImgParams->get("imgHtmlShow", 'yes');
                                $htmlWidthAsImage = ($imgHtmlShow == 'yes' && $currentImgParams->get("htmlWidthAsImg", "yes") == "yes");
                                $htmlPosition = ($imgHtmlShow == 'yes') ? $currentImgParams->get("htmlPosition", "bottom") : 'bottom';
                            }

                            if($params->get("watermark_enable",false)){
                                $imgLink = JURI::root().'images/com_osgallery/gal-'.$image->galId.'/original/watermark/'.$image->file_name;
                            }else{
                                $imgLink = JURI::root().'images/com_osgallery/gal-'.$image->galId.'/original/'.$image->file_name;
                            }
                            $imgOpen = '';
                            if($currentImgParams->get("imgLink",'')){
                                $imgLink = $currentImgParams->get("imgLink",'');
                                $imgLink = str_replace('http//', 'http://', $imgLink);
                                $imgLink = str_replace('https//', 'https://', $imgLink);
                                $imgOpen = $currentImgParams->get("imgLinkOpen",'_blank');
                            }
//                            var_dump($i);
//                            var_dump(!$i);
                            
                                $styleImg = 'style="margin:'.$imageMargin.'px; display:none;"';
                            ?>
                            
                            <div id="grid-item-<?php echo $galId_random?>" class="grid-item img-block <?php echo $fitrow_more_hidden; ?> <?php echo $imageHover ?>-effect text-<?php echo $imgTextPosition; ?> animated <?php echo $numberImagesEffect; ?>" <?php echo $styleImg?>>
                                <div class="os-gallery-album-<?php echo $catId?>-<?php echo $galId_random?>">
                                    
                                    <a 
                                        <?php 
                                        $is_tmp_chk = $currentImgParams->get('imgLink','');
                                        $imgVideoLink = trim($imgVideoLink);
                                       if(empty( $is_tmp_chk )){?>
                                        class="os_fancybox-<?php echo $catId?>"
                                        data-index="<?php echo $image->ordering; ?>"
                                        data-os_fancybox="os_fancybox-<?php echo $catId; ?>"     
                                        <?php }; ?>
                                        id="os_image_id-<?php echo $image->id; ?>"
                                        rel="group"
                                        target="<?php echo $imgOpen?>"
                                        <?php if(isset($imgHtml->html) && !empty($imgHtml->html) && empty( $is_tmp_chk )) { ?>
                                           data-options='{"src": "#data-html-<?php echo $image->id; ?>", "smallBtn" : false}'
                                        <?php }elseif(!empty( $imgVideoLink )){ ?>
                                           href="<?php echo $imgVideoLink; ?>"
                                        <?php }else{ ?>
                                           href="<?php echo $imgLink; ?>"
                                        <?php }; ?>
                                        data-caption="<?php echo $showImgTitle ? $imgTitle : ''?><?php echo $showImgDescription ? $imgShortDesc : ''?>" 
                                        >
                                        <?php if($imgTextPosition != 'bottom' && $imgTextPosition != 'none'){ ?>
                                            <div class="os-gallery-caption<?php echo ($imgTextPosition == 'onImage')?' ':'-';?><?php echo $imgTextPosition; ?>"
                                                 <?php echo ($imgTextPosition == 'onImage')?'':$imgTextStyle;?>>
                                                <?php
                                                    if($imgTitle) {
                                                        echo "<h3 class='os-gallery-img-title'>".strip_tags(substr($imgTitle, 0, $imgMaxlengthTitle))."</h3>";
                                                    }
                                                    if($imgShortDesc) {
                                                        echo "<p class='os-gallery-img-desc'>".strip_tags(substr($imgShortDesc, 0, $imgMaxlengthDesc))."</p>";
                                                    }
                                                ?>
                                            </div>
                                        <?php } 
                                        
                                        if($imgMask != 'none'){ ?>
                            
                                            <div class="bg" style="<?php echo $background_color; ?>; position: absolute; width: 100%; height: 100%;"></div>
                                            <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $image->galId?>/<?php echo $thumbnail_folder; ?>/<?php echo $image->file_name?>" alt="<?php echo $imgAlt?>" style="opacity: <?php echo $background_opacity; ?>; position: absolute;">
                                        <?php } ?>
                                        <img src="<?php echo JURI::root()?>images/com_osgallery/gal-<?php echo $image->galId?>/<?php echo $thumbnail_folder; ?>/<?php echo $image->file_name?>" alt="<?php echo $imgAlt?>" class="<?php echo $imgMaskClass; ?>">
                                        
                                        <?php if($imgTextPosition == 'bottom'){ ?>
                                            <div class="os-gallery-caption-<?php echo $imgTextPosition; ?>" <?php echo $imgTextStyle; ?>>
                                                <?php
                                                    if($imgTitle) {
                                                        echo "<h3 class='os-gallery-img-title'>".strip_tags(substr($imgTitle, 0, $imgMaxlengthTitle))."</h3>";
                                                    }
                                                    if($imgShortDesc) {
                                                        echo "<p class='os-gallery-img-desc'>".strip_tags(substr($imgShortDesc, 0, $imgMaxlengthDesc))."</p>";
                                                    }
                                                ?>
                                            </div>
                                        <?php } ?>
                                     </a>
                                    </div>

                                <?php if(isset($imgHtml->html) && !empty($imgHtml->html)) { ?>

                                <?php 
                                    // class for block width as image
                                    $htmlWidthAsImageClass = ($htmlWidthAsImage) ? 'htmlWidthAsImage' : ''; 
                                    // class for position html
                                    $htmlPositionClass = ($htmlPosition) ? 'position_'.$htmlPosition : '';
                                ?>   

                                <div style="display: none;" class="data-html-wrap <?php echo $htmlWidthAsImageClass; ?> <?php echo $htmlPositionClass; ?>" id="data-html-<?php echo $image->id; ?>">
                                    <?php if($imgHtmlShow == 'yes'){?>
                                        <div class="imgInHtml">    
                                            <img src="<?php echo $imgLink; ?>">
                                        </div>
                                    <?php } ?>
                                    <div class="contentInHtml">
                                       <?php echo $imgHtml->html ; ?>
                                    </div>
                                </div>
                                <?php } ?>

                            </div>
                            
                        <?php
                        } ?>
                        </div>    
                    <?php }?>
                </div>
                <!-- END simple mod-->
            <?php
            } ?>
        </div>

        <script>
            jQuerOs(window).on('load',function($) {
                from_history = false;
                jQuerOs('#os_progres_img-<?php echo $galId_random; ?>' ).attr('class', "");
    
                var gallery = new osGallery(".os-gallery-album-tabs-main-<?php echo $galId_random; ?>",{
                    minImgEnable : <?php echo $minImgEnable?>,
                    spaceBetween: <?php echo $imageMargin?>,
                    minImgSize: <?php echo $minImgSize?>,
                    numColumns: <?php echo $numColumns?>,
                    showImgTitle: '<?php echo $params->get('showImgTitle'); ?>',
                    showImgDescription: '<?php echo $params->get('showImgTitle'); ?>',
                    limEnd: '<?php echo $numberImages?>',
                    galId: '<?php echo $galId; ?>',
                    galIdRandom: '<?php echo $galId_random; ?>',
                    imgCountCat: '<?php echo $img_count_cat_js; ?>',
                    load_more_background: '<?php echo $load_more_background; ?>',
                    os_fancybox_background: '<?php echo $os_fancybox_background; ?>',
                    showLoadMore: '<?php echo $showLoadMore; ?>',
                    juri: '<?php echo JURI::root(); ?>',
                    itemId: '<?php echo $itemId ?>',
                    layout: 'album',
                    albumSublayout: '<?php echo $albumSublayout; ?>',
                    fancSettings:{
                        wrapCSS: 'os-os_fancybox-window',
                        animationEffect : "<?php echo $open_close_effect?>",
                        animationDuration : "<?php echo $open_close_speed?>",
                        transitionEffect : "<?php echo $prev_next_effect?>",
                        transitionDuration : "<?php echo $prev_next_speed?>",
                        loop: <?php echo $loop?>,
                        arrows: <?php echo $os_fancybox_arrows?>,
                        clickContent: "<?php echo $next_click?>",
                        wheel: <?php echo $mouse_wheel?>,
                        slideShow : {
                            autoStart : <?php echo $os_fancybox_autoplay?>,
                            speed     : <?php echo $autoplay_speed?>
                        },
                        clickSlide : <?php echo $click_close?>,
                        thumbs : {
                            autoStart : <?php echo $thumbnail_autostart?>,
                            axis : '<?php echo $os_fancybox_thumbnail_axis?>'
                        },
                        buttons : {
                            'slideShow': '<?php echo $start_slideshow_button?>',
                            'fullScreen': '<?php echo $full_screen_button?>',
                            'thumbs': '<?php echo $thumbnails_button?>',
                            'share': '<?php echo $share_button?>',
                            'download': '<?php echo $download_button?>',
                            'zoom': '<?php echo $zoom_button?>', 
                            'arrowLeft': '<?php echo $left_arrow?>', 
                            'arrowRight': '<?php echo $right_arrow?>', 
                            'close': '<?php echo $close_button?>'
                        },
                        share : {
                            tpl : '<?php echo $share_tpl?>'
                        },
                        infobar : <?php echo $infobar?>,
                        baseClass : '<?php echo $os_fancybox_thumbnail_position?>'
                    }
                });


                jQuerOs("#load-more-<?php echo $galId_random; ?>").hide();
                

                gallery.loadMore("<?php echo $showLoadMore; ?>",false);
                
                // add social sharing script
                var href = window.location.href;
                var img_el_id = '';
                var pos1 = href.indexOf('os_image_id'); 
                var pos2 = href.lastIndexOf('#'); 
                var catId = '';
                var cat_pos1 = href.indexOf('os_fancybox');
                var cat_pos = href.substring(cat_pos1, href.lastIndexOf('-'));
                var cat_pos = cat_pos.substring(cat_pos.lastIndexOf('-'));
                var os_show_load_more = "<?php echo $showLoadMore; ?>";
                if (pos1 > -1 && pos2 > - 1) {
                    img_el_id = href.substring(pos1, pos2); 
                }else if(pos1 > -1 && pos2 == -1){
                    img_el_id = href.substring(pos1);
                }
                    
                os_fancy_box_getInst = jQuerOs.os_fancybox.getInstance(); 
                
                if(!os_fancy_box_getInst){
                    if(img_el_id && img_el_id.indexOf('os_image_id') > -1)  {

                        if(document.getElementById(img_el_id) == null){
                            if (os_show_load_more == 'auto'){
                                gallery.loadMore("auto");

                            }
                            else if (os_show_load_more !== null){
                                gallery.loadMore("button");

                                jQuerOs('#load-more-<?php echo $galId_random;?>').trigger('click');

                            }

                        }

                        else {
                            jQuerOs('#' + img_el_id).trigger('click');
                        }
                    }
                }
                
                var position_gallery = href.indexOf('cat');
                var gallery_cat_id = '';
                var gallery_cat_id = href.substring(position_gallery);
                if(gallery_cat_id.indexOf('&') > -1){
                    gallery_cat_id = gallery_cat_id.substr(0, gallery_cat_id.indexOf('&'));
                }
                
                if(gallery_cat_id && gallery_cat_id.indexOf('cat-') > -1 && gallery_cat_id.indexOf('=') == -1){
                    jQuerOs('#' + gallery_cat_id + '-<?php echo $galId_random; ?> .album-main-image').trigger('click');
                }
                
                window.onpopstate = function(event) {
                  //alert("location: " + document.location + ", state: " + JSON.stringify(event.state));
                  from_history = true;
                  
                  var href = window.location.href;
                    var img_el_id = '';
                    var pos1 = href.indexOf('os_image_id'); 
                    var pos2 = href.lastIndexOf('-'); 
                    os_fancy_box_getInst = jQuerOs.os_fancybox.getInstance(); 
                    
                    if (!os_fancy_box_getInst && (pos1 > -1)){
                        if (pos1 > -1 && href.indexOf('#os_fancybox') > - 1) {
                            pos2 = href.lastIndexOf('#os_fancybox')
                            img_el_id = href.substring(pos1, pos2); 
                        }else if(pos1 > -1 && href.indexOf('#os_fancybox') == -1){
                            img_el_id = href.substring(pos1);
                        }
                        
                        jQuerOs('#' + img_el_id).trigger('click');
                    }
                    else if (pos1 > -1) {
                        img_el_id = href.substring(pos1);
                        var ordering_id = jQuerOs('#' + img_el_id).attr('data-index');
                        
                        os_fancy_box_getInst.jumpTo(ordering_id);
                    }else if(pos1 == -1 && href.indexOf('os_fancybox') == -1 && os_fancy_box_getInst){
                        os_fancy_box_getInst.close();
                        window.history.back();
                    }else{
                        jQuerOs('#back-' + '<?php echo $galId_random?>').trigger('click');
                    }
                    
                    var cat_id = '';
                    if(href.indexOf('cat-') > -1 && href.indexOf('os_image_id') == -1){
                        cat_id = href.substring(href.indexOf('cat-'));
                        jQuerOs('#' + cat_id + '<?php echo $galId_random?>').trigger('click');
                    }
                     from_history = false;
                };
                
                // end sharing script 

            });
        </script>
    </div>
    
        <?php if ($showLoadMore) { ?>
        <div class="osGallery-button-box" id="button-<?php echo $galId_random?>">
            <div id="os_lm_progres_img-<?php echo $galId_random; ?>" class="img-block1-load-more"></div>
            <button id="load-more-<?php echo $galId_random; ?>" class="load-more-button" style="<?php echo ($showLoadMore != 'button') ? 'display:none;':''; ?> background:<?php echo $load_more_background; ?>"> 
                    <?php echo $loadMoreButtonText; ?>                
            </button>
        </div>
        <?php } ?>
        <div class="scrollPoint_<?php echo $galId_random; ?>"></div>
<?php
}