<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_weblinks
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\String\PunycodeHelper;

$weblinkUrl = PunycodeHelper::urlToUTF8($this->item->url);
$user      = Factory::getApplication()->getIdentity();
$canEdit = $user->authorise('core.edit', 'com_weblinks.category.' . $this->item->catid);
if (!$canEdit) {
    $canEditOwn = $user->authorise('core.edit.own', 'com_weblinks.category.' . $this->item->catid);
    $canEdit    = $canEditOwn && $this->item->created_by == $user->id;
}
?>
<div class="item-page">
    <meta itemprop="inLanguage" content="<?php echo ($this->item->language === '*') ? Factory::getApplication()->get('language') : $this->item->language; ?>" />
  <div class="page-header">
      <h2 itemprop="headline">
            <?php echo $this->escape($this->item->title); ?>
      </h2>
  </div>
    <?php if ($canEdit) :
        ?>
        <div class="icons">
            <div class="float-end">
                <div>
                    <?php echo HTMLHelper::_('weblinkicon.edit', $this->item, $this->item->params); ?>
               </div>
         </div>
     </div>
        <?php
    endif; ?>

    <?php // Content is generated by content plugin event "onContentAfterTitle" ?>
    <?php echo $this->item->event->afterDisplayTitle; ?>

    <?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
    <?php echo $this->item->event->beforeDisplayContent; ?>

    <div itemprop="articleBody">
       <div class="p-3">
            <a href="<?php echo $weblinkUrl; ?>" target="_blank" itemprop="url">
                <?php echo $weblinkUrl; ?>
          </a>
       </div>

        <?php if ($this->params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) :
            ?>
          <div class="p-2">
                <?php echo LayoutHelper::render('joomla.content.tags', $this->item->tags->itemTags); ?>
          </div>
            <?php
        endif; ?>

        <div class="p-3">
            <?php $images = json_decode($this->item->images); ?>
            <?php if (!empty($images->image_first)) :
                ?>
                <?php $imgFloat = '';?>
                <?php if (!empty($images->float_first)) :
                    ?>
                    <?php $imgFloat = $images->float_first == 'right' ? 'float-end' : 'float-start'; ?>
                    <?php
                endif; ?>
                <?php $img      = HTMLHelper::cleanImageURL($images->image_first); ?>
                <?php $alt      = empty($images->image_first_alt) && empty($images->image_first_alt_empty)
                    ? ''
                    : 'alt="' . htmlspecialchars($images->image_first_alt, ENT_COMPAT, 'UTF-8') . '"'; ?>
                <figure class="item-image <?php echo $imgFloat; ?>">
                    <img src="<?php echo htmlspecialchars($img->url, ENT_COMPAT, 'UTF-8'); ?>"
                            <?php echo $alt; ?> itemprop="thumbnail" />
                    <?php if (!empty($images->image_first_caption)) :
                        ?>
                        <figcaption class="caption"><?php echo htmlspecialchars($images->image_first_caption, ENT_COMPAT, 'UTF-8'); ?></figcaption>
                        <?php
                    endif; ?>
              </figure>
                <?php
            endif; ?>

            <?php  if (!empty($images->image_second)) :
                ?>
                <?php $imgFloat = ''; ?>
                <?php if (!empty($images->float_second)) :
                    ?>
                    <?php $imgFloat = $images->float_second == 'right' ? 'float-end' : 'float-start'; ?>
                    <?php
                endif; ?>
                <?php $img      = HTMLHelper::cleanImageURL($images->image_second); ?>
                <?php $alt      = empty($images->image_second_alt) && empty($images->image_second_alt_empty)
                    ? ''
                    : 'alt="' . htmlspecialchars($images->image_second_alt, ENT_COMPAT, 'UTF-8') . '"'; ?>
                <figure class="item-image <?php echo $imgFloat; ?>">
                    <img src="<?php echo htmlspecialchars($img->url, ENT_COMPAT, 'UTF-8'); ?>"
                            <?php echo $alt; ?> itemprop="thumbnail" />
                    <?php if (!empty($images->image_second_caption)) :
                        ?>
                        <figcaption class="caption"><?php echo htmlspecialchars($images->image_second_caption, ENT_COMPAT, 'UTF-8'); ?></figcaption>
                        <?php
                    endif; ?>
               </figure>
                <?php
            endif; ?>

            <?php  if (!empty($this->item->description)) :
                ?>
                <?php echo $this->item->description; ?>
                <?php
            endif; ?>

      </div>

    </div>
    <?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
    <?php echo $this->item->event->afterDisplayContent; ?>
</div>
