<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Vladislav Prikhodko (vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminViewCoupons{
    public static function showCoupons($option, & $rows_item, & $publist, & $search, & $pageNav, & $sort_arr, $entity_list, & $userslist, $entities_array){
        global $doc, $user, $app, $session, $db, $os_cck_configuration;
        $db = new os_cckDb();
        $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_SHOW_COUPONS') . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
        $onclick = "Joomla.checkAll(this);";

        $table = new os_cckViewTable('adminForm', 'adminForm', '', 'index.php?option=com_os_cck&task=coupons', 'coupons');

        $table->create_button('Edit', 'edit_coupon', JURI::root() . 'components/com_os_cck/images/btn_d.png', 'fa-pencil-square-o');
        $table->create_button('Publish', 'publish_coupon', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-check');
        $table->create_button('Unpublish', 'unpublish_coupon', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-close');
        $table->create_button('Add', 'new_coupon', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-plus', '', false);
        $table->create_button('Delete', 'remove_coupon', JURI::root() . 'components/com_os_cck/images/published.png', 'fa-close');
        
        $table->create_filters('<div class="search_block"><input type="text" placeholder="'.cck_lang_text('COM_OS_CCK_SHOW_SEARCH').'" name="search" value="'.$search.'" class="inputbox" onChange="document.adminForm.submit();"/><button type="submit" class="cck_search_button" title="" data-original-title="Search"><span class="icon-search"></span></button></div>');
        $table->create_filters('<div>'.$publist.'</div>');
        $table->create_filters('<div>'.$userslist.'</div>');
        $table->create_filters('<div>'.$entity_list.'</div>');
        
        
        $table->first_row_custom_class = 'admin-request-standart-fields';
        $table->limitbox = '<div class="btn-group pull-right hidden-phone">
            <label for="limit" class="element-invisible">'. cck_lang_text('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC') .'</label>'. $pageNav->getLimitBox() .'</div>';

        $table->create_first_row_collumn(JHtml::_('grid.checkall'), '', 'admin-order-title-checkbox');  
        $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_INSTANCE_ID'), 'coup_id', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-id');   
        $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_COUPON'), 'coupon_name', $sort_arr,protectInjectionWithoutQuote('task')), '', 'admin-order-title-date');   
        $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_COUPON_VALUE'), '', 'admin-order-title-date');   
        $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_COUPON_DATE_START'), 'coupon_date_start', $sort_arr, 'coupons'), '', 'admin-order-title-date');   
        $table->create_first_row_collumn(HTML_os_cck::sort_head(cck_lang_text('COM_OS_CCK_LABEL_COUPON_DATE_FINISH'), 'coupon_date_finish', $sort_arr, 'coupons'), '', 'admin-order-title-date');   
        $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_COUPON_USED_NUMBER'), '', 'admin-order-title-date');   
        $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_COUPON_MAX_USES'), '', 'admin-order-title-date');   
        $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_ENTITY'), '', 'admin-order-title-date');   
        $table->create_first_row_collumn(cck_lang_text('COM_OS_CCK_LABEL_PUBLIC'), '', 'admin-order-title-date');  
        
        $session->set('sorting_direction', $sort_arr['sorting_direction']);
        for ($i = 0, $n = count($rows_item); $i < $n; $i++) {
            $request_data = array();
            $row = $rows_item[$i];

            $request_data[] = JHTML::_('grid.id',$i, $row->coup_id, false, 'coup_id');
            $request_data[] = '<a href="?option=com_os_cck&task=edit_coupon&coup_id[]='.$row->coup_id.'"> '.$row->coup_id.'</a>';
            $request_data[] = '<a href="?option=com_os_cck&task=edit_coupon&coup_id[]='.$row->coup_id.'"> '.$row->name.'</a>';
            if($row->type == 'percent'){
                $request_data[] = $row->value . '%';
            }else{
                $currency = cck_getCurrency($os_cck_configuration);
                $request_data[] = calculatedCurrency('',$row->value, $currency[0]['sign'])[0];
            }
            $request_data[] = $row->date_start;
            $request_data[] = $row->date_finish;
            $request_data[] = $row->used_number;
            $request_data[] = $row->max_uses;

            $temp_html = '';
            $enteties = explode(',', $row->entities);
            $enteties = array_diff($enteties, array(''));
            //var_dump($enteties);
            if(!empty($enteties)){
                $z=0;
                foreach($enteties as $entity){
                    if(count($enteties)-1 == $z){
                        if($entity != '-1'){
                            $temp_html .= $entities_array[$entity]->text;
                        }else{
                            $temp_html .= cck_lang_text('COM_OS_CCK_LABEL_ALL_ENTETIES');
                        }
                    }else{
                        if($entity != '-1'){
                            $temp_html .= $entities_array[$entity]->text . ', ';
                        }else{
                            $temp_html .= cck_lang_text('COM_OS_CCK_LABEL_ALL_ENTETIES') . ', ';
                        }
                    }
                    $z++;
                }
            }else{
                $temp_html .= cck_lang_text('COM_OS_CCK_LABEL_ALL_ENTETIES');
            }
            $request_data[] = $temp_html;

            $task = $row->published ? 'unpublish_coupon' : 'publish_coupon';
            $alt = $row->published ? 'Unpublish' : 'Publish';
            $img = $row->published ? 'tick.png' : 'publish_x.png';
            $img = "components/com_os_cck/images/{$img}";
            $temp_html = '';
            if (JFactory::getUser()->authorise('publish_coupons', 'com_os_cck')){
                $temp_html .= '<a href="javascript: void(0);"
                    onClick="return cckSendForm(\'cb'.$i.'\',\''.$task.'\',\'adminForm\')">';
            }
            $temp_html .= '<img src="'.$img.'" width="12" height="12" border="0" alt="'.$alt.'"/>';
            if (JFactory::getUser()->authorise('publish_coupon', 'com_os_cck')){
                $temp_html .= '</a>';
            }
            $request_data[] = $temp_html;
            
            $class = 'row' . ($i % 2) . ' ';

            $table->create_first_row_data($request_data, $class);
        }

        $table->paginator = $pageNav->getListFooter();
        
        echo $table->viewTable();

    }
    
    static function editCoupon($coupon){
        global $app;
        $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . cck_lang_text('COM_OS_CCK_SHOW_COUPONS') . "</div>";
        $app = JFactory::getApplication();
        $app->JComponentTitle = $html;
        
        ?>
        <script language="javascript" type="text/javascript">
            Joomla.submitbutton = function (pressbutton) {
                var form = document.adminForm;
                if (pressbutton == "coupons") {
                    Joomla.submitform(pressbutton);
                    return true;
                }
                Joomla.submitform(pressbutton);
                
            }
            window.addEventListener('load', function() {
                jQuerOs('input[name=max_uses], input[name=value]').on('input',function(){
                    var value = jQuerOs(this).val()
                    if(value > 2147483647){
                      jQuerOs(this).val(2147483647)
                    }
                    
                })
            })
        </script>
        
        <?php
        $table = new os_cckViewTable('adminForm', 'adminForm', '', 'index.php', '');
        $table->create_button(cck_lang_text('COM_OS_CCK_BUTTON_FORM_SAVE_AND_CLOSE'), 'save_coupon', '', 'fa-save', '', false);
        $table->create_button(cck_lang_text('COM_OS_CCK_CANCEL'), 'coupons', '', 'fa-close', '', false);

        $table_html = '';

        ob_start();
        ?>
<!--        <form action="index.php" method="post" name="adminForm" id="adminForm" class="couponForm">-->
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON'); ?></label>
                <input type="text" name="name" class="coupon_name" value="<?php echo $coupon->name; ?>" maxlength="250">
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_TYPE'); ?></label>
                <?php echo $coupon->_coupon_type_input; ?>
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_VALUE'); ?></label>
                <input type="number" name="value" class="coupone_value" value="<?php echo $coupon->value; ?>">
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_DATE_START'); ?></label>
                <?php echo JHtml::calendar($coupon->date_start, 'date_start', 'date_start'); ?>
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_DATE_FINISH'); ?></label>
                <?php echo JHtml::calendar($coupon->date_finish, 'date_finish', 'date_finish'); ?>
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_MAX_USES'); ?></label>
                <input type="number" name="max_uses" class="coupone_max_uses" value="<?php echo $coupon->max_uses; ?>">
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_ENTITIES'); ?></label>
                <?php echo $coupon->_entities_input; ?>
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_USER_GROUPS'); ?></label>
                <?php echo $coupon->_coupon_user_groups_input; ?>
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_COUPON_CATEGORIES'); ?></label>
                <?php echo $coupon->_coupon_categories; ?>
            </div>
            
            <div>
                <label><?php echo cck_lang_text('COM_OS_CCK_LABEL_PUBLIC'); ?></label>
                <?php echo $coupon->_coupon_publish_input;?>
            </div>
            
            <input type="hidden" name="option" value="com_os_cck"/>
            <input type="hidden" name="task" value=""/>
            <?php if($coupon->coup_id){?>
            <input type="hidden" name="coup_id" value="<?php echo $coupon->coup_id; ?>"/>
            <?php } ?>
        <!--</form>-->

        <?php
        $table_html = ob_get_contents();
        ob_clean();
        $table->set_custom_html($table_html);
        echo $table->viewTable();
    }
}
