<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

$fName = $field->db_field_name;
// var_dump($fName);
// var_dump($layout->type);
if($layout->type == 'add_instance'){
    $buttonText = isset($layout_params["views"][$fName ."_text"])?$layout_params["views"][$fName ."_text"]:'Save & Close';
}else{
    $buttonText = isset($layout_params["views"][$fName ."_text"])?$layout_params["views"][$fName ."_text"]:'Edit';
}

$buttonTask = isset($layout_params["fields"][$fName.'_button_task'])?$layout_params["fields"][$fName.'_button_task']:'edit';
$field_php_show = (isset($fields_from_params[$fName.'_php_show'])) ? $fields_from_params[$fName.'_php_show'] : '';
$redirect_page = isset($layout_params["fields"][$fName.'_redirect_page'])?$layout_params["fields"][$fName.'_redirect_page']:'previous_page';

$custom_redirect_page = isset($layout_params["fields"][$fName ."_custom_page"])?$layout_params["fields"][$fName ."_custom_page"]:'';

$buttonTaskOption = array();
if($layout->type == 'add_instance'){
    $buttonTaskOption[] = JHTML::_('select.option','save','Save & Close');
    $buttonTaskOption[] = JHTML::_('select.option','apply','Apply');
    $buttonTaskOption[] = JHTML::_('select.option','cancel','Cancel');
}else{
    $buttonTaskOption[] = JHTML::_('select.option','edit','Edit');
    $buttonTaskOption[] = JHTML::_('select.option','delete','Delete');
}

$buttonRedirectPage = array();

$buttonRedirectPage[] = JHTML::_('select.option','previous_page','Previous page');
$buttonRedirectPage[] = JHTML::_('select.option','custom_page','Custom page');



$field_php_show = (isset($fields_from_params[$fName.'_php_show'])) ? $fields_from_params[$fName.'_php_show'] : '';

$gtree = get_group_children_tree_cck('instance_manager');
$access_selected = (isset($fields_from_params['access_'.$fName])) ? $fields_from_params['access_'.$fName] : '1';
?>
<div id="options-field-<?php echo $fName?>">
    <div>
        <label><?php echo cck_lang_text('COM_OS_CCK_LAYOUT_BUTTON_TEXT')?></label>
        <input type="text" value="<?php echo $buttonText?>" placeholder="Type form button text...." name="vi_<?php echo $fName?>_text">
    </div>
    <div>
        <label><?php echo cck_lang_text('COM_OS_CCK_LAYOUT_BUTTON_TASK')?></label>
        <?php echo JHTML::_('select.genericlist', $buttonTaskOption,  'fi_'. $fName .'_button_task', '','value', 'text',$buttonTask)?>
        
    </div>
    <div class="save_redirect<?php echo $fName; ?>">
        <label><?php echo cck_lang_text('COM_OS_CCK_LAYOUT_TASK_SAVE_REDIRECT')?></label>
        <?php echo JHTML::_('select.genericlist', $buttonRedirectPage,  'fi_'. $fName .'_redirect_page', '','value', 'text',$redirect_page)?>
        
    </div>
    <div class="custom_page_redirect<?php echo $fName; ?>">
        <label><?php echo cck_lang_text('COM_OS_CCK_LAYOUT_TASK_SAVE_REDIRECT_CUSTOM_PAGE')?></label>
        <input type="text" value="<?php echo $custom_redirect_page?>" name="fi_<?php echo $fName?>_custom_page">
    </div>
    <div class="php_show">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_PHP_SHOW")?> <i title="<?php echo cck_lang_text("COM_OS_CCK_LABEL_PHP_SHOW_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input id="add-field-mask-php-show" class="new-mask" type="button" aria-invalid="false" value="+field">
        <span class="editor-button">Editor</span>
        <textarea class="php-show-editor" rows="5" cols="30" name="fi_<?php echo $fName?>_php_show"><?php echo $field_php_show?></textarea>
    </div>
    <?php if(isset($cck_entity_configuration[$layout->fk_eid]['check_access_fields']) && $cck_entity_configuration[$layout->fk_eid]['check_access_fields'] == '1'){ 
        $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access_selected,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
        ?>
    <div>
        <label class="access-label"><?php echo cck_lang_text("COM_OS_CCK_LABEL_FIELD_ACCESS")?></label>
        <?php //echo JHTML::_('select.genericlist', $gtree, 'fi_access_'.$fName.'[]', 'multiple="true"','value', 'text',$access_selected);
        echo JHTML::_('select.groupedlist',$gtree,'fi_access_'.$fName.'[]', $attr);?>
    </div>
    <?php } ?>

    <input name="cck_action_button[<?php echo $key; ?>]" type="hidden" value="{}">
</div>

<script>
 
    function showHideRedirectPage<?php echo $fName; ?>(){
        var task = jQuerOs('#fi_<?php echo $fName; ?>_button_task').val();
        var redirect = jQuerOs('#fi_<?php echo $fName; ?>_redirect_page').val();
        // console.log('111111111111111', task, redirect)
        if(task == 'save' || task == 'cancel'){
            jQuerOs('.save_redirect<?php echo $fName; ?>').show()
            if(redirect == 'custom_page'){
                jQuerOs('.custom_page_redirect<?php echo $fName; ?>').show()
            }else{
                jQuerOs('.custom_page_redirect<?php echo $fName; ?>').hide()
            }
        }else{
            jQuerOs('.save_redirect<?php echo $fName; ?>, .custom_page_redirect<?php echo $fName; ?>').hide()
        }

    }
    window.addEventListener('load', function() { 
        showHideRedirectPage<?php echo $fName; ?>();
        
        jQuerOs('#fi_<?php echo $fName; ?>_button_task').on('change', function(){
            showHideRedirectPage<?php echo $fName; ?>();
        })
        jQuerOs('#fi_<?php echo $fName; ?>_redirect_page').on('change', function(){
            showHideRedirectPage<?php echo $fName; ?>();
        })
        
    })

</script>
