<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

if(isset($field)){
    $fName = $field->db_field_name;
}else{
//    $field = new stdClass();
//    $field->db_field_name = 'user_order_by';
    $fName = 'user_order_by';
}
$rand =rand();

$fld_published = (isset($fields_from_params[$fName.'_published']) 
                    && $fields_from_params[$fName.'_published'] == 'on') ? 'checked="true"' : '';
$fld_published = (!isset($fields_from_params[$fName.'_published'])) ? 'checked="true"' : $fld_published;
$selected_orderFieldsDefault = (isset($fields_from_params['indexed_'.$fName])) ? $fields_from_params['indexed_'.$fName] : '';
$sortType_selected = (isset($fields_from_params['sortType_'.$fName])) ? $fields_from_params['sortType_'.$fName] : '';
$selected_orderFields = (isset($fields_from_params['order_by_fields_'.$fName])) ? $fields_from_params['order_by_fields_'.$fName] : '';

//sort fields
if($layout->type == 'parent_child'){
    $idxFields = array();
    if(isset($layout_params['views']['show_request_layout']) && !empty($layout_params['views']['show_request_layout'])){
        foreach ($layout_params['views']['show_request_layout'] as $child_layout_id => $temp_val){
            $child_layout = new os_cckLayout($db->_db);
            $child_layout->load($child_layout_id);
            $child_entity_id = $child_layout->fk_eid;
            $child_entity = new os_cckEntity($db->_db);
            $child_entity->load($child_entity_id);
            $order_fields = $child_entity->getIndexedFieldList();
            $idxFields = array_merge($idxFields, $order_fields);
        }
    
    }elseif(isset($child_lid)){
        $child_layout = new os_cckLayout($db->_db);
        $child_layout->load($child_lid);
        $child_entity_id = $child_layout->fk_eid;
        $child_entity = new os_cckEntity($db->_db);
        $child_entity->load($child_entity_id);
        $order_fields = $child_entity->getIndexedFieldList();
        $idxFields = array_merge($idxFields, $order_fields);
    }else{
        echo '<div id="options-field-'.$fName.'">';
        echo '<div class="request_layout_error">'.cck_lang_text('COM_OS_CCK_LAYOUT_ORDER_BY_REQUEST_LAYOUT_ERROR').'</div></div>'; return;
    }
}else{
    $idxFields = $entity->getIndexedFieldList();
}
//var_dump($idxFields); exit;
$field_for_order = array();
if(!isset($entities_type)){
    $entities_type = $GLOBALS['entities_type'];
}
if($entities_type[$layout->fk_eid] !== 'custom_sql'){
    $field_for_order[] = JHTML::_('select.option','ceid','Id', array('option.attr' => 'optionattr', 'attr' => array('data-img' => "red.jpg")));
    $field_for_order[] = JHTML::_('select.option','hits', cck_lang_text('COM_OS_CCK_NUMBER_OF_VIEWS'), array('option.attr' => 'optionattr', 'attr' => array('data-img' => "red.jpg")));
    $field_for_order[] = JHTML::_('select.option','last_review_date', cck_lang_text('COM_OS_CCK_LAST_REVIEW_DATE'), array('option.attr' => 'optionattr', 'attr' => array('data-img' => "red.jpg")));
}

$field_for_order_custom_opt = JHTML::_('select.option','custom_order', cck_lang_text('COM_OS_CCK_OPT_LABEL_CUSTOM'));

$field_for_order[] = $field_for_order_custom_opt;
foreach($idxFields as $idx) {
    $field_for_order[]  = JHTML::_('select.option',$idx['value'],$idx['text']);
}
if(count($field_for_order) <= 1){
    $orderByFields = 'Need at least 2 sortable fields';
}else{
    $orderByFields =  JHTML::_('select.genericlist',$field_for_order, 'fi_order_by_fields_' . $fName. '[]',
                      'size="4" multiple="multiple" class="inputbox" ', 'value', 'text', $selected_orderFields);
}


// order by
$orderByFieldsDefault =  JHTML::_('select.genericlist',$field_for_order, 'fi_indexed_' . $fName,
                      ' class="inputbox" ', 'value', 'text', $selected_orderFieldsDefault);

$sortType_option = array(JHTML::_('select.option','ASC','ASC'), JHTML::_('select.option','DESC','DESC'), JHTML::_('select.option','RAND()','Random'));
$sortType = JHTML::_('select.genericlist', $sortType_option, 'fi_sortType_' . $fName, '','value', 'text',$sortType_selected);


$tags[]  = JHTML::_('select.option','span','span');
$tags[]  = JHTML::_('select.option','div','div');

$field_custom_order_by = (isset($layout_params['views']['custom_order_by'][0])) ? $layout_params['views']['custom_order_by'][0] : '';
$fld_custom_order_by_alias = (isset($layout_params['views']['custom_order_by_alias'])) ? $layout_params['views']['custom_order_by_alias'] : '';


?>
<div id="options-field-<?php echo $fName?>">
    <div>
        <input type="hidden" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published"
        <?php echo $fld_published?> value="0">
        <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_SHOW_FIELD_PUBLISHED")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_<?php echo $fName?>_published" <?php echo $fld_published?>>
    </div>

        <div class="category-options">
            <label><?php echo cck_lang_text('COM_OS_CCK_LAYOUT_ORDER_BY_FIELDS_DEFAULT'); ?></label>
            <?php echo $orderByFieldsDefault; ?>
        </div>
        <div class="category-options">
            <label><?php echo cck_lang_text('COM_OS_CCK_LAYOUT_ORDER_BY'); ?></label>
            <?php echo $sortType; ?>
        </div>
        <div class="category-options rand" <?php echo ($sortType_selected != 'RAND()') ? 'style="display:none;"' : '' ?>>
            <label></label>
            <?php echo cck_lang_text('COM_OS_CCK_LAYOUT_ORDER_BY_RAND_WANING'); ?>
        </div>
        <div class="category-options">
            <label><?php echo cck_lang_text('COM_OS_CCK_LAYOUT_ORDER_BY_FIELDS'); ?>
                <i title="<?php echo cck_lang_text("COM_OS_CCK_LAYOUT_ORDER_BY_FIELDS_TOOLTIP")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i>
            </label>
            <?php echo $orderByFields; ?>
        </div>
        <div class="custom_order_by_wrap" style="display: block;">
            <div class="category-options">
                <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_CUSTOM_ORDER_BY_ALIAS")?></label>
                <input type="text" size="4" name="vi_custom_order_by_alias"  value="<?php echo $fld_custom_order_by_alias?>" >
            </div>
            <div class="php_show">
                <label><?php echo cck_lang_text("COM_OS_CCK_LABEL_CUSTOM_ORDER_BY")?> </label>
                <input id="add-field-mask-custom-order-by" class="new-mask" type="button" aria-invalid="false" value="select +field">
                <span class="editor-button">Editor</span>
                <textarea class="custom-order-by-editor" rows="5" cols="30" name="vi_custom_order_by[]"><?php echo $field_custom_order_by?></textarea>
            </div>
        </div>
</div>

<script>
    
function showHideCustomOrderByFields(){
    var array_val = jQuerOs('#fi_order_by_fields_<?php echo $fName; ?>').val();
    var deafult_val = jQuerOs('#fi_indexed_<?php echo $fName; ?>').val();
    
    if(array_val && (array_val.includes('custom_order') || deafult_val == 'custom_order')){
        jQuerOs('.custom_order_by_wrap').show()
    }else{
        jQuerOs('.custom_order_by_wrap').hide()
    }

}
window.addEventListener('load', function() { 
    showHideCustomOrderByFields();
    
    jQuerOs('#fi_order_by_fields_<?php echo $fName; ?>').on('change', function(){
        showHideCustomOrderByFields();
    })
    jQuerOs('#fi_indexed_<?php echo $fName; ?>').on('change', function(){
        showHideCustomOrderByFields();
    })
    jQuerOs('#fi_sortType_<?php echo $fName; ?>').on('change', function(){
        var value = $(this).val();
        if(value == 'RAND()'){
            $('.rand').show()
        }else{
            $('.rand').hide()
        }

    })
})
</script>
