<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

/**
* Legacy function, use <jdoc:include type="module" /> instead
*
* @deprecated        As of version 1.5
*/

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

if (!defined('DS'))
  define('DS', DIRECTORY_SEPARATOR);

if (!function_exists('mosLoadModule')) {

  function mosLoadModule($name, $style = - 1) {
      ?><jdoc:include type="module" name="<?php echo $name ?>" style="<?php echo $style ?>" /><?php
  }

}
if (!isset($GLOBALS['realestatemanager_configuration'])) {
  require_once (JPATH_ROOT . '/' . 'administrator' . '/' . 'components' . '/'
   . 'com_realestatemanager' . '/' . 'realestatemanager.class.conf.php' );
  $GLOBALS['realestatemanager_configuration'] =
    isset($realestatemanager_configuration) ? $realestatemanager_configuration : null;
}
/**
* Legacy function, using <jdoc:include type="modules" /> instead
*
* @deprecated  As of version 1.5
*/


if (!function_exists('os_hide_left_panel')) {

   function os_hide_left_panel() {
      if (version_compare(JVERSION, "4.0.0-alpha10", "lt")) {

      } else {
        $input = JFactory::getApplication()->input;
        $input->set('hidemainmenu', true);
      }
   }

}

//if (!function_exists('clearDate')) {
//
//    function clearDate($date) {
//        $date = preg_replace('/%/', '', $date);
//        return $date;
//    }
//
//}

if (!function_exists('get_user_details')) {
  function get_user_details($user_id){
    global $mosConfig_absolute_path ;

//throw 'get_user_details';
//ECHO 'get_user_details';
// RETURN;
    $joom_user = new JUser();
    $joom_user->load($user_id);

    JPluginHelper::importPlugin('user');
//    JForm::addFormPath($mosConfig_absolute_path . '/components/com_simplemembership/forms');
    JForm::addFormPath($mosConfig_absolute_path . '/components/com_users/models/forms');
    
    $user_profile_form = JForm::getInstance('com_users.user', 'profile');

    $offset = 0;
    $plug_params = 1;
     //run mambot onPrepareContent on plug_row object
    // Trigger the onContentPrepare event.
    $results2 = JFactory::getApplication()->triggerEvent('onContentPrepareData', array("com_users.user", $joom_user));
    $results = JFactory::getApplication()->triggerEvent('onContentPrepareForm', array($user_profile_form, $joom_user));

    $user_profile_form->bind($joom_user);

    $fields = $user_profile_form->getFieldset('fields-0');     
    $joom_user->nachname = "" ; 
    foreach($fields as $field) {
      if ($field->name == 'com_fields[nachname]' && $field->value !== '') { 
        $joom_user->nachname = $field->value; 
      } else if ($field->name == 'com_fields[firma]' && $field->value !== '') { 
        $joom_user->firma = $field->value; 
      } else if ($field->name == 'com_fields[anrede]' && $field->value !== '') { 
        $joom_user->anrede = $field->value; 
      } else if ($field->name == 'com_fields[telefon]' && $field->value !== '') { 
        $joom_user->telefon = $field->value; 
      } else if ($field->name == 'com_fields[webseite]' && $field->value !== '') { 
        $joom_user->webseite = $field->value; 
      } else if ($field->name == 'com_fields[adresse]' && $field->value !== '') { 
        $joom_user->adresse = $field->value; 
      } else if ($field->name == 'com_fields[plz]' && $field->value !== '') { 
        $joom_user->plz = $field->value; 
      }  else if ($field->name == 'com_fields[ort]' && $field->value !== '') { 
        $joom_user->ort = $field->value; 
      }  else if ($field->name == 'com_fields[land]' && $field->value !== '') { 
        $joom_user->land = $field->value; 
      }
    }
    $joom_user->profile_address1 = $joom_user->profile['address1'] ;
    $joom_user->profile_address2 = $joom_user->profile['address2'] ;
    $joom_user->profile_city = $joom_user->profile['city'] ;
    $joom_user->profile_country = $joom_user->profile['country'] ;
    $joom_user->profile_postal_code = $joom_user->profile['postal_code'] ;
    $joom_user->profile_phone = $joom_user->profile['phone'] ;
    $joom_user->profile_website = $joom_user->profile['website'] ;

      // print_r(":1111111111111111:");
      // print_r($joom_user );
      // exit;
    return $joom_user ;
  }
}

if (!function_exists('incorrect_price')) {
  function incorrect_price($price){
//    if(preg_match('/\D/i',$price) == 1){
//    if(preg_match('/^[0-9]*\.{0,1}[0-9]*$/',$price) == 1){
    if(preg_match('/^[0-9]*[.]{0,1}[0-9]*$/',$price) == 1){
      //price is correct !
      return false;
    }else{
      return true;
    }
  }
}

if (!function_exists('CAT_Utils_categoryArray')) {
   function CAT_Utils_categoryArray() {
        global $database;
        // get a list of the menu items
        $query = "SELECT c.*, c.parent_id AS parent"
                . "\n FROM #__rem_main_categories c"
                . "\n WHERE section='com_realestatemanager'"
                . "\n AND published <> -2"
                . "\n ORDER BY ordering";
        $database->setQuery($query);
        $items = $database->loadObjectList();
        // establish the hierarchy of the menu
        $children = array();
        // first pass - collect children
        foreach ($items as $v) {
            $pt = $v->parent;
            $list = @$children[$pt] ? $children[$pt] : array();
            array_push($list, $v);
            $children[$pt] = $list;
        }
        // second pass - get an indent list of the items
        $array = mosTreeRecurseREM(0, '', array(), $children);
        return $array;
    }
}

if (!function_exists('mosMail'))
{
    function mosMail($from, $fromname, $recipient, $subject, $body, $mode = 0, $cc = NULL, $bcc = NULL, $attachment = NULL, $replyto = NULL, $replytoname = NULL)
    {
        
      try {

        // // old version function
        // // $mail = JMail::getInstance();
        // // return $mail->sendMail($from, $fromname, $recipient, $subject, $body, $mode, $cc, $bcc, $attachment, $replyto, $replytoname);
        // // ----------------------------------------------------
        // $mailer = JFactory::getMailer();

        // $mailer->setSender(array($from, $fromname));
        // $mailer->setSubject($subject);
        // $mailer->setBody($body);

        // // Are we sending the email as HTML?
        // if ($mode) {
        //     $mailer->isHTML(true);
        // }

        // if (!is_array($recipient)) {
        //     $recipient = explode(',', $recipient);
        // }

        // $mailer->addRecipient($recipient);
        // $mailer->addCC($cc);
        // $mailer->addBCC($bcc);
        // $mailer->addAttachment($attachment);

        // // Take care of reply email addresses
        // if (is_array($replyto)) {
        //     $numReplyTo = count($replyto);
        //     for ($i=0; $i < $numReplyTo; $i++){
        //         $mailer->addReplyTo(array($replyto[$i], $replytoname[$i]));
        //     }
        // } elseif (isset($replyto)) {
        //     $mailer->addReplyTo(array($replyto, $replytoname));
        // }
        // $ret = $mailer->Send();

            $a = JFactory::getMailer();
            return $a->sendMail($from, $fromname, $recipient, $subject, $body, $mode, $cc, $bcc, $attachment, $replyto, $replytoname);
  
      } catch (Exception $e) {
          JFactory::getApplication()->enqueueMessage(JText::_($e->getMessage()), 'error');
          $ret = false;
      }
      return $ret ;
    }
}

if (!function_exists('mosLoadAdminModules')) {

  function mosLoadAdminModules($position = 'left', $style = 0) {
      // Select the module chrome function
      if (is_numeric($style)) {
          switch ($style) {
              case 2:
                  $style = 'xhtml';
                  break;
              case 0:
              default:
                  $style = 'raw';
                  break;
          }
      }
      ?><jdoc:include type="modules" name="<?php echo $position ?>" style="<?php echo $style ?>" /><?php
  }

}
/**
* Legacy function, using <jdoc:include type="module" /> instead
*
* @deprecated  As of version 1.5
*/
if (!function_exists('mosLoadAdminModule')) {

  function mosLoadAdminModule($name, $style = 0) {
      ?><jdoc:include type="module" name="<?php echo $name ?>" style="<?php echo $style ?>" /><?php
  }

}
/**
*
* @deprecated  As of version 1.5
*/
if (!function_exists('mosStripslashes')) {

  function mosStripslashes(&$value) {
      $ret = '';
      if (is_string($value)) {
          $ret = stripslashes($value);
      } else {
          if (is_array($value)) {
              $ret = array();
              foreach ($value as $key => $val)
                  $ret[$key] = mosStripslashes($val);
          } else
              $ret = $value;
      }
      return $ret;
  }

}


if (!function_exists('imagecopymerge_alpha')) {
    function imagecopymerge_alpha($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct){
        // creating a cut resource
        $cut = imagecreatetruecolor($src_w, $src_h);

        // copying relevant section from background to the cut resource
        imagecopy($cut, $dst_im, 0, 0, $dst_x, $dst_y, $src_w, $src_h);

        // copying relevant section from watermark to the cut resource
        imagecopy($cut, $src_im, 0, 0, $src_x, $src_y, $src_w, $src_h);

        imagealphablending($dst_im, false);
        imagesavealpha($dst_im,true);
        // insert cut resource to destination image
        imagecopymerge($dst_im, $cut, $dst_x, $dst_y, 0, 0, $src_w, $src_h, $pct);
        return $dst_im;
    }
}


if (!function_exists('getImageCreateFunction')) {
  function getImageCreateFunction($type){
        switch ($type) {
            case 'jpeg':
            case 'jpg':
                $imageCreateFunc = 'imagecreatefromjpeg';
                break;

            case 'png':
                $imageCreateFunc = 'imagecreatefrompng';
                break;

            case 'bmp':
                $imageCreateFunc = 'imagecreatefrombmp';
                break;

            case 'gif':
                $imageCreateFunc = 'imagecreatefromgif';
                break;

            case 'vnd.wap.wbmp':
                $imageCreateFunc = 'imagecreatefromwbmp';
                break;

            case 'xbm':
                $imageCreateFunc = 'imagecreatefromxbm';
                break;

            default:
                $imageCreateFunc = 'imagecreatefromjpeg';
                break;
        }
        return $imageCreateFunc;
    }
}

if (!function_exists('getImageSaveFunction')) {
    function getImageSaveFunction($type) {
        switch ($type) {
            case 'jpeg':
                $imageSaveFunc = 'imagejpeg';
                break;

            case 'png':
                $imageSaveFunc = 'imagepng';
                break;

            case 'bmp':
                $imageSaveFunc = 'imagebmp';
                break;

            case 'gif':
                $imageSaveFunc = 'imagegif';
                break;

            case 'vnd.wap.wbmp':
                $imageSaveFunc = 'imagewbmp';
                break;

            case 'xbm':
                $imageSaveFunc = 'imagexbm';
                break;

            default:
                $imageSaveFunc = 'imagejpeg';
                break;
        }
        return $imageSaveFunc;
    }
}

// add watermark
if (!function_exists('rem_createWaterMark')) {

  function rem_createWaterMark($file_name, $params){

      global $mosConfig_absolute_path;
      global $realestatemanager_configuration;

      //get imfo about original image
      $original_src = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/'.$file_name;
      $original_info = getimagesize($original_src, $original_info);
      $original_width = $original_info[0];
      $original_height = $original_info[1];
      $original_ext = str_replace('image/', '', $original_info['mime']);

      //get create and save function
      $imageCreateFunc = getImageCreateFunction($original_ext);
      $imageSaveFunc = getImageSaveFunction($original_ext);
      $sImage = $imageCreateFunc($original_src);
      $dImage = imagecreatetruecolor($original_width, $original_height);

      // Make transparent
      if ($original_ext == 'png') {
        imagealphablending($dImage, false);
        imagesavealpha($dImage,true);
        $transparent = imagecolorallocatealpha($dImage, 255, 255, 255, 127);
        imagefilledrectangle($dImage, 0, 0, $original_width, $original_height, $transparent);
      }

      //get watermark
      if($realestatemanager_configuration['watermark']['type']== 'image'){
            $mark = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark/watermark_img.png';
      }else{
          //create text watermark
          //get size of text

          $text = $params["text"];
          $font = $mosConfig_absolute_path . '/components/com_realestatemanager/includes/fonts/font.ttf';
          $textSizes = 200;
          $textAngle = $params["angle"];
          //size,angle
          $TextSizes = imagettfbbox($textSizes, $textAngle, $font, $text);
          if($textAngle==45){
              $width = $height = abs($TextSizes[5] - $TextSizes[1]);
          }else{
              $width = abs($TextSizes[4] - $TextSizes[0]);
              $height = abs($TextSizes[5] - $TextSizes[1]);
          }

          $height = $height*1.5;

          $mark = imagecreatetruecolor($width, $height);
          imagealphablending($mark, false);
          imagesavealpha($mark,true);
          $white = imagecolorallocatealpha($mark, 255, 255, 255, 127);
          $grey = imagecolorallocate($mark, 128, 128, 128);
          $fontColor = str_replace("rgba(", '', $params["color"]);
          $fontColor = str_replace(")", '', $fontColor);
          $fontColor = explode(',', $fontColor);
          $r = isset($fontColor[0])?$fontColor[0]:0;
          $g = isset($fontColor[1])?$fontColor[1]:0;
          $b = isset($fontColor[2])?$fontColor[2]:0;

          // print_r($r);
          // exit;

          $fontColor = imagecolorallocate($mark, $r, $g, $b);
          imagefilledrectangle($mark, 0, 0, $width, $height, $white);

          // Тень
          //size,angle
          if($textAngle ==45){
              $margin = $textSizes/2;
              $offset = $height;
          }else if($textAngle == 90){
              $margin = $textSizes;
              $offset = $height;
              }else{
                  $margin = 0;
                  $offset = $textSizes;
              }
              imagettftext($mark, $textSizes, $textAngle, $margin+1, $offset+1, $grey, $font, $text);
              // Текст
              //size,angle
              if($textAngle ==45){
                  $margin = $textSizes/2;
                  $offset = $height;
              }else if($textAngle == 90){
                  $margin = $textSizes;
                  $offset = $height;
              }else{
                  $margin = 0;
                  $offset = $textSizes;
              }
              imagettftext($mark, $textSizes, $textAngle, $margin, $offset, $fontColor, $font, $text);

                $dest = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark/watermark.png';



              imagepng($mark, $dest);
              imagedestroy($mark);
              //end
              //print_r('http://localhost/~akosha/Joomla_clear/images/com_osgallery/gal-'.$galId.'/watermark/text_watermark.png');exit;
              $mark = $dest;
          }
          $watermark_info = getimagesize($mark, $watermark_info);
          $watermark_ext = str_replace('image/', '', $watermark_info['mime']);
          $watermarkCreateFunc = getImageCreateFunction($watermark_ext);
          $watermark = $watermarkCreateFunc($mark);
          $watermark_width = imagesx($watermark);
          $watermark_height = imagesy($watermark);

          $margin = 10;

          //old size (value in px)
          // $sx = ($watermark_width < $original_width)?$watermark_width : $original_width-$original_width*0.5;
          // $sy = ($watermark_height < $original_height)?$watermark_height : $original_height-$original_height*0.5;;

          $sx = $original_width*$params["size"]/100;
          $sy = $watermark_height*($sx/$watermark_width);

          $xx = $original_width;
          $yy = $original_height;
          $position = $params["position"];

          switch ($position) {
              case 'top_left':
                  $x = $margin;
                  $y = $margin;
                  break;
              case 'top_right':
                  $x = $xx - $sx - $margin;
                  $y = $margin;
                  break;
              case 'bottom_left':
                  $x = $margin;
                  $y = $yy - $sy - $margin;
                  break;
              case 'bottom_right':
                  $x = $xx - $sx - $margin;
                  $y = $yy - $sy - $margin;
                  break;
              case 'center':
                  $x = $xx/2-$sx/2;
                  $y = $yy/2-$sy/2;
                  break;
          }

          //RESIZE watermark save transparrent
          $resize_mark = imagecreatetruecolor($sx, $sy);
          imagealphablending($resize_mark, false);
          imagesavealpha($resize_mark,true);
          $transparent = imagecolorallocatealpha($resize_mark, 255, 255, 255, 127);

          imagecopyresampled($resize_mark, $watermark, 0, 0, 0, 0, $sx, $sy, $watermark_width, $watermark_height);

          //save transparent in main image
          $sImage = imagecopymerge_alpha($sImage, $resize_mark, $x, $y, 0, 0, $sx, $sy,$params['opacity']);

          $save_src = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark/'.$file_name;

          if ($original_ext == 'png') {
            $imageSaveFunc($sImage, $save_src, 9);
          }
          else if ($original_ext == 'gif') {
            $imageSaveFunc($sImage, $save_src);
          }
          else {
            $imageSaveFunc($sImage, $save_src, 90);
          }
  }

}



if (!function_exists("formatMoney")) {

  function formatMoney($number, $fractional = false, $pattern = ".") {
      if(preg_match("/\d/", $pattern)){

          $msg = "Your separator: $pattern - incorrect, you can not use numbers, to split price" ;
          echo '<script>alert("'.$msg.'");</script>';
          $pattern = ".";
      }
      if ($fractional) {
          $number = sprintf('%.2f', $number);
      }
      if ($pattern == ".")
          $number = str_replace(".", ",", $number);
      while (true) {
          $replaced = preg_replace('/(-?\d+)(\d\d\d)/', '$1' . $pattern . '$2', $number);
          //echo $replaced."<br>";
          if ($replaced != $number) {
              $number = $replaced;
          } else {
              break;
          }
      }
      // $number = preg_replace('/\^/', $number, $pattern);
      return $number;
  }

}
/**
* Legacy function, use {@link JFolder::files()} or {@link JFolder::folders()} instead
*
* @deprecated  As of version 1.5
*/
if (!function_exists('mosReadDirectory')) {

  function mosReadDirectory($path, $filter = '.', $recurse = false, $fullpath = false) {
      $arr = array(null);
      // Get the files and folders
      jimport('joomla.filesystem.folder');
      $files = JFolder::files($path, $filter, $recurse, $fullpath);
      $folders = JFolder::folders($path, $filter, $recurse, $fullpath);
      // Merge files and folders into one array
      $arr = array();
      if (is_array($files))
          $arr = $files;
      if (is_array($folders))
          $arr = array_merge($arr, $folders);
      // Sort them all
      asort($arr);
      return $arr;
  }

}
/**
*
* @deprecated  As of version 1.5
*/
if (!function_exists('date_to_data_ms')){
  function date_to_data_ms($data_string){             // 2014-01-25 covetr to date in ms

      global $database;

//        $date = data_transform_rem($data_string);

/*        $query = "SELECT UNIX_TIMESTAMP('$data_string')";
      $database->setQuery($query);
      $rent_ms = $database->loadResult();

      return $rent_ms;*/
      if($data_string){
         $rent_mas = explode('-', $data_string);
         $month=$rent_mas[1];
         $day=$rent_mas[2];
         $year=$rent_mas[0];
         $rent_ms = mktime ( 0 ,0, 0, $month , $day , $year);
         return $rent_ms;
     }else{
          exit;
      }
  }
}
if (!function_exists('mosRedirect')) {

  function mosRedirect($url, $msg = '') {
      $mainframe = JFactory::getApplication(); 
      if($msg != "") $mainframe->enqueueMessage($msg);
      $mainframe->redirect($url);
  }

}
/**
* Legacy function, use {@link ArrayHelper::getValue()} instead
*
* @deprecated  As of version 1.5
*/
if (!function_exists('mosGetParam')) {
  function mosGetParam(&$arr, $name, $def = null,$filter = "STRING" ) {
      // Static input filters for specific settings
      $jinput = JFactory::getApplication()->input;
         
      return $jinput->get($name, $def,$filter);
  
      // Static input filters for specific settings
      // static $noHtmlFilter = null;
      // static $safeHtmlFilter = null;
      // $var = Joomla\Utilities\ArrayHelper::getValue($arr, $name, $def, '');
      // // If the no trim flag is not set, trim the variable
      // if (!($mask & 1) && is_string($var))
      //     $var = trim($var);
      // // Now we handle input filtering
      // if ($mask & 2) {
      //     // If the allow html flag is set, apply a safe html filter to the variable
      //     if (is_null($safeHtmlFilter))
      //         $safeHtmlFilter = JFilterInput::getInstance(null, null, 1, 1);
      //     $var = $safeHtmlFilter->clean($var, 'none');
      // } elseif ($mask & 4) {
      //     // If the allow raw flag is set, do not modify the variable
      //     $var = $var;
      // } else {
      //     // Since no allow flags were set, we will apply the most strict filter to the variable
      //     if (is_null($noHtmlFilter)) {
      //         $noHtmlFilter = JFilterInput::getInstance(/* $tags, $attr, $tag_method, $attr_method, $xss_auto */
      //         );
      //     }
      //     $var = $noHtmlFilter->clean($var, 'none');
      // }
      // return $var;
  }

}
/**
* Legacy function, use {@link JEditor::save()} or {@link JEditor::getContent()} instead
*
* @deprecated  As of version 1.5
*/
if (!function_exists('getEditorContents')) {

  function getEditorContents($editorArea, $hiddenField) {
      jimport('joomla.html.editor');
      $editor = JEditor::getInstance();
      echo $editor->save($hiddenField);
  }

}
/**
* Legacy function, use {@link JFilterOutput::objectHTMLSafe()} instead
*
* @deprecated  As of version 1.5
*/
if (!function_exists('mosMakeHtmlSafe')) {

  function mosMakeHtmlSafe(&$mixed, $quote_style = ENT_QUOTES, $exclude_keys = '') {
      JFilterOutput::objectHTMLSafe($mixed, $quote_style, $exclude_keys);
  }

}
/**
* Legacy utility function to provide ToolTips
*
* @deprecated As of version 1.5
*/

/* The Mootools have conflict with GoogleMap. GoogleMap StreetView don`t work when Mootools turn on.
It looks like we use the Mootools only for the function "window.addEvent(domready, function() {". Replace this function on Mootools on the same function on jQoery "jQuerOs(document).ready(function() {".
Turn off The Mootools in our components. */
/*if (!function_exists('mosToolTip')) {
  function mosToolTip($tooltip, $title = '', $width = '', $image = 'tooltip.png', $text = '', $href = '', $link = 1) {
      // Initialize the toolips if required
      static $init;
      if (!$init) {
          JHTML::_('behavior.tooltip');
          $init = true;
      }
      return JHTML::_('tooltip', $tooltip, $title, $image, $text, $href, $link);
  }
}*/

/**
* Legacy function to replaces &amp; with & for xhtml compliance
*
* @deprecated  As of version 1.5
*/
if (!function_exists('mosTreeRecurseREM')) {

  function mosTreeRecurseREM($id, $indent, $list, &$children, $maxlevel = 9999, $level = 0, $type = 1) {
      if (@$children[$id] && $level <= $maxlevel) {
          $parent_id = $id;
          foreach ($children[$id] as $v) {
              $id = $v->id;
              if ($type) {
                  $pre = 'L ';
                  $spacer = '.      ';
              } else {
                  $pre = '- ';
                  $spacer = '  ';
              }
              if ($v->parent == 0)
                  $txt = $v->name;
              else
                  $txt = $pre . $v->name;
              $pt = $v->parent;
              $list[$id] = $v;
              $list[$id]->treename = "$indent$txt";

              if(isset($children[$id])){
                  $list[$id]->children = count(@$children[$id]);
              }else{
                  $list[$id]->children = 0;
              }
              $list[$id]->all_fields_in_list = count(@$children[$parent_id]);
              $list = mosTreeRecurseREM($id, $indent . $spacer, $list, $children, $maxlevel, $level + 1, $type);
          }
      }
      return $list;
  }

}
if (!function_exists('getGroupsByUser')) {

  function getGroupsByUser($uid, $recurse) {
      if (version_compare(JVERSION, "1.6.0", "lt")) {

      } else if (version_compare(JVERSION, "1.6.0", "ge")) {
          $database = JFactory::getDBO();
          // Custom algorythm
          $usergroups = array();
          if ($recurse == 'RECURSE') {
              // [1]: Recurse getting the usergroups
              $id_group = array();
              $q1 = "SELECT group_id FROM `#__user_usergroup_map` WHERE user_id={$uid}";
              $database->setQuery($q1);
              $rows1 = $database->loadObjectList();
              foreach ($rows1 as $v)
                  $id_group[] = $v->group_id;
              for ($k = 0; $k < count($id_group); $k++) {
                  $q = "SELECT g2.id FROM `#__usergroups` g1 "
                   . " LEFT JOIN `#__usergroups` g2 ON g1.lft > g2.lft AND g1.lft < g2.rgt "
                   . " WHERE g1.id={$id_group[$k]} ORDER BY g2.lft";
                  $database->setQuery($q);
                  $rows = $database->loadObjectList();
                  foreach ($rows as $r)
                      $usergroups[] = $r->id;
              }
              $usergroups = array_unique($usergroups);
          }
          // [2]: Non-Recurse getting usergroups
          $q = "SELECT * FROM #__user_usergroup_map WHERE user_id = {$uid}";
          $database->setQuery($q);
          $rows = $database->loadObjectList();
          foreach ($rows as $k => $v)
              $usergroups[] = $rows[$k]->group_id;
          // If user is unregistered, Joomla contains it into standard group (Public by default).
          // So, groupId for anonymous users is 1 (by default).
          // But custom algorythm doesnt do this: if user is not autorised, he will NOT connected to any group.
          // And groupId will be 0.
          if (count($rows) == 0)
              $usergroups[] = - 2;
          return $usergroups;
      } else {
          echo "Sanity test. Error version check!";
          exit;
      }
  }

}

if (!function_exists('getWhereUsergroupsCondition')) {

  function getWhereUsergroupsCondition($table_alias) {
      // Get Current User 
      if (version_compare(JVERSION, "4.0.0", "ge")) {
          $app = JFactory::getApplication();
          $my = $app->getIdentity();
      } else {
          $my = JFactory::getUser(); 
      }

      if (isset($my->id) AND $my->id != 0)
          $usergroups_sh = getGroupsByUser($my->id, '');
      else
          $usergroups_sh = array();
      $usergroups_sh[] = - 2;
      $s = '';
      for ($i = 0; $i < count($usergroups_sh); $i++) {
          $g = $usergroups_sh[$i];
          $s.= " $table_alias.params LIKE '%,{$g}' or $table_alias.params = '{$g}' or " .
            "$table_alias.params LIKE '{$g},%' or $table_alias.params LIKE '%,{$g},%' ";
          if (($i + 1) < count($usergroups_sh))
              $s.= ' or ';
      }
      return $s;
  }

}

//  Returns a string for WHERE condition
// [call]: $s = getWhereDatePublishStringRem ( "alias_name" );
// (alias_name) its a `#__rem_main_categories` table alias.
// (alias_name) depends of the particular query, as usual its "c", "cc" or something like this.
if (!function_exists('getWhereDatePublishStringRem')) {
    function getWhereDatePublishStringRem($table_alias) {
        
        $s = '';
        $s.= " ( $table_alias.publish_up <= now() or 
                $table_alias.publish_up = '0000-00-00 00:00:00' or 
                ($table_alias.publish_up IS NULL) ) and 
               ( $table_alias.publish_down >= now() or
                $table_alias.publish_down = '0000-00-00 00:00:00' or 
                ($table_alias.publish_down IS NULL) ) ";
        return $s;
    }
}

if (!function_exists('addSubMenuRealEstate')) {

  function addSubMenuRealEstate($vName) {

    if (version_compare(JVERSION, "4.0.0-alpha10", "ge")) {
        return;
    } 

    if (!defined('_HEADER_NUMBER')) loadConstRem();

      JSubMenuHelper::addEntry(JText::_(_HEADER_NUMBER),
       'index.php?option=com_realestatemanager', $vName == 'Houses');
      JSubMenuHelper::addEntry(JText::_(_CATEGORIES_NAME),
       'index.php?option=com_realestatemanager&section=categories', $vName == 'Categories');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_ADMIN_RENT_REQUESTS),
       'index.php?option=com_realestatemanager&task=rent_requests', $vName == 'Rent Requests');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_ADMIN_RENT_HISTORY),
       'index.php?option=com_realestatemanager&task=users_rent_history', $vName == 'Users Booking History');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_ADMIN_SALE_MANAGER_MENU),
       'index.php?option=com_realestatemanager&task=buying_requests', $vName == 'Sale Manager');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_ADMIN_PROPERTY_REQUEST_MANAGER_MENU),
       'index.php?option=com_realestatemanager&task=property_requests', $vName == 'Requests Manager');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_LABEL_FEATURED_MANAGER_FEATURE_MANAGER),
       'index.php?option=com_realestatemanager&section=featured_manager', $vName == 'Features Manager');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_LABEL_LANGUAGE_MENU),
       'index.php?option=com_realestatemanager&section=language_manager', $vName == 'Language Manager');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_ADMIN_LABEL_SETTINGS),
       'index.php?option=com_realestatemanager&task=config', $vName == 'Settings');
      JSubMenuHelper::addEntry(JText::_(_REALESTATE_MANAGER_ADMIN_ABOUT_ABOUT),
       'index.php?option=com_realestatemanager&task=about', $vName == 'About');
    }

}


if (!function_exists('loadConstRem')) {
  function loadConstRem() {
    global $database, $mosConfig_absolute_path;
    //$is_exception = false;
    $database->setQuery("SELECT * FROM #__rem_languages");
    $langs = $database->loadObjectList();
    $component_path = JPath::clean($mosConfig_absolute_path . '/components/com_realestatemanager/lang/');
    $component_constans = array();
    if (is_dir($component_path) && ($component_constans =
      JFolder::files($component_path, '^[^_]*\.php$', false, true))) {
        //check and add constants file in DB
        foreach ($component_constans as $i => $file) {
          $file_name = pathinfo($file);
          $file_name = $file_name['filename'];
          if ($file_name === 'constant') {
            require($mosConfig_absolute_path . "/components/com_realestatemanager/lang/$file_name.php");
            foreach ( $constMas as $mas ) {
              $database->setQuery(
                "INSERT IGNORE INTO #__rem_const (const, sys_type) VALUES ('".
                $mas["const"]."','".$mas["value_const"]."')");
              $database->execute();
            }
          }
        }
        //check and add new text files in DB
        $flag1=true;
        print_r("<b>These constants exist in Languages files but not exist in file constants:</b><br><br>");
        foreach ($component_constans as $i => $file) {
          $file_name = pathinfo($file);
          $file_name = $file_name['filename'];
          $LangLocal = '';
          if ($file_name != 'constant') {
            require($mosConfig_absolute_path . "/components/com_realestatemanager/lang/$file_name.php");
            try {
              $database->setQuery("INSERT IGNORE INTO #__rem_languages (lang_code,title) VALUES ('"
                        . $LangLocal['lang_code'] . "','" . $LangLocal['title'] . "')");
              $database->execute();
              $database->setQuery("SELECT id FROM #__rem_languages " .
                 " WHERE lang_code = '" . $LangLocal['lang_code'] . "' AND title='".$LangLocal['title']."'");
              $idLang = $database->loadResult();
              foreach ($constLang as $item) {
                //if(!isset($item['value_const'])) var_dump($item);
                $database->setQuery("SELECT id FROM #__rem_const WHERE const = '" . $item['const'] . "'");
                $idConst = $database->loadResult();
                if(!array_key_exists ( 'value_const'  , $item ) || !$idConst){
                     print_r($item['const']." not exist in file <b>'constant'</b> for this language:  <b>"
                   . $LangLocal['title']."</b>.");
                   $flag1 = false;
                } else {
                  $database->setQuery(
                   "INSERT IGNORE INTO #__rem_const_languages (fk_constid,fk_languagesid,value_const) "
                   . " VALUES ($idConst, $idLang, " . $database->quote($item['value_const']) . ")");
                  $database->execute();
                }
              }
            } catch (Exception $e) {
              //$is_exception = true;
              echo 'Send exception, please write to admin for language check: ',  $e->getMessage(), "\n";
            }
          }
        }
        if($flag1){
          print_r("<br /><p style='color:green;'><b>Everything is [ OK ]</b></p><br />");
        }
        else{
          print_r("<br><b style='color:red;'>This constants not loaded.!</b><br><br>");
        }
        //if($is_exception)
        language_check();
        //if text constant missing recover they in DB
        if (!defined('_HEADER_NUMBER')) {
          $query = "SELECT c.const, cl.value_const ";
          $query .= "FROM #__rem_const_languages as cl ";
          $query .= "LEFT JOIN #__rem_languages AS l ON cl.fk_languagesid=l.id ";
          $query .= "LEFT JOIN #__rem_const AS c ON cl.fk_constid=c.id ";
          $query .= "WHERE l.lang_code = 'en-GB'";
          $database->setQuery($query);
          $langConst = $database->loadObjectList();
          foreach ($langConst as $item) {
            if(!defined($item->const)){
              define($item->const, $item->value_const);
            }
          }
        }
    }

    //if some language file missing recover it
    $component_path = JPath::clean($mosConfig_absolute_path . '/components/com_realestatemanager/lang/');
    $component_constans = array();
    if (is_dir($component_path) && ($component_constans = JFolder::files($component_path, '^[^_]*\.php$', false, true))) {
      foreach ($component_constans as $i => $file) {
        $isLang = 0;
        $file_name = pathinfo($file);
        $file_name = $file_name['filename'];
        if ($file_name != 'constant') {
          require($mosConfig_absolute_path . "/components/com_realestatemanager/lang/$file_name.php");
          //$fileMas[] = $LangLocal;
          $fileMas[] = $LangLocal['title'];
        }
      }
    }


    $database->setQuery("SELECT title FROM #__rem_languages");
    if (version_compare(JVERSION, '3.0', 'lt')) {
      $langs = $database->loadResultArray();
    } else {
      $langs = $database->loadColumn();
    }
    if (count($langs) > count($fileMas)) {
      $results = array_diff($langs, $fileMas);
      foreach ($results as $result) {
        $database->setQuery("SELECT lang_code FROM #__rem_languages WHERE title = '$result'");
        $lang_code = $database->loadResult();
        $langfile = "<?php if( !defined( '_VALID_MOS' ) && !defined( '_JEXEC' ) ) "
         . "die( 'Direct Access to '.basename(__FILE__).' is not allowed.' );";
        $langfile .= "\n\n/**\n*\n* @package  RealestateManager\n"
         . "* @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);\n"
         . "* Homepage: https://ordasoft.com/joomla-real-estate\n* @version: 5.0 PRO\n*\n* */\n\n";
        $langfile .= "\$LangLocal = array('lang_code'=>'$lang_code', 'title'=>'$result');\n\n";
        $langfile .= "\$constLang = array();\n\n";

        $query = "SELECT c.const, cl.value_const ";
        $query .= "FROM #__rem_const_languages as cl ";
        $query .= "LEFT JOIN #__rem_languages AS l ON cl.fk_languagesid=l.id ";
        $query .= "LEFT JOIN #__rem_const AS c ON cl.fk_constid=c.id ";
        $query .= "WHERE l.title = '$result'";

        $database->setQuery($query);
        $constlanguages = $database->loadObjectList();

        foreach ($constlanguages as $constlanguage) {
            $langfile .= "\$constLang[] = array('const'=>'" . $constlanguage->const
             . "', 'value_const'=>" . $database->quote($constlanguage->value_const) . ");\n";
        }

        // Write out new initialization file
        $fd = fopen($mosConfig_absolute_path . "/components/com_realestatemanager/lang/$result.php", "w")
         or die("Cannot create language file.");
        fwrite($fd, $langfile);
        fclose($fd);
      }
    }
  }
}

if (!function_exists('language_check')) {
  function language_check($component_db_name = 'rem' ) {
    global $database;
    $database->setQuery("SELECT * FROM #__".$component_db_name."_languages");
    $langIds = $database->loadObjectList();

    $flag2=true;
    print_r("<br /><b>These constants exit in file constants but not exist in Languages files:</b><br />");
    foreach ($langIds as $langId){
      $query = " SELECT  lc.*  FROM    #__".$component_db_name."_const as lc ";
      $query .= " WHERE  NOT EXISTS ";
      $query .= " ( SELECT  l1.*  FROM #__".$component_db_name."_const_languages as l1 ";
      $query .= " WHERE lc.id = l1.`fk_constid` and l1.fk_languagesid = ".$langId->id.") ";
      $query .= " and lc.sys_type != 'Features' and lc.sys_type != 'Features Category'   ";
      $database->setQuery($query);
      $badLangConsts = $database->loadObjectList();
        if($badLangConsts){
          $flag2 = false;
          print_r("<br />Languages: ".$langId->title."<br />");
          print_r($badLangConsts);
          echo "<br><br>";
        }
      }
      if($flag2)
        print_r("<br /><p style='color:green;'><b>Everything is [ OK ]</b></p><br /><br />");
  }
}

if (!function_exists('remove_langs')) {
  function remove_langs($component_db_name = 'rem' ) {
       global $database;


      $query = " TRUNCATE TABLE #__".$component_db_name."_languages; ";
      $database->setQuery($query);
      $database->execute();

      $query = " TRUNCATE TABLE #__".$component_db_name."_const; ";
      $database->setQuery($query);
      $database->execute();

      $query = " TRUNCATE TABLE #__".$component_db_name."_const_languages ;";
      $database->setQuery($query);
      $database->execute();

  }
}

// Updated on June 25, 2011
// accessgroupid - array which contains accepted user groups for this item
// usersgroupid - groupId of the user
// For anonymous user Uid = 0 and Gid = 0
if (!function_exists('checkAccess_REM')) {
  function checkAccess_REM($accessgroupid, $recurse, $usersgroupid, $acl) {
      
      if (!is_array($usersgroupid)) {
          $usersgroupid = explode(',', $usersgroupid);
      }
      //parse usergroups
      $tempArr = array();
      $tempArr = explode(',', $accessgroupid);
      
      for ($i = 0; $i < count($tempArr); $i++) {
          if (((!is_array($usersgroupid) && $tempArr[$i] == $usersgroupid) OR
                 (is_array($usersgroupid) && in_array($tempArr[$i], $usersgroupid))) || $tempArr[$i] == - 2) {
              //allow access
              return true;
          } else {
              if ($recurse == 'RECURSE') {
                  if (is_array($usersgroupid)) {
                      foreach ($usersgroupid as $j)
                          if (in_array($j, $tempArr))
                              return 1;
                  } else {
                      if (in_array($usersgroupid, $tempArr))
                          return 1;
                  }
              }
          }
      } // end for
      //deny access
      return 0;
  }

}
if (!function_exists('editorArea')) {

  function editorArea($name, $content, $hiddenField, $width, $height, $col, $row, $option = true) {

    if (version_compare(JVERSION, "4.0.0-alpha10", "ge")) {
        jimport('joomla.html.editor');
        // get editor selected in global settings:
        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $app = JFactory::getApplication();
            $config = $app->getConfig();
        } else {
            $config = JFactory::getConfig(); 
        }
        $global_editor = $config->get( 'editor' );

        // Get Current User 
        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $app = JFactory::getApplication();
            $my = $app->getIdentity();
        } else {
            $my = JFactory::getUser(); 
        }
        // get user's default editor
        $user_editor = $my->getParam("editor");
        if($user_editor && $user_editor !== 'JEditor') {
            $selected_editor = $user_editor;
        } else {
            $selected_editor = $global_editor;
        }
        $editor = JEditor::getInstance($selected_editor);
        // display(string $name, string $html, string $width, string $height, integer $col, integer $row, boolean $buttons = true, string $id = null, string $asset = null, object $author = null, array $params = array()) : string
        echo $editor->display($hiddenField, $content, $width, $height, $col, $row, $option);
    } else {
        jimport('joomla.html.editor');
        $editor = JFactory::getEditor();
        echo $editor->display($hiddenField, $content, $width, $height, $col, $row, $option);
    }


  }

}

if(!function_exists('protectInjection')){
    function protectInjection($element, $def = '', $filter = "STRING",$bypass_get=false){
        
        $database = JFactory::getDBO();
        
        if(!$bypass_get){
          $value = JFactory::getApplication()->input->get($element, $def, $filter);
        // $value = $element;
        }else{
          $value = $element;
        }

        if(!isset($value) ) return $def;


        if(is_array($value)){
            foreach($value as $key=>$item_value){
                $value[$key] = $database->quote($item_value);
            }
            return $value ;

        }

        return $database->quote($value);
    }

}

if(!function_exists('protectInjectionWithoutQuote')){
    function protectInjectionWithoutQuote($element, $def = '', $filter = "STRING", $bypass_get=false){
        
        $database = JFactory::getDBO();
        
        if(!$bypass_get){
                $value = JFactory::getApplication()->input->get($element, $def, $filter);
                // $value = $element;
             }else{
                $value = $element;
             }

        if(!isset($value) ) return $def;
        $special_symb = array("/*","*/","select", "insert", "update", "drop", "delete", "alter");

        if(is_array($value)){
            foreach($value as $key => $val){
                if(!is_array($val)){
                    $isset_spec_symb = false;
                    foreach($special_symb as $symb){
                        $indx = stripos($val, $symb);
                        if($indx  !== false){
                            if($indx == 0 && preg_match('#'.$symb.'[0-9a-zA-Z@]+#i', $val)==0 ){
                                $isset_spec_symb = true;
                                continue;
                            } else if($indx > 0 && preg_match('#[0-9a-zA-Z@]+'.$symb.'#i', $val)==0 ){
                                $isset_spec_symb = true;
                                continue;
                            }
                        }
                    }
                    if($isset_spec_symb){
                        $val = protectInjection($val, $def , $filter ,true);
                    }else{
                        $val = protectInjectionWithoutQuote($val, $def , $filter ,true);
                    }
                }else{
                    $val = protectInjectionWithoutQuote($val, $def , $filter ,true);
                }
                $value[$key] = $val;
            }
        }else {
            $isset_spec_symb = false;
            foreach($special_symb as $symb){
                $indx = stripos($value, $symb);
                if($indx !== false){
                    if($indx == 0 && preg_match('#'.$symb.'[0-9a-zA-Z@]+#i', $value)==0 ){
                        $isset_spec_symb = true;
                        continue;
                    } else if($indx > 0 && preg_match('#[0-9a-zA-Z@]+'.$symb.'#i', $value)==0 ){
                        $isset_spec_symb = true;
                        continue;
                    }
                }
            }
            if($isset_spec_symb){
                $value = protectInjection($value, $def , $filter ,true);
            }else{
                $value = $database->escape($value);
            }
        }

        return $value;
    }
}


if (!class_exists('getLayoutPath')) {

  class getLayoutPath {

      static function getLayoutPathCom($components, $type, $layout = 'default') {
          $template = JFactory::getApplication()->getTemplate();

          if ( !isset($layout) || $layout  === "")  $layout = 'default' ;

          $defaultLayout = $layout;

          if (strpos($layout, ':') !== false) {
              // Get the template and file name from the string
              $temp = explode(':', $layout);
              $template = ($temp[0] == '_') ? $template : $temp[0];
              $layout = $temp[1];
              $defaultLayout = ($temp[1]) ? $temp[1] : 'default';
          }

          // Build the template and base path for the layout
          $tPath = JPATH_THEMES . '/' . $template . '/html/' . $components . '/' . $type . '/' . $layout . '.php';
          $cPath = JPATH_BASE . '/components/' . $components . '/views/' . $type . '/tmpl/' . $layout . '.php';
          $dPath = JPATH_BASE . '/components/' . $components . '/views/' . $type . '/tmpl/default.php';
          // If the template has a layout override use it
          if (file_exists($tPath)) {
              return $tPath;
          } else if (file_exists($cPath)) {
              return $cPath;
          } else if (file_exists($dPath)) {
              return $dPath;
          } else {
              echo "Bad layout path, please write to admin";
              exit;
          }
      }

  }

}

if (!function_exists('getLayoutsRem')) {

      function getLayoutsRem($components, $type) {
          global $database;
          $database = JFactory::getDBO();
          // get current template on frontend
          $template = '';
          $query = "SELECT template FROM #__template_styles WHERE client_id=0 AND home=1";
          $database->setQuery($query);
          $template = $database->loadResult();

          // Build the template and base path for the layout
          $tPath = JPATH_SITE . '/templates/' . $template . '/html/' . $components . '/' . $type . '/';
          $cPath = JPATH_SITE . '/components/' . $components . '/views/' . $type . '/tmpl/';

          $layouts1 = array();
          $layouts3 = array();

          if (is_dir($tPath) && ($layouts1 = JFolder::files($tPath, '^[^_]*\.php$', false, true))) {

              foreach ($layouts1 as $i => $file) {
                  $select_file_name = pathinfo($file);
                  $select_file_name = $select_file_name['filename'];
                  $layouts3[] = $select_file_name;
              }
          }
          $layouts2 = array();
          $layouts4 = array();

          if (is_dir($cPath) && ($layouts2 = JFolder::files($cPath, '^[^_]*\.php$', false, true))) {

              foreach ($layouts2 as $i => $file) {
                  $select_file_name = pathinfo($file);
                  $select_file_name = $select_file_name['filename'];
                  $layouts4[] =  $select_file_name;
              }
          }
          $layouts = array_merge($layouts3,$layouts4);
          $layouts = array_unique($layouts);
          return $layouts;
      }
}

if(!function_exists('transforDateFromPhpToJquery_rm')){
  function transforDateFromPhpToJquery_rm(){
    global $realestatemanager_configuration;
    $DateToFormat = str_replace("d",'dd',(str_replace("m",'mm',(str_replace("Y",'yy',(
      str_replace('%','',$realestatemanager_configuration['date_format'])))))));
    return $DateToFormat;
  }
}

//date_transform_rem - TRANSFER DATE or for show from database touser
//or for save to database from user
// $date_format -> "from" - from database to user , show in format from settings
// $date_format -> "to" - to database from user , save to format "Y-m-d"
if (!function_exists('date_transform_rem')) {
  function date_transform_rem($date, $date_format = "from") {
      global $realestatemanager_configuration, $database;

      if ( $date_format == "to" ) {
          $formatDateFrom = $realestatemanager_configuration['date_format'];
          $formatDateTo = 'Y-m-d';
      } else { // $date_format == "from"
           $date = substr($date, 0,10);
           $formatDateFrom = 'Y-m-d' ;
           $formatDateTo = $realestatemanager_configuration['date_format'] ;
      }

      $formatDateSource = str_replace("%","",$formatDateFrom);
      $formatDateTo = str_replace("%","",$formatDateTo);

      if(function_exists('date_format')){
          $dateObject = date_create_from_format($formatDateSource, $date);

          if($dateObject){
              $date = date_format($dateObject, $formatDateTo);
          } else $date = "" ;

      } else $date = "" ;

      if($date == "" ){
          $query = "SELECT STR_TO_DATE('$date','$formatDateTo')";
          $database->setQuery($query);
          $normaDat = $database->loadResult();

          if(strlen($normaDat) > 0){
              $date = $normaDat;
          }
      }
      return $date;

  }
}
if(!function_exists('calculate_rent_until_REM')){
  function calculate_rent_until_REM ( $rent_from, $rent_until,$how_many_weeks,$how_many_monthes){
    if($how_many_weeks > 0 ){
      $date = DateTime::createFromFormat('Y-m-d', $rent_from);
      $date->add(new DateInterval("P".( $how_many_weeks*7)."D")); 
      $rent_until = $date->format("Y-m-d"); 

    }else if ($how_many_monthes > 0 ){
      $date = DateTime::createFromFormat('Y-m-d', $rent_from);
      $date->add(new DateInterval("P".$how_many_monthes."M")); 
      $rent_until = $date->format("Y-m-d"); 

    }

    return $rent_until;
  }
}
if(!function_exists('checkRentDayNightREM')){
  function checkRentDayNightREM ($from, $until, $rent_from, $rent_until,$rent_by){
    global  $realestatemanager_configuration;
      if( $rent_by == "by_day" ){
        //there we check by day

          if (( $rent_from >= $from &&
                $rent_from <= $until) || ($rent_from <= $from &&
                $rent_until >= $until) || (
                $rent_until >= $from && $rent_until <= $until))
          {
              return 'Sorry, this item not is available from " '. $from .' " until " '. $until . '"';
          }
      }else{
        //there we check by night, by weeks, by monthes

          if($rent_from === $rent_until){
              return 'Sorry, not one night, not selected';
          }

          if($rent_from < $until && $rent_until > $from){
              return 'Sorry, this item not is available from " '. $from .' " until " '. $until . '"';
          }
      }
  }
}
if(!function_exists('createRentTable')){
      function createRentTable($rentTerm, $massage, $typeMessage){
          global $realestatemanager_configuration;
                    if($typeMessage === 'error'){
                  echo '<div id ="message-here" style ="color: red; font-size: 18px;" >'.$massage.'</div>';
              }else{
                  echo '<div id ="message-here" style ="color: gray; font-size: 18px;" >'.$massage.'</div>';
              }

          echo '<div id ="SpecialPriseBlock">';
              echo '<table class="adminlist_04" width ="100%" align ="center">';
                  echo '<tr>';
                      echo '<th class="title" align ="center" width ="25%">'.
                        _REALESTATE_MANAGER_RENT_PRICE_PER_DAY.'</th>';
                      echo '<th class="title" align ="center" width ="25%">'.
                        _REALESTATE_MANAGER_FROM.'</th>';
                      echo '<th class="title" align ="center" width ="25%" >'
                        ._REALESTATE_MANAGER_TO.'</th>';
                      echo '<th class="title" >'._REALESTATE_MANAGER_LABEL_REVIEW_COMMENT.'</th>';
                      echo '<th class="title" align ="center" width ="25%">'.
                        _REALESTATE_MANAGER_LABEL_CALENDAR_SELECT_DELETE.'</th>';
                  echo '</tr>';

                  for ($i = 0; $i < count($rentTerm); $i++) {
                      $DateToFormat = str_replace("D",'d',(str_replace("M",'m',(str_replace('%','',
                        $realestatemanager_configuration['date_format'])))));
                      $date_from = new DateTime($rentTerm[$i]->price_from);
                      $date_to = new DateTime($rentTerm[$i]->price_to);

                      echo '<tr>';
                          echo '<td align ="center">'.$rentTerm[$i]->special_price.'</td>';
                          echo '<td align ="center">'.date_format($date_from, $DateToFormat).'</td>';
                          echo '<td align ="center">'.date_format($date_to, $DateToFormat).'</td>';
                          echo '<td>'.$rentTerm[$i]->comment_price.'</td>';
                          echo '<td align ="center"><input type="checkbox" name="del_rent_sal[]" value="'
                           .$rentTerm[$i]->id.'"</td>';

                      echo '</tr>';
                  }
              echo '</table>';
              echo '<p>';


              echo '<p>';
          echo '</div>' ;

          exit;
      }
}


if(!function_exists('rentPriceREM')){


  function rentPriceREM($bid,$rent_from,$rent_until,$special_price,
    $comment_price,$currency_spacial_price){


      global $database, $realestatemanager_configuration;
      $rent_from_transf = date_transform_rem($rent_from,"to");
      $rent_until_transf = date_transform_rem($rent_until,"to");
      if(is_array($bid) && isset($bid[0])){
          $bid = $bid[0];
      }
      if($bid==''){
          $rentTerm = array();
          createRentTable($rentTerm, 'Please save or apply this item first','error');
          return;
      }
      
      $query = "SELECT * FROM #__rem_rent_sal where fk_houseid = " . $bid;
      $database->setQuery($query);
      $rentTerm = $database->loadObjectList();


      if($special_price==''){
          createRentTable($rentTerm, 'You need fill Price','error');
      }
      if($rent_from==''){
          createRentTable($rentTerm, 'You need fill Check In','error');
      }
      if($rent_until==''){
          createRentTable($rentTerm, 'You need fill Check Out','error');
      }
      if($rent_from_transf >$rent_until_transf){
          createRentTable($rentTerm, 'Incorrect Check Out','error');
      }

      $house = new mosRealEstateManager($database);
      $house->load( $bid );    

      foreach ($rentTerm as $oneTerm){
          $returnMessage = checkRentDayNightREM (($oneTerm->price_from),($oneTerm->price_to),
             $rent_from_transf, $rent_until_transf, $house->rent_by );

          if(strlen($returnMessage) > 0){
              createRentTable($rentTerm, $returnMessage, 'error');
          }
      }

      $sql = "INSERT INTO #__rem_rent_sal (fk_houseid, price_from, price_to,
         special_price, priceunit, comment_price) VALUES (" . $bid . ", '" .
          $rent_from_transf . "', '" . $rent_until_transf . "', '" .
           $special_price . "','" . $currency_spacial_price . "','" .
           $comment_price . "')";
      $database->setQuery($sql);
      $database->execute();

      $query = "SELECT * FROM #__rem_rent_sal where fk_houseid = " . $bid;
      $database->setQuery($query);
      $rentTerm = $database->loadObjectList();

      createRentTable($rentTerm, 'Add special price on data: from "'.
        $rent_from.'" to "'.$rent_until.'"','');
  }
}


if(!function_exists('calculatePriceREM')){
  function calculatePriceREM ($hid,$rent_from,$rent_until,$how_many_weeks,$how_many_monthes ){

    global $realestatemanager_configuration;

    $database = JFactory::getDBO();


      $zapros = "SELECT price, priceunit,rent_by FROM #__rem_houses WHERE id=" . $hid . ";";
//echo ":11111:".$zapros ; exit ;

      $database->setQuery($zapros);
      $item_rem = $database->loadObjectList();


      if( incorrect_price($item_rem[0]->price) || ($item_rem[0]->price) <= 0 ){
        $returnArr[0]=0;
        $returnArr[1]='';
        $returnArr[2]='';
        return $returnArr;
      }        


      $rent_from = date_transform_rem($rent_from,"to");

      if( intval($how_many_weeks) != 0 ) {
      
          $sum_price =  $how_many_weeks * $item_rem[0]->price;

          $returnArr[0]=$sum_price;
          $returnArr[1]=$item_rem[0]->priceunit;
          $returnArr[2]='';
      }
      else if( intval($how_many_monthes) != 0 ) {

          $sum_price =  $how_many_monthes * $item_rem[0]->price;

          $returnArr[0]=$sum_price;
          $returnArr[1]=$item_rem[0]->priceunit;
          $returnArr[2]='';
      }else if( $rent_until != "" ) {
        //order check very important, $rent_until != "" - may be not empty because we calculated it from how_many_monthes or how_many_weeks
        //rent by day or night
        $rent_until = date_transform_rem($rent_until,"to");

        if($rent_from >$rent_until){
            echo '0';exit;
        }
      
        if( $item_rem[0]->rent_by == "by_day" ){
          //rent by day
            $query = "SELECT * FROM #__rem_rent_sal WHERE fk_houseid = ".$hid .
                " AND (price_from <= ('" .$rent_until. "') AND price_to >= ('" .$rent_from. "'))";
        }else if( $item_rem[0]->rent_by == "by_night" ){
            $query = "SELECT * FROM #__rem_rent_sal WHERE fk_houseid = ".$hid .
                " AND (price_from < ('" .$rent_until. "') AND price_to > ('" .$rent_from. "'))";
        } else {
          //if version updated and we not have  $item_rem[0]->rent_by
          //so need set 
          $api_key = JFactory::getApplication()->enqueueMessage("Please set rent type for this Property!");
          return;
        }
        $database->setQuery($query);
        $data_for_price = $database->loadObjectList();

        $rent_from_ms = date_to_data_ms($rent_from);
        $rent_to_ms = date_to_data_ms($rent_until);

        if(  $item_rem[0]->rent_by == "by_day" ){
            $rent_to_ms = $rent_to_ms + (60*60*24);
        }

        $count_day = (($rent_to_ms - $rent_from_ms)/60/60/24);
        $count_day = round($count_day);
        $array_day_between_to_from[0]=$rent_from;

        for($i = 1; $i < $count_day; $i++){
            $array_day_between_to_from[]=date('Y-m-d',$rent_from_ms + (60*60*24)*($i));
        }

        $count_day_spashal_price = 0;
        $comment_rent_price = '';
        $count_spashal_price = 0;

        foreach ($data_for_price as $one_period){
            $from = $one_period->price_from;
            $to = $one_period->price_to;

            for ($day = 0; $day < $count_day; $day++){
                $currentday = ($array_day_between_to_from[$day]);

                if( $item_rem[0]->rent_by == "by_day"  ){
                    if (($currentday >= $from) && ($currentday <= $to)){
                        $count_day_spashal_price++;
                        $count_spashal_price += $one_period->special_price;
                        $comment_rent_price .= (string)$one_period->comment_price;
                    }
                }else if( $item_rem[0]->rent_by == "by_night"  ){
                    if (($currentday >= $from) && ($currentday < $to)){
                        $count_day_spashal_price++;
                        $count_spashal_price += $one_period->special_price;
                        $comment_rent_price .= (string)$one_period->comment_price;
                    }
                }
            }
        }

        $count_day_not_sp_price = $count_day - $count_day_spashal_price;
        $sum_price_not_sp_price =  $count_day_not_sp_price * $item_rem[0]->price;
        $sum_price = $sum_price_not_sp_price + $count_spashal_price;

        $returnArr[0]=$sum_price;
        $returnArr[1]=$item_rem[0]->priceunit;
        $returnArr[2]=$comment_rent_price;

      }


      return $returnArr;
  }
}



if(!function_exists('getCountHouseForSingleUserREM')){


  function getCountHouseForSingleUserREM($my,$database,$realestatemanager_configuration){


      $user_group = userGID_REM($my->id);
      $user_group_mas = explode(',', $user_group);
      $max_count_house = 0;

      foreach ($user_group_mas as $value) {
          $count_house_for_single_group =
           $realestatemanager_configuration['user_manager_rem'][$value]['count_homes'];

          if($count_house_for_single_group>$max_count_house){
              $max_count_house = $count_house_for_single_group;
          }
      }

      $count_house_for_single_group = $max_count_house;
      $database->setQuery("SELECT COUNT('houseid') as `count_homes` " .
       "FROM #__rem_houses WHERE owner_id= '" . $my->id. "'AND published='1'" );
      $house_single_user = $database->loadObject();
      $count_house_single_user = $house_single_user->count_homes;
      $returnarray = array();
      $returnarray[0] = $count_house_single_user;
      $returnarray[1] = $count_house_for_single_group;
      return $returnarray;
  }
}

if(!function_exists('getHTMLPayPalRM')){

function getHTMLPayPalRM($realestate,$plugin_name_select){
  global $database;
  if(!getPublicPlugin()){
      echo "<div class='alert_rem alert-error'>" . _REALESTATE_MANAGER_RENT_INSTALL_PAYPAL . "</div>";
  }else{
    $xml = @simplexml_load_file(JPATH_BASE . "/plugins/payment/paypal/paypal.xml");
    $plugin_version = $xml->version;
    if (version_compare($xml->version, "1.1.0", "lt")) {
        echo "<div class='alert alert-error'>You must update the PayPal plugin!</div>";
        return;
    }
    
    $plugin = JPluginHelper::importPlugin( 'payment',$plugin_name_select);
    $query = "SELECT profile_value FROM #__user_profiles "
            ."\n WHERE profile_key = 'profile.paypal_email' AND user_id = ".$realestate->owner_id;
    $database->setQuery($query);
    $paypal_email = $database->loadResult();
    $data = array('vtitle' => $realestate->htitle, 'price' => $realestate->price, 'currency_code' => $realestate->priceunit,'owner_paypal_email' => $paypal_email);
    $html = JFactory::getApplication()->triggerEvent('onGetHTMLPayPal', array($data));
    
    echo $html[0];
  }
 }
}

if(!function_exists('getHTML2CheckoutRM')){

function getHTML2CheckoutRM($realestate,$plugin_name_select){
  global $database;
  $option = $_REQUEST['option'];
  if(!getPublicPlugin()){
      echo "<div class='alert_rem alert-error'>" . _REALESTATE_MANAGER_RENT_INSTALL_PAYPAL . "</div>";
  }else{
    $option = $_REQUEST['option'];
    $plugin = JPluginHelper::importPlugin( 'payment', $plugin_name_select);
    $query = "SELECT profile_value FROM #__user_profiles "
            ."\n WHERE profile_key = 'profile.paypal_email' AND user_id = ".$realestate->owner_id;
    $database->setQuery($query);
    $paypal_email = $database->loadResult();

    $a = $realestate->price;
    $pricecut = sprintf ('%.2f', $a);

    $data = array('id' => $realestate->id, 'vtitle' => $realestate->htitle, 'price' => $pricecut, 'currency_code' => $realestate->priceunit,'owner_paypal_email' => $paypal_email, 'option' => $option);
    $html = JFactory::getApplication()->triggerEvent('onGetHTML2Checkout', array($data));

    echo $html[0];
    }
  }
}

if(!function_exists('getHTMLStripeRM')){
function getHTMLStripeRM($realestate,$plugin_name_select){
  global $database;
  $option = $_REQUEST['option'];
  if(!getPublicPlugin()){
      echo "<div class='alert_rem alert-error'>" . _REALESTATE_MANAGER_RENT_INSTALL_PAYPAL . "</div>";
  }else{
    $option = $_REQUEST['option'];
    $plugin = JPluginHelper::importPlugin( 'payment', $plugin_name_select);
    $query = "SELECT profile_value FROM #__user_profiles "
            ."\n WHERE profile_key = 'profile.paypal_email' AND user_id = ".$realestate->owner_id;
    $database->setQuery($query);
    $paypal_email = $database->loadResult();

    $a = $realestate->price;
    $pricecut = sprintf ('%.2f', $a);

    $data = array('id' => $realestate->id, 'vtitle' => $realestate->htitle, 'price' => $pricecut, 'currency_code' => $realestate->priceunit,'owner_paypal_email' => $paypal_email, 'option' => $option);
    $html = JFactory::getApplication()->triggerEvent('getHTMLStripe', array($data));

    echo $html[0];
    }
  }
}


if(!function_exists('getPublicPlugin')){

  function getPublicPlugin(){
           $db = JFactory::getDBO();
       $condtion = array(0 => '\'payment\'');
       $condtionatype = join(',',$condtion);
           if(JVERSION >= '1.6.0')
           {
               $query = "SELECT extension_id as id,name,element,enabled as published
                   FROM #__extensions
                   WHERE folder in ($condtionatype) AND enabled=1";
           }
           else
           {
               $query = "SELECT id,name,element,published
                   FROM #__plugins
                   WHERE folder in ($condtionatype) AND published=1";
           }
       $db->setQuery($query);
       $gatewayplugin = $db->loadobjectList();

       $retr = count($gatewayplugin);
           if($retr>0){
               $ret_string = "";
                   for($i=0;$i<$retr;$i++){
                           $ret_string .= "<option value='".$gatewayplugin[$i]->name."'>"
                             .$gatewayplugin[$i]->name."</option>";
                   }
           return $ret_string;
           }
           else{
               return false;
           }

}

}
if(!function_exists('saveAssociateCayegoriesREM')){

  function saveAssociateCayegoriesREM($post, $database){

      $currentId = $post['id'];
      if($currentId){
          $i = 1;
          $assocArray = array();
          $assocCategoryId = array();

          while(isset($post['associate_category'.$i])){
              $langAssoc = $post['associate_category_lang'.$i];
              $valAssoc = $post['associate_category'.$i];
              $assocArray[$langAssoc] = $valAssoc;
              if($valAssoc){
                  $assocCategoryId[] = $valAssoc;
              }

              $i++;
          }
          $currentId = $post['id'];
          $currentLang = $post['language'];
          $assocArray[$currentLang] = $currentId;
          $assocStr = serialize($assocArray);

          $query = "select `associate_category` from #__rem_main_categories where `id` = ".$currentId."";
          $database->setQuery($query);
          $oldAssociate = $database->loadResult();
          $oldAssociateArray = unserialize($oldAssociate);

          if($oldAssociateArray){
              foreach ($oldAssociateArray as $key => $value) {
                  if($value && !isset($assocCategoryId[$value])){
                      $assocCategoryId[] = $value;
                  }
              }
          }

          if(!isset($assocCategoryId[$currentId])){
              $assocCategoryId[] = $currentId;
          }

          $idToChange = implode(',' , $assocCategoryId);

          if(count($assocCategoryId) > 0 && !empty($idToChange)){
              $query = "UPDATE #__rem_main_categories SET `associate_category`='"
                .$assocStr."' where `id` in (".$idToChange.")";
              $database->setQuery($query);
              $database->execute();
          }
      }
  }
}

if(!function_exists('getAssociateHousesLang')){

  function getAssociateHousesLang($hoseIds){

      global $database;
      $query = "select associate_house from #__rem_houses where id = ".$hoseIds.
        " and associate_house is not null";
      $database->setQuery($query);
      $houseAssociateHouse = $database->loadResult();
      if (!empty($houseAssociateHouse)){
          $houseLangIds = unserialize($houseAssociateHouse);
          return $houseLangIds;
      }
  }
}

if(!function_exists('getAssociateHouses')){

  function getAssociateHouses($hoseId){

      global $database;

      $one = array();
      $bids = "";

      $query = "select associate_house from #__rem_houses where id = ".$hoseId.
        " and associate_house is not null";
      $database->setQuery($query);
      $houseAssociateHouse = $database->loadResult();


      if (!empty($houseAssociateHouse)){
        $hoseIds_tmp = unserialize($houseAssociateHouse);

        $is_correct_assosiate_array = false ;
        foreach($hoseIds_tmp as $oneHouse){
          if($oneHouse != 0){
              $one[] = $oneHouse;
              if($oneHouse == $hoseId) $is_correct_assosiate_array = true ;
          }
        }

        $bids = implode(',', $one);
        if( !$is_correct_assosiate_array ) $bids = ""; //return empty - if in assosiate array - not exist House with same id
      }
      return $bids;
  }
}

if(!function_exists('getAssociateDiff')){

  function getAssociateDiff($assocArray1,$assocArray2){

     global $database;

     $diff_ids = array();

      $diff = array_diff($assocArray1,$assocArray2);
      foreach($diff as $key => $value){
          if($value != 0){
                  $diff_ids[] = $value;
          }
      }

      return $diff_ids ;
  }
}

if(!function_exists('getAssociateOld')){
  function getAssociateOld(){
      global $database;

      $id_check = intval(protectInjectionWithoutQuote('id', ''));

        $query = "select `associate_house` from #__rem_houses where `id` = ".$id_check."";
        $database->setQuery($query);
        $oldAssociate = $database->loadResult();
        $oldAssoc_func = unserialize($oldAssociate);
      return $oldAssoc_func;
  }
}

if(!function_exists('ClearAssociateDiff')){

  function ClearAssociateDiff(){

    global $database;
    $old_ids_assoc=array();
    $new_ids_assoc=array();
    $id_check = intval(protectInjectionWithoutQuote('id', ''));
    $language_post = protectInjectionWithoutQuote('language', "");
     $oldAssociateArray = getAssociateOld();
     $i = 1;
     $assocArray = array();

     // while(count(protectInjectionWithoutQuote("associate_house".$i))){
     while( isset($_REQUEST["associate_house".$i]) ){
               $langAssoc = protectInjectionWithoutQuote("associate_house_lang".$i);
               $valAssoc = protectInjectionWithoutQuote("language_associate_house".$i);

               $assocArray[$langAssoc] = $valAssoc;
               $i++;
           }
     $assocArray[$language_post] = $id_check;
     if(!empty($oldAssociateArray) && !empty($assocArray))
    $old_ids_assoc = getAssociateDiff($oldAssociateArray,$assocArray);
            if(count($old_ids_assoc)>0)
            {
                foreach($old_ids_assoc as $key => $value) {
                  if(empty($value) ) continue ;
                  $diff_assoc2 = getAssociateHouses($value);
                  if(!empty($diff_assoc2)){
                    $ids_assoc_diff2 = explode(',', $diff_assoc2);
                    foreach ($ids_assoc_diff2 as $key2 => $value2){
                      if(!in_array($value2,$old_ids_assoc)){
                        $assoc_lang = getAssociateHousesLang($value);
                        foreach ($assoc_lang as $key3 => $value3){
                          if($value3 == $value2){
                            $assoc_lang[$key3] = 0;
                          }
                        }
                        $houseLangIds = serialize($assoc_lang);
                        $query = "UPDATE #__rem_houses SET `associate_house`='".$houseLangIds.
                          "' where `id` = ".$value."";
                        $database->setQuery($query);
                        $database->execute();
                      }
                    }
                  }
                }
            }
      if(!empty($oldAssociateArray) && !empty($assocArray))
      $new_ids_assoc = getAssociateDiff($assocArray,$oldAssociateArray);
      if(count($new_ids_assoc)>0)
      {
          foreach($new_ids_assoc as $key => $value) {
            if(empty($value) ) continue ;
            $diff_assoc2 = getAssociateHouses($value);
            if(!empty($diff_assoc2)){
            $ids_assoc_diff2 = explode(',', $diff_assoc2);
              foreach ($ids_assoc_diff2 as $key2 => $value2){
                if($value2 == $value || $value2 == 0 ) continue;
                $assoc_lang = getAssociateHousesLang($value2);
                foreach ($assoc_lang as $key3 => $value3){
                  if($value3 == $value){
                    $assoc_lang[$key3] = 0;
                  }
                }
                $houseLangIds = serialize($assoc_lang);
                $query = "UPDATE #__rem_houses SET `associate_house`='".$houseLangIds.
                  "' where `id` = ".$value2."";
                $database->setQuery($query);
                $database->execute();
              }
            }
          }
      }
  }
}

if(!function_exists('edit_house_associate')){

  function edit_house_associate($house,$call_from){
    global $my, $database;

    $associateArray = array();
    $userid = $my->id;

    $query = "SELECT lang_code FROM `#__languages` ";
    $database->setQuery($query);
    $allLanguages =  $database->loadColumn();
    //bch
    if($call_from=='backend')
    {
        $query = "SELECT id,language,htitle FROM `#__rem_houses`";
    }
    else
    {
        $query = "SELECT id,language,htitle FROM `#__rem_houses` WHERE owner_id = " . $userid . "";
    }



    $database->setQuery($query);
    $allhouse =  $database->loadObjectlist();

    $query = "select associate_house from #__rem_houses where id =".$house->id;
    $database->setQuery($query);
    $houseAssociateHouse =  $database->loadResult();

    if(!empty($houseAssociateHouse)){
        $houseAssociateHouse = unserialize($houseAssociateHouse);
    }else{
        $houseAssociateHouse = array();
    }

    $i=0;
    foreach ($allLanguages as $oneLang) {
      $i++;
      $associate_house = array();
      $associate_house[] = mosHtml::makeOption(0, 'select');

      foreach($allhouse as $oneHouse){
          if($oneLang == $oneHouse->language && $oneHouse->id != $house->id){
              $associate_house[] = mosHtml::makeOption(($oneHouse->id), $oneHouse->htitle);
          }
      }

      if($house->language != $oneLang){

        if(isset($houseAssociateHouse[$oneLang]) &&
          $houseAssociateHouse[$oneLang] !== $house->id ){
            $associateArray[$oneLang]['assocId'] = $houseAssociateHouse[$oneLang];
        }else{
            $associateArray[$oneLang]['assocId'] = 0;
        }

        $associate_house_list = mosHTML :: selectList($associate_house,
          'language_associate_house'.$i,
          'class="inputbox" size="1"', 'value', 'text',
          $associateArray[$oneLang]['assocId']);

      }else{
          $associate_house_list = null;
      }

      $associateArray[$oneLang]['list'] = $associate_house_list;

      if(isset($houseAssociateHouse[$oneLang]) &&
        $houseAssociateHouse[$oneLang] !== $house->id ){
          $associateArray[$oneLang]['assocId'] = $houseAssociateHouse[$oneLang];
      }else{
          $associateArray[$oneLang]['assocId'] = 0;
      }
    }
    return $associateArray;
  }
}


if(!function_exists('save_house_associate')){
  function save_house_associate(){
  global  $database;

      $id_check = protectInjectionWithoutQuote('id', "");
      $id_true = protectInjectionWithoutQuote('idtrue', "");
      $language_post = protectInjectionWithoutQuote('language', "");

      if($id_check){
        if(empty($id_true)){
      //----------get new values (what house we choose for chaque language) --------------------------//
        $i = 1;
        $assocArray = array();
        $assocHouseId = array();

        // if ( protectInjectionWithoutQuote("associate_house".$i) ){
          // while(count(protectInjectionWithoutQuote("associate_house".$i))){
          while( isset($_REQUEST["associate_house".$i]) ){
            $langAssoc = protectInjectionWithoutQuote("associate_house_lang".$i, '');
            $valAssoc = protectInjectionWithoutQuote("language_associate_house".$i,'');

            if($valAssoc == '' ) {
              $i++;
              continue;
            }
            $assocArray[$langAssoc] = $valAssoc;
            if($valAssoc){
              $assocHouseId[] = $valAssoc;  //----Array of new house_ids
            }
            $i++;
          }
        // }
        if(count($assocArray) > 0 ) {
          $assocArray[$language_post] = $id_check;
          $assocStr = serialize($assocArray);
      //-----------slect associate with old values------------------------------------------//
          $oldAssociateArray = getAssociateOld();
        //----------------------------------------------------------------//
          if(!isset($assocHouseId[$id_check])){
            $assocHouseId[] = $id_check;
          }
          if($assocArray && $oldAssociateArray){
            ksort($assocArray);
            ksort($oldAssociateArray);
          }
          if($assocArray !== $oldAssociateArray){   //-----------compare old and new values--

        //---------set null for houses that are not more in associates----------------//
            ClearAssociateDiff();

        //---------set new associates for houses that are choosed----------------//
        //--ids of new houses  where we set new values for column associate_house
            $idToChange = implode(',' , $assocHouseId);
            if(count($assocHouseId) > 0 && !empty($idToChange)){
              $query = "select * from #__rem_rent where `fk_houseid` in (".$idToChange.
                ") and `rent_return` is NULL";
              $database->setQuery($query);
              $CheckAssociate = $database->loadObjectList();
              if(!empty($CheckAssociate))
              {
                echo "<script> alert('"._REALESTATE_MANAGER_MUST_RETURN_HOUSES_FROM_RENT
                  ."'); window.history.go(-1); </script>";
                exit;
              }
              $query = "UPDATE #__rem_houses SET `associate_house`='".$assocStr.
                "' where `id` in (".$idToChange.")";
              $database->setQuery($query);
              $database->execute();
            }else{
              $query = "UPDATE #__rem_houses SET `associate_house`= null where `id` = ".$id_check."";
              $database->setQuery($query);
              $database->execute();
            }
          }
        }
      }
    }
  }
}

//return not avaliable dates
if(!function_exists('available_dates')){
  function available_dates($house_id){
    global $database,$realestatemanager_configuration;
    $date_NA = array();
    $query = "SELECT rent_from, rent_until FROM #__rem_rent WHERE fk_houseid='".$house_id.
      "' AND rent_return is null";
    $database->setQuery($query);
    $curRentDates = $database->loadObjectList();

    $house = new mosRealEstateManager($database);
    $house->load( $house_id ); 

    // create a massiv of all dates when houses are in rent and then is used for
    // make dates unavailable in calendar for rent
    foreach($curRentDates as $curRentDate){
      $not_av_from = $curRentDate->rent_from;
      $not_av_until = $curRentDate->rent_until;
      $not_av_from_begin = new DateTime( $not_av_from);
      $not_av_until_end = new DateTime( $not_av_until);
      if( $house->rent_by == "by_day" ){
       $not_av_until_end = $not_av_until_end->modify( '+1 day' );
      }
      // else{
      //   $not_av_from_begin = $not_av_from_begin->modify( '+1 day' );
      // }
      $interval = new DateInterval('P1D');
      $daterange = new DatePeriod($not_av_from_begin, $interval, $not_av_until_end);
      foreach($daterange as $datess){
          $date_NA[] = $datess->format("Y-m-d");
          $date_NA[] = $datess->format("d-m-Y");
      }
    }
  return $date_NA;
  }
}
////////////////////////////STORE video/track functions START\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
if (!function_exists('REMstoreTrack')) {
  function REMstoreTrack(&$house) {
    global $realestatemanager_configuration, $mosConfig_absolute_path;
    $app = JFactory::getApplication();
    $jinput = $app->input;
    for ($i = 1;isset($_FILES['new_upload_track' . $i])
      || array_key_exists('new_upload_track_url' . $i, $_POST);$i++) {
        $track_name = '';
        if (isset($_FILES['new_upload_track' . $i]) && $_FILES['new_upload_track' . $i]['name'] != "") {
          //storing e-Document

          // $track = protectInjectionWithoutQuote('new_upload_track' . $i, '', 'files');
          $track = $jinput->files->get('new_upload_track' . $i);

          $ext = pathinfo($track['name'], PATHINFO_EXTENSION);
          $allowed_exts = explode(",", $realestatemanager_configuration['allowed_exts_track']);
          $ext = strtolower($ext);
          if (!in_array($ext, $allowed_exts)) {
            echo "<script> alert(' File ext. not allowed to upload! - " . $ext .
                                 "'); window.history.go(-1); </script>\n";
            exit();
          }
          $code = guid();

          // $track_name = $code . '_' . filter($track['name']);
          $track_name = $code . '_' . rem_remove_forbidden_characters_whitespaces_from_file_name( $track['name'] );

          if (intval($track['error']) > 0 && intval($track['error']) < 4) {
            echo "<script> alert('" . _REALESTATE_MANAGER_LABEL_TRACK_UPLOAD_ERROR . " - " .
                                 $track_name . "'); window.history.go(-1); </script>\n";
            exit();
          } else if (intval($track['error']) != 4) {
            $track_new = $mosConfig_absolute_path . $realestatemanager_configuration['tracks']['location'] . $track_name;
            if (!move_uploaded_file($track['tmp_name'], $track_new)) {
              echo "<script> alert('" . _REALESTATE_MANAGER_LABEL_TRACK_UPLOAD_ERROR . " - " .
                                   $track_name . "'); window.history.go(-1); </script>\n";
              exit();
            }
          }
        }
        if (array_key_exists('new_upload_track_kind' . $i, $_POST)
          && $_POST['new_upload_track_kind' . $i] != "") {
            $uploadTrackKind = protectInjectionWithoutQuote('new_upload_track_kind' . $i, '');

            $uploadTrackKind = strip_tags(trim($uploadTrackKind));
        }
        if (array_key_exists('new_upload_track_scrlang' . $i, $_POST)
          && $_POST['new_upload_track_scrlang' . $i] != "") {

            $uploadTrackScrlang = protectInjectionWithoutQuote('new_upload_track_scrlang' . $i, '');

            $uploadTrackScrlang = strip_tags(trim($uploadTrackScrlang));
        }
        if (array_key_exists('new_upload_track_label' . $i, $_POST)
          && $_POST['new_upload_track_label' . $i] != "") {

            $uploadTrackLabel = protectInjectionWithoutQuote('new_upload_track_label' . $i, '');

            $uploadTrackLabel = strip_tags(trim($uploadTrackLabel));
        }
        if (array_key_exists('new_upload_track_url' . $i, $_POST) && $_POST['new_upload_track_url' . $i] != "") {

          $uploadTrackURL = protectInjectionWithoutQuote('new_upload_track_url' . $i, '');

          $uploadTrackURL = strip_tags(trim($uploadTrackURL));
          if (empty($track_name) && !empty($uploadTrackURL))
            REMsaveTracks($house->id, $uploadTrackURL, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel);
        }
        if (!empty($track_name))
          REMsaveTracks($house->id, $track_name, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel);
    }
  }
}

if (!function_exists('checkMimeType')) {
  function checkMimeType($ext) {
    global $database;
    $database->setQuery("SELECT mime_type FROM #__rem_mime_types WHERE mime_ext=".$database->quote($ext));
    $type = $database->loadResult();
    if(!$type)
      $type = 'unknown';
    return $type;
  }
}

if (!function_exists('filter')) {
  function filter($value) {
    $value = str_replace(array("/", "|", "\\", "?", ":", ";", "*", "#", "%", "$", "+", "=", ";", " "), "_", $value);
    return $value;
  }
}

if (!function_exists('guid')) {
  function guid() {
    if (function_exists('com_create_guid')) {
      return com_create_guid();
    } else {
      mt_srand((int)microtime() * 10000); //optional for php 4.2.0 and up.
      $charid = strtoupper(md5(uniqid(rand(), true)));
      $hyphen = chr(45); // "-"
      $uuid = //chr(123)// "{"
      substr($charid, 0, 8) . $hyphen . substr($charid, 8, 4) . $hyphen . substr($charid, 12, 4) . $hyphen . substr($charid, 16, 4) . $hyphen . substr($charid, 20, 12);
      //.chr(125);// "}"
      return $uuid;
    }
  }
}

jimport( 'joomla.filesystem.file' );
if(!function_exists('rem_createImage')){
    function rem_createImage($imgSrc, $imgDest, $width, $height, $crop = true) {
       if (JFile::exists($imgDest)) {
            $info = getimagesize($imgDest, $imageinfo);
            if (($info[0] == $width) && ($info[1] == $height)) {
                return;
            }
        }
        if (JFile::exists($imgSrc)) {

            $info = getimagesize($imgSrc, $imageinfo);
            $sWidth = $info[0];
            $sHeight = $info[1];
            rem_resize_img($imgSrc, $imgDest, $width, $height, $crop);
        }
    }
}
if(!function_exists('rem_resize_img')){
    function rem_resize_img($imgSrc, $imgDest, $tmp_width, $tmp_height, $crop = true) {
       global $mosConfig_absolute_path;

        //some time return error
        $info = getimagesize($imgSrc, $imageinfo);
        $sWidth = $info[0];
        $sHeight = $info[1];
        $ext = str_replace('image/', '', $info['mime']);

        //if (($info[0] >= $tmp_width) && ($info[1] >= $tmp_height)) {
        if (($info[0] >= $tmp_width) || ($info[1] >= $tmp_height)) {
        if($sWidth == 0 || $tmp_width == 0 ) {
          $logPath  = $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/my_log.log";
          file_put_contents($logPath, "  rem_resize_img zero ".$imgSrc."::".$sWidth ."::" . $tmp_width."\n",  FILE_APPEND );

          $imgSrc = $mosConfig_absolute_path."/components/com_realestatemanager/photos/"."no-img_eng_big.gif";
          $info = getimagesize($imgSrc, $imageinfo);
          $sWidth = $info[0];
          $sHeight = $info[1];
          $ext = str_replace('image/', '', $info['mime']);
        }

        if ($sHeight / $sWidth > $tmp_height / $tmp_width) {
            $width = $sWidth;
            $height = round(($tmp_height * $sWidth) / $tmp_width);
            $sx = 0;
            $sy = round(($sHeight - $height) / 3);
        }
        else {
            $height = $sHeight;
            $width = round(($sHeight * $tmp_width) / $tmp_height);
            $sx = round(($sWidth - $width) / 2);
            $sy = 0;
        }

        if (!$crop) {
            $sx = 0;
            $sy = 0;
            $width = $sWidth;
            $height = $sHeight;
        }
        }else {
            $sx = 0;
            $sy = 0;
            $width = $sWidth;
            $height = $sHeight;
    }

        $ext = str_replace('image/', '', $info['mime']);
        $imageCreateFunc = rem_getImageCreateFunction($ext);
        $imageSaveFunc = rem_getImageSaveFunction($ext);

        $sImage = $imageCreateFunc($imgSrc);
        if (($info[0] >= $tmp_width) && ($info[1] >= $tmp_height)) {
        $dImage = imagecreatetruecolor($tmp_width, $tmp_height);
        }
        else {$dImage = imagecreatetruecolor($width, $height);
        $tmp_width = $width;
        $tmp_height = $height;
        }
        // Make transparent
        if ($ext == 'png') {
            imagealphablending($dImage, false);
            imagesavealpha($dImage,true);
            $transparent = imagecolorallocatealpha($dImage, 255, 255, 255, 127);
            imagefilledrectangle($dImage, 0, 0, $tmp_width, $tmp_height, $transparent);
        }

        imagecopyresampled($dImage, $sImage, 0, 0, $sx, $sy, $tmp_width, $tmp_height, $width, $height);


        if ($ext == 'png') {
          //for png quality must be 0 - 9
          //0 - max quality no copress, 9 - low quality max compress
          $quality = 6;
          $imageSaveFunc($dImage, $imgDest, $quality);
        }
        else if ($ext == 'bmp') {
          $compressed = true;
          $imageSaveFunc($dImage, $imgDest, $compressed);
        }
        else if ($ext == 'gif') {
          $imageSaveFunc($dImage, $imgDest);
        }
        else if ($ext == 'vnd.wap.wbmp' || $ext == 'xbm') {
          $foreground = '';
          if(isset($foreground) && !empty($foreground)){
            $imageSaveFunc($dImage, $imgDest, $foreground);
          }
          else{
            $imageSaveFunc($dImage, $imgDest);
          }
        }
        else {
          //for jpg or jpeg
          //for png quality must be 0 - 100
          //0 - low quality max compress, 100 - max quality no copress
          $quality = 75;
          $imageSaveFunc($dImage, $imgDest, $quality);
        }
    }
}
if(!function_exists('rem_getImageCreateFunction')){
    function rem_getImageCreateFunction($type) {
        switch ($type) {
            case 'jpeg':
            case 'jpg':
                $imageCreateFunc = 'imagecreatefromjpeg';
                break;

            case 'png':
                $imageCreateFunc = 'imagecreatefrompng';
                break;

            case 'bmp':
                $imageCreateFunc = 'imagecreatefrombmp';
                break;

            case 'gif':
                $imageCreateFunc = 'imagecreatefromgif';
                break;

            case 'vnd.wap.wbmp':
                $imageCreateFunc = 'imagecreatefromwbmp';
                break;

            case 'xbm':
                $imageCreateFunc = 'imagecreatefromxbm';
                break;

            default:
                $imageCreateFunc = 'imagecreatefromjpeg';
        }

        return $imageCreateFunc;
    }
}
if(!function_exists('rem_getImageSaveFunction')){
    function rem_getImageSaveFunction($type) {
        switch ($type) {
            case 'jpeg':
                $imageSaveFunc = 'imagejpeg';
                break;

            case 'png':
                $imageSaveFunc = 'imagepng';
                break;

            case 'bmp':
                $imageSaveFunc = 'imagebmp';
                break;

            case 'gif':
                $imageSaveFunc = 'imagegif';
                break;

            case 'vnd.wap.wbmp':
                $imageSaveFunc = 'imagewbmp';
                break;

            case 'xbm':
                $imageSaveFunc = 'imagexbm';
                break;

            default:
                $imageSaveFunc = 'imagejpeg';
        }

        return $imageSaveFunc;
    }
}

/**
 * Saves the record on an edit form submit
 * @param database A database connector object
 */
if (!function_exists('rem_picture_thumbnail')) {
  function rem_picture_thumbnail($file, $width_original, $high_original, $watermark = false) {
      global $mosConfig_absolute_path, $realestatemanager_configuration;
      //min size in order to adding watermark

      if(!file_exists($mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark')){
        mkdir($mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark','755');
      }

      $min_image_width = $realestatemanager_configuration['watermark']['min_width'];
      $min_image_high = $realestatemanager_configuration['watermark']['min_height'];

      $watermark_path = ($watermark) ? 'watermark/' : '';

      $params3 = $realestatemanager_configuration['thumb_param']['show'];// RealEstateManager - Settings - Administrator Settings - Crop image: YES - $params3 = 1 (crop), NO - $params3 = 0 (resize, scale image).
      $uploaddir = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
      $watermarkfile = $file;

      //file name and extention
      if($file === '' || !file_exists($mosConfig_absolute_path .
           '/components/com_realestatemanager/photos/' . $file)){
        copy ( $mosConfig_absolute_path . '/components/com_realestatemanager/images/no-img_eng_big.gif' ,
            $mosConfig_absolute_path . '/components/com_realestatemanager/photos/no-img_eng_big.gif' );
        $file = 'no-img_eng_big.gif';

      }elseif($watermark && (($realestatemanager_configuration['watermark']['type'] == 'text' && $realestatemanager_configuration['watermark']['text'] != '')
                    || ($realestatemanager_configuration['watermark']['type'] == 'image' && file_exists($mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark/watermark_img.png')))){

        if(!file_exists($mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark/' . $file)){

          rem_createWaterMark($file, $realestatemanager_configuration['watermark']);
        }
        if($high_original < $min_image_high || $width_original < $min_image_width){
          $watermark = false;
            // $file  = str_ireplace('watermark/', '', $file);
        }else{
            $file = $watermark_path.$file;
        }
      }

      $file_inf = pathinfo($file);
      $file_type = '.' . $file_inf['extension'];
      $file_name = basename($file, $file_type);
      $watermarkfile_name = $file_name;
      $file_name = $watermark_path . $file_name;
      $index = '';

      if($params3 == 1){// RealEstateManager - Settings - Administrator Settings - Crop image: YES - $params3 = 1 (crop), NO - $params3 = 0 (resize, scale image).
        $index = "_2_";
      }else{
        $index = "_1_";
      }

      // Setting the resize parameters
      list($width, $height) = getimagesize($mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file);

      $size = "_" . $width_original . "_" . $high_original;

      if (file_exists($mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file_name . $size . $index . $file_type)) {
          return $file_name . $size . $index . $file_type;
      } else {
          if ($width < $height) {
              if ($height > $high_original) {
                  $k = $height / $high_original;
              } else if ($width > $width_original) {
                  $k = $width / $width_original;
              }
              else
                  $k = 1;
          } else {
              if ($width > $width_original) {
                  $k = $width / $width_original;
              } else if ($height > $high_original) {
                  $k = $height / $high_original;
              }
              else
                  $k = 1;
          }
          $w_ = intval($width / $k);
          $h_ = intval($height / $k);
      }

       if($params3 == 1){// RealEstateManager - Settings - Administrator Settings - Crop image: YES - $params3 = 1 (crop), NO - $params3 = 0 (resize, scale image).
         if ($watermark == false){
            $CreateNewImage = rem_createImage($uploaddir.$file, $uploaddir.$file_name . $size . $index . $file_type, $width_original, $high_original);
            return $file_name . $size . $index . $file_type;
        } elseif(($realestatemanager_configuration['watermark']['type'] == 'text' && $realestatemanager_configuration['watermark']['text'] != '')
                    || ($realestatemanager_configuration['watermark']['type'] == 'image' && file_exists($mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark/watermark_img.png'))) {
            if (file_exists($uploaddir . $watermarkfile_name . $size. $index .$file_type))
            {

                $fileforwatermark = $watermarkfile_name . $size. $index .$file_type;

                rem_createWaterMark($fileforwatermark, $realestatemanager_configuration['watermark']);
                unlink($uploaddir.$fileforwatermark);
                return $file_name . $size . $index . $file_type;
            } else {
                $fileforwatermark = $watermarkfile_name . $size. $index .$file_type;

                $CreateNewImage = rem_createImage($uploaddir.$watermarkfile, $uploaddir . $watermarkfile_name . $size. $index
                .$file_type, $width_original, $high_original);
                rem_createWaterMark($fileforwatermark, $realestatemanager_configuration['watermark']);
                unlink($uploaddir.$fileforwatermark);
                return $file_name . $size . $index . $file_type;
            }


        }else{
            $CreateNewImage = rem_createImage($uploaddir.$file, $uploaddir.$file_name . $size . $index . $file_type, $width_original, $high_original);
            return $file_name . $size . $index . $file_type;
        }
    }
      // Creating the Canvas
      $tn = imagecreatetruecolor($w_, $h_);
      $index = "_1_";
      switch (strtolower($file_type)) {
        case '.png':
          $source = imagecreatefrompng($mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file);
          if( $source === false ){
              //is not a valid image file 
              $source = imagecreatefromgif($mosConfig_absolute_path . '/components/com_realestatemanager/images/no-img_eng_big.gif');
              $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
              imagegif($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/'. $file_name . $size . $index . $file_type);
              return ;
          }          
          $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
          imagepng($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file_name . $size . $index . $file_type);
          break;
        case '.jpg':
          $source = imagecreatefromjpeg($mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file);
          if( $source === false ){
              //is not a valid image file 
              $source = imagecreatefromgif($mosConfig_absolute_path . '/components/com_realestatemanager/images/no-img_eng_big.gif');
              $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
              imagegif($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/'. $file_name . $size . $index . $file_type);
              return ;
          }
          $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
          imagejpeg($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file_name . $size . $index . $file_type);
          break;
        case '.jpeg':
          $source = imagecreatefromjpeg($mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file);
          if( $source === false ){
              //is not a valid image file 
              $source = imagecreatefromgif($mosConfig_absolute_path . '/components/com_realestatemanager/images/no-img_eng_big.gif');
              $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
              imagegif($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/'. $file_name . $size . $index . $file_type);
              return ;
          }
          $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
          imagejpeg($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file_name . $size . $index . $file_type);
          break;
        case '.gif':
          $source = imagecreatefromgif($mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file);
          if( $source === false ){
              //is not a valid image file 
              $source = imagecreatefromgif($mosConfig_absolute_path . '/components/com_realestatemanager/images/no-img_eng_big.gif');
              $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
              imagegif($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/'. $file_name . $size . $index . $file_type);
              return ;
          }
          $file = imagecopyresampled($tn, $source, 0, 0, 0, 0, $w_, $h_, $width, $height);
          imagegif($tn, $mosConfig_absolute_path . '/components/com_realestatemanager/photos/' . $file_name . $size . $index . $file_type);
          break;
        default:
          echo 'not support';
          return;
      }

      return $file_name . $size . $index . $file_type;
  }
}

if (!function_exists('REMstoreVideo')) {
  function REMstoreVideo(&$house) {
    global $realestatemanager_configuration, $mosConfig_absolute_path;
    $app = JFactory::getApplication();
    $jinput = $app->input;
    for ($i = 1;isset($_FILES['new_upload_video' . $i])
      || array_key_exists('new_upload_video_url' . $i, $_POST)
      || array_key_exists('new_upload_video_youtube_code' . $i, $_POST);$i++) {
        $video_name = '';
        if (isset($_FILES['new_upload_video' . $i]) && $_FILES['new_upload_video' . $i]['name'] != "") {
          //storing e-Document

          $video = $jinput->files->get('new_upload_video' . $i);

          $ext = pathinfo($video['name'], PATHINFO_EXTENSION);
          $allowed_exts = explode(",", $realestatemanager_configuration['allowed_exts_video']);
          $ext = strtolower($ext);

          if (!in_array($ext, $allowed_exts)) {
            echo "<script> alert(' File ext. not allowed to upload! - " . $ext.
                                     "'); window.history.go(-1); </script>\n";
            exit();
          }

          $type = checkMimeType($ext);

          if (stripos($type, $video['type'])===false) {
            echo "<script> alert(' File ext. not allowed to upload! - " . $ext.
                                     "'); window.history.go(-1); </script>\n";
            exit();
          }
          $code = guid();

          // $video_name = $code . '_' . filter($video['name']);
          $video_name = $code . '_' . rem_remove_forbidden_characters_whitespaces_from_file_name( $video['name'] );

          if (intval($video['error']) > 0 && intval($video['error']) < 4) {
            echo "<script> alert('" . _REALESTATE_MANAGER_LABEL_VIDEO_UPLOAD_ERROR . " - " .
                                   $video_name . "'); window.history.go(-1); </script>\n";
            exit();
          } else if (intval($video['error']) != 4) {
            $video_new = $mosConfig_absolute_path . $realestatemanager_configuration['videos']['location']  . $video_name;
            if (!move_uploaded_file($video['tmp_name'], $video_new)) {
              echo "<script> alert('" . _REALESTATE_MANAGER_LABEL_VIDEO_UPLOAD_ERROR . " - " .
                                   $video_name . "'); window.history.go(-1); </script>\n";
              exit();
            }
            REMsaveVideos($video_name, $house->id, $type);
          }
        }
        if (array_key_exists('new_upload_video_url' . $i, $_POST) && $_POST['new_upload_video_url' . $i] != "") {

          $uploadVideoURL = protectInjectionWithoutQuote('new_upload_video_url' . $i, '');

          $uploadVideoURL = strip_tags(trim($uploadVideoURL));
          $end = explode(".", $uploadVideoURL);
          $ext = end($end);
          $type = checkMimeType($ext);
          if(empty($video_name) && !empty($uploadVideoURL))
            REMsaveVideos($uploadVideoURL, $house->id, $type);
        }
        if (array_key_exists('new_upload_video_youtube_code' . $i, $_POST)
          && $_POST['new_upload_video_youtube_code' . $i] != "") {

            $uploadVideoYoutubeCode = protectInjectionWithoutQuote('new_upload_video_youtube_code' . $i, '');

            $uploadVideoYoutubeCode = strip_tags(trim($uploadVideoYoutubeCode));
            REMsaveYouTubeCode($uploadVideoYoutubeCode, $house->id);
        }
      }
  }
}

if (!function_exists('REMsaveTracks')) {
    function REMsaveTracks($h_id, $src, $uploadTrackKind, $uploadTrackScrlang, $uploadTrackLabel) {
        global $database,$realestatemanager_configuration, $mosConfig_absolute_path;
        if ($src != "" && !strstr($src, "http")) {
          $query = "INSERT INTO #__rem_track_source (fk_house_id,src,kind,scrlang,label)".
                    "\n VALUE ($h_id,
                              '" . $realestatemanager_configuration['tracks']['location'].$src . "',
                              '" . $uploadTrackKind . "',
                              '" . $uploadTrackScrlang . "',
                              '" . $uploadTrackLabel . "')";
        }else{
          $query ="INSERT INTO #__rem_track_source (fk_house_id,src,kind,scrlang,label)".
                  "\n VALUE ($h_id,
                            '" . $src."',
                            '" . $uploadTrackKind . "',
                            '" . $uploadTrackScrlang . "',
                            '" . $uploadTrackLabel . "')";
        }
        $database->setQuery($query);
        $database->execute();
    }
}

if (!function_exists('REMsaveVideos')) {
  function REMsaveVideos($src, $h_id, $type) {
    global $database,$realestatemanager_configuration, $mosConfig_absolute_path;
    if ($src != "" && strstr($src, "http")) {
      $query = "INSERT INTO #__rem_video_source(fk_house_id, src, type)".
                                                  "\n VALUE($h_id,'" . $src . "', '" . $type . "')";
    }else{
      $query = "INSERT INTO #__rem_video_source(fk_house_id,src,type)".
                "\n VALUE($h_id,
                        '".$realestatemanager_configuration['videos']['location'].$src."',
                        '".$type."')";
    }
    $database->setQuery($query);
    $database->execute();
  }
}

if (!function_exists('REMsaveYouTubeCode')) {
  function REMsaveYouTubeCode($youtube_code, $h_id) {
    global $database;
      $database->setQuery("SELECT id FROM #__rem_video_source
                            WHERE youtube != ''
                            AND fk_house_id = $h_id");
      $database->execute();
      $youtubeId = $database->LoadResult();
    if ($youtube_code != '' && !empty($youtubeId)) {
      $query = "UPDATE #__rem_video_source".
                "\n SET youtube = '" . $youtube_code . "'".
                "\n WHERE id = $youtubeId";
    } else {
      $query = "INSERT INTO #__rem_video_source (fk_house_id,youtube)".
                "\n VALUE($h_id,'" . $youtube_code . "')";
    }
    $database->setQuery($query);
    $database->execute();
  }
}


////////////////////////////STORE video/track functions END\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

///////////////////////////DELETE video/track functions START\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
if (!function_exists('REMdeleteTracks')) {
  function REMdeleteTracks($h_id) {
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $realestatemanager_configuration;
    $database->setQuery("SELECT id FROM #__rem_track_source where fk_house_id = $h_id;");
    $tdiles_id = $database->loadColumn();
    $deleteTr_id = array();
    foreach($tdiles_id as $key => $value) {
      if (isset($_POST['track_option_del' . $value])) {

        array_push($deleteTr_id, protectInjectionWithoutQuote('track_option_del' . $value, ''));

      }
    }
    if ($deleteTr_id) {
      $del_tid = implode(',', $deleteTr_id);
      $sql = "SELECT src FROM #__rem_track_source WHERE id IN (" .$del_tid . ")";
      $database->setQuery($sql);
      $tracks = $database->loadColumn();
      if ($tracks) {
        foreach($tracks as $name) {
          if (substr($name, 0, 4) != "http") unlink($mosConfig_absolute_path . $name);
        }
      }
      $sql = "DELETE FROM #__rem_track_source WHERE (id IN (" . $del_tid . "))
              AND (fk_house_id = $h_id)";
      $database->setQuery($sql);
      $database->execute();
    }
  }
}

if (!function_exists('REMdeleteVideos')) {
  function REMdeleteVideos($h_id) {
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $realestatemanager_configuration;
    $database->setQuery("SELECT id FROM #__rem_video_source where fk_house_id = $h_id;");
    $vdiles_id = $database->loadColumn();
    $deleteVid_id = array();
    foreach($vdiles_id as $key => $value) {
      if (isset($_POST['video_option_del' . $value])) {

      array_push($deleteVid_id, protectInjectionWithoutQuote('video_option_del' . $value, ''));

      }
    }
    $database->setQuery("SELECT id FROM #__rem_video_source where fk_house_id = $h_id AND youtube IS NOT NULL;");
    $youtubeid = $database->loadResult();
    if (!empty($youtubeid)) {
      if (isset($_POST['youtube_option_del' . $youtubeid])) {
        $y_t_id = mosGetParam($_REQUEST, 'youtube_option_del' . $youtubeid, '');
        $sql = "DELETE FROM #__rem_video_source
                WHERE id = $y_t_id
                AND fk_house_id=$h_id";
        $database->setQuery($sql);
        $database->execute();
      }
    }
    if ($deleteVid_id) {
      $del_id = implode(',', $deleteVid_id);
      $sql = "SELECT src FROM #__rem_video_source WHERE id IN (". $del_id . ")";
      $database->setQuery($sql);
      $videos = $database->loadColumn();
      if ($videos) {
        foreach($videos as $name) {
          if (substr($name, 0, 4) != "http" && file_exists($mosConfig_absolute_path . $name))
            unlink($mosConfig_absolute_path . $name);
        }
      }
      $sql = "DELETE FROM #__rem_video_source
              WHERE (id IN (" . $del_id . "))
              AND (fk_house_id=$h_id)";
      $database->setQuery($sql);
      $database->execute();
    }
  }
}
///////////////////////////DELETE video/track fucntions END\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
if(!function_exists('return_bytes')){
    function return_bytes($val)
    {
        if (empty($val))
        {
            return 0;
        }

        $val = trim($val);

        preg_match('#([0-9]+)[\s]*([a-z]+)#i', $val, $matches);

        $last = '';

        if (isset($matches[2]))
        {
            $last = $matches[2];
        }

        if (isset($matches[1]))
        {
            $val = (int) $matches[1];
        }

        switch (strtolower($last))
        {
            case 'g':
            case 'gb':
                $val *= 1024;
            case 'm':
            case 'mb':
                $val *= 1024;
            case 'k':
            case 'kb':
                $val *= 1024;
        }

        return (int) $val;
    }

}

if(!function_exists('getAvilableRM')){
  function getAvilableRM ($calenDate,$month,$year,$realestatemanager_configuration,$day,$houseid){
    global $flag3,$realestatemanager_configuration, $database;

    if(strlen($month) == 1){
        $month = '0'.$month ;
      }
      if(strlen($day) == 1){
        $day = '0'.$day ;
      }
      $toDay = $day+1;
      if(strlen($toDay) == 1){
        $toDay = '0'.$toDay ;
      }
    $cheackDataFrom = $year.'-'.$month.'-'.$day;
    $cheackDataTo = $year.'-'.$month.'-'.$toDay;
    foreach ($calenDate as $oneTerm){
      $from=explode(' ',$oneTerm->rent_from);
      $until=explode(' ',$oneTerm->rent_until);
      if($cheackDataFrom >= $oneTerm->rent_until)continue;


      $house = new mosRealEstateManager($database);
      $house->load( $houseid );    

      $resultmsg = checkRentDayNightREM (($oneTerm->rent_from),($oneTerm->rent_until), $cheackDataFrom, $cheackDataTo, $house->rent_by);
      if($cheackDataTo <= date('Y-m-d') && strlen($resultmsg) > 1){
        if( $house->rent_by == "by_night"
            && ($cheackDataFrom == $until[0] || $cheackDataFrom == $from[0] )){
          if($flag3){
            $flag3 = false;
            return 'calendar_day_gone_not_avaible_night_end';
          }else{
            $flag3 = true;
            return 'calendar_day_gone_not_avaible_night_start';
          }
        }
        return 'calendar_day_gone_not_avaible';
      }
      if(strlen($resultmsg) > 1){
        if(  $house->rent_by == "by_night"
          && ($cheackDataFrom == $until[0] || $cheackDataFrom == $from[0] )){
          if($flag3){
            $flag3 = false;
            return 'calendar_not_available_night_end';
          }else{
            $flag3 = true;
            return 'calendar_not_available_night_start';
          }
        }
        return 'calendar_not_available';
      }
      if($cheackDataTo <= date('Y-m-d')){
        return 'calendar_day_gone_avaible';
      }
    }
    if(isset($cheackDataTo) && $cheackDataTo <= date('Y-m-d')){
      return 'calendar_day_gone_avaible';
    }
    return 'calendar_available';
  }
}

if(!function_exists('com_house_categoryTreeList')){
    function com_house_categoryTreeList($id, $action, $is_new, &$options = array(), $catid='', $lang='') {
        global $database;
        if($lang){
            $list = com_house_categoryArray($lang);
        } else {
            $list = com_house_categoryArray();
        }
        $cat = new mainRealEstateCategories($database);
        $cat->load($id);

        $this_treename = '';
        $childs_ids = Array();
        foreach ($list as $item) {
            if ($item->id == $cat->id || array_key_exists($item->parent_id, $childs_ids))
                $childs_ids[$item->id] = $item->id;
        }
        foreach ($list as $item) {
            if ($this_treename) {
                if ($item->id != $cat->id
                        && strpos($item->treename, $this_treename) === false
                        && array_key_exists($item->id, $childs_ids) === false) {
                    $options[] = mosHTML::makeOption($item->id, $item->treename);
                }
            } else {
                if ($item->id != $cat->id) {
                    $options[] = mosHTML::makeOption($item->id, $item->treename);
                } else {
                    $this_treename = "$item->treename/";
                }
            }
        }

        $parent = null;
        $parent = mosHTML::selectList($options, 'catid', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $catid);
        return $parent;
    }
}

if(!function_exists('com_house_categoryArray')){
    function com_house_categoryArray($lang='') {
        global $database, $my, $acl;
        $s = getWhereUsergroupsCondition('c');
        $s_cat = getWhereDatePublishStringRem('c');
        // get a list of the menu items
          $query = "SELECT c.*, c.parent_id AS parent, c.params AS access "
                . "\n FROM #__rem_main_categories c "
                . "\n WHERE ($s) AND ($s_cat) AND section='com_realestatemanager' "
                . "\n AND published <> 0  ";
        if($lang){
            $query .=  " AND ($lang)"
                  . "\n ORDER BY ordering";
        } else {
            $query .= " ORDER BY ordering";
        }
        $database->setQuery($query);
        $items = $database->loadObjectList();
        foreach ($items as $r => $cat_item) {
            if (!checkAccess_REM($cat_item->access, 'NORECURSE', userGID_REM($my->id), $acl)) {
            //if have not access then remove item from search
                unset($items[$r]);
            }
        }
        $items = array_values($items);
        // establish the hierarchy of the menu
        $children = array();
        // first pass - collect children
        foreach ($items as $v) {
            $pt = $v->parent;
            $list = @$children[$pt] ? $children[$pt] : array();
            array_push($list, $v);
            $children[$pt] = $list;
        }
        // second pass - get an indent list of the items
        $array = mosTreeRecurseREM(0, '', array(), $children);

        return $array;
    }
}

if (!function_exists('checkJavaScriptIncludedRE')) {
  function checkJavaScriptIncludedRE($name) {

      $doc = JFactory::getDocument();

      foreach($doc->_scripts as $script_path=>$value){
        if(strpos( $script_path, $name ) !== false ) return true ;
      }
      return false;
  }
}

if (!function_exists('checkStylesIncludedRE')) {
  function checkStylesIncludedRE($name) {

      $doc = JFactory::getDocument();

      foreach($doc->_styleSheets as $script_path=>$value){
        if(strpos( $script_path, $name ) !== false ) return true ;
      }
      return false;
  }
}

if (!function_exists('rem_add_new_features_constant')) {
  function rem_add_new_features_constant() {
    global $database, $mosConfig_absolute_path;

    //add new features constant for all which exists before
    $query = "SELECT f.* ";
    $query .= "FROM #__rem_feature as f ";
    $database->setQuery($query);
    $house_features = $database->loadObjectList();
    $i = 0 ;
    foreach ($house_features as $house_feature) {
      //check so consts already added ?
      $query = "select * from #__rem_const where const ='".'_REALESTATE_MANAGER_FEATURE'.$house_feature->id."'";
      $database->setQuery($query);
      $defined_consts = $database->loadobjectList();
      if(count($defined_consts) > 0 ) {
       $house_features[$i]->fk_constid = $defined_consts[0]->id ; 
       $i++;
       continue ; 
      }

      //add new features constant
      $query = "insert IGNORE into #__rem_const ( `const`,`sys_type`)
        values('_REALESTATE_MANAGER_FEATURE".$house_feature->id."','Features')";
      $database->setQuery($query);
      $database->execute();

      $house_features[$i]->fk_constid = $database->insertid();
      $i++;
    }

    foreach ($house_features as $house_feature) {
      
      $query = "select * from #__rem_languages";
      $database->setQuery($query);
      $defined_languages = $database->loadobjectList();
      foreach ($defined_languages as $defined_language) {
          $query = "insert IGNORE into #__rem_const_languages ( `fk_constid`,`fk_languagesid`,`value_const`) values(".$house_feature->fk_constid .",".$defined_language->id .",".$database->Quote($house_feature->name).")";
          $database->setQuery($query);
          $database->execute();
      }
    }
  }
}

if (!function_exists('rem_add_new_features_category_constant')) {
  function rem_add_new_features_category_constant() {
    global $realestatemanager_configuration, $database;

    $categories_constants = array() ;
    $categ = explode(',', $realestatemanager_configuration['featuredmanager']['placeholder']);
    for ($i = 0; $i < count($categ); $i++){
        $categories_constants[] = '_REALESTATE_MANAGER_FEATURE_CATEGORY_'.trim( $categ[$i] );
    }

      if(count($categories_constants) > 0 ){
        //get old features category constants
        $query = "select * from #__rem_const where `sys_type` = 'Features Category'";
        $database->setQuery($query);
        $defined_constants = $database->loadobjectList();
        $categories_old_constants = array() ;

        $query = "select * from #__rem_languages";
        $database->setQuery($query);
        $defined_languages = $database->loadobjectList();

        foreach ($defined_constants as $defined_constant) {

            //find features in this category
            $query = "select * from #__rem_feature where ".
                " `categories` = '".substr($defined_constant->const ,strlen("_REALESTATE_MANAGER_FEATURE_CATEGORY_") ) ."'";
            $database->setQuery($query);
            $defined_features_category = $database->loadobjectList();

            //if this category not exist and if not exist features with this category
            if( in_array($defined_constant->const,$categories_constants) == FALSE &&
                count($defined_features_category) == 0 ){
                //delete features laguages constant
                $query = "select * from #__rem_const where `const` = '".$defined_constant->const."'";
                $database->setQuery($query);
                $rem_consts = $database->loadobjectList();
                foreach ($rem_consts as $rem_const) {
                    $query = "DELETE FROM #__rem_const_languages where `fk_constid` = ".$rem_const->id ;
                    $database->setQuery($query);
                    $database->execute();
                }

                //delete features constant 
                $query = "DELETE FROM #__rem_const where `const` = '".$defined_constant->const."'";
                $database->setQuery($query);
                $database->execute();
            }


            //check exist constant only in #__rem_const or also in #__rem_const_languages
            $query = "select * from #__rem_const where `const` = '".$defined_constant->const."'";
            $database->setQuery($query);
            $rem_consts = $database->loadobjectList();   

            if( count($rem_consts)  == 0  ){
              $categories_old_constants[] = $defined_constant->const ;
              continue ;

            }

            $query = "select * from #__rem_const_languages where `fk_constid` = '".$rem_consts[0]->id."'";
            $database->setQuery($query);
            $rem_consts_lang = $database->loadobjectList() ;

            //if some category constant exist in some languages but not exist an other
            //remove all and unsert again
            if(count($rem_consts_lang) < count($defined_languages) ){

                $query = "DELETE FROM #__rem_const_languages where `fk_constid` = ".$rem_consts[0]->id ;
                $database->setQuery($query);
                $database->execute();

                $query = "DELETE FROM #__rem_const where `id` = ".$rem_consts[0]->id ;
                $database->setQuery($query);
                $database->execute();     

                //do continue special for not add this constant to $categories_old_constants and add this constant again to DB 
                continue;

            }

            $categories_old_constants[] = $defined_constant->const ;


        }

        foreach ($categories_constants as $categories_constant) {
            if( in_array($categories_constant,$categories_old_constants) == FALSE) {
                $query = "insert IGNORE into #__rem_const ( `const`,`sys_type`)
                  values('".$categories_constant."','Features Category')";
                $database->setQuery($query);
                $database->execute();

                $const_id = $database->insertid();


                foreach ($defined_languages as $defined_language) {
                    $query = "insert IGNORE into #__rem_const_languages ( `fk_constid`,`fk_languagesid`,`value_const`) values(".$const_id.",".$defined_language->id .",". $database->Quote(substr($categories_constant,strlen("_REALESTATE_MANAGER_FEATURE_CATEGORY_") ) ).")";
                    $database->setQuery($query);
                    $database->execute();
                }
            }
        }
      }
  }
}


// function remove forbidden characters and replace whitespaces by hyphens:
if (!function_exists('rem_remove_forbidden_characters_whitespaces_from_file_name')) {
    function rem_remove_forbidden_characters_whitespaces_from_file_name($file_path_name) {
        // split a file name on main parts:
        $file_name_parts = pathinfo( $file_path_name );
        // take the part what we need (file extension and file name):
        $file_name_ext = $file_name_parts['extension'];
        $file_name = $file_name_parts['filename'];
        // file name check with Joomla-function stringURLUnicodeSLug (it is this function remove forbidden characters and replace whitespaces by hyphens):
        $file_name_clear = JFilterOutput::stringURLUnicodeSLug( $file_name );
        // compile file name and file extension in one string by concatenation:
        $file_name_clear_ext = $file_name_clear . "." . $file_name_ext;
        return $file_name_clear_ext;
    }
}

// function check is enabled Joomla Google Captcha-reCaptcha plugin and in administrator global sittings :
if (!function_exists('rem_check_enabled_google_captcha_recaptcha')) {
    function rem_check_enabled_google_captcha_recaptcha() {

        global $realestatemanager_configuration;

        //Check enabled plugin captcha-recaptcha
        $recaptchaPluginEnabled = JPluginHelper::isEnabled('captcha', 'recaptcha');

        //Check enable option captcha-recaptcha in admin form
        if (version_compare(JVERSION, "4.0.0", "ge")) {
            $app = JFactory::getApplication();
            $config = $app->getConfig();
        } else {
            $config = JFactory::getConfig(); 
        }        
        $recaptchaAdminEnabled = false;
        if($config->get('captcha') == 'recaptcha'){
            $recaptchaAdminEnabled = true;
        }

        //Check enable google recaptcha in REM settings
        $googleRecaptchaEnabled = false;
        if($recaptchaPluginEnabled && $recaptchaAdminEnabled && $realestatemanager_configuration['google_captcha_by_default_show']){
            $googleRecaptchaEnabled = true;
        }

        return $googleRecaptchaEnabled;
    }
}

// Add rotate exif img
if(!function_exists('rem_rotateImage')){
    function rem_rotateImage($imagePath){

        $pathinfo = pathinfo($imagePath);
        if(!file_exists($imagePath)) return;
        if( !function_exists("exif_read_data")) return;

        if(strtolower($pathinfo['extension']) == 'jpeg'
           || strtolower($pathinfo['extension']) == 'jpg'){

          
            $exif = @exif_read_data($imagePath);

            if (!empty($exif['Orientation'])) {
                $imageResource = imagecreatefromjpeg($imagePath); // provided that the image is jpeg. Use relevant function otherwise
                switch ($exif['Orientation']) {
                    case 3:
                    $image = imagerotate($imageResource, 180, 0);
                    break;
                    case 6:
                    $image = imagerotate($imageResource, -90, 0);
                    break;
                    case 8:
                    $image = imagerotate($imageResource, 90, 0);
                    break;
                    default:
                    $image = $imageResource;
                }

                imagejpeg($image, $imagePath);
                imagedestroy($image);
            }

            return;
        }

    }
}
// Check that Google Map API Key exist, if not - show message on the page.
// Add script to Google Map works.
/*if(!function_exists('rem_GoogleMap_KeyCheck_AddScript')){
    function rem_GoogleMap_KeyCheck_AddScript(){
        global $realestatemanager_configuration;
        $doc = JFactory::getDocument();
        if ( $realestatemanager_configuration['location_map'] == '1' && $realestatemanager_configuration['google_openmap']['show'] == '1' ) {
            if ( isset($realestatemanager_configuration['api_key']) && $realestatemanager_configuration['api_key'] ) {
                $api_key = "key=" . $realestatemanager_configuration['api_key'];
            } else {
              $api_key = JFactory::getApplication()->enqueueMessage("<a target='_blank' href='//developers.google.com/maps/documentation/geocoding/get-api-key'>" . _REALESTATE_MANAGER_GOOGLEMAP_API_KEY_LINK_MESSAGE . "</a>", _REALESTATE_MANAGER_GOOGLEMAP_API_KEY_ERROR);
            }
                $doc->addScript("//maps.googleapis.com/maps/api/js?$api_key&libraries=places");
        }
    }
}*/

if(!function_exists('rem_checkFile')){
  function rem_checkFile() {
      $path = $_GET["path"];
      $filename = basename($_GET["file"]);
      $file = $path . $filename;
      if (file_exists($file)) {
          echo "The file with such name already is!";
      } else {
          echo "";
      }
  }
}

if (!function_exists('rem_pdf_print_logo')) {
    function rem_pdf_print_logo() {
        global $mosConfig_absolute_path, $realestatemanager_configuration;

        // Getting params from template
        $app  = JFactory::getApplication();
        $template_params = $app->getTemplate(true)->params;
        $sitename = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');

        $pdf_logo_file = '';
        
        $pdf_logo_file = ( file_exists($mosConfig_absolute_path . '/components/com_realestatemanager/photos/pdf_print_logo/pdf_print_logo.png') ) ? 'components/com_realestatemanager/photos/pdf_print_logo/pdf_print_logo.png' : '' ;

        // Logo file or site title/name param
        if ( $pdf_logo_file != '' && $realestatemanager_configuration['pdf_print_logo']['show'] ) 
        {
            $logo = '<span align="center"><img src="' . htmlspecialchars(JUri::root() . $pdf_logo_file, ENT_QUOTES) . '" alt="' . $sitename . '" /></span>';
        }
        elseif ($template_params->get('sitetitle'))
        {
            $logo = '<span class="site-title" align="center" title="' . $sitename . '">' . htmlspecialchars($template_params->get('sitetitle'), ENT_COMPAT, 'UTF-8') . '</span>';
        }
        else
        {
            $logo = '<span class="site-title" align="center" title="' . $sitename . '">' . $sitename . '</span>';
        }

        return $logo;
    }
}
if(!function_exists('addInfoAboutUpdate')){
    function addInfoAboutUpdate() {
        
        global $mosConfig_absolute_path;
        // function for check equivalence versions
        function checkVersion($newversion, $oldversion) {
                if (strpos($newversion, " ") !== false ) 
                    $newversion = explode('.', substr($newversion, 0, strpos($newversion, ' ')));
                else  $newversion = explode('.', $newversion);

                $oldversion = explode('.', substr($oldversion, 0, strpos($oldversion, ' ')));
                return $oldversion === max($newversion, $oldversion);
        }
        // add info about update
        $url="https://ordasoft.com/xml_update/realestatemanager_update.xml";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT ,0); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);

        $data = curl_exec($ch);
        curl_close($ch);
 
        if (!$data || stristr($data, 'Not Found')) return; // exit from function if not xml
        $xml = simplexml_load_string($data);
        $ordasoftNewV = (string)$xml->version;
        $ordasoftCreationDate = (string)$xml->creationDate;
        unset($xml);

        $xml = simplexml_load_file($mosConfig_absolute_path . "/administrator/components/com_realestatemanager/realestatemanager.xml");
        $ordasoftCurV = (string)$xml->version;
        $creationDate = (string)$xml->creationDate;
        unset($xml);

        //-------------------------------------------------
        if (!empty($ordasoftNewV) && !checkVersion($ordasoftNewV, $ordasoftCurV)) {
            $message = "Available new version RealEstateManager $ordasoftNewV" . 
            ", creation date $ordasoftCreationDate";
            JFactory::getApplication()->enqueueMessage($message);
        }
    }
}  


if (!function_exists('checkREMVersionProFree')) {
    function checkREMVersionProFree(){

        $activationNeed = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_realestatemanager/realestatemanager.xml");
        if($xml){
            $version = (string)$xml->tag;
            unset($xml);

            return $version;
        }
        return "free" ;
    }
}

if (!function_exists('checkREMVersionNumber')) {
    function checkREMVersionNumber(){

        $activationNeed = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_realestatemanager/realestatemanager.xml");
        if($xml){

            $version = (string)$xml->version;
            unset($xml);

            return $version;
        }
        return "" ;
    }
}

if (!function_exists('checkREMVersionDate')) {
    function checkREMVersionDate(){

        $activationNeed = false;
        $xml = @simplexml_load_file(JPATH_BASE . "/components/com_realestatemanager/realestatemanager.xml");
        if($xml){
            $date = (string)$xml->creationDate;
            unset($xml);

            return $date;
        }
        return "" ;
    }
}    


