<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/


class AdminViewRequest{

  static function showRequests($option, & $rows_item, & $clist,
                                & $publist, & $search, & $pageNav, & $sort_arr, $show_fields,$entity_list)
  {


      global $doc, $user, $app, $session, $db, $entityFieldLists;
      $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_ADMIN_LABLE_SUBMISSIONS') . "</div>";
      $app = JFactory::getApplication();
      $app->JComponentTitle = $html;
      $onclick = "Joomla.checkAll(this);";
      ?>
      <form action="index.php?option=com_os_cck&task=show_requests" method="post" name="adminForm" id="adminForm">
        <div class="adminlist filters wrapper_filters">
            <div>
              <div class="search_block">
              <input type="text" placeholder="<?php echo JText::_('COM_OS_CCK_SHOW_SEARCH'); ?>" name="search" value="<?php echo $search; ?>" class="inputbox"
                   onChange="document.adminForm.submit();"/>
              <button type="submit" class="cck_search_button" title="" data-original-title="Search"><span class="icon-search"></span></button>
              </div>
            </div>
            <div>
              <?php echo $publist; ?>
            </div>
            <div>
              <?php echo $clist; ?>
            </div>
            <div>
              <?php echo $entity_list; ?>
            </div>
            <?php if (version_compare(JVERSION, "3.0.0", "ge")) { ?>
              
            <?php } ?>
        </div>
        <div class="wrapper_filters_right">
          <div class="btn-group pull-right hidden-phone">
            <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
            <?php echo $pageNav->getLimitBox(); ?>
          </div>
        </div>
        <div class="admin-request-title">
        
            <div class="admin-order-title-checkbox">
                <input type="checkbox" name="toggle" value="" onClick="<?php echo $onclick; ?>" />
            </div>
            
            <div class="admin-order-title-id">
                <?php echo HTML_os_cck::sort_head(JText::_('COM_OS_CCK_LABEL_INSTANCE_ID'), 'inst_id', $sort_arr,protectInjectionWithoutQuote('task'));?>
                
            </div>
            <?php
            foreach($show_fields as $value){
              foreach($value as $field){
                ?>

                <div class="admin-order-title-email">
                    <?php echo HTML_os_cck::sort_head($field->field_name, $field->db_field_name, $sort_arr,protectInjectionWithoutQuote('task'));?>
                </div>
                <?php
                
              }
            }
            ?>
            <div class="admin-order-title-email">
              <?php echo HTML_os_cck::sort_head(JText::_('COM_OS_CCK_REQUEST_DATE'), 'created', $sort_arr,protectInjectionWithoutQuote('task'));?>
            </div>
            <div class="admin-order-title-date">
              <?php echo HTML_os_cck::sort_head(JText::_('COM_OS_CCK_REQUEST_ENTITY'), 'entity', $sort_arr,protectInjectionWithoutQuote('task'));?>
                
            </div>
            
      </div>
      <?php 
      // var_dump($rows_item);
      for($i = 0; $i < count($rows_item); $i++) { 
          $row = $rows_item[$i];
          // $order_instancies = $order_entity_array[$rows_item[$i]->id];
          ?>
         
      <div class="admin-one-order <?php echo $rows_item[$i]->notreaded?'admin-order-not-readed':''?>">
          <div class="admin-order-standart-fields admin-request-standart-fields">
              <div class="admin-order-standart-fields-checkbox">
                <?php if ($row->checked_out && $row->checked_out != $user->id) { ?>
                  &nbsp;
                <?php
                } else {
                  echo JHTML::_('grid.id',$i, $rows_item[$i]->eiid, ($rows_item[$i]->checked_out && $rows_item[$i]->checked_out != $user->id), 'eiid');
                }
                ?>
                  
              </div>
              <div class="admin-order-standart-fields-id">
                  <a href="#show_request_item"
                     onClick="return Joomla.listItemTask('cb<?php echo $i; ?>','show_request_item')">
                      <?php echo $row->eiid; ?></a>
              </div>
              <?php 
                foreach($show_fields as $key => $value){
                  foreach($value as $field){
                    $html = '';
                    if($rows_item[$i]->fk_eid != $key){
                      echo'<div class="admin-order-standart-fields-email"></div>';
                      continue;
                    }
                    if($field->field_type == 'categoryfield'){
                      echo "<div class='admin-order-standart-fields-email'>$rows_item[$i]->category</div>";
                      continue;
                    }
                    ?>
                    <div class="admin-order-standart-fields-email">
                      <?php
                      $entityInstance = new os_cckEntityInstance($db);
                      $entityInstance->load($rows_item[$i]->eiid);
                      $value = $entityInstance->getFieldValue($field);
                      ?>
                      <div>
                          <span class="col_box" style="display:block;
                          <?php echo ($field->field_type=='imagefield'
                                      && isset($field->options['width'])
                                      && isset($field->options['height']))? 'width:'.$field->options['width'].'px; height:'.$field->options['height'].'px;':'';?>">
                              <?php
                                  ob_start();
                                    require getSiteShowFiledViewPath('com_os_cck', $field->field_type);
                                    $html .= ob_get_contents();
                                  ob_end_clean();
                                  echo $html;
                              ?>
                          </span>
                      </div>
                  </div>
                    <?php
                  }
                }
              ?>
              <div class="admin-order-standart-fields-email">
                  <?php echo $rows_item[$i]->created;?>
              </div>
              <div class="admin-order-standart-fields-date">
                  <?php echo $rows_item[$i]->entity;?>
              </div>
              
              
          </div>
          <div class="admin-order-products">
              <?php
              $parentInstance = new os_cckEntityInstance($db);
              $parentInstance->load($rows_item[$i]->fid_parent);
              
              // foreach ($parentInstance as $cart_item => $inst){
                  echo '<div class="admin-order-single-product">';
                  // $orderInstance = new os_cckEntityInstance($db);
                  // $orderInstance->load($inst);
                  $show_in_orders_fields = array();
                  
                  if(isset($entityFieldLists[$parentInstance->fk_eid])){
                    $fields = $entityFieldLists[$parentInstance->fk_eid];
                  }else{
                    $fields = array();
                  }
                  foreach($fields as $field){
                      $params = new JRegistry;
                      $params->loadString($field->params);
                      if($params->get('show_in_requests', '') == 'yes'){
                          $show_in_orders_fields[] = $field;
                      }
                  }
                  // var_dump($show_in_orders_fields);
                  ?>
                  <div>
                      <div>Title</div>
                      <div><?php echo $parentInstance->title; ?></div>
                  </div>
                  
                  <?php
//                        var_dump($show_in_orders_fields);
                  foreach ($show_in_orders_fields as $field){
                    // var_dump($field);
                      $value = $parentInstance->getFieldValue($field);
                      if(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == ''){
                          continue;
                      }elseif($field->field_type == 'datetime_popup' && isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data') && $value[0]->data == '0000-00-00 00:00:00'){
                          continue;
                      }
                      $print_value = '';
                      if($field->field_type == 'text_select_list'){
                          $value = (isset($value[0]->data))?$value[0]->data : '';
                          $value = json_decode($value);
                          $params = new JRegistry;
                          $params->loadString($field->params);
                          $allowed_values = $params->get("allowed_value");
                          $allowed_values = explode('\sprt', $allowed_values);
                          $tmp_val = array();

                          if(is_array($value)){

                              foreach($value as $val){

                                  if(isset($allowed_values[$val])){
                                      $tmp_val[] = JText::_($allowed_values[$val]);
                                  }
                              }
                          }

                          $print_value = implode(', ', $tmp_val);
                          
//                                $temp_val = json_decode($value[0]->data);
//                                if(is_array($temp_val)){
//                                    $temp_val = implode(', ', $temp_val);
//                                    $print_value = $temp_val;
//                                }
//                                var_dump(json_decode($value[0]->data));
                      }elseif(stripos($field->field_type, 'pricefield') !== false){
                          
                          continue;
                      }elseif(isset($value[0]) && is_object($value[0]) && property_exists($value[0], 'data')){
                          $print_value = $value[0]->data;
                      }
                      echo '<div><div>'.$field->field_name.'</div><div>'.$print_value.'</div></div>';
//                            var_dump($value);
                  }
                  
                  
                  echo '</div>';
//                        var_dump($fields);
              
              ?>
          </div>
          
      </div>
      <?php } ?>
      <div><?php echo $pageNav->getListFooter(); ?></div>
        
        <input type="hidden" name="option" value="<?php echo $option; ?>"/>
        <input type="hidden" name="task" value="show_requests"/>
        <input type="hidden" name="boxchecked" value="0"/>
      </form>

  <?php
  }

  static function showRequestItem($option, & $entityInstance, & $str_list, $recurse){


    global $os_cck_configuration,$user, $app, $session, $doc;
    $html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Config' />" . JText::_('COM_OS_CCK_ADMIN_LABLE_SUBMISSIONS') . "</div>";
    $app->JComponentTitle = $html;
    $doc->addStyleSheet(JURI::root()."components/com_os_cck/assets/css/jquerOs-ui.min.css");
    $doc->addStyleSheet(JURI::root()."components/com_os_cck/assets/css/admin_style.css");
    
    $doc->addScript(JURI::root()."components/com_os_cck/assets/js/jquerOs-ui.min.js");
    
    $doc->addScript(JUri::root().'components/com_os_cck/assets/js/jquery.raty.js');
    $doc->addStyleSheet( JUri::root().'/components/com_os_cck/assets/lightbox/css/lightbox.css');
    $doc->addScriptDeclaration('jQuerOs=jQuerOs.noConflict();');
    $doc->addScript(JUri::root().'/components/com_os_cck/assets/lightbox/js/lightbox-2.6.min.js');
    $doc->addScript('//maps.googleapis.com/maps/api/js');

    if($recurse == 1){
      $div_id = 'instance';
    }else{
      $div_id = 'psubmission';
    }  ?>
    <div id="<?php echo $div_id; ?>">
      <?php
      
      $layout_params = $str_list['layout_params'];
      $layout = $str_list['layout'];
      $bootstrap_version = $session->get( 'bootstrap','2');
//      var_dump($layout);
//      echo '11111111111'; exit;
      $layout->layout_html = $layout->getLayoutHtml($bootstrap_version);
      
      $layout_html = urldecode($layout->layout_html);
      $field_from_params = $layout_params["fields"];
      $fields_list = $str_list['extra_fields_list'];

      //add child selects to layout
      $addChildSelectToLayout = addChildSelectToLayout($fields_list, $entityInstance, $layout_params, $layout_html, $layout);
      $layout_html = $addChildSelectToLayout['layout_html'];
      $layout_params = $addChildSelectToLayout['layout_params'];
      $parent = $addChildSelectToLayout['select_parent'];
      $layout->params = serialize($layout_params);
      //add child selects to layout
      $hover_animated = array();
      $moduleId = 0;
      $Itemid = 0;
      $layout_params['custom_fields'] = unserialize($layout->custom_fields);
      $child_entities = (isset($layout_params['child_entities'])) ? $layout_params['child_entities'] : '';
      $layout_html = $layout->getLayoutViews($entityInstance, $fields_list, $layout_html, $layout_params, $hover_animated, $option, $child_entities, $moduleId, $Itemid, 10);

      $layout_html = str_replace(array("{|f-cck_send_button|}","Button Send"), '', $layout_html);
      echo $layout_html;
      
      ?>
    </div>
    <?php
    
    //echo '1111111111'; exit;
    if(!empty($str_list['parent_instance']) && is_array($str_list['parent_instance'])){
        foreach($str_list['parent_instance'] as $parent_instance){
            AdminRequest::showRequestItem($option, $parent_instance->fid_parent, 1);
        }
    }
  }

}
