<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

//JHTML::_('behavior.modal', 'a.modal-button');
$doc = JFactory::getDocument();
$doc->addScript(JURI::root().'/components/com_os_cck/assets/js/functions.js');
$doc->addStyleSheet(JURI::root().'/components/com_os_cck/assets/css/admin_style.css');
 
class JFormFieldPaypalStatus extends JFormField{
  protected function getInput(){
    $db = JFactory::getDBO();
    $query = "SELECT name,enabled FROM #__extensions WHERE folder='payment' AND (element='paypal' OR element='paypal2')";
    $db->setQuery($query);
    $status = $db->loadObjectList();
    $status_str = '';
    if(!isset($status[0])){
      $status_str = '<b style="color:red;">'.JText::_("COM_OS_CCK_PARAMS_PAYPAL_NOT_INSTALL").'</b>';
    }
    if(is_array($status)){
        foreach($status as $st){
            if($st->enabled == 0){
              $status_str .= '<b style="color:red;">' . JText::_("COM_OS_CCK_PARAMS_PAYPAL_PLUGIN") . $st->name . JText::_("COM_OS_CCK_PARAMS_PAYPAL_PLUGIN_NOT_ENABLE"). '</b>, ';
            }else{
              $status_str .= '<b style="color:green;">'.JText::_("COM_OS_CCK_PARAMS_PAYPAL_PLUGIN_ENABLE").' [ '.$st->name.' ]</b>, ';
            }
        }
    }
    $status_str = trim($status_str, ', ');
    return $status_str;
  }
}