<?php
/**
 *
 * @package  RealEstateManager
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

$session = JFactory::getSession();
$arr = $session->get("array", "default");
global $hide_js, $Itemid, $mosConfig_live_site, $mosConfig_absolute_path,
   $database, $doc, $my, $catid;
global $limit, $total, $limitstart, $task, $paginations, $mainframe,
  $realestatemanager_configuration, $option;

if(!empty($params['page_heading']) && $params['show_page_heading'] != 0){
    $rem_header = $params['page_heading'];
} else {
    $rem_header = $params->get('header');
}
$watermark_path = ($realestatemanager_configuration['watermark']['show'] == 1) ? 'watermark/' : '';
$watermark = ($realestatemanager_configuration['watermark']['show'] == 1) ? true : false;

function words_limit($input_text, $limit = 50, $end_str = '') {
    $input_text = strip_tags($input_text);
    $words = explode(' ', $input_text);
    if ($limit < 1 || sizeof($words) <= $limit) {
        return $input_text;
    }
    $words = array_slice($words, 0, $limit);
    $out = implode(' ', $words);
    return $out . $end_str;

}
/* The Mootools have conflict with GoogleMap. GoogleMap StreetView don`t work when Mootools turn on.
It looks like we use the Mootools only for the function "window.addEvent(domready, function() {". Replace this function on Mootools on the same function on jQoery "jQuerOs(document).ready(function() {".
Turn off The Mootools in our components. */
// if (version_compare(JVERSION, "3.0.0", "lt")) JHTML::_('behavior.mootools');
// else JHtml::_('behavior.framework', true);
//gooale map, street view, panorama conflict with mootools
//Uncomment the following lines if street view does not work.
//foreach($doc->_scripts as $temp_script => $val){
//    if(stripos($temp_script, 'mootools') !== FALSE){
//        unset($doc->_scripts[$temp_script]);
//    }
//}
?>

<?php
// Check that Google Mao API Key exist, if not - show message on the page.
// Add script to Google Map works.
// rem_GoogleMap_KeyCheck_AddScript();
?>

<script type="text/javascript">
    function rem_rent_request_submitbutton() {
        var form = document.userForm;
        if (form.user_name.value == "") {
            alert( "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_NAME; ?>" );
        } else if (form.user_email.value == "" || !isValidEmail(form.user_email.value)) {
            alert( "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_EMAIL; ?>" );
        } else if (form.user_mailing == "") {
            alert( "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_MAILING; ?>" );
        } else if (form.rent_until.value == "") {
            alert( "<?php echo _REALESTATE_MANAGER_INFOTEXT_JS_RENT_REQ_UNTIL; ?>" );
        } else {
            form.submit();
        }
    }

    function isValidEmail(str) {
        return (str.indexOf("@") > 1);
    }

    function allreordering(){
        if(document.orderForm.order_direction.value=='asc')
            document.orderForm.order_direction.value='desc';
        else document.orderForm.order_direction.value='asc';

        document.orderForm.submit();
    }

</script>
<?php positions_rem($params->get('singlecategory01')); ?>
<div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
    <?php
if (!$params->get('wrongitemid')) {
    echo $rem_header;
}
?>

</div>



<?php positions_rem($params->get('singleuser02')); ?>
<?php positions_rem($params->get('singlecategory02')); ?>
<?php positions_rem($params->get('singlecategory03')); ?>

<?php
$map_uniq_id = "587493";
if (($task != 'rent_request') && ($realestatemanager_configuration['location_map'] == 1)) {
    ?>

    <div id="map_canvas<?php echo $map_uniq_id; ?>" class="re_map_canvas re_map_canvas_04"></div>

    <?php
    if ( $realestatemanager_configuration['google_openmap']['show'] == 0 ){
        //for open map add div for Popup
        ?>
        <div id="os_ol_popup<?php echo $map_uniq_id; ?>" class="os_ol_popup">
            <a href="#" id="os_ol_popup-closer<?php echo $map_uniq_id; ?>" class="os_ol_popup-closer"></a>
            <div id="os_ol_popup-content<?php echo $map_uniq_id; ?>"></div>
        </div>

        <?php
        // HTML_realestatemanager::add_open_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', 'map', 'open_map');

    } else {
        // HTML_realestatemanager::add_google_map($rows,$map_uniq_id);
        require getLayoutPath::getLayoutPathCom('com_realestatemanager', 'map', 'google_map');
    }
    ?>

<?php } ?>

<?php
if (count($rows) > 0) {
    $sort_arr['order_field'] = $params->get('sort_arr_order_field');
    $sort_arr['order_direction'] = $params->get('sort_arr_order_direction');
?>
    <?php positions_rem($params->get('singleuser03')); ?>
    <?php positions_rem($params->get('singlecategory04')); ?>
    <?php positions_rem($params->get('singleuser04')); ?>
    <?php positions_rem($params->get('singlecategory05')); ?>

<div class="REL-row">
<div>
    <div id="list" class="wishlist">
    <?php
    $available = false;
    $k = 0;
    $total = count($rows);
    $g_item_count = 0;
    foreach($rows as $row) {
        $tmphouse = new mosRealEstateManager($database);
        $tmphouse->load($row->id);
        $tmphouse->setCatIds();
        $link = 'index.php?option=com_realestatemanager&task=view&id=' .
         $row->id . '&catid=' . $tmphouse->catid[0] . '&Itemid=' . $Itemid ;
        $g_item_count++;
?>

            <!-- <div class="list_house " id="rem<?php // echo $row->id ?> REL-row" > -->
            <div class="list_house REL-row" id="rem<?php echo $row->id; ?>" >

             <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 rem_list_image_container">

                <span class="col_img" style="position: relative">
                    <a href="<?php echo sefRelToAbs($link); ?>">
            <?php
        $house = $row;
        $imageURL = $house->image_link;
        if ($imageURL == '') $imageURL = _REALESTATE_MANAGER_NO_PICTURE_BIG;
            $file_name = rem_picture_thumbnail($imageURL,
                         $realestatemanager_configuration['foto']['width'],
                          $realestatemanager_configuration['foto']['high'], $watermark);
            $file = $mosConfig_live_site . 'components/com_realestatemanager/photos/' . $file_name;
            echo '<img alt="' . $house->htitle . '" title="' . $house->htitle .
             '" src="' . $file . '" border="0" class="little">';
?>
                    </a>

                <?php
                        if ($house->listing_status){
                          if ($house->listing_status != 0){
                            $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
                            $ls = 1;
                            foreach ($listing_status1 as $listing_status2) {
                                $listing_status[$ls] = $listing_status2;
                                $ls++;
                            }
                            echo '<div class="rem_listing_status">'.$listing_status[$house->listing_status].'</div>';
                          }
                        }
                    ?>

                <div class="col_rent">
        <?php
        if ($params->get('show_housestatus')) {
            if ($params->get('show_houserequest')) {
                $data1 = JFactory::getDBO();
                $query = "SELECT  b.rent_from , b.rent_until  FROM #__rem_rent AS b " .
                 " LEFT JOIN #__rem_houses AS c ON b.fk_houseid = c.id " . " WHERE c.id=" . $row->id .
                  " AND c.published='1' AND c.approved='1' AND b.rent_return IS NULL";
                $data1->setQuery($query);
                $rents1 = $data1->loadObjectList();
        ?>
        <?php
                if ($row->listing_type == 1) {
                    echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_RENT;
                }
                if($row->listing_type == 2){
                    echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_SALE;
                }
        ?>
        <?php
            }
        }
?>
                </div><!-- col_rent -->
                    <!-- add wishlist marker -->
                    <span class="fa-stack fa-lg i-wishlist i-wishlist-all "  >
                        <i class="fa fa-star fa-stack-1x" id="icon<?php echo $row->id ?>" title="<?php echo _REALESTATE_MANAGER_LABEL_WISHLIST_REMOVE ?>" onclick="removeFromWishlist(<?php echo $row->id; ?>)"></i>
                    </span>
                    <!-- end add wishlist marker -->
                </span>

                </div>

                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8 rem_list_container">

                <div class="col_htitle">
                    <a href="<?php echo sefRelToAbs($link); ?>" class="category<?php
                     echo $params->get('pageclass_sfx'); ?>">
                    <?php positions_rem(words_limit($row->htitle, 5, '...')); ?></a>
                </div>
                <div class="price_hits">
                <?php
        if ($row->price !== '' && $row->priceunit !== '') {
?>
        <?php
        if (!incorrect_price($row->price)){
            if ($row->price != '' || $row->priceunit != '') {
                if ($realestatemanager_configuration['price_unit_show'] == '1') {
                    if ($realestatemanager_configuration['sale_separator']) {
?>
                        <div class="price_priceunit">
                            <span class="col_price">
                        <?php echo formatMoney($row->price, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']); ?>
                            </span>
                            <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                        </div>
                                <?php
                    } else { ?>
                        <div class="price_priceunit">
                            <span class="col_price"><?php echo $row->price; ?></span>
                            <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                        </div>
                    <?php
                    }
                } else {
                    if ($realestatemanager_configuration['sale_separator']) {
?>
                        <div class="price_priceunit">
                            <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                            <span class="col_price">
            <?php echo formatMoney($row->price, $realestatemanager_configuration['sale_fraction'], $realestatemanager_configuration['price_format']); ?></span>
                        </div>
                                <?php
                    } else { ?>

                        <div class="price_priceunit">
                            <span class="col_priceunit"><?php echo $row->priceunit; ?></span>
                            <span class="col_price"><?php echo $row->price; ?></span>
                        </div>

<?php
                    }
                }
            }
        }else{
            echo  '<span class="col_price">'.$row->price.'</span>';
        }
    }
?>
                </div> <!-- price_hits -->


    <div class="col_hlocation">
        <?php if ( trim($row->hcountry) !== '' || trim($row->hregion) !== '' || trim($row->hcity) !== '' || trim($row->hzipcode) !== '' || trim($row->hlocation) !== '' ) { ?>
                    <i class="fa fa-map-marker"></i>
    <?php if (trim($row->hcountry)) { ?>
                    <span class="col_text_2"><?php echo trim($row->hcountry); ?></span>,

<?php
        }
        if (trim($row->hregion)) { ?>
                    <span class="col_text_2"><?php echo trim($row->hregion); ?></span>,

<?php
        }
        if (trim($row->hcity)) { ?>
                    <span class="col_text_2"><?php echo trim($row->hcity); ?></span>,

            <?php
        }
        if (trim($row->hzipcode)) { ?>
                    <span class="col_text_2"><?php echo trim($row->hzipcode); ?></span>,

            <?php
        }
        if (trim($row->hlocation)) { ?>
                <span class="col_02"><?php echo trim($row->hlocation); ?></span>.
                <?php
        }
        } ?>
    </div>

                                <?php
        if (trim($row->description)) {
?>
          <div class="rem_house_description">
              <?php positions_rem(words_limit($row->description, 40, '...')); ?>
          </div>
                <?php
        }
?>
                            <div class="rem_type_catlist">

                        <?php
        if ($params->get('show_category')) {
            $link1 = 'index.php?option=com_realestatemanager&amp;task=showCategory&amp;catid=' .
             $tmphouse->catid[0] . '&amp;Itemid=' . $Itemid;
?>
            <div class="col_category_title row_text">
                    <?php
            $row->category_titel = array();
            foreach($tmphouse->catid as $key => $value) {
                $query = "SELECT title FROM #__rem_main_categories WHERE id =" . $value;
                $database->setQuery($query);
                $row->category_titel[$key] = $database->loadResult();
                //echo "------------->";print_r($total);exit();
                $link1 = 'index.php?option=com_realestatemanager&amp;task=showCategory&amp;catid=' .
                 $tmphouse->catid[$key] . '&amp;Itemid=' . $Itemid;
?>
                    <i class='fa fa-tag'></i>
                    <a href="<?php echo sefRelToAbs($link1); ?>"
                     class="category<?php echo $params->get('pageclass_sfx'); ?>">
                    <?php echo $row->category_titel[$key]; ?>
                    </a>
                    <?php
            }
?>
            </div>
                <?php
        }
?>

            <?php
        if ($params->get('hits')) {
?>
            <div class="col_hits row_text">
                <span class="col_10">
            <?php echo "<i class='fa fa-eye'></i>" . "&nbsp;" . _REALESTATE_MANAGER_LABEL_HITS; ?>:
                </span>
                <span class="col_11">
            <?php echo $row->hits; ?>
                </span>
            </div>
            <?php
        }
?>
            <?php
        if (trim($row->house_size)) {
?>
                <div class="row_text">
                    <i class="fa fa-expand"></i>
                    <span class="col_text_2">
                        <?php echo $row->house_size; ?>
                        <?php echo _REALESTATE_MANAGER_LABEL_SIZE_SUFFIX; ?>
                    </span>
                </div>
                <?php
        }
?>
            <?php
        if (trim($row->year)) { ?>
                <div class="row_text">
                    <i class="fa fa-calendar"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?>:</span>
                    <span class="col_text_2"><?php echo $row->year; ?></span>
                </div>
            <?php
        }
        if (trim($row->rooms)) { ?>
                <div class="row_text">
                    <i class="fa fa-building-o"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_ROOMS; ?>:</span>
                    <span class="col_text_2"><?php echo $row->rooms; ?></span>
                </div>
            <?php
        }
        if (trim($row->bedrooms)) { ?>
                <div class="row_text">
                    <i class="fa fa-inbox"></i>
                    <span class="col_text_1"><?php echo _REALESTATE_MANAGER_LABEL_BEDROOMS; ?>:</span>
                    <span class="col_text_2"><?php echo $row->bedrooms; ?></span>
                </div>
                        <?php
        }
?>
            <div style="clear: both;"></div>
                        </div>

                </div>

            </div> <!-- list_house -->

                    <?php
    }
?>
    </div> <!-- list -->

                <?php positions_rem($params->get('singleuser05')); ?>
                <?php positions_rem($params->get('singlecategory06')); ?>
                <?php
}
?>
    <br/>
     <div id="pagenavig">
    <?php
$paginations = $arr;
if ($paginations && ($pageNav->total > $pageNav->limit)) {
    echo $pageNav->getPagesLinks();
}
?>
    </div>

    </div> <!-- end span9  -->

</div><!-- end row-fluid  -->
   <?php positions_rem($params->get('singlecategory09')); ?>
   <?php positions_rem($params->get('singlecategory11')); ?>
<div>
<?php
mosHTML::BackButton($params, $hide_js);
?>
</div>

<style type="text/css">
    #list img.little{
        /*height: <?php //echo $params->get('minifotohigh');
 ?>px;
        width:<?php //echo $params->get('minifotowidth');
 ?>px;*/
    }

    .okno{
        width: <?php echo $realestatemanager_configuration['fotogallery']['width'] + 10; ?>px;
        height: <?php echo $realestatemanager_configuration['fotogallery']['high'] + 65; ?>px;
        float:left;
        padding:10px;
        position:relative;
        border:1px solid white;
        margin:5px;

    }
    .okno:hover{
        border:1px solid black;
    }
    .okno img{

        width:<?php echo $realestatemanager_configuration['fotogallery']['width']; ?>px;
        max-height: <?php echo $realestatemanager_configuration['fotogallery']['high']; ?>px;
    }
    .okno .texthouse{
        width:<?php echo $realestatemanager_configuration['fotogallery']['width']; ?>px;
        position:absolute;
        bottom:5px;
    }
    .okno .price{
        float:right;
    }
    .okno .titlehouse{
        max-height: 50px;
    }

</style>

<!-- Add code for modal window: -->
<!-- Modal for wishlist -->
<a href="#aboutus" class="rem-button-about"></a>
<a href="#rem-modal-css" class="rem-overlay" id="rem-aboutus" style="display: none;"></a>
<div class="rem-popup">
    <div class="rem-modal-text">
        Please past text to modal
    </div>
    <a class="rem-close" title="Close" href="#rem-close"></a>
</div>

