<?php
/**
 *
 * @package  RealEstateManager
 * @copyright 2021 Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

global $Itemid, $mosConfig_live_site, $realestatemanager_configuration, $my, $database, $doc, $acl;


$watermark_path = ($realestatemanager_configuration['watermark']['show'] == 1) ? 'watermark/' : '';
$watermark = ($realestatemanager_configuration['watermark']['show'] == 1) ? true : false;

$session = JFactory::getSession();
$arr = $session->get("array", "default");

positions_rem($params->get('my01'));
/*********************************************get max count car*****************/
$count_house_all = getCountHouseForSingleUserREM($my, $database,
  $realestatemanager_configuration);
$count_house_single_user = $count_house_all[0];
$count_house_for_single_group = $count_house_all[1];
/*******************************************************************************/
function words_limit($input_text, $limit = 50, $end_str = '') {
    $input_text = strip_tags($input_text);
    $words = explode(' ', $input_text);
    if ($limit < 1 || sizeof($words) <= $limit) {
        return $input_text;
    }
    $words = array_slice($words, 0, $limit);
    $out = implode(' ', $words);
    return $out . $end_str;

}
?>

<script>
    function rem_buttonClick(button){
        if(button.name=='addhouse'){
            rem_submitform('show_add');
            return;
        }

        var c = document.getElementsByName('bid[]');
        for(var i=0;i<c.length;i++){
            if(c[i].checked){
                var checkedhouses = true;
                break;
            }
        }

        if(!checkedhouses){
            alert("<?php echo _REALESTATE_MANAGER_ERROR_NOT_SELECTED; ?>")
            return;
        }

        if(button.name=='publish_house'){
        var maxCountHouse = <?php echo ($count_house_for_single_group + 0) ?>;
        var countHouse = <?php echo ($count_house_single_user + 0) ?>;
/***************************************** cheack for max count car *************/

        if(countHouse >= maxCountHouse){
            alert('<?php echo _REALESTATE_MANAGER_YOU_HAVE;?>: ' + countHouse +
		' <?php echo _REALESTATE_MANAGER_NUMBER_HOUSES;?>, ' +
		'<?php echo _REALESTATE_MANAGER_MAXIMUM_COUNT_HOUSE_FOR_YOUR;?>: ' + maxCountHouse);
            return;
        }

/********************************************************************************/
            rem_submitform('publish_house');
            return;
        }

        if(button.name=='unpublish_house'){
            rem_submitform('unpublish_house');
            return;
        }

        if(button.name=='delete_house'){
            resultat = confirm("<?php echo _REALESTATE_MANAGER_DELETE_HOUSES; ?>");
            if (resultat) rem_submitform('delete_house');
            return;
        }
    }
</script>
  
  <div class="componentheading<?php echo $params->get('pageclass_sfx'); ?>">
    <?php 

    if ( is_menu_item_rem($Itemid)
        && $params->get('show_page_heading') 
        && trim($params->get('page_heading')) != "" ) {  ?>
              <h1><?php echo $params->get('page_heading'); ?></h1>
    <?php } else {  ?>
              <h1><?php echo _REALESTATE_MANAGER_LABEL_TITLE_MY_HOUSES;  ?></h1>                
    <?php } ?>
  </div>

  <div class="componentbody<?php echo $params->get('pageclass_sfx'); ?>">

<form action="<?php echo JRoute::_("index.php?option=" . $option."&Itemid=" . $Itemid ); ?>"
  method="get" name="adminForm" id="adminForm">
    </br> <!--br for simple membership -->
  <div class="my_house_filter REL-row">

  <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-5 REL-collumn-lg-4">

      <div class="REL-row">
          <div class="REL-collumn-xs-12 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4">

            <label for="search_keyword"><?php echo _REALESTATE_MANAGER_SHOW_SEARCH; ?>
            </label>

          </div>

          <div class="REL-collumn-xs-12 REL-collumn-sm-8 REL-collumn-md-8 REL-collumn-lg-8">
              <input type="text" name="search" value="<?php echo $search; ?>"
              class="inputbox" onChange="document.adminForm.submit();" id="search_keyword" />
          </div>
      </div>

  </div>

  <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-5 REL-collumn-lg-4">

  <div class="REL-row">

       <div class="REL-collumn-xs-12 REL-collumn-sm-4 REL-collumn-md-4 REL-collumn-lg-4">
          <label for="search_list"><?php echo _REALESTATE_MANAGER_SHOW_SEARCH_BY; ?>:</label>
       </div>

      <div class="REL-collumn-xs-12 REL-collumn-sm-8 REL-collumn-md-8 REL-collumn-lg-8">
          <?php echo $search_list; ?>
      </div>

      </div>

  </div>
  </div>

  <div class="my_house_filter REL-row">


    <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3"><?php echo $publist; ?></div>
    <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3"><?php echo $rentlist; ?></div>
    <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3"><?php echo $clist; ?></div>
    <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3"><?php echo $language; ?></div>
    <div class="REL-collumn-xs-12 REL-collumn-sm-6 REL-collumn-md-3 REL-collumn-lg-3"><?php echo $ownerlist; ?></div>

  </div>
<?php
PHP_realestatemanager::showTabs();
?>
<form action="<?php echo JRoute::_("index.php?option=" . $option."&Itemid=" . $Itemid ); ?>"
  method="get" name="adminForm" id="adminForm">
    <?php
if (count($houses) && $realestatemanager_configuration['cb_edit']['show']) {
?>

        <div id="my_houses_edit" class="my_houses">
            <div class="row_check_all">
                <input type="checkbox" name="toggle" value=""
                  onClick="rem_checkAll(this);" />
                <span><?php echo _REALESTATE_MANAGER_CHECK_ALL; ?></span>
            </div>
            <?php
    foreach($houses as $i => $house) {
        $h_item = new mosRealEstateManager($database);
        $h_item->load($house->id);
        $h_item->setCatIds();
        $house->catid = $h_item->catid;
        $link = 'index.php?option=com_realestatemanager&task=view_house&id=' .
          $house->id . '&catid=' . $h_item->catid[0] .
          '&Itemid=' . $Itemid ;
?>

                <div class="row_house sectiontableentry<?php echo $i % 2; ?> REL-row">

                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-4 REL-collumn-lg-4 rem_list_image_container">

                <span class="col_img" style="position: relative">
              <a href="<?php echo sefRelToAbs($link); ?>">
                            <?php
                        $imageURL = $house->image_link;
                        if ($imageURL == '') $imageURL = _REALESTATE_MANAGER_NO_PICTURE_BIG;
                            $file_name = rem_picture_thumbnail($imageURL,
                               $realestatemanager_configuration['foto']['width'],
                               $realestatemanager_configuration['foto']['high'], $watermark);
                            $file = $mosConfig_live_site . 'components/com_realestatemanager/photos/' .
                              $file_name;
                            echo '<img alt="' . $house->htitle . '" title="' . $house->htitle .
                              '" src="' . $file . '" border="0" class="little">';
                ?>
                                    </a>
                <?php
                                        if ($house->listing_status){
                                          if ($house->listing_status != 0){
                                            $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
                                            $ls = 1;
                                            foreach ($listing_status1 as $listing_status2) {
                                                $listing_status[$ls] = $listing_status2;
                                                $ls++;
                                            }
                                            echo '<div class="rem_listing_status">'.$listing_status[$house->listing_status].'</div>';
                                          }
                                        }
                                    ?>
                                <div class="col_rent">
              <?php
              if ($realestatemanager_configuration['rentstatus']['show']) {
                  $data1 = JFactory::getDBO();
                  $query = "SELECT  b.rent_from , b.rent_until  FROM #__rem_rent AS b " .
                     " LEFT JOIN #__rem_houses AS c ON b.fk_houseid = c.id " .
                     " WHERE c.id=" . $house->id .
                     " AND c.published='1' AND c.approved='1' AND b.rent_return IS NULL";
                  $data1->setQuery($query);
                  $rents1 = $data1->loadObjectList();
              ?>
              <?php
                  if (($house->listing_type == 1)) {
                      echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_RENT;
                  } else if (($house->listing_type == 2)) {
                      echo _REALESTATE_MANAGER_LABEL_ACCESSED_FOR_SALE;
                  } else if (($house->listing_type == 3)) {
                      echo _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST;
                  }
              ?>
              <?php
                        }
                ?>
                                </div><!-- col_rent -->
                            </span>
                        </div>

                <div class="REL-collumn-xs-12 REL-collumn-sm-12 REL-collumn-md-8 REL-collumn-lg-8 rem_list_container">


                    <div class="title_my_house">
                        <?php
        if ($option != "com_realestatemanager") {
?>
          <a href="index.php?option=com_realestatemanager&task=view_house&is_show_data=1&id=<?php
             echo $house->id; ?>&catid=<?php echo $house->catid[0];
             ?>&Itemid=<?php echo $Itemid  ; ?>" alt="">
          <?php
        } else {
?>
         <a href="index.php?option=com_realestatemanager&task=view&id=<?php echo $house->id; ?>&catid=<?php
           echo $house->catid[0]; ?>&Itemid=<?php echo $Itemid; ?>" alt="">
                 <?php
        }
?>
        <?php positions_rem(words_limit($house->htitle, 4, '...')); ?>
          </a>
                    </div>
                        <div class="col_hlocation">
                          <?php if ( trim($house->hcountry) !== '' || trim($house->hregion) !== '' || trim($house->hcity) !== '' || trim($house->hzipcode) !== '' || trim($house->hlocation) !== '' ) { ?>
                          <i class="fa fa-map-marker"></i>
                        <?php if (trim($house->hcountry)) { ?>
                          <span class="col_text_2"><?php echo $house->hcountry; ?></span>,

                    <?php
        }
        if (trim($house->hregion)) { ?>
                          <span class="col_text_2"><?php echo trim($house->hregion); ?></span>,

                    <?php
        }
        if (trim($house->hcity)) { ?>
                          <span class="col_text_2"><?php echo trim($house->hcity); ?></span>,

        <?php
        }
        if (trim($house->hzipcode)) { ?>
                          <span class="col_text_2"><?php echo trim($house->hzipcode); ?></span>,

        <?php
        }
        if (trim($house->hlocation)) { ?>
                          <span class="col_02"><?php echo trim($house->hlocation); ?></span>.
                          <?php
        }
      } ?>
                        </div>
        <div class="rem_type_catlist">
                        <div class="row_text">
                            <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_PUBLIC; ?></span>
                            <span class="col_02">
        <?php $img = ($house->published) ? '<i class="fa fa-check"></i>' : '<i class="fa fa-ban"></i>'; ?>
        <?php echo $img ?>
                            </span>
                        </div>

                        <div class="row_text">
                            <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_APPROVED; ?></span>
                            <span class="col_02">
        <?php $img = ($house->approved) ? '<i class="fa fa-check"></i>' : '<i class="fa fa-ban"></i>'; ?>
        <?php echo $img ?>
                            </span>
                        </div>
                    <div class="row_hits row_text">
        <?php echo "<i class='fa fa-eye'></i>"; ?>
                        <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_HITS; ?></span>
                        <span class="col_02"><?php echo $house->hits; ?></span>
                    </div>
                    <div class="edit row_text">
                        <?php
    if ($option == "com_comprofiler") {
?>
          <a href="index.php?option=<?php
           echo $option; ?>&task=edit_house&is_show_data=1&tab=getmyhousesTab&id=<?php
            echo $house->id; ?>&Itemid=<?php echo $Itemid ; ?>">
<?php
    } else if ($option != "com_realestatemanager") {
?>
          <a href="index.php?option=<?php
           echo $option; ?>&task=edit_house&is_show_data=1&id=<?php
            echo $house->id; ?>&Itemid=<?php echo $Itemid ; ?>">
<?php
        } else {
?>
          <a href="index.php?option=<?php echo $option; ?>&task=edit_house&id=<?php
           echo $house->id; ?>&Itemid=<?php echo $Itemid; ?>">
<?php
        }
?>
        <?php echo "<i class='fa fa-edit'></i>"; ?>
                            </a>
                    </div>
                </div>
                <div class="row_check_all">
                       <input type="checkbox" value="<?php echo $house->id; ?>"
                         name="bid[]" id="cb<?php echo $i; ?>" />
                    <div class="row01">
                        <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_ID; ?>
                        </span>
                        <span class="col_02"><?php echo $house->houseid; ?></span>
                    </div>
                </div>

          </div>

                </div>
                <?php
    } //endfor house

?>

            <div>
                <input type="hidden" name="option" value="<?php echo $option; ?>"/>
                <input type="hidden" id="adminFormTaskInput" name="task" value="" />
<?php
    if ($option != "com_realestatemanager") {
?>
                <input type="hidden" name="is_show_data" value="1"/>
<?php
    }
?>
<?php
    if ($option == "com_comprofiler") {
?>
                <input type="hidden" name="tab" value="getmyhousesTab"/>
<?php
    }
?>
                <input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>"/>
            </div>

        </div> <!--  myhouses and   -->

        <div class="box_button">
            <?php positions_rem($params->get('my02')); ?>

            <?php
    if ($realestatemanager_configuration['add_house']['show']) {
        if(checkAccess_REM(
          $realestatemanager_configuration['add_house']['registrationlevel'],
           'NORECURSE', userGID_REM($my->id), $acl)) {
?>
            <input type="button" name="addhouse"
              value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_ADD_HOUSE; ?>"
              onclick="rem_buttonClick(this);"/>
        <?php
        }
    }
?>
            <input type="button" name="publish_house"
              value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_PUBLISH; ?>"
              onclick="rem_buttonClick(this)"/>
            <input type="button" name="unpublish_house"
              value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_UNPUBLISH; ?>"
              onclick="rem_buttonClick(this)"/>
            <input type="button" name="delete_house"
              value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_DELETE; ?>"
              onclick="rem_buttonClick(this)"/>
    <?php positions_rem($params->get('my03')); ?>
            <input type="button" name="rentout"
              value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_RETURN_HOUSE_FROM_RENT;
              ?>" onclick="rem_buttonClickRent(this)"/>
            <input type="button" name="rent"
              value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_RENT; ?>"
              onclick="rem_buttonClickRent(this)"/>
            <input type="button" name="edit_rent"
              value="<?php echo _REALESTATE_MANAGER_TOOLBAR_ADMIN_EDIT_RENT; ?>"
              onclick="rem_buttonClickRent(this)"/>
        </div>

        <div id="pagenavig">
            <?php
    $paginations = $arr;
    if ($pageNav->total > $pageNav->limit) {
        echo $pageNav->getPagesLinks();
    }
?>
        </div>

    </form>
    <?php
    positions_rem($params->get('my04'));
} else {
    if ($realestatemanager_configuration['cb_edit']['show'])
      echo "<div style='margin:10px 0;'>" . _REALESTATE_MANAGER_HAVENOT_HOUSES .
        "</div>";
?>
    <form action="<?php echo JRoute::_("index.php?option=" . $option."&Itemid=" . $Itemid ); ?>" method="get" name="adminForm" id="adminForm">
        <?php
    if ($realestatemanager_configuration['add_house']['show']) {
      if(checkAccess_REM($realestatemanager_configuration['add_house']['registrationlevel'],
        'NORECURSE', userGID_REM($my->id), $acl)) {
?>
        <input type="button" name="addhouse"
          value="<?php echo _REALESTATE_MANAGER_LABEL_BUTTON_ADD_HOUSE; ?>"
          onclick="rem_buttonClick(this);"/>
    <?php
      }
    }
?>
        <input type="hidden" name="option" value="<?php echo $option; ?>"/>
        <input type="hidden" id="adminFormTaskInput" name="task" value="" />
        <?php
    if ($option != "com_realestatemanager") {
?>
            <input type="hidden" name="is_show_data" value="1"/>
        <?php
    }
?>
        <input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>"/>
    </form>
    <?php
}
?>

  </div> <!--class="componentbody -->