jQuerOs(document).ready(function () {

  const menuItems = document.querySelectorAll('.mod-menu .parent');

  function addClassToParent(event) {
    const menuItem = event.target;
    menuItem.parentElement.classList.add('focus');
  }

  function removeClassFromParent(event) {
    const menuItem = event.target;
    menuItem.parentElement.classList.remove('focus');
  }

  menuItems.forEach(item => {
    item.addEventListener('mouseenter', addClassToParent);
    item.addEventListener('mouseleave', removeClassFromParent);

    item.addEventListener('focusin', addClassToParent);
    item.addEventListener('focusout', removeClassFromParent);

    const subMenu = item.querySelector('.mod-menu__sub');
    if (subMenu) {
      subMenu.addEventListener('mouseenter', addClassToParent);
      subMenu.addEventListener('mouseleave', removeClassFromParent);

      subMenu.addEventListener('focusin', function () {
        item.classList.add('focus');
      });
      subMenu.addEventListener('focusout', function () {
        item.classList.remove('focus');
      });
    }
  });

  var sidebarRightMenu = jQuerOs('.sidebar-right-menu');
  sidebarRightMenu.find('li.parent > a, li.parent > .nav-header').append('<i class="fas fa-angle-double-left"></i>');
  sidebarRightMenu.find(' > li').last().addClass('lastChild');

  var sidebarLeftMenu = jQuerOs('.sidebar-left-menu');
  sidebarLeftMenu.find('li.parent > a, li.parent > .nav-header').append('<i class="fas fa-angle-double-right"></i>');
  sidebarLeftMenu.find(' > li').last().addClass('lastChild');

  jQuerOs('.itp-subscribe form .inputbox').attr('placeholder', 'Email Address');

  var wrapheight = jQuerOs(window).outerHeight() - jQuerOs(".header").outerHeight(true) - jQuerOs("#footer").outerHeight(true);
  jQuerOs("#wrapper").css("min-height", wrapheight);

  jQuerOs(document).ready(function () {
    jQuerOs(".main_menu .navbar-toggle").click(function () {
      if (jQuerOs(".main_menu #main-navbar-collapse").hasClass("activeMenu")) {
        jQuerOs(".main_menu #main-navbar-collapse").removeClass("activeMenu");
        jQuerOs(".main_menu #main-navbar-collapse").addClass("menuInActive");
        jQuerOs(".main_menu #main-navbar-collapse").slideDown();
      } else {
        jQuerOs(".main_menu #main-navbar-collapse").removeClass("menuInActive");
        jQuerOs(".main_menu #main-navbar-collapse").addClass("activeMenu");
        jQuerOs(".main_menu #main-navbar-collapse").slideUp();
      }
    });
  });


  // ----------------------
  var show = true;
  var countbox = ".wrapperStatistics";
  el = jQuerOs(".wrapperStatistics").html();
  if (!el) {

  } else {
    jQuerOs(window).on("scroll load resize", function () {
      if (!show) return false;
      var w_top = jQuerOs(window).scrollTop();
      var e_top = jQuerOs(countbox).offset().top;
      var w_height = jQuerOs(window).height();
      var d_height = jQuerOs(document).height();
      var e_height = jQuerOs(countbox).outerHeight();
      if (w_top + 500 >= e_top || w_height + w_top == d_height || e_height + e_top < w_height) {
        jQuerOs('.statisticsNumber').css('opacity', '1');
        jQuerOs('.statisticsNumber').spincrement({
          thousandSeparator: " ",
          duration: 10000
        });

        show = false;
      }
    });
  }
  // ---------------------

  // _____________________________________________________________________________________________ footer to bottom
  function footerToBottom() {
    var browserHeight = jQuerOs(window).height(),
      footerOuterHeight = jQuerOs('.footer').outerHeight(true),
      mainHeightMarginPaddingBorder = jQuerOs('#wrapper').outerHeight(true) - jQuerOs('#wrapper').height() + 3;
    jQuerOs('#wrapper').css({
      'min-height': browserHeight - footerOuterHeight - mainHeightMarginPaddingBorder,
    });
  };
  footerToBottom();
  jQuerOs(window).resize(function () {
    footerToBottom();
  });

});

jQuerOs(document).ready(function () {

  var mainMenu = jQuerOs('#site-navigation-main ul.nav');
  mainMenu.find('li.parent > a').next('ul').hide();
  mainMenu.find('li.parent > a').append('<i class="fas fa-angle-down"></i>');
  mainMenu.find('li.parent > span.separator').next('ul').hide();
  mainMenu.find('li.parent > span.separator').append('<i class="fas fa-angle-down"></i>');
  mainMenu.find('li.parent > .nav-header').next('ul').hide();
  mainMenu.find('li.parent > .nav-header').append('<i class="fas fa-angle-down"></i>');

  jQuerOs(function () {

    mainMenu.find('li.parent').hover(function () {

      if (!jQuerOs(this).children('ul').is(':visible')) {
        jQuerOs(this).children('ul').stop().slideDown(50);
      }
    },
      function () {
        if (jQuerOs(this).children('ul').is(':visible')) {
          jQuerOs(this).children('ul').slideUp(50);
        }
      });
  });;
});