<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2025 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::root().'/components/com_os_cck/assets/css/admin_style.css');

require_once(JPATH_SITE . '/components/com_os_cck/functions.php');

class JFormFieldInstanceManagerLayout extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }
    $query = "SELECT ce.eid AS id, ce.name AS title FROM #__os_cck_entity AS ce WHERE published='1' ";
    $db->setQuery($query);
    $entities = $db->loadObjectList();
    $list = array();
    foreach ($entities as $entity) {
      $list[]  = JHTML::_('select.option',$entity->id,$entity->title);
    }
    return JHTML::_('select.genericlist', $list,'jform[params][entity_list][]','class="inputbox" multiple="true"','value','text', $params->get('entity_list',''));
  }
}

class JFormFieldInstanceManagerAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'instance_manager_access',
        'list.select' => $params->get('instance_manager_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][instance_manager_access][]', $attr);
    
  }
}

class JFormFieldAddInstanceAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'im_add_instance_access',
        'list.select' => $params->get('im_add_instance_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][im_add_instance_access][]', $attr);
    
  }
}

class JFormFieldRentInstanceAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'im_rent_requests_access',
        'list.select' => $params->get('im_rent_requests_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][im_rent_requests_access][]', $attr);
    
  }
}

class JFormFieldBuyInstanceAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'im_rent_requests_access',
        'list.select' => $params->get('im_rent_requests_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][im_rent_requests_access][]', $attr);
    
  }
}

class JFormFieldApproveAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'im_approve_access',
        'list.select' => $params->get('im_approve_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][im_approve_access][]', $attr);
    
  }
}

class JFormFieldRentManagerAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'rent_manager_access',
        'list.select' => $params->get('rent_manager_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][rent_manager_access][]', $attr);
    
  }
}

class JFormFieldRequestsAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'im_requests_access',
        'list.select' => $params->get('im_requests_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][im_requests_access][]', $attr);
    
  }
}

class JFormFieldRentHistoryAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'im_rent_history_access',
        'list.select' => $params->get('im_rent_history_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][im_rent_history_access][]', $attr);
    
  }
}

class JFormFieldDeleteAccess extends JFormField{

  protected function getInput(){
    $input = JFactory::getApplication()->input;
    $db = JFactory::getDBO();
    $params = new JRegistry;
    if($input->get('id', '') != '') {
      $menu = new JTableMenu($db);
      $menu->load($input->get('id', ''));
      $params->loadString($menu->params);
    }

    $gtree = get_group_children_tree_cck('instance_manager');

    $attr = array (
        'list.attr' => ' multiple="true" class="form-select inputbox valid form-control-success"',
        'id' => 'im_delete_access',
        'list.select' => $params->get('im_delete_access','8'),
        'group.items' => null,
        'option.key.toHtml' => false,
        'option.text.toHtml' => false
    );
    return JHTML::_('select.groupedlist',$gtree,'jform[params][im_delete_access][]', $attr);
    
  }
}