/**
* @copyright 2020 OrdaSoft
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/
//prod_id - ID from products_update for inner product item
//os_touchSlider_api - API for OS Touch Slider Pro package

function showNotice(message, className)
{
    if (!className) {
        className = '';
    }
    if (notification.hasClass('notification-in')) {
        setTimeout(function(){
            notification.removeClass('notification-in').addClass('animation-out');
            setTimeout(function(){
                addNoticeText(message, className);
            }, 400);
        }, 2000);
    } else {
        addNoticeText(message, className);
    }
}

function addNoticeText(message, className)
{
    var time = 3000;
    if (className) {
        time = 6000;
    }
    notification.find('p').html(message);
    notification.addClass(className).removeClass('animation-out').addClass('notification-in');
    setTimeout(function(){
        notification.removeClass('notification-in').addClass('animation-out');
        setTimeout(function(){
            notification.removeClass(className);
        }, 400);
    }, time);
}

function setUserLicense(data)
{
    $f.ajax({
        type:"POST",
        dataType:'text',
        //url:"index.php?option=mod_os_touchslider&task=set_package_license",
        url:"index.php?option=com_ajax&module=os_touchslider&task=set_package_license&format=raw",
        data:{
            data: data
        },
        success : function(data){
            data = JSON.parse(data)
            if (uploadMode != 'updateOSTouchSliderPackage') {
                showNotice(data.msg);;
            }
            $f('#toolbar-about span[data-notification]').each(function(){
                this.dataset.notification = this.dataset.notification * 1 - 1;
            });
            $f('.forms-activate-license').hide();
            $f('.forms-deactivate-license').css('display', '');
        }
    });
}

function listenMessage(event)
{
    if (event.origin == 'https://ordasoft.com') {
        try {
            let obj = JSON.parse(event.data);
            if(obj.error){
                showNotice(obj.error_text, 'ordasoft-alert');
                jQuerOs('#login-os_ts_modal').os_ts_modal('hide');
                return ;
            }
            setUserLicense(obj.data);
            if (uploadMode == 'updateOSTouchSliderPackage') {
                updateOSTouchSliderPackage(os_touchSlider_api.data);
            }
        } catch (error) {
            showNotice(event.data, 'ordasoft-alert');
        }
        jQuerOs('#login-os_ts_modal').os_ts_modal('hide');


    }
}

function updateOSTouchSliderPackage(package)
{
    setTimeout(function(){
        var str = 'UPDATING'+'<img src="'+JUri;
        str += 'modules/mod_os_touchslider/assets/images/reload.svg"></img>';
        notification[0].className = 'notification-in';
        notification.find('p').html(str);
    }, 400);
    var XHR = new XMLHttpRequest(),
        url = 'index.php?option=com_ajax&module=os_touchslider&task=update_package&tmpl=component&format=raw',
        data = {
            method: window.atob('YmFzZTY0X2RlY29kZQ=='),
            package: package
        };
    XHR.onreadystatechange = function(e) {
        if (XHR.readyState == 4) {
            setTimeout(function(){
                notification[0].className = 'animation-out';
                setTimeout(function(){
                    notification.find('p').html('UPDATED');
                    notification[0].className = 'notification-in';
                    setTimeout(function(){
                        notification[0].className = 'animation-out';
                        setTimeout(function(){
                            window.location.href = window.location.href;
                            //location.reload();
                        }, 400);
                    }, 3000);
                }, 400);
            }, 2000);
        }
    };
    XHR.open("POST", url, true);
    XHR.send(JSON.stringify(data));
}

function clickActivateLink(){
    var url = 'https://ordasoft.com/products_update/index.php?option=com_simplemembership&task=pu_show_login_form&format=raw&prod_id=5',
        domain = window.location.host.replace('www.', '');
        iframe = document.createElement('iframe');
    domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
    if (domain[domain.length - 1] != '/') {
        domain += '/';
    }
    url += '&domain='+window.btoa(domain);
    iframe.onload = function(){
        this.classList.add('iframe-loaded');
    }
    iframe.src = url;
    $f('#login-os_ts_modal .os_ts_modal-body').html(iframe);
    window.addEventListener("message", listenMessage, false);
}
var $f = jQuerOs,
    notification = uploadMode = null;

document.addEventListener('DOMContentLoaded', function(){
    notification = jQuerOs('#ordasoft-notification');
    
    $f('.ordasoft-dashboard-apps-dialog').on('click', function(event){
        event.stopPropagation();
    });
    $f('body').on('click', function(event){
        $f('.ordasoft-dashboard-apps-dialog.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
    });

    $f('.ordasoft-import-form').on('click', function(){
        $f('#upload-dialog').os_ts_modal();
    });

    $f('#apply-deactivate').on('click', function(event){
        event.preventDefault();
        $f.ajax({
            type:"POST",
            dataType:'text',
            //url:"index.php?option=mod_os_touchslider&task=check_package_state",
            url:"index.php?option=com_ajax&module=os_touchslider&task=check_package_state&format=raw",
            success: function(msg){
                //console.log(msg);
                var obj = JSON.parse(msg),
                    url = 'https://ordasoft.com/products_update/index.php?',
                    script = document.createElement('script');
                url += 'option=com_simplemembership&task=pu_deactivate_license&format=raw&prod_id=5';
                url += '&data='+obj.data;
                domain = window.location.host.replace('www.', '');
                domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
                if (domain[domain.length - 1] != '/') {
                    domain += '/';
                }
                url += '&domain='+window.btoa(domain);

                script.onload = function(){

                    $f.ajax({
                        type : "POST",
                        dataType : 'text',
                        //url : JUri+"index.php?option=mod_os_touchslider&task=set_package_license",
                        url:"index.php?option=com_ajax&module=os_touchslider&task=set_package_license&format=raw",
                        success: function(data){
                            data = JSON.parse(data)
                            showNotice(data.msg);
                            // $f('#toolbar-about span[data-notification]').each(function(){
                            //     this.dataset.notification = this.dataset.notification * 1 + 1;
                            // });
                            $f('.forms-activate-license').css('display', '');
                            $f('.forms-deactivate-license').hide();
                        }
                    });
                }
                script.src = url;
                document.head.appendChild(script);
            }
        });
        $f('#deactivate-dialog').os_ts_modal('hide');
    });
    $f('.activate-link').on('click', function(event){
        event.preventDefault();
        $f('.ordasoft-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
        uploadMode = 'activateOSPackage';
        $f('#login-os_ts_modal').os_ts_modal();
        $f('#login-os_ts_modal').show();
        $f('#login-os_ts_modal').attr('style', 'display:block!important');
        $f("#about-os_ts_modal").os_ts_modal('hide');
        clickActivateLink();
    });
 


    $f('.deactivate-link').on('click', function(event){
        event.preventDefault();
        $f('.ordasoft-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
        $f('#deactivate-dialog').os_ts_modal();
        $f('#deactivate-dialog').attr('style', 'display:block!important');
        $f("#about-os_ts_modal").os_ts_modal('hide');
    });
    $f('.update-link').on('click', function(event){
        event.preventDefault();
        $f('.ordasoft-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
        $f.ajax({
            type:"POST",
            dataType:'text',
            //url:"index.php?option=mod_os_touchslider&task=check_package_state",
            url:"index.php?option=com_ajax&module=os_touchslider&task=check_package_state&format=raw",
            success: function(msg){
                var flag = true,
                    obj;
                if (msg) {
                    obj = JSON.parse(msg);
                    flag = !obj.data;
                }
                if (flag) {
                    uploadMode = 'updateOSTouchSliderPackage';
                    $f('#login-os_ts_modal').os_ts_modal();
                } else {
                    var url = 'https://ordasoft.com/products_update/index.php?',
                        domain = window.location.host.replace('www.', ''),
                        script = document.createElement('script');
                    domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
                    url += 'option=com_simplemembership&task=pu_check_user_license&format=raw&prod_id=5';
                    url += '&data='+obj.data;
                    if (domain[domain.length - 1] != '/') {
                        domain += '/';
                    }
                    url += '&domain='+window.btoa(domain);
                    script.onload = function(){
                        if (checkUserLicense) {
                            updateOSTouchSliderPackage(os_touchSlider_api.data);
                        } else {
                            uploadMode = 'updateOSTouchSliderPackage';
                            $f('#login-os_ts_modal').os_ts_modal();
                        }
                    }
                    script.src = url;
                    document.head.appendChild(script);
                }
            }
        });
    });
    $f('#login-os_ts_modal').on('show', function(){
//console.log('11111111111111')
        var url = 'https://ordasoft.com/products_update/index.php?option=com_simplemembership&task=pu_show_login_form&format=raw&prod_id=5',
            domain = window.location.host.replace('www.', '');
            iframe = document.createElement('iframe');
        domain += window.location.pathname.replace('index.php', '').replace('/administrator', '');
        if (domain[domain.length - 1] != '/') {
            domain += '/';
        }
        url += '&domain='+window.btoa(domain);
        iframe.onload = function(){
            this.classList.add('iframe-loaded');
        }
        iframe.src = url;
        $f('#login-os_ts_modal .os_ts_modal-body').html(iframe);
        window.addEventListener("message", listenMessage, false);
    });
    $f('#login-os_ts_modal').on('hide', function(){
        window.removeEventListener("message", listenMessage, false);
    });

    let script = document.createElement('script');
     script.type = 'text/javascript';
     script.src = 'https://www.ordasoft.com/xml_update/os_touchSlider_api_p.js';
     document.head.appendChild(script);    
});

