<?php
defined('_JEXEC') or die('Restricted access');

/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/
$fName = $field->db_field_name;

if($layout->params == ''){
    $lParams = array();
}else{
    $lParams = unserialize($layout->params)['fields'];
}


$description_show = (isset($lParams['description_'.$fName])) ? 'checked="true"' : '';
$price_details_show = (isset($lParams['price_details_'.$fName])) ? 'checked="true"' : '';
$delete_button_show = (isset($lParams['delete_button_'.$fName])) ? 'checked="true"' : '';
$edit_quantity = (isset($lParams['edit_quantity_'.$fName])) ? 'checked="true"' : '';
$total_price_show = (isset($lParams['total_price_show_'.$fName])) ? 'checked="true"' : '';
$quantity_prefix = (isset($lParams[$fName.'_quantity_prefix'])) ? $lParams[$fName.'_quantity_prefix'] : '';
$quantity_suffix = (isset($lParams[$fName.'_quantity_suffix'])) ? $lParams[$fName.'_quantity_suffix'] : '';
$fld_name_show = (isset($lParams['showName_'.$fName])) ? 'checked="true"' : '';
$fld_alias = (isset($lParams[$fName.'_alias'])) ? $lParams[$fName.'_alias'] : $field->description;
$field_tooltip = (isset($lParams[$fName.'_tooltip'])) ? $lParams[$fName.'_tooltip'] : '';
//var_dump($lParams);
$access_selected = (isset($lParams['access_'.$fName])) ? $lParams['access_'.$fName] : '1';
$fld_require = (isset($lParams[$fName.'_required'])) ? 'checked="true"' : '';

$instanceLayoutSelected = (isset($lParams[$fName.'_instance_layout'])) ? $lParams[$fName.'_instance_layout'] : '-1';

$field_php_show = (isset($lParams[$fName.'_php_show'])) ? $lParams[$fName.'_php_show'] : '';

$field_title = (isset($lParams[$fName.'_title_field'])) ? $lParams[$fName.'_title_field'] : 0;
 
$icon_alias_prefix = (isset($lParams[$fName.'_add_icon_alias_prefix'])) ? $lParams[$fName.'_add_icon_alias_prefix'] : '';
$icon_alias_suffix = (isset($lParams[$fName.'_add_icon_alias_suffix'])) ? $lParams[$fName.'_add_icon_alias_suffix'] : '';
$icon_prefix_prefix = (isset($lParams[$fName.'_add_icon_prefix_prefix'])) ? $lParams[$fName.'_add_icon_prefix_prefix'] : '';
$icon_prefix_suffix = (isset($lParams[$fName.'_add_icon_prefix_suffix'])) ? $lParams[$fName.'_add_icon_prefix_suffix'] : '';
$icon_suffix_prefix = (isset($lParams[$fName.'_add_icon_suffix_prefix'])) ? $lParams[$fName.'_add_icon_suffix_prefix'] : '';
$icon_suffix_suffix = (isset($lParams[$fName.'_add_icon_suffix_suffix'])) ? $lParams[$fName.'_add_icon_suffix_suffix'] : '';

$field_digits_points = (isset($lParams[$fName.'_digits_points'])) ? $lParams[$fName.'_digits_points'] : 0;
$field_decimal_separator = (isset($lParams[$fName.'_decimal_separator'])) ? $lParams[$fName.'_decimal_separator'] : '.';
$field_thousands_separator = (isset($lParams[$fName.'_thousands_separator'])) ? $lParams[$fName.'_thousands_separator'] : '';

$gtree = get_group_children_tree_cck();
//var_dump($layout); exit;
//$layouts_for_link_options = get_options_for_layout_select_list('instance', $field->fk_eid, $layout->lid);

?>
<div id="options-field-<?php echo $fName?>">

    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_FIELD_NAME")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_showName_<?php echo $fName?>" <?php echo $fld_name_show?>>
    </div>
    <div class="label_alias_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_ALIAS")?></label>
        <div class="fa <?php echo $icon_alias_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_prefix" value="<?php echo $icon_alias_prefix; ?>">
        <input type="text" size="4" style="float: right;" name="fi_<?php echo $fName?>_alias"  value="<?php echo $fld_alias?>" >
        <div class="fa <?php echo $icon_alias_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_alias_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_alias_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_alias_suffix" value="<?php echo $icon_alias_suffix; ?>">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_DESCRIPTION")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_description_<?php echo $fName?>" <?php echo $description_show?>>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_TOOLTIP")?></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_tooltip"  value="<?php echo $field_tooltip?>" >
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_PRICE_DETAILS")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_price_details_<?php echo $fName?>" <?php echo $price_details_show?>>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_TOTAL_PRICE_SHOW")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_total_price_show_<?php echo $fName?>" <?php echo $total_price_show; ?>>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_EDIT_QUANTITY")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_edit_quantity_<?php echo $fName?>" <?php echo $edit_quantity?>>
    </div>
    <div class="prefix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_QUANTITY_PREFIX")?></label>
        <div class="fa <?php echo $icon_prefix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_prefix" value="<?php echo $icon_prefix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_quantity_prefix"  value="<?php echo $quantity_prefix?>" >
        <div class="fa <?php echo $icon_prefix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_prefix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_prefix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_prefix_suffix" value="<?php echo $icon_prefix_suffix; ?>">
    </div>
    <div class="suffix_wrap">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_QUANTITY_SUFFIX")?></label>
        <div class="fa <?php echo $icon_suffix_prefix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_prefix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_prefix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_prefix" value="<?php echo $icon_suffix_prefix; ?>">
        <input type="text" size="4" name="fi_<?php echo $fName?>_quantity_suffix"  value="<?php echo $quantity_suffix?>" >
        <div class="fa <?php echo $icon_suffix_suffix; ?> add_font_awesom" id="<?php echo $fName;?>_add_icon_suffix_suffix" rel="tooltip" data-toggle="tooltip" data-placement="top" title="<?php echo JText::_("COM_OS_CCK_TOOLTIP_ADD_ICON");?>"><?php echo ($icon_suffix_suffix == '') ? '&#10000;' : ''; ?></div>
        <input type="hidden" name="fi_<?php echo $fName; ?>_add_icon_suffix_suffix" value="<?php echo $icon_suffix_suffix; ?>">
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_SHOW_DELETE_BUTTON")?></label>
        <input type="checkbox" data-field-name="<?php echo $fName?>" name="fi_delete_button_<?php echo $fName?>" <?php echo $delete_button_show?>>
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_DIGITS_POINT")?><i title="<?php echo JText::_("COM_OS_CCK_LABEL_DIGITS_POINT_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_digits_points"  value="<?php echo $field_digits_points?>" >
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_DECIMAL_SEPARATOR")?><i title="<?php echo JText::_("COM_OS_CCK_LABEL_DECIMAL_SEPARATOR_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_decimal_separator"  value="<?php echo $field_decimal_separator?>" >
    </div>
    <div>
        <label><?php echo JText::_("COM_OS_CCK_LABEL_THOUSANDS_SEPARATOR")?><i title="<?php echo JText::_("COM_OS_CCK_LABEL_THOUSANDS_SEPARATOR_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input type="text" size="4" name="fi_<?php echo $fName?>_thousands_separator"  value="<?php echo $field_thousands_separator?>" >
    </div>
    <div class="php_show">
        <label><?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW")?> <i title="<?php echo JText::_("COM_OS_CCK_LABEL_PHP_SHOW_DESC")?>" class="glyphicon glyphicon-info-sign date_tooltip"></i></label>
        <input id="add-field-mask-php-show" class="new-mask" type="button" aria-invalid="false" value="+field">
        <span class="editor-button">Editor</span>
        <textarea class="php-show-editor" rows="5" cols="30" name="fi_<?php echo $fName?>_php_show"><?php echo $field_php_show?></textarea>
    </div>
    
    <?php if(isset($cck_entity_configuration[$layout->fk_eid]['check_access_fields']) && $cck_entity_configuration[$layout->fk_eid]['check_access_fields'] == '1'){ 
        $attr = array (
            'list.attr' => ' multiple="true" ',
            'id' => 'fi_access_'.$fName,
            'list.select' => $access_selected,
            'group.items' => null,
            'option.key.toHtml' => false,
            'option.text.toHtml' => false
        );
        ?>
    <div>
        <label class="access-label"><?php echo JText::_("COM_OS_CCK_LABEL_FIELD_ACCESS")?></label>
        <?php //echo JHTML::_('select.genericlist', $gtree, 'fi_access_'.$fName.'[]', 'multiple="true"','value', 'text',$access_selected);
        echo JHTML::_('select.groupedlist',$gtree,'fi_access_'.$fName.'[]', $attr);?>
    </div>
    <?php } ?>
    
</div>

