<?php
/**
 *
 * @package Joomla Real Estate
 * @copyright Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: https://ordasoft.com/joomla-real-estate
 * @license GNU General Public License version 2 or later
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

defined('_VM_IS_BACKEND') or define('_VM_IS_BACKEND', '1');

$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path'] = JPATH_SITE;
include_once( $mosConfig_absolute_path . '/components/com_realestatemanager/compat.joomla1.5.php' );
include_once( $mosConfig_absolute_path . '/components/com_realestatemanager/functions.php' );

$my = $GLOBALS['my'];

$css = $mosConfig_absolute_path .
 '/administrator/components/com_realestatemanager/admin_realestatemanager.css';
$mainframe = JFactory::getApplication();
jimport('joomla.html.pagination');
jimport('joomla.filesystem.folder');

require_once ($mosConfig_absolute_path .
 '/administrator/components/com_realestatemanager/realestatemanager.html.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.language.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.feature.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.rent.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.rent_request.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.buying_request.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.class.property_request.php');
require_once ($mosConfig_absolute_path .
 '/administrator/components/com_realestatemanager/realestatemanager.class.impexp.php');
require_once ($mosConfig_absolute_path .
 '/administrator/components/com_realestatemanager/realestatemanager.class.conf.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/functions.php');
require_once ($mosConfig_absolute_path .
 '/components/com_realestatemanager/realestatemanager.main.categories.class.php');

$jinput = JFactory::getApplication()->input;

$GLOBALS['realestatemanager_configuration'] = $realestatemanager_configuration;
$GLOBALS['database'] = $database;
$GLOBALS['my'] = $my;
$GLOBALS['mosConfig_absolute_path'] = $mosConfig_absolute_path;
$table_prefix = $database->getPrefix(); 
$GLOBALS['table_prefix'] = $table_prefix; 
$GLOBALS['task'] = $task = $jinput->getCmd('task', '');
$GLOBALS['option'] = $option = mosGetParam($_REQUEST, 'option', 'com_realestatemanager');

global $mosConfig_lang;

$cls_path = $mosConfig_absolute_path . "/components/com_realestatemanager/realestatemanager.class.php";
require_once ($cls_path);
if (version_compare(JVERSION, "3.3.0", "lt")) {
    require_once $mosConfig_absolute_path . "/administrator/components/com_realestatemanager/language.php";
}
$cid = mosGetParam($_REQUEST, 'cid', array(0),"ARRAY");

$section = mosGetParam($_REQUEST, 'section', 'courses');

//$realestatemanager_configuration['debug'] = 1 ;
if ($realestatemanager_configuration['debug'] == '1' && $task == "update_package") {
    echo "Task: " . $task . "<br />";
    echo "_REQUEST: " ;print_r($_REQUEST);
    echo "_POST: " ;print_r($_POST);
    echo "<hr /><br />"; exit ;
}

// print_r($task);exit;

if (version_compare(JVERSION, "3.0.0", "ge"))
    require_once ($mosConfig_absolute_path .
     "/administrator/components/com_realestatemanager/toolbar.realestatemanager.php");
if (isset($section) && $section == 'categories') {
    switch ($task) {
        case "saveCategoryOrder":
            // $jinput = JFactory::getApplication()->input;
            $order = $jinput->get('order', array(0),"ARRAY");

            sortCategories($cid, $order, $option);
            break;

        case "edit" :
            editCategory($option, $cid[0]);
            break;
        case "add":
            editCategory($option, 0);
            break;
        case "cancel":
            cancelCategory();
            break;
        case "save":
        case 'apply':
            saveCategory();
            break;
        case "remove":
            removeCategories($option, $cid);
            break;
        case "publish":
            publishCategories("com_realestatemanager", $id, $cid, 1);
            break;
        case "unpublish":
            publishCategories("com_realestatemanager", $id, $cid, 0);
            break;
        case "orderup":
            orderCategory($cid[0], -1);
            break;
        case "orderdown":
            orderCategory($cid[0], 1);
            break;
        case "accesspublic":
            accessCategory($cid[0], 0);
            break;
        case "accessregistered":
            accessCategory($cid[0], 1);
            break;
        case "accessspecial":
            accessCategory($cid[0], 2);
            break;
        case "show":
        default :
            showCategories();
    }
} elseif ($section == 'featured_manager') {
    switch ($task) {
        case "edit" :
    //        editFeaturedManager($option, $cid[0]);
                echo "<script> alert('". _REALESTATE_MANAGER_EDIT_CONSTANT.": ".
                    "_REALESTATE_MANAGER_FEATURE".$cid[0]."'); window.history.go(-1);</script>\n";
                exit;
            break;

        case "add":
            editFeaturedManager($option, 0);
            break;

        case "cancel":
            cancelFeaturedManager();
            break;

        case "save":
            saveFeaturedManager();
            break;

        case "remove":
            removeFeaturedManager($option, $cid);
            break;

        case "publish":
            publishFeaturedManager("com_realestatemanager", $id, $cid, 1);
            break;

        case "unpublish":
            publishFeaturedManager("com_realestatemanager", $id, $cid, 0);
            break;
        case "addFeature":
            save_featured_category($option);
            showFeaturedManager($option);
            break;
        default:
            showFeaturedManager($option);
            break;
    }
} elseif ($section == 'language_manager') {
    switch ($task) {
        case "edit":
            editLanguageManager($option, $cid[0]);
            break;

        case "cancel":
            cancelLanguageManager();
            break;

        case "save":
            saveLanguageManager();
            break;

        default:
            showLanguageManager($option);
            break;
    }
} else {
    switch ($task) {

        case 'getUserData':

        // $jinput = JFactory::getApplication()->input;
        $userId = $jinput->getCmd('userId', false);

        //$user = JFactory::getUser($userId);
        $user = new JUser($userId);        
        $userData = array();
        $userData['name'] = $user->username;
        $userData['email'] = $user->email;

        echo json_encode($userData);
        // return;

        break;

        case "saveHouseOrder":
            $order = mosGetParam($_REQUEST, 'order', array(0),"ARRAY");
            sortHouses($cid, $order, $option);
        break;
        case "deleteOrder": 
            deleteOrder();
            break;
        case "updateOrderStatus":
            updateOrderStatus();
            break;
        case "orders":
            orders($option);
            break;

        case "categories":
            echo "now work $section=='categories , this part not work";
            exit;

        case "add":
            editHouse($option, 0);
            break;

        case "edit":
            editHouse($option, array_pop($cid));
            break;

        case "ajax_rent_price":

            // $get_tmp = protectInjectionWithoutQuote('get');
            $get_tmp = $jinput->get->getArray(array());

            if (isset ($get_tmp["cid"]) AND
            isset ($get_tmp["rent_from"]) AND
            isset($get_tmp["rent_until"]) AND
            isset($get_tmp["special_price"])) {
                $cid_ajax_rent = $get_tmp["cid"];
                $rent_from = $get_tmp["rent_from"];
                $rent_until = $get_tmp["rent_until"];
                $special_price = $get_tmp["special_price"];
                $currency_spacial_price = $get_tmp["currency_spacial_price"];
                if(isset($get_tmp["comment_price"]))
                    $comment_price = $get_tmp["comment_price"];
                else
                    $comment_price = '';
            }

            rentPrice($cid_ajax_rent,$rent_from,$rent_until,$special_price,
              $comment_price,$currency_spacial_price);
            break;

        case "clon_rem":
            clonHouse($cid,$option);
            break;

        case "apply":
        case "save":
            saveHouse($option, $task);
            break;

        case "remove":
            removeHouses($cid, $option);
            break;

        case "publish":
            publishHouses($cid, 1, $option);
            break;

        case "unpublish":
            publishHouses($cid, 0, $option);
            break;

        case "approve":
            approveHouses($cid, 1, $option);
            break;

        case "unapprove":
            approveHouses($cid, 0, $option);
            break;

        case "cancel":
            cancelHouse($option);
            break;

        case "houseorderdown":
            orderHouses($cid[0], 1, $option);
            break;

        case "houseorderup":
            orderHouses($cid[0], -1, $option);
            break;

        case "show_import_export":
            importExportHouses($option);
            break;

        case "import":
            import($option);
            break;

        case "export":
            mosRealEstateManagerImportExport::exportHouses($option);
            break;

//***************   begin for manage reviews   ***********************/

        case "publish_manage_review":
            publish_manage_review($cid[0], 1, $option);
            break;

        case "unpublish_manage_review":
            publish_manage_review($cid[0], 0, $option);
            break;

        case "delete_manage_review":
            delete_manage_review($option, $cid);
            manage_review_s($option, "");
            break;

        case "edit_manage_review":
            edit_manage_review($option, $cid);
            break;

        case "update_edit_manage_review":
            $title = mosGetParam($_POST, 'title');
            $comment = mosGetParam($_POST, 'comment');
            $rating = mosGetParam($_POST, 'rating');
            $house_id = mosGetParam($_POST, 'house_id');
            $review_id = mosGetParam($_POST, 'review_id');

            update_review($title, $comment, $rating, $review_id);
            manage_review_s($option, "");
            break;

//***************   end for manage reviews   *************************/

        case "config":
            configure($option);
            break;

        case "config_save":

            // $jinput = JFactory::getApplication()->input;

            configure_save_frontend($option);
            configure_save_backend($option);
            configure($option);
            break;

        case "rent":

            if (mosGetParam($_POST, 'save') == 1)
                saveRent($option, $cid, '',false);
            else
                rent($option, $cid);
            break;

        case "rent_history":
            rent_history($option, $cid);
            break;

        case "users_rent_history":
            users_rent_history($option, $cid);
            break;

        case "rent_requests":
            rent_requests($option, $cid);
            break;

        case "accept_rent_requests":
            accept_rent_requests($option, $cid);
            break;

        case "decline_rent_requests":
            decline_rent_requests($option, $cid);
            break;

        case "property_requests":
            property_requests($option);
            break;

        case "accept_property_requests":
            accept_property_requests($option, $cid);
            break;

        case "decline_property_requests":
            decline_property_requests($option, $cid);
            break;


        case "buying_requests":
            buying_requests($option);
            break;

        case "accept_buying_requests":
            accept_buying_requests($option, $cid);
            break;

        case "decline_buying_requests":
            decline_buying_requests($option, $cid);
            break;

        case "about":
            HTML_realestatemanager::about();
            break;

        case "show_info":
            showInfo($option, $cid);
            break;

        case "rent_return":
            if (mosGetParam($_POST, 'save') == 1)
                saveRent_return($option, $cid,false); else
                rent_return($option, $cid);
            break;

        case "edit_rent":
            if (mosGetParam($_POST, 'save') == 1) {
                if (count($cid) > 1) {
                    echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_ONE_ITEM_ALERT .
                     "'); window.history.go(-1); </script>\n";
                    exit;
                }
                saveRent($option, $cid, "edit_rent",false);
            } else
                edit_rent($option, $cid);
            break;

        case "delete_review":
            $ids = explode(',', $cid[0]);
            delete_review($option, $ids[1]);
            editHouse($option, $ids[0]);
            break;

        case "edit_review":
            $ids = explode(',', $cid[0]);
            edit_review($option, $ids[1], $ids[0]);
            break;

        case "update_review":
            $title = mosGetParam($_POST, 'title');
            $comment = mosGetParam($_POST, 'comment');
            $rating = mosGetParam($_POST, 'rating');
            $house_id = mosGetParam($_POST, 'house_id');
            $review_id = mosGetParam($_POST, 'review_id');
            update_review($title, $comment, $rating, $review_id);
            editHouse($option, $house_id);
            break;

        case "cancel_review_edit":
            $house_id = mosGetParam($_POST, 'house_id');
            editHouse($option, $house_id);
            break;

        case "checkFile":
            rem_checkFile();
        break;
        // case "update_map":
        //     updateMap($option);
        // break;


        default:
            showHouses($option);
            break;
    }
} //else


/**
 * HTML Class
 * Utility class for all HTML drawing classes
 * @desc class General HTML creation class. We use it for back/front ends.
 */
class HTML {

    // TODO::merge categoryList and categoryParentList
    // add filter option ?
//     function categoryList($id, $action, $options = array()){
//         $list = CAT_Utils::categoryArray();
//         // assemble menu items to the array
//         foreach ($list as $item) {
//             $options[] = mosHTML::makeOption($item->id, $item->treename);
//         }
//         $parent = mosHTML::selectList($options, 'catid', 'id="catid" class="inputbox"
// size="1" onchange="' . $action . '"', 'value', 'text', $id);
//         return $parent;
//     }


    static function categoryParentList($id, $action, $options = array()) {
        global $database;
        $list = CAT_Utils_categoryArray();
        $cat = new mainRealEstateCategories($database); 
        $cat->load($id);

        $this_treename = '';
        $childs_ids = Array();
        foreach ($list as $item) {
            if ($item->id == $cat->id || array_key_exists($item->parent_id, $childs_ids))
                $childs_ids[$item->id] = $item->id;
        }

        foreach ($list as $item) {
            if ($this_treename) {
                if ($item->id != $cat->id
                        && strpos($item->treename, $this_treename) === false
                        && array_key_exists($item->id, $childs_ids) === false) {
                    $options[] = mosHTML::makeOption($item->id, $item->treename);
                }
            } else {
                if ($item->id != $cat->id) {
                    $options[] = mosHTML::makeOption($item->id, $item->treename);
                } else {
                    $this_treename = "$item->treename/";
                }
            }
        }

        $parent = null;
        $parent = mosHTML::selectList($options, 'parent_id', 'class="inputbox" size="1"',
         'value', 'text', $cat->parent_id);

        return $parent;
    }

    static function imageList($name, &$active, $javascript = null, $directory = null) {
        global $mosConfig_absolute_path;
        if (!$javascript) {
            $javascript = "onchange=\"javascript:if (document.adminForm." . $name .
                    ".options[selectedIndex].value!='') {document.imagelib.src='../images/stories/' + document.adminForm."
                    . $name . ".options[selectedIndex].value} else {document.imagelib.src='../components/com_realestatemanager/images/no-img_eng.gif'}\"";
        }
        if (!$directory) {
            $directory = '/images/stories';
        }

        if (!file_exists($mosConfig_absolute_path . $directory)) {
            @mkdir($mosConfig_absolute_path . $directory, 0777) or
             die("Error of directory creating: [" . $mosConfig_absolute_path . $directory . "] ");
        }

        $imageFiles = mosReadDirectory($mosConfig_absolute_path . $directory);
        $images = array(mosHTML::makeOption('', _A_SELECT_IMAGE));


        foreach ($imageFiles as $file) {
            if (preg_match("/bmp|gif|jpeg|jpg|png/i", $file)) {
                $images[] = mosHTML::makeOption($file);
            }
        }
        $images = mosHTML::selectList($images, $name, 'id="' . $name .
         '" class="inputbox" size="1" ' . $javascript, 'value', 'text', $active);

        return $images;
    }

}


function getLocation() {
var_dump($_POST); exit();

}


function houseLibraryTreeRecurse($id, $indent, $list, &$children, $maxlevel = 9999, $level = 1, $type = 1, $parents_list = '') {
    if (@$children[$id] && $level <= $maxlevel) {
        $parent_id = $id;
        foreach ($children[$id] as $v) {
            $id = $v->id;
            if ($type) {
                $pre = 'L ';
                $spacer = '.      ';
                $parent_item = $parent_id;
            } else {
                $pre = '- ';
                $spacer = '  ';
            }
            if ($v->parent == 0) {
                $txt = $v->name;
            } else {
                $txt = $pre . $v->name;
            }
            $pt = $v->parent;
            $list[$id] = $v;
            $list[$id]->level = $level;
            $list[$id]->parents_list = $parents_list;
            $list[$id]->treename = "$indent$txt";
            $list[$id]->children = (isset($children[$id]) && is_array($children[$id])) ? count(@$children[$id]) : 0;
            $list[$id]->all_fields_in_list = count(@$children[$parent_id]);
            $list = houseLibraryTreeRecurse($id, $indent . $spacer, $list,
             $children, $maxlevel, $level + 1, $type, $parents_list." ".$parent_item);
        }
    }
    return $list;
}



function showCategories() {
    global $database, $my, $acl, $option, $menutype, $mainframe, $mosConfig_list_limit;
    $mainframe = JFactory::getApplication();

    $groups = get_group_children_rem();

    $section = "com_realestatemanager";
    $sectionid = $mainframe->getUserStateFromRequest("sectionid{$section}{$section}", 'sectionid', 0);
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$section}limitstart", 'limitstart', 0);
    $levellimit = $mainframe->getUserStateFromRequest("view{$option}limit$menutype", 'levellimit', 10);

    // Abort an user if he edit a categories more then 2 hours (7200 sec)

    // Old code was under $query:
    /*
    if (version_compare(JVERSION, "3.0.0", "lt"))
        $curdate = strtotime(JFactory::getDate()->toMySQL());
    else
        $curdate = strtotime(JFactory::getDate()->toSQL());
    foreach ($rows as $row) {
        if( !isset($row->checked_out_time) ) continue ;
        $check = strtotime($row->checked_out_time);
        $remain = 7200 - ($curdate - $check);
        if (($remain <= 0) && ($row->checked_out != 0)) {
            $item = new mainRealEstateCategories($database);
            $item->checkin($row->id);
        }
    }
    */

    // New code:
    $user_checked_out_categories = " UPDATE #__rem_main_categories SET checked_out=0, checked_out_time='0000-00-00 00:00:00'
        WHERE `checked_out_time` > 0 AND ( TIME_TO_SEC('" . date('Y-m-d H:i:s') . "') - TIME_TO_SEC(`checked_out_time`) ) >= 7200;";
    $database->setQuery($user_checked_out_categories);
    $database->execute();

    $query = "SELECT  c.*, c.checked_out as checked_out_contact_category, "
            . " c.parent_id as parent, u.name AS editor, c.params, COUNT(hc.id) AS cc"
            . "\n FROM #__rem_main_categories AS c"
            . "\n LEFT JOIN #__rem_categories AS hc ON hc.idcat=c.id"
            . "\n LEFT JOIN #__users AS u ON u.id = c.checked_out"
            . "\n WHERE c.section='$section'"
            . "\n GROUP BY c.id"
            . "\n ORDER BY parent DESC, ordering";

    $database->setQuery($query);
    $rows = $database->loadObjectList();


    foreach ($rows as $k => $v) {
        $rows[$k]->ncourses = 0;
        foreach ($rows as $k1 => $v1)
            if ($v->id == $v1->parent)
                $rows[$k]->cc +=$v1->cc;
        ($rows[$k]->cc == 0) ? "-" : "<a href=\"?option=com_realestatemanager&section=house&catid="
         . $v->id . "\">" . ($v->cc) . "</a>"; 
        $curgroup = array();
        $ss = explode(',', $v->params);
        foreach ($ss as $s) {
            if ($s == '')
                $s = '-2';
            $curgroup[] = $groups[$s];
        }
        $rows[$k]->groups = implode(', ', $curgroup);
    }


    // establish the hierarchy of the categories
    $children = array();
    // first pass - collect children
    foreach ($rows as $v) {
        $pt = $v->parent;
        $list = @$children[$pt] ? $children[$pt] : array();
        array_push($list, $v);
        $children[$pt] = $list;
    }
    // second pass - get an indent list of the items
    $list = houseLibraryTreeRecurse(0, '', array(), $children, max(0, $levellimit - 1));
    $total = count($list);

    $pageNav = new JPagination($total, $limitstart, $limit); 

    $levellist = mosHTML::integerSelectList(1, 20, 1,
     'levellimit', 'size="1" onchange="document.adminForm.submit();"', $levellimit);
    // slice out elements based on limits
    $list = array_slice($list, $pageNav->limitstart, $pageNav->limit);

    $count = count($list);
    $javascript = 'onchange="document.adminForm.submit();"';
    $lists['sectionid'] =
     version_compare(JVERSION, '3.0', 'ge') ? NUll : mosAdminMenus::SelectSection(
     'sectionid', $sectionid, $javascript);
    HTML_Categories::show($list, $my->id, $pageNav, $lists, 'other');
}

    function createAssociateArray($row, $database){
        $associateArray = array();
        if($row->id){
            $query = "SELECT lang_code FROM `#__languages` WHERE 1";
            $database->setQuery($query);
            $allLanguages =  $database->loadColumn();

            $query = "SELECT id,language,title FROM `#__rem_main_categories` WHERE 1";
            $database->setQuery($query);
            $allInCategories =  $database->loadObjectlist();

            $query = "select associate_category from #__rem_main_categories where id =".$row->id;
            $database->setQuery($query);
            $categoryAssociateCategory =  $database->loadResult();

            if(!empty($categoryAssociateCategory)){
                $categoryAssociateCategory = unserialize($categoryAssociateCategory);
            }else{
                $categoryAssociateCategory = array();
            }

            foreach ($allLanguages as &$oneLang) {
                $associate_category = array();
                $associate_category[] = mosHtml::makeOption(0, 'select');
                $i = 0;

                foreach($allInCategories as &$oneCat){
                    if($oneLang == $oneCat->language && $oneCat->id != $row->id){
                        $associate_category[] = mosHtml::makeOption(($oneCat->id), $oneCat->title);
                    }
                }

                if($row->language != $oneLang){
                    $associate_category_list = mosHTML::selectList($associate_category,
                     'language_associate_category', 'class="inputbox" size="1"', 'value', 'text', "");
                }else{
                    $associate_category_list = null;
                }

                $associateArray[$oneLang]['list'] = $associate_category_list;

                if(isset($categoryAssociateCategory[$oneLang])){
                    $associateArray[$oneLang]['assocId'] = $categoryAssociateCategory[$oneLang];
                }else{
                    $associateArray[$oneLang]['assocId'] = 0;
                }
            }
        }
        return $associateArray;
    }

function editCategory($section = '', $uid = 0) {
    global $database, $my, $acl;
    global $mosConfig_absolute_path, $mosConfig_live_site, $realestatemanager_configuration, $os_rem_state;

   $type = mosGetParam($_REQUEST, 'type', '');
    $redirect = mosGetParam($_POST, 'section', '');
    ;

    $row = new mainRealEstateCategories($database);

    // load the row from the db table
    $row->load($uid);
    // fail if checked out not by 'me'
    if ($row->checked_out && $row->checked_out <> $my->id) {
        mosRedirect('index.php?option=com_realestatemanager&task=categories', 'The category ' .
         $row->title . ' is currently being edited by another administrator');
    }

    if ($uid) {
        // existing record
        $row->checkout($my->id);
        // code for Link Menu
    } else {
        // new record
        $row->section = $section;
        $row->published = 1;
    }

    $associateArray = createAssociateArray($row, $database);

    // build the select list for the image positions
    $active = ($row->image_position ? $row->image_position : 'left');
    $lists['image_position'] = version_compare(JVERSION, '3.0', 'ge')
      ? NUll : mosAdminMenus::Positions('image_position', $active, null, 0, 0);
    // Imagelist
    $lists['image'] = HTML::imageList('image', $row->image);
    // build the html select list for the group access
    $lists['access'] = version_compare(JVERSION, '3.0', 'ge') ? NUll : mosAdminMenus::Access($row);
    // build the html radio buttons for published
    $lists['published'] = mosHTML::yesnoRadioList('published', 'class="inputbox"', $row->published);

    $options = array();
    $options[] = mosHTML::makeOption('0', _A_SELECT_TOP);
    $lists['parent'] = HTML::categoryParentList($row->id, "", $options);
    //***********access category
    $gtree = get_group_children_tree_rem();

    $f = array();
    if ($row->params == null || trim($row->params) == '') $row->params = '-2';
    $s = explode(',', $row->params);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['category']['registrationlevel'] = mosHTML::selectList($gtree,
     'category_registrationlevel[]', 'size="" multiple="multiple"', 'value', 'text', $f);
    //********end access category

    $query = "SELECT lang_code, title FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();

    $languages_row[] = mosHTML::makeOption('*', 'All');
    foreach ($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
    }

    $lists['languages'] = mosHTML::selectList($languages_row, 'language',
     'class="inputbox" size="1"', 'value', 'text', $row->language);

    // $params2 = unserialize($row->params2);

    // if (empty($params2)) {
    //     $params2 = new stdClass();
    //     $params2->alone_category = '';
    //     $params2->view_house = '';
    // }

    if ( $row->id ) {
        $registry = new JRegistry($row->metadata); 
        $metadata = $registry->toArray() ;
        $row->metadata = array() ;

        $row->metadata['meta_title'] = 
            (isset($metadata['meta_title']) )?($metadata['meta_title']):("");
        $row->metadata['meta_keywords'] = 
            (isset($metadata['meta_keywords']) )?($metadata['meta_keywords']):("");
        $row->metadata['meta_description'] = 
            (isset($metadata['meta_description']) )?($metadata['meta_description']):("");
        $row->metadata['meta_robots'] = 
            (isset($metadata['meta_robots']) )?($metadata['meta_robots']):("");
    }else{
        $row->metadata = array() ;
        $row->metadata['meta_title']="";
        $row->metadata['meta_keywords']="";
        $row->metadata['meta_description']="";
        $row->metadata['meta_robots']="";
    }

    $meta_robots = null;
    $robots[] = JHtml::_('select.option',"", _REALESTATE_MANAGER_ROBOTS_USE_GLOBAL);
    $robots[] = JHtml::_('select.option',"index, follow", _REALESTATE_MANAGER_ROBOTS_INDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, follow", _REALESTATE_MANAGER_ROBOTS_NOINDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"index, nofollow", _REALESTATE_MANAGER_ROBOTS_INDEX_NOFOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, nofollow", _REALESTATE_MANAGER_ROBOTS_NOINDEX_NOFOLLOW);

    $meta_robots = JHtml::_('select.genericlist',$robots, "metadata[meta_robots]", 'class="inputbox" size="1"', 
        'value', 'text',  $row->metadata['meta_robots'] );

    HTML_Categories::edit($row, $section, $lists, $redirect, $associateArray,$meta_robots);
}

function saveCategory() {
    global $database,$task,$option, $os_rem_state;

    $row = new mainRealEstateCategories($database);

    $post = JFactory::getApplication()->input->getArray($_POST);
    if( !isset($post['description']) || empty($post['description']) ) $post['description'] = "" ;

    saveAssociateCayegoriesREM($post, $database);

    $params2 = new stdClass();

    $post['params2'] = serialize($params2);

    if (!$row->bind($post)) {
        echo "<script> alert('" . addslashes($row->getError()) . "'); window.history.go(-1); </script>\n";
        exit;
    }
    
    $row->section = 'com_realestatemanager';
    $row->parent_id = $_REQUEST['parent_id'];
    //****set access level

    $row->params = implode(',', mosGetParam($_POST, 'category_registrationlevel', ''));

    //****end set access level

    if (!$row->check()) {
        echo "<script> alert('" . addslashes($row->getError()) . "'); window.history.go(-1); </script>\n";
        exit;
    }

    $registry = new JRegistry($row->metadata);     
    $row->metadata = $registry->toString() ;
    
    $row->publish_up = date_transform_rem($row->publish_up,"to");
    $row->publish_down = date_transform_rem($row->publish_down,"to");

    if (!$row->store()) {
        echo "<script> alert('" . addslashes($row->getError()) . "'); window.history.go(-1); </script>\n";
        exit;
    }
    $row->updateOrder();
    $row->checkin();


    switch ($task) {
        case 'apply':
            mosRedirect("index.php?option=" . $option . "&section=categories&task=edit&cid[]=" . $row->id);
            break;

        case 'save':
            mosRedirect("index.php?option=" . $option."&section=categories");
            break;
    }
}

 function is_exist_curr_and_subcategory_houses($catid) {
    global $database, $my;
    $query = "SELECT *, COUNT(a.id) AS numlinks FROM #__rem_main_categories AS cc"
            . "\n  JOIN #__rem_categories AS hc ON hc.idcat = cc.id"
            . "\n  JOIN #__rem_houses AS a ON a.id = hc.iditem"
            . "\n WHERE  section='com_realestatemanager' AND cc.id='$catid' "
            . "\n GROUP BY cc.id"
            . "\n ORDER BY cc.ordering";
    $database->setQuery($query);
    $categories = $database->loadObjectList();
    if (count($categories) != 0)
        return true;

    $query = "SELECT id "
            . "FROM #__rem_main_categories AS cc "
            . " WHERE section='com_realestatemanager' AND parent_id='$catid' ";
    $database->setQuery($query);
    $categories = $database->loadObjectList();

    if (count($categories) == 0)
        return false;

    foreach ($categories as $k) {
        if (is_exist_curr_and_subcategory_houses($k->id))
            return true;
    }
    return false;
}

function removeCategoriesFromDB($cid) {
    global $database, $my;
    $query = "SELECT id  "
            . " FROM #__rem_main_categories AS cc "
            . " WHERE section='com_realestatemanager' AND parent_id='$cid' ";
    $database->setQuery($query);
    $categories = $database->loadObjectList();

    if (count($categories) != 0) {
        //delete child
        foreach ($categories as $k) {
            removeCategoriesFromDB($k->id);
        }
    }
    $sql = "DELETE FROM #__rem_main_categories WHERE id = $cid ";
    $database->setQuery($sql);
    $database->execute();

    $category = new mainRealEstateCategories($database);
    $category->load((int)$cid);
    $category->updateOrder();
}

/**
 * Deletes one or more categories from the categories table
 *
 * @param string $ The name of the category section
 * @param array $ An array of unique category id numbers
 */
function removeCategories($section, $cid) {
    global $database;

    if (count($cid) < 1) {
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_ONE_CTEGORY_ALERT .
         "'); window.history.go(-1);</script>\n";
        exit;
    }

    foreach ($cid as $catid)
        removeCategoriesFromDB($catid);

    $msg = (count($cid) > 1 ? "Categories " : _CATEGORIES_NAME . " ") . _DELETED;
    mosRedirect('index.php?option=com_realestatemanager&section=categories&mosmsg=' . $msg);
}

/**
 * Publishes or Unpublishes one or more categories
 *
 * @param string $ The name of the category section
 * @param integer $ A unique category id (passed from an edit form)
 * @param array $ An array of unique category id numbers
 * @param integer $ 0 if unpublishing, 1 if publishing
 * @param string $ The name of the current user
 */
function publishCategories($extension, $categoryid = null, $cid = null, $publish = 1) {
    global $database, $my, $os_rem_state;

    if (!is_array($cid))
        $cid = array();
    if ($categoryid)
        $cid[] = $categoryid;

    if (count($cid) < 1) {
        $action = $publish ? _PUBLISH : _DML_UNPUBLISH;
        echo "<script> alert('" . _DML_SELECTCATTO . " $action'); window.history.go(-1);</script>\n";
        exit;
    }

    $cids = implode(',', $cid);

    $query = "UPDATE #__rem_main_categories SET published='$publish'"
            . "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))";
    $database->setQuery($query);
    $database->execute() ;

    if (count($cid) == 1) {
        $row = new mainRealEstateCategories($database);
        $row->checkin($cid[0]);
    }
    mosRedirect('index.php?option=com_realestatemanager&section=categories');
}

/**
 * Cancels an edit operation
 *
 * @param string $ The name of the category section
 * @param integer $ A unique category id
 */
function cancelCategory() {
    global $database;
    $row = new mainRealEstateCategories($database);
    $row->bind($_POST);
    $row->checkin();
    mosRedirect('index.php?option=com_realestatemanager&section=categories');
}

/**
 * Moves the order of a record
 *
 * @param integer $ The increment to reorder by
 */
function orderCategory($uid, $inc) {
    global $database;
    $row = new mainRealEstateCategories($database);

    $row->load($uid);
    if ($row->ordering == 1 && $inc == -1)
        mosRedirect('index.php?option=com_realestatemanager&section=categories');
    $new_order = $row->ordering + $inc;
    //change ordering - for other element
    $query = "UPDATE `#__rem_main_categories` SET ordering='" . ($row->ordering) . "'"
            . "\nWHERE parent_id = $row->parent_id and ordering=$new_order";

    $database->setQuery($query);
    $database->execute();
    //change ordering - for this element
    $query = "UPDATE `#__rem_main_categories` SET ordering='" . $new_order . "'"
            . "\nWHERE id = $uid";
    $database->setQuery($query);
    $database->execute();
    mosRedirect('index.php?option=com_realestatemanager&section=categories');
}

/**
 * changes the access level of a record
 *
 * @param integer $ The increment to reorder by
 */
function accessCategory($uid, $access) {
    global $database;
    $row = new mainRealEstateCategories($database);
    $row->load($uid);
    $row->access = $access;
    if (!$row->check())
        return $row->getError();
    if (!$row->store())
        return $row->getError();
    mosRedirect('index.php?option=com_realestatemanager&section=categories');
}

function update_review($title, $comment, $rating, $review_id) {
    global $database, $os_rem_state;

    $review = new mosRealEstateManager_review($database);
    $review->load($review_id);

    if (!$review->bind($_POST)) {
        echo "<script> alert('" . addslashes($review->getError()) . "'); window.history.go(-1); </script>\n";
        exit();
    }

    if (!$review->check()) {
        echo "<script> alert('" . addslashes($review->getError()) . "'); window.history.go(-1); </script>\n";
        exit();
    }

    if (!$review->store()) {
        echo "<script> alert('" . addslashes($review->getError()) . "'); window.history.go(-1); </script>\n";
        exit();
    }

    mosRedirect("index.php?option=com_realestatemanager&task=manage_review"); 
}

function edit_review($option, $review_id, $house_id) {
    global $database, $os_rem_state;

    $database->setQuery("SELECT * FROM #__rem_review WHERE id=" . $review_id . " ");
    $review = $database->loadObjectList();
    
    HTML_realestatemanager::edit_review($option, $house_id, $review);
}

/*
 * Function for delete coment
 * (comment for every house)
 * in database.
 */

function delete_review($option, $id) {
    global $database;
    //delete review where id =.. ;
    $database->setQuery("DELETE FROM #__rem_review WHERE #__rem_review.id=" . $id . ";");
    $database->execute();

    mosRedirect("index.php?option=com_realestatemanager&task=manage_review"); 

}

//********************************************************************************
//*******************   begin for manage reviews   *******************************
//********************************************************************************
function delete_manage_review($option, $id) {
    global $database;
    for ($i = 0; $i < count($id); $i++) {
        //delete review where id =.. ;
        $database->setQuery("DELETE FROM #__rem_review WHERE #__rem_review.id=" . $id[$i] . ";");
        $database->execute();
    }
    mosRedirect("index.php?option=com_realestatemanager&task=manage_review");    
}

function edit_manage_review($option, $review_id) {
    global $database, $os_rem_state;

    if (count($review_id) > 1) {
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_ONE_REVIEW_ALERT ."'); window.history.go(-1); </script>\n";
    } else {
        $database->setQuery("SELECT * FROM #__rem_review WHERE id=" . $review_id[0] . " ");
        $review = $database->loadObjectList();

        HTML_realestatemanager::edit_manage_review($option, $review);
    }
}

//*******************************************************************************
//**************************   end for manage reviews   *************************
//*******************************************************************************


function showInfo($option, $cid) {
    if (is_array($cid) && count($cid) > 0)
        $cid = $cid[0];
    echo "Test: " . $cid;
}

function decline_rent_requests($option, $cids) {
    global $database, $realestatemanager_configuration;
    $datas = array();
    foreach ($cids as $cid) {
        $rent_request = new mosRealEstateManager_rent_request($database);
        $rent_request->load($cid);
        $tmp = $rent_request->decline();
        if ($tmp != null) {
            echo "<script> alert('" . $tmp . "'); window.history.go(-1); </script>\n";
            exit();
        }
        foreach ($datas as $c => $data) {
            if ($rent_request->user_email == $data['email']) {
                $datas[$c]['ids'][] = $rent_request->fk_houseid;
                continue 2;
            }
        }
        $datas[] = array('email' => $rent_request->user_email,
         'name' => $rent_request->user_name, 'id' => $rent_request->fk_houseid);
    }
    if ($realestatemanager_configuration['rent_answer']) {

        sendMailRentRequest($datas, _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_DECLINED);
    }
    mosRedirect("index.php?option=$option&task=rent_requests");
}

function accept_rent_requests($option, $cids) {
    global $database, $realestatemanager_configuration, $os_rem_state;

    $datas = array();
    foreach ($cids as $cid) {

              $rent_request = new mosRealEstateManager_rent_request($database);
              $rent_request->load($cid);
              $tmp = $rent_request->accept();

              if ($tmp != null) {
                  echo "<script> alert('" . $tmp . "'); window.history.go(-1); </script>\n";
                  exit();
              }

              foreach ($datas as $c => $data) {
                  if ($rent_request->user_email == $data['email']) {
                      $datas[$c]['ids'][] = $rent_request->fk_houseid;
                      continue 2;
                  }
              }
              $datas[] = array('email' => $rent_request->user_email,
               'name' => $rent_request->user_name, 'id' => $rent_request->fk_houseid,
                'fk_userid' => $rent_request->fk_userid);
            }
    if ($realestatemanager_configuration['rent_answer']) {
        sendMailRentRequest($datas, _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_ACCEPTED);
    }
    mosRedirect("index.php?option=$option&task=rent_requests");
}

function sendMailRentRequest($datas, $answer) {
    global $database, $mosConfig_mailfrom, $realestatemanager_configuration;

    if (version_compare(JVERSION, "4.0.0", "ge")) {
        $app = JFactory::getApplication();
        $conf = $app->getConfig();
    } else {
        $conf = JFactory::getConfig(); 
    }

    foreach ($datas as $key => $data) {
        $mess = null;
        $zapros = "SELECT htitle FROM #__rem_houses WHERE id=" . $data['id'];
        $database->setQuery($zapros);
        $item = $database->loadResult();

        $database->setQuery("SELECT u.name AS ownername,u.email as owneremail
                          \nFROM #__users AS u
                          \nLEFT JOIN #__rem_houses AS rm ON rm.owner_id=u.id
                          \nWHERE rm.id=" . $data['id']);

        $ownerdata = $database->loadObjectList();
        $datas[$key]['title'] = $item;
        $message = _REALESTATE_MANAGER_EMAIL_NOTIFICATION_RENT_REQUEST_ANSWER;
        $message = str_replace("{title}", addslashes($datas[$key]['title']), $message);
        $message = str_replace("{answer}", addslashes($answer), $message);
        $message = str_replace("{username}", $datas[$key]['name'], $message);

        $oname = (isset($ownerdata[0]->ownername)) ? $ownerdata[0]->ownername : null;
        $oemail = (isset($ownerdata[0]->owneremail)) ? $ownerdata[0]->owneremail : null;

        if ($answer == _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_ACCEPTED) {
            $message = str_replace("{ownername}", addslashes($ownerdata[0]->ownername), $message);
            $message = str_replace("{owneremail}", $ownerdata[0]->owneremail, $message);
            $from_name = $oname;
        } else {
            $message = str_replace("{ownername}", '', $message);
            $message = str_replace("{owneremail}", '', $message);
            $from_name = null;
        }

        mosMail($mosConfig_mailfrom, $from_name, $data['email'],
         _REALESTATE_MANAGER_EMAIL_RENT_ANSWER_SUBJECT, $message, true);
    }
}



function accept_buying_requests($option, $cids) {
    global $database, $realestatemanager_configuration, $os_rem_state;

    foreach ($cids as $cid) {
        $buying_request = new mosRealEstateManager_buying_request($database);
        $buying_request->load($cid);
        $datas[] = array('name' => $buying_request->customer_name,
            'email' => $buying_request->customer_email,
            'id' => $buying_request->fk_houseid
        );
        $buying_request->delete($cid);
        if ($tmp != null) {
            echo "<script> alert('" . $tmp . "'); window.history.go(-1); </script>\n";
            exit();
        }
    }
    if ($realestatemanager_configuration['buy_answer']) {
        sendMailBuyingRequest($datas, _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_ACCEPTED);
    }
    mosRedirect("index.php?option=$option&task=buying_requests");
}

function accept_property_requests($option, $cids) {
    global $database, $realestatemanager_configuration, $os_rem_state;

    foreach ($cids as $cid) {
        $property_request = new mosRealEstateManager_property_request($database);
        $property_request->load($cid);
        $datas[] = array('name' => $property_request->customer_name,
            'email' => $property_request->customer_email,
            'id' => $property_request->fk_houseid
        );
        $property_request->delete($cid);
        if ($tmp != null) {
            echo "<script> alert('" . $tmp . "'); window.history.go(-1); </script>\n";
            exit();
        }
    }
    if ($realestatemanager_configuration['property_request_answer']) {
        send_mail_property_request($datas, _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_ACCEPTED);
    }
    mosRedirect("index.php?option=$option&task=property_requests");
}


function decline_buying_requests($option, $cids) {
    global $database, $realestatemanager_configuration;
    $datas = array();
    foreach ($cids as $cid) {
        $buying_request = new mosRealEstateManager_buying_request($database);
        $buying_request->load($cid);
        $datas[] = array('name' => $buying_request->customer_name,
            'email' => $buying_request->customer_email,
            'id' => $buying_request->fk_houseid
        );
        $tmp = $buying_request->decline();

        if ($tmp != null) {
            echo "<script> alert('" . $tmp . "'); window.history.go(-1); </script>\n";
            exit();
        }
    }

    if ($realestatemanager_configuration['buy_answer']) {
        sendMailBuyingRequest($datas, _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_DECLINED);
    }
    mosRedirect("index.php?option=$option&task=buying_requests");
}

function decline_property_requests($option, $cids) {
    global $database, $realestatemanager_configuration;
    $datas = array();
    foreach ($cids as $cid) {
        $property_request = new mosRealEstateManager_property_request($database);
        $property_request->load($cid);
        $datas[] = array('name' => $property_request->customer_name,
            'email' => $property_request->customer_email,
            'id' => $property_request->fk_houseid
        );
        $tmp = $property_request->decline();

        if ($tmp != null) {
            echo "<script> alert('" . $tmp . "'); window.history.go(-1); </script>\n";
            exit();
        }
    }

    if ($realestatemanager_configuration['property_request_answer']) {
        send_mail_property_request($datas, _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_DECLINED);
    }
    mosRedirect("index.php?option=$option&task=property_requests");
}

function sendMailBuyingRequest($datas, $answer) {
    global $database, $mosConfig_mailfrom, $realestatemanager_configuration;

    if (version_compare(JVERSION, "4.0.0", "ge")) {
        $app = JFactory::getApplication();
        $conf = $app->getConfig();
    } else {
        $conf = JFactory::getConfig(); 
    }


    foreach ($datas as $key => $data) {
        $mess = null;
        $zapros = "SELECT htitle FROM #__rem_houses WHERE id=" . $data['id'];
        $database->setQuery($zapros);
        $item = $database->loadResult();

        $database->setQuery("SELECT u.name AS ownername,u.email as owneremail
                          \nFROM #__users AS u
                          \nLEFT JOIN #__rem_houses AS rm ON rm.owner_id=u.id
                          \nWHERE rm.id=" . $data['id']);

        $ownerdata = $database->loadObjectList();
        $datas[$key]['title'] = $item;
        $message = _REALESTATE_MANAGER_EMAIL_NOTIFICATION_BUYING_REQUEST_ANSWER;
        $message = str_replace("{title}", addslashes($datas[$key]['title']), $message);
        $message = str_replace("{answer}", addslashes($answer), $message);
        $message = str_replace("{username}", $datas[$key]['name'], $message);

        $oname = (isset($ownerdata[0]->ownername)) ? $ownerdata[0]->ownername : null;
        $oemail = (isset($ownerdata[0]->owneremail)) ? $ownerdata[0]->owneremail : null;

        if ($answer == _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_ACCEPTED) {
            $message = str_replace("{ownername}", addslashes($ownerdata[0]->ownername), $message);
            $message = str_replace("{owneremail}", $ownerdata[0]->owneremail, $message);
            $from_name = $oname;
        } else {
            $message = str_replace("{ownername}", '', $message);
            $message = str_replace("{owneremail}", '', $message);
            $from_name = null;
        }

        mosMail($mosConfig_mailfrom, $from_name, $data['email'],
         _REALESTATE_MANAGER_EMAIL_RENT_ANSWER_SUBJECT, $message, true);
    }
}

function send_mail_property_request($datas, $answer) {
    global $database, $mosConfig_mailfrom, $realestatemanager_configuration;

    if (version_compare(JVERSION, "4.0.0", "ge")) {
        $app = JFactory::getApplication();
        $conf = $app->getConfig();
    } else {
        $conf = JFactory::getConfig(); 
    }

    foreach ($datas as $key => $data) {
        $mess = null;
        $zapros = "SELECT htitle FROM #__rem_houses WHERE id=" . $data['id'];
        $database->setQuery($zapros);
        $item = $database->loadResult();

        $database->setQuery("SELECT u.name AS ownername,u.email as owneremail
                          \nFROM #__users AS u
                          \nLEFT JOIN #__rem_houses AS rm ON rm.owner_id=u.id
                          \nWHERE rm.id=" . $data['id']);

        $ownerdata = $database->loadObjectList();
        $datas[$key]['title'] = $item;
        $message = _REALESTATE_MANAGER_EMAIL_NOTIFICATION_PROPERTY_REQUEST_ANSWER;
        $message = str_replace("{title}", addslashes($datas[$key]['title']), $message);
        $message = str_replace("{answer}", addslashes($answer), $message);
        $message = str_replace("{username}", $datas[$key]['name'], $message);

        $oname = (isset($ownerdata[0]->ownername)) ? $ownerdata[0]->ownername : null;
        $oemail = (isset($ownerdata[0]->owneremail)) ? $ownerdata[0]->owneremail : null;

        if ($answer == _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_ANSWER_ACCEPTED) {
            $message = str_replace("{ownername}", addslashes($ownerdata[0]->ownername), $message);
            $message = str_replace("{owneremail}", $ownerdata[0]->owneremail, $message);
            $from_name = $oname;
        } else {
            $message = str_replace("{ownername}", '', $message);
            $message = str_replace("{owneremail}", '', $message);
            $from_name = null;
        }

        mosMail($mosConfig_mailfrom, $from_name, $data['email'],
         _REALESTATE_MANAGER_EMAIL_RENT_ANSWER_SUBJECT, $message, true);
    }
}


function rent_requests($option, $cid) {

    global $database, $mainframe, $mosConfig_list_limit, $os_rem_state;

    $mainframe = JFactory::getApplication();

    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

    $database->setQuery("SELECT count(*) FROM #__rem_houses AS a" .
            " \nLEFT JOIN #__rem_rent_request AS l" .
            " \nON l.fk_houseid = a.id" .
            " \nWHERE l.status = 0");
    $total = $database->loadResult();

    $pageNav = new JPagination($total, $limitstart, $limit); 

    $database->setQuery("SELECT * FROM #__rem_houses AS a" .
            " \nLEFT JOIN #__rem_rent_request AS l" .
            " \nON l.fk_houseid = a.id" .
            " \nWHERE l.status = 0" .
            " \nORDER BY l.id DESC" .
            " \nLIMIT $pageNav->limitstart,$pageNav->limit;");
    $rent_requests = $database->loadObjectList();

    foreach ($rent_requests as $request) {
        if($request->associate_house){
            if($assoc_rem = getAssociateHouses($request->fk_houseid)){
                $database->setQuery("SELECT group_concat(distinct a.htitle) FROM #__rem_houses AS a" .
                  "\n LEFT JOIN #__rem_rent_request AS l ON l.fk_houseid = a.id" .
                  "\n WHERE a.id in ($assoc_rem) AND a.id != $request->fk_houseid");
                $request->title_assoc = $database->loadResult();
            }
        }
    }

    // print_r($rent_requests);exit;

    HTML_realestatemanager::showRequestRentHouses($option, $rent_requests, $pageNav);
}

function buying_requests($option) {

    global $database, $mainframe, $mosConfig_list_limit, $os_rem_state;

    $mainframe = JFactory::getApplication();

    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

    $database->setQuery("SELECT count(*) FROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_buying_request AS s" .
            "\nON s.fk_houseid = a.id" .
            "\nWHERE s.status = 0");
    $total = $database->loadResult();

    $pageNav = new JPagination($total, $limitstart, $limit); 

    $database->setQuery("SELECT * FROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_buying_request AS s" .
            "\nON s.fk_houseid = a.id" .
            "\nWHERE s.status = 0" .
            "\nORDER BY s.customer_name" .
            "\nLIMIT $pageNav->limitstart,$pageNav->limit;");
    $rent_requests = $database->loadObjectList();

    HTML_realestatemanager ::showRequestBuyingHouses($option, $rent_requests, $pageNav);
}


function property_requests($option) {

    global $database, $mainframe, $mosConfig_list_limit, $os_rem_state;

    $mainframe = JFactory::getApplication();

    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

    $database->setQuery("SELECT count(*) FROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_property_request AS s" .
            "\nON s.fk_houseid = a.id" .
            "\nWHERE s.status = 0");
    $total = $database->loadResult();

    $pageNav = new JPagination($total, $limitstart, $limit); 

    $database->setQuery("SELECT * FROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_property_request AS s" .
            "\nON s.fk_houseid = a.id" .
            "\nWHERE s.status = 0" .
            "\nORDER BY s.customer_name" .
            "\nLIMIT $pageNav->limitstart,$pageNav->limit;");
    $rent_requests = $database->loadObjectList();

    HTML_realestatemanager ::show_property_request_houses($option, $rent_requests, $pageNav);
}
/**
 * Compiles a list of records
 * @param database - A database connector object
 * select categories
 */
function showHouses($option) {
    global $database, $mainframe, $mosConfig_list_limit, $mosConfig_live_site;
    $mainframe = JFactory::getApplication();


    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    $catid = $mainframe->getUserStateFromRequest("catid{$option}", 'catid', '-1'); //old 0
    $language_owner = $mainframe->getUserStateFromRequest("language{$option}", 'language', '-1');
    $rent = $mainframe->getUserStateFromRequest("rent{$option}", 'rent', '-1'); //add nik
    $pub = $mainframe->getUserStateFromRequest("pub{$option}", 'pub', '-1'); //add nik
    $owner = $mainframe->getUserStateFromRequest("owner{$option}", 'owner', '-1');
    $search = $mainframe->getUserStateFromRequest("search{$option}", 'search', '');
    $search = addslashes($search);
    $search_list = $mainframe->getUserStateFromRequest("search_list{$option}", 'search_list', '-1');
    //$search = $database->getEscaped(trim(strtolower($search)));

    $where = array();

    if ($rent == "rent") {
        array_push($where, "a.fk_rentid <> 0");
    } else if ($rent == "not_rent") {
        array_push($where, "a.fk_rentid = 0");
    }
    if ($pub == "pub") {
        array_push($where, "a.published = 1");
    } else if ($pub == "not_pub") {
        array_push($where, "a.published = 0");
    }
    if ($owner != -1)
        array_push($where, "a.owner_id = '$owner'");
    if ($catid > 0) {
        array_push($where, "hc.idcat='$catid'");
    }
    if ($language_owner != '0' and $language_owner != '*'and $language_owner != '-1' )
    {
        array_push($where, "a.language='$language_owner'");
    }

    if($search_list != '-1'){
         array_push($where, "(LOWER($search_list) LIKE '%$search%')");
    }else{
        array_push($where, "(LOWER(a.htitle) LIKE '%$search%' " .
            " OR LOWER(a.description) LIKE '%$search%' " .
            " OR LOWER(a.houseid) LIKE '%$search%' " .
            " OR LOWER(a.hlocation) LIKE '%$search%' " .
            " OR LOWER(a.hcountry) LIKE '%$search%' " .
            " OR LOWER(a.hcity) LIKE '%$search%' " .
            " OR LOWER(a.hregion) LIKE '%$search%' " .
            " OR LOWER(a.hzipcode) LIKE '%$search%')");
    }
    // $database->setQuery("SELECT count(*) FROM #__rem_houses AS a" .
    //         "\nLEFT JOIN #__rem_categories AS hc ON a.id=hc.iditem" .
    //         "\nLEFT JOIN #__rem_rent AS l" .
    //         "\nON a.fk_rentid = l.id" .
    //         (count($where) ? "\nWHERE " . implode(' AND ', $where) : ""));
    $database->setQuery("SELECT count(distinct a.id ) FROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_categories AS hc ON a.id=hc.iditem" .
            (count($where) ? "\nWHERE " . implode(' AND ', $where) : ""));


    $total = $database->loadResult();

    $pageNav = new JPagination($total, $limitstart, $limit);

    // Abort an user if he edit a categories more then 2 hours (7200 sec)

    // Old code was under $selectstring:
    /*
    if (version_compare(JVERSION, "3.0.0", "lt"))
        $curdate = strtotime(JFactory::getDate()->toMySQL());
    else
        $curdate = strtotime(JFactory::getDate()->toSQL());
    foreach ($rows as $row) {
        if( !isset($row->checked_out_time) ) continue ;
        $check = strtotime($row->checked_out_time);
        $remain = 7200 - ($curdate - $check);
        if (($remain <= 0) && ($row->checked_out != 0)) {
            $item = new mosRealEstateManager($database);
            $item->checkin($row->id);
        }
    }
    */

    // New code:
    $user_checked_out_houses = " UPDATE #__rem_houses SET checked_out=0, checked_out_time='0000-00-00 00:00:00'
        WHERE `checked_out_time` > 0 AND ( TIME_TO_SEC('" . date('Y-m-d H:i:s') . "') - TIME_TO_SEC(`checked_out_time`) ) >= 7200;";
    $database->setQuery($user_checked_out_houses);
    $database->execute();    

    $selectstring = "SELECT a.*, GROUP_CONCAT(DISTINCT(cc.title) SEPARATOR ',') AS category,
            l.id as rentid, l.rent_from as rent_from, l.rent_return as rent_return,
            l.rent_until as rent_until, u.name AS editor, ue.name AS editor1" .
            "\nFROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_categories AS hc ON hc.iditem = a.id" .
            "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
            "\nLEFT JOIN #__rem_rent AS l ON l.fk_houseid = a.id  and l.rent_return is null " .
            "\nLEFT JOIN #__users AS u ON u.id = a.owner_id" .
            "\nLEFT JOIN #__users AS ue ON ue.id = a.checked_out" .
            (count($where) ? "\nWHERE " . implode(' AND ', $where) : "") .
            "\nGROUP BY a.id" .
            "\nORDER BY a.ordering " .
            "\nLIMIT $pageNav->limitstart,$pageNav->limit;";
    $database->setQuery($selectstring);
    $rows = $database->loadObjectList();


    //set ordering if = 0
    $query = "SELECT id FROM #__rem_houses WHERE ordering = '0'";
    $database->setQuery($query);
    $ids = $database->loadColumn();

    $query = "SELECT MAX(ordering) FROM #__rem_houses";
    $database->setQuery($query);
    $max_ordering = $database->loadResult();

    $max = $max_ordering;
    foreach ($ids as $id) {
        $max++;
        $query ="UPDATE #__rem_houses SET ordering = '".$max."' WHERE id = '".$id."'";
        $database->setQuery($query);
        $database->execute();
    }
    //set ordering if = 0


    // get list of categories
    /*
     * select list treeSelectList
     */
    $categories[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_LABEL_SELECT_CATEGORIES);
    $categories[] = mosHTML::makeOption('-1', _REALESTATE_MANAGER_LABEL_SELECT_ALL_CATEGORIES);
//*************   begin add for sub category in select in manager houses   *************
    $options = $categories;
    $id = 0; //$categories_array;
    $list = CAT_Utils_categoryArray();

    $cat = new mainRealEstateCategories($database);
    $cat->load($id);

    $this_treename = '';
    foreach ($list as $item) {
        if ($this_treename) {
            if ($item->id != $cat->id && strpos($item->treename, $this_treename) === false) {
                $options[] = mosHTML::makeOption($item->id, $item->treename);
            }
        } else {
            if ($item->id != $cat->id) {
                $options[] = mosHTML::makeOption($item->id, $item->treename);
            } else {
                $this_treename = "$item->treename/";
            }
        }
    }

    $clist = mosHTML::selectList($options, 'catid',
     'class="inputbox" size="1" onchange="document.adminForm.submit();"',
      'value', 'text', $catid); //new nik edit
//*****  end add for sub category in select in manager houses   **********

    $searchmenu[] = mosHTML::makeOption('-1', _REALESTATE_MANAGER_LABEL_SELECT_BY_ALL);
    $searchmenu[] = mosHTML::makeOption('a.htitle', _REALESTATE_MANAGER_LABEL_SELECT_BY_TITLE);
    $searchmenu[] = mosHTML::makeOption('a.description', _REALESTATE_MANAGER_LABEL_SELECT_BY_DESC);
    $searchmenu[] = mosHTML::makeOption('a.houseid', _REALESTATE_MANAGER_LABEL_SELECT_BY_HOUSEID);
    $searchmenu[] = mosHTML::makeOption('a.hlocation', _REALESTATE_MANAGER_LABEL_SELECT_BY_LOCATION);
    $searchmenu[] = mosHTML::makeOption('a.hcountry', _REALESTATE_MANAGER_LABEL_SELECT_BY_COUNTRY);
    $searchmenu[] = mosHTML::makeOption('a.hcity', _REALESTATE_MANAGER_LABEL_SELECT_BY_CITY);
    $searchmenu[] = mosHTML::makeOption('a.hregion', _REALESTATE_MANAGER_LABEL_SELECT_BY_REGION);
    $searchmenu[] = mosHTML::makeOption('a.hzipcode', _REALESTATE_MANAGER_LABEL_SELECT_BY_ZIPCODE);

    $search_list = mosHTML::selectList($searchmenu, 'search_list',
     'class="inputbox" size="1" onchange="document.adminForm.submit();"',
      'value', 'text', $search_list);

    $rentmenu[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_LABEL_SELECT_TO_RENT);
    $rentmenu[] = mosHTML::makeOption('-1', _REALESTATE_MANAGER_LABEL_SELECT_ALL_RENT);
    $rentmenu[] = mosHTML::makeOption('not_rent', _REALESTATE_MANAGER_LABEL_SELECT_NOT_RENT);
    $rentmenu[] = mosHTML::makeOption('rent', _REALESTATE_MANAGER_LABEL_SELECT_RENT);

    $rentlist = mosHTML::selectList($rentmenu, 'rent',
     'class="inputbox" size="1" onchange="document.adminForm.submit();"',
      'value', 'text', $rent);

    $pubmenu[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_LABEL_SELECT_TO_PUBLIC);
    $pubmenu[] = mosHTML::makeOption('-1', _REALESTATE_MANAGER_LABEL_SELECT_ALL_PUBLIC);
    $pubmenu[] = mosHTML::makeOption('not_pub', _REALESTATE_MANAGER_LABEL_SELECT_NOT_PUBLIC);
    $pubmenu[] = mosHTML::makeOption('pub', _REALESTATE_MANAGER_LABEL_SELECT_PUBLIC);

    $publist = mosHTML::selectList($pubmenu, 'pub',
     'class="inputbox" size="1" onchange="document.adminForm.submit();"',
      'value', 'text', $pub);

    $ownermenu[] = mosHTML::makeOption('-1', _REALESTATE_MANAGER_LABEL_SELECT_ALL_USERS);
    $selectstring = "SELECT id,name FROM  #__users GROUP BY name ORDER BY id ";

    $database->setQuery($selectstring);
    $owner_list = $database->loadObjectList();

    $i = 2;
    foreach ($owner_list as $item) {
        $ownermenu[$i] = mosHTML::makeOption($item->id, $item->name);
        $i++;
    }

    $ownerlist = mosHTML::selectList($ownermenu,
     'owner', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
      'value', 'text', $owner);

    $language = array();
    $selectlanguage = "SELECT `language` FROM `#__rem_houses` WHERE language <> '*' GROUP BY language ";

    $database->setQuery($selectlanguage);
    $languages = $database->loadObjectList();
    $language_list[]= mosHTML::makeOption('0', _REALESTATE_MANAGER_LABEL_SELECT_LANGUAGE);

    foreach ($languages as $language) {
        $language_list[] = mosHTML::makeOption($language->language, $language->language);

    }
    $language = mosHTML::selectList($language_list, 'language',
     'class="inputbox input-medium" size="1" onchange="document.adminForm.submit();"',
      'value', 'text', $language_owner);


    HTML_realestatemanager::showHouses($option, $rows, $clist,$language,
     $rentlist, $publist, $ownerlist, $search, $search_list, $pageNav);
}

/**
 * Compiles information to add or edit houses
 * @param integer cid The unique id of the record to edit (0 if new)
 * @param array option the current options
 */
function rentPrice($cid,$rent_from,$rent_until,$special_price,$comment_price,
  $currency_spacial_price){
   rentPriceREM($cid,$rent_from,$rent_until,$special_price,$comment_price,
     $currency_spacial_price);
}


function clonHouse($cid, $option) {
    global $database, $my, $mosConfig_live_site, $realestatemanager_configuration, $os_rem_state;

    if(count($cid) > 1 || $cid[0] == '0'){
      echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_CLON_ALERT .
        "'); window.history.go(-1); </script>\n";
              exit();
    }

    $cid = $cid[0];

    $house_true = new mosRealEstateManager($database);
    // load the row from the db table
    $house_true->load(intval($cid));

    $house_true->setCatIds();
    $house = clone $house_true;
    $house->id = null;
    $house->owner_id = null;

     //get ordering value
    $query = "SELECT MIN(ordering) FROM #__rem_houses WHERE ordering != '0'";
    $database->setQuery($query);
    $min_ordering = $database->loadResult();
    if($min_ordering){
        if($min_ordering == 1){
            $min_ordering = $min_ordering - 2;
        }else{
            $min_ordering = $min_ordering - 1;
        }
    }else{
        $min_ordering = 1;
    }
    $house->ordering = $min_ordering;

    $house->store();
    $house->id_true = $house_true->id;
    $house->saveCatIds($house->catid);

    $numeric_houseids = Array();

    // get list of categories
    $categories = array();

    $query = "SELECT  id ,name, parent_id as parent"
            . "\n FROM #__rem_main_categories"
            . "\n WHERE section='com_realestatemanager'"
            . "\n AND published > 0"
            . "\n ORDER BY parent_id, ordering";

    $database->setQuery($query);
    $rows = $database->loadObjectList();

    // establish the hierarchy of the categories
    $children = array();
    // first pass - collect children
    foreach ($rows as $v) {
        $pt = $v->parent;
        $list = @$children[$pt] ? $children[$pt] : array();
        array_push($list, $v);
        $children[$pt] = $list;
    }

    // second pass - get an indent list of the items
    $list = houseLibraryTreeRecurse(0, '', array(), $children);

    foreach ($list as $i => $item) {
        $item->text = $item->treename;
        $item->value = $item->id;
        $list[$i] = $item;
    }
    $categories = array_merge($categories, $list);

    //if (count($categories) <= 1) {
    //mosRedirect("index.php?option=com_realestatemanager&section=categories",
    //_REALESTATE_MANAGER_ADMIN_IMPEXP_ADD);
    //}
    if (isset($house->id) && trim($house->id) != "")
        $house->setCatIds();
    $clist = mosHTML::selectList($categories, 'catid[]',
     'class="inputbox" multiple', 'value', 'text', $house->catid);

    //get Rating
    $retVal2 = mosRealEstateManagerOthers::getRatingArray();
    $rating = null;
    for ($i = 0, $n = count($retVal2); $i < $n; $i++) {
        $help = $retVal2[$i];
        $rating[] = mosHTML::makeOption($help[0], $help[1]);
    }

    //delete ehouse?
    if( isset($house->edok_link) ) $help = str_replace($mosConfig_live_site, "", $house->edok_link);
    else $help = 1 ;
    $delete_ehouse_yesno[] = mosHTML::makeOption($help, _REALESTATE_MANAGER_YES);
    $delete_ehouse_yesno[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_NO);
    $delete_edoc = mosHTML::RadioList($delete_ehouse_yesno, 'delete_edoc',
       'class="inputbox"', '0', 'value', 'text');

    // fail if checked out not by 'me'
    if ($house->checked_out && $house->checked_out <> $my->id) {
        mosRedirect("index.php?option=$option", _REALESTATE_MANAGER_IS_EDITED);
    }

    if ($cid) {
        $house->checkout($my->id);
    } else {
        // initialise new record
        $house->published = 0;
        $house->approved = 0;
    }

//*****************************   begin for reviews **************************//
    $database->setQuery("select a.* from #__rem_review a " .
            " WHERE a.fk_houseid=" . $cid . " ORDER BY date ;");
    $reviews = $database->loadObjectList();
//**********************   end for reviews   *****************************//

    // select list for listing type
    $listing_type[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
    $listing_type[] = mosHtml::makeOption(3, _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST);
    $listing_type[] = mosHtml::makeOption(1, _REALESTATE_MANAGER_OPTION_FOR_RENT);
    $listing_type[] = mosHtml::makeOption(2, _REALESTATE_MANAGER_OPTION_FOR_SALE);
    $listing_type_list = mosHTML::selectList($listing_type, 'listing_type',
      'class="inputbox" size="1"  onchange=rem_changedListingType(this) ', 'value', 'text', $house->listing_type);


    // select list for rent_by 
    $rent_by[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
    $rent_by[] = mosHtml::makeOption("by_day", "by_day");
    $rent_by[] = mosHtml::makeOption("by_night", "by_night");
    $rent_by[] = mosHtml::makeOption("by_week", "by_week");
    $rent_by[] = mosHtml::makeOption("by_month", "by_month");
    $rent_by_list = mosHTML::selectList($rent_by, 'rent_by',
      'class="inputbox" size="1" ', 'value', 'text', $house->rent_by);


     // select list for listing status
    $listing_status[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
    $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
    $i = 1;
    foreach ($listing_status1 as $listing_status2) {
        $listing_status[] = mosHtml::makeOption($i, $listing_status2);
        $i++;
    }
    $listing_status_list = mosHTML::selectList($listing_status, 'listing_status',
      'class="inputbox" size="1"', 'value', 'text', $house->listing_status);

    // select list for property type
    $property_type[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
    $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
    $i = 1;
    foreach ($property_type1 as $property_type2) {
        $property_type[] = mosHtml::makeOption($i, $property_type2);
        $i++;
    }
    $property_type_list = mosHTML::selectList($property_type, 'property_type',
      'class="inputbox" size="1"', 'value', 'text', $house->property_type);

    $house_photo = array();
    if (isset($house->id) && trim($house->id) != "") {
        $query = "select main_img from #__rem_photos WHERE fk_houseid='$house->id' order by img_ordering,id";
        $database->setQuery($query);
        $house_temp_photos = $database->loadObjectList();

        foreach ($house_temp_photos as $house_temp_photo) {
            $house_photos[] = array($house_temp_photo->main_img,
              rem_picture_thumbnail($house_temp_photo->main_img,
                $realestatemanager_configuration['foto']['high'],
                $realestatemanager_configuration['foto']['width']));
        }

        $query = "select image_link from #__rem_houses WHERE id='$house->id'";
        $database->setQuery($query);
        $house_photo = $database->loadResult();

        if ($house_photo != '')
            $house_photo = array($house_photo, rem_picture_thumbnail($house_photo,
              $realestatemanager_configuration['foto']['high'],
               $realestatemanager_configuration['foto']['width']));
        else $house_photo = array();
    }
///////////START check video/audio files\\\\\\\\\\\\\\\\\\\\\\
    $tracks = array();
    $videos = array();
    if (!empty($house->id)) {
      $database->setQuery("SELECT * FROM #__rem_video_source WHERE fk_house_id=" . $cid);
      $videos = $database->loadObjectList();
    }
    $youtube = new stdClass();
    for ($i = 0;$i < count($videos);$i++) {
      if (!empty($videos[$i]->youtube)) {
        $youtube->code = $videos[$i]->youtube;
        $youtube->id = $videos[$i]->id;
        break;
      }
    }
    if (!empty($house->id)) { //check video file
      $database->setQuery("SELECT * FROM #__rem_track_source WHERE fk_house_id=" . $cid);
      $tracks = $database->loadObjectList();
    }
    if(count($videos)){
        for($i = 0; $i < count($videos); $i++){
            $query = "INSERT INTO
                        `#__rem_video_source`
                      SET
                        `fk_house_id` = ".$house->id.",
                        `sequence_number` = '".$videos[$i]->sequence_number."',
                        `src` = '".$videos[$i]->src."',
                        `type` = '".$videos[$i]->type."',
                        `media` = '".$videos[$i]->media."',
                        `youtube` = '".$videos[$i]->youtube."'";
            $database->setQuery($query);
            $database->execute();
        }
    }
    if(count($tracks)){
        for($i = 0; $i < count($tracks); $i++){
            $query = "INSERT INTO
                        `#__rem_track_source`
                      SET
                        `fk_house_id` = ".$house->id.",
                        `sequence_number` = '".$tracks[$i]->sequence_number."',
                        `src` = '".$tracks[$i]->src."',
                        `kind` = '".$tracks[$i]->kind."',
                        `scrlang` = '".$tracks[$i]->scrlang."',
                        `label` = '".$tracks[$i]->label."'";
            $database->setQuery($query);
            $database->execute();
        }
    }
////////////////////////////////END check video/audio files \\\\\\\\\\\\\\\\\\
    if (trim($cid) != "") {
        $query = "select * from #__rem_rent_sal WHERE fk_houseid='$cid' order by `yearW`, `monthW`";
        $database->setQuery($query);
        $house_rent_sal = $database->loadObjectList();

        if(count($house_rent_sal)){
            for($i = 0; $i < count($house_rent_sal); $i++){
                $query = "INSERT INTO
                            `#__rem_rent_sal`
                          SET
                            `fk_houseid` = ".$house->id.",
                            `monthW` = '".$house_rent_sal[$i]->monthW."',
                            `yearW` = '".$house_rent_sal[$i]->yearW."',
                            `week` = '".$house_rent_sal[$i]->week."',
                            `weekend` = '".$house_rent_sal[$i]->weekend."',
                            `price_from` = '".$house_rent_sal[$i]->price_from."',
                            `price_to` = '".$house_rent_sal[$i]->price_to."',
                            `special_price` = ".$house_rent_sal[$i]->special_price.",
                            `comment_price` = '".$house_rent_sal[$i]->comment_price."',
                            `priceunit` = '".$house_rent_sal[$i]->priceunit."'";
                $database->setQuery($query);
                $database->execute();
            }
        }
    }

    // $query = "SELECT * ";
    $query = "SELECT f.id, f.name, LTRIM(f.categories) AS categories , f.published, f.image_link ";
    $query .= "FROM #__rem_feature as f ";
    $query .= "WHERE f.published = 1 ";
    // Sorting features
    // $query .= "ORDER BY f.categories";
    $query .= "ORDER BY categories, f.name";
    $database->setQuery($query);
    $house_feature = $database->loadObjectList();

    for ($i = 0; $i < count($house_feature); $i++) {
        $feature = "";
        if (!empty($house->id_true)) {
            $query = "SELECT id ";
            $query .= "FROM #__rem_feature_houses ";
            $query .= "WHERE fk_featureid =" . $house_feature[$i]->id .
             " AND fk_houseid =" . $house->id_true;
            $database->setQuery($query);
            $feature = $database->loadResult();
            if ($feature)
                $house_feature[$i]->check = 1; else
                $house_feature[$i]->check = 0;
        } else {
            $house_feature[$i]->check = 0;
        }
    }

    $currencys = explode(';', $realestatemanager_configuration['currency']);
    foreach ($currencys as $row) {
        if ($row != '') {
            $row = explode("=", $row);
            $temp_currency[] = mosHTML::makeOption($row[0], $row[0]);
        }
    }
    $currency = mosHTML::selectList($temp_currency, 'priceunit', 'class="inputbox" size="1"',
       'value', 'text', $house->priceunit);
    $currency_spacial_price = mosHTML::selectList($temp_currency, 'currency_spacial_price',
       'class="inputbox" size="1"', 'value', 'text', $house->priceunit);
    $query = "SELECT lang_code, title FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();

    $languages_row[] = mosHTML::makeOption('*', 'All');
    if (version_compare(JVERSION, '2.5', 'ge')) {
        foreach ($languages as $language) {
            $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
        }
    }
    $languages = mosHTML::selectList($languages_row, 'language', 'class="inputbox" size="1"',
       'value', 'text', $house->language);

    $associate_house = null;
    for ($i = 6; $i <= 10; $i++) {
        $extraOption = array();
        $extraOption[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
        $name = "_REALESTATE_MANAGER_EXTRA" . $i . "_SELECTLIST";
        $extra = explode(',', constant($name));
        $j = 1;
        foreach ($extra as $extr) {
            $extraOption[] = mosHTML::makeOption($j, $extr);
            $j++;
        }

        switch ($i) {
            case 6:
                $extraSelect = $house->extra6;
                break;
            case 7:
                $extraSelect = $house->extra7;
                break;
            case 8:
                $extraSelect = $house->extra8;
                break;
            case 9:
                $extraSelect = $house->extra9;
                break;
            case 10:
                $extraSelect = $house->extra10;
                break;
        }
        $extra_list[] = mosHTML::selectList($extraOption, 'extra' . $i, 'class="inputbox" size="1"',
          'value', 'text', $extraSelect);
    }

    HTML_realestatemanager::editHouse($option, $house, $clist, $ratinglist, $delete_edoc,$videos,$youtube, $tracks, $reviews, $listing_status_list, $property_type_list, $listing_type_list,$rent_by_list, $house_photo,$house_temp_photos, $house_photos, $house_rent_sal, $house_feature, $currency, $languages, $extra_list,  $currency_spacial_price,$associate_house);
}




function editHouse($option, $cid) {
    global $database, $my, $mosConfig_live_site, $realestatemanager_configuration, $os_rem_state;

    $house = new mosRealEstateManager($database);


    // load the row from the db table
    $house->load(intval($cid));


/************************************    language     *********************/
    $associateArray = array();
    if($cid){
      $call_from = 'backend';
      $associateArray = edit_house_associate($house,$call_from);
    }
/**************************************************************************/
    // get list of categories
    $categories = array();

    $query = "SELECT  id ,name, language, parent_id as parent"
            . "\n FROM #__rem_main_categories"
            . "\n WHERE section='com_realestatemanager'"
            . "\n AND published > 0"
            . "\n ORDER BY parent_id, ordering";

    $database->setQuery($query);
    $rows = $database->loadObjectList();

    // establish the hierarchy of the categories
    $children = array();
    // first pass - collect children
    foreach ($rows as $v) {
        $pt = $v->parent;
        $list = @$children[$pt] ? $children[$pt] : array();
        array_push($list, $v);
        $children[$pt] = $list;
    }

    // second pass - get an indent list of the items
    $list = houseLibraryTreeRecurse(0, '', array(), $children);

    foreach ($list as $i => $item) {
        if($item->language != "*"){
        $item->text = $item->treename . " (" . $item->language . ")";
        } else {
        $item->text = $item->treename;
        }
        $item->value = $item->id;
        $list[$i] = $item;
    }
    $categories = array_merge($categories, $list);

    //if (count($categories) <= 1) {
    //mosRedirect("index.php?option=com_realestatemanager&section=categories",
    //_REALESTATE_MANAGER_ADMIN_IMPEXP_ADD);
    //}
    if (isset($house->id) && trim($house->id) != "")
        $house->setCatIds();
    $clist = mosHTML::selectList($categories, 'catid[]', 'class="inputbox" multiple',
     'value', 'text', $house->catid);

    //get Rating
    $retVal2 = mosRealEstateManagerOthers::getRatingArray();
    $rating = null;
    for ($i = 0, $n = count($retVal2); $i < $n; $i++) {
        $help = $retVal2[$i];
        $rating[] = mosHTML::makeOption($help[0], $help[1]);
    }

    //delete ehouse?
    if( isset($house->edok_link) ) $help = str_replace($mosConfig_live_site, "", $house->edok_link);
    else $help = 1 ;
    $delete_ehouse_yesno[] = mosHTML::makeOption($help, _REALESTATE_MANAGER_YES);
    $delete_ehouse_yesno[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_NO);
    $delete_edoc = mosHTML::RadioList($delete_ehouse_yesno, 'delete_edoc', 'class="inputbox"', '0', 'value', 'text');

    // fail if checked out not by 'me'
    if ($house->checked_out && $house->checked_out <> $my->id) {
        mosRedirect("index.php?option=$option", _REALESTATE_MANAGER_IS_EDITED);
    }

    if ($cid) {
        $house->checkout($my->id);
    } else {
        // initialise new record
        $house->published = 0;
        $house->approved = 0;
    }

//*****************************   begin for reviews **************************//
    if($cid != 0 ){
      $database->setQuery("select a.* from #__rem_review a " .
              " WHERE a.fk_houseid=" . $cid . " ORDER BY date ;");
      $reviews = $database->loadObjectList();
    } else {
       $reviews = array();
    }
//**********************   end for reviews   *****************************//
    // select list for listing type
    $listing_type[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
    $listing_type[] = mosHtml::makeOption(3, _REALESTATE_MANAGER_OPTION_FOR_PROPERTY_REQUEST);
    $listing_type[] = mosHtml::makeOption(1, _REALESTATE_MANAGER_OPTION_FOR_RENT);
    $listing_type[] = mosHtml::makeOption(2, _REALESTATE_MANAGER_OPTION_FOR_SALE);


    $listing_type_list = mosHTML::selectList($listing_type, 'listing_type',
      'class="inputbox" size="1"  onchange=rem_changedListingType(this) ', 'value', 'text', $house->listing_type);


    // select list for rent_by 
    $tmp_rent_by = "by_night";
    if( $house->rent_by != "" )  $tmp_rent_by = $house->rent_by;
    $rent_by[] = mosHtml::makeOption("by_day", "by_day");
    $rent_by[] = mosHtml::makeOption("by_night", "by_night");
    $rent_by[] = mosHtml::makeOption("by_week", "by_week");
    $rent_by[] = mosHtml::makeOption("by_month", "by_month");
    $rent_by_list = mosHTML::selectList($rent_by, 'rent_by',
      'class="inputbox" size="1" ', 'value', 'text', $tmp_rent_by);

    // select list for listing status
    $listing_status[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
    $listing_status1 = explode(',', _REALESTATE_MANAGER_OPTION_LISTING_STATUS);
    $i = 1;
    foreach ($listing_status1 as $listing_status2) {
        $listing_status[] = mosHtml::makeOption($i, $listing_status2);
        $i++;
    }
    $listing_status_list = mosHTML::selectList($listing_status,
     'listing_status', 'class="inputbox" size="1"', 'value', 'text', $house->listing_status);

    // select list for property type
    $property_type[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
    $property_type1 = explode(',', _REALESTATE_MANAGER_OPTION_PROPERTY_TYPE);
    $i = 1;
    foreach ($property_type1 as $property_type2) {
        $property_type[] = mosHtml::makeOption($i, $property_type2);
        $i++;
    }
    $property_type_list = mosHTML::selectList($property_type, 'property_type',
     'class="inputbox" size="1"', 'value', 'text', $house->property_type);


   $house_photo = array();
   if (isset($house->id) && trim($house->id) != "") {
        $query = "select main_img from #__rem_photos WHERE fk_houseid='$house->id' order by img_ordering,id";
        $database->setQuery($query);
        $house_temp_photos = $database->loadObjectList();

        foreach ($house_temp_photos as $house_temp_photo) {
            $house_photos[] = array($house_temp_photo->main_img,
             rem_picture_thumbnail($house_temp_photo->main_img, '150', '150'));
        }

        $query = "select image_link from #__rem_houses WHERE id='$house->id'";
        $database->setQuery($query);
        $house_photo = $database->loadResult();

        if ($house_photo != '')
            $house_photo = array($house_photo, rem_picture_thumbnail($house_photo, '150', '150'));
        else $house_photo = array();
    }
    if (isset($house->id) && trim($house->id) != "") {
        $query = "select * from #__rem_rent_sal WHERE fk_houseid='$house->id' order by `yearW`, `monthW`";
        $database->setQuery($query);
        $house_rent_sal = $database->loadObjectList();
    }

///////////START check video/audio files\\\\\\\\\\\\\\\\\\\\\\
    $tracks = array();
    $videos = array();
    $youtubeId = "";
    if (!empty($house->id)) {
      $database->setQuery("SELECT * FROM #__rem_video_source WHERE fk_house_id=" . $house->id);
      $videos = $database->loadObjectList();
    }
    $youtube = new stdClass();
    for ($i = 0;$i < count($videos);$i++) {
      if (!empty($videos[$i]->youtube)) {
        $youtube->code = $videos[$i]->youtube;
        $youtube->id = $videos[$i]->id;
        break;
      }
    }
    if (!empty($house->id)) { //check video file
      $database->setQuery("SELECT * FROM #__rem_track_source WHERE fk_house_id=" . $house->id);
      $tracks = $database->loadObjectList();
    }
////////////////////////////////END check video/audio files \\\\\\\\\\\\\\\\\\
    // $query = "SELECT * ";
    $query = "SELECT f.id, f.name, LTRIM(f.categories) AS categories , f.published, f.image_link ";
    $query .= "FROM #__rem_feature as f ";
    $query .= "WHERE f.published = 1 ";

    // Sorting features
    // $query .= "ORDER BY f.categories";
    $query .= "ORDER BY categories, f.name";

    $database->setQuery($query);
    $house_feature = $database->loadObjectList();

    for ($i = 0; $i < count($house_feature); $i++) {
        $feature = "";
        if (!empty($house->id)) {
            $query = "SELECT id ";
            $query .= "FROM #__rem_feature_houses ";
            $query .= "WHERE fk_featureid =" . $house_feature[$i]->id .
             " AND fk_houseid =" . $house->id;
            $database->setQuery($query);
            $feature = $database->loadResult();

            if ($feature)
                $house_feature[$i]->check = 1; else
                $house_feature[$i]->check = 0;

        } else {
            $house_feature[$i]->check = 0;
        }
    }

    $currencys = explode(';', $realestatemanager_configuration['currency']);
    foreach ($currencys as $row) {
        if ($row != '') {
            $row = explode("=", $row);
//            if ($house->priceunit == $row[0])
//                $house->price = $row[1];
            $temp_currency[] = mosHTML::makeOption($row[0], $row[0]);
        }
    }
    $currency = mosHTML::selectList($temp_currency, 'priceunit',
     'class="inputbox" size="1"', 'value', 'text', $house->priceunit);
    $currency_spacial_price = mosHTML::selectList($temp_currency,
     'currency_spacial_price', 'class="inputbox" size="1"', 'value', 'text', $house->priceunit);



    $query = "SELECT lang_code, title FROM #__languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();

    $languages_row[] = mosHTML::makeOption('*', 'All');
    if (version_compare(JVERSION, '2.5', 'ge')) {
        foreach ($languages as $language) {
            $languages_row[] = mosHTML::makeOption($language->lang_code, $language->title);
        }
    }
    $languages = mosHTML::selectList($languages_row, 'language',
     'class="inputbox" size="1"', 'value', 'text', $house->language);

    for ($i = 6; $i <= 10; $i++) {
        $extraOption = array();
        $extraOption[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_OPTION_SELECT);
        $name = "_REALESTATE_MANAGER_EXTRA" . $i . "_SELECTLIST";
        $extra = explode(',', constant($name));
        $j = 1;
        foreach ($extra as $extr) {
            $extraOption[] = mosHTML::makeOption($j, $extr);
            $j++;
        }

        switch ($i) {
            case 6:
                $extraSelect = $house->extra6;
                break;
            case 7:
                $extraSelect = $house->extra7;
                break;
            case 8:
                $extraSelect = $house->extra8;
                break;
            case 9:
                $extraSelect = $house->extra9;
                break;
            case 10:
                $extraSelect = $house->extra10;
                break;
        }
        $extra_list[] = mosHTML::selectList($extraOption, 'extra' . $i,
         'class="inputbox" size="1"', 'value', 'text', $extraSelect);
    }

    if($realestatemanager_configuration['show_country_region_city_as_text_field'] == 0){
        $countrys_and_regions = mosRealEstateManagerOthers::getElementsArray('countrys_and_regions.txt');
        $regions_and_citys = mosRealEstateManagerOthers::getElementsArray('regions_and_citys.txt');

//******************************************** country list *********************************
        if(isset($house->hcountry) && trim($house->hcountry) == ''){
            $hcountry  = '';
        }else{
            $hcountry = $house->hcountry;
        }

        $countrys[] = mosHtml::makeOption('', _REALESTATE_MANAGER_ADMIN_PLEASE_SEL);

            $countryList = $countrys_and_regions[0];

            foreach ($countryList as $country) {
                if (trim($country) != ''){
                  $countrys[] = mosHtml::makeOption(trim($country), trim($country));
                }
            }
        if(!in_array($hcountry, $countrys_and_regions[0])){
            if($hcountry != ''){
                $countrys[] = mosHtml::makeOption($hcountry, $hcountry);
            }
        }

        $country = mosHTML::selectList($countrys, 'hcountry', 'class="inputbox" size="1" onchange=rem_changedCountry(this)', 'value', 'text', $hcountry);

        $house->hcountry = $country;
    //******************************************** end country list *********************************


    //******************************************** region list **************************************

        if(isset($house->hregion) && trim($house->hregion) == ''){
            $hregion  = '';
        }else{
            $hregion = $house->hregion;
        }

        $regions[] = mosHtml::makeOption('', _REALESTATE_MANAGER_ADMIN_PLEASE_SEL);

        if(in_array($hcountry, $countrys_and_regions[0])){
            $countrys_and_regions_tmp = array_flip($countrys_and_regions[0]) ;
            $countryIndex = $countrys_and_regions_tmp[$hcountry];
            $regionList = $countrys_and_regions[1][$countryIndex];

            foreach ($regionList as $region) {
                if (trim($region) != ''){
                  $regions[] = mosHtml::makeOption(trim($region), trim($region));
                }
            }
        }else{
            if($hregion  != ''){
                $regions[] = mosHtml::makeOption(trim($hregion), trim($hregion));
            }
        }

        // $regions = array_unique($regions);

        $region = mosHTML::selectList($regions, 'hregion', 'class="inputbox" size="1" onchange=rem_changedRegion(this)', 'value', 'text', $hregion);

        $house->hregion = $region;

    //******************************************** end region list **********************************



    //******************************************** city list **************************************//

        if(isset($house->hcity) && trim($house->hcity) == ''){
            $hcity  = '';
        }else{
            $hcity = $house->hcity;
        }

        $citys[] = mosHtml::makeOption('', _REALESTATE_MANAGER_ADMIN_PLEASE_SEL);

        if(in_array($hregion, $regions_and_citys[0])){
            $regions_and_citys_tmp = array_flip($regions_and_citys[0]) ;
            $regionIndex = $regions_and_citys_tmp[$hregion];
            $cityList = $regions_and_citys[1][$regionIndex];

            foreach ($cityList as $city) {
                if (trim($city) != ''){
                  $citys[] = mosHtml::makeOption(trim($city), trim($city));
                }
            }
        }else{
            if($hcity  != ''){
                $citys[] = mosHtml::makeOption($hcity, $hcity);
            }
        }

        // $citys = array_unique($citys);

        $city = mosHTML::selectList($citys, 'hcity', 'class="inputbox" size="1"', 'value', 'text', $hcity);

        $house->hcity = $city;



    }
//******************************************** end city list **********************************
//******************************************** add diagramm **********************************
    $diagramma = false;
    if($realestatemanager_configuration['energy_field_show']) {
        $energy_value = $house->energy_value;
        $climate_value = $house->climate_value;

        require_once JPATH_SITE . '/components/com_realestatemanager/views/view_house/tmpl/_diagramm.php';

        $diagramma = diagram($energy_value, $climate_value);
    }
//******************************************** end add diagramm ******************************


    if ( $house->id ) {
        $registry = new JRegistry($house->metadata); 
        $metadata = $registry->toArray() ;
        $house->metadata = array() ;
 
        $house->metadata['meta_title'] = 
            (isset($metadata['meta_title']) )?($metadata['meta_title']):("");
        $house->metadata['meta_keywords'] = 
            (isset($metadata['meta_keywords']) )?($metadata['meta_keywords']):("");
        $house->metadata['meta_description'] = 
            (isset($metadata['meta_description']) )?($metadata['meta_description']):("");
        $house->metadata['meta_robots'] = 
            (isset($metadata['meta_robots']) )?($metadata['meta_robots']):("");
    }else{
        $house->metadata = array() ;
        $house->metadata['meta_title']="";
        $house->metadata['meta_keywords']="";
        $house->metadata['meta_description']="";
        $house->metadata['meta_robots']="";
    }

    $meta_robots = null;
    $robots[] = JHtml::_('select.option',"", _REALESTATE_MANAGER_ROBOTS_USE_GLOBAL);
    $robots[] = JHtml::_('select.option',"index, follow", _REALESTATE_MANAGER_ROBOTS_INDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, follow", _REALESTATE_MANAGER_ROBOTS_NOINDEX_FOLLOW);
    $robots[] = JHtml::_('select.option',"index, nofollow", _REALESTATE_MANAGER_ROBOTS_INDEX_NOFOLLOW);
    $robots[] = JHtml::_('select.option',"noindex, nofollow", _REALESTATE_MANAGER_ROBOTS_NOINDEX_NOFOLLOW);

    $meta_robots = JHtml::_('select.genericlist',$robots, "metadata[meta_robots]", 'class="inputbox" size="1"', 
        'value', 'text',  $house->metadata['meta_robots'] );

    HTML_realestatemanager::editHouse(
            $option,
            $house,
            $clist,
            $ratinglist,
            $delete_edoc,
            $videos,
            $youtube,
            $tracks,
            $reviews,
            $listing_status_list,
            $property_type_list,
            $listing_type_list,
            $rent_by_list,
            $house_photo,
            $house_temp_photos,
            $house_photos,
            $house_rent_sal,
            $house_feature,
            $currency,
            $languages,
            $extra_list,
            $currency_spacial_price,
            $associateArray,
            $meta_robots,
            $countrys_and_regions,
            $regions_and_citys,
            $diagramma
            );

}


function getMonth($month) {

    switch ($month) {
        case 1:
            $smonth = JText::_('JANUARY');
            break;
        case 2:
            $smonth = JText::_('FEBRUARY');
            break;
        case 3:
            $smonth = JText::_('MARCH');
            break;
        case 4:
            $smonth = JText::_('APRIL');
            break;
        case 5:
            $smonth = JText::_('MAY');
            break;
        case 6:
            $smonth = JText::_('JUNE');
            break;
        case 7:
            $smonth = JText::_('JULY');
            break;
        case 8:
            $smonth = JText::_('AUGUST');
            break;
        case 9:
            $smonth = JText::_('SEPTEMBER');
            break;
        case 10:
            $smonth = JText::_('OCTOBER');
            break;
        case 11:
            $smonth = JText::_('NOVEMBER');
            break;
        case 12:
            $smonth = JText::_('DECEMBER');
            break;
    }

    return $smonth;
}



function saveHouse($option, $task) {

    global $database, $my, $mosConfig_absolute_path, $mosConfig_live_site, $realestatemanager_configuration, $os_rem_state;
    // checking how the other info should be provided

    $house = new mosRealEstateManager($database);

    $post = JFactory::getApplication()->input->post->getArray(array(), null, 'raw');    
    if (!$house->bind($post)) {
        echo "<script> alert('" . addslashes($house->getError()) .
         "'); window.history.go(-1); </script>\n";
        exit();
    }

    $registry = new JRegistry($house->metadata); 
    $house->metadata = $registry->toString() ;
    
    $house->publish_up = date_transform_rem($house->publish_up,"to");
    $house->publish_down = date_transform_rem($house->publish_down,"to");


    //check energy value
    if(!empty($_POST['energy_value']) && ($_POST['energy_value'] <= 0 || !is_numeric($_POST['energy_value']))){
        $house->energy_value = 1;
    }

    //check climate value
    if(!empty($_POST['climate_value']) && ($_POST['climate_value'] <= 0 || !is_numeric($_POST['climate_value']))){
        $house->climate_value = 1;
    }

    if (($_POST['owner_id'] == 0))
        $house->owner_id = $_POST['owner_id'];
    if(($_POST['owner_id'] == '')){
        $house->owner_id = $my->id;
    }

    //get ordering value
    $query = "SELECT MIN(ordering) FROM #__rem_houses WHERE ordering != '0'";
    $database->setQuery($query);
    $min_ordering = $database->loadResult();
    if($min_ordering){
        if($min_ordering == 1){
            $min_ordering = $min_ordering - 2;
        }else{
            $min_ordering = $min_ordering - 1;
        }
    }else{
        $min_ordering = 1;
    }

    //set ordering value
    if(isset($_POST['id'])){

        $house_ordering = new mosRealEstateManager($database);
        $house_ordering->load((int)$_POST['id']);

        if($house_ordering->ordering == 0){
            $house->ordering = $min_ordering;
        }
    }

    $house->contacts = $_POST['contacts'];

/*************Call function to Save changes for associated houses*******************/
    save_house_associate();
/***********************************************************************************/

    if (isset($_POST['edok_link']))
        $house->edok_link = $_POST['edok_link'];
    //delete ehouse file if neccesary
    $delete_edoc = mosGetParam($_POST, 'delete_edoc', 0);
    if ($delete_edoc != '0') {
        $retVal = unlink($mosConfig_absolute_path . $delete_edoc);
        $house->edok_link = "";
    }

    //storing e-house
    if (isset($_FILES['edoc_file'])){
        $edfile = $_FILES['edoc_file'];
        $uid = md5(uniqid(rand(), 1));
        $edfile['name'] = $uid . $edfile['name'];
        $newpath = JPATH_COMPONENT . '/edocs/' . $edfile['name'];
    }
    //check if fileupload is correct
    if ($realestatemanager_configuration['edocs']['allow']
            && intval($edfile['error']) > 0
            && intval($edfile['error']) < 4) {

        echo "<script> alert('" . _REALESTATE_MANAGER_LABEL_EDOCUMENT_UPLOAD_ERROR .
        "'); window.history.go(-1); </script>\n";
        exit();
    } else if ($realestatemanager_configuration['edocs']['allow']
            && isset($_FILES['edoc_file']) && intval($edfile['error']) != 4) {

        $uploaddir = $mosConfig_absolute_path . $realestatemanager_configuration['edocs']['location'];

        // delete spaces and forbidden characters in file name
        // $file_new = $uploaddir . $uid . $_FILES['edoc_file']['name'];
        $file_name_clear_ext = $uid . rem_remove_forbidden_characters_whitespaces_from_file_name( $_FILES['edoc_file']['name'] );
        $file_new = $uploaddir . $file_name_clear_ext;

        $ext = pathinfo($_FILES['edoc_file']['name'], PATHINFO_EXTENSION);
        $ext = strtolower($ext);
        $allowed_exts = explode(",", $realestatemanager_configuration['allowed_exts']);
        foreach ($allowed_exts as $key => $allowed_ext) {
            $allowed_exts[$key] = strtolower($allowed_ext);
        }

        $file['type'] = $_FILES['edoc_file']['type'];
        $db = JFactory::getDbo();
        $db->setQuery("SELECT mime_type FROM #__rem_mime_types WHERE `mime_ext` = "
         . $db->quote($ext) . " and mime_type = " . $db->quote($file['type']));
        $file_db_mime = $db->loadResult();
        if ($file_db_mime != $file['type']) {
            echo "<script> alert(' " . _REALESTATE_MANAGER_FILE_MIME_TYPE_NOT_MATCH
              . " - " . $_FILES['edoc_file']['name'] . "'); window.history.go(-1); </script>\n";
            exit();
        }
        ////
        if (!copy($_FILES['edoc_file']['tmp_name'], $file_new)) {
            echo "<script> alert('error: not copy'); window.history.go(-1); </script>\n";
            exit();
        } else {

            // $house->edok_link = $mosConfig_live_site . $realestatemanager_configuration['edocs']['location'] . $edfile['name'];
            $house->edok_link = $mosConfig_live_site . $realestatemanager_configuration['edocs']['location'] . $file_name_clear_ext;

        }
    }

    if (is_string($house)) {
        echo "<script> alert('" . $house . "'); window.history.go(-1); </script>\n";
        exit();
    }

    if ($realestatemanager_configuration['publish_on_add']['show']) {
        $house->published = 1;
    } else {
        $house->published = 0;
    }
    if ($realestatemanager_configuration['approve_on_add']['show']) {
        $house->approved = 1;
    } else {
        $house->approved = 0;
    }

    $house->date = date("Y-m-d H:i:s");
    if (!$house->check()) {
        echo "<script> alert('" . addslashes($house->getError()) .
         "'); window.history.go(-1); </script>\n";
        exit();
    }

    $house->description = stripslashes($house->description);
    if($house->energy_value == "" ) $house->energy_value = 0 ;
    if($house->climate_value == "" ) $house->climate_value = 0 ;

    $house->map_zoom = intval($house->map_zoom);
    if (!$house->store()) {
        echo "<script> alert('" . addslashes($house->getError()) .
         "'); window.history.go(-1); </script>\n";
        exit();
    }

    $house->saveCatIds($house->catid);
    $house->checkin();

    // saving main image
    $uploaddir = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';

    if($_REQUEST['idtrue']){

        $uploaddir = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
        $code = guid();
        $house_true_id = $_REQUEST['idtrue'];

        $query = "select main_img from #__rem_photos WHERE fk_houseid='$house_true_id' order by img_ordering,id";
        $database->setQuery($query);
        $house_temp_photos = $database->loadObjectList();

        $query = "select image_link from #__rem_houses WHERE id='$house_true_id' order by id";
        $database->setQuery($query);
        $house_mail_photos = $database->loadObject();

        function createNewName($name){
            $regExp = '/^[A-Z0-9]{8}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{4}-[A-Z0-9]{10}/';

            if(preg_match($regExp, $name)){
                $substrName = createNewName(mb_substr($name, 36, strlen($name)));
            }else{
                $substrName = $name;
            }
            return $substrName;
        }

        $house_mail_photos_clon = $code.createNewName($house_mail_photos->image_link);
        if (copy($uploaddir.$house_mail_photos->image_link, $uploaddir.$house_mail_photos_clon)){
            $database->setQuery(
              "UPDATE #__rem_houses SET image_link='$house_mail_photos_clon' WHERE id=" . $house->id);
        }

        $database->execute();

        foreach($house_temp_photos as $val){
            $trueImg = $uploaddir.$val->main_img;
            $nameImgWithoutCode = createNewName($val->main_img);
            $file_name = $code.$nameImgWithoutCode;
            $clonImg = $uploaddir.$file_name;

            if (copy($trueImg, $clonImg)){
                $database->setQuery(
                  "INSERT INTO #__rem_photos (fk_houseid, main_img) VALUES ( '$house->id','$file_name')");

                $database->execute() ;
            }
        }

        $file_new_url = str_replace($realestatemanager_configuration['edocs']['location'],
         $realestatemanager_configuration['edocs']['location'].$code, $_REQUEST['edocument_Link']);

        $file_name = explode($realestatemanager_configuration['edocs']['location'], $_REQUEST['edocument_Link']);
        $file_new = $mosConfig_absolute_path.$realestatemanager_configuration['edocs']['location'].$code.$file_name[1];
        $file_true = $mosConfig_absolute_path.$realestatemanager_configuration['edocs']['location'].$file_name[1];

        if (copy($file_true, $file_new)){
            $sql="UPDATE #__rem_houses SET edok_link ='$file_new_url' WHERE id=" . $house->id;
            $database->setQuery($sql);
            $database->execute();
        }
        //edok_link
        $house->edok_link=$file_new_url;
        //end clon
    }

    if ($_FILES['image_link']['name'] != '') {
        ///
        $ext = pathinfo($_FILES['image_link']['name'], PATHINFO_EXTENSION);
        $ext = strtolower($ext);
        $allowed_exts = explode(",", $realestatemanager_configuration['allowed_exts_img']);
        foreach ($allowed_exts as $key => $allowed_ext) {
            $allowed_exts[$key] = strtolower($allowed_ext);
        }

        $file['type'] = $_FILES['image_link']['type'];
        $db = JFactory::getDbo();
        $db->setQuery("SELECT mime_type FROM #__rem_mime_types WHERE `mime_ext` = " .
        $db->quote($ext) . " and mime_type = " . $db->quote($file['type']));
        $file_db_mime = $db->loadResult();
        if ($file_db_mime != $file['type']) {
            echo "<script> alert(' " . _REALESTATE_MANAGER_FILE_MIME_TYPE_NOT_MATCH
              . " - " . $_FILES['image_link']['name'] . "'); window.history.go(-1); </script>\n";
            exit();
        }
        ///
        $code = guid();
        // delete spaces and forbidden characters in file name
        $_FILES['image_link']['name'] = rem_remove_forbidden_characters_whitespaces_from_file_name( $_FILES['image_link']['name'] );
        $uploadfile = $uploaddir . $code . "_" . $_FILES['image_link']['name'];
        $file_name = $code . "_" . $_FILES['image_link']['name'];
        if (copy($_FILES['image_link']['tmp_name'], $uploadfile)) {

            // Add rotate exif img
            if( $realestatemanager_configuration['rotate_img'] == '1' ){
                rem_rotateImage( $uploaddir . $file_name );
            }

            $info = getimagesize($uploaddir . $file_name, $imageinfo);
            $file_width = $info[0];
            $file_height = $info[1];

            if ($file_width > $realestatemanager_configuration['fotoupload']['width'] || $file_height > $realestatemanager_configuration['fotoupload']['high']) {
                $tmp_file = rem_picture_thumbnail($file_name, $realestatemanager_configuration['fotoupload']['width'], $realestatemanager_configuration['fotoupload']['high']);
                copy($uploaddir . $tmp_file, $uploaddir . $file_name);
                unlink($uploaddir . $tmp_file);
            }

            //deletion MAIN IMAGE WHICH WAS BEFORE
            $database->setQuery("select image_link  FROM  #__rem_houses where  id ="
                    . $house->id . "");
            $image_link = $database->loadObjectList();

            if(!empty($image_link[0]->image_link) ) 
                unlink($mosConfig_absolute_path . 
                    '/components/com_realestatemanager/photos/'
                    . $image_link[0]->image_link);

            //separation of the file name in the name and extension
            $del_main_phot = pathinfo($image_link[0]->image_link);
            $del_main_photo_type = '.' . $del_main_phot['extension'];
            $del_main_photo_name = basename($image_link[0]->image_link, $del_main_photo_type);

            if(!empty($del_main_photo_name) ){
                $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
                $check_files = JFolder::files($path, '^' . $del_main_photo_name . '.*$', false, true);
                foreach ($check_files as $check_file) {
                    unlink($check_file);
                }
            }
            //END deletion MAIN IMAGE WHICH WAS BEFORE            

            $database->setQuery("UPDATE `#__rem_houses` SET image_link='$file_name' WHERE id=" . $house->id);
            $database->execute() ;
        }
    } //end if

    /********************* if count photo group > count photo user not published******************/
    $count_foto_for_single_group = '';
    $user_group = userGID_REM($my->id);
    $user_group_mas = explode(',', $user_group);
    $max_count_foto = 0;
    foreach ($user_group_mas as $value) {
        $count_foto_for_single_group =
         $realestatemanager_configuration['user_manager_rem'][$value]['count_foto'];
        if($count_foto_for_single_group>$max_count_foto){
            $max_count_foto = $count_foto_for_single_group;
        }
    }
    $count_foto_for_single_group = $max_count_foto;
    $query = "select main_img from #__rem_photos WHERE fk_houseid='$house->id' order by img_ordering,id";
    $database->setQuery($query);
    $house_temp_photos = $database->loadObjectList();
    if(count($house_temp_photos) != 0)
    {
        $count_foto_for_single_group = $count_foto_for_single_group - count($house_temp_photos);
    }
/********************************************************************************************/

    //SAVE FILES TO FOLDER photos
    $uploaddir = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';

    if (array_key_exists("new_photo_file", $_FILES)) {
        for ($i = 0; $i < $count_foto_for_single_group; $i++) {
            if (!empty($_FILES['new_photo_file']['name'][$i])) {
                $code = guid();
                ////
                $ext = pathinfo($_FILES['new_photo_file']['name'][$i], PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $allowed_exts = explode(",", $realestatemanager_configuration['allowed_exts_img']);
                foreach ($allowed_exts as $key => $allowed_ext) {
                    $allowed_exts[$key] = strtolower($allowed_ext);
                }
                if (!in_array($ext, $allowed_exts)) {
                    echo "<script> alert(' File ext. not allowed to upload! - " .
                     $_FILES['new_photo_file']['name'][$i] . "'); window.history.go(-1); </script>\n";
                    exit();
                }
                $file['type'] = $_FILES['new_photo_file']['type'][$i];
                $db = JFactory::getDbo();
                $db->setQuery("SELECT mime_type FROM #__rem_mime_types WHERE `mime_ext` = " .
                 $db->quote($ext) . " and mime_type = " . $db->quote($file['type']));
                $file_db_mime = $db->loadResult();
                if ($file_db_mime != $file['type']) {
                    echo "<script> alert(' " . _REALESTATE_MANAGER_FILE_MIME_TYPE_NOT_MATCH
                      . " - " . $_FILES['new_photo_file']['name'][$i] . "'); window.history.go(-1); </script>\n";
                    exit();
                }

                // delete spaces and forbidden characters in file name
                $_FILES['new_photo_file']['name'][$i] = rem_remove_forbidden_characters_whitespaces_from_file_name( $_FILES['new_photo_file']['name'][$i] );

                $uploadfile = $uploaddir . $code . "_" . $_FILES['new_photo_file']['name'][$i];
                if (copy($_FILES['new_photo_file']['tmp_name'][$i], $uploadfile)) {
                    $file_name = $code . "_" . $_FILES['new_photo_file']['name'][$i];

                    // Add rotate exif img
                    if( $realestatemanager_configuration['rotate_img'] == '1' ){
                        rem_rotateImage( $uploaddir . $file_name );
                    }

                    $info = getimagesize($uploaddir . $file_name, $imageinfo);
                    $file_width = $info[0];
                    $file_height = $info[1];

                    if ($file_width > $realestatemanager_configuration['fotoupload']['width'] || $file_height > $realestatemanager_configuration['fotoupload']['high']) {
                        $tmp_file = rem_picture_thumbnail($file_name, $realestatemanager_configuration['fotoupload']['width'], $realestatemanager_configuration['fotoupload']['high']);
                        copy($uploaddir . $tmp_file, $uploaddir . $file_name);
                        unlink($uploaddir . $tmp_file);
                    }

                    $database->setQuery(
                    "INSERT INTO #__rem_photos (fk_houseid, main_img) VALUES ( '$house->id','$file_name')");
                    $database->execute();
                }
            }
        }
    } //end if
    //ordering_photo

    if (protectInjectionWithoutQuote('rem_img_ordering')){
        $ordering = protectInjectionWithoutQuote('rem_img_ordering');

        $ordering = explode(',', $ordering);
        foreach ($ordering as $key => $value) {
            $query = "UPDATE #__rem_photos SET img_ordering = $key WHERE main_img='".$value."'";
            $database->setQuery($query);
            $database->execute();
        }
    }
    //end ordering
  /////////////save video/tracks functions\\\\\\\\\\\\\\\\\\\\\\
    REMstoreVideo($house);
    REMstoreTrack($house);
  /////////////////////////\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    //CHECK FILES - SETED FOR DEL
    if (array_key_exists("del_main_photo", $_POST)) {
        $del_main_photo = $_POST['del_main_photo'];
        if ($del_main_photo != '') {
            $file_inf = pathinfo($del_main_photo);
            $file_type = '.' . $file_inf['extension'];
            $file_name = basename($del_main_photo, $file_type);

            if(!empty($file_name) ){
                $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
                $check_files = JFolder::files($path, '^' . $file_name . '.*$', false, true);
                foreach ($check_files as $check_file) {
                    unlink($check_file);
                }
            }


            $database->setQuery("UPDATE #__rem_houses SET image_link='' WHERE id=" . $house->id);
            $database->execute() ;
        }
    } //end if
    if(isset($_POST['del_photos'])){
        if (count($_POST['del_photos']) != 0) {
            if (count($_POST['del_photos']) != 0) {
                for ($i = 0; $i < count($_POST['del_photos']); $i++) {
                    $del_photo = $_POST['del_photos'][$i];
                    $database->setQuery("DELETE FROM #__rem_photos WHERE main_img='$del_photo'");
                    if ($database->execute()) {
                        $file_inf = pathinfo($del_photo);
                        $file_type = '.' . $file_inf['extension'];
                        $file_name = basename($del_photo, $file_type);

                        if(strlen($file_name) < 20) continue;

                        $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/';
                        $check_files = JFolder::files($path, '^' . $file_name . '.*$', false, true);
                        foreach ($check_files as $check_file) {
                            unlink($check_file);
                        }
                    } else {
                        echo '<script>alert("Can\'t delete");window.history.go(-1);</script>';
                    }
                }
            }
        }
    }
    if(isset($_POST['del_rent_sal'])){
        if (count($_POST['del_rent_sal']) != 0) {
            for ($i = 0; $i < count($_POST['del_rent_sal']); $i++) {
                $del_rent_sal = $_POST['del_rent_sal'][$i];
                $database->setQuery("DELETE FROM #__rem_rent_sal WHERE id ='$del_rent_sal'");
                $database->execute();
            }
        }
    }
    $house->checkin();

    if (isset($_POST['ffeature'])) {
        $feature = $_POST['ffeature'];
        $database->setQuery("DELETE FROM #__rem_feature_houses WHERE fk_houseid = " . $house->id);
        $database->execute();
        for ($i = 0; $i < count($feature); $i++) {
            $database->setQuery(
            "INSERT INTO #__rem_feature_houses (fk_houseid, fk_featureid) VALUES ("
             . $house->id . ", " . $feature[$i] . ")");
            $database->execute();
        }
    } else {
        $database->setQuery("DELETE FROM #__rem_feature_houses WHERE fk_houseid = " . $house->id);
        $database->execute();
    }
    REMdeleteVideos($house->id);
    REMdeleteTracks($house->id);

    switch ($task) {
        case 'apply':
            mosRedirect("index.php?option=" . $option . "&task=edit&cid[]=" . $house->id);
            break;

        case 'save':
            mosRedirect("index.php?option=" . $option);
            break;
    }
}

/**
 * Deletes one or more houses
 * @param array - An array of unique category id numbers
 * @param string - The current author option
 */
function removeHouses($cid, $option,$if_clon=NULL) {

    global $database, $mosConfig_absolute_path;

    if (!is_array($cid) || count($cid) < 1) {
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM .
          "'); window.history.go(-1);</script>\n";
        exit;
    }

    foreach ($cid as $item_id) {
        $house = new mosRealEstateManager($database);
        $house->load($item_id);
        $house->deleteHouse();
        $house = null ;
    }

    // $cids = implode(',', $cid);
    // $database->setQuery("DELETE FROM #__rem_rent WHERE fk_houseid IN ($cids) ");
    // $database->execute();

    // $database->setQuery("DELETE FROM #__rem_review WHERE fk_houseid IN ($cids)");
    // $database->execute();

    // $database->setQuery("DELETE FROM #__rem_categories WHERE iditem IN ($cids)");
    // $database->execute();

    // $database->setQuery("DELETE FROM #__rem_feature_houses WHERE fk_houseid IN ($cids)");
    // $database->execute();

    // for($i = 0; $i < count($cid); $i++){

    //     $query = "select associate_house from #__rem_houses where id =".$cid[$i];
    //     $database->setQuery($query);
    //     $houseAssociateHouse = $database->loadResult();

    //     $assocHouseObj = unserialize($houseAssociateHouse);
    //     $idWhereChange = array();
    //     if(!empty($assocHouseObj)){
    //         foreach ($assocHouseObj as $key => $value) {
    //             if($value == $cid[$i]){
    //                 $assocHouseObj[$key] = null;
    //             }else if($value){
    //                 $idWhereChange[] = $value;
    //             }
    //         }

    //         $stringIdWhereChange = implode(',', $idWhereChange);
    //         $newAssocSerialize = serialize($assocHouseObj);
    //         if(!empty($stringIdWhereChange)){
    //             $query =
    //               "update #__rem_houses set associate_house ='$newAssocSerialize' " .
    //                " where id in($stringIdWhereChange)";
    //             $database->setQuery($query);
    //             $database->execute();
    //         }
    //     }
    // }

    // if (count($cid)) {
    //     foreach ($cid as $h_id) {
    //       $sql = "SELECT src FROM #__rem_video_source WHERE fk_house_id =". $h_id;
    //       $database->setQuery($sql);
    //       $videos = $database->loadColumn();
    //       if ($videos) {
    //         foreach($videos as $name) {
    //           if (substr($name, 0, 4) != "http" && file_exists($mosConfig_absolute_path . $name))
    //             unlink($mosConfig_absolute_path . $name);
    //         }
    //       }
    //       $sql = "DELETE FROM #__rem_video_source
    //               WHERE (fk_house_id = $h_id)";
    //       $database->setQuery($sql);
    //       $database->execute();

    //       $sql = "SELECT src FROM #__rem_track_source WHERE fk_house_id =". $h_id;
    //       $database->setQuery($sql);
    //       $track = $database->loadColumn();
    //       if ($track) {
    //         foreach($track as $name) {
    //           if (substr($name, 0, 4) != "http" && file_exists($mosConfig_absolute_path . $name))
    //             unlink($mosConfig_absolute_path . $name);
    //         }
    //       }
    //       $sql = "DELETE FROM #__rem_track_source
    //               WHERE (fk_house_id = $h_id)";
    //       $database->setQuery($sql);
    //       $database->execute();
    //     }
    //     $database->setQuery("SELECT * FROM  #__rem_houses WHERE id IN (" . $cids . ")");
    //     $del_rem = $database->loadObjectList();

    //     for ($i = 0; $i < count($del_rem); $i++) {
    //       if ($del_rem[$i]->image_link != '' )
    //       {
    //            $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos';
    //            $del_photo_mask_inf = pathinfo($del_rem[$i]->image_link);
    //            $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
    //            $del_photo_mask = basename($del_rem[$i]->image_link, $del_photo_mask_type);

    //            if(strlen($del_photo_mask) < 20 ) continue ;

    //             @set_time_limit(ini_get('max_execution_time'));
    //             array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );

    //             $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark';
    //            $del_photo_mask_inf = pathinfo($del_rem[$i]->image_link);
    //            $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
    //            $del_photo_mask = basename($del_rem[$i]->image_link, $del_photo_mask_type);

    //            if(strlen($del_photo_mask) < 20 ) continue ;

    //             @set_time_limit(ini_get('max_execution_time'));
    //             array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );

    //       }
    //     }
    //     $database->setQuery("SELECT fk_houseid,thumbnail_img, main_img FROM #__rem_photos WHERE fk_houseid IN ($cids)");
    //     $del_photos = $database->loadObjectList();
    //     for ($i = 0; $i < count($del_photos); $i++) {
    //       if ($del_photos[$i]->main_img != '')
    //       {
    //        $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos';
    //        $del_photo_mask_inf = pathinfo($del_photos[$i]->main_img);
    //        $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
    //        $del_photo_mask = basename($del_photos[$i]->main_img, $del_photo_mask_type);

    //        if(strlen($del_photo_mask) < 20 ) continue ;

    //         @set_time_limit(ini_get('max_execution_time'));
    //         array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );

    //         $path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/watermark';
    //        $del_photo_mask_inf = pathinfo($del_photos[$i]->main_img);
    //        $del_photo_mask_type = '.' . $del_photo_mask_inf['extension'];
    //        $del_photo_mask = basename($del_photos[$i]->main_img, $del_photo_mask_type);

    //        if(strlen($del_photo_mask) < 20 ) continue ;

    //         @set_time_limit(ini_get('max_execution_time'));
    //         array_map( "unlink", glob( $path . '/' . $del_photo_mask . '*' ) );

    //        }
    //         $database->setQuery("DELETE FROM #__rem_photos WHERE fk_houseid = " . $del_photos[$i]->fk_houseid );
    //         $database->execute();

    //         $database->setQuery("DELETE FROM #__rem_houses WHERE id =" . $del_photos[$i]->fk_houseid );
    //         $database->execute();
    //     }

    //     $database->setQuery("DELETE FROM #__rem_photos WHERE fk_houseid IN ($cids)");
    //     $database->execute() ;

    //     $database->setQuery("DELETE FROM #__rem_houses WHERE id IN ($cids)");
    //     $database->execute();
    // }

    mosRedirect("index.php?option=$option");

}

/**
 * Publishes or Unpublishes one or more records
 * @param array - An array of unique category id numbers
 * @param integer - 0 if unpublishing, 1 if publishing
 * @param string - The current author option
 */
function publishHouses($cid, $publish, $option) {

    global $database, $my, $os_rem_state;

    $catid = mosGetParam($_POST, 'catid', array(0),"ARRAY");

    if (!is_array($cid) || count($cid) < 1) {
        $action = $publish ? 'publish' : 'unpublish';
        echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
        exit;
    }

    $cids = implode(',', $cid);

    $database->setQuery("UPDATE #__rem_houses SET published='$publish'" .
            "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))");
    $database->execute();

    if (count($cid) == 1) {
        $row = new mosRealEstateManager($database);
        $row->checkin($cid[0]);
    }

    mosRedirect("index.php?option=$option");
}

/**
 * Approve or Unapprove one or more records
 * @param array - An array of unique category id numbers
 * @param integer - 0 if unapprove, 1 if approve
 * @param string - The current author option
 */
function approveHouses($cid, $approve, $option) {

    global $database, $my, $os_rem_state;

    //echo $cid[0];exit;
    $catid = mosGetParam($_POST, 'catid', array(0),"ARRAY");

    if (!is_array($cid) || count($cid) < 1) {
        $action = $approve ? 'approve' : 'unapprove';
        echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
        exit;
    }

    $cids = implode(',', $cid);

    $database->setQuery("UPDATE #__rem_houses SET approved='$approve'" .
            "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='$my->id'))");
    $database->execute();


    if (count($cid) == 1) {
        $row = new mosRealEstateManager($database);
        $row->checkin($cid[0]);
    }

    mosRedirect("index.php?option=$option");
}

/**
 * Moves the order of a record
 * @param integer - The increment to reorder by
 */
function orderHouses($cid, $inc, $option) {

    global $database;

    $house = new mosRealEstateManager($database);
    $house->load($cid);
    $house->move($inc);
    mosRedirect("index.php?option=$option");
}

function sortHouses($cid = array(), $order = array(), $option='com_realestatemanager') {

    global $database;
    $house = new mosRealEstateManager($database);
    for($i=0;$i<count($cid),$i<count($order);$i++){
        $house->load($cid[$i]);
        $house->ordering = $order[$i];
        $house->store();
    }

    return true;
}

function sortCategories($cid = array(), $order = array(), $option='com_realestatemanager') {
    global $database;
    $category = new mainRealEstateCategories($database);

    for($i=0;$i<count($cid),$i<count($order);$i++){
        $category->load($cid[$i]);
        $category->ordering = $order[$i];
        $category->store();
    }

    return true;
  }

/**
 * Cancels an edit operation
 * @param string - The current author option
 */
function cancelHouse($option) {

    global $database;
    $row = new mosRealEstateManager($database);
    if($_REQUEST['idtrue']){
        $cid[]=$_REQUEST['id'];
        removeHouses($cid,$option,TRUE);
    }
    $row->bind($_POST);
    $row->checkin();
    mosRedirect("index.php?option=$option");
}

function reset_watermark() {
    $pathWat = JPATH_SITE . '/components/com_realestatemanager/photos/watermark/';
    $start = microtime(true);
    array_map('unlink', glob($pathWat."*"));
    return;
}

function configure_save_frontend($option) {
    global $my, $realestatemanager_configuration, $mosConfig_live_site, $mosConfig_absolute_path,$database, $os_rem_state;

    $str = '';
    $supArr = array();
    $supArr = mosGetParam($_POST, 'edocs_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['edocs']['registrationlevel'] = $str;


    $str = '';
    $supArr = mosGetParam($_POST, 'paypal_buy_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['paypal_buy']['registrationlevel'] = $str;
    $realestatemanager_configuration['2checkout_buy']['registrationlevel'] = $str;
    $realestatemanager_configuration['stripe_buy']['registrationlevel'] = $str;

    $str = '';
    $supArr = mosGetParam($_POST, 'paypal_buy_sale_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['paypal_buy_sale']['registrationlevel'] = $str;
    $realestatemanager_configuration['2checkout_buy_sale']['registrationlevel'] = $str;
    $realestatemanager_configuration['stripe_buy_sale']['registrationlevel'] = $str;


 

    //*********   begin add send mail for admin   *******
    $str = '';
    $supArr = mosGetParam($_POST, 'add_email_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['add_email']['registrationlevel'] = $str;
    $realestatemanager_configuration['add_email']['show'] = mosGetParam($_POST, 'add_email_show', 0);

    $str = '';
    $supArr = mosGetParam($_POST, 'review_added_email_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['review_added_email']['registrationlevel'] = $str;
    $realestatemanager_configuration['review_added_email']['show'] = mosGetParam($_POST, 'review_added_email_show', 0);


    $str = '';
    $supArr = mosGetParam($_POST, 'rentrequest_email_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['rentrequest_email']['registrationlevel'] = $str;
    $realestatemanager_configuration['rentrequest_email']['show'] = mosGetParam($_POST, 'rentrequest_email_show', 0);

    $str = '';
    $supArr = mosGetParam($_POST, 'buyingrequest_email_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['buyingrequest_email']['registrationlevel'] = $str;
    $realestatemanager_configuration['buyingrequest_email']['show'] = mosGetParam($_POST, 'buyingrequest_email_show', 0);

    $str = '';
    $supArr = mosGetParam($_POST, 'property_request_email_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['property_request_email']['registrationlevel'] = $str;
    $realestatemanager_configuration['property_request_email']['show'] = mosGetParam($_POST, 'property_request_email_show', 0);
    //*********   end add send mail for admin   *********


//***********begin Show captcha
    $realestatemanager_configuration['captcha_option']['show'] = mosGetParam($_POST, 'captcha_option');
    //***********end Show captcha
    //***********begin show captcha booking option
    $realestatemanager_configuration['captcha_option_booking']['show'] = mosGetParam($_POST, 'captcha_option_booking');
    //***********end show captcha booking option
    //***********begin show captcha sendmessage option
    $realestatemanager_configuration['captcha_option_sendmessage']['show'] = mosGetParam($_POST, 'captcha_option_sendmessage');
    //***********end show captcha sendmessage option

    $realestatemanager_configuration['captcha_option_property_request']['show'] = mosGetParam($_POST, 'captcha_option_property_request');

    //***********begin show captcha add house option
    //***********end show captcha add house option

    //***********begin show map for search layout
    $realestatemanager_configuration['searchlayout_map']['show'] = mosGetParam($_POST, 'searchlayout_map');
    $str = '';
    $supArr = mosGetParam($_POST, 'searchlayout_map_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['searchlayout_map']['registrationlevel'] = $str;
    //***********end show map for search layout
    //***********begin show order by form for search layout
    $realestatemanager_configuration['searchlayout_orderby']['show'] = mosGetParam($_POST, 'searchlayout_orderby');
    $str = '';
    $supArr = mosGetParam($_POST, 'searchlayout_orderby_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['searchlayout_orderby']['registrationlevel'] = $str;
    
    //******   begin show add serch button on frontend  *****
    $realestatemanager_configuration['search_button']['show'] = mosGetParam($_POST, 'search_button');
    $str = '';
    $supArr = mosGetParam($_POST, 'search_button_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['search_button']['registrationlevel'] = $str;
    //****** end  begin show add serch button on frontend  *****

    //***********begin option access to edit house
    $realestatemanager_configuration['option_edit']['show'] = mosGetParam($_POST, 'option_edit');
    $str = '';
    $supArr = mosGetParam($_POST, 'option_edit_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);

    if($realestatemanager_configuration['option_edit']['show']==0){
         $realestatemanager_configuration['option_edit']['registrationlevel'] = '';
    }else{
        $realestatemanager_configuration['option_edit']['registrationlevel'] = $str;
    }
    //***********end option access to edit house

    //04.07.17
    //***********begin show google captcha by default
    $realestatemanager_configuration['google_captcha_by_default_show'] = mosGetParam($_POST, 'google_captcha_by_default_show');
    //***********end begin show google captcha by default

    //***********begin show search all houses
    $realestatemanager_configuration['search_all_houses']['show'] = mosGetParam($_POST, 'search_all_houses');
    $str = '';
    $supArr = mosGetParam($_POST, 'search_all_houses_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['search_all_houses']['registrationlevel'] = $str;
    //***********end show search all houses

    //***********begin show search alone category
    $realestatemanager_configuration['search_alone_category']['show'] = mosGetParam($_POST, 'search_alone_category');
    $str = '';
    $supArr = mosGetParam($_POST, 'search_alone_category_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['search_alone_category']['registrationlevel'] = $str;
    //***********end show search alone category
    //***********begin show check in field on frontend
    $realestatemanager_configuration['search_check_in_show'] = mosGetParam($_POST, 'search_check_in_show');
    //***********end begin show check in field on frontend
    //***********begin show check out field on frontend
    $realestatemanager_configuration['search_check_out_show'] = mosGetParam($_POST, 'search_check_out_show');
    //***********end begin show check in field on frontend
    //27.07.17
    //***********begin show energy field
    $realestatemanager_configuration['energy_field_show'] = mosGetParam($_POST, 'energy_field_show');
    //***********end begin show energy field
//___cb

    $realestatemanager_configuration['cb']['show'] = mosGetParam($_POST, 'cb_show', 0);
    $realestatemanager_configuration['cb_myhouse']['show'] = mosGetParam($_POST, 'cb_show_myhouse', 0);
    $realestatemanager_configuration['cb_edit']['show'] = mosGetParam($_POST, 'cb_show_edit', 0);
    $realestatemanager_configuration['cb_rent']['show'] = mosGetParam($_POST, 'cb_show_rent', 0);
    $realestatemanager_configuration['cb_buy']['show'] = mosGetParam($_POST, 'cb_show_buy', 0);
    $realestatemanager_configuration['cb_property_request']['show'] = mosGetParam($_POST, 'cb_show_property_request', 0);
    $realestatemanager_configuration['cb_history']['show'] = mosGetParam($_POST, 'cb_show_history', 0);

    $realestatemanager_configuration['location_tab']['show'] = mosGetParam($_POST, 'location_tab_show', 0);
    $realestatemanager_configuration['street_view']['show'] = mosGetParam($_POST, 'street_view_show', 0);
    $realestatemanager_configuration['reviews_tab']['show'] = mosGetParam($_POST, 'reviews_tab_show', 0);

    //paypal and 2checkout


    if(isset($_POST['plugin_name_select'])){
        $str = '';
        $supArr = mosGetParam($_POST, 'plugin_name_select', "");
        for ($i = 0; $i < count($supArr); $i++)
            $str.=$supArr[$i] . ',';
        $str = substr($str, 0, -1);
        $realestatemanager_configuration['plugin_name_select'] = $str;


    }


    $realestatemanager_configuration['paypal_buy_status']['show'] =
     mosGetParam($_POST, 'paypal_buy_status_show', 0);
     $realestatemanager_configuration['2checkout_buy_status']['show'] =
     mosGetParam($_POST, 'paypal_buy_status_show', 0);
     $realestatemanager_configuration['stripe_buy_status']['show'] =
     mosGetParam($_POST, 'paypal_buy_status_show', 0);

    $realestatemanager_configuration['paypal_buy_status_sale']['show'] =
     mosGetParam($_POST, 'paypal_buy_status_sale_show', 0);
     $realestatemanager_configuration['2checkout_buy_status_sale']['show'] =
     mosGetParam($_POST, 'paypal_buy_status_sale_show', 0);
//     var_dump($_POST['paypal_buy_status_sale_show']); exit;
     $realestatemanager_configuration['stripe_buy_status_sale']['show'] =
     mosGetParam($_POST, 'paypal_buy_status_sale_show', 0);
    // $realestatemanager_configuration['cancel_url'] =addslashes($_POST['cancel_url']);
    // $realestatemanager_configuration['success_url'] = addslashes($_POST['success_url']);

    $realestatemanager_configuration['paypal_real_or_test']['show'] =
     mosGetParam($_POST, 'paypal_real_or_test', 0);

    $realestatemanager_configuration['special_price']['show'] =
     mosGetParam($_POST, 'special_price', 0);

    $realestatemanager_configuration['google_openmap']['show'] =
     mosGetParam($_POST, 'google_openmap', 0);

    //******   begin option for search form on nothing found page  *****
    $realestatemanager_configuration['search_form_on_nothing_found_page_show'] = mosGetParam($_POST, 'search_form_on_nothing_found_page_show', 0);
    //******  end begin option for search form on nothing found page  *****
    //******   begin option for search form on search page  *****
    $realestatemanager_configuration['search_form_on_result_search_page_show'] = mosGetParam($_POST, 'search_form_on_result_search_page_show', 0);
    //******  end begin option for search form on search page  *****
    //******   begin option search keyword on search page  *****
    $realestatemanager_configuration['search_form_search_keyword_field_show'] = mosGetParam($_POST, 'search_form_search_keyword_field_show', 0);
    //******  end begin option search keyword on search page  *****
    //******  begin option check in on search page  *****
    $realestatemanager_configuration['search_form_check_in_field_show'] = mosGetParam($_POST, 'search_form_check_in_field_show', 0);
    //******  end begin option check in on search page  *****
    //******  begin option check out on search page  *****
    $realestatemanager_configuration['search_form_check_out_field_show'] = mosGetParam($_POST, 'search_form_check_out_field_show', 0);
    //******  end begin option check out on search page  *****

    //******  begin option radiuse range field on search page  *****
    $realestatemanager_configuration['search_form_radiuse_range_field_show'] = mosGetParam($_POST, 'search_form_radiuse_range_field_show', 0);
    //******  end begin option radiuse range field on search page  *****
    //******  begin option radiuse range on search page  *****
    $realestatemanager_configuration['search_form_radiuse_range'] = mosGetParam($_POST, 'search_form_radiuse_range', 0);
    //******  end begin option radiuse range on search page  *****

    //******  begin option lot size on search page  *****
    $realestatemanager_configuration['search_lot_size_field_show'] = mosGetParam($_POST, 'search_lot_size_field_show', 0);
    //******  end begin option lot size on search page  *****
    //******  begin option house size on search page  *****
    $realestatemanager_configuration['search_house_size_field_show'] = mosGetParam($_POST, 'search_house_size_field_show', 0);
    //******  end begin option house size on search page  *****
    //******  begin option rooms number on search page  *****
    $realestatemanager_configuration['search_rooms_num_field_show'] = mosGetParam($_POST, 'search_rooms_num_field_show', 0);
    //******  end begin option rooms number on search page  *****
    //******  begin option bathrooms number on search page  *****
    $realestatemanager_configuration['search_bathrooms_num_field_show'] = mosGetParam($_POST, 'search_bathrooms_num_field_show', 0);
    //******  end begin option bathrooms number on search page  *****
    //******  begin option bedrooms number on search page  *****
    $realestatemanager_configuration['search_bedrooms_num_field_show'] = mosGetParam($_POST, 'search_bedrooms_num_field_show', 0);
    //******  end begin option bedrooms number on search page  *****
    //******  begin option category on search page  *****
    $realestatemanager_configuration['search_form_category_field_show'] = mosGetParam($_POST, 'search_form_category_field_show', 0);
    //******  end begin option category on search page  *****
    //******  begin option property_type on search page  *****
    $realestatemanager_configuration['search_form_property_type_field_show'] = mosGetParam($_POST, 'search_form_property_type_field_show', 0);
    //******  end begin option property_type on search page  *****
    //******  begin option propertyid on search page  *****
    $realestatemanager_configuration['search_form_propertyid_field_show'] = mosGetParam($_POST, 'search_form_propertyid_field_show', 0);
    //******  end begin option propertyid on search page  *****
    //******  begin option comment on search page  *****
    $realestatemanager_configuration['search_form_comment_field_show'] = mosGetParam($_POST, 'search_form_comment_field_show', 0);
    //******  end begin option comment on search page  *****
    //******  begin option title on search page  *****
    $realestatemanager_configuration['search_form_title_field_show'] = mosGetParam($_POST, 'search_form_title_field_show', 0);
    //******  end begin option title on search page  *****
    //******  begin option country on search page  *****
    $realestatemanager_configuration['search_form_country_field_show'] = mosGetParam($_POST, 'search_form_country_field_show', 0);
    //******  end begin option country on search page  *****
    //******  begin option address on search page  *****
    $realestatemanager_configuration['search_form_address_field_show'] = mosGetParam($_POST, 'search_form_address_field_show', 0);
    //******  end begin option address on search page  *****
    //******  begin option region on search page  *****
    $realestatemanager_configuration['search_form_region_field_show'] = mosGetParam($_POST, 'search_form_region_field_show', 0);
    //******  end begin option region on search page  *****
    //******  begin option city on search page  *****
    $realestatemanager_configuration['search_form_city_field_show'] = mosGetParam($_POST, 'search_form_city_field_show', 0);
    //******  end begin option city on search page  *****
    //******** add Custom Dropdown Field 6 options **********
    $realestatemanager_configuration['extra6_advanced'] = mosGetParam($_POST, 'extra6_advanced', 0);
    //******** end add Custom Dropdown Field 6 options **********
    //******** add Custom Dropdown Field 7 options **********
    $realestatemanager_configuration['extra7_advanced'] = mosGetParam($_POST, 'extra7_advanced', 0);
    //******** end add Custom Dropdown Field 7 options **********
    //******** add Custom Dropdown Field 8 options **********
    $realestatemanager_configuration['extra8_advanced'] = mosGetParam($_POST, 'extra8_advanced', 0);
    //******** end add Custom Dropdown Field 6 options **********
    //******** add Custom Dropdown Field 8 options **********
    $realestatemanager_configuration['extra9_advanced'] = mosGetParam($_POST, 'extra9_advanced', 0);
    //******** end add Custom Dropdown Field 9 options **********
    //******** add Custom Dropdown Field 10 options **********
    $realestatemanager_configuration['extra10_advanced'] = mosGetParam($_POST, 'extra10_advanced', 0);
    //******** end add Custom Dropdown Field 10 options **********
    //******  begin option zipcode on search page  *****
    $realestatemanager_configuration['search_form_zipcode_field_show'] = mosGetParam($_POST, 'search_form_zipcode_field_show', 0);
    //******  end begin option zipcode on search page  *****
    //******  begin option owner on search page  *****
    $realestatemanager_configuration['search_form_owner_field_show'] = mosGetParam($_POST, 'search_form_owner_field_show', 0);
    //******  end begin option owner on search page  *****
    //******  begin option bedrooms on search page  *****
    $realestatemanager_configuration['search_form_exactly_to_all_field_show'] = mosGetParam($_POST, 'search_form_exactly_to_all_field_show', 0);
    //******  end begin option bedrooms on search page  *****
    //******  begin option garages on search page  *****
    $realestatemanager_configuration['search_form_garages_field_show'] = mosGetParam($_POST, 'search_form_garages_field_show', 0);
    //******  end begin option garages on search page  *****
    //******  begin option build_year on search page  *****
    $realestatemanager_configuration['search_form_build_year_field_show'] = mosGetParam($_POST, 'search_form_build_year_field_show', 0);
    //******  end begin option build_year on search page  *****
    //******  begin option contacts on search page  *****
    $realestatemanager_configuration['search_form_contacts_field_show'] = mosGetParam($_POST, 'search_form_contacts_field_show', 0);
    //******  end begin option contacts on search page  *****
    //******  begin option agent on search page  *****
    $realestatemanager_configuration['search_form_agent_field_show'] = mosGetParam($_POST, 'search_form_agent_field_show', 0);
    //******  end begin option agent on search page  *****
    //******** end add Custom Dropdown Field 1 options **********
    $realestatemanager_configuration['extra1_advanced'] = mosGetParam($_POST, 'extra1_advanced', 0);
    //******** end add Custom Dropdown Field 1 options **********
    //******** end add Custom Dropdown Field 2 options **********
    $realestatemanager_configuration['extra2_advanced'] = mosGetParam($_POST, 'extra2_advanced', 0);
    //******** end add Custom Dropdown Field 2 options **********
    //******** end add Custom Dropdown Field 3 options **********
    $realestatemanager_configuration['extra3_advanced'] = mosGetParam($_POST, 'extra3_advanced', 0);
    //******** end add Custom Dropdown Field 3 options **********
    //******** end add Custom Dropdown Field 4 options **********
    $realestatemanager_configuration['extra4_advanced'] = mosGetParam($_POST, 'extra4_advanced', 0);
    //******** end add Custom Dropdown Field 4 options **********
    //******** end add Custom Dropdown Field 5 options **********
    $realestatemanager_configuration['extra5_advanced'] = mosGetParam($_POST, 'extra5_advanced', 0);
    //******** end add Custom Dropdown Field 5 options **********

    //******  begin option features on search page  *****
    $query = "SELECT name, id FROM #__rem_feature";
    $database->setQuery($query);
    $features = $database->loadObjectList();

    foreach ($features as $feature) {
        $realestatemanager_configuration['search_form_features']["$feature->id"] = mosGetParam($_POST, "search_form_features_$feature->id", 3);
    }
    //******  end option features search on page  *****

    //******  begin option default search layout  *****
    $realestatemanager_configuration['default_search_layout'] = mosGetParam($_POST, 'default_search_layout', 0);
    //******  end begin option default search layout  *****
    //******  begin option order default  *****
    $realestatemanager_configuration['order_by_default'] = mosGetParam($_POST, 'order_by_default', 0);
    //******  end begin option order default  *****
    //******  begin energy field option  *****
    $realestatemanager_configuration['energy_field_show'] = mosGetParam($_POST, 'energy_field_show', 0);
    //******  end begin energy field option  *****

//*********   begin add for Manager Add : button 'add a house' *******
    $str = '';
    $supArr = mosGetParam($_POST, 'add_house_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['add_house']['registrationlevel'] = $str;

    $realestatemanager_configuration['add_house']['show'] =
     mosGetParam($_POST, 'add_house_show', 0);

    //*******   end add for Manager add_house: button 'Add house'   *******
//*******  begin  add for Manager print_pdf: button 'print PDF'   *******
    $str = '';
    $supArr = mosGetParam($_POST, 'print_pdf_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['print_pdf']['registrationlevel'] = $str;

    $realestatemanager_configuration['print_pdf']['show'] =
     mosGetParam($_POST, 'print_pdf_show', 0);
//*******   end add for Manager print_pdf: button 'print PDF'   *******
//*******  begin  add for Manager print_view: button 'print View'   *******
    $str = '';
    $supArr = mosGetParam($_POST, 'print_view_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['print_view']['registrationlevel'] = $str;
    $realestatemanager_configuration['print_view']['show'] =
     mosGetParam($_POST, 'print_view_show', 0);
//*******   end add for Manager print_view: button 'print View'   *******




    $realestatemanager_configuration['edocs']['show'] = mosGetParam($_POST, 'edocs_show', 0);

    $realestatemanager_configuration['rotate_img'] = mosGetParam($_POST, 'rotate_img', 0);

    $realestatemanager_configuration['videos_tracks']['show'] = mosGetParam($_POST, 'videos_tracks_allow', 0);

    $realestatemanager_configuration['price']['show'] = mosGetParam($_POST, 'price_show', 0);
    $realestatemanager_configuration['price']['string'] = mosGetParam($_POST, 'price_string', 0);

    $realestatemanager_configuration['thumb_param']['show'] = mosGetParam($_POST, 'thumb_param_show', 0);
    $realestatemanager_configuration['foto']['high'] = mosGetParam($_POST, 'foto_high');
    $realestatemanager_configuration['foto']['width'] = mosGetParam($_POST, 'foto_width');
    $realestatemanager_configuration['fotomain']['high'] = mosGetParam($_POST, 'fotomain_high');
    $realestatemanager_configuration['fotomain']['width'] = mosGetParam($_POST, 'fotomain_width');
    //add calendar year
    $realestatemanager_configuration['initial_year'] = mosGetParam($_POST, 'initial_year');
    $realestatemanager_configuration['final_year'] = mosGetParam($_POST, 'final_year');
    //end add calendar year
    $realestatemanager_configuration['fotoupload']['high'] = mosGetParam($_POST, 'fotoupload_high');
    $realestatemanager_configuration['fotoupload']['width'] = mosGetParam($_POST, 'fotoupload_width');
    $realestatemanager_configuration['fotogallery']['high'] = mosGetParam($_POST, 'fotogallery_high');
    $realestatemanager_configuration['fotogallery']['width'] = mosGetParam($_POST, 'fotogallery_width');
    $realestatemanager_configuration['fotocategory']['high'] = mosGetParam($_POST, 'fotocategory_high');
    $realestatemanager_configuration['fotocategory']['width'] = mosGetParam($_POST, 'fotocategory_width');
    $realestatemanager_configuration['page']['items'] = mosGetParam($_POST, 'page_items');
    $realestatemanager_configuration['license']['show'] = mosGetParam($_POST, 'license_show');

    //add for show in category picture
    $realestatemanager_configuration['cat_pic']['show'] = mosGetParam($_POST, 'cat_pic_show');

    //add for show subcategory
    $realestatemanager_configuration['subcategory']['show'] = mosGetParam($_POST, 'subcategory_show');
    //***********begin approve on add


    $realestatemanager_configuration['slider']['height'] = mosGetParam($_POST, 'slider_height', 56);
    $realestatemanager_configuration['slider']['object_fit'] = mosGetParam($_POST, 'slider_object_fit', 'cover');

    //start pdf_print_logo
    $pdf_print_logo_path = $mosConfig_absolute_path . '/components/com_realestatemanager/photos/pdf_print_logo/';

    if ( ( isset($_FILES['pdf_print_logo_file']) && $_FILES['pdf_print_logo_file']["size"] > 0
        && ($_FILES['pdf_print_logo_file']['name'] != $realestatemanager_configuration['pdf_print_logo_primary_file']['name']) ) ) {
        $uploaddir = $pdf_print_logo_path;

        if ( isset($_FILES['pdf_print_logo_file']['tmp_name']) && !empty($_FILES['pdf_print_logo_file']['tmp_name']) && !copy($_FILES['pdf_print_logo_file']['tmp_name'], $uploaddir.$_FILES['pdf_print_logo_file']['name']) ) {

        } else {
            if ( $_FILES['pdf_print_logo_file']['name'] != '' ) {
                $realestatemanager_configuration['pdf_print_logo_primary_file']['name'] = $_FILES['pdf_print_logo_file']['name'];
            }
        }
        rename($pdf_print_logo_path . $realestatemanager_configuration['pdf_print_logo_primary_file']['name'], $pdf_print_logo_path . "pdf_print_logo.png");
    }

    $realestatemanager_configuration['pdf_print_logo']['show'] = mosGetParam($_POST, 'pdf_print_logo_show', '1');
    //end pdf_print_logo

    //view type
    $realestatemanager_configuration['view_house'] = mosGetParam($_POST, 'view_house');
    //owner show
    $realestatemanager_configuration['owner']['show'] = mosGetParam($_POST, 'owner_show');

    //***********begin Calendar list
    $realestatemanager_configuration['calendarlist']['show'] = "1";

    $str = '';
    $supArr = mosGetParam($_POST, 'calendarlist_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['calendarlist']['registrationlevel'] = "-2";
    //***********end Calendar list

    //***********begin additional_tab list
    $realestatemanager_configuration['additional_tab']['show'] = mosGetParam($_POST, 'additional_tab_show');

    $str = '';
    $supArr = mosGetParam($_POST, 'additional_tab_registrationlevel', 0);
    if ( isset($supArr) && $supArr > 0 ) {
        for ($i = 0; $i < count($supArr); $i++) {
        $str.=$supArr[$i] . ',';
        }
    }
    $str = substr($str, 0, -1);
    $realestatemanager_configuration['additional_tab']['registrationlevel'] = $str;
    //***********end additional_tab list


    $realestatemanager_configuration['price_format'] = $_POST['patern'];
    $realestatemanager_configuration['date_format'] = mosGetParam($_POST, 'date_format');
    $realestatemanager_configuration['datetime_format'] = mosGetParam($_POST, 'datetime_format');
    $realestatemanager_configuration['price_unit_show'] = $_POST['price_unit_show'];

    //show location map
    $realestatemanager_configuration['location_map'] = mosGetParam($_POST, 'location_map', 0);
    $realestatemanager_configuration['cat_orderind_default'] = mosGetParam($_POST, 'cat_orderind_default', 'name');

    //12.07.17
    //***********begin rent request user email notification
    $realestatemanager_configuration['rentrequest_user_email_notification'] = mosGetParam($_POST, 'rentrequest_user_email_notification', 0);
    //***********end begin rent request user email notification
    //***********begin buying request user email notification
    $realestatemanager_configuration['buyingrequest_user_email_notification'] = mosGetParam($_POST, 'buyingrequest_user_email_notification', 0);
    //***********end begin buying request user email notification
    $realestatemanager_configuration['property_request_user_email_notification'] = mosGetParam($_POST, 'property_request_user_email_notification', 0);
    //***********begin mandatory built year
    $realestatemanager_configuration['mandatory_built_year_field'] = mosGetParam($_POST, 'mandatory_built_year_field', 0);
    //***********end begin mandatory built year
    //***********begin mandatory address
    $realestatemanager_configuration['mandatory_address_field'] = mosGetParam($_POST, 'mandatory_address_field', 0);
    //***********end begin mandatory address
    //***********begin mandatory price
    $realestatemanager_configuration['mandatory_price_field'] = mosGetParam($_POST, 'mandatory_price_field', 0);
    //***********end begin mandatory price
    //***********begin mandatory photo
    $realestatemanager_configuration['mandatory_photo_field'] = mosGetParam($_POST, 'mandatory_photo_field', 0);
    //***********end begin mandatory photo
    //***********begin mandatory House size, Sqrt
    $realestatemanager_configuration['mandatory_house_size_field'] = mosGetParam($_POST, 'mandatory_house_size_field', 0);
    //***********end begin mandatory House size, Sqrt

    //***********begin mandatory Rooms
    $realestatemanager_configuration['mandatory_rooms_field'] = mosGetParam($_POST, 'mandatory_rooms_field', 0);
    //***********end begin mandatory Rooms
    //***********begin mandatory Bedrooms
    $realestatemanager_configuration['mandatory_bedrooms_field'] = mosGetParam($_POST, 'mandatory_bedrooms_field', 0);
    //***********end begin mandatory Bedrooms
    $realestatemanager_configuration['rel_data_columns_adv_lg'] = mosGetParam($_POST, 'rel_data_columns_adv_lg', "");
    $realestatemanager_configuration['rel_data_columns_adv_md'] = mosGetParam($_POST, 'rel_data_columns_adv_md', "");
    $realestatemanager_configuration['rel_data_columns_adv_sm'] = mosGetParam($_POST, 'rel_data_columns_adv_sm', "");
    $realestatemanager_configuration['rel_data_columns_adv_xs'] = mosGetParam($_POST, 'rel_data_columns_adv_xs', "");

    $realestatemanager_configuration['rel_data_columns_map_lg'] = mosGetParam($_POST, 'rel_data_columns_map_lg', "");
    $realestatemanager_configuration['rel_data_columns_map_md'] = mosGetParam($_POST, 'rel_data_columns_map_md', "");
    $realestatemanager_configuration['rel_data_columns_map_sm'] = mosGetParam($_POST, 'rel_data_columns_map_sm', "");
    $realestatemanager_configuration['rel_data_columns_map_xs'] = mosGetParam($_POST, 'rel_data_columns_map_xs', "");

    mosRealEstateManagerOthers::setParams();
}


function configure_save_backend($option) {

    global $my, $realestatemanager_configuration, $mosConfig_live_site, $mosConfig_absolute_path, $os_rem_state;

    $gtree = get_group_children_tree_rem();
    foreach($gtree as $g){
        $realestatemanager_configuration['user_manager_rem'][$g->value]['count_homes'] =
          intval(mosGetParam($_POST, 'count_homes' . $g->value, "100"));
        $realestatemanager_configuration['user_manager_rem'][$g->value]['count_foto'] = 5 ;
    }
    //$realestatemanager_configuration['tabs']['show']=mosGetParam($_POST, 'tabs_show', "");
    $realestatemanager_configuration['add_email']['address'] =
            mosGetParam($_POST, 'add_email_address', ""); //back--1
    $realestatemanager_configuration['review_email']['address'] =
            mosGetParam($_POST, 'review_email_address', ""); //back--1
    $realestatemanager_configuration['rentrequest_email']['address'] =
            mosGetParam($_POST, 'rentrequest_email_address', "");
    $realestatemanager_configuration['buyingrequest_email']['address'] =
            mosGetParam($_POST, 'buyingrequest_email_address', "");
    $realestatemanager_configuration['property_request_email']['address'] =
            mosGetParam($_POST, 'property_request_email_address', "");

    $realestatemanager_configuration['houseid']['auto-increment']['boolean'] =
            mosGetParam($_POST, 'houseid_auto_increment_boolean', 0);
    $realestatemanager_configuration['edocs']['allow'] = mosGetParam($_POST, 'edocs_allow', 0);
    $realestatemanager_configuration['edocs']['location'] =
     mosGetParam($_POST, 'edocs_location', "/components/com_realestatemanager/edocs/");
    $realestatemanager_configuration['rent_answer'] = mosGetParam($_POST, 'rent_answer', 0);
    $realestatemanager_configuration['rent_form'] =
     str_replace("\\", "", mosGetParam($_POST, 'rent_form', 0));
    $realestatemanager_configuration['buy_answer'] = mosGetParam($_POST, 'buy_answer', 0);
    $realestatemanager_configuration['property_request_answer'] = mosGetParam($_POST, 'property_request_answer', 0);

    $realestatemanager_configuration['buy_form'] =
     str_replace("\\", "", mosGetParam($_POST, 'buy_form', 0));

    $realestatemanager_configuration['rent_before_end_notify'] =
     mosGetParam($_POST, 'rent_before_end_notify', 0);
    $realestatemanager_configuration['rent_before_end_notify_days'] =
     mosGetParam($_POST, 'rent_before_end_notify_days', "2");
    $realestatemanager_configuration['rent_before_end_notify_email'] =
     mosGetParam($_POST, 'rent_before_end_notify_email', "");
    $realestatemanager_configuration['calendar']['placeholder'] =
     mosGetParam($_POST, 'calendar_placeholder', "");

    $realestatemanager_configuration['manager_feature_category'] =
     mosGetParam($_POST, 'manager_feature_category', 0);

    $realestatemanager_configuration['sale_separator'] = mosGetParam($_POST, 'sale_separator', 0);

    //********* add sale fraction price *********
    $realestatemanager_configuration['sale_fraction'] = mosGetParam($_POST, 'sale_fraction', 0);
    //********* end add sale fraction price *********

    //paypal

    $realestatemanager_configuration['pay_pal_buy']['business'] =
     mosGetParam($_POST, 'pay_pal_buy_business', "");
    $realestatemanager_configuration['pay_pal_buy']['return'] =
     mosGetParam($_POST, 'pay_pal_buy_return', "");
    $realestatemanager_configuration['pay_pal_buy']['image_url'] =
     mosGetParam($_POST, 'pay_pal_buy_image_url', "");
    $realestatemanager_configuration['pay_pal_buy']['cancel_return'] =
     mosGetParam($_POST, 'pay_pal_buy_cancel_return', "");
    $realestatemanager_configuration['pay_pal_rent']['business'] =
     mosGetParam($_POST, 'pay_pal_rent_business', "");
    $realestatemanager_configuration['pay_pal_rent']['return'] =
     mosGetParam($_POST, 'pay_pal_rent_return', "");
    $realestatemanager_configuration['pay_pal_rent']['image_url'] =
     mosGetParam($_POST, 'pay_pal_rent_image_url', "");
    $realestatemanager_configuration['pay_pal_rent']['cancel_return'] =
     mosGetParam($_POST, 'pay_pal_rent_cancel_return', "");

    // 0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--

    //$realestatemanager_configuration['plugin_name_select'] = mosGetParam($_POST, 'plugin_name_select', "");


    // 0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--0--

    $realestatemanager_configuration['extra1'] = mosGetParam($_POST, 'extra1', '');
    $realestatemanager_configuration['extra2'] = mosGetParam($_POST, 'extra2', '');
    $realestatemanager_configuration['extra3'] = mosGetParam($_POST, 'extra3', '');
    $realestatemanager_configuration['extra4'] = mosGetParam($_POST, 'extra4', '');
    $realestatemanager_configuration['extra5'] = mosGetParam($_POST, 'extra5', '');
    $realestatemanager_configuration['extra6'] = mosGetParam($_POST, 'extra6', '');
    $realestatemanager_configuration['extra7'] = mosGetParam($_POST, 'extra7', '');
    $realestatemanager_configuration['extra8'] = mosGetParam($_POST, 'extra8', '');
    $realestatemanager_configuration['extra9'] = mosGetParam($_POST, 'extra9', '');
    $realestatemanager_configuration['extra10'] = mosGetParam($_POST, 'extra10', '');


    //add show house slider
    $realestatemanager_configuration['show_house_slider'] = mosGetParam($_POST, 'show_house_slider', 0);
    //end add show house slider
    //add show country, region and city_as text field
    $realestatemanager_configuration['show_country_region_city_as_text_field'] = mosGetParam($_POST, 'show_country_region_city_as_text_field', 0);
    //end add show country, region and city_as text field

    $realestatemanager_configuration['show_metadata'] = 
        mosGetParam($_POST, 'show_metadata');

    $realestatemanager_configuration['calendar']['placeholder'] =
     mosGetParam($_POST, 'calendar_placeholder', "");
    //$realestatemanager_configuration['featuredmanager']['placeholder'] =
    // mosGetParam($_POST, 'featuredmanager_placeholder', "");
    $realestatemanager_configuration['currency'] = mosGetParam($_POST, 'currency', "");
    //---------------------start check currency-----------------------------//
    //this array from paypal plugin,if you change something here, don't forget to change it in the paypal.php
    $plugin_name_select = mosGetParam($_POST, 'plugin_name_select', "") ;
    if( is_array($plugin_name_select ) && count($plugin_name_select) > 0 )
        foreach( $plugin_name_select as $rem_config ){

            if($rem_config == 'paypal'
                && ($realestatemanager_configuration['paypal_buy_status']['show']
                 || $realestatemanager_configuration['paypal_buy_status_sale']['show']))
            {
                $defcurrency=array('AUD','CAD','CZK','DKK','EUR','HKD','HUF','JPY','NOK','NZD',
                'PLN','SGD','SEK','CHF','USD','RUB','ILS','MXN','PHP','GBP','THB');
                $currenc = explode(';', $realestatemanager_configuration['currency']);
                foreach ($currenc as $row) {
                    if ($row != '') {
                        $row = explode("=", $row);
                        if (!in_array($row[0],$defcurrency)) {
                            echo "<script> alert('" . _REALESTATE_MANAGER_ADMIN_NOT_CORRECT_CURRENCY .
                             "'); window.history.go(-1);</script>\n";
                            exit;
                        }
                    }
                }
            }
                //this array from 2checkout plugin, if you change something here, don't forget to change it in the 2checkout.php
            if($rem_config == '2checkout'
                && ($realestatemanager_configuration['2checkout_buy_status']['show']
                 || $realestatemanager_configuration['2checkout_buy_status_sale']['show']))
            {

                 $defcurrency=array('AFN', 'ALL', 'DZD', 'ARS', 'AUD', 'AZN', 'BSD', 'BDT', 'BBD', 'BZD', 'BMD', 'BOB', 'BWP', 'BRL', 'GBP', 'BND',
                'BGN', 'CAD', 'CLP', 'CNY', 'COP', 'CRC', 'HRK', 'CZK', 'DKK', 'DOP', 'XCD', 'EGP', 'EUR', 'FJD', 'GTQ', 'HKD',
                'HNL', 'HUF', 'INR', 'IDR', 'ILS', 'JMD', 'JPY', 'KZT', 'KES', 'LAK', 'MMK', 'LBP', 'LRD', 'MOP', 'MYR', 'MVR',
                'MRO', 'MUR', 'MXN', 'MAD', 'NPR', 'TWD', 'NZD', 'NIO', 'NOK', 'PKR', 'PGK', 'PEN', 'PHP', 'PLN', 'QAR', 'RON',
                'RUB', 'WST', 'SAR', 'SCR', 'SGD', 'SBD', 'ZAR', 'KRW', 'LKR', 'SEK', 'CHF', 'SYP', 'THB', 'TOP', 'TTD', 'TRY',
                'UAH', 'AED', 'USD', 'VUV', 'VND', 'XOF', 'YER');

                $currenc = explode(';', $realestatemanager_configuration['currency']);
                foreach ($currenc as $row) {

                    if ($row != '') {
                        $row = explode("=", $row);
                        if (!in_array($row[0],$defcurrency)) {
                            echo "<script> alert('" . _REALESTATE_MANAGER_ADMIN_NOT_CORRECT_CURRENCY_2CHECKOUT .
                             "'); window.history.go(-1);</script>\n";
                            exit;
                        }
                    }
                }
            }
        }

    //---------------------------end check-------------------------//
    $realestatemanager_configuration['allowed_exts'] = mosGetParam($_POST, 'allowed_exts', "");
    $realestatemanager_configuration['allowed_exts_img'] = mosGetParam($_POST, 'allowed_exts_img', "");
    $realestatemanager_configuration['allowed_exts_video'] = mosGetParam($_POST, 'allowed_exts_video', "");
    $realestatemanager_configuration['allowed_exts_track'] = mosGetParam($_POST, 'allowed_exts_track', "");
    $realestatemanager_configuration['toronto_login'] = mosGetParam($_POST, 'toronto_login', "");
    $realestatemanager_configuration['api_key'] = mosGetParam($_POST, 'api_key', "");
    $realestatemanager_configuration['toronto_password'] = mosGetParam($_POST, 'toronto_password', "");

    $realestatemanager_configuration['mresdms_login'] = mosGetParam($_POST, 'mresdms_login', "");
    $realestatemanager_configuration['mresdms_password'] = mosGetParam($_POST, 'mresdms_password', "");

    $realestatemanager_configuration['matrix_login'] = mosGetParam($_POST, 'matrix_login', "");
    $realestatemanager_configuration['matrix_password'] = mosGetParam($_POST, 'matrix_password', "");

    //13.07.17
    if(!preg_match('/(^https?:\/\/)/i' ,$_POST['patern_rent']) && $realestatemanager_configuration['input_link_rent'] == '3'){
        $_POST['patern_rent'] = "http://".$_POST['patern_rent'];
    }
    if(!preg_match('/(^https?:\/\/)/i' ,$_POST['patern_sale']) && $realestatemanager_configuration['input_link_rent'] == '3'){
        $_POST['patern_sale'] = "http://".$_POST['patern_sale'];
    }
    if(!preg_match('/(^https?:\/\/)/i' ,$_POST['patern_property_request']) && $realestatemanager_configuration['input_link_property_request'] == '3'){
        $_POST['patern_property_request'] = "http://".$_POST['patern_property_request'];
    }
    $realestatemanager_configuration['input_link_rent'] = $_POST['patern_rent'];
    $realestatemanager_configuration['input_link_sale'] = $_POST['patern_sale'];
    $realestatemanager_configuration['input_link_property_request'] = $_POST['patern_property_request'];

    mosRealEstateManagerOthers::setParams();
}

function configure($option) {
    //configure_frontend
    global $my, $realestatemanager_configuration, $acl, $database;
    global $mosConfig_absolute_path;
    $yesno[] = mosHTML::makeOption('1', _REALESTATE_MANAGER_YES);
    $yesno[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_NO);
    // $daynight[] = mosHTML::makeOption('1', _REALESTATE_MANAGER_ADMIN_CONFIG_RENT_BEFORE_END_NOTIFY_DAYS);
    // $daynight[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_RENT_PER_NIGHT);
    $google_openmap[] = mosHTML::makeOption('1', _REALESTATE_MANAGER_GOOGLE_OPENMAP_GOOGLE);
    $google_openmap[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_GOOGLE_OPENMAP_OPENMAP);
    $lists = array();

    $gtree = get_group_children_tree_rem();

    foreach($gtree as $g) {
        $t['value'] = $g->value;
        $t['role'] = str_replace('&nbsp;', '', $g->text);
        $t['count_homes'] = '<input type="text" name="count_homes' . $g->value . '" value="' .
         $realestatemanager_configuration['user_manager_rem'][$g->value]['count_homes'] .
         '" class="inputbox" size="5" maxlength="5" />';
        $t['count_foto'] = '<input type="text" name="count_foto' . $g->value . '" value="' .
           $realestatemanager_configuration['user_manager_rem'][$g->value]['count_foto'] .
           '" class="inputbox" size="3" maxlength="3" />';
        $lists['user_manager_rem'][] = $t;
    }

    // _______________- community builder section -_______________
    $f = array();
    $s = explode(',', $realestatemanager_configuration['cb_myhouse']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['cb_myhouse']['show'] = mosHTML::RadioList($yesno, 'cb_show_myhouse', 'class="inputbox"',
      $realestatemanager_configuration['cb_myhouse']['show'], 'value', 'text');

    $lists['cb_myhouse']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_myhouse_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['cb_edit']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['cb_edit']['show'] = mosHTML::RadioList($yesno, 'cb_show_edit', 'class="inputbox"',
      $realestatemanager_configuration['cb_edit']['show'], 'value', 'text');

    $lists['cb_edit']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_edit_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['cb_rent']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['cb_rent']['show'] = mosHTML::RadioList($yesno, 'cb_show_rent', 'class="inputbox"',
      $realestatemanager_configuration['cb_rent']['show'], 'value', 'text');

    $lists['cb_rent']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_rent_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['cb_buy']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['cb_buy']['show'] = mosHTML::RadioList($yesno, 'cb_show_buy', 'class="inputbox"',
     $realestatemanager_configuration['cb_buy']['show'], 'value', 'text');

    $lists['cb_buy']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_buy_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['cb_property_request']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['cb_property_request']['show'] = mosHTML::RadioList($yesno, 'cb_show_property_request', 'class="inputbox"',
     $realestatemanager_configuration['cb_property_request']['show'], 'value', 'text');

    $lists['cb_property_request']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_property_request_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['cb_history']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['cb_history']['show'] = mosHTML::RadioList($yesno, 'cb_show_history', 'class="inputbox"',
      $realestatemanager_configuration['cb_history']['show'], 'value', 'text');

    $lists['cb_history']['registrationlevel'] = mosHTML::selectList($gtree, 'cb_history_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);
    // _______________- end community builder section -_______________




    $f = array();
    $s = explode(',', $realestatemanager_configuration['houserequest']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['housestatus']['show'] = mosHTML::RadioList($yesno, 'housestatus_show', 'class="inputbox"',
     $realestatemanager_configuration['housestatus']['show'], 'value', 'text');

    $lists['houserequest']['registrationlevel'] = mosHTML::selectList($gtree, 'houserequest_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['buyrequest']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['buystatus']['show'] = mosHTML::RadioList($yesno, 'buystatus_show', 'class="inputbox"',
     $realestatemanager_configuration['buystatus']['show'], 'value', 'text');

    $lists['buyrequest']['registrationlevel'] = mosHTML::selectList($gtree, 'buyrequest_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['property_request']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['property_request']['show'] = mosHTML::RadioList($yesno, 'property_request_show', 'class="inputbox"',
     $realestatemanager_configuration['property_request']['show'], 'value', 'text');

    $lists['property_request']['registrationlevel'] = mosHTML::selectList($gtree, 'property_request_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['edocs']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['edocs']['registrationlevel'] = mosHTML::selectList($gtree, 'edocs_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);

    $lists['edocs']['show'] = mosHTML::RadioList($yesno, 'edocs_show', 'class="inputbox"',
     $realestatemanager_configuration['edocs']['show'], 'value', 'text');

    // add rotate images
    $lists['rotate_img'] = mosHTML::RadioList($yesno, 'rotate_img', 'class="inputbox"', $realestatemanager_configuration['rotate_img'], 'value', 'text');
    // end add rotate images

    $lists['videos_tracks']['show'] = mosHTML::RadioList($yesno, 'videos_tracks_allow', 'class="inputbox"',
        $realestatemanager_configuration['videos_tracks']['show'], 'value', 'text');
    $lists['videos']['location'] = '<input disabled="disabled" type="text" name="videos_location" value="' .
        $realestatemanager_configuration['videos']['location'] . '" class="inputbox" size="50" maxlength="50" title="" />';
    $lists['tracks']['location'] = '<input disabled="disabled" type="text" name="tracks_location" value="' .
         $realestatemanager_configuration['tracks']['location'] . '" class="inputbox" size="50" maxlength="50" title="" />';

    $f = array();
    $s = explode(',', $realestatemanager_configuration['price']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['price']['show'] = mosHTML::RadioList($yesno, 'price_show', 'class="inputbox"',
     $realestatemanager_configuration['price']['show'], 'value', 'text');

    $lists['price']['string'] = mosHTML::RadioList($yesno, 'price_string', 'class="inputbox"',
     $realestatemanager_configuration['price']['string'], 'value', 'text');

    $lists['price']['registrationlevel'] = mosHTML::selectList($gtree, 'price_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);

    //********   begin add send mail for admin  ******************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['add_email']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['add_email']['show'] = mosHTML::RadioList($yesno, 'add_email_show', 'class="inputbox"',
     $realestatemanager_configuration['add_email']['show'], 'value', 'text');
    $lists['add_email']['registrationlevel'] = mosHTML::selectList($gtree,
     'add_email_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['review_added_email']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['review_added_email']['show'] = mosHTML::RadioList($yesno, 'review_added_email_show',
     'class="inputbox"', $realestatemanager_configuration['review_added_email']['show'], 'value', 'text');
    $lists['review_added_email']['registrationlevel'] = mosHTML::selectList($gtree,
     'review_added_email_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['rentrequest_email']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['rentrequest_email']['show'] = mosHTML::RadioList($yesno, 'rentrequest_email_show', 'class="inputbox"',
     $realestatemanager_configuration['rentrequest_email']['show'], 'value', 'text');
    $lists['rentrequest_email']['registrationlevel'] = mosHTML::selectList($gtree,
     'rentrequest_email_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //buying
    $f = array();
    $s = explode(',', $realestatemanager_configuration['buyingrequest_email']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['buyingrequest_email']['show'] = mosHTML::RadioList($yesno, 'buyingrequest_email_show',
     'class="inputbox"', $realestatemanager_configuration['buyingrequest_email']['show'], 'value', 'text');
    $lists['buyingrequest_email']['registrationlevel'] =
      mosHTML::selectList($gtree, 'buyingrequest_email_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['property_request_email']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['property_request_email']['show'] = mosHTML::RadioList($yesno, 'property_request_email_show',
     'class="inputbox"', $realestatemanager_configuration['property_request_email']['show'], 'value', 'text');
    $lists['property_request_email']['registrationlevel'] =
      mosHTML::selectList($gtree, 'property_request_email_registrationlevel[]',
      'size="4" multiple="multiple"', 'value', 'text', $f);


//********   end add send mail for admin   **********************

//******   begin add for  Manager print_pdf: button 'print PDF'   *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['print_pdf']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['print_pdf']['show'] = mosHTML::RadioList($yesno, 'print_pdf_show', 'class="inputbox"',
     $realestatemanager_configuration['print_pdf']['show'], 'value', 'text');

    $lists['print_pdf']['registrationlevel'] = mosHTML::selectList($gtree, 'print_pdf_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end add for Manager print_pdf: button 'print PDF'   *******
//******   begin add for  Manager print_view: button 'print View'   *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['print_view']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['print_view']['show'] = mosHTML::RadioList($yesno, 'print_view_show', 'class="inputbox"',
     $realestatemanager_configuration['print_view']['show'], 'value', 'text');

    $lists['print_view']['registrationlevel'] = mosHTML::selectList($gtree, 'print_view_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end add for Manager print_view: button 'print View'   *******


    $f = array();
    $s = explode(',', $realestatemanager_configuration['reviews']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['reviews']['show'] = mosHTML::RadioList($yesno, 'reviews_show', 'class="inputbox"',
     $realestatemanager_configuration['reviews']['show'], 'value', 'text');
    $lists['reviews']['registrationlevel'] = mosHTML::selectList($gtree, 'reviews_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);

//******   begin add for Manager Add house: button 'add a house'   *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['add_house']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['add_house']['show'] = mosHTML::RadioList($yesno, 'add_house_show', 'class="inputbox"',
     $realestatemanager_configuration['add_house']['show'], 'value', 'text');

    $lists['add_house']['registrationlevel'] = mosHTML::selectList($gtree, 'add_house_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);

//******   end add for Manager Add house: button 'add a house'   **
    //********** greatschools list ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['greatschools']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['greatschools']['show'] = mosHTML::RadioList($yesno, 'greatschools_show', 'class="inputbox"', $realestatemanager_configuration['greatschools']['show'], 'value', 'text');

    $lists['greatschools']['registrationlevel'] = mosHTML::selectList($gtree, 'greatschools_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********** END greatschools list ************
    //********** greatschools list ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['walkscore']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['walkscore']['show'] = mosHTML::RadioList($yesno, 'walkscore_show', 'class="inputbox"', $realestatemanager_configuration['walkscore']['show'], 'value', 'text');

    $lists['walkscore']['registrationlevel'] = mosHTML::selectList($gtree, 'walkscore_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    $lists['walkscore_key'] = '<input type="text" name="walkscore_key"
    value="' . $realestatemanager_configuration['walkscore']['key'] . '" class="inputbox" size="25" maxlength="100" title="" />';
    //********** END walkscore list ************
    
    //********** Calendar list ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['calendarlist']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['calendarlist']['show'] = mosHTML::RadioList($yesno, 'calendarlist_show', 'class="inputbox"', $realestatemanager_configuration['calendarlist']['show'], 'value', 'text');

    $lists['calendarlist']['registrationlevel'] = mosHTML::selectList($gtree, 'calendarlist_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********** END Calendar list ************


    //********** additional_tab list ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['additional_tab']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['additional_tab']['show'] = mosHTML::RadioList($yesno, 'additional_tab_show', 'class="inputbox"', $realestatemanager_configuration['additional_tab']['show'], 'value', 'text');

    $lists['additional_tab']['registrationlevel'] = mosHTML::selectList($gtree, 'additional_tab_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //********** END additional_tab list ************


    //show location map
    $lists['location_map'] = mosHTML::RadioList($yesno, 'location_map', 'class="inputbox"',
     $realestatemanager_configuration['location_map'], 'value', 'text');

    $cat_orderind_default = array();
    $cat_orderind_default[] = mosHTML::makeOption('name','name');
    $cat_orderind_default[] = mosHTML::makeOption('ordering','ordering');


    $lists['cat_orderind_default'] = mosHTML::selectList($cat_orderind_default, 'cat_orderind_default', '', 'value', 'text',  $realestatemanager_configuration['cat_orderind_default']);

    $lists['thumb_param']['show'] = mosHTML::RadioList($yesno, 'thumb_param_show', 'class="inputbox"',
     $realestatemanager_configuration['thumb_param']['show'], 'value', 'text');

    //12.07.17
    //***********begin rent request user email notification
    $lists['rentrequest_user_email_notification'] = mosHTML::RadioList($yesno, 'rentrequest_user_email_notification', 'class="inputbox"', $realestatemanager_configuration['rentrequest_user_email_notification'], 'value', 'text');
    //***********end begin rent request user email notification
    //***********begin buying request user email notification
    $lists['buyingrequest_user_email_notification'] = mosHTML::RadioList($yesno, 'buyingrequest_user_email_notification', 'class="inputbox"', $realestatemanager_configuration['buyingrequest_user_email_notification'], 'value', 'text');
    //***********end begin buying request user email notification

    $lists['property_request_user_email_notification'] = mosHTML::RadioList($yesno, 'property_request_user_email_notification', 'class="inputbox"', $realestatemanager_configuration['property_request_user_email_notification'], 'value', 'text');
    //***********begin add mandatory built year
    $lists['mandatory_built_year_field'] = mosHTML::RadioList($yesno, 'mandatory_built_year_field', 'class="inputbox"', $realestatemanager_configuration['mandatory_built_year_field'], 'value', 'text');
    //***********end begin add mandatory built year

    //***********begin mandatory address
    $lists['mandatory_address_field'] = mosHTML::RadioList($yesno, 'mandatory_address_field', 'class="inputbox"', $realestatemanager_configuration['mandatory_address_field'], 'value', 'text');
    //***********end begin mandatory address

    //***********begin mandatory price
    $lists['mandatory_price_field'] = mosHTML::RadioList($yesno, 'mandatory_price_field', 'class="inputbox"', $realestatemanager_configuration['mandatory_price_field'], 'value', 'text');
    //***********end begin mandatory price

    //***********begin mandatory photo
    $lists['mandatory_photo_field'] = mosHTML::RadioList($yesno, 'mandatory_photo_field', 'class="inputbox"', $realestatemanager_configuration['mandatory_photo_field'], 'value', 'text');
    //***********end begin mandatory photo

    $lists['foto']['high'] = '<input type="text" name="foto_high"
    value="' . $realestatemanager_configuration['foto']['high'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['foto']['width'] = '<input type="text" name="foto_width"
    value="' . $realestatemanager_configuration['foto']['width'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['fotomain']['high'] = '<input type="text" name="fotomain_high"
    value="' . $realestatemanager_configuration['fotomain']['high'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['fotomain']['width'] = '<input type="text" name="fotomain_width"
    value="' . $realestatemanager_configuration['fotomain']['width'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['fotoupload']['high'] = '<input type="text" name="fotoupload_high"
    value="' . $realestatemanager_configuration['fotoupload']['high'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';


    //***********begin mandatory House size, Sqrt
    $lists['mandatory_house_size_field'] = mosHTML::RadioList($yesno, 'mandatory_house_size_field', 'class="inputbox"', $realestatemanager_configuration['mandatory_house_size_field'], 'value', 'text');
    //***********end begin mandatory House size, Sqrt

    //***********begin mandatory Rooms
    $lists['mandatory_rooms_field'] = mosHTML::RadioList($yesno, 'mandatory_rooms_field', 'class="inputbox"', $realestatemanager_configuration['mandatory_rooms_field'], 'value', 'text');
    //***********end begin mandatory Rooms

    //***********begin mandatory Bedrooms
    $lists['mandatory_bedrooms_field'] = mosHTML::RadioList($yesno, 'mandatory_bedrooms_field', 'class="inputbox"', $realestatemanager_configuration['mandatory_bedrooms_field'], 'value', 'text');
    //***********end begin mandatory Bedrooms


    //add calendar year
    $year = date("Y", mktime(0, 0, 0, date('m'), 1, date('Y')));

    if( !isset($realestatemanager_configuration['initial_year']) 
        || empty($realestatemanager_configuration['initial_year']) 
        || intval($realestatemanager_configuration['initial_year']) <= 0 ){
            $initial_year_val = $year;
    } else {
        $initial_year_val = intval($realestatemanager_configuration['initial_year'] );
    }

    if(!isset($realestatemanager_configuration['final_year']) 
        || empty($realestatemanager_configuration['final_year']) 
        || intval($realestatemanager_configuration['final_year'] ) <= $initial_year_val){
        $final_year_val = $initial_year_val + 1;
    }
    else{
        $final_year_val = intval($realestatemanager_configuration['final_year'] );
    }

    $lists['initial_year'] = '<input type="text" name="initial_year"
    value="' . $initial_year_val . '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['final_year'] = '<input type="text" name="final_year"
    value="' . $final_year_val . '" class="inputbox" size="4" maxlength="4" title="" />';
    //end add calendar year

    $lists['fotoupload']['width'] = '<input type="text" name="fotoupload_width"
    value="' . $realestatemanager_configuration['fotoupload']['width'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['fotogallery']['high'] = '<input type="text" name="fotogallery_high"
    value="' . $realestatemanager_configuration['fotogallery']['high'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['fotogallery']['width'] = '<input type="text" name="fotogallery_width"
    value="' . $realestatemanager_configuration['fotogallery']['width'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['fotocategory']['high'] = '<input type="text" name="fotocategory_high"
    value="' . $realestatemanager_configuration['fotocategory']['high'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['fotocategory']['width'] = '<input type="text" name="fotocategory_width"
    value="' . $realestatemanager_configuration['fotocategory']['width'] .
            '" class="inputbox" size="4" maxlength="4" title="" />';

    $lists['page']['items'] = '<input type="text" name="page_items"
    value="' . $realestatemanager_configuration['page']['items'] .
            '" class="inputbox" size="3" maxlength="3" title="" />';

    $lists['license']['show'] = mosHTML::RadioList($yesno, 'license_show',
     'class="inputbox"', $realestatemanager_configuration['license']['show'], 'value', 'text');

    $txt = $realestatemanager_configuration['license']['text'];
    $lists['rent_form'] = $realestatemanager_configuration['rent_form'];

    $lists['rent_form'] = $realestatemanager_configuration['rent_form'];
    $lists['buy_form'] = $realestatemanager_configuration['buy_form'];

    //add for show in category picture
    $lists['cat_pic']['show'] = mosHTML::RadioList($yesno, 'cat_pic_show',
     'class="inputbox"', $realestatemanager_configuration['cat_pic']['show'], 'value', 'text');

    //add for show subcategory
    $lists['subcategory']['show'] = mosHTML::RadioList($yesno, 'subcategory_show',
     'class="inputbox"', $realestatemanager_configuration['subcategory']['show'], 'value', 'text');

    //******   begin approve_on_add  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['approve_on_add']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['approve_on_add']['show'] = mosHTML::RadioList($yesno, 'approve_on_add',
     'class="inputbox"', $realestatemanager_configuration['approve_on_add']['show'], 'value', 'text');


    $lists['approve_on_add']['registrationlevel'] = mosHTML::selectList($gtree,
     'approve_on_add_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end approve_on_add   *******
//******   begin publish_on_add  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['publish_on_add']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['publish_on_add']['show'] = mosHTML::RadioList($yesno, 'publish_on_add',
     'class="inputbox"', $realestatemanager_configuration['publish_on_add']['show'], 'value', 'text');


    $lists['publish_on_add']['registrationlevel'] = mosHTML::selectList($gtree,
     'publish_on_add_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end publish_on_add   *******
//
//******   begin publish_on_review  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['publish_on_review']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['publish_on_review']['show'] = mosHTML::RadioList($yesno, 'publish_on_review',
     'class="inputbox"', $realestatemanager_configuration['publish_on_review']['show'], 'value', 'text');


    $lists['publish_on_review']['registrationlevel'] = mosHTML::selectList($gtree,
     'publish_on_review_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end publish_on_review   *******
//********** RSS ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['rss']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['rss']['show'] = mosHTML::RadioList($yesno, 'rss_show', 'class="inputbox"',
     $realestatemanager_configuration['rss']['show'], 'value', 'text');
    $lists['rss']['registrationlevel'] = mosHTML::selectList($gtree, 'rss_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);
//********** END RSS ************
//********** wishlist ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['wishlist']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['wishlist']['show'] = mosHTML::RadioList($yesno, 'wishlist_show', 'class="inputbox"',
     $realestatemanager_configuration['wishlist']['show'], 'value', 'text');
    $lists['wishlist']['registrationlevel'] = mosHTML::selectList($gtree, 'wishlist_registrationlevel[]',
     'size="4" multiple="multiple"', 'value', 'text', $f);
//********** END wishlist ************
//********** Owners list ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['ownerslist']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['ownerslist']['show'] = mosHTML::RadioList($yesno, 'ownerslist_show', 'class="inputbox"',
     $realestatemanager_configuration['ownerslist']['show'], 'value', 'text');
    $lists['ownerslist']['registrationlevel'] = mosHTML::selectList($gtree,
     'ownerslist_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//********** END Owners list ************
    $f = array();
    $s = explode(',', $realestatemanager_configuration['owner']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['owner']['show'] = mosHTML::RadioList($yesno, 'owner_show', 'class="inputbox"',
     $realestatemanager_configuration['owner']['show'], 'value', 'text');
    $lists['owner']['registrationlevel'] = mosHTML::selectList($gtree,
     'owner_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

//******   begin show captcha_option  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['captcha_option']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['captcha_option']['show'] = mosHTML::RadioList($yesno, 'captcha_option',
     'class="inputbox"', $realestatemanager_configuration['captcha_option']['show'], 'value', 'text');


    $lists['captcha_option']['registrationlevel'] = mosHTML::selectList($gtree,
     'captcha_option_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end show captcha_option   *******
    //******   begin show captcha_booking_option  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['captcha_option_booking']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['captcha_option_booking']['show'] = mosHTML::RadioList($yesno, 'captcha_option_booking',
     'class="inputbox"', $realestatemanager_configuration['captcha_option_booking']['show'], 'value', 'text');

    $lists['captcha_option_booking']['registrationlevel'] = mosHTML::selectList($gtree,
     'captcha_option_booking_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end show captcha_booking_option   *******
    //******   begin show captcha_option_sendmessage  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['captcha_option_sendmessage']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['captcha_option_sendmessage']['show'] = mosHTML::RadioList($yesno, 'captcha_option_sendmessage',
     'class="inputbox"', $realestatemanager_configuration['captcha_option_sendmessage']['show'], 'value', 'text');


    $lists['captcha_option_sendmessage']['registrationlevel'] = mosHTML::selectList($gtree,
    'captcha_option_sendmessage_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end show captcha_option_sendmessage   *******

    $f = array();
    $s = explode(',', $realestatemanager_configuration['captcha_option_property_request']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['captcha_option_property_request']['show'] = mosHTML::RadioList($yesno, 'captcha_option_property_request',
     'class="inputbox"', $realestatemanager_configuration['captcha_option_property_request']['show'], 'value', 'text');


    $lists['captcha_option_property_request']['registrationlevel'] = mosHTML::selectList($gtree,
    'captcha_option_property_request_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    //******   begin show captcha_option_add_house  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['captcha_option_add_house']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['captcha_option_add_house']['show'] = mosHTML::RadioList($yesno, 'captcha_option_add_house',
     'class="inputbox"', $realestatemanager_configuration['captcha_option_add_house']['show'], 'value', 'text');


    $lists['captcha_option_add_house']['registrationlevel'] = mosHTML::selectList($gtree,
    'captcha_option_add_house_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end show captcha_option_add_house   *******

    //******   begin show map for search layout  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['searchlayout_map']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['searchlayout_map']['show'] = mosHTML::RadioList($yesno, 'searchlayout_map',
     'class="inputbox"', $realestatemanager_configuration['searchlayout_map']['show'], 'value', 'text');

    $lists['searchlayout_map']['registrationlevel'] = mosHTML::selectList($gtree,
     'searchlayout_map_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //*******   end show map for search layout   *******
    //******   begin show order by form for search layout  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['searchlayout_orderby']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['searchlayout_orderby']['show'] = mosHTML::RadioList($yesno, 'searchlayout_orderby',
     'class="inputbox"', $realestatemanager_configuration['searchlayout_orderby']['show'], 'value', 'text');

    $lists['searchlayout_orderby']['registrationlevel'] = mosHTML::selectList($gtree,
     'searchlayout_orderby_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    
    //******   begin show add serch button on frontend  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['search_button']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['search_button']['show'] = mosHTML::RadioList($yesno, 'search_button',
     'class="inputbox"', $realestatemanager_configuration['search_button']['show'], 'value', 'text');

    $lists['search_button']['registrationlevel'] = mosHTML::selectList($gtree,
     'search_button_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //****** end  begin show add serch button on frontend  *****

    //******   begin option access to edit house  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['option_edit']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['option_edit']['show'] = mosHTML::RadioList($yesno, 'option_edit',
     'class="inputbox"', $realestatemanager_configuration['option_edit']['show'], 'value', 'text');

    $lists['option_edit']['registrationlevel'] = mosHTML::selectList($gtree,
     'option_edit_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //*******   end option access to edit house   *******

//******   begin show search all houses  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['search_all_houses']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['search_all_houses']['show'] = mosHTML::RadioList($yesno, 'search_all_houses',
     'class="inputbox"', $realestatemanager_configuration['search_all_houses']['show'], 'value', 'text');

    $lists['search_all_houses']['registrationlevel'] = mosHTML::selectList($gtree,
     'search_all_houses_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end show search all houses  *******

//******   begin show search_alone_category  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['search_alone_category']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['search_alone_category']['show'] = mosHTML::RadioList($yesno, 'search_alone_category',
     'class="inputbox"', $realestatemanager_configuration['search_alone_category']['show'], 'value', 'text');

    $lists['search_alone_category']['registrationlevel'] = mosHTML::selectList($gtree,
     'search_alone_category_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
//*******   end show search_alone_category   *******
//******   begin show check in field in search block  *****
    $lists['search_check_in_show'] = mosHTML::RadioList($yesno, 'search_check_in_show', 'class="inputbox"', $realestatemanager_configuration['search_check_in_show'], 'value', 'text');
//******   end begin show check in field in search block  *****
//******   begin show check out field in search block  *****
    $lists['search_check_out_show'] = mosHTML::RadioList($yesno, 'search_check_out_show', 'class="inputbox"', $realestatemanager_configuration['search_check_out_show'], 'value', 'text');
//******   end begin show check out field in search block  *****
//******   begin show energy field  *****
    $lists['energy_field_show'] = mosHTML::RadioList($yesno, 'energy_field_show',
     'class="inputbox"', $realestatemanager_configuration['energy_field_show'], 'value', 'text');
//******   end begin show energy field  *****


//configure_backend

    $lists['add_email']['address'] = '<input type="text" name="add_email_address" value="'
     . $realestatemanager_configuration['add_email']['address'] .
      '" class="inputbox" size="50" maxlength="50" title="" />';
    $lists['review_email']['address'] = '<input type="text" name="review_email_address" value="'
     . $realestatemanager_configuration['review_email']['address'] .
      '" class="inputbox" size="50" maxlength="50" title="" />';
    $lists['rentrequest_email']['address'] =
     '<input type="text" name="rentrequest_email_address" value="'
     . $realestatemanager_configuration['rentrequest_email']['address'] .
      '" class="inputbox" size="50" maxlength="50" title="" />';
    $lists['buyingrequest_email']['address'] =
     '<input type="text" name="buyingrequest_email_address" value="'
     . $realestatemanager_configuration['buyingrequest_email']['address'] .
      '" class="inputbox" size="50" maxlength="50" title="" />';
    $lists['property_request_email']['address'] =
     '<input type="text" name="property_request_email_address" value="'
     . $realestatemanager_configuration['property_request_email']['address'] .
      '" class="inputbox" size="50" maxlength="50" title="" />';

    $lists['houseid']['auto-increment']['boolean'] =
     mosHTML::RadioList($yesno, 'houseid_auto_increment_boolean', 'class="inputbox"',
      $realestatemanager_configuration['houseid']['auto-increment']['boolean'], 'value', 'text');

    $lists['edocs']['allow'] = mosHTML::RadioList($yesno, 'edocs_allow', 'class="inputbox"',
     $realestatemanager_configuration['edocs']['allow'], 'value', 'text');

    $lists['edocs']['location'] = '<input type="text" name="edocs_location" value="'
     . $realestatemanager_configuration['edocs']['location']
      . '" class="inputbox" size="50" maxlength="50" title="" disabled="disabled"/>';

    $lists['photos']['location'] =
    '<input type="text" name="photos_location" value="/components/com_realestatemanager/photos/" '
    .' class="inputbox" size="50" maxlength="50" title="" disabled="disabled"/>';
    $lists['calendar']['placeholder'] = '<input type="text" name="calendar_placeholder" value="'
     . $realestatemanager_configuration['calendar']['placeholder']
     . '" class="inputbox" size="50" maxlength="50" title=""/>';

    //rent request answer
    $lists['rent_answer'] = mosHTML::RadioList($yesno, 'rent_answer', 'class="inputbox"',
     $realestatemanager_configuration['rent_answer'], 'value', 'text');

    $lists['buy_answer'] = mosHTML::RadioList($yesno, 'buy_answer', 'class="inputbox"',
     $realestatemanager_configuration['buy_answer'], 'value', 'text');

    $lists['property_request_answer'] = mosHTML::RadioList($yesno, 'property_request_answer', 'class="inputbox"',
     $realestatemanager_configuration['property_request_answer'], 'value', 'text');

    //notify before end rent
    $lists['rent_before_end_notify'] = mosHTML::RadioList($yesno,
     'rent_before_end_notify', 'class="inputbox"',
     $realestatemanager_configuration['rent_before_end_notify'], 'value', 'text');
    $lists['rent_before_end_notify_days'] =
     '<input type="text" name="rent_before_end_notify_days" value="'
     . $realestatemanager_configuration['rent_before_end_notify_days'] .
      '" class="inputbox" size="2" maxlength="2" title="" />';
    $lists['rent_before_end_notify_email'] =
     '<input type="text" name="rent_before_end_notify_email" value="'
     . $realestatemanager_configuration['rent_before_end_notify_email'] .
      '" class="inputbox" size="50" maxlength="50" title="" />';

    //show category for feature manager
    $lists['manager_feature_category'] =
     mosHTML::RadioList($yesno, 'manager_feature_category', 'class="inputbox"',
     $realestatemanager_configuration['manager_feature_category'], 'value', 'text');
     // $lists['calendar']['show'] = mosHTML::RadioList($yesno, 'calendar_show', 'class="inputbox"', $realestatemanager_configuration['calendar']['show'], 'value', 'text');
    //show sale_separator
    $lists['sale_separator'] = mosHTML::RadioList($yesno, 'sale_separator', 'class="inputbox"', $realestatemanager_configuration['sale_separator'], 'value', 'text');

    //********* add sale fraction price *********
    $lists['sale_fraction'] = mosHTML::RadioList($yesno, 'sale_fraction', 'class="inputbox"', $realestatemanager_configuration['sale_fraction'], 'value', 'text');
    //********* end add sale fraction price *********

    $lists['extra1'] = mosHTML::RadioList($yesno, 'extra1', 'class="inputbox"',
     $realestatemanager_configuration['extra1'], 'value', 'text');
    $lists['extra2'] = mosHTML::RadioList($yesno, 'extra2', 'class="inputbox"',
     $realestatemanager_configuration['extra2'], 'value', 'text');
    $lists['extra3'] = mosHTML::RadioList($yesno, 'extra3', 'class="inputbox"',
     $realestatemanager_configuration['extra3'], 'value', 'text');
    $lists['extra4'] = mosHTML::RadioList($yesno, 'extra4', 'class="inputbox"',
     $realestatemanager_configuration['extra4'], 'value', 'text');
    $lists['extra5'] = mosHTML::RadioList($yesno, 'extra5', 'class="inputbox"',
     $realestatemanager_configuration['extra5'], 'value', 'text');
    $lists['extra6'] = mosHTML::RadioList($yesno, 'extra6', 'class="inputbox"',
     $realestatemanager_configuration['extra6'], 'value', 'text');
    $lists['extra7'] = mosHTML::RadioList($yesno, 'extra7', 'class="inputbox"',
     $realestatemanager_configuration['extra7'], 'value', 'text');
    $lists['extra8'] = mosHTML::RadioList($yesno, 'extra8', 'class="inputbox"',
     $realestatemanager_configuration['extra8'], 'value', 'text');
    $lists['extra9'] = mosHTML::RadioList($yesno, 'extra9', 'class="inputbox"',
     $realestatemanager_configuration['extra9'], 'value', 'text');
    $lists['extra10'] = mosHTML::RadioList($yesno, 'extra10', 'class="inputbox"',
     $realestatemanager_configuration['extra10'], 'value', 'text');

    // add show house slider
    $lists['show_house_slider'] = mosHTML::RadioList($yesno, 'show_house_slider', 'class="inputbox"',
     $realestatemanager_configuration['show_house_slider'], 'value', 'text');
    // end add show house slider
    //07.07.17
    $lists['show_country_region_city_as_text_field'] = mosHTML::RadioList($yesno, 'show_country_region_city_as_text_field', 'class="inputbox"', $realestatemanager_configuration['show_country_region_city_as_text_field'], 'value', 'text');

    $m_list[] = mosHTML::makeOption('0', _REALESTATE_MANAGER_NOT_ADD_META);
    $m_list[] = mosHTML::makeOption('1', _REALESTATE_MANAGER_ADD_META_MANUAL);
    $m_list[] = mosHTML::makeOption('2', _REALESTATE_MANAGER_AUTOMATIC_GENERATE_META);
    $m_list[] = mosHTML::makeOption('3', _REALESTATE_MANAGER_AUTOMATIC_GENERATE_META_FOR_EMPTY);
    $lists['show_metadata'] = mosHTML::selectList($m_list, 'show_metadata', '', 
        'value', 'text', $realestatemanager_configuration['show_metadata']);

   $lists['currency'] = '<input type="text" name="currency" value="'
    . $realestatemanager_configuration['currency'] .
     '" class="inputbox" size="50" maxlength="500" title=""/>';
    $lists['allowed_exts'] = '<input type="text" name="allowed_exts" value="'
     . $realestatemanager_configuration['allowed_exts'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';
    $lists['allowed_exts_img'] = '<input type="text" name="allowed_exts_img" value="'
     . $realestatemanager_configuration['allowed_exts_img'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';

    $lists['allowed_exts_video'] = '<input type="text" name="allowed_exts_video" value="' .
     $realestatemanager_configuration['allowed_exts_video'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';
    $lists['allowed_exts_track'] = '<input type="text" name="allowed_exts_track" value="' .
     $realestatemanager_configuration['allowed_exts_track'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';

    //treb
    $lists['toronto_login'] = '<input type="text" name="toronto_login" value="' .
     $realestatemanager_configuration['toronto_login'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';
    $lists['toronto_password'] = '<input type="text" name="toronto_password" value="' .
     $realestatemanager_configuration['toronto_password'] .
      '" class="inputbox " size="50" maxlength="1500" title=""/>';
    $lists['api_key'] = '<input type="text" id="api_key" name="api_key" value="' .
     $realestatemanager_configuration['api_key'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';
    $lists['update']['map'] = '<input disabled="disabled" type="text" name="update_map" value="' .
         $realestatemanager_configuration['update']['map'] . '" class="inputbox treb_textinput" size="50" maxlength="50" title="" />';

    $lists['toronto_link_import'] = '<input disabled="disabled" type="text" name="update_map" value="' .
    $realestatemanager_configuration['toronto_link_import'] . '" class="inputbox treb_textinput" size="50" maxlength="50" title="" />';

    //rets
     $lists['mresdms_login'] = '<input type="text" name="mresdms_login" value="' .
     $realestatemanager_configuration['mresdms_login'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';
    $lists['mresdms_password'] = '<input type="text" name="mresdms_password" value="' .
     $realestatemanager_configuration['mresdms_password'] .
      '" class="inputbox " size="50" maxlength="1500" title=""/>';
    $lists['mresdms_link_import'] = '<input disabled="disabled" type="text" name="update_map" value="' .
    $realestatemanager_configuration['mresdms_link_import'] . '" class="inputbox treb_textinput" size="50" maxlength="50" title="" />';

    //matrix rets
     $lists['matrix_login'] = '<input type="text" name="matrix_login" value="' .
     $realestatemanager_configuration['matrix_login'] .
      '" class="inputbox" size="50" maxlength="1500" title=""/>';
    $lists['matrix_password'] = '<input type="text" name="matrix_password" value="' .
     $realestatemanager_configuration['matrix_password'] .
      '" class="inputbox " size="50" maxlength="1500" title=""/>';
    $lists['matrix_link_import'] = '<input disabled="disabled" type="text" name="update_map" value="' .
    $realestatemanager_configuration['matrix_link_import'] . '" class="inputbox treb_textinput" size="50" maxlength="50" title="" />';

    //watermark

    $lists['watermark']['show'] = mosHTML::RadioList($yesno, 'watermark_show',
     'class="inputbox"', $realestatemanager_configuration['watermark']['show'], 'value', 'text');

    $watermark_type[] = mosHTML::makeOption('text','Text');
    $watermark_type[] = mosHTML::makeOption('image','Image');
    $lists['watermark']['type'] = mosHTML::selectList($watermark_type,
     'watermark_type', '', 'value', 'text', $realestatemanager_configuration['watermark']['type']);

    $lists['watermark']['text'] = '<input type="text" name="watermark_text" value="' .
    $realestatemanager_configuration['watermark']['text'] . '" class="inputbox" size="50" maxlength="50" title="" />';

    $lists['watermark']['size'] = '<input type="number" name="watermark_size" value="' .
    $realestatemanager_configuration['watermark']['size'] . '" class="inputbox" size="50" maxlength="50" title="" />';

    $lists['watermark']['color'] = '<input type="text" name="watermark_color" value="' .
    $realestatemanager_configuration['watermark']['color'] . '" class="inputbox" max="300" size="50" maxlength="50" title="" />';

    $watermark_angle = array();
    $watermark_angle[] = mosHTML::makeOption(0,'0'.'&deg;');
    $watermark_angle[] = mosHTML::makeOption(45,'45'.'&deg;');
    $watermark_angle[] = mosHTML::makeOption(90,'90'.'&deg;');
    $lists['watermark']['angle'] = mosHTML::selectList($watermark_angle,
     'watermark_angle', '', 'value', 'text', $realestatemanager_configuration['watermark']['angle']);

    $watermark_position = array();
    $watermark_position[] = mosHTML::makeOption('top_right','Top right');
    $watermark_position[] = mosHTML::makeOption('top_left','Top left');
    $watermark_position[] = mosHTML::makeOption('center','Center');
    $watermark_position[] = mosHTML::makeOption('bottom_right','Bottom right');
    $watermark_position[] = mosHTML::makeOption('bottom_left','Bottom left');
    $lists['watermark']['position'] = mosHTML::selectList($watermark_position,
     'watermark_position', '', 'value', 'text', $realestatemanager_configuration['watermark']['position']);

    $lists['watermark']['opacity'] = '<input type="number" name="watermark_opacity" value="' .
    $realestatemanager_configuration['watermark']['opacity'] . '" class="inputbox" min="0" max="100"  title="" />';

    $lists['watermark']['min_width'] = '<input style="width:70px" type="number" name="watermark_min_width" value="' .
    $realestatemanager_configuration['watermark']['min_width'] . '" size="5" maxlength="5" class="inputbox" min="0" max="20000"  title="" />';

    $lists['watermark']['min_height'] = '<input style="width:70px" type="number" name="watermark_min_height" value="' .
    $realestatemanager_configuration['watermark']['min_height'] . '" size="5" maxlength="5" class="inputbox" min="0" max="20000"  title="" />';

    //watermark

    //slider
    $lists['slider']['height'] = '<input style="width:70px" type="number" name="slider_height" value="' .
    $realestatemanager_configuration['slider']['height'] . '" size="5" maxlength="5" class="inputbox" min="1" max="500"  title="" />';

    $slider_object_fit = array();
    $slider_object_fit[] = mosHTML::makeOption('cover','Filling in');
    $slider_object_fit[] = mosHTML::makeOption('contain','Proportionally');
    $lists['slider']['object_fit'] = mosHTML::selectList($slider_object_fit,
     'slider_object_fit', '', 'value', 'text', $realestatemanager_configuration['slider']['object_fit']);
    //slider

     //start pdf_print_logo
    $lists['pdf_print_logo']['show'] = mosHTML::RadioList($yesno, 'pdf_print_logo_show',
     'class="inputbox"', $realestatemanager_configuration['pdf_print_logo']['show'], 'value', 'text');
    //end pdf_print_logo

    //paypal
    $f = array();
    $s = explode(',', $realestatemanager_configuration['paypal_buy']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['paypal_buy_status']['show'] = mosHTML::RadioList($yesno, 'paypal_buy_status_show',
     'class="inputbox"', $realestatemanager_configuration['paypal_buy_status']['show'], 'value', 'text');
    $lists['paypal_buy']['registrationlevel'] = mosHTML::selectList($gtree,
     'paypal_buy_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    $lists['2checkout_buy_status']['registrationlevel'] = mosHTML::selectList($gtree,
     'paypal_buy_sale_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    $lists['stripe_buy_status']['registrationlevel'] = mosHTML::selectList($gtree,
     'paypal_buy_sale_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    $f = array();
    $s = explode(',', $realestatemanager_configuration['paypal_buy_sale']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);
    $lists['paypal_buy_status_sale']['show'] = mosHTML::RadioList($yesno, 'paypal_buy_status_sale_show',
     'class="inputbox"', $realestatemanager_configuration['paypal_buy_status_sale']['show'], 'value', 'text');
    $lists['paypal_buy_sale']['registrationlevel'] = mosHTML::selectList($gtree,
     'paypal_buy_sale_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    $lists['2checkout_buy_sale']['registrationlevel'] = mosHTML::selectList($gtree,
     'paypal_buy_sale_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);

    $lists['stripe_buy_sale']['registrationlevel'] = mosHTML::selectList($gtree,
     'paypal_buy_sale_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);


    $lists['paypal_real_or_test']['show'] =
     mosHTML::RadioList($yesno, 'paypal_real_or_test', 'class="inputbox"',
      $realestatemanager_configuration['paypal_real_or_test']['show'], 'value', 'text');

    $lists['special_price']['show'] = mosHTML::RadioList($yesno, 'special_price', 'class="inputbox"',
     $realestatemanager_configuration['special_price']['show'], 'value', 'text');


    $lists['google_openmap']['show'] = mosHTML::RadioList($google_openmap, 'google_openmap', 'class="inputbox"',
     $realestatemanager_configuration['google_openmap']['show'], 'value', 'text');


    //******   begin option for search form on nothing found page  *****
    $lists['search_form_on_nothing_found_page_show'] = mosHTML::RadioList($yesno, 'search_form_on_nothing_found_page_show',
     'class="inputbox"', $realestatemanager_configuration['search_form_on_nothing_found_page_show'], 'value', 'text');
    //******  end begin option for search form on nothing found page  *****
    //******   begin option for search form on search page  *****
    $lists['search_form_on_result_search_page_show'] = mosHTML::RadioList($yesno, 'search_form_on_result_search_page_show',
     'class="inputbox"', $realestatemanager_configuration['search_form_on_result_search_page_show'], 'value', 'text');
    //******  end begin option for search form on search page  *****
    //******   begin show add serch button on frontend  *****
    $f = array();
    $s = explode(',', $realestatemanager_configuration['search_button']['registrationlevel']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $lists['search_button']['show'] = mosHTML::RadioList($yesno, 'search_button',
     'class="inputbox"', $realestatemanager_configuration['search_button']['show'], 'value', 'text');

    $lists['search_button']['registrationlevel'] = mosHTML::selectList($gtree,
     'search_button_registrationlevel[]', 'size="4" multiple="multiple"', 'value', 'text', $f);
    //****** end  begin show add serch button on frontend  *****
    // end 29.06.17
    //04.07.17
    //***********begin show google captcha by default
    $lists['google_captcha_by_default_show'] = mosHTML::RadioList($yesno, 'google_captcha_by_default_show',
     'class="inputbox"', $realestatemanager_configuration['google_captcha_by_default_show'], 'value', 'text');
    //***********end begin show google captcha by default
    //07.07.17
    $lists['show_country_region_city_as_text_field'] = mosHTML::RadioList($yesno, 'show_country_region_city_as_text_field', 'class="inputbox"', $realestatemanager_configuration['show_country_region_city_as_text_field'], 'value', 'text');

    //add show house slider
    $lists['show_house_slider'] = mosHTML::RadioList($yesno, 'show_house_slider', 'class="inputbox"', $realestatemanager_configuration['show_house_slider'], 'value', 'text');
    //end add show house slider
    //PayPal

//     $lists['pay_pal_buy_business'] = '<input type="text" name="pay_pal_buy_business" value="' .
//      $realestatemanager_configuration['pay_pal_buy']['business'] .
//       '" class="inputbox" size="50" maxlength="500" title=""/>';
//    $lists['pay_pal_buy_return'] = '<input type="text" name="pay_pal_buy_return" value="'
//     . $realestatemanager_configuration['pay_pal_buy']['return'] .
//      '" class="inputbox" size="50" maxlength="500" title=""/>';
//     $lists['pay_pal_buy_image_url'] = '<input type="text" name="pay_pal_buy_image_url" value="' .
//      $realestatemanager_configuration['pay_pal_buy']['image_url'] .
//       '" class="inputbox" size="50" maxlength="500" title=""/>';
//     $lists['pay_pal_buy_cancel_return'] = '<input type="text" name="pay_pal_buy_cancel_return" value="' .
//      $realestatemanager_configuration['pay_pal_buy']['cancel_return'] .
//       '" class="inputbox" size="50" maxlength="500" title=""/>';
//     $lists['pay_pal_rent_business'] = '<input type="text" name="pay_pal_rent_business" value="'
//      . $realestatemanager_configuration['pay_pal_rent']['business'] .
//       '" class="inputbox" size="50" maxlength="500" title=""/>';
//     $lists['pay_pal_rent_return'] = '<input type="text" name="pay_pal_rent_return" value="'
//      . $realestatemanager_configuration['pay_pal_rent']['return'] .
//       '" class="inputbox" size="50" maxlength="500" title=""/>';
//     $lists['pay_pal_rent_image_url'] = '<input type="text" name="pay_pal_rent_image_url" value="'
//      . $realestatemanager_configuration['pay_pal_rent']['image_url'] .
//       '" class="inputbox" size="50" maxlength="500" title=""/>';
//     $lists['pay_pal_rent_cancel_return'] = '<input type="text" name="pay_pal_rent_cancel_return" value="'
//      . $realestatemanager_configuration['pay_pal_rent']['cancel_return'] .
//       '" class="inputbox" size="50" maxlength="500" title=""/>';
    $lists['cancel_url'] = stripslashes($realestatemanager_configuration['cancel_url']);
    $lists['success_url'] = stripslashes($realestatemanager_configuration['success_url']);
    //***************************************************

    $view_house = getLayoutsRem('com_realestatemanager','view_house');
    $lists['view_house'] = mosHTML::selectList($view_house, 'view_house', 'size="1" ',
     'value', 'text', $realestatemanager_configuration['view_house']);

  /////////////////////////////////////////////////////
    //Options for order default
    $default_order_option = array();
    $default_order_option[] = JHtml::_('select.option', "date", "Date");
    $default_order_option[] = JHtml::_('select.option', "price", "Price");
    $default_order_option[] = JHtml::_('select.option', "htitle", "Title");
    $default_order_option[] = JHtml::_('select.option', "ordering", "User order");

    // $default_layout_option = array();
    // $default_layout_option[] = JHtml::_('select.option', "default", "Default");
    // $default_layout_option[] = JHtml::_('select.option', "advanced", "Advanced");

    //Options for select list on search page
    $two_select_option = array();
    $two_select_option[] = JHtml::_('select.option', "1", "Show & search");
    //$two_select_option[] = JHtml::_('select.option', "2", "Search");
    $two_select_option[] = JHtml::_('select.option', "3", "None");

    //Options for checkbox on search page
    $three_select_option = array();
    $three_select_option[] = JHtml::_('select.option', "1", "Show & search");
    $three_select_option[] = JHtml::_('select.option', "2", "Search");
    $three_select_option[] = JHtml::_('select.option', "3", "None");

    $rel_data_columns_lg = array();
    $rel_data_columns_lg[] = JHtml::_('select.option', "1", "1");
    $rel_data_columns_lg[] = JHtml::_('select.option', "2", "2");
    $rel_data_columns_lg[] = JHtml::_('select.option', "3", "3");
    $rel_data_columns_lg[] = JHtml::_('select.option', "4", "4");

    $rel_data_columns_md = array();
    $rel_data_columns_md[] = JHtml::_('select.option', "1", "1");
    $rel_data_columns_md[] = JHtml::_('select.option', "2", "2");
    $rel_data_columns_md[] = JHtml::_('select.option', "3", "3");
    $rel_data_columns_md[] = JHtml::_('select.option', "4", "4");

    $rel_data_columns_sm = array();
    $rel_data_columns_sm[] = JHtml::_('select.option', "1", "1");
    $rel_data_columns_sm[] = JHtml::_('select.option', "2", "2");
    $rel_data_columns_sm[] = JHtml::_('select.option', "3", "3");

    $rel_data_columns_xs = array();
    $rel_data_columns_xs[] = JHtml::_('select.option', "1", "1");
    $rel_data_columns_xs[] = JHtml::_('select.option', "2", "2");

    $money_ditlimer = array();
    $money_ditlimer[] = JHtml::_('select.option', ".", "Point (12.134.123,12)");
    $money_ditlimer[] = JHtml::_('select.option', ",", "Comma (12,134,123.12)");
    $money_ditlimer[] = JHtml::_('select.option', "space", "Space (12 134 123,12)");
    $money_ditlimer[] = JHtml::_('select.option', "other", "Your delimiter: ");
    $price_unit_show = array(_REALESTATE_PRICE_UNIT_SHOW_AFTER, _REALESTATE_PRICE_UNIT_SHOW_BEFORE);
    $price_unit_show = null;
    $price_unit_show[] = mosHTML::makeOption('1', _REALESTATE_PRICE_UNIT_SHOW_AFTER);
    $price_unit_show[] = mosHTML::makeOption('0', _REALESTATE_PRICE_UNIT_SHOW_BEFORE);

    //Redirect settings on frontend page
    $redirect_option    =   array();
    $redirect_option[]  =   JHtml::_('select.option', "1", "Default");
    $redirect_option[]  =   JHtml::_('select.option', "2", "Redirect to all houses page");
    $redirect_option[]  =   JHtml::_('select.option', "3", "Redirect to input link");

    $selecter = '';
    switch ($realestatemanager_configuration['price_format']) {
        case '.':
            $selecter = '.';
            break;
        case ',':
            $selecter = ',';
            break;
        case '&nbsp;':
            $selecter = 'space';
            break;
        default:
            $selecter = 'other';
    }

    //redirect rent options
    $redirect_rent_selecter = '';
    switch ($realestatemanager_configuration['input_link_rent']) {
        case '1':
            $redirect_rent_selecter = '1';
            break;
        case '2':
            $redirect_rent_selecter = '2';
            break;
        default:
            $redirect_rent_selecter = '3';
    }

    //redirect sale options
    $redirect_sale_selecter = '';
    switch ($realestatemanager_configuration['input_link_sale']) {
        case '1':
            $redirect_sale_selecter = '1';
            break;
        case '2':
            $redirect_sale_selecter = '2';
            break;
        default:
            $redirect_sale_selecter = '3';
    }

    //19.09.17
    //******** for advanced layout ********
    //******** add option row houses lg resolution **********
    $lists['rel_data_columns_adv_lg'] = mosHTML::selectList($rel_data_columns_lg, 'rel_data_columns_adv_lg', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_adv_lg']);
    //********end add option row houses lg resolution **********
    //******** add option row houses md resolution **********
    $lists['rel_data_columns_adv_md'] = mosHTML::selectList($rel_data_columns_md, 'rel_data_columns_adv_md', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_adv_md']);
    //********end add option row vehousehicle md resolution **********
    //******** add option row house sm resolution **********
    $lists['rel_data_columns_adv_sm'] = mosHTML::selectList($rel_data_columns_sm, 'rel_data_columns_adv_sm', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_adv_sm']);
    //********end add option row houses sm resolution **********
    ////******** add option row houses xs resolution **********
    $lists['rel_data_columns_adv_xs'] = mosHTML::selectList($rel_data_columns_xs, 'rel_data_columns_adv_xs', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_adv_xs']);
    //********end add option row houses xs resolution **********
    //******** end for advanced layout ********

    //******** for map layout ********
    //******** add option row houses lg resolution **********
    $lists['rel_data_columns_map_lg'] = mosHTML::selectList($rel_data_columns_lg, 'rel_data_columns_map_lg', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_map_lg']);
    //********end add option row houses lg resolution **********
    //******** add option row houses md resolution **********
    $lists['rel_data_columns_map_md'] = mosHTML::selectList($rel_data_columns_md, 'rel_data_columns_map_md', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_map_md']);
    //********end add option row houses md resolution **********
    //******** add option row houses sm resolution **********
    $lists['rel_data_columns_map_sm'] = mosHTML::selectList($rel_data_columns_sm, 'rel_data_columns_map_sm', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_map_sm']);
    //********end add option row houses sm resolution **********
    ////******** add option row houses xs resolution **********
    $lists['rel_data_columns_map_xs'] = mosHTML::selectList($rel_data_columns_xs, 'rel_data_columns_map_xs', 'size="1"', 'value', 'text', $realestatemanager_configuration['rel_data_columns_map_xs']);
    //********end add option row houses xs resolution **********
    //******** end for map layout ********

    //redirect rent
    $lists['redirect_rent'] = mosHTML::selectList($redirect_option, 'redirect_rent', 'size="1"  onchange="set_rent_options(this)"', 'value', 'text', $redirect_rent_selecter);
    $lists['patern_rent'] = '<input id="patern_rent" type="hidden" readonly="true" value="' . $realestatemanager_configuration['input_link_rent'] . '" name="patern_rent" size="2"/>';
    //end redirect rent
    //redirect sale
    $lists['redirect_sale'] = mosHTML::selectList($redirect_option, 'redirect_sale', 'size="1"  onchange="set_sale_options(this)"', 'value', 'text', $redirect_sale_selecter);
    $lists['patern_sale'] = '<input id="patern_sale" type="hidden" readonly="true" value="' . $realestatemanager_configuration['input_link_sale'] . '" name="patern_sale" size="2"/>';
    //end redirect sale
    
    $lists['redirect_property_request'] = mosHTML::selectList($redirect_option, 'redirect_property_request', 'size="1"  onchange="set_property_request_options(this)"', 'value', 'text', $redirect_sale_selecter);
    $lists['patern_property_request'] = '<input id="patern_property_request" type="hidden" readonly="true" value="' . $realestatemanager_configuration['input_link_property_request'] . '" name="patern_property_request" size="2"/>';

    // 1 - affter 0 - beffore
    $lists['price_unit_show'] = mosHTML::RadioList($price_unit_show, 'price_unit_show',
     'class="inputbox"', $realestatemanager_configuration['price_unit_show'], 'value', 'text');
    $lists['money_ditlimer'] = mosHTML::selectList($money_ditlimer, 'money_select',
     'size="1"  onchange="set_pricetype(this)"', 'value', 'text', $selecter);
    $lists['date_format'] = '<input type="text" name="date_format" value="'
     . $realestatemanager_configuration['date_format'] . '" class="inputbox"  title="" />';
    $lists['datetime_format'] = '<input type="hidden" name="datetime_format" value="'
     . $realestatemanager_configuration['datetime_format'] . '" class="inputbox" title="" />';

     
     //******** add option show keywords in search page **********
    $lists['search_form_search_keyword_field_show'] = mosHTML::selectList($two_select_option, 'search_form_search_keyword_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_search_keyword_field_show']);
    //******** end add option show keywords in search page **********
     //******** add option Check In in search page **********
    $lists['search_form_check_in_field_show'] = mosHTML::selectList($two_select_option, 'search_form_check_in_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_check_in_field_show']);
    //******** end add option Check In in search page **********
    //******** add option Check out search page **********
    $lists['search_form_check_out_field_show'] = mosHTML::selectList($two_select_option, 'search_form_check_out_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_check_out_field_show']);
    //******** end add option Check out search page **********
    //******** add option Price search page **********
    $lists['search_form_price_field_show'] = mosHTML::selectList($two_select_option, 'search_form_price_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_price_field_show']);
    //******** end add option Price in search page **********

    //******** add option Radiuse range in search page **********
    $lists['search_form_radiuse_range_field_show'] = mosHTML::selectList($three_select_option, 'search_form_radiuse_range_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_radiuse_range_field_show']);

    $h_range = array();
    $h_range[] = mosHtml::makeOption(0, _REALESTATE_MANAGER_LABEL_MOD_MAP_SEARCH_RANGE);
    $h_ranges = explode(',', _REALESTATE_MANAGER_OPTION_SEARCH_RADIUS_RANGE_LISTING);
    foreach ( $h_ranges as $range ) {
        $h_range[] = mosHtml::makeOption($range, $range);
    }

    $lists['search_form_radiuse_range'] = mosHTML::selectList($h_range, 'search_form_radiuse_range',
      'class="inputbox" size="1"', 'value', 'text', $realestatemanager_configuration['search_form_radiuse_range']);
    //******** end add option Radiuse range in search page **********

    //******** add option rooms number search page **********
    $lists['search_rooms_num_field_show'] = mosHTML::selectList($two_select_option, 'search_rooms_num_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_rooms_num_field_show']);
    //******** end add option rooms number search page **********
    //******** add option bathrooms number search page **********
    $lists['search_bathrooms_num_field_show'] = mosHTML::selectList($two_select_option, 'search_bathrooms_num_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_bathrooms_num_field_show']);
    //******** end add option bathrooms number search page **********
    //******** add option bedrooms number search page **********
    $lists['search_bedrooms_num_field_show'] = mosHTML::selectList($two_select_option, 'search_bedrooms_num_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_bedrooms_num_field_show']);
    //******** end add bedoption rooms number search page **********
    //******** add option lot size search page **********
    $lists['search_lot_size_field_show'] = mosHTML::selectList($two_select_option, 'search_lot_size_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_lot_size_field_show']);
    //******** end add option lot size search page **********
    //******** add option house size search page **********
    $lists['search_house_size_field_show'] = mosHTML::selectList($two_select_option, 'search_house_size_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_house_size_field_show']);
    //******** end add option house size search page **********
    //******** add option category search page **********
    $lists['search_form_category_field_show'] = mosHTML::selectList($two_select_option, 'search_form_category_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_category_field_show']);
    //******** end add option category in search page **********
    //******** add option listing type search page **********
    $lists['search_form_listing_type_field_show'] = mosHTML::selectList($two_select_option, 'search_form_listing_type_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_listing_type_field_show']);
    //******** end add option listing type in search page **********
    //******** add option listing status search page **********
    $lists['search_form_listing_status_field_show'] = mosHTML::selectList($two_select_option, 'search_form_listing_status_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_listing_status_field_show']);
    //******** end add option listing status in search page **********
     //******** add option property type search page **********
    $lists['search_form_property_type_field_show'] = mosHTML::selectList($two_select_option, 'search_form_property_type_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_property_type_field_show']);
    //******** end add option property type in search page **********
    //******** add option Property ID search page **********
    $lists['search_form_propertyid_field_show'] = mosHTML::selectList($three_select_option, 'search_form_propertyid_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_propertyid_field_show']);
    //******** end add option Property ID in search page **********
    //******** add option Description search page **********
    $lists['search_form_comment_field_show'] = mosHTML::selectList($three_select_option, 'search_form_comment_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_comment_field_show']);
    //******** end add option Description in search page **********
    //******** add option Title search page **********
    $lists['search_form_title_field_show'] = mosHTML::selectList($three_select_option, 'search_form_title_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_title_field_show']);
    //******** end add option Title in search page **********
    //******** add option House size search page **********
    $lists['search_form_house_size_field_show'] = mosHTML::selectList($three_select_option, 'search_form_house_size_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_house_size_field_show']);
    //******** end add option House size in search page **********
    //******** add option Address search page **********
    $lists['search_form_address_field_show'] = mosHTML::selectList($three_select_option, 'search_form_address_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_address_field_show']);
    //******** end add option Address in search page **********
    $sel = $two_select_option;
    if($realestatemanager_configuration['show_country_region_city_as_text_field']==0){
        $sel = $three_select_option;
    }
    //******** add option Country search page **********
    $lists['search_form_country_field_show'] = mosHTML::selectList($sel, 'search_form_country_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_country_field_show']);
    //******** end add option Country in search page **********
    //******** add option Region search page **********
    $lists['search_form_region_field_show'] = mosHTML::selectList($sel, 'search_form_region_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_region_field_show']);
    //******** end add option Region in search page **********
    //******** add option City search page **********
    $lists['search_form_city_field_show'] = mosHTML::selectList($sel, 'search_form_city_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_city_field_show']);
    //******** end add option City in search page **********
    //******** add Custom Dropdown Field 6 options **********
    $lists['extra6_advanced'] = mosHTML::selectList($two_select_option, 'extra6_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra6_advanced']);
    //******** end add Custom Dropdown Field 6 options **********
    //******** add Custom Dropdown Field 7 options **********
    $lists['extra7_advanced'] = mosHTML::selectList($two_select_option, 'extra7_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra7_advanced']);
    //******** end add Custom Dropdown Field 7 options **********
    //******** add Custom Dropdown Field 8 options **********
    $lists['extra8_advanced'] = mosHTML::selectList($two_select_option, 'extra8_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra8_advanced']);
    //******** end add Custom Dropdown Field 8 options **********
    //******** add Custom Dropdown Field 6 options **********
    $lists['extra9_advanced'] = mosHTML::selectList($two_select_option, 'extra9_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra9_advanced']);
    //******** end add Custom Dropdown Field 9 options **********
    //******** add Custom Dropdown Field 10 options **********
    $lists['extra10_advanced'] = mosHTML::selectList($two_select_option, 'extra10_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra10_advanced']);
    //******** end add Custom Dropdown Field 10 options **********
    //******** add option Zipcode search page **********
    $lists['search_form_zipcode_field_show'] = mosHTML::selectList($three_select_option, 'search_form_zipcode_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_zipcode_field_show']);
    //******** end add option Zipcode in search page **********
    //******** add option Lot size search page **********
    // $lists['search_form_lot_size_field_show'] = mosHTML::selectList($three_select_option, 'search_form_lot_size_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_lot_size_field_show']);
    //******** end add option Lot size in search page **********
    //******** add option Owner search page **********
    $lists['search_form_owner_field_show'] = mosHTML::selectList($three_select_option, 'search_form_owner_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_owner_field_show']);
    //******** end add option Owner in search page **********
    //******** add option Exactly to all search page **********
    $lists['search_form_exactly_to_all_field_show'] = mosHTML::selectList($three_select_option, 'search_form_exactly_to_all_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_exactly_to_all_field_show']);
    //******** end add option Exactly to all in search page **********
    //******** add option Garages search page **********
    $lists['search_form_garages_field_show'] = mosHTML::selectList($three_select_option, 'search_form_garages_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_garages_field_show']);
    //******** end add option Garages in search page **********
    //******** add option Built year search page **********
    $lists['search_form_build_year_field_show'] = mosHTML::selectList($three_select_option, 'search_form_build_year_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_build_year_field_show']);
    //******** end add option Built year in search page **********
    //******** add option Contacts search page **********
    $lists['search_form_contacts_field_show'] = mosHTML::selectList($three_select_option, 'search_form_contacts_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_contacts_field_show']);
    //******** end add option Contacts in search page **********
    //******** add option Agent name search page **********
    $lists['search_form_agent_field_show'] = mosHTML::selectList($three_select_option, 'search_form_agent_field_show', 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_agent_field_show']);
    //******** end add option Agent name in search page **********
    //******** end add Custom Dropdown Field 1 options **********
    $lists['extra1_advanced'] = mosHTML::selectList($three_select_option, 'extra1_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra1_advanced']);
    //******** end add Custom Dropdown Field 1 options **********
    //******** end add Custom Dropdown Field 2 options **********
    $lists['extra2_advanced'] = mosHTML::selectList($three_select_option, 'extra2_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra2_advanced']);
    //******** end add Custom Dropdown Field 2 options **********
    //******** end add Custom Dropdown Field 3 options **********
    $lists['extra3_advanced'] = mosHTML::selectList($three_select_option, 'extra3_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra3_advanced']);
    //******** end add Custom Dropdown Field 3 options **********
    //******** end add Custom Dropdown Field 4 options **********
    $lists['extra4_advanced'] = mosHTML::selectList($three_select_option, 'extra4_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra4_advanced']);
    //******** end add Custom Dropdown Field 4 options **********
    //******** end add Custom Dropdown Field 5 options **********
    $lists['extra5_advanced'] = mosHTML::selectList($three_select_option, 'extra5_advanced', 'size="1"', 'value', 'text', $realestatemanager_configuration['extra5_advanced']);
    //******** end add Custom Dropdown Field 5 options **********

    //******** add select list for feature in search tab **********
    $query = "SELECT name, id FROM #__rem_feature";
    $database->setQuery($query);
    $features = $database->loadObjectList();

    foreach ($features as $feature) {
        if(!isset($realestatemanager_configuration['search_form_features']["$feature->id"]) )
             $realestatemanager_configuration['search_form_features']["$feature->id"] = 3 ;
        $lists["search_form_features_$feature->id"] = mosHTML::selectList($three_select_option, "search_form_features_$feature->id", 'size="1"', 'value', 'text', $realestatemanager_configuration['search_form_features']["$feature->id"]);
    }
    //******** end add select list for feature in search tab **********

    //******** add option default search layout **********
    $lists['default_search_layout'] = getSearchLayout();
    //******** end add option default search layout **********
    //******** add option order default **********
    $lists['order_by_default'] = mosHTML::selectList($default_order_option, 'order_by_default', 'size="1"', 'value', 'text', $realestatemanager_configuration['order_by_default']);
    //******** end add option order default **********

    $f = array();

    $s = explode(',', $realestatemanager_configuration['plugin_name_select']);
    for ($i = 0; $i < count($s); $i++)
        $f[] = mosHTML::makeOption($s[$i]);

    $plugin_name_select = array();
    $plugin_name_mass = getSelect();
    $selecter_plugin_name = array();
    if(!$plugin_name_mass){
        $lists['plugin_name_select'] = '<div class="alert_rem alert-error">
                            <button type="button" class="close" data-dismiss="alert">×</button>'
                            . _REALESTATE_MANAGER_MESSAGE_INSTALL_PLUGIN .
                        '</div>';
    }else{

        foreach ($plugin_name_mass as $value) {
            if(isset($realestatemanager_configuration['plugin_name_select'])
             && !empty($realestatemanager_configuration['plugin_name_select'])
              && in_array($value, $s)){
                $selecter_plugin_name[] = $value;
            }
            $plugin_name_select[] = JHtml::_('select.option', "$value", "$value");
        }

        $lists['plugin_name_select'] = mosHTML::selectList($plugin_name_select,
         'plugin_name_select[]', 'multiple="multiple" size="' .count($plugin_name_mass) .'"', 'value', 'text', $selecter_plugin_name);
    }


    HTML_realestatemanager::showConfiguration($lists, $option, $txt);
}

//----------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------



  function getSearchLayout(){
    global $realestatemanager_configuration;
        $all_houses_layout = getLayoutsRem('com_realestatemanager','show_search_house');
        $layouts = Array();
        $layouts[] = JHtml::_('select.option', '', 'Use Global');
        foreach($all_houses_layout as $value){
            $layouts[] = JHtml::_('select.option', "$value", "$value");
        }

        return mosHTML::selectList($layouts, 'default_search_layout', 'size="1"', 'value', 'text', $realestatemanager_configuration['default_search_layout']);

        // return JHtml::_('select.genericlist', $layouts, 'default_search_layout', 'size="1"', 'value', 'text', $realestatemanager_configuration['default_search_layout']);
  }

  function getSelect(){
                                $db = JFactory::getDBO();
                    $condtion = array(0 => '\'payment\'');
                    $condtionatype = join(',',$condtion);
                    if(JVERSION >= '1.6.0')
                    {
                        $query = "SELECT extension_id as id,name,element,enabled as published
                                  FROM #__extensions
                                  WHERE folder in ($condtionatype) AND enabled=1";
                    }
                    else
                    {
                        $query = "SELECT id,name,element,published
                                  FROM #__plugins
                                  WHERE folder in ($condtionatype) AND published=1";
                    }
                    $db->setQuery($query);
                    $gatewayplugin = $db->loadobjectList();
                                        if(!getNamePluginForValSelect($gatewayplugin)){

                                        }else{
                                            return getNamePluginForValSelect($gatewayplugin);
                                        }

       }

 function getNamePluginForValSelect($gatewayplugin){

          $new_plugin_name = array();

          $retr = count($gatewayplugin);

           if($retr>0){

                for($i=0;$i<$retr;$i++){
                      $plugin_name_strtolower = mb_strtolower(trim($gatewayplugin[$i]->name));
                      $plugin_name_mass = explode(" ", $plugin_name_strtolower);
                      $lenght_mass = count($plugin_name_mass);
                      array_push($new_plugin_name,$plugin_name_mass[$lenght_mass-1]);
                }
                return $new_plugin_name;

          }
          else{
                return false;
          }

      }

//----------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------------------

//****************   begin for manage reviews   *******************


//*********************   end for manage reviews   ****************************
function publish_manage_review($cid, $publish, $option) {
    global $database;

    $database->setQuery("UPDATE #__rem_review SET published = $publish WHERE id  = $cid ");
    $database->execute();

    mosRedirect("index.php?option=$option&task=manage_review");
}


function rent($option, $cid) {
    global $database, $my;
    if (!is_array($cid) || count($cid) !== 1) {
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM ."'); window.history.go(-1);</script>\n";
        exit;
    }
    $cid_house = implode(',', $cid);
    $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
            "l.rent_return as rent_return, l.rent_until as rent_until, " .
            "l.user_name as user_name, l.user_email as user_email " .
            "\nFROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
            "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
            "\nLEFT JOIN #__rem_rent AS l ON l.id = a.fk_rentid" .
            "\nWHERE a.id = $cid_house";
    $database->setQuery($select);
    $house1 = $database->loadObject();
    if ($house1->listing_type != 1) {
              ?>
              <script type = "text/JavaScript" language = "JavaScript">
                  alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT ?>");
                  window.history.go(-1); 
              </script>
              <?php

              exit;
    }
    $cids = implode(',', $cid);
    $cids = getAssociateHouses($cids);
    $houses_assoc[]= $house1;
    if($cids){
        $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
                "l.rent_return as rent_return, l.rent_until as rent_until, " .
                "l.user_name as user_name, l.user_email as user_email " .
                "\nFROM #__rem_houses AS a" .
                "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
                "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
                "\nLEFT JOIN #__rem_rent AS l ON l.id = a.fk_rentid" .
                "\nWHERE a.id in ($cids)";
        $database->setQuery($select);
        $houses_assoc = $database->loadObjectList();
        //for rent or not
        $count = count($houses_assoc);
        for ($i = 0; $i < $count; $i++) {
            if ($houses_assoc[$i]->listing_type != 1) {
                ?>
                <script type = "text/JavaScript" language = "JavaScript">
                    alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT_ASOC ?>");
                    window.history.go(-1);
                </script>
                <?php

                exit;
            }
        }
    }
// get list of categories

    $userlist[] = mosHTML::makeOption('-1', '----------');
    $database->setQuery("SELECT id AS value, name AS text from #__users ORDER BY name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    $usermenu = mosHTML::selectList($userlist, 'userid', 'class="inputbox" size="1"', 'value', 'text', '-1');

    HTML_realestatemanager::showRentHouses($option, $house1, $houses_assoc, $usermenu, "rent");
}


function edit_rent($option, $cid) {

    global $database, $my, $os_rem_state;

    if (!is_array($cid) || count($cid) !== 1) {
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM ."'); window.history.go(-1);</script>\n";
        exit;
    }

    $cid_house = implode(',', $cid);
    $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
            "l.rent_return as rent_return, l.rent_until as rent_until, " .
            "l.user_name as user_name, l.user_email as user_email " .
            "\nFROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
            "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
            "\nLEFT JOIN #__rem_rent AS l ON l.fk_houseid = a.id" .
            "\nWHERE a.id = $cid_house";
    $database->setQuery($select);
    $house1 = $database->loadObject();
    if ($house1->listing_type != 1) {
      ?>
      <script type = "text/JavaScript" language = "JavaScript">
          alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT ?>");
          window.history.go(-1);
      </script>
      <?php
      exit;
    }



    $cids = implode(',', $cid);
    $cids = getAssociateHouses($cids);
    if($cids == "") $cids = implode(',', $cid);
    $houses_rents_assoc= array();
    $title_assoc = array();
    if($cids){


        $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
                "l.rent_return as rent_return, l.rent_until as rent_until, " .
                "l.user_name as user_name, l.user_email as user_email " .
                "\nFROM #__rem_houses AS a" .
                "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
                "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
                "\nLEFT JOIN #__rem_rent AS l ON l.fk_houseid = a.id" .
                "\nWHERE a.id in ($cids)";
        $database->setQuery($select);
        $houses_rents_assoc = $database->loadObjectList();

        $select = "SELECT a.htitle  " .
                "\nFROM #__rem_houses AS a" .
                "\nLEFT JOIN #__rem_rent AS l ON l.fk_houseid = a.id" .
                "\nWHERE a.id in ($cids)";
        $database->setQuery($select);
        $title_assoc = $database->loadObjectList();

        $count = count($houses_rents_assoc);
        for ($i = 0; $i < $count; $i++) {
            if ($houses_rents_assoc[$i]->listing_type != 1) {
                ?>
                <script type = "text/JavaScript" language = "JavaScript">
                    alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT_ASOC ?>");
                    window.history.go(-1);
                </script>
                <?php
                exit;
            }
        }

        $is_rent_out = false;
        for ($i = 0; $i < count($houses_rents_assoc); $i++) {

          if ( $houses_rents_assoc[$i]->rent_from != '' && $houses_rents_assoc[$i]->rent_return == '' )
          {
            $is_rent_out = true ;
            break ;
          }
        }

        if ( !$is_rent_out ){
            ?>
            <script type = "text/JavaScript" language = "JavaScript">
                alert("<?php echo _REALESTATE_MANAGER_ADMIN_HOUSE_NOT_IN_RENT ?>");
                window.history.go(-1);
            </script>
            <?php
            exit;
        }

      //check rent_return == null count for all assosiate
        $ids = explode(',', $cids);
        $rent_count = -1;
        $all_assosiate_rent = array();
        $count = count($ids);
        for ($i = 0; $i < $count; $i++) {

            $query = "SELECT * FROM #__rem_rent WHERE fk_houseid = " . $ids[$i] .
             " and rent_return is null ORDER BY rent_from";
            // print_r($query);
            $database->setQuery($query);
            $all_assosiate_rent_item = $database->loadObjectList();

            if ( $rent_count != -1 && $rent_count != count($all_assosiate_rent_item) )
            {
                ?>
                <script type = "text/JavaScript" language = "JavaScript">
                    alert("<?php echo _REALESTATE_MANAGER_ADMIN_RENT_ASSOCIATED ?>");
                    window.history.go(-1);
                </script>
                <?php

                exit;
            }
            $rent_count = count($all_assosiate_rent_item);
           // print_r($rent_count);exit;
            $all_assosiate_rent[] = $all_assosiate_rent_item;
        }
    }

    // get list of users
    $userlist[] = mosHTML::makeOption('-1', '----------');
    $database->setQuery("SELECT id AS value, name AS text from #__users ORDER BY name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    $usermenu = mosHTML::selectList($userlist, 'userid', 'class="inputbox" size="1"', 'value', 'text', '-1');

    HTML_realestatemanager::editRentHouses($option, $house1, $houses_rents_assoc,
     $title_assoc, $usermenu, $all_assosiate_rent, "edit_rent");
}


function rent_return($option, $cid) {

    global $database, $my, $os_rem_state;

    if (!is_array($cid) || count($cid) !== 1) {
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM .
          "'); window.history.go(-1);</script>\n";
        exit;
    }

    $cid_house = implode(',', $cid);
    $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
            "l.rent_return as rent_return, l.rent_until as rent_until, " .
            "l.user_name as user_name, l.user_email as user_email " .
            "\nFROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
            "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
            "\nLEFT JOIN #__rem_rent AS l ON l.fk_houseid = a.id" .
            "\nWHERE a.id = $cid_house";
    $database->setQuery($select);
    $house1 = $database->loadObject();
    if ($house1->listing_type != 1) {
              ?>
              <script type = "text/JavaScript" language = "JavaScript">
                  alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT ?>");
                  window.history.go(-1);
              </script>
              <?php

              exit;
    }
    $cids = implode(',', $cid);
    $cids = getAssociateHouses($cids);
    if($cids == "") $cids = implode(',', $cid);
    $houses_rents_assoc = array();
    $title_assoc = array();
    if($cids){
        $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
                "l.rent_return as rent_return, l.rent_until as rent_until, " .
                "l.user_name as user_name, l.user_email as user_email " .
                "\nFROM #__rem_houses AS a" .
                "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
                "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
                "\nLEFT JOIN #__rem_rent AS l ON l.fk_houseid = a.id" .
                "\nWHERE a.id in ($cids)";
        $database->setQuery($select);
        $houses_rents_assoc = $database->loadObjectList();

        $select = "SELECT a.htitle " .
                "\nFROM #__rem_houses AS a" .
                "\nLEFT JOIN #__rem_rent AS l ON l.fk_houseid = a.id" .
                "\nWHERE a.id in ($cids)";
        $database->setQuery($select);
        $title_assoc = $database->loadObjectList();


        $count = count($houses_rents_assoc);
        for ($i = 0; $i < $count; $i++) {
            if ($houses_rents_assoc[$i]->listing_type != 1) {
                ?>
                <script type = "text/JavaScript" language = "JavaScript">
                    alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT_ASOC ?>");
                    window.history.go(-1);
                </script>
                <?php
                exit;
            }
        }


        $is_rent_out = false;
        for ($i = 0; $i < count($houses_rents_assoc); $i++) {

          if ( $houses_rents_assoc[$i]->rent_from != '' && $houses_rents_assoc[$i]->rent_return == '' )
          {
            $is_rent_out = true ;
            break ;
          }
        }

        if ( !$is_rent_out )
        {
            ?>
            <script type = "text/JavaScript" language = "JavaScript">
                alert("<?php echo _REALESTATE_MANAGER_ADMIN_ALERT_NOT_IN_RENT ?>");
                window.history.go(-1);
            </script>
            <?php
            exit;
        }

        //check rent_return == null count for all assosiate
      $ids = explode(',', $cids);
      $rent_count = -1;
      $all_assosiate_rent = array();
      $count = count($ids);
      for ($i = 0; $i < $count; $i++) {

          $query = "SELECT * FROM #__rem_rent WHERE fk_houseid = " . $ids[$i] .
           " and rent_return is null ORDER BY rent_from";
          // print_r($query);
          $database->setQuery($query);
          $all_assosiate_rent_item = $database->loadObjectList();

          if ( $rent_count != -1 && $rent_count != count($all_assosiate_rent_item) )
          {
              ?>
              <script type = "text/JavaScript" language = "JavaScript">
                  alert("<?php echo _REALESTATE_MANAGER_ADMIN_RENT_ASSOCIATED ?>");
                  window.history.go(-1);
              </script>
              <?php
              exit;
          }
          $rent_count = count($all_assosiate_rent_item);
         // print_r($rent_count);exit;
          $all_assosiate_rent[] = $all_assosiate_rent_item;
      }
    }
    // get list of users
    $userlist[] = mosHTML::makeOption('-1', '----------');
    $database->setQuery("SELECT id AS value, name AS text from #__users ORDER BY name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    $usermenu = mosHTML::selectList($userlist, 'userid', 'class="inputbox" size="1"', 'value', 'text', '-1');

    HTML_realestatemanager::editRentHouses($option, $house1, $houses_rents_assoc,
     $title_assoc, $usermenu, $all_assosiate_rent, "rent_return");
}


function saveRent($option, $cids, $task = "") {
    global $database, $realestatemanager_configuration, $os_rem_state;

    if (!is_array($cids) || count($cids) < 1) {
      echo "<script> alert('Select an item to rent'); window.history.go(-1);</script>\n";
      exit;
    }
    $id = mosGetParam($_POST, 'id');
    $ids[] = $id ;
    $ids = implode(',', $ids);
    $ids = getAssociateHouses($ids);
    if($ids == "")  $ids = $id;
    $ids = explode(',', $ids);
    //print_r($_POST);exit;
    $data = JFactory::getDBO();
    $houseid = mosGetParam($_POST, 'houseid');
    $rent_from = date_transform_rem(mosGetParam($_POST, 'rent_from'),"to");
    $rent_until = date_transform_rem(mosGetParam($_POST, 'rent_until',""),"to");
    $how_many_weeks = mosGetParam($_POST, 'how_many_weeks',0);
    $how_many_monthes = mosGetParam($_POST, 'how_many_monthes',0);
    if ($how_many_weeks == 0 && $how_many_monthes == 0 && $rent_from > $rent_until) {
      echo "<script> alert('" . $rent_from . " more then " . $rent_until . "'); window.history.go(-1); </script>\n";
      exit();
    }

    $house = new mosRealEstateManager($database);
    $house->load( $id );

    if ($task == "edit_rent") {
      $check_vids = implode(',', $cids);
      if ($check_vids == 0 || count($cids) > 1){
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM ."'); window.history.go(-1);</script>\n";
        exit;
      }
      $rent = new mosRealEstateManager_rent($database);
      $a_ids = explode(',', $cids[0]);
      for($j = 0, $k = count($a_ids); $j < $k; $j++){
        $rent->load($a_ids[$j]);
        $query = "SELECT * FROM #__rem_rent where fk_houseid= " . $rent->fk_houseid . " AND rent_return is NULL ";
        $database->setQuery($query);
        $rentTerm = $database->loadObjectList();

        $rent_from_shrink_to = $rent_from = substr($rent_from, 0, 10);
        if($rent_until != "" && $rent_until != 0 ) $rent_until_shrink_to = substr($rent_until, 0, 10);
        else $rent_until_shrink_to =  calculate_rent_until_REM ( $rent_from, $rent_until,$how_many_weeks,$how_many_monthes) ;

        foreach ($rentTerm as $oneTerm){
          if ($a_ids[$j] == $oneTerm->id)
            continue;
          $oneTerm->rent_from = substr($oneTerm->rent_from, 0, 10);
          $oneTerm->rent_until = substr($oneTerm->rent_until, 0, 10);
          $returnMessage = checkRentDayNightREM (($oneTerm->rent_from),
            ($oneTerm->rent_until), $rent_from_shrink_to, $rent_until_shrink_to,$house->rent_by);
          if($a_ids[$j] !== $oneTerm->id && strlen($returnMessage) > 0){
            echo "<script> alert('$returnMessage'); window.history.go(-1); </script>\n";
            exit;
          }
        }
        $rent->rent_from = $rent_from_shrink_to;
        if (mosGetParam($_POST, 'rent_until') != "" || (isset($rent_until_shrink_to) && $rent_until_shrink_to != "") ){
          $rent->rent_until = $rent_until_shrink_to ;
        } else{
            $rent->rent_until = null;
        }
        $rent->how_many_weeks = $how_many_weeks;
        $rent->how_many_monthes = $how_many_monthes;
        $rent->fk_houseid = $ids[$i];
        // $rent->fk_houseid = $id;
        $userid = mosGetParam($_POST, 'userid');
            if ($userid == "-1") {
                $rent->user_name = mosGetParam($_POST, 'user_name', '');
                $rent->user_email = mosGetParam($_POST, 'user_email', '');
            } else {
                $rent->getRentTo(intval($userid));
            }

            if (!$rent->check($rent)) {
                echo "<script> alert('" . addslashes($rent->getError()) .
                  "'); window.history.go(-1); </script>\n";
                exit();
            }

            if (!$rent->store()) {
                echo "<script> alert('" . addslashes($rent->getError()) .
                 "'); window.history.go(-1); </script>\n";
                exit();
            }
            $rent->checkin();
          }
    }

    if ($task !== "edit_rent") {
      $checkh = mosGetParam($_POST, 'checkHouse');
      if ($checkh != "on") {
          echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM .
            "'); window.history.go(-1);</script>\n";
          exit;
      }
      for($i = 0, $n = count($ids); $i < $n; $i++){
          $rent = new mosRealEstateManager_rent($database);
            $query = "SELECT * FROM #__rem_rent where fk_houseid= " . $ids[$i] . " AND rent_return is NULL ";
            $database->setQuery($query);
            $rentTerm = $database->loadObjectList();
            $rent_from_shrink_to = $rent_from = substr($rent_from, 0, 10);

            if($rent_until != "" && $rent_until != 0 ) $rent_until_shrink_to = substr($rent_until, 0, 10);
            else $rent_until_shrink_to =  calculate_rent_until_REM ( $rent_from, $rent_until,$how_many_weeks,$how_many_monthes) ;

            foreach ($rentTerm as $oneTerm){
                $oneTerm->rent_from = substr($oneTerm->rent_from, 0, 10);
                $oneTerm->rent_until = substr($oneTerm->rent_until, 0, 10);
                $returnMessage = checkRentDayNightREM (($oneTerm->rent_from),
                  ($oneTerm->rent_until), $rent_from_shrink_to, $rent_until_shrink_to,$house->rent_by);
                if(strlen($returnMessage) > 0){
                    echo "<script> alert('$returnMessage'); window.history.go(-1); </script>\n";
                    exit;
                }
            }

            $rent->rent_from = $rent_from_shrink_to;
            $rent->rent_until = $rent_until_shrink_to;
            $rent->how_many_weeks = $how_many_weeks;
            $rent->how_many_monthes = $how_many_monthes;
            $rent->fk_houseid = $ids[$i];
            $userid = mosGetParam($_POST, 'userid');

            if ($userid == "-1") {
                $rent->user_name = mosGetParam($_POST, 'user_name', '');
                $rent->user_email = mosGetParam($_POST, 'user_email', '');
            } else {
                $rent->getRentTo(intval($userid));
                $rent->fk_userid = intval($userid);
            }

            if (!$rent->check($rent)) {
                echo "<script> alert('" . addslashes($rent->getError()) .
                 "'); window.history.go(-1); </script>\n";
                exit();
            }

            if (!$rent->store()) {
                echo "<script> alert('" . addslashes($rent->getError()) .
                 "'); window.history.go(-1); </script>\n";
                exit();
            }

            $rent->checkin();
            $house = new mosRealEstateManager($database);
            $house->load($ids[$i]);
            $house->fk_rentid = $rent->id;
            $house->store();
            $house->checkin();
        }
    }
        mosRedirect("index.php?option=$option");
}

function saveRent_return($option, $lids) {

    global $database, $os_rem_state;

    $houseid = mosGetParam($_POST, 'houseid');
    $id = mosGetParam($_POST, 'id');
    $check_vids = implode(',', $lids);
      if ($check_vids == 0 || count($lids) > 1)
      {
          echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM .
            "'); window.history.go(-1);</script>\n";
          exit;
      }

    $r_ids = explode(',', $lids[0]);
    $rent = new mosRealEstateManager_rent($database);
    for ($i = 0, $n = count($r_ids); $i < $n; $i++) {

        $rent->load($r_ids[$i]);

        if ($rent->rent_return != null) {
            echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_RENT_ALERT_RETURNED .
             "'); window.history.go(-1);</script>\n";
            exit;
        }

        $rent->rent_return = date("Y-m-d H:i:s");

        if (!$rent->check($rent)) {
            echo "<script> alert('" . addslashes($rent->getError()) .
             "'); window.history.go(-1); </script>\n";
            exit;
        }

        if (!$rent->store()) {
            echo "<script> alert('" . addslashes($rent->getError()) .
             "'); window.history.go(-1); </script>\n";
            exit;
        }

        $rent->checkin();

        $is_update_house_lend = true;
        if ($is_update_house_lend) {

            $house = new mosRealEstateManager($database);
            $house->load($id);

            $query = "SELECT * FROM #__rem_rent where fk_houseid= " . $id . " AND rent_return is NULL";
            $database->setQuery($query);
            $info_rents = $database->loadObjectList();

            if (isset($info_rents[0])) {
                $house->fk_rentid = $info_rents[0]->id;
                $is_update_house_lend = FALSE;
            } else {
                $house->fk_rentid = 0;
            }

            $house->store();
            $house->checkin();
        }
    }

        mosRedirect("index.php?option=$option");
}

function import($option) {
    global $database, $my, $os_rem_state;

    if(mosGetParam($_REQUEST, 'import_type') != '5'
        && mosGetParam($_REQUEST, 'import_type') != '6'
        && mosGetParam($_REQUEST, 'import_type') != '7'){
      $file = file($_FILES['import_file']['tmp_name']);
    }
    $catid = mosGetParam($_REQUEST, 'import_catid', array(0),"ARRAY");
   //***********************   begin add for XML format   ***************************************
    $type = mosGetParam($_REQUEST, 'import_type');
    switch ($type) {
        //CSV=='1' XML=='2' FullXML=='4' TREB=='5'
        case '1':
            $retVal = mosRealEstateManagerImportExport::importHousesCSV($file, $catid);
            HTML_realestatemanager:: showImportResult($retVal, $option);
            break;
        case '2':
            $retVal = mosRealEstateManagerImportExport::importHousesXML($_FILES['import_file']['tmp_name'], $catid);
            HTML_realestatemanager:: showImportResult($retVal, $option);
            break;
        case '4':
            $retVal = mosRealEstateManagerImportExport::importHousesXML($_FILES['import_file']['tmp_name'], null);
            HTML_realestatemanager:: showImportResult($retVal, $option);
            break;
        case '5':
            $retVal = mosRealEstateManagerImportExport::importHousesXMLFromToronto($catid);
            HTML_realestatemanager:: showImportResult($retVal, $option);
            break;
        case '6':
            $retVal = mosRealEstateManagerImportExport::importHousesXMLFromMRESDMS($catid);
            HTML_realestatemanager:: showImportResult($retVal, $option);
            break;
        case '7':
            $retVal = mosRealEstateManagerImportExport::importHousesFromMatrixRets($catid);
            HTML_realestatemanager:: showImportResult($retVal, $option);
            break;
     //***********************   end add for XML format   *****************************************
    }
}

function importExportHouses($option) {
    global $database;
    // get list of categories
    $categories = array();

    $query = "SELECT  id ,name, parent_id as parent"
            . "\n FROM #__rem_main_categories"
            . "\n WHERE section='com_realestatemanager'"
            . "\n AND published > 0"
            . "\n ORDER BY parent_id, ordering";

    $database->setQuery($query);
    $rows = $database->loadObjectList();

    // establish the hierarchy of the categories
    $children = array();
    // first pass - collect children
    foreach ($rows as $v) {
        $pt = $v->parent;
        $list = @$children[$pt] ? $children[$pt] : array();
        array_push($list, $v);
        $children[$pt] = $list;
    }

    // second pass - get an indent list of the items
    $list = houseLibraryTreeRecurse(0, '', array(), $children);

    foreach ($list as $i => $item) {
        $item->text = $item->treename;
        $item->value = $item->id;
        $list[$i] = $item;
    }

    $categories = array_merge($categories, $list);

    //if (count($categories) < 1) {
    //  mosRedirect("index.php?option=com_realestatemanager&section=categories", _REALESTATE_MANAGER_ADMIN_IMPEXP_ADD);
    //}

    $impclist = mosHTML::selectList($categories, 'import_catid[]',
     'class="inputbox" multiple  id="import_catid"', 'value', 'text', 0);
    $expclist = mosHTML::selectList($categories, 'export_catid[]',
     'class="inputbox" multiple  id="export_catid"', 'value', 'text', 0);

    $params = array();
    $params['import']['category'] = $impclist;
    $params['export']['category'] = $expclist;

    $importtypes[0] = mosHTML::makeOption('0', _REALESTATE_MANAGER_ADMIN_PLEASE_SEL);
    $importtypes[1] = mosHTML::makeOption('1', _REALESTATE_MANAGER_ADMIN_FORMAT_CSV);
    $importtypes[2] = mosHTML::makeOption('2', _REALESTATE_MANAGER_ADMIN_FORMAT_XML);
    $importtypes[4] = mosHTML::makeOption('4', _REALESTATE_MANAGER_ADMIN_FULL_XML);
    $importtypes[5] = mosHTML::makeOption('5', _REALESTATE_MANAGER_ADMIN_CONFIG_TREB_IMPORT);
    $importtypes[6] = mosHTML::makeOption('6', _REALESTATE_MANAGER_ADMIN_CONFIG_RETS_IMPORT);
    $importtypes[7] = mosHTML::makeOption('7', _REALESTATE_MANAGER_ADMIN_CONFIG_MATRIX_RETS_IMPORT);

    $params['import']['type'] = mosHTML::selectList($importtypes, 'import_type',
     'id="import_type" class="inputbox" size="1" onchange = "impch();"', 'value', 'text', 0);

    $exporttypes[0] = mosHTML::makeOption('0', _REALESTATE_MANAGER_ADMIN_PLEASE_SEL);
    $exporttypes[1] = mosHTML::makeOption('1', _REALESTATE_MANAGER_ADMIN_FORMAT_CSV);
    $exporttypes[2] = mosHTML::makeOption('2', _REALESTATE_MANAGER_ADMIN_FORMAT_XML);
    $exporttypes[4] = mosHTML::makeOption('4', _REALESTATE_MANAGER_ADMIN_FULL_XML);

    $params['export']['type'] = mosHTML::selectList($exporttypes, 'export_type',
     'id="export_type" class="inputbox" size="1" onchange="expch();"', 'value', 'text', 0);
    HTML_realestatemanager::showImportExportHouses($params, $option);
}

function showLanguageManager($option) {
    global $database, $mainframe, $mosConfig_list_limit, $menutype, $mosConfig_absolute_path;

    $section = "com_realestatemanager";

    $search['const'] = mosGetParam($_POST, 'search_const', '');
    $search['const_value'] = mosGetParam($_POST, 'search_const_value', '');
    $search['languages'] = $mainframe->getUserStateFromRequest(
      "search_languages{$option}", 'search_languages', '');
    $search['sys_type']  = $mainframe->getUserStateFromRequest(
      "search_sys_type{$option}", 'search_sys_type', '');

    $where_query = array();
    if ($search['const'] != '')
        $where_query[] = "c.const LIKE '%" . $search['const'] . "%'";
    if ($search['const_value'] != '')
        $where_query[] = "cl.value_const LIKE '%" . $search['const_value'] . "%'";
    if ($search['languages'] != '')
        $where_query[] = "cl.fk_languagesid = " .$database->quote( $search['languages']) . " ";
    if ($search['sys_type'] != '')
        $where_query[] = "c.sys_type LIKE '" . $search['sys_type'] . "'";

    $where = "";
    $i = 0;
    if (count($where_query) > 0)
        $where = "WHERE ";
    foreach ($where_query as $item) {
        if ($i == 0)
            $where .= "( $item ) ";
        else
            $where .= "AND ( $item ) ";
        $i++;
    }

    $query = "SELECT cl.id, cl.value_const, c.sys_type, l.title, c.const ";
    $query .= "FROM #__rem_const_languages as cl ";
    $query .= "LEFT JOIN #__rem_languages AS l ON cl.fk_languagesid=l.id ";
    $query .= "LEFT JOIN #__rem_const AS c ON cl.fk_constid=c.id $where";

    $database->setQuery($query);
    $const_languages = $database->loadObjectList();

    $sectionid = $mainframe->getUserStateFromRequest("sectionid{$section}{$section}", 'sectionid', 0);
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$section}limitstart", 'limitstart', 0);
    $levellimit = $mainframe->getUserStateFromRequest("view{$option}limit$menutype", 'levellimit', 10);

    $total = count($const_languages);

    $pageNav = new JPagination($total, $limitstart, $limit); 

    $const_languages = array_slice($const_languages, $pageNav->limitstart, $pageNav->limit);

    $query = "SELECT sys_type FROM #__rem_const GROUP BY sys_type";
    $database->setQuery($query);
    $sys_types = $database->loadObjectList();

    $sys_type_row[] = mosHTML::makeOption('', '--Select sys type--');
    foreach ($sys_types as $sys_type) {
        $sys_type_row[] = mosHTML::makeOption($sys_type->sys_type, $sys_type->sys_type);
    }

    $search['sys_type'] = mosHTML::selectList($sys_type_row, 'search_sys_type',
     'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value',
      'text', $search['sys_type']);

    $query = "SELECT id, title FROM #__rem_languages";
    $database->setQuery($query);
    $languages = $database->loadObjectList();

    $languages_row[] = mosHTML::makeOption('', '--Select language--');
    foreach ($languages as $language) {
        $languages_row[] = mosHTML::makeOption($language->id, $language->title);
    }

    $search['languages'] = mosHTML::selectList($languages_row, 'search_languages',
     'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value',
      'text', $search['languages']);

    if(protectInjectionWithoutQuote('task','') == 'loadLang'){

        loadConstRem();
        language_check();
    }

    HTML_realestatemanager::showLanguageManager($const_languages, $pageNav, $search);
}

function editLanguageManager($section = '', $cid = 0) {
    global $database, $my, $acl, $realestatemanager_configuration;
    global $mosConfig_absolute_path, $mosConfig_live_site, $os_rem_state;

    $row = new mosRealEstateManager_language($database); 
    // load the row from the db table
    $row->load($cid);

    $query = "SELECT * FROM #__rem_const WHERE id = " . $row->fk_constid;
    $database->setQuery($query);
    $const = $database->loadObject();

    $lists['const'] = $const->const;
    $lists['sys_type'] = $const->sys_type;

    $query = "SELECT title FROM #__rem_languages WHERE id = " . $row->fk_languagesid;
    $database->setQuery($query);
    $language = $database->loadResult();

    $lists['languages'] = $language;

    HTML_realestatemanager::editLanguageManager($row, $lists);
}

function saveLanguageManager() {
    global $database, $mosConfig_absolute_path, $os_rem_state;

    $row = new mosRealEstateManager_language($database); 

    $post = JFactory::getApplication()->input->post->getArray(array(), null, 'raw');    
    if (!$row->bind($post)) {
        echo "<script> alert(\"" . $row->getError() . "\"); window.history.go(-1); </script>\n";
        exit();
    }

    if (!$row->check()) {
        echo "<script> alert(\"" . $row->getError() . "\"); window.history.go(-1); </script>\n";
        exit();
    }

    if (!$row->store()) {
        echo "<script> alert(\"" . $row->getError() . "\"); window.history.go(-1); </script>\n";
        exit();
    }

    mosRedirect('index.php?option=com_realestatemanager&section=language_manager');
}

function cancelLanguageManager() {
    global $database, $mosConfig_absolute_path;

    $row = new mosRealEstateManager_language($database); 
    $row->bind($_POST);
    mosRedirect('index.php?option=com_realestatemanager&section=language_manager');
}

function showFeaturedManager($option) {
    global $database, $mainframe, $mosConfig_list_limit, $menutype, $lists;

    $section = "com_realestatemanager";

    $query = "SELECT * FROM #__rem_feature";
    $database->setQuery($query);
    $features = $database->loadObjectList();

    $sectionid = $mainframe->getUserStateFromRequest("sectionid{$section}{$section}", 'sectionid', 0);
    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$section}limitstart", 'limitstart', 0);
    $levellimit = $mainframe->getUserStateFromRequest("view{$option}limit$menutype", 'levellimit', 10);

    $total = count($features);

    $pageNav = new JPagination($total, $limitstart, $limit); 

    $features = array_slice($features, $pageNav->limitstart, $pageNav->limit);

    HTML_realestatemanager::showFeaturedManager($features, $pageNav, $lists);
}

function editFeaturedManager($section = '', $uid = 0) {
    global $database, $my, $acl, $realestatemanager_configuration;
    global $mosConfig_absolute_path, $mosConfig_live_site, $os_rem_state;

    $row = new mosRealEstateManager_feature($database); 
    // load the row from the db table
    $row->load($uid);

    // build the html radio buttons for published
    $lists['published'] = mosHTML::yesnoRadioList('published', 'class="inputbox"', $row->published);

    //Select list for number of doors
    $categories[] = mosHtml::makeOption("", _REALESTATE_MANAGER_OPTION_SELECT);
    if(trim($realestatemanager_configuration['featuredmanager']['placeholder'] != '')){
        $categ = explode(',', $realestatemanager_configuration['featuredmanager']['placeholder']);
        for ($i = 0; $i < count($categ); $i++){
            $categories[] = mosHtml::makeOption($categ[$i], $categ[$i]);
        }
    }
    $lists['categories'] = mosHTML::selectList($categories, 'categories',
     'class="inputbox" size="1"', 'value', 'text', $row->categories);

    HTML_realestatemanager::editFeaturedManager($row, $lists);
}

function saveFeaturedManager() {
    global $database, $mosConfig_absolute_path, $os_rem_state;

    $row = new mosRealEstateManager_feature($database); 

    $app = JFactory::getApplication();
    $jinput = $app->input;
    $post = $jinput->getArray($_POST);

    // Trim whitespaces in category name. Else the same category names will not match, for example, at sorting amenities when adding a new amenity.
    $post['categories'] = trim( $post['categories'] );

    if (!$row->bind($post)) {
        echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";
        exit();
    }

    if (!$row->check()) {
        echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";
        exit();
    }

    if (!$row->store()) {
        echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";
        exit();
    }else {
        //add new features constant
        $query = "insert into #__rem_const ( `const`,`sys_type`) values('_REALESTATE_MANAGER_FEATURE".$row->id."','Features')";
        $database->setQuery($query);
        $database->execute();

        $const_id = $database->insertid();

        $query = "select * from #__rem_languages";
        $database->setQuery($query);
        $defined_languages = $database->loadobjectList();
        foreach ($defined_languages as $defined_language) {
            $query = "insert into #__rem_const_languages ( `fk_constid`,`fk_languagesid`,`value_const`) values(".$const_id.",".$defined_language->id .",".$database->Quote($row->name).")";
            $database->setQuery($query);
            $database->execute();
        }
        rem_add_new_features_constant();

        // Add default options ('3') for advanced search layout fields on front-end in realestatemanager.class.conf.php
        $realestatemanager_configuration['search_form_features'][$row->id]='3';
        mosRealestateManagerOthers::setParams();
    }
    mosRedirect('index.php?option=com_realestatemanager&section=featured_manager');
}

function cancelFeaturedManager() {
    global $database;
    $row = new mosRealEstateManager_feature($database); 
    $row->bind($_POST);
    mosRedirect('index.php?option=com_realestatemanager&section=featured_manager');
}

function removeFeaturedManager($section, $fids) {
    global $database;

    if (count($fids) < 1) {
        echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_ONE_AMENITY_ALERT ."'); window.history.go(-1);</script>\n";
        exit;
    }

    foreach ($fids as $fid){
        removeFeaturedManagerFromDB($fid);
    }

    mosRedirect('index.php?option=com_realestatemanager&section=featured_manager');
}

function removeFeaturedManagerFromDB($fid) {
    global $database, $my, $mosConfig_absolute_path;

    $database->setQuery("SELECT image_link FROM #__rem_feature WHERE id=$fid");
    $image_link = $database->loadResult();
    unlink($mosConfig_absolute_path . '/components/com_realestatemanager/featured_ico/' . $image_link);

    $sql = "DELETE FROM #__rem_feature WHERE id = $fid ";
    $database->setQuery($sql);
    $database->execute();

    $sql = "DELETE FROM #__rem_feature_houses WHERE fk_featureid = $fid ";
    $database->setQuery($sql);
    $database->execute();

    //delete features laguages constant
    $query = "select * from #__rem_const where `const` = '_REALESTATE_MANAGER_FEATURE".$fid."'";
    $database->setQuery($query);
    $rem_consts = $database->loadobjectList();
    foreach ($rem_consts as $rem_const) {
        $query = "DELETE FROM #__rem_const_languages where `fk_constid` = ".$rem_const->id ;
        $database->setQuery($query);
        $database->execute();
    }

    //delete features constant
    $query = "DELETE FROM #__rem_const where `const` = '_REALESTATE_MANAGER_FEATURE".$fid."'";
    $database->setQuery($query);
    $database->execute();

}

function publishFeaturedManager($section, $featureid = null, $cid = null, $publish = 1) {
    global $database, $my, $os_rem_state;

    if (!is_array($cid))
        $cid = array();
    if ($featureid)
        $cid[] = $featureid;

    if (count($cid) < 1) {
        $action = $publish ? _PUBLISH : _DML_UNPUBLISH;
        echo "<script> alert('" . _DML_SELECTCATTO . " $action'); window.history.go(-1);</script>\n";
        exit;
    }

    $cids = implode(',', $cid);

    $query = "UPDATE #__rem_feature SET published='$publish'"
            . "\nWHERE id IN ($cids)";
    $database->setQuery($query);
    $database->execute();

    if (count($cid) == 1) {
        $row = new mosRealEstateManager_feature($database); 
        $row->checkin($cid[0]);
    }
    mosRedirect('index.php?option=com_realestatemanager&section=featured_manager');
}

function save_featured_category($option) {
    global $realestatemanager_configuration,$database, $os_rem_state;

    if(trim($realestatemanager_configuration['featuredmanager']['placeholder']) !== trim(mosGetParam($_POST,
            'featuredmanager_placeholder', "")) ){
        $realestatemanager_configuration['featuredmanager']['placeholder'] = mosGetParam($_POST, 'featuredmanager_placeholder', "");
        if( trim($realestatemanager_configuration['featuredmanager']['placeholder']) !== "" ) {
            rem_add_new_features_category_constant();
        }
        mosRealestateManagerOthers::setParams();
    }
}

function orders($option) {

    global $database, $my, $user_configuration, $acl, $mosConfig_live_site, $mosConfig_absolute_path;
    global $mainframe, $mosConfig_list_limit;
    $search = '';
    $order = 'ORDER BY o.id  DESC';
    $where = '';
     if(isset($_REQUEST['search'])) {
        $search = $_REQUEST['search'];
        $where = "WHERE o.email LIKE '%{$search}%' OR o.name LIKE '%{$search}%'";
    }
    if(isset($_GET['orderby']) && $_GET['orderby'] == 'user') {
        $order = 'ORDER BY o.name';
    }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'email') {
        $order = 'ORDER BY o.email ASC';
    }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'status') {
        $order = "ORDER BY o.status = 'Completed' DESC";
    }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'order_date') {
        $order = "ORDER BY o.order_date  DESC";
    }elseif(isset($_GET['orderby']) && $_GET['orderby'] == 'id') {
        $order = "ORDER BY o.id  ASC";
    }

    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);

    if(isset($_REQUEST['order_details'])){
        if(!$order && !$where)
        $order = "ORDER BY o.order_date  DESC";
        if(isset($_GET['orderby']) && $_GET['orderby'] == 'order_date') {
            $order = "ORDER BY o.order_date  ASC";
        }
        if($where)
            $where = "WHERE o.email LIKE '%{$search}%' OR o.name LIKE '%{$search}%'
                        AND fk_order_id = ".$_REQUEST['order_id']."";
        else
            $where = "WHERE fk_order_id = ".$_REQUEST['order_id']."";
        $sql = "SELECT count(*)  ".
                " FROM #__rem_orders_details AS o ".
                " LEFT JOIN #__users AS u ".
                " ON o.fk_user_id = u.id ".
                " LEFT JOIN #__rem_houses AS g ".
                " ON o.fk_house_id = g.id ".
                " LEFT JOIN #__rem_orders AS remo ".
                " ON remo.id = o.fk_order_id ".
                $where." ".$order ;
        $database->setQuery($sql);
        $total = $database->loadResult();
        $pageNav = new JPagination($total, $limitstart, $limit);
        $sql = "SELECT u.username, ".
                       "o.*, ".
                       "g.price, g.priceunit, g.htitle ".
               " FROM #__rem_orders_details AS o ".
               " LEFT JOIN #__users AS u ".
               " ON o.fk_user_id = u.id ".
               " LEFT JOIN #__rem_houses AS g ".
               " ON o.fk_house_id = g.id ".
                " LEFT JOIN #__rem_orders AS remo ".
               " ON remo.id = o.fk_order_id ".
                $where." ".$order. " LIMIT " . $pageNav->limitstart." , ". $pageNav->limit;
        $database->setQuery($sql);
        $orders = $database->loadobjectList();

        HTML_realestatemanager::orders_details($orders, $search, $pageNav);
    }else{
        $sql = "SELECT count(*)  ".
                " FROM #__rem_orders AS o ".
                " LEFT JOIN #__users AS u ".
                " ON o.fk_user_id = u.id ".
                " LEFT JOIN #__rem_houses AS h ".
                " ON o.fk_house_id = h.id ". $where ." ".$order;
        $database->setQuery($sql);
        $total = $database->loadResult();
        $pageNav = new JPagination($total, $limitstart, $limit);
        $sql = "SELECT u.id as userId, u.username, ".
           "o.*, ".
           "h.price as h_price, h.priceunit as h_price_unit, h.htitle ".
           " FROM #__rem_orders AS o ".
           " LEFT JOIN #__users AS u ".
           " ON o.fk_user_id = u.id ".
           " LEFT JOIN #__rem_houses AS h ".
           " ON o.fk_house_id = h.id ". $where.
            $order. " LIMIT " . $pageNav->limitstart." , ". $pageNav->limit;
        $database->setQuery($sql);
        $orders = $database->loadobjectList();

        HTML_realestatemanager::orders($orders, $search, $pageNav);
    }
}

function updateOrderStatus() {
    global $database, $os_rem_state;

    $orderId = $_POST['cb'];
    $status = $_POST['order_status'];
    $status = $status[$orderId[0]];
    $option = $_POST['option'];
    $sql = "UPDATE #__rem_orders SET status = '".$status."' WHERE id = ".$orderId[0]."";
    $database->setQuery($sql);
    $database->execute();
    $sql = "SELECT * FROM #__rem_orders WHERE id = ".$orderId[0]."";
    $database->setQuery($sql);
    $order = $database->loadobjectList();
    $order = $order['0'];
    $order->txn_type = 'Order status changed (set:'.$status.') by the administrator';
    $sql = "INSERT INTO `#__rem_orders_details`(fk_order_id,fk_user_id,fk_houses_htitle,status,order_date,fk_house_id,
        txn_type,txn_id,payer_id,payer_status,
        order_calculated_price,payment_details,paypal_paykay)
        VALUES ('".$orderId[0]."',
        '".$order->fk_user_id."',
        '".$order->fk_houses_htitle."',
        '".$order->status."',
        '".$order->order_date."',
        '".$order->fk_house_id."',
        '".$order->txn_type."',
        '".$order->txn_id."',
        '".$order->payer_id."',
        '".$order->payer_status."',
        '".$order->order_calculated_price."','','')";
    $database->setQuery($sql);
    $database->execute();
    mosRedirect("index.php?option=$option&task=orders");
}

function deleteOrder() {

  global $database;

    $orderIds = $_POST['cb'];
    $option = $_POST['option'];
    if( !is_array($orderIds) ) $orderIds[]  = $_POST['order_id'];
    foreach($orderIds as $key=>$orderId){
        $sql = "DELETE FROM #__rem_orders WHERE id = ".(int)$orderId." ";
        $database->setQuery($sql);
        $database->execute();
        $sql = "DELETE FROM #__rem_orders_details WHERE fk_order_id = ".$orderId." ";
        $database->setQuery($sql);
        $database->execute();
    }
    mosRedirect("index.php?option=$option&task=orders");
}

function rent_history($option, $cid) {
  global $database, $my,$mainframe;
  if (!is_array($cid) || count($cid) !== 1) {
    echo "<script> alert('". _REALESTATE_MANAGER_ADMIN_SELECT_ONE_ITEM ."'); window.history.go(-1);</script>\n";
    exit;
  }
  $cid_house = implode(',', $cid);
  $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
          "l.rent_return as rent_return, l.rent_until as rent_until, " .
          "l.user_name as user_name, l.user_email as user_email " .
          "\nFROM #__rem_houses AS a" .
          "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
          "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
          "\nLEFT JOIN #__rem_rent AS l ON l.id = a.fk_rentid" .
          "\nWHERE a.id = $cid_house";
  $database->setQuery($select);
  $house1 = $database->loadObject();
  if ($house1->listing_type != 1) {
    ?>
    <script type = "text/JavaScript" language = "JavaScript">
      alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT ?>");
      window.history.go(-1);
    </script>
    <?php
    exit;
  }
  $cids = implode(',', $cid);
  $cids = getAssociateHouses($cids);
  $houses_assoc[]= $house1;
  if($cids){
    $select = "SELECT a.*, cc.name AS category, l.id as rentid, l.rent_from as rent_from, " .
            "l.rent_return as rent_return, l.rent_until as rent_until, " .
            "l.user_name as user_name, l.user_email as user_email " .
            "\nFROM #__rem_houses AS a" .
            "\nLEFT JOIN #__rem_categories as hc on hc.iditem = a.id" .
            "\nLEFT JOIN #__rem_main_categories AS cc ON cc.id = hc.idcat" .
            "\nLEFT JOIN #__rem_rent AS l ON l.id = a.fk_rentid" .
            "\nWHERE a.id in ($cids)";
    $database->setQuery($select);
    $houses_assoc = $database->loadObjectList();
    //for rent or not
    $count = count($houses_assoc);
    for ($i = 0; $i < $count; $i++) {
      if ($houses_assoc[$i]->listing_type != 1) {
        ?>
        <script type = "text/JavaScript" language = "JavaScript">
          alert("<?php echo _REALESTATE_MANAGER_ADMIN_NOT_FOR_RENT_ASOC ?>");
          window.history.go(-1);
        </script>
        <?php
        exit;
      }
    }
  }
  HTML_realestatemanager::showRentHistory($option, $house1, $houses_assoc, $usermenu, "rent");
}

function users_rent_history($option, $cid){
    global $database, $my,$mainframe;
    $jinput = JFactory::getApplication()->input;
    $owner = $mainframe->getUserStateFromRequest("owner_h{$option}", 'owner_h', '-1'); //add nik
    // print_r($_REQUEST);exit;
    if ($jinput->get('sort_h')) {
        $order = $jinput->get('sort_h');
    } else {
        $order = 'a.htitle';
    }

    $where = '';
    if ($owner !=-1) {
        $where = "\n WHERE l.user_name = ".$database->Quote($owner).
                "\n OR l.fk_userid = ".$database->Quote($owner);
    }

    $allrent = '';
    $select = "SELECT l.rent_from as rent_from, " .
            "a.htitle, a.houseid,l.rent_return as rent_return, l.rent_until as rent_until, " .
            "l.user_name as user_name, l.user_email as user_email " .
            "\n FROM #__rem_rent AS l" .
            "\n LEFT JOIN #__rem_houses AS a ON l.fk_houseid = a.id" .
              $where . " ORDER BY $order";
    $database->setQuery($select);
    $allrent = $database->loadObjectList();

    $userlist[] = mosHTML::makeOption('-1', 'Select User');
    $database->setQuery("SELECT DISTINCT fk_userid AS value, user_name AS text from #__rem_rent ORDER BY user_name");
    $userlist = array_merge($userlist, $database->loadObjectList());
    foreach ($userlist as $value) {
        if(!$value->value)
            $value->value = $value->text;
    }
    $usermenu = mosHTML::selectList($userlist, 'owner_h', 'class="inputbox input-medium" size="1"
        onchange="document.adminForm.submit();"', 'value', 'text', $owner);

    HTML_realestatemanager::showUsersRentHistory($option, $allrent,  $usermenu, $sortmenu);
}
