<?php
/*
Template Name: Category
*/

get_header();
?>

<div class="row category">

  <?php get_template_part('templates/positions-before-content'); ?>

  <div class="<?php if (os_is_active_sidebar("sidebar_right") && os_is_active_sidebar("sidebar_left")) {
    echo ('col-lg-6 col-md-6 col-sm-6 col-xs-12 col-md-6 col-sm-12 col-xs-12');
  } else if (os_is_active_sidebar("sidebar_right") || os_is_active_sidebar("sidebar_left")) {
    echo ('col-lg-9 col-md-9 col-sm-12 col-xs-12');
  } else {
    echo ('col-lg-12 col-md-12 col-sm-12 col-xs-12 col-md-12 col-sm-12 col-xs-12');
  } ?> category-wrapper">

    <?php
    $countcat = get_category(get_query_var('cat'), false);

    print_r("<h2 class='category-name'>" . $countcat->cat_name . '</h2>');
    //echo $countcat->count; 
    
    //print_r($countcat->count);
    $posts_all = $countcat->count;

    //$posts_per_page_cat = 3 ;
    $posts_per_page_cat = $wp_query->query_vars['posts_per_page'];
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    query_posts(
      array(
        'paged' => $paged,
        'posts_per_page' => $posts_per_page_cat
      )
    );

    if (have_posts()) {
      while (have_posts()) {
        the_post(); ?>
        <div class="row">
          <div class=" col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="full_imgs left">
              <a href="<?php the_permalink() ?>"><?php the_post_thumbnail(array(878, 878)); ?></a>
            </div>
            <h3 class="title-post-cat"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
            <p class="desc-post-cat">
              <?php the_excerpt(); ?>
            </p>
            <div class="link">
              <a href="<?php the_permalink() ?>">Detalis > </a>
            </div>
          </div>
        </div>
      <?php }

    } else { ?>
      <div class="row">
        <div class=" col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <h2>
            <?php _e('NEWS NOT FOUND', 'delta'); ?>
          </h2>
        </div>
      </div>
    <?php } ?>

    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 cat-pagination bdp-post-pagination">
      <?php os_pagenavi_category($posts_all, $posts_per_page_cat); ?>
    </div>

  </div>

  <?php get_template_part('templates/positions-after-content'); ?>

</div>

<?php get_footer(); ?>