<?php

//define('FS_METHOD', 'direct');

/**
 * Add support for a custom header imageHeader Text Color.
 */
//require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/inc/settings_template.php';
//require get_template_directory() . '/inc/example.php';
require get_template_directory() . '/inc/template-tags.php';

// show the template file being used in the footer area - user must have admin bar showing and be logged in
// add_action( 'admin_bar_menu', 'show_template' );

// function show_template() {

// global $template;

// echo ":111111111:";
// print_r(  $template );

// }



/**
 * delta only works in WordPress 3.6 or later.
 */
if (version_compare($GLOBALS['wp_version'], '3.6-alpha', '<'))
	require get_template_directory() . '/inc/back-compat.php';

/**
 * Register two widget areas.
 * @return void
 */

function sidebar_left()
{
	if (function_exists('register_sidebar')) {
		register_sidebar(
			array(
				'name' => __('SideBar Left', 'delta'),
				'id' => 'sidebar_left',
				'description' => __('Appears in the left column of the site.', 'delta'),
				'before_widget' => '<div id="%1$s" class="widget_left %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="widget_title_left">',
				'after_title' => '</h3>',
			)
		);
	}
}
add_action('widgets_init', 'sidebar_left');

function sidebar_right()
{
	if (function_exists('register_sidebar')) {
		register_sidebar(
			array(
				'name' => __('SideBar Right', 'delta'),
				'id' => 'sidebar_right',
				'description' => __('Appears in the right column of the site.', 'delta'),
				'before_widget' => '<div id="%1$s" class="widget_right %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h3 class="widget_title_right">',
				'after_title' => '</h3>',
			)
		);
	}
}
add_action('widgets_init', 'sidebar_right');

function top_left()
{
	register_sidebar(
		array(
			'id' => 'top_left',
			'name' => __('Top: Left', 'delta'),
			'description' => __('Position: Top Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_top_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'top_left');

function top_left_center()
{
	register_sidebar(
		array(
			'id' => 'top_left_center',
			'name' => __('Top: Left -> Center', 'delta'),
			'description' => __('Top: Left -> Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_top_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'top_left_center');

function top_right_center()
{
	register_sidebar(
		array(
			'id' => 'top_right_center',
			'name' => __('Top: Right -> Center', 'delta'),
			'description' => __('Top: Right -> Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_top_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'top_right_center');

function top_right()
{
	register_sidebar(
		array(
			'id' => 'top_right',
			'name' => __('Top: Right', 'delta'),
			'description' => __('Position Top Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_top_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'top_right');

function line1_left()
{
	register_sidebar(
		array(
			'id' => 'line1_left',
			'name' => __('Line 1 Left', 'delta'),
			'description' => __('Line 1 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line1_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line1_left');

function line1_left_center()
{
	register_sidebar(
		array(
			'id' => 'line1_left_center',
			'name' => __('Line 1 Left Center', 'delta'),
			'description' => __('Line 1 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line1_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line1_left_center');

function line1_right_center()
{
	register_sidebar(
		array(
			'id' => 'line1_right_center',
			'name' => __('Line 1 Right Center', 'delta'),
			'description' => __('Line 1 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line1_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line1_right_center');

function line1_right()
{
	register_sidebar(
		array(
			'id' => 'line1_right',
			'name' => __('Line 1 Right', 'delta'),
			'description' => __('Line 1 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line1_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line1_right');

function line2_left()
{
	register_sidebar(
		array(
			'id' => 'line2_left',
			'name' => __('Line 2 Left', 'delta'),
			'description' => __('Line 2 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line2_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line2_left');

function line2_left_center()
{
	register_sidebar(
		array(
			'id' => 'line2_left_center',
			'name' => __('Line 2 Left Center', 'delta'),
			'description' => __('Line 2 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line2_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line2_left_center');

function line2_right_center()
{
	register_sidebar(
		array(
			'id' => 'line2_right_center',
			'name' => __('Line 2 Right Center', 'delta'),
			'description' => __('Line 2 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line2_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line2_right_center');

function line2_right()
{
	register_sidebar(
		array(
			'id' => 'line2_right',
			'name' => __('Line 2 Right', 'delta'),
			'description' => __('Line 2 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line2_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line2_right');

function line3_left()
{
	register_sidebar(
		array(
			'id' => 'line3_left',
			'name' => __('Line 3 Left', 'delta'),
			'description' => __('Line 3 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line3_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line3_left');

function line3_left_center()
{
	register_sidebar(
		array(
			'id' => 'line3_left_center',
			'name' => __('Line 3 Left Center', 'delta'),
			'description' => __('Line 3 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line3_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line3_left_center');

function line3_right_center()
{
	register_sidebar(
		array(
			'id' => 'line3_right_center',
			'name' => __('Line 3 Right Center', 'delta'),
			'description' => __('Line 3 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line3_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line3_right_center');

function line3_right()
{
	register_sidebar(
		array(
			'id' => 'line3_right',
			'name' => __('Line 3 Right', 'delta'),
			'description' => __('Line 3 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line3_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line3_right');

function line4_left()
{
	register_sidebar(
		array(
			'id' => 'line4_left',
			'name' => __('Line 4 Left', 'delta'),
			'description' => __('Line 4 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line4_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line4_left');

function line4_left_center()
{
	register_sidebar(
		array(
			'id' => 'line4_left_center',
			'name' => __('Line 4 Left Center', 'delta'),
			'description' => __('Line 4 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line4_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line4_left_center');

function line4_right_center()
{
	register_sidebar(
		array(
			'id' => 'line4_right_center',
			'name' => __('Line 4 Right Center', 'delta'),
			'description' => __('Line 4 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line4_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line4_right_center');

function line4_right()
{
	register_sidebar(
		array(
			'id' => 'line4_right',
			'name' => __('Line 4 Right', 'delta'),
			'description' => __('Line 4 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line4_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line4_right');

function center_left()
{
	register_sidebar(
		array(
			'id' => 'center_left',
			'name' => __('Center Left', 'delta'),
			'description' => __('Center Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_center_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'center_left');

function center_left_position()
{
	register_sidebar(
		array(
			'id' => 'center_left_position',
			'name' => __('Center Left Position', 'delta'),
			'description' => __('Center Left Position', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_center_left_position">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'center_left_position');


function center_right_position()
{
	register_sidebar(
		array(
			'id' => 'center_right_position',
			'name' => __('Center Right Position', 'delta'),
			'description' => __('Center Right Position', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_center_right_position">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'center_right_position');


function center_right()
{
	register_sidebar(
		array(
			'id' => 'center_right',
			'name' => __('Center Right', 'delta'),
			'description' => __('Position Top Four', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_center_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'center_right');

function line5_left()
{
	register_sidebar(
		array(
			'id' => 'line5_left',
			'name' => __('Line 5 Left', 'delta'),
			'description' => __('Line 5 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line5_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line5_left');

function line5_left_center()
{
	register_sidebar(
		array(
			'id' => 'line5_left_center',
			'name' => __('Line 5 Left Center', 'delta'),
			'description' => __('Line 5 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line5_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line5_left_center');

function line5_right_center()
{
	register_sidebar(
		array(
			'id' => 'line5_right_center',
			'name' => __('Line 5 Right Center', 'delta'),
			'description' => __('Line 5 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line5_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line5_right_center');

function line5_right()
{
	register_sidebar(
		array(
			'id' => 'line5_right',
			'name' => __('Line 5 Right', 'delta'),
			'description' => __('Line 5 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line5_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line5_right');

function line6_left()
{
	register_sidebar(
		array(
			'id' => 'line6_left',
			'name' => __('Line 6 Left', 'delta'),
			'description' => __('Line 6 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line6_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line6_left');

function line6_left_center()
{
	register_sidebar(
		array(
			'id' => 'line6_left_center',
			'name' => __('Line 6 Left Center', 'delta'),
			'description' => __('Line 6 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line6_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line6_left_center');

function line6_right_center()
{
	register_sidebar(
		array(
			'id' => 'line6_right_center',
			'name' => __('Line 6 Right Center', 'delta'),
			'description' => __('Line 6 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line6_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line6_right_center');

function line6_right()
{
	register_sidebar(
		array(
			'id' => 'line6_right',
			'name' => __('Line 6 Right', 'delta'),
			'description' => __('Line 6 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line6_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line6_right');

function line7_left()
{
	register_sidebar(
		array(
			'id' => 'line7_left',
			'name' => __('Line 7 Left', 'delta'),
			'description' => __('Line 7 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line7_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line7_left');

function line7_left_center()
{
	register_sidebar(
		array(
			'id' => 'line7_left_center',
			'name' => __('Line 7 Left Center', 'delta'),
			'description' => __('Line 7 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line7_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line7_left_center');

function line7_right_center()
{
	register_sidebar(
		array(
			'id' => 'line7_right_center',
			'name' => __('Line 7 Right Center', 'delta'),
			'description' => __('Line 7 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line7_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line7_right_center');

function line7_right()
{
	register_sidebar(
		array(
			'id' => 'line7_right',
			'name' => __('Line 7 Right', 'delta'),
			'description' => __('Line 7 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line7_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line7_right');

function line8_left()
{
	register_sidebar(
		array(
			'id' => 'line8_left',
			'name' => __('Line 8 Left', 'delta'),
			'description' => __('Line 8 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line8_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line8_left');

function line8_left_center()
{
	register_sidebar(
		array(
			'id' => 'line8_left_center',
			'name' => __('Line 8 Left Center', 'delta'),
			'description' => __('Line 8 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line8_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line8_left_center');

function line8_right_center()
{
	register_sidebar(
		array(
			'id' => 'line8_right_center',
			'name' => __('Line 8 Right Center', 'delta'),
			'description' => __('Line 8 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line8_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line8_right_center');

function line8_right()
{
	register_sidebar(
		array(
			'id' => 'line8_right',
			'name' => __('Line 8 Right', 'delta'),
			'description' => __('Line 8 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line8_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line8_right');

function line9_left()
{
	register_sidebar(
		array(
			'id' => 'line9_left',
			'name' => __('Line 9 Left', 'delta'),
			'description' => __('Line 9 Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line9_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line9_left');

function line9_left_center()
{
	register_sidebar(
		array(
			'id' => 'line9_left_center',
			'name' => __('Line 9 Left Center', 'delta'),
			'description' => __('Line 9 Left Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line9_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line9_left_center');

function line9_right_center()
{
	register_sidebar(
		array(
			'id' => 'line9_right_center',
			'name' => __('Line 9 Right Center', 'delta'),
			'description' => __('Line 9 Right Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line9_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line9_right_center');

function line9_right()
{
	register_sidebar(
		array(
			'id' => 'line9_right',
			'name' => __('Line 9 Right', 'delta'),
			'description' => __('Line 9 Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_line9_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'line9_right');


function bottom_left()
{
	register_sidebar(
		array(
			'id' => 'bottom_left',
			'name' => __('Bottom: Left', 'delta'),
			'description' => __('Bottom: Left', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_bottom_left">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'bottom_left');

function bottom_left_center()
{
	register_sidebar(
		array(
			'id' => 'bottom_left_center',
			'name' => __('Bottom: Left -> Center', 'delta'),
			'description' => __('Bottom: Left -> Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_bottom_left_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'bottom_left_center');

function bottom_right_center()
{
	register_sidebar(
		array(
			'id' => 'bottom_right_center',
			'name' => __('Bottom: Right -> Center', 'delta'),
			'description' => __('Bottom: Right -> Center', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_bottom_right_center">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'bottom_right_center');

function bottom_right()
{
	register_sidebar(
		array(
			'id' => 'bottom_right',
			'name' => __('Bottom: Right', 'delta'),
			'description' => __('Bottom: Right', 'delta'),
			'before_widget' => '<div id="%1$s" class="%2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="my_widget_title_bottom_right">',
			'after_title' => '</h4>'
		)
	);
}
add_action('widgets_init', 'bottom_right');



if (!function_exists('os_theme_entry_meta')) {
	/**
	 * Print HTML with meta information for current post: categories, tags, permalink, author, and date.
	 * Create your own os_theme_entry_meta() to override in a child theme.
	 * @return void
	 */
	function os_theme_entry_meta()
	{
		if (is_sticky() && is_home() && !is_paged())
			echo '<span class="featured-post">' . __('Sticky', 'delta') . '</span>';

		if (!has_post_format('link') && 'post' == get_post_type())
			os_theme_entry_date();

		// Translators: used between list items, there is a space after the comma.
		$categories_list = get_the_category_list(__(', ', 'delta'));
		if ($categories_list) {
			echo '<span class="categories-links">' . $categories_list . '</span>';
		}

		// Translators: used between list items, there is a space after the comma.
		$tag_list = get_the_tag_list('', __(', ', 'delta'));
		if ($tag_list) {
			echo '<span class="tags-links">' . $tag_list . '</span>';
		}

		// Post author
		if ('post' == get_post_type()) {
			printf(
				'<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
				esc_url(get_author_posts_url(get_the_author_meta('ID'))),
				esc_attr(sprintf(__('View all posts by %s', 'delta'), get_the_author())),
				get_the_author()
			);
		}
	}
}


if (!function_exists('os_theme_entry_date')) {
	/**
	 * Print HTML with date information for current post.
	 * Create your own os_theme_entry_date() to override in a child theme.
	 * @param boolean $echo (optional) Whether to echo the date. Default true.
	 * @return string The HTML-formatted post date.
	 */
	function os_theme_entry_date($echo = true)
	{
		if (has_post_format(array('chat', 'status')))
			$format_prefix = _x('%1$s on %2$s', '1: post format name. 2: date', 'delta');
		else
			$format_prefix = '%2$s';

		$date = sprintf(
			'<span class="date"><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a></span>',
			esc_url(get_permalink()),
			esc_attr(sprintf(__('Permalink to %s', 'delta'), the_title_attribute('echo=0'))),
			esc_attr(get_the_date('c')),
			esc_html(sprintf($format_prefix, get_post_format_string(get_post_format()), get_the_date()))
		);

		if ($echo)
			echo $date;

		return $date;
	}
}
;



/**
 * Return the post URL.
 * @uses get_url_in_content() to get the URL in the post meta (if it exists) or
 * the first link found in the post content.
 * Falls back to the post permalink if no URL is found in the post.
 * @return string The Link format URL.
 */

// Add Toolbar Menus
//function custom_toolbar() {global $wp_admin_bar;}

// function tr_post_include($atts) {
//     $thepostid = intval($atts[id]);
//     $output = '';
//     query_posts("p=$thepostid");
//     if (have_posts()) : while (have_posts()) : the_post();
//         $output .= get_the_post_thumbnail($post->ID);
//         $output .= get_the_content($post->ID);
//     endwhile; else:
//         // not out
//     endif;
//     wp_reset_query();
//     return $output;
// }
// add_shortcode("pst_inc", "tr_post_include");
//[pst_inc id="449"]



//Disable Theme Updates wp-3+
remove_action('load-update-core.php', 'wp_update_themes');
//add_filter( 'pre_site_transient_update_themes', create_function( '$a', "return null;" ) );
wp_clear_scheduled_hook('wp_update_themes');



//excluding these categories widget start
// function ext_widget_categories($args){
//     $exclude = "1,8"; 
//     $args["exclude"] = $exclude;
//     return $args;
// }
// add_filter("widget_categories_args","ext_widget_categories");
//excluding these categories widget end

//remove <br> and <p></p>
remove_filter('the_content', 'wpautop');
remove_filter('the_excerpt', 'wpautop');



//css styles connect to the admin
function true_style_backend()
{
	wp_enqueue_style('admin_style', get_stylesheet_directory_uri() . '/css/admin_style.css');
}
add_action('admin_enqueue_scripts', 'true_style_backend');

function true_include_in_font()
{
	wp_enqueue_style('font-awesomes', get_stylesheet_directory_uri() . '/css/font-awesome.css');
}
add_action('admin_enqueue_scripts', 'true_include_in_font');
//css styles connect to the admin

//file js connect to the admin
function true_include_in_admin()
{
	wp_enqueue_script('js_admin', get_stylesheet_directory_uri() . '/js/js_admin.js');
}
add_action('admin_enqueue_scripts', 'true_include_in_admin');
//file js connect to the admin

//Do you want to be able to use a shortcode in your blog’s sidebar instead 
//of your post or page, that help 
add_filter('widget_text', 'do_shortcode');


//Add register Menu
register_nav_menus(
	array(
		'primary' => esc_html__('Primary menu', 'delta'),
		'top_menu' => esc_html__('Top menu', 'delta'),
		'footer_menu' => esc_html__('Footer menu', 'delta'),
	)
);

if (function_exists('register_block_style')) {
	register_block_style(
		'core/quote',
		array(
			'name' => 'blue-quote',
			'label' => __('Blue Quote', 'delta'),
			'is_default' => true,
			'inline_style' => '.wp-block-quote.is-style-blue-quote { color: blue; }',
		)
	);
}


function os_rigistre_scripts()
{
	$os_uri = get_template_directory_uri();

	wp_register_style('font-awesome_style', $os_uri . '/css/font-awesome.css', false);
	wp_enqueue_style('font-awesome_style');

	wp_register_style('bootstrap_style', $os_uri . '/bootstrap/css/bootstrap.css', true);
	wp_enqueue_style('bootstrap_style');

	wp_register_style('ionicons_style', $os_uri . '/css/ionicons.min.css', false);
	wp_enqueue_style('ionicons_style');

	wp_register_style('animate_style', $os_uri . '/css/animate.css', false);
	wp_enqueue_style('animate_style');

	if (isset($_REQUEST['tp']) && $_REQUEST['tp']) {
		wp_register_style('style_positions_preview', $os_uri . '/css/style-positions-preview.css', false);
		wp_enqueue_style('style_positions_preview');
	}

	wp_register_style('style_main', $os_uri . '/style.css', false);
	wp_enqueue_style('style_main');

	wp_register_script('jquery_script', $os_uri . '/js/custom.js', array('jquery') , false);
	wp_enqueue_script('jquery_script');

	wp_register_script('counterup_script', $os_uri . '/js/jquery.counterup.min.js', false);
	wp_enqueue_script('counterup_script');

	wp_register_script('bootstrap_script', $os_uri . '/bootstrap/js/bootstrap.js', false);
	wp_enqueue_script('bootstrap_script');

	wp_register_script('viewportchecker_script', $os_uri . '/js/viewportchecker.js', false);
	wp_enqueue_script('viewportchecker_script');

	wp_register_script('animate_script', $os_uri . '/js/animate.js', false);
	wp_enqueue_script('animate_script');

	wp_register_script('waypoints_script', $os_uri . '/js/waypoints.min.js', false);
	wp_enqueue_script('waypoints_script');

	wp_register_script('jquery_script', $os_uri . '/js/jquery.js', false);
	wp_enqueue_script('jquery_script');

	// Threaded comment reply styles.
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}	

}
add_action('wp_enqueue_scripts', 'os_rigistre_scripts');


function new_excerpt_length($length)
{
	return 13;
}
add_filter('excerpt_length', 'new_excerpt_length');


// function new_excerpt_more($more) {
// 		global $post;
//     return '...<a href="'. get_permalink($post->ID) . '"></a>';
// }
function new_excerpt_more($more)
{
	global $post;
	return get_template_part('templates/single', 'post');
}


add_filter('excerpt_more', 'new_excerpt_more');


//Paginator Post Blog
if (!function_exists('os_pagenavi_blog')) {
	function os_pagenavi_blog($post_type = '', $posts_per_page = 6)
	{

		if ($post_type == "")
			$count_posts = wp_count_posts();
		else
			$count_posts = wp_count_posts($post_type);

		$big = 999999999;
		$args = array(
			'base' => str_replace($big, '%#%', get_pagenum_link($big))
			,
			'format' => ''
			,
			'current' => max(1, get_query_var('paged'))
			,
			'total' => ceil($count_posts->publish / $posts_per_page)

		);
		$result = paginate_links($args);
		$result = str_replace('/page/1"', '"', $result);

		echo $result;
	}
}

//Paginator Post Caregory
if (!function_exists('os_pagenavi_category')) {
	function os_pagenavi_category($posts_all, $posts_page_cat = 1)
	{

		$big = 999999989;
		$args = array(
			'base' => str_replace($big, '%#%', get_pagenum_link($big))
			,
			'format' => ''
			,
			'current' => max(1, get_query_var('paged'))
			,
			'total' => ceil($posts_all / $posts_page_cat)

		);

		$result = paginate_links($args);
		$result = str_replace('/page/1"', '"', $result);

		echo $result;
	}
}
//Add Post Thumbnails
add_theme_support('post-thumbnails');

/*
 * Let WordPress manage the document title.
 * This theme does not use a hard-coded <title> tag in the document head,
 * WordPress will provide it for us.
 */
add_theme_support('title-tag');

add_theme_support('automatic-feed-links');
add_theme_support("wp-block-styles");
add_theme_support("responsive-embeds");
add_theme_support('html5', array('comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script'));

//Add Сustom Background
//  $defaults = array(
// 	'default-color'          => '',
// 	'default-image'          => '',
// 	'wp-head-callback'       => '_custom_background_cb',
// 	'admin-head-callback'    => '',
// 	'admin-preview-callback' => ''
// );
// add_theme_support( 'custom-background', $defaults );

// Add support for full and wide align images.
add_theme_support( 'align-wide' );

// Add support for editor styles.
add_theme_support( 'editor-styles' );

$editor_stylesheet_path = './css/style-editor.css';

// Note, the is_IE global variable is defined by WordPress and is used
// to detect if the current browser is internet explorer.
global $is_IE;
if ( $is_IE ) {
	$editor_stylesheet_path = './css/ie-editor.css';
}

// Enqueue editor styles.
add_editor_style( $editor_stylesheet_path );


//widgets
class Custom_Title_Widget extends WP_Widget
{
	public function __construct()
	{
		parent::__construct(
			'title_block',
			'Title block',
			array(
				'description' => __('widget for title and text', 'delta'),
			)
		);
	}
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = ($new_instance['title']);
		$instance['text'] = ($new_instance['text']);
		return $instance;
	}
	public function form($instance)
	{
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>">Title</label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
				name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />

			<label for="<?php echo $this->get_field_id('text'); ?>">Text</label>
			<input class="widefat" rows="5" cols="20" id="<?php echo $this->get_field_id('text'); ?>"
				name="<?php echo $this->get_field_name('text'); ?>" type="textarea" value="<?php echo $instance['text']; ?>" />
		</p>
		<?php
	}
	public function widget($args, $instance)
	{
		?>

		<div class="title in_up">
			<span class="title_top">
				<?php echo $instance['title']; ?>
			</span>
			<p>
				<?php echo $instance['text']; ?>
			</p>

		</div>
		<?php
	}
}
add_action('widgets_init', function () {
	register_widget('Custom_Title_Widget');
});


//statistic 
class Custom_Statistic_Widget extends WP_Widget
{
	public function __construct()
	{
		parent::__construct(
			'widget_statistic',
			'Widget Statistic',
			array(
				'description' => __('widget Statistic', 'delta'),
			)
		);
		add_action('admin_enqueue_scripts', array(&$this, 'admin_enqueue_scripts'));
	}

	public function admin_enqueue_scripts($hook_suffix)
	{
		if ($hook_suffix != 'widgets.php')
			return;

		wp_enqueue_style('wp-color-picker');
		wp_enqueue_script('wp-color-picker');
	}

	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['color'] = ($new_instance['color']);
		$instance['sizing'] = ($new_instance['sizing']);
		$instance['title'] = ($new_instance['title']);
		$instance['number'] = ($new_instance['number']);
		return $instance;
	}
	public function form($instance)
	{
		?>
		<p>
			<label for="<?php echo $this->get_field_id('color'); ?>">Select color:</label><br />
			<input type="text" id="<?php echo $this->get_field_id('color'); ?>"
				name="<?php echo $this->get_field_name('color'); ?>" value="<?php echo $instance['color']; ?>" /><br />

			<label for="<?php echo $this->get_field_id('sizing'); ?>">Size (px)</label>
			<input class="widefat" id="<?php echo $this->get_field_id('sizing'); ?>"
				name="<?php echo $this->get_field_name('sizing'); ?>" type="text" value="<?php echo $instance['sizing']; ?>" />

			<label for="<?php echo $this->get_field_id('title'); ?>">Title</label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
				name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />

			<label for="<?php echo $this->get_field_id('number'); ?>">Number</label>
			<input class="widefat" id="<?php echo $this->get_field_id('number'); ?>"
				name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $instance['number']; ?>" />
		</p>
		<script type="text/javascript">
			jQuery(document).ready(function (jQuery) {
				jQuery('#<?php echo $this->get_field_id('color'); ?>').wpColorPicker();
			});
		</script>
		<?php
	}
	public function widget($args, $instance)
	{
		?>
		<div class="statistic">
			<span class="counter"
				style="font-size:<?php echo $instance['sizing']; ?>px;color:<?php echo $instance['color']; ?>"><?php echo $instance['number']; ?></span>
			<h4>
				<?php echo $instance['title']; ?>
			</h4>
		</div>

		<?php
	}

}
add_action('widgets_init', function () {
	register_widget('Custom_Statistic_Widget');
});

if (!function_exists('os_show_position_preview')) {
	function os_show_position_preview($position_name, $css_class = "")
	{
		if (isset($_REQUEST['tp']) && $_REQUEST['tp']) {
			echo "<div class='" . $css_class . "'>";
			echo "<div class='show_theme_position'>" . $position_name . "</div>";

			if (function_exists('dynamic_sidebar'))
				dynamic_sidebar($position_name);

			echo "</div>";

			return true;
		}

		return false;
	}
}

//need for cirrect show theme positions
if (!function_exists('os_is_active_sidebar')) {
	function os_is_active_sidebar($position_name)
	{
		if (isset($_REQUEST['tp']) && $_REQUEST['tp']) {
			return true;
		}else{
			return is_active_sidebar($position_name) ;
		}

	}
}


/*-----comment tags-----*/
function mytheme_init()
{
	add_filter('comment_form_defaults', 'mytheme_comments_form_defaults');
}
add_action('after_setup_theme', 'mytheme_init');
function mytheme_comments_form_defaults($default)
{
	unset($default['comment_notes_after']);
	return $default;
}




add_action('wp_enqueue_scripts', 'mytheme_enqueue_scripts');
function mytheme_enqueue_scripts()
{
	wp_enqueue_style('animate', get_stylesheet_directory_uri() . '/css/animate.css');
	wp_enqueue_script('wow', get_stylesheet_directory_uri() . '/js/wow.min.js', array(), '', true);
}

add_action('wp_enqueue_scripts', 'mytheme_wow_init_in_footer');
function mytheme_wow_init_in_footer()
{
	add_action('print_footer_scripts', 'wow_init');
}
function wow_init()
{ ?>
	<script type='text/javascript'>
		new WOW().init();


	</script>

<?php }


