<?php
/**
 * Prevent switching to Twenty Thirteen on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since Twenty Thirteen 1.0
 *
 * @return void
 */
function os_theme_switch_theme() {
	switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'os_theme_upgrade_notice' );
}
add_action( 'after_switch_theme', 'os_theme_switch_theme' );

/**
 * Add message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * Twenty Thirteen on WordPress versions prior to 3.6.
 *
 * @since Twenty Thirteen 1.0
 *
 * @return void
 */
function os_theme_upgrade_notice() {
	$message = sprintf( __( 'delta requires at least WordPress version 3.6. You are running version %s. Please upgrade and try again.', 'delta' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevent the Theme Customizer from being loaded on WordPress versions prior to 3.6.
 *
 * @since Twenty Thirteen 1.0
 *
 * @return void
 */
function os_theme_customize() {
	wp_die( sprintf( __( 'delta requires at least WordPress version 3.6. You are running version %s. Please upgrade and try again.', 'delta' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'os_theme_customize' );

/**
 * Prevent the Theme Preview from being loaded on WordPress versions prior to 3.4.
 *
 * @since Twenty Thirteen 1.0
 *
 * @return void
 */
function os_theme_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( __( 'delta requires at least WordPress version 3.6. You are running version %s. Please upgrade and try again.', 'delta' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'os_theme_preview' );
