<?php
defined('_JEXEC') or die('Restricted access');
/**
* @package OS CCK
* @copyright 2023 OrdaSoft.
* @author Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev (akoevroman@gmail.com), Vladislav Prikhodko(vlados.vp1@gmail.com)
* @link http://ordasoft.com/cck-content-construction-kit-for-joomla.html
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later;
*/

class AdminViewImportExport
{

	static function import($step = 1,&$data = array()) {

		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
	    $app = JFactory::getApplication();
	    $app->JComponentTitle = $html;

		if($step == 1){

		?>
		<h3> Import </h3><hr/>
		<form method="POST" action="index.php?option=com_os_cck&task=import&step=2" class="form-horizontal" enctype="multipart/form-data">
			<div class="control-group">
				<label class="control-label" for="importData">Zip File for import</label>
				<div class="controls">
					<input id="importData" type="file" name="importData" />
				</div>
			</div>
			<div class="control-group">
				<div class="controls">
					<button type="submit" class="btn">Upload</button>
				</div>
			</div>
		</form>
		<?php 
		}elseif($step == 3){

			if(isset($data['error'])) 
				{
					echo JFactory::getApplication()->enqueueMessage($data['error'], 'Error');
				}else{
					echo JFactory::getApplication()->enqueueMessage('Archive loaded successfully', 'Message');
				}
			?>

			&nbsp&nbsp<button type="button" class="btn btn-small btn-success" onclick="location.href = '<?php echo JUri::root();?>administrator/index.php?option=com_os_cck&task=import';" >Back</button>
			<?php
			
		}
	}
	static function import1(&$step = 1,&$data = array()) {
		global $doc, $input;
		?>
		<script>
			var JUri = '<?php echo JUri::root(); ?>';
		</script>
		<?php
		$doc->addScript(JUri::root() . "components/com_os_cck/assets/js/os-import.js");
		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
	    $app = JFactory::getApplication();
	    $app->JComponentTitle = $html;
		$json_enteties = json_encode($data['entities_list']);
		
		$url = $input->get('url', "https://ordasoft.com/joomla-templates/joomla-cck-website-builder?tmpl=component", 'STRING');
		// $url = $input->get('url', "http://localhost/~vlados/import/index.php/cck-all-library-instance", 'STRING');
		// var_dump($input->get('active_tab', ''));
		if($input->get('active', '') != ''){
			$active = true;
		}else{
			$active = false;
		}
		$domain = file_get_contents($url);

		$file_path = JPATH_SITE . '/administrator/components/com_os_cck/exports/iframe_page.html';
		file_put_contents($file_path, $domain);

		$library_url = $input->get('library_url', "https://ordasoft.com/joomla-cck-library?tmpl=component", 'STRING');
		// $url = $input->get('url', "http://localhost/~vlados/import/index.php/cck-all-library-instance", 'STRING');
//                var_dump($library_url);
		$domain = file_get_contents($library_url);

		$file_path = JPATH_SITE . '/administrator/components/com_os_cck/exports/iframe_library_page.html';
		file_put_contents($file_path, $domain);
		

		if($step === 1){
			?>
			<!-- <script>
				let script = document.createElement('script');
				script.type = 'text/javascript';
				script.src = 'https://www.ordasoft.com/xml_update/os_cck_api_p.js';
				script.onload = function(){
					console.log('111111111111111', os_cck_api.data)
					// updateOSPackageStep2(os_cck_api.data);
				};
				document.head.appendChild(script); 
		</script> -->
			<?php
			if($active){
				$options = Array('active'    => 'panel_3_id');
			}else{
				$options = Array('active'    => 'panel_1_id');
			}
			
			echo JHtml::_('bootstrap.startTabSet', 'import-tab', $options);
		    echo JHtml::_('bootstrap.addTab', 'import-tab', 'panel_1_id', JText::_('COM_OS_CCK_IMPORT_TAB_LIBRARY'));
			?>
			<link rel="stylesheet" type="text/css" href="<?php echo JUri::root(); ?>components/com_os_cck/assets/css/os-about.css">
			<div class="import-body">
				<iframe src="<?php echo JUri::root(); ?>administrator/components/com_os_cck/exports/iframe_library_page.html" id="importLibFarame" border="0"></iframe>
			</div>
			<div id="ordasoft-notification">
				<p></p>
			</div>
			<div id="login-modal" class="ordasoft-modal-sm modal hide" aria-hidden="true" style="display: none;">
				<div class="modal-dialog">
					<div class="modal-content">
						<img class="img-preloader notification-in" src="<?php echo JURI::base(); ?>/components/com_os_cck/images/reload.svg" ></img>
						<div class="modal-body">
					
						</div>
					</div>
				</div>
			</div>
			<?php
			echo JHtml::_('bootstrap.endTab');
			echo JHtml::_('bootstrap.addTab', 'import-tab', 'panel_3_id', JText::_('COM_OS_CCK_IMPORT_TAB_TEMPLATE'));
			?>
			<link rel="stylesheet" type="text/css" href="<?php echo JUri::root(); ?>components/com_os_cck/assets/css/os-about.css">
			<div class="import-body">
				<iframe src="<?php echo JUri::root(); ?>administrator/components/com_os_cck/exports/iframe_page.html" id="importFarame" border="0"></iframe>
			</div>
			<div id="ordasoft-notification">
				<p></p>
			</div>
			<div id="login-modal" class="ordasoft-modal-sm modal hide" aria-hidden="true" style="display: none;">
				<div class="modal-dialog">
					<div class="modal-content">
						<img class="img-preloader notification-in" src="<?php echo JURI::base(); ?>/components/com_os_cck/images/reload.svg" ></img>
						<div class="modal-body">
					
						</div>
					</div>
				</div>
			</div>
			<?php
			echo JHtml::_('bootstrap.endTab');
  			echo JHtml::_('bootstrap.addTab', 'import-tab', 'panel_2_id', JText::_('COM_OS_CCK_IMPORT_TAB_CUSTOM'));
		
		echo JHtml::_('bootstrap.endTab');
		echo JHtml::_('bootstrap.addTab', 'import-tab', 'panel_4_id', JText::_('CSV Import/Export')); 
		
		
		echo JHtml::_('bootstrap.endTab');
		echo JHtml::_('bootstrap.endTabSet');
		}elseif($step == 3){
            if(isset($data['error']))
				{
					echo JFactory::getApplication()->enqueueMessage($data['error'], 'Error');
				}else{
					echo JFactory::getApplication()->enqueueMessage('Archive loaded successfully', 'Message');
				}
			?>
<!-- http://localhost/~vlados/joomla42/administrator/index.php?option=com_os_cck&task=import -->
			&nbsp&nbsp<button type="button" class="btn btn-small btn-primary" onclick="history.go(-1);" >Back</button>
			<?php
			
		}
	}
        
	static function showExportResult($InformationArray, $option) {
//            global $doc, $mosConfig_live_site,$app;

		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
		$app = JFactory::getApplication();
		$app->JComponentTitle = $html;
		
		?>
		<form action="index.php" method="post" name="adminForm" id="adminForm">
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			<table border="0" class="adminheading" cellpadding="0" cellspacing="0" width="100%">
				<tr valign="middle">
					<th class="config">Export Result</th>
					<td align="right"></td>
				</tr>
			</table>
			You can download the requested Export under the following URL (right-click to save):  <br />
			<a href="<?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?>"
				target="blank"><?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?></a>
			<br />
		Please note that the files will still be saved on the server and you have to clean them yourself.  <br />
			<input type="hidden" name="option" value="<?php echo $option; ?>" />
			<input type="hidden" name="task" value="cancel" />
		</form>
		<?php
	}

	static function importStepTwo($entity_arr, $tmp_file_path, $existing_entities, $zip_file_name) {
//            global $doc, $mosConfig_live_site,$app;

		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
		$app = JFactory::getApplication();
		$app->JComponentTitle = $html;
		?>
		<form method="post" name="adminForm" id="adminForm" action="index.php?option=com_os_cck&task=import&step=3">
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			<div>Select the operation you want to perform on the detected entities.</div>
			<?php foreach($entity_arr as $eid => $entity_name){ ?>
				<div class="entity-export">
					<div>Entity: "<?php echo $entity_name; ?>"</div>
					<div>
						<select name="entity_export_type[<?php echo $eid; ?>]" eid="<?php echo $eid; ?>" class="entity_export_type">
							<option value="new" selected="selected">Create new Entity</option>
							<option value="merge">Merge with an existing entity</option>
							<option value="skip">Skip</option>
						</select>
					</div>
					<div class="entity_merge" style="display:none" eid="<?php echo $eid; ?>">
						<div><select name="entity_merge[<?php echo $eid; ?>]" >
							<?php foreach($existing_entities as $key => $name){ ?>
								<option value=<?php echo $key; ?>><?php echo $name; ?></option>
							<?php } ?>
						</select>
						</div>
						
						<div>
							<span class="show_advanced_options showed">Show advanced options</span>
							<div class="adv_opt" style="display: none;">
								<div>
									<div>
										Matching Layout Options
									</div>
									<div>
										<select name="layout_opt[<?php echo $eid; ?>]" class="layout_opt">
											<option value="new">Create new layouts</option>
											<option value="merge">Merge</option>
										</select>
									</div>
									<div class="import_layout_info_text">
										All layouts will be created regardless of matches
									</div>
								</div>
								<div>
									<div>
										Matching Fields options
									</div>
									<div>
										<select name="field_opt[<?php echo $eid; ?>]" class="field_opt">
											<option value="new">Create new fields</option>
											<option value="merge">Merge</option>
										</select>
									</div>
									<div class="import_field_info_text">
										All fields will be created regardless of matches
									</div>
								</div>
							</div>
						</div>	
						
							
					</div>
				</div>
			<?php } ?>
			<input type="submit" class="btn btn-success" value="Import"/>
			<input type="hidden" name="tmp_file_path" value="<?php echo $tmp_file_path; ?>"/>
			<input type="hidden" name="zip_file_name" value="<?php echo $zip_file_name; ?>"/>
			
		</form>
		<script>
			window.addEventListener('load', function() { 
				
				function hideShowExtEntity(elem){
					var eid = jQuerOs(elem).attr('eid')
					var val = jQuerOs(elem).val();
					
					if(val == 'new' || val == 'skip'){
						jQuerOs('.entity_merge[eid="'+eid+'"]').hide()
					}else{
						jQuerOs('.entity_merge[eid="'+eid+'"]').show()
						
					}
				}
				
				
				
				jQuerOs('.entity_export_type').on('change', function(){
					
					hideShowExtEntity(this)
				})

				jQuerOs('.show_advanced_options').on('click', function(){
					if(jQuerOs(this).hasClass('showed')){
						jQuerOs(this).removeClass('showed')
						jQuerOs(this).addClass('hided')
						jQuerOs(this).parent().find('.adv_opt').show()
						jQuerOs(this).text('Hide advanced options')
					}else{
						jQuerOs(this).addClass('showed')
						jQuerOs(this).removeClass('hided')
						jQuerOs(this).parent().find('.adv_opt').hide()
						jQuerOs(this).text('Show advanced options')
					}
				})

				jQuerOs('.layout_opt').on('change', function(){
					var val = jQuerOs(this).val()
					// console.log('11111111111', jQuerOs(this).parent())
					if(val == 'new'){
						jQuerOs(this).parents('.adv_opt').find('.import_layout_info_text').text('All layouts will be created regardless of matches')
					}else{
						jQuerOs(this).parents('.adv_opt').find('.import_layout_info_text').text('Layouts that match the existing type and name will not be created. All instances, requests, and reviews that are linked to these layouts will be linked to the existing layouts')
					}
				})

				jQuerOs('.field_opt').on('change', function(){
					var val = jQuerOs(this).val()
					// console.log('11111111111', jQuerOs(this).parent())
					if(val == 'new'){
						jQuerOs(this).parents('.adv_opt').find('.import_field_info_text').text('All fields will be created regardless of matches')
					}else{
						jQuerOs(this).parents('.adv_opt').find('.import_field_info_text').text('Fields that match existing ones by type and name will not be created.')
					}
				})
				
				
			})
		</script>
		<?php
	}

	static function importCsvStepTwo($data, $existing_entities, $tmp_file_path, $separator){

		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
		$app = JFactory::getApplication();
		$app->JComponentTitle = $html;
		// var_dump($data); exit;
		?>
		<form method="post" name="adminForm" id="adminForm" action="index.php?option=com_os_cck&task=csv_import&step=3">
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			<div><?php echo count($data); ?> fields have been detected. Select which entity to apply the data to.</div>
			<div><select name="entity" id="entity">
				
				<?php foreach($existing_entities as $key => $name){ ?>
					<option value=<?php echo $key; ?>><?php echo $name; ?></option>
				<?php } ?>
			</select>
			</div>
						
			<div style="margin-top: 10px;"><input type="submit" class="btn btn-success" value="Next"/></div>
			<input type="hidden" name="tmp_file_path" value="<?php echo $tmp_file_path; ?>"/>
			<input type="hidden" name="separator" value="<?php echo $separator; ?>"/>
			
			
		</form>
		
		<?php
	}

	static function importCsvStepThree($data, $entity, $tmp_file_path){
		global $entityFieldLists;
		$html = "<div class='os_cck_caption' ><img src='./components/com_os_cck/images/os_cck_logo.png' alt ='Import' />" . JText::_('COM_OS_CCK_IMPORT') . "</div>";
		$app = JFactory::getApplication();
		$app->JComponentTitle = $html;

		$separator_opt = array();
		$separator_opt[]  = JHTML::_('select.option','','(None)');
		$separator_opt[]  = JHTML::_('select.option',' ','(Space)');
		$separator_opt[]  = JHTML::_('select.option',',',',');
		$separator_opt[]  = JHTML::_('select.option','.','.');
		// $separator_opt[]  = JHTML::_('select.option','custom','Custom');

		$sequence_number_opt = array();
		for($i = 1; $i < 11; $i++){
			$sequence_number_opt[]  = JHTML::_('select.option',$i,$i);
		}
		
		
		?>
		<form method="post" name="adminForm" id="adminForm" action="index.php?option=com_os_cck&task=csv_import&step=4">
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			<div>Select for which fields the data is intended. (The data from the first line will be shown)</div>
			<div>Import the first row? <input  type="checkbox" name="first_row" value="1"></div>
			<div>
				<div class="line_wrap">
					<div class="field-label">From field</div>
					<div class="fields-select">To field</div>
					<div class="fields-select separator title-separator">Field separator <i title="A character that is placed at the end of the field value when merging fields." class="glyphicon glyphicon-info-sign date_tooltip"></i></div>
					<div class="fields-select separator title-separator">Line merge ordering(Text and Textatea Fields only)</div>
				</div>
				<?php 
				
				foreach($data as $key => $name){ ?>
					<div class="line_wrap">
					<div class="field-label"><?php echo substr($name, 0, 30); ?></div>
					<div class="fields-select">
						<select name="selected_field[<?php echo $key; ?>]">
							<option value="">Select field</option>
							<?php foreach($entityFieldLists[$entity->eid] as $field){ ?>
								<option value="<?php echo $field->db_field_name; ?>"><?php echo $field->field_name; ?> (<?php echo $field->field_type; ?>)</option>
							<?php } ?>
						</select>
					</div>
					<div class="fields-select separator">
						<?php echo JHTML::_('select.genericlist',$separator_opt, 'textfield_separator['.$key.']',
							'size="1" class="inputbox" ', 'value', 'text', '');?>
					</div>
					<div class="fields-select separator">
						<?php echo JHTML::_('select.genericlist',$sequence_number_opt, 'textfield_sequence_number['.$key.']',
							'size="1" class="inputbox" ', 'value', 'text', 1);?>
					</div>
				</div>	


			<?php 
					
				} ?>	
			
			</div>
						
			<div style="margin-top: 10px;"><input type="submit" class="btn btn-success" value="Import"/></div>
			<input type="hidden" name="tmp_file_path" value="<?php echo $tmp_file_path; ?>"/>
			<input type="hidden" name="eid" value="<?php echo $entity->eid; ?>"/>
			
			
		</form>

		<script>
			window.addEventListener('load', function() { 
				jQuerOs('select[name^=selected_field]').on('change', function(){
					// var name = jQuerOs(this).attr('name')
					var value = jQuerOs(this).val();
					// var old_value = jQuerOs(this).attr('old_value')
					// console.log('11111111111111',name)
					if(value.indexOf('text_textfield_') > -1 || value.indexOf('text_textarea_') > -1){
						jQuerOs(this).parents('.line_wrap').find('.separator').css('display', 'inline-block')
						jQuerOs('.title-separator').css('display', 'inline-block')
					}else{
						jQuerOs(this).parents('.line_wrap').find('.separator').css('display', 'none')
						var isset_text = false;
						jQuerOs('[name^=selected_field]').each(function(){
							var temp_val = jQuerOs(this).val();
							if(temp_val.indexOf('text_textfield_') > -1 || temp_val.indexOf('text_textarea_') > -1){
								isset_text = true;
							}
							// console.log('22222222222222', temp_val)	
						})
						if(!isset_text){
							jQuerOs('.title-separator').hide()
						}
					}
					// console.log('22222222222222',value.indexOf('text_textfield_'))
					// jQuerOs(this).attr('old_value', value)

					// jQuerOs('select').each(function(){
					// 	if(jQuerOs(this).attr('name') != name){
					// 		if(value != undefined && value != ''){
					// 			console.log('33333333333333333')
					// 			jQuerOs(this).find('option[value='+value+']').attr('disable', 'disable')
					// 		}
					// 		if(old_value != undefined && old_value != ''){
					// 			jQuerOs(this).find('option[value='+old_value+']').removeAttr('disable')
					// 		}
							// console.log('33333333333333333', jQuerOs(this).find('option[value='+value+']'))
							// jQuerOs(this).find('option').each(function(){
							// 	console.log('33333333333333333', jQuerOs(this).val())
							// })
				// 		}
						
				// 	})
					
				})
			})


		</script>
		
		<?php
	}

	static function exportCsvStepTwo($fieldSelectOpt, $enteties){
		?>
		<form method="post" name="adminForm" id="adminForm" action="index.php?option=com_os_cck&task=csv_export&step=3">
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
			
			<div>
				<?php 
				
				foreach($enteties as $key => $eid){ ?>
					<label class="control-label" for="entity">Check Fields for export</label>
					<div class="controls">
						<?php echo JHTML::_('select.genericlist',$fieldSelectOpt[$eid], 'fields['.$eid.'][]',
							'size="5" class="inputbox" multiple="multiple"', 'value', 'text', '');?>
	<!--					<input id="entity" type="file" name="entity" />-->
					</div>


			<?php 
					
				} ?>	
			
			</div>
						
			<div style="margin-top: 10px;"><input type="submit" class="btn btn-success" value="Export"/></div>
						
			
		</form>
		<?php
	}
	

}
