<?php 

// echo "post<pre><br>";
// print_r($_POST);
// echo "</pre>request<br>";
// CONFIG: Enable debug mode. This means we'll log requests into 'ipn.log' in the same directory.
// Especially useful if you encounter network errors or other intermittent problems with IPN (validation).
// Set this to 0 once you go live or don't require logging.
define("DEBUG", 1);

// Set to 0 once you're ready to go live
define("USE_SANDBOX", 1);


define("LOG_FILE", "./ipn.log");


// Read POST data
// reading posted data directly from $_POST causes serialization
// issues with array data in POST. Reading raw POST data from input stream instead.
$raw_post_data = file_get_contents('php://input');
$raw_post_array = explode('&', $raw_post_data);
$myPost = array();
foreach ($raw_post_array as $keyval) {
    $keyval = explode ('=', $keyval);
    if (count($keyval) == 2)
    $myPost[$keyval[0]] = urldecode($keyval[1]);
}
// read the post from PayPal system and add 'cmd'
$req = 'cmd=_notify-validate';
if(function_exists('get_magic_quotes_gpc')) {
    $get_magic_quotes_exists = true;
}
foreach ($myPost as $key => $value) {
    if($get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) {
        $value = urlencode(stripslashes($value));
    } else {
        $value = urlencode($value);
    }
    $req .= "&$key=$value";
}

// Post IPN data back to PayPal to validate the IPN data is genuine
// Without this step anyone can fake IPN data

if(USE_SANDBOX == true) {
    $paypal_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
} else {
//    $paypal_url = "https://www.paypal.com/cgi-bin/webscr";
}

$ch = curl_init($paypal_url);
    if ($ch == FALSE) {
        return FALSE;
}

curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);

if(DEBUG == true) {
    curl_setopt($ch, CURLOPT_HEADER, 1);
    curl_setopt($ch, CURLINFO_HEADER_OUT, 1);
}

// CONFIG: Optional proxy configuration
//curl_setopt($ch, CURLOPT_PROXY, $proxy);
//curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, 1);

// Set TCP timeout to 30 seconds
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Connection: Close'));

// CONFIG: Please download 'cacert.pem' from "http://curl.haxx.se/docs/caextract.html" and set the directory path
// of the certificate as shown below. Ensure the file is readable by the webserver.
// This is mandatory for some environments.

//$cert = __DIR__ . "./cacert.pem";
//curl_setopt($ch, CURLOPT_CAINFO, $cert);


//проверка на валидность ipn
$res = curl_exec($ch);
if (curl_errno($ch) != 0) {// cURL error
    if(DEBUG == true) {
        echo "FALSE11111";
        error_log(date('[Y-m-d H:i e] '). "Can't connect to PayPal to validate IPN message: " . curl_error($ch) . PHP_EOL, 3, LOG_FILE);
    }
    curl_close($ch);
    echo "Can't connect to PayPal to validate IPN message: " . curl_error($ch);
    if($_POST['test_ipn']) { echo "<br>You used test sandbox-paypal!!<br>";}
    else {exit; }//в тесте пока закоментить

} else {
    // Log the entire HTTP response if debug is switched on.
    if(DEBUG == true) {
        error_log(date('[Y-m-d H:i e] '). "HTTP request of validation request:". curl_getinfo($ch, CURLINFO_HEADER_OUT) ." for IPN payload: $req" . PHP_EOL, 3, LOG_FILE);
        error_log(date('[Y-m-d H:i e] '). "HTTP response of validation request: $res" . PHP_EOL, 3, LOG_FILE);
        // Split response headers and payload
        list($headers, $res) = explode("\r\n\r\n", $res, 2);
    }
    curl_close($ch);
    //echo "HTTP request of validation request";

}

// Inspect IPN validation result and act accordingly

if (strcmp ($res, "VERIFIED") == 0) {
    // check whether the payment_status is Completed
    // check that txn_id has not been previously processed
    // check that receiver_email is your PayPal email
    // check that payment_amount/payment_currency are correct
    // process payment and mark item as paid.

    // assign posted variables to local variables
    //$item_name = $_POST['item_name'];
    //$item_number = $_POST['item_number'];
    //$payment_status = $_POST['payment_status'];
    //$payment_amount = $_POST['mc_gross'];
    //$payment_currency = $_POST['mc_currency'];
    //$txn_id = $_POST['txn_id'];
    //$receiver_email = $_POST['receiver_email'];
    //$payer_email = $_POST['payer_email'];

    if(DEBUG == true) {
        error_log(date('[Y-m-d H:i e] '). "Verified IPN: $req ". PHP_EOL, 3, LOG_FILE);
        //echo "HTTP request of validation request";
    }
} else if (strcmp ($res, "INVALID") == 0) {
    // log for manual investigation
    // Add business logic here which deals with invalid IPN messages
    if(DEBUG == true) {
        error_log(date('[Y-m-d H:i e] '). "Invalid IPN: $req" . PHP_EOL, 3, LOG_FILE);
    }
    echo "Can't connect to PayPal to validate IPN message, exit is not coment";
    if($_POST['test_ipn']) { echo "<br>You used test sandbox-paypal!!<br>";}
    else {exit; }//в тесте пока закоментить
}

/*
Array
(
    [mc_gross] => 50.00
    [protection_eligibility] => Ineligible
    [payer_id] => SMT6EMFU6STTL
    [tax] => 0.00
    [payment_date] => 04:37:08 Apr 17, 2014 PDT
    [payment_status] => Pending
    [charset] => utf-8
    [first_name] => vov
    [mc_fee] => 1.75
    [notify_version] => 3.7
    [custom] => 
    [payer_status] => verified
    [business] => vova@yandex.ru
    [quantity] => 1
    [payer_email] => anton@yandex.ru
    [verify_sign] => A6ppXBkqQsxPETykjPcLEpwAZV2AAAHYZ75xfVvDlzu0Ur2JlXFyb17J
    [txn_id] => 0CK02526TK2033335
    [payment_type] => instant
    [last_name] => vov
    [receiver_email] => vova@yandex.ru
    [payment_fee] => 1.75
    [receiver_id] => JE72C4PQSDLEQ
    [pending_reason] => paymentreview
    [txn_type] => web_accept
    [item_name] => silver
    [mc_currency] => USD
    [item_number] => 
    [residence_country] => US
    [test_ipn] => 1
    [handling_amount] => 0.00
    [transaction_subject] => 
    [payment_gross] => 50.00
    [shipping] => 0.00
    [auth] => AKT.zV2SORAe3CsQPgN3r4C2u7z.VLkEqxla1etCt0bdC2lCR4JkOEVeAN6nd58BczDnlfSQS2.GaoMGPrFhRLQ
)
*/
