<?php
/**
* @version 6.6
* @package OS CCK
* @copyright 2020 OrdaSoft
* @author 2015 Andrey Kvasnevskiy(akbet@mail.ru),Roman Akoev(akoevroman@gmail.com)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @description OrdaSoft Content Construction Kit 
* @license GNU General Public license version 2 or later; 
* @license GNU General Public license version 2 or later;
*/

defined('_JEXEC') or die;

jimport( 'joomla.plugin.plugin' );

class plgSystemCck_system extends JPlugin{
  protected static $modules = array();

  protected static $mods = array();
  
/**
* Constructor.
* @access protected
* @param object $subject The object to observe
* @param array   $config  An array that holds the plugin configuration
* @since 1.0
*/

  public function __construct( &$subject, $config ){
    parent::__construct( $subject, $config );
  }
  
  function onBeforeCompileHead(){
    global $bootstrap;
    
    $doc = JFactory::getDocument();
    $session = JFactory::getSession();
    $app = JFactory::getApplication();
    $input = $app->input;
    $matches  = preg_grep ('/bootstrap.css/i', array_keys($doc->_styleSheets));
    if(!$matches){
      $matches  = preg_grep ('/maxcdn.bootstrapcdn.com\/bootstrap/i', array_keys($doc->_styleSheets));
    }
    $plugin = JPluginHelper::getPlugin('system', 'cck_system');
    $params = new JRegistry;
    $params->loadString($plugin->params);
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site') && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite() && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }
    if ($check) {
//      switch($params->get('bootstrap_version','0')){
//        case "1":
//          //dont include bootstrap
//        break;
//        case "2":
//          //include bootstrap 2
//          $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap2.css");
//          $session->set('bootstrap', '2');
//        break;
//        case "3":
//          //include bootstrap 3
//          $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
//          $session->set('bootstrap', '3');
//        break;
//        default:
//          //try detect version of bootstrap
//          if(isset($doc->_scripts[JURI::root(true).'/media/jui/js/bootstrap.min.js'])){
//            $file = file_get_contents(JPATH_BASE.'/media/jui/js/bootstrap.min.js');
//            $match  = preg_match_all ('/Custom version for Joomla!/i', $file);
//            if($match){
//              $session->set('bootstrap', '2');
//            }else{
//              $session->set('bootstrap', '3');
//              $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
//            }
//          }else if(count($matches)){
//            foreach ($matches as $value) {
//              //need test if we have bootstrap
//              $match  = preg_match_all ('/maxcdn.bootstrapcdn.com\/bootstrap\/2/i', $value);
//              if($match){
//                $session->set('bootstrap', '2');
//              }else{
//                $match  = preg_match_all ('/maxcdn.bootstrapcdn.com\/bootstrap\/3/i', $value);
//                if($match){
//                  $session->set('bootstrap', '3');
//                }
//              }
//            }
//          }else{
//            $session->set('bootstrap', '3');
//            $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
//          }
//      }
    }

    //backend
    if($input->get('option','') == 'com_os_cck' && ($input->get('task','') == 'edit_layout' 
      || ($input->get('task','') == 'new_layout' && $input->get('layout_type','')))){
      $doc = JFactory::getDocument();
      
      // Remove default bootstrap
      
      unset($doc->_scripts[JURI::root(true).'/media/jui/js/bootstrap.min.js']);
      foreach ($doc->_styleSheets as $key => $value) {
        if(substr_count($key,'templates')){
          unset($doc->_styleSheets [$key]);
        }
      }
      
      $doc->addScript(JURI::root() . "/components/com_os_cck/assets/bootstrap/js/bootstrapCCK.js");
      $doc->addScript(JURI::root() . "/components/com_os_cck/assets/js/jquery.minicolors.js");
      $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css");
      $doc->addStyleSheet(JURI::root() . "/components/com_os_cck/assets/css/jquery.minicolors.css");
      //style for codemirror

      $doc->addScript(JURI::root() . "/media/system/js/html5fallback.js");
      JHtml::_('behavior.formvalidator');
      JHtml::_('behavior.keepalive');
      //JHtml::_('behavior.modal');
      // $doc->addScript("https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.6.7/jquery.tinymce.min.js");
      //end
      foreach ($doc->_scripts as $script => $type) {
        if(strpos($script, 'isis/js/template.js')){
          unset($doc->_scripts[$script]);
        }
        if(strpos($script, 'html5fallback.js')){
          unset($doc->_scripts[$script]);
        }
      }
    }
  }

  public function onContentPrepare($context, &$article, &$params){
    $app = JFactory::getApplication();
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site')){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite()){
        $check = true;
      }else{
        $check = false;
      }
    }
    if($check ){
      require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
    }
    $cck_option = 'com_os_cck';
    $db = JFactory::getDBO();
    if(isset($article->introtext)){
      $article_content = $article->introtext;
      $language = JFactory::getLanguage();
      $language->load('com_os_cck');
      //get mask
      preg_match_all('[{CCKLayout\|[a-z]-[0-9]{1,}\|}|'.
              '{CCKLayout\|[a-z]-[0-9]{1,}:CCK[a-zA-Z]{1,10}\|[a-z]-[0-9]{1,}\|}]',$article_content,$matches);
      //var_dump($matches);
      if(isset($matches[0])){
        foreach ($matches[0] as $key => $match) {
          $eiid = '';
          $lid = '';
          $cat_id = '';
          if(strpos($match, '{CCKLayout|') == 0){
            //if instance or category layout
            if(strpos($match, ':')){
              $match = explode(':', $match);
              $lid = str_replace("{CCKLayout|l-", '', $match[0]);
              if(strpos($match[1], 'CCKInstance|i-') === 0){
                $eiid = str_replace("CCKInstance|i-", '', $match[1]);
                $eiid = str_replace("|}", '', $eiid);
              }else{
                $cat_id = str_replace("CCKCategory|c-", '', $match[1]);
                $cat_id = str_replace("|}", '', $cat_id);
              }
            }else{
              //others layout
              $lid = str_replace("{CCKLayout|l-", '', $match);
              $lid = str_replace("|}", '', $lid);
            }
          }
          
          //replase content
          if($lid && $eiid){
            //  var_dump(stripos($article_content, "{CCKLayout|l-".$lid.":CCKInstance|i-".$eiid."|}"));
            //instance layout
            ob_start();
            Instance::showItem($cck_option,$eiid, 0, $lid);
            //var_dump($article_content);
            $article_content = str_replace("{CCKLayout|l-".$lid.":CCKInstance|i-".$eiid."|}", ob_get_contents(), $article_content);
            //echo $article_content;exit;
            ob_end_clean();
            
          }else if($lid && $cat_id){
            //category layout
            ob_start();
            Category::showCategory($cck_option,$cat_id,$lid);
            $article_content = str_replace("{CCKLayout|l-".$lid.":CCKCategory|c-".$cat_id."|}", ob_get_contents(), $article_content);
            ob_end_clean();
          }else{
            //other layout
              
            
            ob_start();
            $layout = new os_cckLayout($db);
            $layout->load($lid);
            switch($layout->type){
              case "add_instance":
              case "request_instance":
                Instance::show_request_layout($cck_option ,$lid,0);
                break;

              case "all_categories":
                Category::listCategories($cck_option, $lid);
                break;

              case "all_instance":
                Instance::show_all_instance($cck_option,$lid);
                break;

              case "search":
                Category::showSearch($cck_option,0,$lid);
                break;
            }
            $article_content = str_replace("{CCKLayout|l-".$lid."|}", ob_get_contents(), $article_content);
            ob_end_clean();
          }

        }
        $article->introtext = $article_content;
      }
      if (version_compare(JVERSION, "4.0.0", "ge")) {
        if ($app->isClient('site')){
          $check = true;
        }else{
          $check = false;
        }
      }else{
        if ($app->isSite()){
          $check = true;
        }else{
          $check = false;
        }
      }
      if($check ){
        require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
      }
  /////copy from plugins/content/loadmodule/loadmodule.php/
      // Expression to search for (positions)
      $regex = '/{loadposition\s(.*?)}/i';
      $style = $this->params->def('style', 'none');

      // Expression to search for(modules)
      $regexmod = '/{loadmodule\s(.*?)}/i';
      $stylemod = $this->params->def('style', 'none');

      // Find all instances of plugin and put in $matches for loadposition
      // $matches[0] is full pattern match, $matches[1] is the position
      preg_match_all($regex, $article->introtext, $matches, PREG_SET_ORDER);

      // No matches, skip this
      
      if ($matches)
      
      {
        foreach ($matches as $match)
        {
          $matcheslist = explode(',', $match[1]);

          // We may not have a module style so fall back to the plugin default.
          if (!array_key_exists(1, $matcheslist))
          {
            $matcheslist[1] = $style;
          }

          $position = trim($matcheslist[0]);
          $style    = trim($matcheslist[1]);

          $output = $this->_load($position, $style);

          // We should replace only first occurrence in order to allow positions with the same name to regenerate their content:
          $article->introtext = preg_replace("|$match[0]|", addcslashes($output, '\\$'), $article->introtext, 1);
          $style = $this->params->def('style', 'none');
        }
      }

      // Find all instances of plugin and put in $matchesmod for loadmodule
      preg_match_all($regexmod, $article->introtext, $matchesmod, PREG_SET_ORDER);
      // If no matches, skip this
      
      if ($matchesmod)
      {
        foreach ($matchesmod as $matchmod)
        {
          $matchesmodlist = explode(',', $matchmod[1]);

          // We may not have a specific module so set to null
          if (!array_key_exists(1, $matchesmodlist))
          {
            $matchesmodlist[1] = null;
          }

          // We may not have a module style so fall back to the plugin default.
          if (!array_key_exists(2, $matchesmodlist))
          {
            $matchesmodlist[2] = $stylemod;
          }

          $module = trim($matchesmodlist[0]);
          $name   = htmlspecialchars_decode(trim($matchesmodlist[1]));
          $stylemod  = trim($matchesmodlist[2]);

          // $match[0] is full pattern match, $match[1] is the module,$match[2] is the title
          $output = $this->_loadmod($module, $name, $stylemod);

          // We should replace only first occurrence in order to allow positions with the same name to regenerate their content:
          $article->introtext = preg_replace("|$matchmod[0]|", addcslashes($output, '\\$'), $article->introtext, 1);
          $stylemod = $this->params->def('style', 'none');
        }
      }

    }
  }

  public function onAfterRender(){
    $cck_option = 'com_os_cck';
    $doc = JFactory::getDocument();
    $app = JFactory::getApplication();
    $input = $app->input;
    $db = JFactory::getDBO();
    $html = $app->getBody();
    $format = $input->get('format', '');
    if($format == 'raw') return;
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site')){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite()){
        $check = true;
      }else{
        $check = false;
      }
    }
    if($check ){
      require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
    }
    $sitemenu = $app->getMenu();
    $menuitems = $sitemenu->getItems('component', 'com_os_cck');
//    var_dump($menuitems);
    $html = $app->getBody();
//    $html = $app->getBody();
      $pos = strpos($html, '</head>');
      $head = substr($html, 0, $pos);
      ini_set('xdebug.var_display_max_depth', -1);
        ini_set('xdebug.var_display_max_children', -1);
        ini_set('xdebug.var_display_max_data', -1);
        
      $body = substr($html, $pos);
      if (version_compare(JVERSION, "4.0.0", "ge")) {
          if($input->get('option','') == 'com_os_cck' && ($input->get('task','') == 'edit_layout' 
          || ($input->get('task','') == 'new_layout' && $input->get('layout_type','')))){
              $styless_arr = ['joomla-media-select.min.css', 'template.min.css', 'joomla-alert.min.css', 'fontawesome-free/fontawesome.min.css'];
              foreach($styless_arr as $style){
                  $pos_style = stripos($head, $style);
                  $pos_start = strripos(substr($head, 0, $pos_style), '<link');
                  $pos_end = stripos($head, '/>', $pos_style);
                  $head = substr_replace($head, '', $pos_start, ($pos_end - $pos_start) + 2);
              }
//              var_dump($head);
              
              
              $app->setBody($head.$body);
          }
          
      }
      
    foreach($menuitems as $menu){
      $params = new JRegistry();
      $params->loadString($menu->getParams());
      // var_dump($menu);
        if($menu->query['view'] == 'hover_layout' || $menu->query['view'] == 'popup' || $params->get('show_type', 1) == 4 || $params->get('show_type', 1) == 5){
          
            $language = JFactory::getLanguage();
            $language->load('com_os_cck');
            
           
            $eiid = false;
            $cat_id = false;
            $lid = $params->get('layout', '');
            $layout = new os_cckLayout($db);
            if($lid != ''){
              $layout->load($lid);
            }
            if($params->get('layout_type', '') == 'instance' || $params->get('layout_type', '') == 'parent_child'){
                $eiid = $params->get('instance', '');
            }
            if($params->get('layout_type', '') == 'category'){
                $cat_id = $params->get('instance', '');
            }
            
            $cat_id = $params->get('category');
//            if (version_compare(JVERSION, "4.0.0", "ge")) {
//                $class = 'nav-item item-'.$menu->id . ' ' . $params->get('menu-anchor_css', '');
//            }else{
//                $class = 'item-'.$menu->id . ' ' . $params->get('menu-anchor_css', '');
//            }
            $link_class = $params->get('menu-anchor_css', '');
            if (version_compare(JVERSION, "4.0.0", "ge")) {
                $class = 'nav-item item-'.$menu->id;
            }else{
                $class = 'item-'.$menu->id;
            }
            
//            var_dump($html);
            $pos_start = stripos($html, '<li class="'.$class); 
            
            
            $pos_finish = stripos($html, '</li>', $pos_start) + 5; 
            
            
            $raplaced_text = substr($html, $pos_start, $pos_finish - $pos_start);
            if($menu->level > 1){
              $add_class = ' nav-child ';
              $arrow = "<span class='arrow'></span>";
            }else{
              $add_class = '';
              $arrow = "";
            }
            $hover_center = ($params->get('hover_position', 'left_cck_hover_pos') == 'center_cck_hover_pos') ? 'cck_hover_side' : '';
            $hover_center = 'cck_hover_side';
            if($menu->query['view'] == 'hover_layout' || $params->get('show_type', 1) == 4){
                if($layout->fk_eid){
                  $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
                }
                // $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
                // $new_html = '<li class="item-'.$menu->id.' ' . $hover_center .'"><a href="#">'.$menu->title.$arrow.'</a><ul class="os_cck_menu_child '.$params->get('hover_position', 'left_cck_hover_pos').' '.$add_class.'">';
                $new_html = '<li class="'.$class.' ' . $hover_center .'"><a class="'.$link_class.'">'.$menu->title.$arrow.'</a><ul class="os_cck_menu_child '.$params->get('hover_position', 'left_cck_hover_pos').' '.$add_class.'">';
            }
            if($menu->query['view'] == 'popup' || $params->get('show_type', 1) == 5){
              if($layout->fk_eid){
                $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
                // $head .= '<script src='.JURI::root() .'components/com_os_cck/assets/js/os-cck-modal.js"></script>'."\n";
              }
                $new_html = '<li class="'.$class.'"><a class="'.$link_class.'" href="#" data-toggle="os_cck_modal" data-target="#os_cck_popup_'.$menu->id.'">'.$menu->title.'</a></li>';
                $new_html .= '<div class="fade os_cck_modal" id="os_cck_popup_'.$menu->id.'"  tabindex="-1" role="dialog" aria-hidden="true">'
                                .'<div class="os_cck_modal-dialog os_cck_modal-dialog-scrollable" role="document">'
                                    .'<div class="os_cck_modal-content">'
                                    .'<div class="os_cck_modal-header">'
                                        .'<button type="button" class="close" data-dismiss="os_cck_modal" aria-label="Close">'
                                            .'<span aria-hidden="true">&times;</span>'
                                        .'</button>'
                                    .'</div>'
                                    .'<div class="os_cck_modal-body">';
            }

            
              include_once JPATH_SITE . '/components/com_os_cck/os_cck.php';
              ob_start();
//              $layout = new os_cckLayout($db);
//              $layout->load($lid);
              switch($params->get('layout_type', '')){
                case "instance":
                    Instance::showItem($cck_option,$eiid, 0, $lid, 0, 10, $menu->id);
                    break;
                case "category":
                    Category::showCategory($cck_option,$cat_id,$lid, 0 ,0, false, $menu->id);
                    break;
                case "add_instance":
                case "request_instance":
                  Instance::show_request_layout($cck_option ,$lid,0);
                  break;

                case "all_categories":
                  Category::listCategories($cck_option, $lid, $menu->id);
                  break;

                case "all_instance":
                  Instance::show_all_instance($cck_option,$lid, 0, $menu->id);
                  break;

                case "search":
                  Category::showSearch($cck_option,0,$lid, $menu->id);
                  break;
              
                case "cart":
                  Instance::showCartLayout($cck_option,$lid, 0, 'default', $menu->id);
                  break;
              
                case "calendar":
                  Instance::show_calendar($cck_option,$lid, '', $menu->id);
                  break;
                case "parent_child":
                  Instance::showParentChildLayout($cck_option,$lid, 0, '', $eiid, $menu->id);
                  break;
              case "user_instances":
                  Instance::showUserInstances($cck_option,$lid, 0, '', $params->get('user', ''), $menu->id);
                  break;
              }
//              $body = str_replace("{CCKLayout|l-".$lid."|}", ob_get_contents(), $body);
              $new_html .= ob_get_contents();
              ob_end_clean();
              if($menu->query['view'] == 'hover_layout' || $params->get('show_type', 1) == 4){
                $new_html .= '</ul></li>';
              }
              if($menu->query['view'] == 'popup' || $params->get('show_type', 1) == 5){
                  $new_html .= '</div>
                                  
                                </div>
                              </div>
                            </div>';
              }
              
              $body = str_replace($raplaced_text, $new_html, $body);
//              $result = $this->addStyle($head, $body);
            }
            
        }
//    }
//    var_dump($params); exit;
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site') == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }
    if ($check && $doc->getType() == 'html') {
      
      if(isset($body)){
        $language = JFactory::getLanguage();
        $language->load('com_os_cck');
        //get mask
        preg_match_all('[{CCKLayout\|[a-z]-[0-9]{1,}\|}|'.
                '{CCKLayout\|[a-z]-[0-9]{1,}:CCK[a-zA-Z]{1,10}\|[a-z]-[0-9]{1,}\|}]',$body,$matches);
        if(isset($matches[0]) && !empty($matches[0])){
          require_once(JPATH_SITE."/components/com_os_cck/os_cck.php");//need change to all cat inst lay|.php
          foreach ($matches[0] as $key => $match) {
            $eiid = '';
            $lid = '';
            $cat_id = '';
            if(strpos($match, '{CCKLayout|') == 0){
              //if instance or category layout
              if(strpos($match, ':')){
                $match = explode(':', $match);
                $lid = str_replace("{CCKLayout|l-", '', $match[0]);
                if(strpos($match[1], 'CCKInstance|i-') === 0){
                  $eiid = str_replace("CCKInstance|i-", '', $match[1]);
                  $eiid = str_replace("|}", '', $eiid);
                }else{
                  $cat_id = str_replace("CCKCategory|c-", '', $match[1]);
                  $cat_id = str_replace("|}", '', $cat_id);
                }
              }else{
                //others layout
                $lid = str_replace("{CCKLayout|l-", '', $match);
                $lid = str_replace("|}", '', $lid);
              }
            }
            //replase content
            // var_dump($lid);
            if($lid && $eiid){
              $layout = new os_cckLayout($db);
                $layout->load($lid);
                $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
              //instance layout
              ob_start();
              Instance::showItem($cck_option,$eiid, 0, $lid);
              $body = str_replace("{CCKLayout|l-".$lid.":CCKInstance|i-".$eiid."|}", ob_get_contents(), $body);
              ob_end_clean();
            }else if($lid && $cat_id){
              $layout = new os_cckLayout($db);
                $layout->load($lid);
                $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
              //category layout
              ob_start();
              Category::showCategory($cck_option,$cat_id,$lid);
              $body = str_replace("{CCKLayout|l-".$lid.":CCKCategory|c-".$cat_id."|}", ob_get_contents(), $body);
              ob_end_clean();
            }else{
              //other layout
              ob_start();
              $layout = new os_cckLayout($db);
              $layout->load($lid);
              $head .= '<link rel="stylesheet" href="'.JURI::root() . 'components/com_os_cck/files/entity_files_'.$layout->fk_eid.'/custom.css">'."\n";
              switch($layout->type){
                case "add_instance":
                case "request_instance":
                  Instance::show_request_layout($cck_option ,$lid,0);
                  break;

                case "all_categories":
                  Category::listCategories($cck_option, $lid);
                  break;

                case "all_instance":
                  Instance::show_all_instance($cck_option,$lid);
                  break;

                case "search":
                  Category::showSearch($cck_option,0,$lid);
                  break;

                case "calendar":
                  Instance::show_calendar($cck_option,$lid);
                  break;  
              }
              $body = str_replace("{CCKLayout|l-".$lid."|}", ob_get_contents(), $body);
              ob_end_clean();
            }

          }//end matches

          
          
        }
        $result = $this->addStyle($head, $body);
        $app->setBody($result['head'].$result['body']);
        
      }
    }
    
  }

  protected function _load($position, $style = 'none')
  {
    self::$modules[$position] = '';
    $document = JFactory::getDocument();
    $renderer = $document->loadRenderer('module');
    $modules  = JModuleHelper::getModules($position);
    $params   = array('style' => $style);
    ob_start();

    foreach ($modules as $module)
    {
      echo $renderer->render($module, $params);
    }

    self::$modules[$position] = ob_get_clean();

    return self::$modules[$position];
  }

  protected function _loadmod($module, $title, $style = 'none')
  {
    self::$mods[$module] = '';
    $document = JFactory::getDocument();
    $renderer = $document->loadRenderer('module');
    $mod      = JModuleHelper::getModule($module, $title);

    // If the module without the mod_ isn't found, try it with mod_.
    // This allows people to enter it either way in the content
    if (!isset($mod))
    {
      $name = 'mod_' . $module;
      $mod  = JModuleHelper::getModule($name, $title);
    }

    $params = array('style' => $style);
    ob_start();

    echo $renderer->render($mod, $params);

    self::$mods[$module] = ob_get_clean();

    return self::$mods[$module];
  }

  public function addStyle($head, $body){
    $session = JFactory::getSession();
    $doc = JFactory::getDocument();
    $app = JFactory::getApplication();

    $matches  = preg_grep ('/bootstrap.css/i', array_keys($doc->_styleSheets));
    if(!$matches){
      $matches  = preg_grep ('/maxcdn.bootstrapcdn.com\/bootstrap/i', array_keys($doc->_styleSheets));
    }
    $plugin = JPluginHelper::getPlugin('system', 'cck_system');
    $params = new JRegistry;
    $params->loadString($plugin->params);
    $link = '';
    if (version_compare(JVERSION, "4.0.0", "ge")) {
      if ($app->isClient('site') && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }else{
      if ($app->isSite() && $doc->getType() == 'html'){
        $check = true;
      }else{
        $check = false;
      }
    }
    if($check){
      switch($params->get('bootstrap_version','0')){
        case "1":
          //dont include bootstrap
        break;
        case "2":
          //include bootstrap 2
          $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap2.css";
          $session->set('bootstrap', '2');
        break;
        case "3":
          //include bootstrap 3
          $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css";
          $session->set('bootstrap', '3');
        break;
        default:
          //try detect version of bootstrap
          if(isset($doc->_scripts[JURI::root(true).'/media/jui/js/bootstrap.min.js'])){
              
            $file = file_get_contents(JPATH_BASE.'/media/jui/js/bootstrap.min.js');
            $match  = preg_match_all ('/Custom version for Joomla!/i', $file);
            if($match){
              $session->set('bootstrap', '2');
            }else{
              $session->set('bootstrap', '3');
              $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css";
            }
          }else if(count($matches)){
            foreach ($matches as $value) {
              //need test if we have bootstrap
              $match  = preg_match_all ('/maxcdn.bootstrapcdn.com\/bootstrap\/2/i', $value);
              if($match){
                $session->set('bootstrap', '2');
              }else{
                $match  = preg_grep ('/maxcdn.bootstrapcdn.com\/bootstrap\/3/i', array_keys($doc->_styleSheets));
                if($match){
                  $session->set('bootstrap', '3');
                }
              }
            }
          }else{
            $session->set('bootstrap', '3');
            $link = JURI::root() . "/components/com_os_cck/assets/bootstrap/css/bootstrap.css";
          }
      }
      if($link)
        $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
    }

    $link = JUri::root() . "components/com_os_cck/assets/css/front_end_style.css";
    
    if(!preg_match_all('|front_end_style.css|',$head,$matches)){
      $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
    }

    $link = JURI::root() . '/components/com_os_cck/assets/css/jquerOs-ui.min.css';
    if(!preg_match_all('|jquerOs-ui.min.css|',$head,$matches)){
      $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
    }
    if(stripos($body, '{|style-cck-swiper|}') !== false){
    
        $link = JURI::root() . '/components/com_os_cck/assets/css/swiper.css';
        if(!preg_match_all('|swiper.css|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-swiper|}', '', $body);
    
        
        }
    if(stripos($body, '{|style-cck-lightbox|}') !== false){
        $link = JURI::root() . '/components/com_os_cck/assets/lightbox/css/lightbox.css';
        if(!preg_match_all('|lightbox.css|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-lightbox|}', '', $body);
    }
    
    if(stripos($body, '{|style-cck-timepicker|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/css/jquery.cck_timepicker.css";
        if(!preg_match_all('|jquery.cck_timepicker.css|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-timepicker|}', '', $body);
    }
    
    if(stripos($body, '{|style-cck-fine-uploader|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/css/fine-uploader-new.css";
        if(!preg_match_all('|jquery.cck_timepicker.js|',$head,$matches)){
          $head .= '<link rel="stylesheet" href="'.$link.'">'."\n";
        }
        $body = str_replace('{|style-cck-fine-uploader|}', '', $body);
    }
    
    

    

    $link = JUri::root() . "/components/com_os_cck/assets/js/jQuerOs-2.2.4.min.js";
    if(!preg_match_all('|jQuerOs-2.2.4.min.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
      $head .= '<script type="text/javascript">jQuerOs=jQuerOs.noConflict();</script>'."\n";
    }

    $link = JUri::root() . "/components/com_os_cck/assets/js/jquerOs-ui.min.js";
    if(!preg_match_all('|jquerOs-ui.min.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    }
    // $link = JUri::root() . "/components/com_os_cck/assets/js/os-cck-modal.js";
    // if(!preg_match_all('|os-cck-modal.js|',$head,$matches)){
    //   $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    // }
    
    
    if(stripos($body, '{|script-cck-timepicker|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/jquery.cck_timepicker.js";
        if(!preg_match_all('|jquery.cck_timepicker.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-timepicker|}', '', $body);
    }
    if(stripos($body, '{|script-cck-swiper|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/swiper-os.js";
        if(!preg_match_all('|swiper-os.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-swiper|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-raty|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/jquery.raty.js";
        if(!preg_match_all('|jquery.raty.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-raty|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-lightbox|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/lightbox/js/lightbox-2.6.min.js";
        if(!preg_match_all('|lightbox-2.6.min.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-lightbox|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-fine-uploader|}') !== false){
        $link = JUri::root() . "/components/com_os_cck/assets/js/fine-uploader.js";
        if(!preg_match_all('|fine-uploader.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-fine-uploader|}', '', $body);
    }
 
    
    if(stripos($body, '{|script-cck-gmap|}') !== false){
        $os_cck_configuration = JComponentHelper::getParams('com_os_cck');
        $key = 'key='.$os_cck_configuration->get("google_map_key",'');
        $link = "//maps.googleapis.com/maps/api/js?".$key;
        if(!preg_match_all('|maps.googleapis.com|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-gmap|}', '', $body);
    }
    
    if(stripos($body, '{|script-cck-markerclusterer|}') !== false){
        
        $link = "//developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js";
        if(!preg_match_all('|markerclusterer.js|',$head,$matches)){
          $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
        }
        $body = str_replace('{|script-cck-markerclusterer|}', '', $body);
    }
    
    
    
    
    $link = "//cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.js";
    if(!preg_match_all('|wow.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    }
    
    $link = JUri::root() . "/components/com_os_cck/assets/js/functions.js";
    if(!preg_match_all('|functions.js|',$head,$matches)){
      $head .= '<script type="text/javascript" src="'.$link.'"></script>'."\n";
    }

    $result = array('head' => $head, 'body' => $body);
    return $result;
  }

}